<?php

# CONSTANTS
define('VINTWOOD_URI', get_template_directory_uri());
define('VINTWOOD_THEME_DIR', get_template_directory());
defined('VINTWOOD_FIRST_COLOR') or define('VINTWOOD_FIRST_COLOR', '#224a49');
defined('VINTWOOD_SECOND_COLOR') or define('VINTWOOD_SECOND_COLOR', '#e53e26');
defined('VINTWOOD_HELPER_COLOR') or define('VINTWOOD_HELPER_COLOR', '#4f7b70');
defined('VINTWOOD_FOOTER_COLOR') or define('VINTWOOD_FOOTER_COLOR', '#281e1a');

# \CONSTANTS

# TEXT DOMAIN
load_theme_textdomain( 'vintwood' , get_template_directory() .'/languages' );
# \TEXT DOMAIN

global $cws_theme_funcs;
global $vintwood_theme_standard;
//Check if plugin active
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
require_once(get_template_directory() . '/core/cws_blog.php');
if (function_exists('cws_core_cwsfw_startFramework') && get_option('vintwood')){
	$cws_theme_funcs = new Vintwood_Funcs();
} else {
	require_once(get_template_directory() . '/core/cws_default.php');
	$vintwood_theme_standard = new Vintwood_Funcs_default();
}

// CWS PB settings
class Vintwood_Funcs {
	protected static $height_to_width_ratio = 0.78;

	protected static $cws_theme_config;

	public static $options;

	protected static $flags = 0;

	public $templates;

	protected static $to_exists = false;

	protected static $blog_thumb_dims = array(
		'large' => array(
			'none' => array(1170, 659),
			'left' => array(870, 490),
			'right' => array(870, 490),
			'both' => array(570, 321),
			),
		'medium' => array(
			'none' => array(570, 321),
			'left' => array(570, 321),
			'right' => array(570, 321),
			'both' => array(570, 321),
			),
		'small' => array(
			'none' => array(370, 208),
			'left' => array(370, 208),
			'right' => array(370, 208),
			'both' => array(370, 208),
			),
		'checkerboard' => array(
			'none' => array(585, 208),
			'left' => array(415, 245),
			'right' => array(415, 245),
			'both' => array(570, 321),
			),
		'1' => array(
			'none' => array(1170, 659),
			'left' => array(870, 490),
			'right' => array(870, 490),
			'both' => array(570, 321),
			),
		'2' => array(
			'none' => array(570, 321),
			'left' => array(420, 237),
			'right' => array(420, 237),
			'both' => array(270, 152),
			),
		'3' => array(
			'none' => array(370, 208),
			'left' => array(270, 152),
			'right' => array(270, 152),
			'both' => array(270, 152),
			),
		'4' => array(
			'none' => array(270, 152),
			'left' => array(270, 152),
			'right' => array(270, 152),
			'both' => array(270, 152),
			),
	);

	const THEME_BEFORE_CE_TITLE = '<div class="ce_title">';
	const THEME_AFTER_CE_TITLE = '</div>';
	const THEME_V_SEP = '<span class="v_sep"></span>';

	public function __construct() {
		$this->header = array(
			'drop_zone_start' => '',
			'drop_zone_end' => '</div><!-- /header_zone -->',
			'before_header' => '',
			'top_bar_box' => '',
			'logo_box' => '',
			'menu_box' => '',
			'header_box' => '',
			'after_header' => '',
		);

		// Check if JS_Composer is active
		if (class_exists('Vc_Manager')){
			$vc_man = Vc_Manager::getInstance();
			$vc_man->disableUpdater(true);
			if (!isset($_COOKIE['vchideactivationmsg_vc11'])) {
				setcookie('vchideactivationmsg_vc11', WPB_VC_VERSION);
			}
			require_once( get_template_directory() . '/vc/cws_vc_config.php' ); // JS_Composer Theme config file
		}

		global $wpdb;
		$to_len = (int)$wpdb->get_var( sprintf('SELECT LENGTH(option_value) FROM '.$wpdb->prefix.'options WHERE option_name = "%s"', 'vintwood') );
		self::$to_exists = $to_len > 0;

		$this->assign_constants();
		$this->init();
		$this->cws_customizer_init();
		
	}
	private function cws_read_options() {
		global $wp_query;
		$pid = get_the_id();

		$theme_options = get_option('vintwood');
		if (empty($theme_options)) return;

		$besides_ooptions = is_search();
		if ($pid && ! $besides_ooptions) {
			$meta = $this->cws_get_post_meta($pid);
			if (!empty($meta)) {
				$meta = $meta[0];
				foreach ($theme_options as $key => $value) {
					if (!isset($meta[$key]) || ( isset($meta[$key]['layout']) && '{' === substr($meta[$key]['layout'], 0, 1) ) ) {
						$meta[$key] = $value;
					}
				}
			} else {
				$meta = $theme_options;
			}
			self::$options = $meta;
		} else {
			self::$options = $theme_options;
		}
		
	}
	private function assign_constants() {
		self::$cws_theme_config = array(
			'js_path' => get_template_directory_uri() .'/js/',
			'scripts' => array(
				'header' => array(
     //Parems ([enable], [path], [dependency], [force activation ENQUEUE])
     //You need to enqueue script in code if it's need, like wp_enqueue_script( 'fancybox' );
					'fancybox' => array(true, 'jquery.fancybox.js', null, false),
					'select2_init' => array(true, 'select2.min.js', null, false),
					'cws_scripts' => array(true, 'scripts.js', null, true),
					'fixed_sidebars' => array($this->cws_get_option('sticky_sidebars') == '1', 'sticky_sidebar.js', null, true),
					'tweenmax' => array(true, 'tweenmax.min.js', null, false),
					'jquery_easing' => array(true, 'jquery.easing.1.3.min.js', null, true),
					'comment-reply' => array(true, null, null, false),
				),
				'footer' => array(
					'owl_carousel' => array(true, 'owl.carousel.js', null, false),
					'pie_chart' => array(true, 'jquery.pie_chart.js', null, false),
					'isotope' => array(true, 'isotope.pkgd.min.js', null, false),
					'odometer' => array(true, 'odometer.js', null, false),
					'wow' => array(true, 'wow.min.js', null, true),
					'parallax' => array(true, 'parallax.js', null, false),
					'vimeo' => array(true, 'jquery.vimeo.api.min.js', null, false),
					'skrollr' => array(true, 'skrollr.min.js', null, false),
     				'modernizr' => array( true, 'modernizr.js', null, false),
					'yt_player_api' => array(true, 'https://www.youtube.com/player_api', null, false),
				),
			),
			'css_path' => get_template_directory_uri() . '/css/',
			'styles' => array(
				'reset' => 'reset.css',
				'layout' => 'layout.css',
				'cws_font_awesome' => get_template_directory_uri() . '/fonts/font-awesome/font-awesome.css',
				'cwsfi' => array('cws_is_cwsfi', null),
				'fancybox' => 'jquery.fancybox.css',
				'select2_init' => 'select2.css',
				'animate' => 'animate.css',
			),
			'actions' => array(
				'cws_is_flaticon' => '',
				'cws_is_cwsfi' => '',
				),
			'gfonts' => array('body', 'menu', 'header', 'helper'), // body-font etc from theme options
			'def_char_number' => 155, // cws_blog_get_chars_count
			'char_counts' => array( // keys are columns
				array(
					'double' => 130,
					'single' => 200,
					'' 		 => 300
				), // empty dummy array
				array(
					'double' => 130,
					'single' => 200,
					'' 		 => 300,
				),
				array(
					'double' => 120,
					'single' => 140,
					''			 => 150,
				),
				array(
					'double' => 60,
					'single' => 80,
					''			 => 90,
				),
				array(
					'double' => 50,
					'single' => 70,
					''			 => 100,
				),
			),
			'strings' => array(
				'home' => esc_html__( 'Home','vintwood'), // text for the 'Home' link
				'category' => esc_html__( 'Category "%s"','vintwood' ), // text for a category page
				'search' => esc_html__( 'Search most for ','vintwood' ).(isset($_GET['s']) ? $_GET['s'] : ""), // text for a search results page
				'taxonomy' => esc_html__( 'Archive by %s "%s"', 'vintwood'),
				'tag'	=> esc_html__( 'Posts Tagged "%s"','vintwood' ), // text for a tag page
				'author' => esc_html__( 'Articles Posted by %s','vintwood' ), // text for an author page
				'404' => esc_html__( 'Error 404','vintwood' ),
				'cart' => esc_html__( 'Cart','vintwood' ),
				'checkout' => esc_html__( 'Checkout','vintwood' ),
			),
			'alt_breadcrumbs' => array('yoast_breadcrumb' => array( '<nav class="bread-crumbs">', '</nav>', false)), // alternative breadcrumbs function and its arguments
			'post-formats' => array( 'aside', 'gallery', 'link', 'image', 'quote', 'status', 'video', 'audio', 'chat' ),
			'nav-menus' => array(
				'header-menu' => esc_html__( 'Navigation Menu','vintwood' ),
				'sidebar-menu' => esc_html__( 'SidePanel Menu', 'vintwood')
			),
			'category_colors' => array('567dbe', 'be5656', 'be9656', '62be56', 'be56b1', '56bebd'),
			'admin_pages' => array('widgets.php', 'edit-tags.php', 'edit.php', 'term.php', 'user-edit.php', 'profile.php', 'nav-menus.php'), // pages cwsfw should be initialized on
		);
	}

	public function get_theme_config($name) {
		if (isset(self::$cws_theme_config[$name])) {
			return self::$cws_theme_config[$name];
		}
		return null;
	}

	public function cws_customizer_init() {
		if ( is_customize_preview() ) {
			if ( isset( $_POST['wp_customize'] ) && $_POST['wp_customize'] == "on" ) {
				if (strlen($_POST['customized']) > 10) {
					global $cwsfw_settings;
					global $cwsfw_mb_settings;
					$post_values = json_decode( stripslashes_deep( $_POST['customized'] ), true );
					if (isset($post_values['cwsfw_settings'])) {
						$new_options = $post_values['cwsfw_settings'];
						$current_options = get_option('vintwood');
						foreach ($new_options as $key => $value) {

							if (is_array($value)){
								if (!isset($current_options[$key])) {
									$current_options[$key] = array();
								}
								$value = array_merge($current_options[$key], $value );
							}
							$cwsfw_settings[$key] = $value;
						}
					}
					if (isset($post_values['cwsfw_mb_settings'])) {
						$cwsfw_mb_settings = $post_values['cwsfw_mb_settings'];
						$this->cws_meta_vars();
					}
				}
			}
		}
	}
	/* Woo Related functions */
	public function cws_getWooMiniCart() {
		ob_start();
		if ( class_exists( 'woocommerce' ) ) {	woocommerce_mini_cart(); }
		return ob_get_clean();
	}

	public function cws_getWooMiniIcon() {
		ob_start();
		if ( class_exists( 'woocommerce' ) ) { ?>
			<a class="woo_icon" href="<?php echo esc_url( wc_get_cart_url() ); ?>" title="<?php esc_html_e( 'View your shopping cart','vintwood' ); ?>"><i class='woo_mini-count flaticon-shopcart-icon'><?php echo ((WC()->cart->cart_contents_count > 0) ?  '<span>' . esc_html( WC()->cart->cart_contents_count ) .'</span>' : '') ?></i></a>
		<?php
		}
		return ob_get_clean();
	}

	/* /Woo Related functions */

	/* Some useful functions */
	public function cws_get_option($name) {
		// !!! this must be in superclass
		$ret = null;
		if (is_customize_preview()) {
			global $cwsfw_settings;
			if (isset($cwsfw_settings[$name])) {
				$ret = $cwsfw_settings[$name];
				if (is_array($ret)) {
				$theme_options = get_option( 'vintwood' );
					if (isset($theme_options[$name])) {
						$to = $theme_options[$name];
							foreach ($ret as $key => $value) {
								$to[$key] = $value;
							}
						$ret = $to;
					}
				}
				return $ret;
			}
		}
		$theme_options = get_option( 'vintwood' );
		$ret = isset($theme_options[$name]) ? $theme_options[$name] : null;
		$ret = stripslashes_deep( $ret );
		return $ret;
	}

	public function cws_get_meta_option($name = '', $check_first_key = false) {
		$value = isset(self::$options[$name]) ? self::$options[$name] : null;
		// This is a sidebars fix for posts created by other themes. 
		if ($name == 'post_sidebars' && empty($value) ){
			$value = array('layout' => '{blog_sidebars}');		
		}	
		// end of fix.		
		while (is_string($value) && '{' === substr($value, 0, 1)) {
			$g_name = substr($value, 1, -1);
			$value = isset(self::$options[$g_name]) ? self::$options[$g_name] : null;
		}		
		if ($check_first_key && is_array($value) && !empty($value)) {
			// it's better to set $check_first_key specifically when there's a chance
			// like in case of sidebars processing
			// check if need to replace value with theme option array
			reset($value);
			$first_key = key($value);
			$val = $value[$first_key];
			if (is_string($val) && '{' === substr($val, 0, 1)) {
				$g_name = substr($val, 1, -1);
				$value = isset(self::$options[$g_name]) ? self::$options[$g_name] : null;
			}
		}
		return $value;
	}

	public function cws_get_post_meta($pid, $key = 'cws_mb_post') {
		$ret = get_post_meta($pid, $key);
		if (!empty($ret[0])) {
			$ret = $ret[0];
		}
		if (is_customize_preview()) {
			global $cwsfw_settings;
			global $cwsfw_mb_settings;
			if(!empty($cwsfw_settings)){
				$ret = array_merge($ret, $cwsfw_settings);
			}
			if (!empty($cwsfw_mb_settings) && !empty($ret)) {
				$ret = array_merge($ret, $cwsfw_mb_settings);
			} else if (!empty($cwsfw_mb_settings) && empty($ret)) {
				$ret = $cwsfw_mb_settings;
			}
		}

		$ret = array($ret);

		return $ret;
	}

	// !!! this must be in superclass
	public function echo_ne($condition, $str, $str2 = '') {	echo !empty($condition) ? $str : $str2; }

	// !!! this must be in superclass
	public function echo_if($condition, $str, $str2 = '') {if($condition){echo sprintf("%s", $str);}else{echo sprintf("%s", $str2);}
	}

	public function print_if($condition, $str, $str2 = '') { return $condition ? $str : $str2; }

	public function print_ne($condition, $str, $str2 = '') { return !empty($condition) ? $str : $str2; }

	public function cws_print_search_form($message_title = '', $message = '') {
		ob_start();
		echo shortcode_exists('cws_sc_msg_box') ? do_shortcode( "[cws_sc_msg_box type='info' title='{$message_title}' text='{$message}'][/cws_sc_msg_box]" ) : (!empty($message_title) ? "<h3>{$message_title}</h3><p>{$message}</p>" : '');
		get_search_form();
		$sc_content = ob_get_clean();
		return $sc_content;
	}

	public function cws_clean_search_form() {
		ob_start();

		get_search_form();

		$output = ob_get_clean();

		return $output;
	}
	/* END of Some useful functions */

	public function cws_render_sidebars($pid) {
		// !!! this must be in superclass
		$out = '';
		$sb = $this->cws_get_sidebars( $pid );

		$layout_class = $sb && $sb['layout_class'] != 'none' ? $sb['layout_class'].'_sidebar' : '';
		$sb1_class = $sb && isset($sb['layout']) && $sb['layout'] == 'right' ? 'sb_right' : 'sb_left';
		$sbl = $sb['sbl'];
		if ( $sbl ){
			$out .= '<div class="container">';
			if ( !empty($sb['sb1']) ) {
				$out .= sprintf('<aside class="%s">', sanitize_html_class($sb1_class));
				ob_start();
				dynamic_sidebar( $sb['sb1'] );
				$out .= ob_get_clean();
				$out .= '</aside>';
			}
			if ( !empty($sb['sb2']) ){
				$out .= '<aside class="sb_right">';
				ob_start();
				dynamic_sidebar( $sb['sb2'] );
				$out .= ob_get_clean();
				$out .= '</aside>';
			}
		}
		return array(
			'layout_class' => $layout_class,
			'sb_class' => $sb1_class,
			'content' => $out,
		);
	}

	private function cws_is_woo() {
		global $woocommerce;
		
		return !empty( $woocommerce ) ? is_woocommerce() || is_product_tag() || is_product_category() || is_account_page() || is_cart() || is_checkout() : false;
	}

	public function cws_get_sidebars( $p_id = null ) { /*!*/
		$page_type = 'page';
		$sb = null;
		$post_type = get_post_type($p_id);
		if ($p_id && !is_home() ) {
			switch ($post_type) {
				case 'page':	
					$page_type = 'page';
					break;
				case 'post':
				case 'attachment':
				case 'cws_portfolio':
				case 'cws_classes':
				case 'cws_staff':
					$page_type = 'post';
					break;
			}
		}
		if (is_front_page()) {
			//Is is_home() works if selected "latest posts" in Reading
			/* default home page have no ID */
			$page_type = 'home';
		}
		if (is_category() && is_archive()) {
			$page_type = 'blog';
		}

		if (!$sb) {
			$sb = $this->cws_get_meta_option("{$page_type}_sidebars", true);
		}

		$ret = $sb;
		$sb_enabled = isset($sb['layout']) && $sb['layout'] != 'none';
		$sbl = 0;
		if ($sb_enabled) {
			$sbl = (int)!empty($sb['sb1']) | ((int)!empty($sb['sb2'])*2);
		}
		$class = '';
		switch ($sbl) {
			case 1:
			case 2:
				$class = 'single';
				break;
			case 3:
				$class = 'double';
				break;
		}

		$ret['layout_class'] = $class;
		$ret['sbl'] = $sbl;
		return $ret;
	}

	public function cws_enqueue_script(){
		$scripts = self::$cws_theme_config['scripts'];
		$js_path = self::$cws_theme_config['js_path'];
		wp_enqueue_script("jquery");
		foreach ($scripts as $type => $v) {
			$is_footer = 'footer' === $type;
			foreach ($v as $alias => $value) {
				list($is_load, $path, $dependencies, $enqueue) = $value;
				if ($path) {
					$path = (0 === strrpos($path, 'http')) ? $path : $js_path . $path;
				}

				if (!is_bool($is_load)) {
					$is_load = do_action();
				}

				if ($is_load) {
					if ($enqueue){
						wp_enqueue_script($alias, $path, $dependencies, '1.0', $is_footer);
					} else {
						wp_register_script($alias, $path, $dependencies, '1.0', $is_footer);
					}
				}
			}
		}

		wp_enqueue_style( '', $this->cws_render_fonts_url() );
	}

	public function cws_enqueue_styles(){
		$styles = self::$cws_theme_config['styles'];
		$css_path = self::$cws_theme_config['css_path'];

		foreach ($styles as $alias => $value) {
			if (is_array($value)) {
				list($is_load, $path) = $value;
				if ($path) {
					$path = (0 === strrpos($path, 'http')) ? $path : $css_path . $path;
				}
			} else {
				$path = (0 === strrpos($value, 'http')) ? $value : $css_path . $value;
				$is_load = true;
			}
			if ($is_load) {
				wp_enqueue_style($alias, $path);
			}
		}
		
		$this->cws_theme_enqueue_styles();	
		$this->cws_add_style();
	}

	private function cws_render_fonts_url() {
		$url = $query_args = '';
		$gfonts = self::$cws_theme_config['gfonts'];
		$fonts_opts = array();
		foreach ($gfonts as $value) {
			$font_value = $this->cws_get_option( $value.'-font' );
			if (isset($font_value)){
				$fonts_opts[] = $font_value;				
			}
		}

		if ( !empty( $fonts_opts ) ) {
			$fonts_urls = array( count( $fonts_opts ) );

			$subsets_arr = array();
			$base_url = "//fonts.googleapis.com/css";

			for ( $i = 0; $i < count( $fonts_opts ); $i++ ){
				$fonts_urls[$i] = $fonts_opts[$i]['font-family'];
				$fonts_urls[$i] .= !empty( $fonts_opts[$i]['font-weight'] ) ? ':' . implode( $fonts_opts[$i]['font-weight'], ',' ) : '';
				if(!empty($fonts_opts[$i]['font-sub'])){
					for ( $j = 0; $j < count( $fonts_opts[$i]['font-sub'] ); $j++ ){
						if ( !in_array( $fonts_opts[$i]['font-sub'][$j], $subsets_arr ) ){
							array_push( $subsets_arr, $fonts_opts[$i]['font-sub'][$j] );
						}
					}
				}
			}

			$query_args = array(
				'family'	=> urlencode( implode( $fonts_urls, '|' ) )
			);
			if ( !empty( $subsets_arr ) ) {
				$query_args['subset']	= urlencode( implode( $subsets_arr, ',' ) );
			}

			$url = add_query_arg( $query_args, $base_url );
		}
		return $url;
	}

	public function cws_wp_title_filter ( $title_text ) {
		$site_name = get_bloginfo( 'name' );
		return is_home() ? $site_name . " | " . get_bloginfo( 'description' ) : $site_name;
	}

	public function cws_custom_nav_menu_item_title ( $title, $item, $args, $depth ) {
		$title = 
			(!empty($item->icon) ? "<i class='".esc_attr($item->icon)."'></i> " : '') . //Custom menu fields (icon)
			$title .
			($item->tag && !empty($item->tag_text)  ? "<span class='tag_label' style='color:".esc_attr($item->tag_font_color).";background-color:".esc_attr($item->tag_bg_color).";'>".esc_html($item->tag_text)."</span> " : ''); //Custom menu fields (label)

		return $title;
	}

	# UPDATE THEME
	public function cws_check_for_update($transient) {
		if (empty($transient->checked)) { return $transient; }

		$theme_pc = trim($this->cws_get_option('_theme_purchase_code'));
		if (empty($theme_pc)) {
			add_action( 'admin_notices', array($this, 'cws_an_purchase_code') );
		}

		$result = wp_remote_get('http://up.cwsthemes.com/products-updater.php?pc=' . $theme_pc . '&tname=' . 'vintwood');
		if (!is_wp_error( $result ) ) {
			if (200 == $result['response']['code'] && 0 != strlen($result['body']) ) {
				$resp = json_decode($result['body'], true);
				$h = isset( $resp['h'] ) ? (float) $resp['h'] : 0;
				$theme = wp_get_theme(get_template());
				if (isset($resp['new_version']) && version_compare( $theme->get('Version'), $resp['new_version'], '<' ) ) {
					$transient->response['vintwood'] = $resp;
				}
				// request and save plugins info
				$opt_res = wp_remote_get('http://up.cwsthemes.com/plugins/update.php', array( 'timeout' => 1));
				update_option('cws_plugin_ver', array('data' => $opt_res['body'], 'lasttime' => date('U')));
				// end of request and save plugins info				
			} else {
				unset($transient->response['vintwood']);
			}
		}
		return $transient;
	}

	// an stands for admin notice
	public function cws_an_purchase_code() {
		$cws_theme = wp_get_theme();
		echo "<div class='update-nag'>" . $cws_theme->get('Name') . esc_html__(' theme notice: Please insert your Item Purchase Code in Theme Options to get the latest theme updates!', 'vintwood') .'</div>';
	}
	# \UPDATE THEME

	private function init() {
		global $wp_filesystem;
		if(empty( $wp_filesystem )) {
			require_once( ABSPATH .'/wp-admin/includes/file.php' );
			WP_Filesystem();
		}

		require_once get_template_directory() . '/core/plugins.php';

		// metaboxes
		require_once(get_template_directory() . '/core/cws_thumb.php');
		include_once(get_template_directory() . '/core/breadcrumbs.php');
		if (function_exists('cws_core_cwsfw_fillMbAttributes')) {
			load_template( trailingslashit( get_template_directory() ) . '/core/scg.php');
			new Vintwood_SCG();
		}
		// require_once(get_template_directory() . '/core/cws-metaboxes.php' );

		set_transient('update_themes', 48*3600);

		add_action('after_setup_theme', array($this, 'cws_after_setup_theme') );
		add_action( 'init', array($this, 'add_excerpts_to_pages') );
		add_filter('nav_menu_item_title', array($this, 'cws_custom_nav_menu_item_title'), 10, 4 ); //Custom menu fields
		add_filter('wp_title', array($this, 'cws_wp_title_filter') );
		add_filter('pre_set_site_transient_update_themes', array($this, 'cws_check_for_update') );
		add_action('admin_enqueue_scripts', array($this, 'cws_admin_init' ) );
		add_filter('the_content', array($this, 'fix_shortcodes_autop') );
		
		add_filter( 'comment_form_defaults', array($this, 'cws_comment_form_defaults') );

		add_action('wp_enqueue_scripts', array($this, 'cws_enqueue_script') );

		add_action('wp_enqueue_scripts', array($this, 'cws_enqueue_styles') );

		add_action('wp_enqueue_scripts', array($this, 'cws_enqueue_theme_stylesheet'), 999 );
		add_action('widgets_init', array($this, 'cws_widgets_init') );
		add_filter('body_class', array($this, 'cws_layout_class') );

		add_action('menu_font_hook', array($this, 'cws_menu_font_action') );
		add_action('header_font_hook', array($this, 'cws_header_font_action') );
		add_action('body_font_hook', array($this, 'cws_body_font_action') );
		add_action('body_helper_hook', array($this, 'cws_body_helper_action') );

		add_action('theme_color_hook', array($this, 'cws_theme_color_action'), 1);
		add_action('theme_color_hook', array($this, 'cws_theme_rgba_color'), 1);

		//Custom block styles
		add_action('theme_color_hook', array($this, 'cws_custom_sticky_menu_styles_action'), 2);
		add_action('theme_color_hook', array($this, 'cws_custom_header_styles_action'), 3);
		add_action('theme_color_hook', array($this, 'cws_custom_top_bar_styles_action'), 4);
		add_action('theme_color_hook', array($this, 'cws_custom_logo_box_styles_action'), 5);
		add_action('theme_color_hook', array($this, 'cws_custom_menu_box_styles_action'), 6);
		// add_action('theme_color_hook', array($this, 'cws_custom_mobile_menu_box_styles_action'), 7);
		add_action('theme_color_hook', array($this, 'cws_custom_page_title_styles_action'), 8);
		add_action('theme_color_hook', array($this, 'cws_custom_side_panel_styles_action'), 9);
		add_action('theme_color_hook', array($this, 'cws_custom_footer_styles_action'), 10);
		add_action('theme_color_hook', array($this, 'cws_custom_boxed_layout_styles_action'), 11);
		add_action('theme_color_hook', array($this, 'cws_custom_styles_action'), 12);			
		//Custom block styles

		add_action('theme_gradient_hook', array($this, 'cws_theme_gradient_action') );
		add_filter('body_class', array($this, 'cws_gradients_body_class') );
		add_filter('cws_dbl_to_sngl_quotes', array($this, 'cws_dbl_to_sngl_quotes') );

		add_action('wp_enqueue_scripts', array($this, 'cws_js_vars_init') );
		add_action('wp', array($this, 'cws_meta_vars') );
		add_action('template_redirect', array($this, 'cws_ajax_redirect') );
		add_filter('excerpt_length', array($this, 'cws_custom_excerpt_length'), 999 );
		add_action('wp_enqueue_scripts', array($this, 'cws_ajaxurl') );
		add_filter('embed_oembed_html', array($this, 'cws_oembed_wrapper'),10,3);
		add_filter('body_class', array($this, 'cws_loading_body_class') );
		add_filter('wp_list_categories', array($this, 'cws_custom_categories_postcount_filter'));

		//Filter all widgets output
		add_filter('dynamic_sidebar_params', array( $this, 'cws_filter_dynamic_sidebar_params' ), 9 );
		add_filter('widget_output', array($this, 'cws_filter_widgets'),10,4);
		//Filter all widgets output

		add_filter('post_gallery', array($this, 'cws_custom_gallery'), 10, 2);
		add_filter('get_search_form', array($this, 'cws_custom_search'));

		// Add custom menu fields to menu
		add_filter('wp_setup_nav_menu_item', array($this, 'cws_add_custom_nav_fields'));
		// Save menu custom fields
		add_filter('wp_update_nav_menu_item', array($this, 'cws_update_custom_nav_fields'), 10, 3);
		// Edit menu walker
		add_filter('wp_edit_nav_menu_walker', array($this, 'cws_edit_walker'), 10, 2);

		// Add inline style
		add_filter('cws_print_single_class', array($this, 'cws_print_single_class'));

		/* tinymce related */
		add_filter( 'tiny_mce_before_init', array($this, 'cws_tiny_mce_before_init') );
		add_filter( 'mce_buttons_2', array($this, 'cws_mce_buttons_2') );
		/* /tinymce related */

		// comments
		add_filter('preprocess_comment', array($this, 'cws_comment_post'), '', 1);
		add_filter( 'comment_form_fields',array( $this, 'cws_move_comment_field_to_bottom' ) );

		// Add Svg support 
		add_filter('upload_mimes', array($this, 'cc_mime_types'));

		// Check if WPML is active
		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		if ( function_exists('wpml_init_language_switcher') ) {
			define('CWS_WPML_ACTIVE', true);
			$GLOBALS['wpml_settings'] = get_option('icl_sitepress_settings');
			global $icl_language_switcher;
		} else {
			define('CWS_WPML_ACTIVE', false);
		}

		define('CWS_WOO_ACTIVE', class_exists( 'woocommerce' ));

		if (CWS_WOO_ACTIVE) {
			add_action( 'wp_ajax_woocommerce_remove_from_cart',array( $this, 'cws_woo_ajax_remove_from_cart' ),1000 );
			add_action( 'wp_ajax_nopriv_woocommerce_remove_from_cart', array( $this, 'cws_woo_ajax_remove_from_cart' ),1000 );

			require_once( get_template_directory() . '/woocommerce/wooinit.php' ); // WooCommerce Shop ini file

			add_filter( 'woocommerce_add_to_cart_fragments', array($this, 'cws_woo_header_add_to_cart_fragment') );
			
			add_filter( 'woocommerce_output_related_products_args', array($this, 'cws_woo_related_products_args') );
			add_action( 'after_setup_theme', array($this, 'cws_theme_woo_setup') );
			add_filter( 'loop_shop_per_page', array( $this, 'loop_products_per_page' ));	
		}
	}

	public function loop_products_per_page() {
		
		return (int) $this->cws_get_option( 'woo_num_products' );
	}

	public function cws_theme_woo_setup(){
			add_theme_support( 'wc-product-gallery-zoom' );
			add_theme_support( 'wc-product-gallery-lightbox' );		
			add_theme_support( 'wc-product-gallery-slider' );		
	}

	public function cc_mime_types($mimes) {
		$mimes['svg'] = 'image/svg+xml';
		return $mimes;
	}

	public function fix_shortcodes_autop($content){
		$array = array (
			'<p>[' => '[',
			']</p>' => ']',
			']<br />' => ']'
		);

		$content = strtr($content, $array);
		return $content;
	}

	public function add_excerpts_to_pages(){
		add_post_type_support( 'page', 'excerpt' );
	}

	public function cws_comment_form_defaults( $defaults ){
		$defaults['title_reply'] = esc_html__('Leave a Comment', 'vintwood' );
		$defaults['title_reply_before'] = '<span id="reply-title" class="h3 comment-reply-title">';
		$defaults['title_reply_after'] = '</span>';
	  return $defaults;
	}

	public function cws_mce_buttons_2( $buttons ) {
		array_unshift( $buttons, 'styleselect' );
		return $buttons;
	}

	public function cws_blog_get_chars_count( $cols = 0, $p_id = null ) {
		$number = self::$cws_theme_config['def_char_number'];
		$p_id = $p_id ? $p_id : get_queried_object_id();
		$sb = $this->cws_get_sidebars( $p_id );
		$sb_layout = isset( $sb['sb_layout_class'] ) ? $sb['sb_layout_class'] : '';
		$anums = self::$cws_theme_config['char_counts'];
		if ( $cols < count($anums) ) {
			$number = $anums[$cols][$sb_layout];
		}
		return $number;
	}

	public function cws_tiny_mce_before_init( $settings ) {
		$font_array = $this->cws_get_option( 'header-font' );

		$settings['theme_advanced_blockformats'] = 'p,h1,h2,h3,h4';

		$style_formats = array(
		array( 'title' => 'Title', 'block' => 'div', 'classes' => 'ce_title' ),
		array( 'title' => 'Divider left', 'block' => 'div', 'classes' => 'ce_title ce_title_div_left' ),
		array( 'title' => 'Divider right', 'block' => 'div', 'classes' => 'ce_title ce_title_div_right' ),
		array( 'title' => 'Font-size', 'items' => array(
			array( 'title' => '50px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em', 'styles' => array( 'font-size' => '50px' , 'line-height' => '1em') ),
			array( 'title' => '40px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em', 'styles' => array( 'font-size' => '40px' , 'line-height' => '1.2em') ),
			array( 'title' => '30px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em', 'styles' => array( 'font-size' => '30px' , 'line-height' => '1.4em') ),
			array( 'title' => '20px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em', 'styles' => array( 'font-size' => '20px' , 'line-height' => '1.6em') ),
			array( 'title' => '16px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em', 'styles' => array( 'font-size' => '16px' , 'line-height' => '1.75em') ),
			array( 'title' => '14px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em', 'styles' => array( 'font-size' => '14px' , 'line-height' => '1.75em') ),
			)
		),
		array( 'title' => 'margin-top', 'items' => array(
			array( 'title' => '0px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em,div', 'styles' => array( 'margin-top' => '0' ) ),
			array( 'title' => '10px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em,div', 'styles' => array( 'margin-top' => '10px' ) ),
			array( 'title' => '15px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em,div', 'styles' => array( 'margin-top' => '15px' ) ),
			array( 'title' => '20px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em,div', 'styles' => array( 'margin-top' => '20px' ) ),
			array( 'title' => '25px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em,div', 'styles' => array( 'margin-top' => '25px' ) ),
			array( 'title' => '30px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em,div', 'styles' => array( 'margin-top' => '30px' ) ),
			array( 'title' => '40px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em,div', 'styles' => array( 'margin-top' => '40px' ) ),
			array( 'title' => '50px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em,div', 'styles' => array( 'margin-top' => '50px' ) ),
			array( 'title' => '60px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em,div', 'styles' => array( 'margin-top' => '60px' ) ),
			)
		),
		array( 'title' => 'margin-bottom', 'items' => array(
			array( 'title' => '0px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em,div', 'styles' => array( 'margin-bottom' => '0px' ) ),
			array( 'title' => '10px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em,div', 'styles' => array( 'margin-bottom' => '10px' ) ),
			array( 'title' => '15px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em,div', 'styles' => array( 'margin-bottom' => '15px' ) ),
			array( 'title' => '20px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em,div', 'styles' => array( 'margin-bottom' => '20px' ) ),
			array( 'title' => '25px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em,div', 'styles' => array( 'margin-bottom' => '25px' ) ),
			array( 'title' => '30px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em,div', 'styles' => array( 'margin-bottom' => '30px' ) ),
			array( 'title' => '40px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em,div', 'styles' => array( 'margin-bottom' => '40px' ) ),
			array( 'title' => '50px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em,div', 'styles' => array( 'margin-bottom' => '50px' ) ),
			array( 'title' => '60px', 'selector' => 'h1,h2,h3,h4,h5,h6,p,span,i,b,strong,em,div', 'styles' => array( 'margin-bottom' => '60px' ) ),
			)
		),
		array( 'title' => 'Underline title', 'items' => array(
			array( 'title' => 'gray line', 'selector' => '.ce_title:not(.und-title.white):not(.und-title.themecolor)', 'classes' => 'und-title gray' ),
			array( 'title' => 'white line', 'selector' => '.ce_title:not(.und-title.themecolor):not(.und-title.gray)', 'classes' => 'und-title white' ),
			array( 'title' => 'theme color line', 'selector' => '.ce_title:not(.und-title.white):not(.und-title.gray)', 'classes' => 'und-title themecolor' ),
			)
		),	
		array( 'title' => 'SVG Divider', 'selector' => 'h1,h2,h3,h4,h5,h6', 'classes' => 'div_title' ),
		array( 'title' => 'Floated Blockqoute', 'selector' => 'blockquote', 'classes' => 'floated' ),
		array( 'title' => 'Bordered image', 'selector' => 'p', 'classes' => 'add_border' ),
		array( 'title' => 'Shifted image', 'selector' => 'img', 'classes' => 'shifted' ),
		array( 'title' => 'Animation On Hover', 'items' => array(
			array( 'title' => 'To top', 'selector' => 'a,img', 'classes' => 'shadow_image top' ),
			array( 'title' => 'To bottom', 'selector' => 'a,img', 'classes' => 'shadow_image bottom' ),
			)
		),
		array( 'title' => 'Border Radius Image', 'items' => array(
			array( 'title' => '1px', 'selector' => 'img', 'styles' => array( 'border-radius' => '1px' )),
			array( 'title' => '2px', 'selector' => 'img', 'styles' => array( 'border-radius' => '2px' )),
			array( 'title' => '3px', 'selector' => 'img', 'styles' => array( 'border-radius' => '3px' )),
			array( 'title' => '4px', 'selector' => 'img', 'styles' => array( 'border-radius' => '4px' )),
			array( 'title' => '5px', 'selector' => 'img', 'styles' => array( 'border-radius' => '5px' )),
			array( 'title' => '6px', 'selector' => 'img', 'styles' => array( 'border-radius' => '6px' )),
			array( 'title' => '7px', 'selector' => 'img', 'styles' => array( 'border-radius' => '7px' )),
			array( 'title' => '8px', 'selector' => 'img', 'styles' => array( 'border-radius' => '8px' )),
			array( 'title' => '9px', 'selector' => 'img', 'styles' => array( 'border-radius' => '9px' )),
			array( 'title' => '10px', 'selector' => 'img', 'styles' => array( 'border-radius' => '10px' )),
			array( 'title' => '11px', 'selector' => 'img', 'styles' => array( 'border-radius' => '11px' )),
			array( 'title' => '12px', 'selector' => 'img', 'styles' => array( 'border-radius' => '12px' )),
			array( 'title' => '13px', 'selector' => 'img', 'styles' => array( 'border-radius' => '13px' )),
			array( 'title' => '14px', 'selector' => 'img', 'styles' => array( 'border-radius' => '14px' )),
			array( 'title' => '15px', 'selector' => 'img', 'styles' => array( 'border-radius' => '15px' )),
			array( 'title' => '16px', 'selector' => 'img', 'styles' => array( 'border-radius' => '16px' )),
			array( 'title' => '17px', 'selector' => 'img', 'styles' => array( 'border-radius' => '17px' )),
			array( 'title' => '18px', 'selector' => 'img', 'styles' => array( 'border-radius' => '18px' )),
			array( 'title' => '19px', 'selector' => 'img', 'styles' => array( 'border-radius' => '19px' )),
			array( 'title' => '20px', 'selector' => 'img', 'styles' => array( 'border-radius' => '20px' )),
			
		))
		);
		// Before 3.1 you needed a special trick to send this array to the configuration.
		// See this post history for previous versions.
		$settings['style_formats'] = str_replace( '"', "'", json_encode( $style_formats ) );

		return $settings;
	}

	public function cws_print_single_class($class) {
		$class .= ' page_content';
		$footer = $this->cws_get_meta_option('footer');
		$wide_featured = $this->cws_get_meta_option('wide_featured');

		$class .= isset($footer['fixed']) && $footer['fixed'] == '1' ? ' fixed' : '';
		$class .= isset($wide_featured) && $wide_featured == '1' ? ' wide_featured' : '';
		return $class;
	}

	public function cws_print_metas() {
		$this->echo_if( has_category(), '<div class="post_categories">' . get_the_category_list ( $this::THEME_V_SEP ) . '</div>');
		$this->echo_if( has_tag(), '<div class="post_tags">' . get_the_tag_list (null, $this::THEME_V_SEP, null ) . '</div>');
	}

	public function cws_get_page_meta_var ( $keys ) {
		$p_meta = array();
		if ( isset( $GLOBALS['vintwood' . '_page_meta'] ) && !empty($keys) ) {
			$p_meta = $GLOBALS['vintwood' . '_page_meta'];
			if ( is_string( $keys ) ) {
				if ( isset( $p_meta[$keys] ) ) {
					return $p_meta[$keys];
				}
			} else if ( is_array( $keys ) ) {
				for ( $i=0; $i < count($keys); $i++ ) {
					if ( isset( $p_meta[$keys[$i]] ) ) {
						if ( $i < count($keys) - 1 ) {
							if ( is_array( $p_meta[$keys[$i]] ) ) {
								$p_meta = $p_meta[$keys[$i]];
							}	else {
								return false;
							}
						}	else {
							return $p_meta[$keys[$i]];
						}
					}	else {
						return false;
					}
				}
			}
		}
		return false;
	}

	public function cws_set_page_meta_var($keys, $value = '') {
		$p_meta = array();
		if (isset($GLOBALS['vintwood' . '_page_meta']) && !empty($keys) ) {
			$p_meta = &$GLOBALS['vintwood' . '_page_meta'];

			if ( is_string( $keys ) ) {
				if ( isset($p_meta[$keys]) ) {
					$p_meta[$keys] = $value;
					return true;
				}
			} else if ( is_array( $keys ) && !empty( $keys ) ) {
				for ( $i=0; $i < count($keys); $i++ ) {
					if ( isset( $p_meta[$keys[$i]] ) ) {
						if ( $i < count($keys) - 1 ) {
							if ( is_array( $p_meta[$keys[$i]] ) ) {
								$p_meta = &$p_meta[$keys[$i]];
							} else {
								return false;
							}
						}	else {
							$p_meta[$keys[$i]] = $value;
							return true;
						}
					}	else {
						return false;
					}
				}
			}
		}
		return false;
	}

	/* HEDER LOADER */
	public function cws_page_loader() {
		$cws_enable_page_loader = $this->cws_get_meta_option( 'show_loader' );
		if (!empty($cws_enable_page_loader)) {

			$loader_logo = $this->cws_get_option( 'loader_logo' );
			$logo_get = wp_get_attachment_image_src($loader_logo['id'], 'full');
			$loader_logo['height'] = $logo_get[2];
			$loader_logo['width'] = $logo_get[1];

			$logo_is_high_dpi = (!empty($loader_logo['logo_is_high_dpi']) ? $loader_logo['logo_is_high_dpi'] : '');

			if ( isset( $loader_logo['src'] ) ) {
				$logo_src = '';
				$logo_class = ' class="loader_logo"';
				$main_logo_height = '';

				if ( isset( $loader_logo['src'] ) && ( ! empty( $loader_logo['src'] ) ) ) {

					if ( $logo_is_high_dpi ) {
						$thumb_obj = cws_thumb( $loader_logo['id'], array( 'width' => 120, 'crop' => false ) );
					} else {
						$thumb_obj = cws_thumb( $loader_logo['id'], array( 'width' => 60, 'height' => 60, 'crop' => false ) );
					}

					$thumb_path_hdpi = !empty($thumb_obj[3]) ? " src='". esc_url( $thumb_obj[0] ) ."' data-at2x='" . esc_attr( $thumb_obj[3] ) ."'" : " src='". esc_url( $thumb_obj[0] ) . "' data-no-retina";
					$logo_src = $thumb_path_hdpi;

				}
			}
			return '<div id="cws_page_loader_container" class="cws_loader_container">
						<div id="cws_page_loader" class="cws_loader">
							<div class="inner"></div>
							'.( (!empty($logo_src)) ? "<img $logo_class $logo_src alt='' />" : '').'
						</div>
			</div>';
		}
	}
	/* END HEDER LOADER */

	/* THE HEADER META */
	public function cws_header_meta() {
		?>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
		<meta name="format-detection" content="telephone=no">
		<link rel="profile" href="http://gmpg.org/xfn/11">
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
		<?php
			$this->cws_read_options();
	}
	/* END THE HEADER META */

	/* THEME HEADER */
	public function cws_page_header() {
		$pid = get_the_id();

		$font_color_style = $animate_title = '';
		$header_box_use_blur = 0;
		$header_box_blur_intensity = $header_box_parallaxify = $bg_header_scalar_x = $bg_header_scalar_y = $bg_header_limit_x = $bg_header_limit_y = $header_box_pattern_image = $header_box_use_blur_style = '';
		$header_box_overlay = $header_box_overlay_gradient = $parallax_opt_arr = array();
		$header_box_parallaxify_atts = $header_box_parallaxify_layer_atts = '';

		$header_box_animate_options = array();
		$header_box_font_color = '';

		//Get metaboxes from page
		$sticky_menu = $this->cws_get_meta_option( 'sticky_menu' );
		extract($sticky_menu, EXTR_PREFIX_ALL, 'sticky_menu');

		$header_box = $this->cws_get_meta_option( 'header_box' );
		extract($header_box, EXTR_PREFIX_ALL, 'header_box');
		$title_height = isset($this->cws_get_meta_option('header_box')['title_height']) ? $this->cws_get_meta_option('header_box')['title_height'] : '390';
		$custom_header_bg_color = false;
		$post_type = get_post_type();

		$img_section_atts = $img_section_styles = '';
		$img_section_atts .= ' class="header_bg_img"';

		$menu_box_header_outside_slider = $this->cws_get_meta_option('menu_box')['header_outside_slider'] == '1' && !is_single() && !is_archive() || $this->cws_get_option( 'shop-slider-type' ) != 'none' && $this->cws_is_woo();
		
		$show_header_shop_slider = $this->cws_get_option( 'shop-slider-type' ) != 'none' && $this->cws_is_woo() && is_shop();
		if($show_header_shop_slider){
			if($this->cws_get_option('woo_header_covers_slider')){
				$menu_box_header_outside_slider = true;
			}else{
				$menu_box_header_outside_slider = false;
			}
		}

		$show_page_title = true;
		/***** Boxed Layout *****/

		$boxed_enable = (isset($this->cws_get_meta_option('boxed')['layout']) && $this->cws_get_meta_option('boxed')['layout'] == '1') || (isset($this->cws_get_meta_option('boxed')['header_layout']) && $this->cws_get_meta_option('boxed')['header_layout'] == '1');
		if ($boxed_enable) {
			echo '<div class="page_boxed">';
		}
		
		/***** \Boxed Layout *****/

		$top_panel_content = $this->cws_render_top_bar($pid);

		$this->header['top_bar_box'] = $top_panel_content;

		$header_box_customize = isset($header_box_customize) && $header_box_customize == '1';
		$header_box_no_title = isset($header_box_no_title) ? $header_box_no_title : '';
		$woo_customize_title = $this->cws_get_option('woo_customize_title');

		if ($header_box_customize) {
			$is_single_or_archive = is_single() || is_archive();
			$is_show_on_post = is_single() && $this->cws_get_option('header_box')['show_on_posts'] == '1' && !$this->cws_is_woo(); //Call from ThemeOptions
			$is_show_on_archive = is_archive() && $this->cws_get_option('header_box')['show_on_archives'] == '1' && !$this->cws_is_woo(); //Call from ThemeOptions

			if($is_single_or_archive){
				if($this->cws_is_woo()){
					$is_woo_breadcrumbs = false;
				}
				else{
					$is_woo_breadcrumbs = true;
				}
				
			}else{
				$is_woo_breadcrumbs = true;
			}

			if(!$is_show_on_archive && get_post_type() == 'tribe_events'){
				$is_woo_breadcrumbs = false;
			}
			if ($is_show_on_post && get_post_type() == 'tribe_events') {
				$is_show_on_post = false;
			}

			$is_customized_title = !$is_single_or_archive ^ $is_show_on_post ^ $is_show_on_archive ^ !$is_woo_breadcrumbs;
		}

		if($this->cws_is_woo() && !empty($woo_customize_title)){
			$woo_header_font_color = $this->cws_get_option('woo_header_font_color');
			$header_box_font_color = !empty($woo_header_font_color) ? $woo_header_font_color : $header_box_font_color;
		}

		$page_title_content = $this->cws_build_page_title($header_box_no_title,$header_box_font_color, $header_box_animate_options);

		ob_start();
		echo "<!-- header_box -->";

			if ($header_box_customize) {
				$header_box_parallaxify = (isset($header_box_effect) && $header_box_effect === 'parallaxify');
				$header_box_use_blur_style = "-webkit-filter:blur(".esc_attr($header_box_blur_intensity)."px);-moz-filter:blur(".esc_attr($header_box_blur_intensity)."px);-o-filter: blur(".esc_attr($header_box_blur_intensity)."px);-ms-filter:blur(".esc_attr($header_box_blur_intensity)."px);filter: blur(".esc_attr($header_box_blur_intensity)."px);";

				extract($header_box_overlay, EXTR_PREFIX_ALL, 'header_box_overlay');
				if (!empty($header_box_overlay) && $header_box_overlay_type != 'none'){
					$header_box_overlay_opacity = (int) $header_box_overlay_opacity / 100;
				}

				if (isset($header_box_parallax_options)){
					$this->cws_print_parallaxify_atts($header_box_parallax_options, $header_box_parallaxify_atts, $header_box_parallaxify_layer_atts);					
				}
			}

			$bg_header = $bg_header_feature = false;
			$bg_header_url = '';

			if (!empty( $header_box_background_image['src'] )){
				$bg_header_url = $header_box_background_image['src'];
				$bg_header = true;
			}

			if (!empty($post_meta['post_header_box_image'])){
				$bg_header_url = $post_meta['post_header_box_image']['src'];
				$bg_header = true;
			}

			$bg_header_html = '';

			if (
				(
					((is_archive() && $header_box_customize) ? $is_show_on_archive : true ) &&
					((is_single() && (get_post_type() == 'post' && $header_box_customize)) ? $is_show_on_post : true ) &&
					($header_box_customize || isset($meta_title_area) || isset( $bg_header_url ) ) &&
					!(get_post_type() == 'cws_staff')
					// Uncomment this line if you need to exclude portfolio post
				)
			|| ($this->cws_is_woo())
			|| (is_single() && $header_box_customize && $is_show_on_post)
				){

				if ( ($header_box_customize && $header_box_overlay_type != 'none' ) )
				{
					if ( ( $header_box_overlay_type == 'color' && !empty( $header_box_overlay_color ) ) || ( $header_box_overlay_type == 'gradient' ) )
					{
						$bg_header = true;
						$bg_header_html .= "<div class='bg_layer'></div>";
					}
				}
			}

				if ( !empty( $bg_header_url ) && !is_front_page() ) {
					$header_bg_atts = '';

					echo "<div class='header_box bg_page_header with_image".(isset($header_box_border['line']) && $header_box_border['line'] == '1' ? ' border_line' : '')."'".$header_bg_atts." ".(isset($title_height) ? "style='min-height:".$title_height."px;'" : '').">";
						if ($page_title_content) {
							echo sprintf("%s", $page_title_content);
						}

						echo sprintf("%s", $bg_header_html);

						if(isset($bg_header_url) && !empty($bg_header_url)){
							echo "<div class='header_img_wrap'>";
								echo "<img src='". esc_url($bg_header_url) ."' alt='header_image' />";
							echo "</div>";
						}

					echo '</div>';
				}

				if ( (empty( $bg_header_url ) && ($header_box_customize )) || (empty( $bg_header_url ) && !empty($page_title_content) ) ) {
					echo "<div class='header_box bg_page_header".(isset($header_box_border['line']) && $header_box_border['line'] == '1' ? ' border_line' : '')."'".(!empty($font_color) ? ' style="color:'.esc_attr($font_color).';"' : '').(!empty($custom_header_bg_spacings["top"]) ? " data-top='".esc_attr($custom_header_bg_spacings['top'])."'" : '').(!empty($custom_header_bg_spacings["bottom"]) ? " data-bottom='".esc_attr($custom_header_bg_spacings['bottom'])."'" : '').">";
						if ($page_title_content) {
							echo sprintf("%s", $page_title_content);
						}
						echo sprintf("%s", $bg_header_html);
						echo "<div class='header_img_wrap' ".(isset($title_height) ? "style='height:".$title_height."px;'" : '')."></div>";
					echo '</div>';
				}
		echo "<!-- /header_box -->";
		$page_header_content = ob_get_clean();

		if(isset($header_box_enable) && $header_box_enable == '1'){
			$this->header['header_box'] = $page_header_content;
		} else {
			$this->header['header_box'] = '';
		}

		ob_start();
			$is_revslider_active = function_exists('set_revslider_as_theme');
			$cws_revslider_content = '';
			$slider_type = "none";
			if ( is_front_page() ){
				$slider_type = $this->cws_get_option( 'home-slider-type' );
				switch( $slider_type ){
					case 'img-slider':
						$bg_header = false;
						$slider_settings = $this->cws_get_meta_option( 'slider_override' );

						$slider_shortcode = $this->cws_get_option( 'home-header-slider-options' );
						if ( is_page() && $slider_settings['is_override'] == '1' ){
							$slider_shortcode = $slider_settings['slider_shortcode'];
						}
						if ( $slider_settings['is_override'] == '1' ){
							$slider_is_wide = $slider_settings['is_wide'];
						} else {
							$slider_is_wide = '';
						}
						$slider_shortcode = wp_specialchars_decode($slider_shortcode, ENT_QUOTES);
						if (!empty($slider_shortcode)) {
							$bg_header = true;
						}

						$slider_plugin_exist = true;

						$slider_shortcode = wp_specialchars_decode($slider_shortcode, ENT_QUOTES);
						$shortcode_output = do_shortcode($slider_shortcode);

						$slider_plugin_exist = !($shortcode_output === $slider_shortcode); //Check shortcode & output the same

						if ($slider_is_wide !== '1') {
							$shortcode_output = "<div class='slider_bg'><div class='container'>{$shortcode_output}</div></div>";
						}

						if ($slider_plugin_exist){
							echo sprintf("%s", $shortcode_output);		
						}

						$slider_error = strpos($shortcode_output, 'Revolution Slider Error') ? true : false;

						$show_page_title = !empty( $slider_shortcode ) ? false : $show_page_title;
						break;
					case 'video-slider':
						$bg_header = false;
						$video_slider_settings = $this->cws_get_option('slidersection-start');

						$slider_shortcode = $video_slider_settings[ 'slider_shortcode' ];
						$slider_switch = $video_slider_settings[ 'slider_switch' ];
						$video_type = $video_slider_settings[ 'video_type' ];
						$set_video_header_height = $video_slider_settings[ 'set_video_header_height' ];
						$video_header_height = $video_slider_settings[ 'video_header_height' ];
						$sh_source = $video_slider_settings[ 'sh_source' ];
						$youtube_source = $video_slider_settings[ 'youtube_source' ];
						$vimeo_source = $video_slider_settings[ 'vimeo_source' ];
						$color_overlay_type = $video_slider_settings[ 'color_overlay_type' ];
						$overlay_color = $video_slider_settings[ 'overlay_color' ];
						$color_overlay_opacity = $video_slider_settings[ 'color_overlay_opacity' ];
						$use_pattern = $video_slider_settings[ 'use_pattern' ];
						$pattern_image = $video_slider_settings[ 'pattern_image' ];

						$video_header_height = $set_video_header_height == "1" ? $video_header_height : false;
						$gradient_video_set = $video_slider_settings["slider_gradient_settings"];
						$gradient_settings = $this->cws_render_gradient($gradient_video_set);

						$sh_source = isset( $sh_source['src'] ) && !empty( $sh_source['src'] ) ? $sh_source['src'] : '';
						$color_overlay_opacity = (int)$color_overlay_opacity / 100;
						$has_video_src = false;
						$header_video_atts = '';
						$header_video_class = "fs_video_bg";
						$header_video_styles = '';
						$header_video_html = '';
						$uniqid = uniqid( 'video-' );
						$uniqid_esc = esc_attr( $uniqid );
						switch ( $video_type ){
							case 'self_hosted':
								if ( !empty( $sh_source ) ){
									$has_video_src = true;
									$header_video_class .= " cws_self_hosted_video";
									$header_video_html .= "<video class='self_hosted_video' src='".esc_url($sh_source)."' autoplay='autoplay' loop='loop' muted='muted'></video>";
								}
								break;
							case 'youtube':
								if ( !empty( $youtube_source ) ){
									wp_enqueue_script ('cws_YT_bg');
									$has_video_src = true;
									$header_video_class .= " cws_Yt_video_bg loading";
									$header_video_atts .= " data-video-source='".esc_url($youtube_source)."' data-video-id='".esc_attr($uniqid)."'";
									$header_video_html .= "<div id='".esc_attr($uniqid_esc)."'></div>";
								}
								break;
							case 'vimeo':
								if ( !empty( $vimeo_source ) ){
									wp_enqueue_script ('vimeo');
									wp_enqueue_script ('cws_self&vimeo_bg');
									$has_video_src = true;
									$header_video_class .= " cws_Vimeo_video_bg";
									$header_video_atts .= " data-video-source='".esc_url($vimeo_source)."' data-video-id='".esc_attr($uniqid)."'";
									$header_video_html .= "<iframe id='".esc_attr($uniqid_esc)."' src='" . esc_url($vimeo_source) . "?api=1&player_id=".esc_attr($uniqid)."' frameborder='0'></iframe>";
								}
								break;
						}
						if ( $has_video_src ){
							$bg_header = true;
							if ( $use_pattern && !empty( $pattern_image ) && isset( $pattern_image['url'] ) && !empty( $pattern_image['url'] ) ){
								$pattern_img_src = $pattern_image['url'];
								$header_video_html .= "<div class='bg_layer' style='background-image:url(" . esc_url($pattern_img_src) . ")'></div>";
							}
							if ( $color_overlay_type == 'color' && !empty( $overlay_color ) ){
								$header_video_html .= "<div class='bg_layer' style='background-color:" . esc_attr($overlay_color) . ";" . ( !empty( $color_overlay_opacity ) ? "opacity:".esc_attr($color_overlay_opacity).";" : '' ) . "'></div>";
							}
							else if ( $color_overlay_type == 'gradient' ){
								$gradient_rules = $this->cws_print_gradient( $gradient_settings );
								$header_video_html .= "<div class='bg_layer' style='".esc_attr($gradient_rules)."" . ( !empty( $color_overlay_opacity ) ? "opacity:".esc_attr($color_overlay_opacity).";" : '' ) . "'></div>";
							}
						}

						$header_video_atts .= !empty( $header_video_class ) ? " class='" . trim( $header_video_class ) . "'" : '';
						$header_video_atts .= !empty( $header_video_styles ) ? " style='". esc_attr($header_video_styles) ."'" : '';


						if ( !empty( $slider_shortcode ) && $has_video_src && $slider_switch == 1 ){
							$bg_header = true;
							echo "<div class='fs_video_slider'>";
								echo  do_shortcode( $slider_shortcode );
								echo '<div ' . $header_video_atts . '>';
								echo sprintf("%s", $header_video_html);
								echo '</div>';
								echo '</div>';
						} elseif ( $has_video_src && $slider_switch == 0 ) {
							$bg_header = true;
							$header_video_fs_view = $video_header_height == false ? 'header_video_fs_view' : '';
							$video_height_coef = $video_header_height == false ? '' : " data-wrapper-height='".esc_attr(960 / $video_header_height)."'";
							$video_header_height = $video_header_height == false ? '' : "style='height:" . esc_attr($video_header_height) ."px'";
							echo "<div class='fs_video_slider ". sanitize_html_class( $header_video_fs_view ) ."' " . $video_header_height . " ". $video_height_coef .">";
							echo '<div ' . $header_video_atts . '>';
							echo sprintf("%s", $header_video_html);
							echo '</div>';
							echo '</div>';
						}elseif ( ! empty( $slider_shortcode ) && $slider_switch == 1 && ! $has_video_src ) {
							$bg_header = true;
								echo  do_shortcode( $slider_shortcode );
						}else{
							$bg_header = true;
							if ( $has_video_src ){
								echo "<div class='fs_video_slider'></div>";
							}
						}

						break;
					case 'stat-img-slider':
						$bg_header = false;
						$static_img_section = $this->cws_get_option('static_img_section');
						$set_img_header_height = $static_img_section['set_static_image_height'];
						$img_header_height = $static_img_section[ 'static_image_height' ];

						$color_overlay_type = '';
						$overlay_color = '';
						$color_overlay_opacity = '';
						$gradient_settings = array();

						if ($static_img_section[ 'static_customize_colors' ] == "1"){
							$color_overlay_type = $static_img_section[ 'img_header_color_overlay_type' ];
							$overlay_color = $static_img_section[ 'img_header_overlay_color' ];
							$color_overlay_opacity = $static_img_section[ 'img_header_color_overlay_opacity' ];
							$color_overlay_opacity = (int)$color_overlay_opacity / 100;
							$gradient_settings = $this->cws_render_gradient( $static_img_section["img_header_gradient_settings"] );
						}

						$use_pattern = $static_img_section[ 'img_header_use_pattern' ];
						$pattern_image = $static_img_section[ 'img_header_pattern_image' ];

						$img_header_height = $set_img_header_height == "1" ? $img_header_height : false;

						$parallax_header_opt = $static_img_section['img_header_parallax_options'];

						$img_header_parallaxify = $static_img_section["img_header_parallaxify"];

						if ($img_header_parallaxify == '1'){
							$img_header_scalar_x = $parallax_header_opt["img_header_scalar_x"];
							$img_header_scalar_y = $parallax_header_opt["img_header_scalar_y"];
							$img_header_limit_x = $parallax_header_opt["img_header_limit_x"];
							$img_header_limit_y = $parallax_header_opt["img_header_limit_y"];

							$img_header_parallaxify_atts = ' data-scalar-x="'.esc_attr($img_header_scalar_x).'" data-scalar-y="'.esc_attr($img_header_scalar_y).'" data-limit-y="'.esc_attr($img_header_limit_y).'" data-limit-x="'.esc_attr($img_header_limit_x).'"';
							$img_header_parallaxify_layer_atts = 'position: absolute; z-index: 1; left: -'.esc_attr($img_header_limit_y).'px; right: -'.esc_attr($img_header_limit_y).'px; top: -'.esc_attr($img_header_limit_x).'px; bottom: -'.esc_attr($img_header_limit_x).'px;';
						}

						$image_options = $static_img_section["home_header_image_options"];

						$default_img = false;
						$override_img = false;
						$img_url = '';

						$header_img_html = '';

						if ( isset( $image_options['src'] ) ){
							if ( $use_pattern && !empty( $pattern_image ) && isset( $pattern_image['src'] ) && !empty( $pattern_image['src'] ) ){
								$pattern_img_src = $pattern_image['src'];
								$header_img_html .= "<div class='bg_layer' style='background-image:url(" . esc_url($pattern_img_src) . ");".($img_header_parallaxify ? $img_header_parallaxify_layer_atts : '')."'></div>";
							}
							if ( $color_overlay_type == 'color' && !empty( $overlay_color ) ){
								$header_img_html .= "<div class='bg_layer' style='background-color:" . esc_attr($overlay_color) . ";" . ( !empty( $color_overlay_opacity ) ? "opacity:".esc_attr($color_overlay_opacity).";" : '' ) . ";".($img_header_parallaxify ? $img_header_parallaxify_layer_atts : '')."'></div>";
							}
							else if ( $color_overlay_type == 'gradient' && !empty( $gradient_settings ) ){
								$gradient_rules = $this->cws_print_gradient( $gradient_settings );
								$header_img_html .= "<div class='bg_layer' style='$gradient_rules" . ( !empty( $color_overlay_opacity ) ? "opacity:".esc_attr($color_overlay_opacity).";" : '' ) . ";".($img_header_parallaxify ? $img_header_parallaxify_layer_atts : '')."'></div>";
							}
						}

						if ( isset( $image_options['src'] ) ) {
							$bg_header = true;
							$header_img_fs_view = $img_header_height== false ? 'header_video_fs_view' : '';
							$header_img_height_coef = $img_header_height == false ? '' : " data-wrapper-height='".esc_attr(960 / $img_header_height)."'";
							$img_header_height = $img_header_height == false ? '' : "style='height:" . esc_attr($img_header_height) ."px'";

							echo "<div class='fs_img_header " . sanitize_html_class( $header_img_fs_view ) ."' " . $img_header_height . " ". $header_img_height_coef .">";
								if ($img_header_parallaxify) {
									echo '<div class="cws_parallax_section" '.$img_header_parallaxify_atts.'>';
								}
								wp_enqueue_script ('parallax');
									if ($img_header_parallaxify) {
										echo '<div class="layer" data-depth="1.00">';
									}
									echo sprintf("%s", $header_img_html);
									echo "<div class='stat_img_cont' style='". ($img_header_parallaxify ? $img_header_parallaxify_layer_atts : '') ."background-image: url(".esc_url($image_options['src']).");background-size: cover;background-position: center center;'></div>";
									if ($img_header_parallaxify) {
										echo '</div>';
									}
								if ($img_header_parallaxify) {
									echo '</div>';
								}
							echo '</div>';

						}
					break;
					default:
				}
			}
			else if ( is_page() || $this->cws_is_woo() && is_shop() ){
				if($this->cws_is_woo() && is_shop()){
				$slider_type = $this->cws_get_option( 'shop-slider-type' );
				switch( $slider_type ){
					case 'img-slider':
						$slider_settings = $this->cws_get_meta_option( 'slider_override' );
						$slider_shortcode = wp_specialchars_decode($this->cws_get_option( 'shop-header-slider-options' ));

						if ( is_page() && $slider_settings['is_override'] == '1' ){
							$slider_shortcode = wp_specialchars_decode($slider_settings['slider_shortcode']);
						}
						$slider_options = isset($slider_options) ? $slider_options : '';
						$slider_options = wp_specialchars_decode($slider_options, ENT_QUOTES);
						$slider_output = do_shortcode( $slider_shortcode );

						if ($slider_settings['is_wide'] !== '1'){
							$slider_output = "<div class='slider_bg'><div class='container'>{$slider_output}</div></div>";
						}

						echo sprintf("%s", $slider_output);

						$slider_error = strpos($slider_output, 'Revolution Slider Error') ? true : false;

						$show_page_title = !empty( $slider_options ) ? false : $show_page_title;
						$bg_header = true;
						break;
					case 'video-slider':
						$bg_header = false;
						$video_slider_settings = $this->cws_get_option('shopslidersection-start');

						$slider_shortcode = isset($video_slider_settings[ 'slider_shortcode' ]) ? $video_slider_settings[ 'slider_shortcode' ] : "";
						$slider_switch = $video_slider_settings[ 'slider_switch' ];
						$video_type = $video_slider_settings[ 'video_type' ];
						$set_video_header_height = $video_slider_settings[ 'set_video_header_height' ];
						$video_header_height = $video_slider_settings[ 'video_header_height' ];
						$sh_source = isset($video_slider_settings[ 'sh_source' ]) ? $video_slider_settings[ 'sh_source' ] : "";
						$youtube_source = $video_slider_settings[ 'youtube_source' ];
						$vimeo_source = isset($video_slider_settings[ 'vimeo_source' ]) ? $video_slider_settings[ 'vimeo_source' ] : "";
						$color_overlay_type = $video_slider_settings[ 'color_overlay_type' ];
						$overlay_color = isset($video_slider_settings[ 'overlay_color' ]) ? $video_slider_settings[ 'overlay_color' ] : "";
						$color_overlay_opacity = isset($video_slider_settings[ 'color_overlay_opacity' ]) ? $video_slider_settings[ 'color_overlay_opacity' ] : "";
						$use_pattern = isset($video_slider_settings[ 'use_pattern' ]) ? $video_slider_settings[ 'use_pattern' ] : "";
						$pattern_image = isset($video_slider_settings[ 'pattern_image' ]) ? $video_slider_settings[ 'pattern_image' ] : "";

						$video_header_height = $set_video_header_height == "1" ? $video_header_height : false;
						$gradient_video_set = isset($video_slider_settings["slider_gradient_settings"]) ? $video_slider_settings["slider_gradient_settings"] : "";
						$gradient_settings = $this->cws_render_gradient($gradient_video_set);

						$sh_source = isset( $sh_source['src'] ) && !empty( $sh_source['src'] ) ? $sh_source['src'] : '';
						$color_overlay_opacity = (int)$color_overlay_opacity / 100;
						$has_video_src = false;
						$header_video_atts = '';
						$header_video_class = "fs_video_bg";
						$header_video_styles = '';
						$header_video_html = '';
						$uniqid = uniqid( 'video-' );
						$uniqid_esc = esc_attr( $uniqid );
						switch ( $video_type ){
							case 'self_hosted':
								if ( !empty( $sh_source ) ){
									$has_video_src = true;
									$header_video_class .= " cws_self_hosted_video";
									$header_video_html .= "<video class='self_hosted_video' src='$sh_source' autoplay='autoplay' loop='loop' muted='muted'></video>";
								}
								break;
							case 'youtube':
								if ( !empty( $youtube_source ) ){
									//wp_enqueue_script ('cws_YT_bg');
									$has_video_src = true;
									$header_video_class .= " cws_Yt_video_bg loading";
									$header_video_atts .= " data-video-source='$youtube_source' data-video-id='$uniqid'";
									$header_video_html .= "<div id='$uniqid_esc'></div>";
								}
								break;
							case 'vimeo':
								if ( !empty( $vimeo_source ) ){
									wp_enqueue_script ('vimeo');
									//wp_enqueue_script ('cws_self&vimeo_bg');
									$has_video_src = true;
									$header_video_class .= " cws_Vimeo_video_bg";
									$header_video_atts .= " data-video-source='$vimeo_source' data-video-id='$uniqid'";
									$header_video_html .= "<iframe id='$uniqid_esc' src='" . $vimeo_source . "?api=1&player_id=$uniqid' frameborder='0'></iframe>";
								}
								break;
						}
						if ( $has_video_src ){
							$bg_header = true;
							if ( $use_pattern && !empty( $pattern_image ) && isset( $pattern_image['url'] ) && !empty( $pattern_image['url'] ) ){
								$pattern_img_src = $pattern_image['url'];
								$header_video_html .= "<div class='bg_layer' style='background-image:url(" . $pattern_img_src . ")'></div>";
							}
							if ( $color_overlay_type == 'color' && !empty( $overlay_color ) ){
								$header_video_html .= "<div class='bg_layer' style='background-color:" . $overlay_color . ";" . ( !empty( $color_overlay_opacity ) ? "opacity:$color_overlay_opacity;" : '' ) . "'></div>";
							}
							else if ( $color_overlay_type == 'gradient' ){
								$gradient_rules = $this->cws_print_gradient( array( 'settings' => $gradient_settings ) );
								$header_video_html .= "<div class='bg_layer' style='$gradient_rules" . ( !empty( $color_overlay_opacity ) ? "opacity:$color_overlay_opacity;" : '' ) . "'></div>";
							}
						}

						$header_video_atts .= !empty( $header_video_class ) ? " class='" . trim( $header_video_class ) . "'" : '';
						$header_video_atts .= !empty( $header_video_styles ) ? " style='". esc_attr($header_video_styles) ."'" : '';


						if ( !empty( $slider_shortcode ) && $has_video_src && $slider_switch == 1 ){
							$bg_header = true;
							echo "<div class='fs_video_slider'>";
							if ( $is_revslider_active ) {
								echo  do_shortcode( $slider_shortcode );
							} else {
								echo do_shortcode( "[cws_sc_msg_box type='warning' is_closable='1' text='Install and activate Slider Revolution plugin'][/cws_sc_msg_box]" );
							}
								echo '<div ' . $header_video_atts . '>';
								echo sprintf("%s", $header_video_html);
								echo '</div>';
								echo '</div>';
						} elseif ( $has_video_src && $slider_switch == 0 ) {
							$bg_header = true;
							$header_video_fs_view = $video_header_height == false ? 'header_video_fs_view' : '';
							$video_height_coef = $video_header_height == false ? '' : " data-wrapper-height='".(960 / $video_header_height)."'";
							$video_header_height = $video_header_height == false ? '' : "style='height:" . $video_header_height ."px'";
							echo "<div class='fs_video_slider ". sanitize_html_class( $header_video_fs_view ) ."' " . $video_header_height . " ". $video_height_coef .">";
							echo '<div ' . $header_video_atts . '>';
							echo sprintf("%s", $header_video_html);
							echo '</div>';
							echo '</div>';
						}elseif ( ! empty( $slider_shortcode ) && $slider_switch == 1 && ! $has_video_src ) {
							$bg_header = true;
							if ( $is_revslider_active ) {
								echo  do_shortcode( $slider_shortcode );
							} else {
								echo do_shortcode( "[cws_sc_msg_box type='warning' is_closable='1' text='Install and activate Slider Revolution plugin'][/cws_sc_msg_box]" );
							}
						}else{
							$bg_header = true;
							if ( $has_video_src ){
								echo "<div class='fs_video_slider'></div>";
							}
						}

						break;
					case 'stat-img-slider':
						$bg_header = false;
						$static_img_section = $this->cws_get_option('static_img_section');
						$set_img_header_height = $static_img_section['set_static_image_height'];
						$img_header_height = $static_img_section[ 'static_image_height' ];


						$color_overlay_type = '';
						$overlay_color = '';
						$color_overlay_opacity = '';
						$gradient_settings = array();

						if ($static_img_section[ 'static_customize_colors' ] == "1"){
							$color_overlay_type = $static_img_section[ 'img_header_color_overlay_type' ];
							$overlay_color = $static_img_section[ 'img_header_overlay_color' ];
							$color_overlay_opacity = $static_img_section[ 'img_header_color_overlay_opacity' ];
							$color_overlay_opacity = (int)$color_overlay_opacity / 100;
							$gradient_settings = $this->cws_render_gradient( $static_img_section["img_header_gradient_settings"] );
						}

						$use_pattern = $static_img_section[ 'img_header_use_pattern' ];
						$pattern_image = $static_img_section[ 'img_header_pattern_image' ];

						$img_header_height = $set_img_header_height == "1" ? $img_header_height : false;

						$parallax_header_opt = $static_img_section['img_header_parallax_options'];

						$img_header_parallaxify = $static_img_section["img_header_parallaxify"];

						if ($img_header_parallaxify == '1'){
							$img_header_scalar_x = $parallax_header_opt["img_header_scalar_x"];
							$img_header_scalar_y = $parallax_header_opt["img_header_scalar_y"];
							$img_header_limit_x = $parallax_header_opt["img_header_limit_x"];
							$img_header_limit_y = $parallax_header_opt["img_header_limit_y"];

							$img_header_parallaxify_atts = ' data-scalar-x="'.$img_header_scalar_x.'" data-scalar-y="'.$img_header_scalar_y.'" data-limit-y="'.$img_header_limit_y.'" data-limit-x="'.$img_header_limit_x.'"';
							$img_header_parallaxify_layer_atts = 'position: absolute; z-index: 1; left: -'.$img_header_limit_y.'px; right: -'.$img_header_limit_y.'px; top: -'.$img_header_limit_x.'px; bottom: -'.$img_header_limit_x.'px;';
						}

						$image_options = $static_img_section["shop_header_image_options"];

						$default_img = false;
						$override_img = false;
						$img_url = '';

						$header_img_html = '';

						if ( isset( $image_options['src'] ) ){
							if ( $use_pattern && !empty( $pattern_image ) && isset( $pattern_image['src'] ) && !empty( $pattern_image['src'] ) ){
								$pattern_img_src = esc_url($pattern_image['src']);
								$header_img_html .= "<div class='bg_layer' style='background-image:url(" . $pattern_img_src . ");".($img_header_parallaxify ? $img_header_parallaxify_layer_atts : '')."'></div>";
							}
							if ( $color_overlay_type == 'color' && !empty( $overlay_color ) ){
								$header_img_html .= "<div class='bg_layer' style='background-color:" . esc_attr($overlay_color) . ";" . ( !empty( $color_overlay_opacity ) ? "opacity:".esc_attr($color_overlay_opacity).";" : '' ) . ";".($img_header_parallaxify ? $img_header_parallaxify_layer_atts : '')."'></div>";
							}
							else if ( $color_overlay_type == 'gradient' && !empty( $gradient_settings ) ){
								$gradient_rules = $this->cws_print_gradient( array( 'settings' => $gradient_settings ) );
								$header_img_html .= "<div class='bg_layer' style='$gradient_rules" . ( !empty( $color_overlay_opacity ) ? "opacity:".esc_attr($color_overlay_opacity).";" : '' ) . ";".($img_header_parallaxify ? $img_header_parallaxify_layer_atts : '')."'></div>";
							}
						}

						if ( isset( $image_options['src'] ) ) {
							$bg_header = true;
							$header_img_fs_view = $img_header_height== false ? 'header_video_fs_view' : '';
							$header_img_height_coef = $img_header_height == false ? '' : " data-wrapper-height='".(960 / $img_header_height)."'";
							$img_header_height = $img_header_height == false ? '' : "style='height:" . esc_attr($img_header_height) ."px'";

							echo "<div class='fs_img_header " . sanitize_html_class( $header_img_fs_view ) ."' " . $img_header_height . " ". $header_img_height_coef .">";
							if($img_header_parallaxify){
								echo '<div class="cws_parallax_section" '.$img_header_parallaxify_atts.'>';
							}
								wp_enqueue_script ('parallax');
								if($img_header_parallaxify){
									echo '<div class="layer" data-depth="1.00">';
								}
									echo sprintf("%s", $header_img_html);
									echo "<div class='stat_img_cont' style='". ($img_header_parallaxify ? $img_header_parallaxify_layer_atts : '') ."background-image: url(".esc_url($image_options['src']).");background-size: cover;background-position: center center;'></div>";
									if($img_header_parallaxify){
										echo '</div></div>';
									}
							echo '</div>';

						}
					break;
					default:
				}
				}else{
					$slider_settings = $this->cws_get_meta_option( 'slider_override' );
					if ( isset($slider_settings['is_override']) && $slider_settings['is_override'] == '1' ){
						$bg_header = true;
						$slider_plugin_exist = true;

						$slider_shortcode = wp_specialchars_decode($slider_settings['slider_shortcode'], ENT_QUOTES);
						$shortcode_output = do_shortcode($slider_shortcode);

						$slider_plugin_exist = !($shortcode_output === $slider_shortcode); //Check shortcode & output the same

						if ($slider_settings['is_wide'] !== '1') {
							$shortcode_output = "<div class='slider_bg'><div class='container'>{$shortcode_output}</div></div>";
						}

						if ($slider_plugin_exist){
							echo sprintf("%s", $shortcode_output);
						}

						$slider_error = strpos($shortcode_output, 'Revolution Slider Error') ? true : false;
					}					
				}


			}
			else if ( is_single() ){}
			else if ( is_archive() ){}

		$slider_content = ob_get_clean();

		$args = array(
			'slider_content' => $slider_content,
			'bg_header' => $bg_header
		);

		ob_start();
			$this->cws_header_menu_and_logo(false, $args);
		$header_content = ob_get_clean();

		if ($sticky_menu_enable == '1') {
			echo "<div class='sticky_header'>";
				$this->cws_header_menu_and_logo(true, $args);
			echo '</div>';
		}

		wp_add_inline_script('img_loaded', 'window.header_after_slider=false;');

		//Get metaboxes from page
		//Header (General)
		$header = $this->cws_get_meta_option('header');
		extract($header, EXTR_PREFIX_ALL, 'header');

		ob_start();

			?>

			<div class="header_zone"><!-- header_zone -->
				<?php
				if ( (isset($header_customize) && $header_customize == '1') && (isset($header_overlay['type']) && $header_overlay['type'] != 'none') ){
					echo "<div class='header_overlay'></div>";
				}

		$header_zone = ob_get_clean();
		$this->header['drop_zone_start'] = $header_zone;

		$menu_box_header_outside_slider = $this->cws_get_meta_option('menu_box')['header_outside_slider'] == '1';

		//Render Header from parts
		ob_start();

		echo '<div class="megamenu_width"><div class="container"></div><div class="container wide_container"></div></div>';
		echo '<div class="header_wrapper_container'.($this->cws_get_meta_option('top_bar_box')['enable'] == 0 ? ' disabled_top_bar' : '').(isset($header_fixed) && $header_fixed == '1' ? ' header_fixed' : '').(($menu_box_header_outside_slider && $bg_header == true ) ? ' header_outside_slider' : '').'">';
			echo sprintf("%s", $this->header['before_header']);
			if ( isset( $header_order ) ){
				foreach ($header_order as $key => $value){
					if (($menu_box_header_outside_slider && $value['val'] == 'header_box' )  ) continue;
					$header_val = $this->header[$value['val']];
					echo sprintf("%s", $header_val);
				}
			}
			echo sprintf("%s", $this->header['after_header']);
		echo '</div>';
		if (($menu_box_header_outside_slider) ) echo sprintf("%s", $this->header['header_box']);

		$header = ob_get_clean();
		echo sprintf("%s", $header);

		if (isset($slider_error) && $slider_error){
			$slider_content = "<div class='rev_slider_error'><div class='message'>Revolution Slider Error: Slider $slider_shortcode not found.</div></div>";
		}

		echo (!empty($slider_content) ? $slider_content : '');
	}

	public function cws_build_page_title($no_title, $font_color, $animate_options) {
		if ($animate_options){
		    wp_enqueue_script ('skrollr','jquery');
		}

		$post_type = get_post_type();

		$page_title_section_atts = '';
		$page_title_section_class = "page_title".($animate_options ? ' animate_title' : '');
		$page_title_section_class .= $no_title == '1' ? ' no_title' : '';
		$page_title_section_atts = !empty( $page_title_section_class ) ? " class='".esc_attr($page_title_section_class)."'" : '';
		$page_title_section_atts .= !empty( $page_title_section_styles ) ? " style='".esc_attr($page_title_section_styles)."'" : '';

		$page_title_container_styles = '';

		$post_id = get_the_id();
		$post_meta = get_post_meta( $post_id, 'cws_mb_post' );
		$post_meta = isset( $post_meta[0] ) ? $post_meta[0] : array();
		$apply_color = isset($post_meta['apply_color']) && !empty($post_meta['apply_color']) ? $post_meta['apply_color'] : "";
		
		$post_title_color = isset($post_meta['post_title_color']) && !empty($post_meta['post_title_color']) ? $post_meta['post_title_color'] : "";
		$post_background_color = isset($post_meta['post_background_color']) && !empty($post_meta['post_background_color']) ? $post_meta['post_background_color'] : '';

		$page_title_container_styles = $this->print_ne($page_title_container_styles, ' style="' . esc_attr($page_title_container_styles) . '"');
		$show_breadcrumbs = $this->cws_get_option( 'breadcrumbs' ) == '1';
		$page_title = $this->cws_get_page_title($post_type);

		// Animate options
		$animate_title_options = $animate_container_options = $animate_section_options = '';
		if ($animate_options) {
			foreach ($animate_options as $key => $value) {
				$data_header = " data-_header-{$value['value']}='{$value['styles']}'";
				switch ($value['element']) {
					case 'title':
						$animate_title_options .= $data_header;
						break;
					case 'container':
						$animate_container_options .= $data_header;
						break;
					case 'section':
						$animate_section_options .= $data_header;
						break;
				}
			}
		}

		$breadcrumbs = '';
		$breadcrumbs .= '<div class="bread-crumbs-wrapper">';
		if ( $show_breadcrumbs ){
			$alt_bc = self::$cws_theme_config['alt_breadcrumbs'];
			reset($alt_bc);
			$key = key($alt_bc);
			if (!empty($alt_bc) && function_exists($key)) {
				$breadcrumbs .= '
					<svg class="left-shape" width="78" height="52">
						<defs>
						  <pattern id="pattern1" patternUnits="objectBoundingBox" width="100%" height="100%">
						  	<rect class="rect-pattern" x="0" y="0" width="100%" height="100%" stroke-width="0" />
						    <image href="'.get_template_directory_uri().'/img/patterns/shape_pattern.png" x="0" y="0" width="100%" height="100%" />
						    <rect x="0" y="0" width="100%" height="100%" stroke-width="0" fill="rgba(0,0,0,.15)" />
						  </pattern>
						</defs>

						<path id="svg_1" d="M0.7,0.2l12,25.9L0.7,51.5l76.9,0.1l0.1-51.2C77.6,0.4,0.7,0.2,0.7,0.2z" fill="url(#pattern1)" />
					</svg>
				';
				$breadcrumbs .= call_user_func_array($key, $alt_bc[$key]);
				$breadcrumbs .= '
					<svg class="right-shape" width="78" height="52">
						<defs>
						  <pattern id="pattern2" patternUnits="userSpaceOnUse" width="100%" height="100%">
						  	<rect class="rect-pattern" x="0" y="0" width="100%" height="100%" stroke-width="0" />
						    <image href="'.get_template_directory_uri().'/img/patterns/shape_pattern.png" x="0" y="0" width="100%" height="100%" />
						    <rect x="0" y="0" width="100%" height="100%" stroke-width="0" fill="rgba(0,0,0,.15)" />
						  </pattern>
						</defs>

						<path id="svg_2" d="M0,0.4L0,51.6l76.9-0.1L64.9,26.1l12-25.9C76.8,0.2,0,0.4,0,0.4z" fill="url(#pattern2)" />
					</svg>
				';
			} else {
				ob_start();
				echo '
					<svg class="left-shape" width="78" height="52">
						<defs>
						  <pattern id="pattern3" patternUnits="objectBoundingBox" width="100%" height="100%">
						  	<rect class="rect-pattern" x="0" y="0" width="100%" height="100%" stroke-width="0" />
						    <image href="'.get_template_directory_uri().'/img/patterns/shape_pattern.png" x="0" y="0" width="100%" height="100%" />
						    <rect x="0" y="0" width="100%" height="100%" stroke-width="0" fill="rgba(0,0,0,.15)" />
						  </pattern>
						</defs>

						<path id="svg_3" d="M0.7,0.2l12,25.9L0.7,51.5l76.9,0.1l0.1-51.2C77.6,0.4,0.7,0.2,0.7,0.2z" fill="url(#pattern3)" />
					</svg>
				';
				vintwood_dimox_breadcrumbs($animate_title_options);
				echo '
					<svg class="right-shape" width="78" height="52">
						<defs>
						  <pattern id="pattern4" patternUnits="userSpaceOnUse" width="100%" height="100%">
						  	<rect class="rect-pattern" x="0" y="0" width="100%" height="100%" stroke-width="0" />
						    <image href="'.get_template_directory_uri().'/img/patterns/shape_pattern.png" x="0" y="0" width="100%" height="100%" />
						    <rect x="0" y="0" width="100%" height="100%" stroke-width="0" fill="rgba(0,0,0,.15)" />
						  </pattern>
						</defs>

						<path id="svg_4" d="M0,0.4L0,51.6l76.9-0.1L64.9,26.1l12-25.9C76.8,0.2,0,0.4,0,0.4z" fill="url(#pattern4)" />
					</svg>
				';
				$breadcrumbs .= ob_get_clean();
			}
		}
		$breadcrumbs .= '</div>';

		$page_title = esc_html($page_title);

		$header_box = $this->cws_get_meta_option('header_box');
		$header_box_settings = isset($header_box['hide_divider']) ? $header_box['hide_divider'] : "";
		
		$breadcrumbs_logo = isset($header_box['breadcrumbs_divider']) ? $header_box['breadcrumbs_divider'] : "";
		$woo_customize_title = $this->cws_get_option('woo_customize_title');
		if($this->cws_is_woo() && !empty($woo_customize_title)){
			$header_box_settings = $this->cws_get_option('woo_hide_divider');
			$breadcrumbs_logo_divider = $this->cws_get_option('woo_breadcrumbs_divider');
			$breadcrumbs_logo = !empty($breadcrumbs_logo_divider) ? $breadcrumbs_logo_divider : "";
		}

		$logo_exists = false;
		$diver_logo = array();		
		if ( !empty( $breadcrumbs_logo['src'] ) ) {
			$logo_exists = true;
			$logo_hw = isset($header_box['breadcrumbs_dimensions']) ? $header_box['breadcrumbs_dimensions'] : "";
			if($this->cws_is_woo() && !empty($woo_customize_title)){
				$logo_hw = $this->cws_get_option('woo_breadcrumbs_dimensions');
			}
			$bfi_args = array();
			
			if ( is_array( $logo_hw ) ) {
				foreach ( $logo_hw as $key => $value ) {
					if ( ! empty( $value ) ) {
						$bfi_args[ $key ] = $value;
						$bfi_args['crop'] = true;
					}
				}
			}

			$logo_m = isset($header_box['breadcrumbs-margin']) ? $header_box['breadcrumbs-margin'] : "";
			if($this->cws_is_woo() && !empty($woo_customize_title)){
				$logo_m = $this->cws_get_option('woo_breadcrumbs_dimensions');
			}
			if (!empty($logo_hw)){
				foreach ($logo_hw as $key => $value) {
					if ( !empty($value) ){
						$bfi_args[$key] = (int)$value;
						$bfi_args['crop'] = true;
					}
				}
			}

			if(!empty($breadcrumbs_logo['src'])){
				$file_parts = pathinfo($breadcrumbs_logo['src']);

				if($file_parts['extension'] == 'svg'){
					$diver_logo['svg'] = $this->cws_print_svg_html($breadcrumbs_logo, $bfi_args);
				}else{
					$diver_logo['img'] = $this->cws_print_img_html($breadcrumbs_logo, $bfi_args);
				}			
			}
			$logo_lr_spacing = $logo_tb_spacing = '';
			if ( is_array( $logo_m ) ) {
				$logo_lr_spacing = $this->cws_print_css_keys($logo_m, 'margin-', 'px');
				$logo_tb_spacing = $this->cws_print_css_keys($logo_m, 'padding-', 'px');
			}
		}
		
		$out = '';

		if ( !is_front_page() ) {

			$header_center = ' header_center';
			$out .= '<section' . $page_title_section_atts . $animate_section_options . '>';
			$out .= '<div class="container' . $header_center . '"';
			$out .= $page_title_container_styles . $animate_container_options . '>';
			$font_color = !empty($post_title_color) ? $post_title_color : $font_color;
			$out .= '<div class="title"><h1' . $this->print_ne( $font_color, ' style="color:'.esc_attr($font_color).';"');
			$out .= $animate_title_options . '>';

			if ($logo_exists){

				$spacing = !empty( $logo_lr_spacing ) ? " style='{$logo_lr_spacing}'" : '';
				$out .= sprintf('<span%s class="logo_breadcrumbs svg_lotus">', $spacing);
				if(!empty($diver_logo)){
					foreach ($diver_logo as $key => $value) {
						switch ($key) {
							case 'img' :
							$out .= '<img '. $diver_logo[$key] .' />';
							break ;
							case 'svg' :
							$out .= $diver_logo[$key];
							break ;
						}
					}			
				}					
				$out .= '</span>';
			}		
			$out .= esc_html($page_title) . '</h1></div>';
			$out .= '<div class="title_dividers">';
				$out .= '<span></span>';
				$out .= '<span></span>';
				$out .= '<span></span>';
			$out .= '</div>';
			if(is_page() && !empty($post->post_excerpt)){
				$out .= "<div class='page_excerpt'>".$post->post_excerpt."</div>";
			}
			$out .= $breadcrumbs . '</div></section>';

		}

		return $out;
	}

	public function cws_get_page_title($post_type) {
		$page_title = '';
		if ( is_404() ) {
			$page_title = self::$cws_theme_config['strings']['404'];
		} else if ( is_search() ) {
			$page_title = self::$cws_theme_config['strings']['search'];
		} else if ( is_front_page() ) {
			$page_title = self::$cws_theme_config['strings']['home'];
		} else if ( is_category() ) {
			$cat = get_category( get_query_var( 'cat' ) );
			$cat_name = isset( $cat->name ) ? $cat->name : '';
			$page_title = sprintf( self::$cws_theme_config['strings']['category'], $cat_name );
		} else if ( is_tag() ) {
			$page_title = sprintf( self::$cws_theme_config['strings']['tag'], single_tag_title( '', false ) );
		} elseif ( is_day() ) {
			$page_title = get_the_time( get_option('date_format') );
		} elseif ( is_month() ) {
			$page_title = get_the_time( 'F, Y' );
		} elseif ( is_year() ) {
			$page_title = get_the_time( 'Y' );
		} elseif ( has_post_format() && !is_singular() ) {
			$page_title = get_post_format_string( get_post_format() );
		} else if ( is_tax( array( 'cws_portfolio_cat', 'cws_staff_member_department', 'cws_staff_member_position' ) ) ) {
			$tax_slug = get_query_var( 'taxonomy' );
			$term_slug = get_query_var( $tax_slug );
			$tax_obj = get_taxonomy( $tax_slug );
			$term_obj = get_term_by( 'slug', $term_slug, $tax_slug );

			$singular_tax_label = isset( $tax_obj->labels ) && isset( $tax_obj->labels->singular_name ) ? $tax_obj->labels->singular_name : '';
			$term_name = isset( $term_obj->name ) ? $term_obj->name : '';
			$page_title = $singular_tax_label . ' ' . $term_name ;
		} elseif ( function_exists ( 'is_shop' ) && is_shop() ) {
  			$page_title = woocommerce_page_title(false);
		} elseif ( is_archive() ) {
			$post_type_obj = get_post_type_object( $post_type );
			$post_type_name = isset( $post_type_obj->label ) ? $post_type_obj->label : '';
			$page_title = $post_type_name ;
		} else if ( $this->cws_is_woo() ) {
			if(is_cart()){
				$page_title = self::$cws_theme_config['strings']['cart'];
			}elseif(is_checkout()){
				$page_title = self::$cws_theme_config['strings']['checkout'];
			}else{
				// $page_title = woocommerce_page_title( false );
				$page_title = get_the_title();
			}
		} else if (substr($post_type, 0, 4) === 'cws_' ) {
			$slug_option = substr($post_type, 4) . '_slug'; // if post_type is cws_portfolio, this will turn it into portfolio_slug option name
			$portfolio_slug = $this->cws_get_option( $slug_option );
			$post_type_obj = get_post_type_object( $post_type );
			$post_type_name = $post_type_obj->labels->menu_name;
			$page_title = !empty($post_type_name) ? $post_type_name : $portfolio_slug;
		} else {
			$blog_title = $this->cws_get_option('blog_title');
			$page_title = (!is_page() && !empty($blog_title)) ? $blog_title : get_the_title();
		}
		return $page_title;
	}

	/* Social Links */
	public function cws_render_social_links($social_location = '', $social_place = 'left') {
		$out = '';
		$social = $this->cws_get_option('social'); //Call from ThemeOptions
		$location = isset($social['location']) ? $social['location'] : '';
		$icons = isset($social['icons']) ? $social['icons'] : '';
		$el_atts = '';

		if ((!empty($icons) && !empty($location) && in_array($social_location, $location))) {
			$menu_box_search_place = $this->cws_get_meta_option('menu_box')['search_place'];
			$side_panel_place = $this->cws_get_meta_option('side_panel')['place'];
			$links = null;
			
			$styles = '';
			foreach ( $icons as $icon ) {
				$icon_id = uniqid( "cws_social_icon_" );
				$title = esc_attr($icon['title']);
				$url = !empty($icon['url']) ? $icon['url'] : '#';
				$links .= "<a id='".esc_attr($icon_id)."' href='".esc_url($url)."' class='cws_social_link ".esc_attr($icon['icon'])."' title='".esc_attr($title)."' target='_blank'></a>";
				$styles .= "
					#top_social_links_wrapper .cws_social_links #".esc_attr($icon_id)."{
						color: ".esc_attr($icon['color']).";
						background-color : ".esc_attr($icon['bg_color']).";
					}

					#top_social_links_wrapper .cws_social_links #".esc_attr($icon_id).":hover{
						color: ".esc_attr($icon['hover_color']).";
						background-color : ".esc_attr($icon['hover_bg_color']).";
					}					
				";
			}
			Cws_shortcode_css()->enqueue_cws_css($styles);

			if ($links) {
				$social_class = ($menu_box_search_place == 'top' || $this->cws_get_option('woo_cart_place') == 'top' || $side_panel_place == 'topbar_right') ? 'social-divider' : '';
				$social_class .= in_array('top_bar', $location) || in_array('menu', $location) ? ' social-'. esc_attr($social_place) : '';
				$out = "<div ".( !empty( $el_atts ) ? $el_atts : '' )." class='cws_social_links ".esc_attr($social_class)."'>{$links}</div>";
			}
		}
		return $out;
	}
	/* \Social Links */

	//public function

	public function cws_header_menu_and_logo ($is_sticky, $args = array() ) {
		extract($args);

		//Get metaboxes from page
		$menu_box = $this->cws_get_meta_option( 'menu_box' );
		extract($menu_box, EXTR_PREFIX_ALL, 'menu_box');

		$sticky_menu = $this->cws_get_meta_option( 'sticky_menu' );
		extract($sticky_menu, EXTR_PREFIX_ALL, 'sticky_menu');

		$logo_box = $this->cws_get_meta_option( 'logo_box' );
		extract($logo_box, EXTR_PREFIX_ALL, 'logo_box');

		$top_bar_box = $this->cws_get_meta_option( 'top_bar_box' );
		extract($top_bar_box, EXTR_PREFIX_ALL, 'top_bar_box');

		$side_panel = $this->cws_get_meta_option( 'side_panel' );
		extract($side_panel, EXTR_PREFIX_ALL, 'side_panel');		

		// $mobile_menu_box = $this->cws_get_meta_option( 'mobile_menu_box' );
		$mobile_menu_box_class = 'mobile_menu_wrapper';
		$mobile_menu_box_class .= (!empty($menu_box_enable_mobile) && $menu_box_enable_mobile == '1' ? ' show_on_tablets' : '');

		$woo_mini_cart = $this->cws_getWooMiniCart();
		$woo_mini_icon = $this->cws_getWooMiniIcon();
		if ($menu_box_enable_mobile){
			wp_enqueue_script ('modernizr');
		}
		/*** Logo Position ***/
		$header_class = 'site_header';
		$header_class .= $sticky_menu_enable ? ' sticky_enable' : '';
		$header_class .= $sticky_menu_enable && $sticky_menu_shadow ? ' sticky_shadow' : '';
		$header_class .= !empty( $logo_box_position ) ? ' logo-'.esc_attr($logo_box_position) : '';
		$header_class .= !empty( $menu_box_position ) ? ' menu-'.esc_attr($menu_box_position) : '';
		$header_class .= !empty( $logo_box_in_menu ) && $logo_box_in_menu == '1' ? ' logo-in-menu' : ' logo-not-in-menu';
		$header_class .= !empty( $slider_content ) && ($menu_box_header_outside_slider) && $bg_header ? " with_background" : '';
		$header_class .= ' mobile-icons-'.$menu_box_mobile_place;

		/***** \Logo Position *****/

		/***** Menu Position *****/
		global $current_user;
		$menu_locations = get_nav_menu_locations();
		$show_wpml_menu = CWS_WPML_ACTIVE;
		/***** \Menu Position *****/
		$a_logos = array(); // array of main logo, mobile and sticky
		$bfi_args = $bfi_args_sticky = $bfi_args_mobile = array();
		if ($logo_box_enable) {
			ob_start();
				/***** Logo Settings *****/
				// TODO: need to add some filter to get proper logo in case there are more than one option
				$woo_customize_logotype = $this->cws_get_option('woo_customize_logotype');
				if($this->cws_is_woo() && !empty($woo_customize_logotype)){
					$logo_box_default = 'logo_woo';
				}

				$logo_class = '';
				$logo_lr_spacing = $logo_tb_spacing = $main_logo_height = '';

				if ($logo_box_default !== 'custom') {
					$logo = isset($this->cws_get_option( 'logo_box' )[$logo_box_default]) ? $this->cws_get_option( 'logo_box' )[$logo_box_default] : ''; //Call from ThemeOptions
				} else {
					$logo = isset($this->cws_get_meta_option( 'logo_box' )['custom']) ? $this->cws_get_meta_option( 'logo_box' )['custom'] : '';
				}
				$logo_box_mobile = isset($this->cws_get_option( 'logo_box' )['mobile']) ? $this->cws_get_option( 'logo_box' )['mobile'] : ''; //Call from ThemeOptions
				$logo_box_sticky = isset($this->cws_get_option( 'logo_box' )['sticky']) ? $this->cws_get_option( 'logo_box' )['sticky'] : ''; //Call from ThemeOptions

				$logo_box_dimensions_sticky = isset($this->cws_get_option( 'logo_box' )['dimensions_sticky']) ? $this->cws_get_option( 'logo_box' )['dimensions_sticky'] : ''; //Call from ThemeOptions
				$logo_box_dimensions_mobile = isset($this->cws_get_option( 'logo_box' )['dimensions_mobile']) ? $this->cws_get_option( 'logo_box' )['dimensions_mobile'] : ''; //Call from ThemeOptions

				$logo_exists = false;
				if ( !empty( $logo['src'] ) ) {
					$logo_exists = true;

					if ( !empty($logo_box_dimensions) && is_array( $logo_box_dimensions ) ) {
						foreach ( $logo_box_dimensions as $key => $value ) {
							if ( ! empty( $value ) ) {
								$bfi_args[ $key ] = $value;
							}
						}
					}
					if ( !empty($logo_box_dimensions_sticky) && is_array( $logo_box_dimensions_sticky ) ) {
						foreach ( $logo_box_dimensions_sticky as $key => $value ) {
							if ( ! empty( $value ) ) {
								$bfi_args_sticky[ $key ] = $value;
							}
						}
					}				
					if ( !empty($logo_box_dimensions_mobile) && is_array( $logo_box_dimensions_mobile ) ) {
						foreach ( $logo_box_dimensions_mobile as $key => $value ) {
							if ( ! empty( $value ) ) {
								$bfi_args_mobile[ $key ] = $value;
							}
						}
					}

					if(!empty($logo['src'])){
						$file_parts = pathinfo($logo['src']);

						if($file_parts['extension'] == 'svg'){
							$a_logos['logo']['svg'] = $this->cws_print_svg_html($logo, $bfi_args, $main_logo_height);
						}else{
							$a_logos['logo']['img'] = $this->cws_print_img_html($logo, $bfi_args, $main_logo_height);
						}			
					}
					
					$logo_lr_spacing = $logo_tb_spacing = '';
					if ( is_array( $logo_box_margin ) ) {
						$logo_lr_spacing = $this->cws_print_css_keys($logo_box_margin, 'margin-', 'px');
						$logo_tb_spacing = $this->cws_print_css_keys($logo_box_margin, 'padding-', 'px');
					}

					if (!empty($main_logo_height)) {
						$logo_lr_spacing .= "height:{$main_logo_height}px;";
						$main_logo_height = " style='height:{$main_logo_height}px;'";
						$a_logos['logo_h'] = $main_logo_height;
					}
				}

				/***** \Logo Settings *****/
				$logo_sticky_src = array();
				if ( !empty($logo_box_sticky['src']) ) {
					$file_parts_sticky = pathinfo($logo_box_sticky['src']);

					if($file_parts_sticky['extension'] == 'svg'){
						$logo_sticky_src['svg'] = $this->cws_print_svg_html($logo_box_sticky, $bfi_args);
					}else{
						$logo_sticky_src['img'] = $this->cws_print_img_html($logo_box_sticky['id'], (!empty($bfi_args_sticky) ? $bfi_args_sticky : null));
					}	
					$logo_class .= ' custom_sticky_logo';
				}

				$logo_mobile_src = array();
				if ( !empty( $logo_box_mobile['src']) ) {
					$file_parts_mobile = pathinfo($logo_box_mobile['src']);
					if($file_parts_mobile['extension'] == 'svg'){
						$logo_mobile_src['svg'] = $this->cws_print_svg_html($logo_box_mobile, $bfi_args);
					}else{
						$logo_mobile_src['img'] = $this->cws_print_img_html($logo_box_mobile['id'], (!empty($bfi_args_mobile) ? $bfi_args_mobile : null));
						if(isset($this->cws_get_meta_option( 'logo_box' )['custom']) && $this->cws_get_meta_option( 'logo_box' )['custom']['custom_mobile_logo'] == '1'){
							$logo_mobile_src['img'] = $this->cws_print_img_html($this->cws_get_meta_option( 'logo_box' )['custom']['id'], (!empty($bfi_args_mobile) ? $bfi_args_mobile : null));
						}
					}			
					$logo_class .= ' custom_mobile_logo';
				}

				$a_logos['mobile'] = $logo_mobile_src;
				$a_logos['sticky'] = $logo_sticky_src;
			?>
				<!-- logo_box -->
			<?php
				//Logo box
				$esc_blog_name = esc_html(get_bloginfo('name'));

				$logo_box_class = 'logo_box';
				$logo_box_class .= ' header_logo_part';
				$logo_box_class .= empty($logo_mobile_src) ? ' no_mobile_logo' : '';
				$logo_box_class .= isset($menu_box_mobile_place) && ($menu_box_mobile_place == 'left' || $menu_box_mobile_place == 'right')  ? ' mobile_switcher_icon' : '';
				$logo_box_class .= isset($logo_box_border['line']) && $logo_box_border['line'] == '1' ? ' border_line' : '';

				if ( isset($logo_box_in_menu) && $logo_box_in_menu != '1' ) {
					?>
				<!-- logo_box -->
					<div class="<?php echo esc_attr($logo_box_class); ?>">
						<div class="container<?php if($logo_box_in_menu != '1' && $logo_box_wide == '1'){echo " wide_container";} ?>">
							<?php

							if ( isset($logo_box_in_menu) && $logo_box_in_menu != '1' ){
								if ($logo_exists){
									$printed_logo = $this->cws_print_logo_block($is_sticky, $logo_lr_spacing, $a_logos, $esc_blog_name);
									echo sprintf("%s", $printed_logo);
								} else {
								?>
									<h1 class='header_site_title'><?php echo esc_html($esc_blog_name); ?></h1>
								<?php 
								}								
							}

							?>
						</div>
					</div>
				<?php }	?>
				<!-- /logo_box -->
			<?php
			$logo_box_output = ob_get_clean();
		}
		if (!$is_sticky){
			$this->header['logo_box'] = $logo_box_output;
		}

		ob_start();

			echo "<div class='header_cont'>";
				?>
				<header <?php echo !empty($header_class) ? "class='".esc_attr($header_class)."'" : ''; ?>><!-- header -->
					<div class="header_container"><!-- header_container -->
		<?php
	
			$before_header_out = ob_get_clean();	
			if (!$is_sticky){
			$this->header['before_header'] = $before_header_out;
		}

		ob_start();

		$menu_style = '';
		$menu_class = 'menu_box';
		$menu_class .= (isset($menu_box_border['line']) && $menu_box_border['line'] == '1' ? ' border_line' : '');

		$menu_attr = " class='".esc_attr($menu_class)."' ".(!empty($menu_style) ? 'style="'.$menu_style.'"' : '').'';

		?>
			<!-- menu_box -->
			<div<?php echo (!empty( $menu_attr )) ? $menu_attr : ''; ?>>
				<div class="container<?php if($menu_box_wide == '1'){echo " wide_container";} ?>">
					<?php
					if ( (($logo_box_position == "left" || $logo_box_position == "right") && $logo_box_enable && (isset($logo_box_in_menu) && $logo_box_in_menu == '1')) || ($logo_box_enable && $is_sticky) ) {
					?>
						<div class="header_logo_part <?php if(empty($logo_mobile_src)){ echo ' no_mobile_logo'; } ?>">
							<?php if ($logo_exists) {
								$printed_logo_2 = $this->cws_print_logo_block($is_sticky, $logo_lr_spacing, $a_logos, $esc_blog_name);
								echo sprintf("%s", $printed_logo_2);
							}else{ ?>
								<h1 class='header_site_title'><?php echo esc_html(get_bloginfo( 'name' )) ?></h1>
							<?php } ?>
						</div>
				<?php
			}

				if (isset($top_bar_box_text) && !empty($top_bar_box_text)){
					echo "<div id='top_bar_box_text'>$top_bar_box_text</div>";
				}

				$custom_menu = isset($menu_box_override_menu) && $menu_box_override_menu == '1' ? $menu_box_custom_menu : '';

				if ( !empty($menu_locations['header-menu']) || !empty($custom_menu) ) {
				?>
				<div class="header_nav_part">
					<nav class="main-nav-container">
					<?php
						$splited_menu = ($logo_box_position == 'center' && $logo_box_in_menu == '1' && $logo_box_enable) || $logo_box_position == 'center' && $logo_box_enable;

						if( $splited_menu && $menu_box_menu_stripes ){
							echo "<span class='left-stripe'></span>";
						}

						// -----> Menu-Box left icons
						echo '<div class="menu_left_icons">';

							if ($side_panel_place == 'menu_left' && $side_panel_enable) {
								echo "<a href='#' class='side_panel_icon ".esc_attr($side_panel_place)."'></a>";
							}

							if ($this->cws_get_option('woo_cart_place') == 'left') {
								echo class_exists( 'woocommerce' ) ? "<div class='mini-cart'>$woo_mini_icon$woo_mini_cart</div>" : '';
							}

							if(isset($menu_box_search_place) && $menu_box_search_place == 'left'){
								echo "<div class='search_menu'></div>";
							}
	
							if ($menu_box_mobile_place == "left"){
								echo '
								<div data-menu="menu_box" class="mobile_menu_switcher mobile_menu_hamburger mobile_menu_hamburger--htx">
									<div class="mobile_menu_hamburger_wrapper">
										<span></span>
										<span></span>
										<span></span>
									</div>
								</div>
								';
							}
						echo '</div>';

						// -----> Menu-Box
						echo '<div class="menu_main_wrapper">';

							ob_start();
								wp_nav_menu( array(
									'menu_id'  => 'main_menu'.($is_sticky ? '_sticky' : ''),
									'theme_location' => (!empty($custom_menu) ? '' : 'header-menu'),
									'menu' => (!empty($custom_menu) ? $custom_menu : ''),
									'menu_class' => 'main-menu',
									'items_wrap' => '<div class="'.($splited_menu ? 'menu-left-part' : 'no-split-menu').'"><ul id="%1$s" class="%2$s">%3$s</ul></div>',
									'container' => false,
									'walker' => new Vintwood_Walker_Nav_Menu($this)
								) );
							$menu = ob_get_clean();
							echo sprintf("%s", $menu);

						echo "</div>";

						// -----> Menu-Box right icons
						echo '<div class="menu_right_icons">';
							if ($this->cws_get_option('woo_cart_place') == 'right') {
								echo class_exists( 'woocommerce' ) ? "<div class='mini-cart'>$woo_mini_icon$woo_mini_cart</div>" : '';
							}
							if ( isset($menu_box_search_place) && $menu_box_search_place == 'right'){
								echo "<div class='search_menu'></div>";
							}

							if (isset($menu_box_mobile_place) && $menu_box_mobile_place == "right"){
								echo '
								<div data-menu="menu_box" class="mobile_menu_switcher mobile_menu_hamburger mobile_menu_hamburger--htx">
									<div class="mobile_menu_hamburger_wrapper">
										<span></span>
										<span></span>
										<span></span>
									</div>
								</div>
								';
							}

							if ($side_panel_place == 'menu_right' && $side_panel_enable) {
								echo "<a href='#' class='side_panel_icon ".esc_attr($side_panel_place)."'></a>";
							}

						echo '</div>';

						if( $splited_menu && $menu_box_menu_stripes ){
							echo "<span class='right-stripe'></span>";
						}
					?>

					</nav>
				</div>
				<?php
			}
			?>
		</div>
			<div class="<?php echo esc_attr($mobile_menu_box_class); ?>">
				<div class="mobile_menu_container">
					<?php
					ob_start();
						wp_nav_menu( array(
							'theme_location' => (!empty($custom_menu) ? '' : 'header-menu'),
							'menu' => (!empty($custom_menu) ? $custom_menu : ''),
							'menu_id'  => 'mobile_menu'.($is_sticky ? '_sticky' : ''),
							'menu_class' => 'mobile_menu main-menu',
							'container' => false,
							'walker' => new Vintwood_Walker_Nav_Mobile_Menu($this)
						) );
					$mobile_menu = ob_get_clean();
					echo sprintf("%s", $mobile_menu);
					?>
				</div>
			</div>
		</div><!-- /menu_box -->
		<?php
			if(($menu_box_search_place == 'right') || ($menu_box_search_place == 'left')){
				echo "<div class='search_menu_wrap animated'>";
					echo "<div class='search_menu_cont'>";
						echo "<div class='search_back_button'></div>";
						echo "<div class='container'>";
							get_search_form();
						echo '</div>';
					echo '</div>';
				echo '</div>';
			}
		?>

		<?php

		$menu_box_out = '';
		if ($menu_box_enable){
			$menu_box_out = ob_get_clean();
		} else {
			ob_clean();
		}

		if (!$is_sticky){
			$this->header['menu_box'] = $menu_box_out;
		}
		ob_start();
		?>

			</div><!-- header_container -->
		</header><!-- header -->
		<?php
		echo '</div>';
		$after_header_out = ob_get_clean();

		if (!$is_sticky){
			$this->header['after_header'] = $after_header_out;
		}

		if($is_sticky){
			echo sprintf("%s", $before_header_out);
			echo sprintf("%s", $menu_box_out);
			echo sprintf("%s", $after_header_out);
		}
	}

	public function cws_print_logo_block($is_sticky, $logo_lr_spacing, $lg, $blog_name) {
		extract(shortcode_atts( array(
			'logo' => '',
			'mobile' => '',
			'sticky' => '',
			'logo_h' => '',
		), $lg));
		$spacing = !empty( $logo_lr_spacing ) ? " style='{$logo_lr_spacing}'" : '';
		$out = sprintf('<a%s class="logo" href="%s">', '', home_url());
		if ($is_sticky){
			if(!empty($sticky) && is_array($sticky)){
				foreach ($sticky as $key => $value) {
					switch ($key){
						case 'img' :
						$out .= $this->print_if( !empty($sticky[$key]), "<img ".$sticky[$key]." class='logo_sticky' ".$spacing." />");
						break ;
						case 'svg' :
						$out .= "<span class='logo_sticky cws_svg_sticky'>";
						$out .= $sticky[$key];
						$out .= "</span>";
						break ;
					}
				}				
			}
		} else {
			if(!empty($logo)){
				foreach ($logo as $key => $value) {
					switch ($key){
						case 'img' :
						$out .= $this->print_if( !empty($logo[$key]), "<img ".$logo[$key]." ".$logo_h." class='logo_desktop' ".$spacing." />");
						break ;
						case 'svg' :
						$out .= $logo[$key];
						break ;
					}
				}			
			}	
		}

		if(!empty($mobile) && is_array($mobile)){
			foreach ($mobile as $key => $value) {
				switch ($key){
					case 'img' :
					$out .= $this->print_if( !empty($mobile[$key]), "<img ".$mobile[$key]." class='logo_mobile' />");
					break ;
					case 'svg' :
					$out .= "<span class='logo_mobile cws_svg_mobile'>";
					$out .= $mobile[$key];
					$out .= "</span>";
					break ;
				}
			}			
		}

		$out .= '</a>';

		return $out;
	}

	public function cws_get_date_parts () {
		$part_val = array();
		$perm_struct = get_option( 'permalink_structure' );
		if (!empty( $perm_struct )) {
			$part_val['addl_query_args'] = array(
				'year' => get_query_var( 'year' ),
				'monthnum' => get_query_var( 'monthnum' ),
				'day' => get_query_var( 'day' ),
			);
		} else {
			$merge_date = get_query_var( 'm' );
			$match = preg_match( '#(\d{4})?(\d{1,2})?(\d{1,2})?#', $merge_date, $matches );
			$part_val['addl_query_args'] = array(
				'year' => isset( $matches[1] ) ? $matches[1] : '',
				'monthnum' => isset( $matches[2] ) ? $matches[2] : '',
				'day' => isset( $matches[3] ) ? $matches[3] : '',
			);
		}
		return $part_val;
	}

	public function cws_get_date_part ( $part = '' ){
		$part_val = '';
		$p_id = get_queried_object_id();
		$perm_struct = get_option( 'permalink_structure' );
		$use_perms = !empty( $perm_struct );
		$merge_date = get_query_var( 'm' );
		$match = preg_match( '#(\d{4})?(\d{1,2})?(\d{1,2})?#', $merge_date, $matches );
		switch ( $part ){
			case 'y':
				$part_val = $use_perms ? get_query_var( 'year' ) : ( isset( $matches[1] ) ? $matches[1] : '' );
				break;
			case 'm':
				$part_val = $use_perms ? get_query_var( 'monthnum' ) : ( isset( $matches[2] ) ? $matches[2] : '' );
				break;
			case 'd':
				$part_val = $use_perms ? get_query_var( 'day' ) : ( isset( $matches[3] ) ? $matches[3] : '' );
				break;
		}
		return $part_val;
	}

	public function cws_render_top_bar($pid) {
		//Get metaboxes from page
		$top_bar_box = $this->cws_get_meta_option( 'top_bar_box' );
		extract($top_bar_box, EXTR_PREFIX_ALL, 'top_bar_box');

		$header_box = $this->cws_get_meta_option( 'header_box' );
		extract($header_box, EXTR_PREFIX_ALL, 'header_box');

		$logo_box = $this->cws_get_meta_option( 'logo_box' );
		extract($logo_box, EXTR_PREFIX_ALL, 'logo_box');

		$menu_box = $this->cws_get_meta_option( 'menu_box' );
		extract($menu_box, EXTR_PREFIX_ALL, 'menu_box');

		$side_panel = $this->cws_get_meta_option( 'side_panel' );
		extract($side_panel, EXTR_PREFIX_ALL, 'side_panel');		

		$mobile_menu_box_class = 'mobile_menu_wrapper';
		$mobile_menu_box_class .= (!empty($menu_box_enable_mobile) && $menu_box_enable_mobile == '1' ? ' show_on_tablets' : '');

		ob_start();

		if ($top_bar_box_enable) {
			$top_bar_box_text = isset($top_bar_box_text) ? stripslashes($top_bar_box_text) : '';

			$social_links = $woo_mini_cart = $woo_mini_icon = '';
			$show_wpml_header = CWS_WPML_ACTIVE;
			if (CWS_WOO_ACTIVE) {
				$woo_mini_cart = $this->cws_getWooMiniCart();
				$woo_mini_icon = $this->cws_getWooMiniIcon();
			}
			$is_woo_active = class_exists( 'woocommerce' );
			$social_links = $this->cws_render_social_links('top_bar', $top_bar_box_social_place);

			$menu_locations = get_nav_menu_locations();

			if ( $top_bar_box_enable ) {
			$top_bar_box_language_bar_position = $top_bar_box_language_bar ? $top_bar_box_language_bar_position : null;

			echo "<!-- top_bar_box --><div class='top_bar_box".(isset($top_bar_box_border['line']) && $top_bar_box_border['line'] == '1' ? ' border_line' : '')."' id='site_top_panel'>";

				echo "<div class='top_bar_trigger'></div>";

				if( (!isset($top_bar_box_title_styles) || $top_bar_box_title_styles != 1) && !empty($header_box_background_image['src']) && (isset($header_box_rotate_img) && $header_box_rotate_img == true) && !is_front_page() ){
					echo "<div class='top_bar_rotate_img_wrapper'>";
						echo "<img src='". $header_box_background_image['src'] ."' class='top_bar_rotate_img' alt='' />";
					echo "</div>";
				}

				echo "<div class='container".($top_bar_box_wide ? ' wide_container ' : '')."'>";

				echo "<div class='topbar_left_icons'>";

				if ( !empty($social_links) && $top_bar_box_social_place == 'left' ) {
					echo "<div id='top_social_links_wrapper''>";
						echo sprintf("%s", $social_links);
					echo "</div>";
				}

				if ($side_panel_place == 'topbar_left' && $side_panel_enable){
					echo " <div class='side_panel_icon ".esc_attr($side_panel_place)."'></div>";
				}

				if ( $top_bar_box_content_place == 'left' && !empty($top_bar_box_content_items) ){
					echo "<div class='top_bar_box_content_wrapper'>";

					foreach ($top_bar_box_content_items as $key => $value) {

						if( !empty($value['icon']) ){
							$top_bar_box_row_icon = "<i class='".esc_attr($value['icon'])."'></i>";
						}

						if ( !empty($value['url']) ){
							if ( $value['link_type'] != 'link' && !empty($value['link_type']) ){
								echo "<a class='top_bar_box_text' href='".esc_attr($value['link_type']).esc_attr($value['url'])."'>".$top_bar_box_row_icon."<span>".esc_html($value['title'])."</span></a>";
							} elseif ( $value['link_type'] == 'link' ){
								echo "<a class='top_bar_box_text' href='".esc_attr($value['url'])."'>".$top_bar_box_row_icon."<span>".esc_html($value['title'])."</span></a>";
							}
						} else {
							echo "<div class='top_bar_box_text'>".$top_bar_box_row_icon.esc_html($value['title'])."</div>";
						}
					}

					echo "</div>";
				}	

				if ( $show_wpml_header && $top_bar_box_language_bar && $top_bar_box_language_bar_position == 'left') { ?>
					<div class="lang_bar">
						<?php do_action( 'icl_language_selector' ); ?>
					</div>
				<?php }
				
				echo '</div>';

				echo (($show_wpml_header && $top_bar_box_language_bar && $top_bar_box_language_bar_position == 'right') || $side_panel_place == 'topbar_right' || $top_bar_box_social_place === 'right' || ($is_woo_active && $this->cws_get_option('woo_cart_place') == 'top') ) ? "<div class='topbar_right_icons'>" : '' ;?>
			

				<?php
				if ( $top_bar_box_content_place == 'right' && !empty($top_bar_box_content_items) ){
					echo "<div class='top_bar_box_content_wrapper'>";

					foreach ($top_bar_box_content_items as $key => $value) {

						if( !empty($value['icon']) ){
							$top_bar_box_row_icon = "<i class='".esc_attr($value['icon'])."'></i>";
						}


						if ( !empty($value['url']) ){
							if ( $value['link_type'] != 'link' && !empty($value['link_type']) ){
								echo "<a class='top_bar_box_text' href='".esc_attr($value['link_type']).esc_attr($value['url'])."'>".$top_bar_box_row_icon."<span>".esc_html($value['title'])."</span></a>";
							} elseif ( $value['link_type'] == 'link' ){
								echo "<a class='top_bar_box_text' href='".esc_attr($value['url'])."'>".$top_bar_box_row_icon."<span>".esc_html($value['title'])."</span></a>";
							}
						} else {
							echo "<div class='top_bar_box_text'>".$top_bar_box_row_icon.esc_html($value['title'])."</div>";
						}
					}

					echo "</div>";
				}

					if ( !empty($social_links) && $top_bar_box_social_place == 'right' ) {
						echo "<div id='top_social_links_wrapper''>";
							echo sprintf("%s", $social_links);
						echo "</div>";
					}



					if ( ($is_woo_active && $this->cws_get_option('woo_cart_place') == 'top') || ($side_panel_place == 'topbar_right' && $side_panel_enable) || ($menu_box_search_place == 'top') ){
						echo "<div id='top_panel_links'>";
							if($menu_box_search_place == 'top'){
								echo "<div class='row_text_search'>";
									get_search_form();
								echo '</div>';
								echo "<div class='search_icon'></div>";
							}

							if ($is_woo_active && $this->cws_get_option('woo_cart_place') == 'top') {
								echo "<div class='mini-cart'>$woo_mini_icon$woo_mini_cart</div>";
							}
							
							if ($side_panel_place == 'topbar_right' && $side_panel_enable){
								echo "<div class='side_panel_icon ".esc_attr($side_panel_place)."'></a>
									</div>";
							}
						echo '</div>';

					}
					
					if ( $show_wpml_header && $top_bar_box_language_bar && $top_bar_box_language_bar_position == 'right') { ?>
						<div class="lang_bar">
							<?php do_action( 'icl_language_selector' ); ?>
						</div>
					<?php }

					echo (($show_wpml_header && $top_bar_box_language_bar && $top_bar_box_language_bar_position == 'right') || $side_panel_place == 'topbar_right' || $top_bar_box_social_place === 'right' || ($is_woo_active && $this->cws_get_option('woo_cart_place') == 'top') ) ? '</div>' : '';

					echo '</div>';
				?>

				<?php
			echo "</div><!-- /top_bar_box -->";
			}

		}
		return ob_get_clean();
	}
	/* /THEME HEADER */

	// Add menu custom fields
	public function cws_add_custom_nav_fields( $menu_item ) {
		$cws_mb_post = get_post_meta( $menu_item->ID, 'cws_mb_post', true );
		if (isset($cws_mb_post['cws_menu'])) {
			foreach ($cws_mb_post['cws_menu'] as $key => $value) {
				$menu_item->$key = $value;
			}
		}
		return $menu_item;
	}

	// Save menu custom fields
	public function cws_update_custom_nav_fields( $menu_id, $menu_post_id, $args ) {
		if(isset($_POST['cws_menu_options'])) {
			parse_str(urldecode($_POST['cws_menu_options']), $parse_array);
			$save_array = array();
			foreach ($parse_array as $k => $value) {
				list($key, $id) = explode('-', $k);
				if ($id == $menu_post_id) {
					$save_array[$key] = $value;
				}
			}
			update_post_meta( $menu_post_id, 'cws_mb_post', array('cws_menu' => $save_array));
		}
	}

	// Edit menu custom fields
	public function cws_edit_walker( $walker,$menu_id ) {
		return 'Walker_Nav_Menu_Edit_Custom';
	}

	// Add inline style
	public function cws_add_style() {
		$out = $this->cws_theme_header_process_fonts();
		$out .= $this->cws_theme_header_process_colors();
		$out .= $this->cws_theme_header_process_blur();
		$out .= $this->cws_theme_loader();

		// $this->cws_generate_default_css($out); //Uncomment this line if you need regenerate default style sheet
		wp_add_inline_style('empty', $out);
	}

	//Generate default css
	public function cws_generate_default_css($style) {
		global $wp_filesystem;

		$wp_filesystem->put_contents(
		get_template_directory(). '/css/default.css',
			$style,
			FS_CHMOD_FILE
		);
	}

	public function cws_Hex2RGBA( $hex, $opacity = '1' ) {
		$hex = str_replace('#', '', $hex);
		$color = '';

		if(strlen($hex) == 3) {
			$color = hexdec(substr($hex, 0, 1 )) . ',';
			$color .= hexdec(substr($hex, 1, 1 )) . ',';
			$color .= hexdec(substr($hex, 2, 1 )) . ',';
		}
		else if(strlen($hex) == 6) {
			$color = hexdec(substr($hex, 0, 2 )) . ',';
			$color .= hexdec(substr($hex, 2, 2 )) . ',';
			$color .= hexdec(substr($hex, 4, 2 )) . ',';
		}
		$color .= $opacity;
		return "rgba($color)";
	}

	public function cws_theme_youtube_api_init (){
		wp_add_inline_script('yt_player_api', '
			var tag = document.createElement("script");
			tag.src = "https://www.youtube.com/player_api";
			var firstScriptTag = document.getElementsByTagName("script")[0];
			firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);
		');
	}

	public function cws_dbl_to_sngl_quotes ( $content ) {
		return preg_replace( "|\"|", "'", $content );
	}

	public function cws_loading_body_class ( $classes ) {
			$classes[] = '';
			$classes[] .= 'vintwood'.'-new-layout';
			$huge_layout = $this->cws_get_meta_option('boxed')['huge_layout'];
			$huge_layout = isset($huge_layout) ? $huge_layout : '';
			$classes[] .= $huge_layout == 1 ? 'layout_1400' : '';
		return $classes;
	}

	public function cws_custom_search ( $form ) {
		$form = "
		<form method='get' class='search-form' action=' ".site_url()." ' >
			<div class='search_wrapper'>
				<label><span class='screen-reader-text'>".esc_html__( 'Search for:', 'vintwood' )."</span></label>
				<input type='text' placeholder='".esc_attr__( 'Type and press Enter ...', 'vintwood' )."' class='search-field' value='". esc_attr(apply_filters('the_search_query', get_search_query())) ."' name='s'/>
				<input type='submit' class='search-submit' value=' ".esc_attr__( 'FIND', 'vintwood' )." ' />
			</div>
		</form>";

		return $form;
	}

	// Custom filter function to modify default gallery shortcode output
	public function cws_custom_gallery( $output, $attr ) {

		// Initialize
		global $post, $wp_locale;

		// Gallery instance counter
		static $instance = 0;
		$instance++;

		// Validate the author's orderby attribute
		if ( isset( $attr['orderby'] ) ) {
			$attr['orderby'] = sanitize_sql_orderby( $attr['orderby'] );
			if ( ! $attr['orderby'] ) unset( $attr['orderby'] );
		}

		// Get attributes from shortcode
		extract( shortcode_atts( array(
			'order'      => 'ASC',
			'orderby'    => 'menu_order ID',
			'id'         => $post->ID,
			'itemtag'    => 'div',
			'icontag'    => 'div',
			'captiontag' => 'div',
			'columns'    => 3,
			'size'       => 'thumbnail',
			'include'    => '',
			'exclude'    => ''
		), $attr ) );

		wp_enqueue_script( 'fancybox' );

		// Initialize
		$id = intval( $id );
		$attachments = array();
		if ( $order == 'RAND' ) $orderby = 'none';

		if ( ! empty( $include ) ) {

			// Include attribute is present
			$include = preg_replace( '/[^0-9,]+/', '', $include );
			$_attachments = get_posts( array( 'include' => $include, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby ) );

			// Setup attachments array
			foreach ( $_attachments as $key => $val ) {
				$attachments[ $val->ID ] = $_attachments[ $key ];
			}

		} else if ( ! empty( $exclude ) ) {

			// Exclude attribute is present
			$exclude = preg_replace( '/[^0-9,]+/', '', $exclude );

			// Setup attachments array
			$attachments = get_children( array( 'post_parent' => $id, 'exclude' => $exclude, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby ) );
		} else {
			// Setup attachments array
			$attachments = get_children( array( 'post_parent' => $id, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby ) );
		}

		if ( empty( $attachments ) ) return '';

		// Filter gallery differently for feeds
		if ( is_feed() ) {
			$output = "\n";
			foreach ( $attachments as $att_id => $attachment ) $output .= wp_get_attachment_link( $att_id, $size, true ) . "\n";
			return $output;
		}

		// Filter tags and attributes
		$itemtag = tag_escape( $itemtag );
		$captiontag = tag_escape( $captiontag );
		$columns = intval( $columns );
		$itemwidth = $columns > 0 ? round(100 / $columns, 2) : 100;
		$float = is_rtl() ? 'right' : 'left';
		$selector = "gallery-{$instance}";

		// Filter gallery CSS
		$output = apply_filters( 'gallery_style', "
			<!-- see gallery_shortcode() in wp-includes/media.php -->
			<div id='$selector' class='gallery galleryid-{$id}'>"
		);

		// Iterate through the attachments in this gallery instance
		$i = 0;
		foreach ( $attachments as $id => $attachment ) {

			// Attachment link
			$link = isset( $attr['link'] ) && 'file' == $attr['link'] ? wp_get_attachment_link( $id, $size, false, false ) : wp_get_attachment_link( $id, $size, true, false );

			if ( isset($attr['link']) && $attr['link'] == 'none') {
				$link = preg_replace("/<a[^>]*>([^|]*)<\/a>/", "<div>$1</div>", $link);
			}

			// Start itemtag
			$output .= "<{$itemtag} class='gallery-item' style='float: {$float}; width: {$itemwidth}%;'>";

			// icontag
			$output .= "
			<{$icontag} class='gallery-icon'>
				$link
			</{$icontag}>";

			if ( $captiontag && trim( $attachment->post_excerpt ) ) {

				// captiontag
				$output .= "
				<{$captiontag} class='gallery-caption'>
					" . wptexturize($attachment->post_excerpt) . "
				</{$captiontag}>";

			}

			// End itemtag
			$output .= "</{$itemtag}>";

			// Line breaks by columns set
			if($columns > 0 && ++$i % $columns == 0) $output .= '<br style="clear: both">';

		}

		// End gallery output
		$output .= "
			<br style='clear: both;'>
		</div>\n";

		return $output;
	}

	//Allows to filter the output of any WordPress widget
	public function cws_filter_dynamic_sidebar_params( $sidebar_params ) {
		if ( is_admin() ) {
			return $sidebar_params;
		}
		global $wp_registered_widgets;
		$current_widget_id = $sidebar_params[0]['widget_id'];
		$wp_registered_widgets[ $current_widget_id ]['original_callback'] = $wp_registered_widgets[ $current_widget_id ]['callback'];
		$wp_registered_widgets[ $current_widget_id ]['callback'] = array( $this, 'cws_display_widget' );
		return $sidebar_params;
	}

	public function cws_display_widget() {
		global $wp_registered_widgets;
		$original_callback_params = func_get_args();
		$widget_id         = $original_callback_params[0]['widget_id'];
		$original_callback = $wp_registered_widgets[ $widget_id ]['original_callback'];
		$wp_registered_widgets[ $widget_id ]['callback'] = $original_callback;
		$widget_id_base = $original_callback[0]->id_base;
		$sidebar_id     = $original_callback_params[0]['id'];
		if ( is_callable( $original_callback ) ) {
			ob_start();
			call_user_func_array( $original_callback, $original_callback_params );
			$widget_output = ob_get_clean();
			/**
			 * Filter the widget's output.
			 *
			 * @param string $widget_output  The widget's output.
			 * @param string $widget_id_base The widget's base ID.
			 * @param string $widget_id      The widget's full ID.
			 * @param string $sidebar_id     The current sidebar ID.
			 */
			echo apply_filters( 'widget_output', $widget_output, $widget_id_base, $widget_id, $sidebar_id );
		}
	}

	public function cws_filter_widgets( $widget_output, $widget_type, $widget_id, $sidebar_id ) {
		if ($widget_type == 'archives' || $widget_type == 'categories'){
			$widget_output = preg_replace('|<\/a>.*\(|', '<span class="post_count">', $widget_output);
			$widget_output = preg_replace('|(\d)\)|', "$1</span></a>", $widget_output);
		}
		$widget_output = preg_replace('|cws-widget|', 'cws-widget widget-'.esc_attr($widget_type), $widget_output);
	    return $widget_output;
	}
	// --//Allows to filter the output of any WordPress widget

	public function cws_custom_categories_postcount_filter ($count) {
		$count = str_replace('</a> (', '<span class="post_count">', $count);
		$count = str_replace(')', '</span> </a>', $count);
		return $count;
	}

	public function cws_oembed_wrapper( $html, $url, $args ) {
		return !empty( $html ) ? "<div class='cws_oembed_wrapper'>$html</div>" : '';
	}

	public function cws_custom_excerpt_length( $length ) {
		return 1400;
	}

	public function cws_ajaxurl() {
		wp_localize_script('cws_scripts', 'ajaxurl', array(
			'templateDir' => esc_url( get_template_directory_uri() ),
			'url' => admin_url( 'admin-ajax.php' ),
		));		
	}

	public function cws_ajax_redirect() {
		$ajax = isset( $_POST['ajax'] ) ? (bool)$_POST['ajax'] : false;
		if ( $ajax ) {
			$template = isset( $_POST['template'] ) ? $_POST['template'] : '';
			if ( !empty( $template ) ) {
				if ( strpos( $template, '-' ) ) {
					$template_parts = explode( '-', $template );
					if ( count( $template_parts ) == 2 ) {
						get_template_part( $template_parts[0], $template_parts[1] );
					}
					else {
						return;
					}
				}	else {
					get_template_part( $template );
				}
				exit();
			}
		}
		return;
	}

	public function cws_meta_vars() {}

	public function cws_render_gradient ($arrs) {
		$gradient = array(
			'first_color' => (!empty($arrs[ 'first_color' ]) ? $arrs[ 'first_color' ] : ''),
			'second_color' => (!empty($arrs[ 'second_color' ]) ? $arrs[ 'second_color' ] : ''),
			'first_color_opacity' => (!empty($arrs[ 'first_color_opacity' ]) ? $arrs[ 'first_color_opacity' ] : ''),
			'second_color_opacity' => (!empty($arrs[ 'second_color_opacity' ]) ? $arrs[ 'second_color_opacity' ] : ''),
			'type' => (!empty($arrs[ 'type' ]) ? $arrs[ 'type' ] : ''),
			'linear_settings' => (!empty($arrs[ 'linear_settings' ]) ? $arrs[ 'linear_settings' ] : ''),
			'radial_settings' => array(
				'shape_settings' => (!empty($arrs['radial_settings']['shape_settings']) ? $arrs['radial_settings']['shape_settings'] : ''),
				'shape' => (!empty($arrs['radial_settings']['shape']) ? $arrs['radial_settings']['shape'] : ''),
				'size_keyword' => (!empty($arrs['radial_settings']['size_keyword']) ? $arrs['radial_settings']['size_keyword'] : ''),
				'size' => (!empty($arrs['radial_settings']['size']) ? $arrs['radial_settings']['size'] : ''),
				)
		);
		return $gradient;
	}

	public function cws_get_grid_shortcodes() {
		return array( 'cws-row', 'col', 'cws-widget' );
	}

	public function cws_get_special_post_formats() {
		return array( 'aside' );
	}

	public function cws_is_special_post_format() {
		global $post;
		$sp_post_formats = $this->cws_get_special_post_formats();
		if ( isset($post) ) {
			return in_array( get_post_format(), $sp_post_formats );
		} else{
			return false;
		}
	}

	public function cws_post_format_mark() {
		global $post;
		$out = '';
		if ( isset( $post ) ) {
			$pf = get_post_format();
			$post_format_icons = array(
				'aside' => 'bullseye',
				'gallery' =>'bullseye',
				'link' => 'chain',
				'image' => 'image',
				'quote' => 'quote-lef',
				'status' => 'flag',
				'video' => 'video-camer',
				'audio' => 'music',
				'chat' => 'wechat',
			);
			$icon = '';
			if (isset($post_format_icons[$pf])) {
				$icon = $post_format_icons[$pf];
			}
			$out = "<i class='fa fa-$icon'></i> $pf";
		}
		return $out;
	}

	public function cws_strip_grid_shortcodes($text) {
		$shortcodes = function_exists('vintwood_get_grid_shortcodes') ? vintwood_get_grid_shortcodes () : "";
		$find = array();
		if(!empty($shortcodes)){
			foreach ( $shortcodes as $shortcode ) {
				$shortcode = preg_replace( "|-|", "\-", $shortcode );
				$op_tag = "|\[.*" . $shortcode . ".*\]|";
				$cl_tag = "|\[/.*" . $shortcode . ".*\]|";
				array_push( $find, $op_tag, $cl_tag );
			}			
		}

		$text = preg_replace( $find, '', $text );
		return $text;
	}

	// Check if WooCommerce is active
	public function cws_woo_ajax_remove_from_cart() {
		global $woocommerce;

		$woocommerce->cart->set_quantity( $_POST['remove_item'], 0 );

		$ver = explode( '.', WC_VERSION );

		if ( $ver[1] == 1 && $ver[2] >= 2 ) :
			$wc_ajax = new WC_AJAX();
			$wc_ajax->get_refreshed_fragments();
		else :
			woocommerce_get_refreshed_fragments();
		endif;

		die();
	}

	public function cws_woo_header_add_to_cart_fragment( $fragments ) {
		ob_start();
		?>
			<i class='woo_mini-count flaticon-shopcart-icon-vintwood'><?php echo ((WC()->cart->cart_contents_count > 0) ?  '<span>' . WC()->cart->cart_contents_count .'</span>' : '') ?></i>
		<?php
		$fragments['.woo_mini-count'] = ob_get_clean();

		ob_start();
		woocommerce_mini_cart();
		$fragments['div.woo_mini_cart'] = ob_get_clean();
		return $fragments;
	}

	public function cws_woo_related_products_args( $args ) {
		$args['posts_per_page'] = $this->cws_get_option( 'woo-resent-num-products' ); // 4 related products
		$args['columns'] = 3; // arranged in 2 columns
		return $args;
	}

	/************** JAVASCRIPT VARIABLES INIT **************/
	public function cws_js_vars_init() {
		//Get metaboxes from page
		$sticky_menu = $this->cws_get_meta_option( 'sticky_menu' );
		extract($sticky_menu, EXTR_PREFIX_ALL, 'sticky_menu');

		$sticky_menu_enable = $sticky_menu_enable == '1' ? 'true' : 'false';

		$is_user_logged = is_user_logged_in();
		$logged_var = $is_user_logged ? 'true' : 'false';

		$sticky_sidebars = $this->cws_get_option('sticky_sidebars') == '1' ? 'true' : 'false';
		$page_loader = $this->cws_get_option('show_loader') == '1' ? 'true' : 'false';
		$animation_curve_menu = $this->cws_get_option('animation_curve_menu');
		$animation_curve_scrolltop = $this->cws_get_option('animation_curve_scrolltop');
		$animation_curve_speed = $this->cws_get_option('animation_curve_speed');

		//Don't forget boolean value without ''
		wp_add_inline_script('cws_scripts', '
			var is_user_logged = '.esc_js($logged_var).','.
			'sticky_menu_enable = '.esc_js($sticky_menu_enable).','.
			'sticky_menu_mode = "'.esc_js($sticky_menu_mode).'",'.
			'sticky_sidebars = '.esc_js($sticky_sidebars).','.
			'page_loader = '.esc_js($page_loader).','.
			'animation_curve_menu = "'.esc_js($animation_curve_menu).'",'.
			'animation_curve_scrolltop = "'.esc_js($animation_curve_scrolltop).'",'.
			'animation_curve_speed = '.esc_js($animation_curve_speed).','.
			'use_blur = false;');
	}
	/************** \JAVASCRIPT VARIABLES INIT **************/

	/******************** TYPOGRAPHY ********************/
	// MENU FONT HOOK
	private function cws_print_font_css($font_array) {
		$out = '';
		foreach ($font_array as $style=>$v) {
			if ($style != 'font-weight' && $style != 'font-sub' && $style != 'font-type') {
				$out .= !empty($v) ? $style .':'.$v.';' : '';
			}
		}
		return $out;
	}

	private function cws_print_menu_font() {
		ob_start();
		do_action( 'menu_font_hook' );
		return ob_get_clean();
	}

	public function cws_menu_font_action() {
		$out = '';
		$font_array = $this->cws_get_meta_option('menu-font');

		$slider_settings = $this->cws_get_meta_option( 'slider_override' );

		// ==========> Menu Fonts from ThemeOptions -> Typography
		if (isset($font_array)) {

			// -----> Default menu font
			$out .= 
			"
				.main-menu .menu-item a,
				.main-menu .menu-item .cws_megamenu_item_title,
				.main-menu .cws_megamenu_item .widgettitle
				{
					". esc_attr($this->cws_print_font_css($font_array)) .";
				}
			";

			// -----> Default menu-box icons
			$out .= 
			"
				.main-nav-container .mini-cart .woo_icon,
				.main-nav-container .search_menu:before
				{
					color: ". esc_attr($font_array['color']) .";
				}
			";
			$out .= 
			"
				.mobile_menu_hamburger span,
				.side_panel_icon span
				{
					background-color: ". esc_attr($font_array['color']) .";
				}
			";
		}

		// ==========> Menu Font Colors from ThemeOptions -> Menu / Metaboxes -> Menu
		if( !empty($this->cws_get_meta_option('menu_box')['font_color']) ){
			$menu_box_font_color = $this->cws_get_meta_option('menu_box')['font_color'];
		}
		if( !empty($this->cws_get_meta_option('menu_box')['font_color_hover']) ){
			$menu_box_font_color_hover = $this->cws_get_meta_option('menu_box')['font_color_hover'];
		}

		$p_type = get_post_type();

		if ( !$this->cws_is_woo() && 'cws_' !== substr($p_type, 0, 4) ){

			if( isset($menu_box_font_color) ){
				// ----------> Customized menu font
				$out .= 
				"
					.main-menu > .menu-item > a,
					.main-menu > .menu-item > .cws_megamenu_item_title
					{
						color: ". esc_attr($menu_box_font_color) .";
					}
				";
				
				if( !empty($this->cws_get_meta_option('menu_box')['font_color']) && $this->cws_get_meta_option('MB_menu') == 1 ){
					$out .=
					"
						.menu_box .main-nav-container ul.sub-menu{
							border-color: ". esc_attr($menu_box_font_color) .";
						}
					";
				}

				// ----------> Customized menu-box icons
				$out .= 
				"
					.main-nav-container .mini-cart .woo_icon,
					.main-nav-container .search_menu:before
					{
						color: ". esc_attr($menu_box_font_color) .";
					}
				";
				$out .= 
				"
					.mobile_menu_hamburger span,
					.side_panel_icon span
					{
						background-color: ". esc_attr($menu_box_font_color) .";
					}
				";

				if( !empty($this->cws_get_meta_option('menu_box')['font_color']) && $this->cws_get_meta_option('MB_menu') == 1 ){
					$out .=
					"
						.menu_box .main-nav-container .sub-menu .cws_megamenu_item .widgettitle:before,
						.menu_box .main-nav-container .sub-menu .cws_megamenu_item .widgettitle:after{
							background-color: ". esc_attr($menu_box_font_color) .";
						}
					";
				}
			}

			if( isset($menu_box_font_color_hover) ){
				// ----------> Customized menu font on hover
				$out .=
				"
					.main-menu > .menu-item:hover > a,
					.main-menu > .menu-item.current_page_item > a,
					.main-menu > .menu-item.current_page_ancestor > a,
					.main-menu > .menu-item.current-menu-item > a,
					.main-menu > .menu-item.current-menu-item > .cws_megamenu_item_title,
					.main-menu > .menu-item:hover > .cws_megamenu_item_title
					{
						color: ". esc_attr($menu_box_font_color_hover) .";
					}
				";

				$out .=
				"
					.main-menu > .menu-item:hover > a,
					.main-menu > .menu-item.current_page_item > a,
					.main-menu > .menu-item.current_page_ancestor > a,
					.main-menu > .menu-item.current-menu-item > a,
					.main-menu > .menu-item.current-menu-item > .cws_megamenu_item_title,
					.main-menu > .menu-item:hover > .cws_megamenu_item_title
					{
						filter: drop-shadow(2px 2px 0px ".$this->cws_Hex2RGBA($menu_box_font_color_hover, .27).");
					}
				";

				// ----------> Customized menu-box icons on hover
				$out .= 
				"
					.main-nav-container .mini-cart .woo_icon:hover,
					.main-nav-container .search_menu:hover:before
					{
						color: ". esc_attr($menu_box_font_color_hover) .";
					}
				";
				$out .= 
				"
					.side_panel_icon:hover span
					{
						background-color: ". esc_attr($menu_box_font_color_hover) .";
					}
				";
			}
		}

		// ==========> Menu Font Colors from ThemeOptions -> Header -> (Customize -> Override Menu`s Font Color)
		if( !empty($this->cws_get_meta_option('header')['override_menu_color']) ){
			$menu_box_font_color = $this->cws_get_meta_option('header')['override_menu_color'];
		}
		if( !empty($this->cws_get_meta_option('header')['override_menu_color_hover'])){
			$menu_box_font_color_hover = $this->cws_get_meta_option('header')['override_menu_color_hover'];
		}

		if ($this->cws_get_meta_option( 'header' )['customize'] == '1' ) {

			if( isset($menu_box_font_color) ){
				// ----------> Customized menu font
				$out .= 
				"
					.header_zone .main-menu > .menu-item > a,
					.header_zone .main-menu > .menu-item > .cws_megamenu_item_title
					{
						color: ". esc_attr($menu_box_font_color) .";
					}
				";

				if( !empty($this->cws_get_meta_option('header')['override_menu_color']) ){
					$out .=
					"
						.header_zone .menu_box .main-nav-container ul.sub-menu{
							border-color: ". esc_attr($menu_box_font_color) .";
						}
					";
				}

				// ----------> Customized menu-box icons
				$out .= 
				"
					.header_zone .main-nav-container .mini-cart .woo_icon,
					.header_zone .main-nav-container .search_menu:before
					{
						color: ". esc_attr($menu_box_font_color) .";
					}
				";

				$out .= 
				"
					.header_zone .mobile_menu_hamburger span,
					.header_zone .side_panel_icon span
					{
						background-color: ". esc_attr($menu_box_font_color) .";
					}
				";

				if( !empty($this->cws_get_meta_option('header')['override_menu_color']) ){
					$out .=
					"
						.header_zone .menu_box .main-nav-container .sub-menu .cws_megamenu_item .widgettitle:before,
						.header_zone .menu_box .main-nav-container .sub-menu .cws_megamenu_item .widgettitle:after{
							background-color: ". esc_attr($menu_box_font_color) .";
						}
					";
				}
			}

			if( isset($menu_box_font_color_hover) ){
				// ----------> Customized menu font on hover
				$out .=
				"
					.header_zone .main-menu > .menu-item:hover > a,
					.header_zone .main-menu > .menu-item.current_page_item > a,
					.header_zone .main-menu > .menu-item.current_page_ancestor > a,
					.header_zone .main-menu > .menu-item.current-menu-item > a,
					.header_zone .main-menu > .menu-item.current-menu-item > .cws_megamenu_item_title,
					.header_zone .main-menu > .menu-item:hover > .cws_megamenu_item_title
					{
						color: ". esc_attr($menu_box_font_color_hover) .";
					}
				";

				$out .=
				"
					.header_zone .main-menu > .menu-item:hover > a,
					.header_zone .main-menu > .menu-item.current_page_item > a,
					.header_zone .main-menu > .menu-item.current_page_ancestor > a,
					.header_zone .main-menu > .menu-item.current-menu-item > a,
					.header_zone .main-menu > .menu-item.current-menu-item > .cws_megamenu_item_title,
					.header_zone .main-menu > .menu-item:hover > .cws_megamenu_item_title
					{
						filter: drop-shadow(2px 2px 0px ".$this->cws_Hex2RGBA($menu_box_font_color_hover, .27).");
					}
				";

				// ----------> Customized menu-box icons on hover
				$out .= 
				"
					.header_zone .main-nav-container .mini-cart .woo_icon:hover,
					.header_zone .main-nav-container .search_menu:hover:before
					{
						color: ". esc_attr($menu_box_font_color_hover) .";
					}
				";
				$out .= 
				"
					.header_zone .side_panel_icon:hover span
					{
						background-color: ". esc_attr($menu_box_font_color_hover) .";
					}
				";
			}
		}

		// ==========> Menu Font Colors from ThemeOptions -> WooCommerce -> Menu
		if( !empty($this->cws_get_option('woo_menu_font_color')) ){
			$menu_box_font_color = $this->cws_get_option('woo_menu_font_color');
		}
		if( !empty($this->cws_get_option('woo_menu_font_color_hover')) ){
			$menu_box_font_color_hover = $this->cws_get_option('woo_menu_font_color_hover');
		}

		if ($this->cws_get_option( 'woo_customize_menu' ) == '1' && $this->cws_is_woo() ) {

			if( isset($menu_box_font_color) ){
				// ----------> Customized menu font
				$out .= 
				"
					.woocommerce .main-menu > .menu-item > a,
					.woocommerce .main-menu > .menu-item > .cws_megamenu_item_title
					{
						color: ". esc_attr($menu_box_font_color) .";
					}
				";

				if( !empty($this->cws_get_option('woo_menu_font_color')) ){
					$out .=
					"
						.woocommerce .menu_box .main-nav-container ul.sub-menu{
							border-color: ". esc_attr($menu_box_font_color) .";
						}
					";
				}

				// ----------> Customized menu-box icons
				$out .= 
				"
					.woocommerce .main-nav-container .mini-cart .woo_icon,
					.woocommerce .main-nav-container .search_menu:before
					{
						color: ". esc_attr($menu_box_font_color) .";
					}
				";
				$out .= 
				"
					.woocommerce .mobile_menu_hamburger span,
					.woocommerce .side_panel_icon span
					{
						background-color: ". esc_attr($menu_box_font_color) .";
					}
				";
				if( !empty($this->cws_get_option('woo_menu_font_color')) ){
					$out .=
					"
						.woocommerce .menu_box .main-nav-container .sub-menu .cws_megamenu_item .widgettitle:before,
						.woocommerce .menu_box .main-nav-container .sub-menu .cws_megamenu_item .widgettitle:after{
							background-color: ". esc_attr($menu_box_font_color) .";
						}
					";
				}
			}

			if( isset($menu_box_font_color_hover) ){
				// ----------> Customized menu font on hover
				$out .=
				"
					.woocommerce .main-menu > .menu-item:hover > a,
					.woocommerce .main-menu > .menu-item.current_page_item > a,
					.woocommerce .main-menu > .menu-item.current_page_ancestor > a,
					.woocommerce .main-menu > .menu-item.current-menu-item > a,
					.woocommerce .main-menu > .menu-item.current-menu-item > .cws_megamenu_item_title,
					.woocommerce .main-menu > .menu-item:hover > .cws_megamenu_item_title
					{
						color: ". esc_attr($menu_box_font_color_hover) .";
					}
				";

				$out .=
				"
					.woocommerce .main-menu > .menu-item:hover > a,
					.woocommerce .main-menu > .menu-item.current_page_item > a,
					.woocommerce .main-menu > .menu-item.current_page_ancestor > a,
					.woocommerce .main-menu > .menu-item.current-menu-item > a,
					.woocommerce .main-menu > .menu-item.current-menu-item > .cws_megamenu_item_title,
					.woocommerce .main-menu > .menu-item:hover > .cws_megamenu_item_title
					{
						filter: drop-shadow(2px 2px 0px ".$this->cws_Hex2RGBA($menu_box_font_color_hover, .27).");
					}
				";

				// ----------> Customized menu-box icons on hover
				$out .= 
				"
					.woocommerce .main-nav-container .mini-cart .woo_icon:hover,
					.woocommerce .main-nav-container .search_menu:hover:before
					{
						color: ". esc_attr($menu_box_font_color_hover) .";
					}
				";
				$out .= 
				"
					.woocommerce .side_panel_icon:hover span
					{
						background-color: ". esc_attr($menu_box_font_color_hover) .";
					}
				";
			}
		}

		echo sprintf("%s", $out);
	}

	// \MENU FONT HOOK

	// HEADER FONT HOOK

	private function cws_print_header_font () {
		ob_start();
		do_action( 'header_font_hook' );
		return ob_get_clean();
	}

	public function cws_header_font_action () {
		$out = '';
		$font_array = $this->cws_get_option('header-font');
		$header_box = $this->cws_get_meta_option( 'header_box' );
		$header_box_page_title_size = $header_box['page_title_size'];

		if (isset($font_array)) {
			$out .=  "
			.news .ce_title a.link_post,
			.cws_portfolio_items .post_info.outside .title_part a,
			.gallery-icon + .gallery-caption,
			.vc_general.vc_tta.vc_tta-tabs .vc_tta-tab .vc_tta-title-text,
			.cta_subtitle,
			.cta_title,
			.cta_desc_subtitle,
			.tribe-nav-label,
			.cta_offer + .cta_banner .cws_vc_shortcode_cta_banner .cws_vc_shortcode_banner_title,
			.cta_offer + .cta_banner .cws_vc_shortcode_cta_banner .cws_vc_shortcode_banner_price,
			.cta_offer + .cta_banner .cws_vc_shortcode_cta_banner .cws_vc_shortcode_banner_desc,
			.cws_vc_shortcode_pricing_plan .pricing_plan_price .price,
			form.wpcf7-form > div:not(.wpcf7-response-output)>p,
			.page_title .page_excerpt, 
			.page_content > main .grid_row.cws_tribe_events #tribe-bar-form label,
			form.wpcf7-form > div:not(.wpcf7-response-output)>label,
			#tribe-events-footer .tribe-events-sub-nav .tribe-events-nav-next a, #tribe-events-header .tribe-events-sub-nav .tribe-events-nav-next a,
			#tribe-events-footer .tribe-events-sub-nav li a, #tribe-events-header .tribe-events-sub-nav li a,
			blockquote,
			.cws_service_extra_button,
			.cws_service_item .cws_service_title,
			.cws_staff_post .cws_staff_post_terms,
			blockquote,
			.nav_post_links,
			.comment_info_header .comment-meta .author-name,
			.comments-area .comment_list .comment-reply-link,
			.cws-widget .about_me .user_position,
			.cws-widget .recentcomments,
			.cws_vc_shortcode_pb .cws_vc_shortcode_pb_title,
			.widget_shopping_cart_content .buttons .button,
			.price .amount,
			.cws_portfolio_nav li a,
			.cws_staff_nav li a,
			.tribe_events_nav  li a,
			.cws_classes_nav li a,
			.vc_tta.vc_general.vc_tta-accordion .vc_tta-panel-title > a > .vc_tta-title-text,
			.cws_custom_button,
			.vc_pie_chart .vc_pie_chart_value,
			.vintwood_banner .banner_wrapper .banner_offer,
			.pagination .page_links > *,
			.news .item .post_media .inline_date,
			.news.single .grid .item .single_post_meta .post_tags a,
			.news.single .grid .item .single_post_meta .post_category a,
			.dropcap,
			ul.products li.product .add_to_cart_button, ul.products li.product .added_to_cart,
			.comments-area .comment-respond .comment-form .form-submit input,
			.button:not(.add_to_cart_button),
			.add_large_button,
			table.shop_table.cart .cart_item .product-name a,
			input.cws_submit,
			.cws-widget ul.menu li .cws_megamenu_item_title,
			.cws-widget ul li a,
			.cws-widget #wp-calendar caption,
			.widget-cws-banner .banner_desc,
			.cws-widget .tagcloud a,
			.mini-cart .cart_list li > a,
			.cws-widget .post_item .post_title a,
			.cws_info_wrapper .cws_info_title,
			.header_logo_part,
			.cws-widget .recentcomments .comment-author-link > a,
			.date-content span:first-child,
			.single .cws_img_navigation.carousel_nav_panel span,
			.search .news .ce_title a
			{
			font-family: ". esc_attr($font_array['font-family']) .";
			}";
			$out .= '
			.ce_title, figcaption .title_info h3, .vintwood-new-layout .cws-widget .widget-title,.woo_product_post_title.posts_grid_post_title, .comments-area .comment-reply-title,
			.woocommerce div[class^="post-"] h1.product_title.entry-title, .page_title.customized .title h1, .bg_page_header .title h1, .slash-icon, .widgettitle, .page_title .title
			{
				'. esc_attr($this->cws_print_font_css($font_array)) .'
			}';
			$out .= '
			.testimonial .author figcaption,
			.testimonial .quote .quote_link:hover,
			.pagination a,
			.widget-title,
			.ce_toggle.alt .accordion_title:hover,
			.pricing_table_column .price_section,
			.comments-area .comments_title,
			.comments-area .comment-meta,
			.comments-area .comment-reply-title,
			.comments-area .comment-respond .comment-form input:not([type=\'submit\']),
			.comments-area .comment-respond .comment-form textarea,
			.benefits_container .cws_textwidget_content .link a:hover,
			.cws_portfolio_fw .title,
			.cws_portfolio_fw .cats a:hover,
			.msg_404,
			.cws_portfolio_items .post_info.outside .title_part a,
			.nav_post_links .sub_title,
			blockquote
			{
			color:' . esc_attr($font_array['color']) . ';
			}';
			$out .=  "
			h1, h2, h3, h4, h5, h6
			{
			font-family: ". esc_attr($font_array['font-family']) .";
			color: ". esc_attr($font_array['color']) .";
			}";
			$out .=  "
			.item .post_title a,
			.news .ce_title a,
			.news .ce_title a:hover
			{
			color: ". esc_attr($font_array['color']) .";
			}";
			$out .= "
			.page_title .title h1
			{
			font-size: ".esc_attr($header_box_page_title_size)."px;
			}";
			$out .= '
			.posts_grid.cws_portfolio_posts_grid h2.widgettitle
			{
			font-size:' . esc_attr($font_array['font-size']) . ';
			}';

		}
		echo sprintf("%s", $out);
	}

	// \HEADER FONT HOOK

	// BODY FONT HOOK

	private function cws_print_body_font () {
		ob_start();
		do_action( 'body_font_hook' );
		return ob_get_clean();
	}

	public function cws_body_font_action () {
		$out = '';
		$font_array = $this->cws_get_option('body-font');
		if (isset($font_array)) {
		$out .= '
		body
		{
		'. esc_attr($this->cws_print_font_css($font_array)) .'
		}';
		$out .= '
		.news .ce_title a,
		.tribe-this-week-events-widget .tribe-this-week-widget-horizontal .entry-title,.tribe-this-week-events-widget  .tribe-this-week-widget-horizontal .entry-title a,
		form.wpcf7-form > div:not(.wpcf7-response-output)>p span,
		form.wpcf7-form > div:not(.wpcf7-response-output)>label span,
		.tribe-events-schedule h2,
		.vintwood-new-layout .tooltipster-light .tooltipster-content,
		.cws-widget .recentcomments a
		{
		font-family:'. esc_attr($font_array['font-family']) . ';
		}';
		$out .= '
		.cws-widget ul li>a,
		.comments-area .comments_nav.carousel_nav_panel a,
		.cws_img_navigation.carousel_nav_panel a,
		.cws_portfolio_fw .cats a,
		.cws_portfolio .categories a,
		.row_bg .ce_accordion.alt .accordion_title,
		.row_bg .ce_toggle .accordion_title,
		.mini-cart .woo_mini_cart,
		.thumb_staff_posts_title a,
		.tribe-this-week-widget-wrapper .tribe-this-week-widget-day .duration, .tribe-this-week-widget-wrapper .tribe-this-week-widget-day .tribe-venue,
		.thumb_staff_posts_title,
		#mc_embed_signup input,
		.mc4wp-form .mc4wp-form-fields input,
		form.wpcf7-form > div:not(.wpcf7-response-output) .select2-selection--single .select2-selection__rendered,.cws-widget #wp-calendar tbody td a:hover,
		.tribe-mini-calendar .tribe-events-has-events div[id*="daynum-"] a:hover,
		form.wpcf7-form > div:not(.wpcf7-response-output) .select2-selection--single .select2-selection__arrow b,
		.vc_general.vc_tta.vc_tta-tabs .vc_tta-tabs-list .vc_tta-tab, .tabs.wc-tabs li,
		#tribe-events-content .tribe-events-calendar div[id*=tribe-events-event-] h3.tribe-events-month-event-title,
		.tribe-events-calendar td.tribe-events-past div[id*=tribe-events-daynum-],
		.tribe-events-calendar td.tribe-events-present div[id*=tribe-events-daynum-],
		.tribe-events-calendar td.tribe-events-past div[id*=tribe-events-daynum-]>a,
		#tribe-events-content .tribe-events-calendar div[id*=tribe-events-event-] h3.tribe-events-month-event-title a,
		.tribe-events-calendar td div[id*=tribe-events-daynum-] > a,
		.posts_grid .portfolio_item_post.under_img .cws_portfolio_posts_grid_post_content
		{
		color:' . esc_attr($font_array['color']) . ';
		}';
		$out .= '
		.mini-cart .woo_mini_cart,
		body input, body  textarea, body select
		{
		font-size:' . esc_attr($font_array['font-size']) . ';
		}';
		$out .= '
		body input,
		body textarea,
		.cws_textmodule .cws_textmodule_icon,
		.cws_textmodule_content p
		{
		line-height:' . esc_attr($font_array['line-height']) . ';
		}';
		$out .='
		.cws-widget ul li > a span.post_count:before{
			background-color: '. esc_attr($font_array['color']) .';
		}
		';
		$out .= '
		abbr
		{
		border-bottom-color:' . esc_attr($font_array['color']) . ';
		}';
		$fs_match = preg_match( '#(\d+)(.*)#', $font_array['font-size'], $fs_matches );
		$lh_match = preg_match( '#(\d+)(.*)#', $font_array['line-height'], $lh_matches );
		if ( $fs_match && $lh_match ) {
			$fs_number = (int)$fs_matches[1];
			$fs_units = $fs_matches[2];
			$lh_number = (int)$lh_matches[1];
			$lh_units = $lh_matches[2];
		$out .= "
		.dropcap
		{
		font-size:" . esc_attr($fs_number * 3 . $fs_units).";
		line-height:" . esc_attr($lh_number * 3 . $lh_units).";
		}";
		}
		}
		echo sprintf("%s", $out);
	}

	// \BODY FONT HOOK

	private function cws_print_helper_font () {
		ob_start();
		do_action( 'body_helper_hook' );
		return ob_get_clean();
	}

	// HELPER FONT HOOK
	public function cws_body_helper_action() {
		$out = '';
		$font_array = $this->cws_get_option('helper-font');

		if (isset($font_array)) {
			$out .= '
				.top_bar_box_content_wrapper,
				.page_title .bread-crumbs span,
				.page_title .bread-crumbs a,
				.page_title .bread-crumbs,
				.cws_textmodule_banner,
				.cws_pricing_plan.highlighted .pricing_title:before,
				.cws_portfolio_post_terms,
				.pricing_plan_price .main_price_part,
				.posts_grid .item a.category-block span.category-label,
				.item.cws_staff_post .cws_staff_post_info .cws_staff_post_terms,
				.woo_banner_wrapper .woo_banner .woo_banner_text,
				.cws-widget ul li > a span.post_count,
				.cws_categories_widget .category-block .category-label,
				.cws-widget.widget-cws-recent-posts .post_item .post_cat,
				.cws_vc_shortcode_milestone_desc,
				.cws_vc_shortcode_pb .pb_bar_title{
					font-family:'. esc_attr($font_array['font-family']) . ';
				}
				';
		}

		echo preg_replace('/\s+/',' ', $out);
	}
	// \HELPER FONT HOOK

	public function cws_process_fonts() {
		$out = $this->cws_print_menu_font();
		$out .= $this->cws_print_header_font();
		$out .= $this->cws_print_body_font();
		$out .= $this->cws_print_helper_font();
		return $out;
	}

	//****************************** CWS PRINT FUNCTIONS ******************************
	public function cws_print_gradient( $settings, $selectors = '',  $use_extra_rules = false) {
		global $cws_theme_funcs; 

		extract( shortcode_atts( array(
			'c1' => VINTWOOD_FIRST_COLOR,
			'c2' => VINTWOOD_SECOND_COLOR,
			'op1' => '100',
			'op2' => '100',
			'type' => 'linear',
			'linear' => array(),
			'radial' => array(),
			'custom_css' => '',
		), $settings));

		if (!empty($custom_css)) return $custom_css;

		$c1 = $this->cws_Hex2RGBA($c1,(int)$op1/100);
		$c2 = $this->cws_Hex2RGBA($c2,(int)$op2/100);

		$out = '';
		$rules = '';
		switch ($type) {
			case 'linear':
				$angle = isset($linear['angle']) ? $linear['angle'] : 0;
				$rules .= "background:-webkit-linear-gradient(".esc_attr($angle)."deg, ".esc_attr($c1).", ".esc_attr($c2).");";
				$rules .= "background:-o-linear-gradient(".esc_attr($angle)."deg, ".esc_attr($c1).", ".esc_attr($c2).");";
				$rules .= "background:-moz-linear-gradient(".esc_attr($angle)."deg, ".esc_attr($c1).", ".esc_attr($c2).");";
				$rules .= "background:linear-gradient(".esc_attr($angle)."deg, ".esc_attr($c1).", ".esc_attr($c2).");";
				break;
			case 'radial':
				extract( shortcode_atts( array(
					'shape_type' => 'simple',
					'shape' => 'ellipse',
					'keyword' => 'farthest-corner',
					'size' => ''
				), $radial));

				switch ($shape_type) {
					case 'simple':
						$rules .= "background:-webkit-radial-gradient(".esc_attr($shape)." ".esc_attr($c1).", ".esc_attr($c2).");";
						$rules .= "background:-o-radial-gradient(".esc_attr($shape)." ".esc_attr($c1).", ".esc_attr($c2).");";
						$rules .= "background:-moz-radial-gradient(".esc_attr($shape)." ".esc_attr($c1).", ".esc_attr($c2).");";
						$rules .= "background:radial-gradient(".esc_attr($shape)." ".esc_attr($c1).", ".esc_attr($c2).");";
						break;
					case 'exteneded':
						$rules .= "background:-webkit-radial-gradient( ".esc_attr($size)." ".esc_attr($size_keyword)." ".esc_attr($c1).", ".esc_attr($c2).");";
						$rules .= "background:-o-radial-gradient( ".esc_attr($size)." ".esc_attr($size_keyword)." ".esc_attr($c1).", ".esc_attr($c2).");";
						$rules .= "background:-moz-radial-gradient( ".esc_attr($size)." ".esc_attr($size_keyword)." ".esc_attr($c1).", ".esc_attr($c2).");";
						$rules .= "background:radial-gradient(".esc_attr($size_keyword)." at ".esc_attr($size)." ".esc_attr($c1).", ".esc_attr($c2).");";
						break;
			}
				break;
		}

		if ( !empty( $rules ) ) {
			$printf_rules = !empty($selectors) ? '%s{%s}' : '%s%s';
			$out .= sprintf($printf_rules, $selectors, $rules);
			if ( $use_extra_rules ) {
				$border_extra_rules = 'border-color:transparent;-moz-background-clip:border;-webkit-background-clip: border;background-clip:border-box;-moz-background-origin:border;-webkit-background-origin:border;background-origin:border-box;background-repeat:no-repeat;';
				$transition_extra_rules = '-webkit-transition-property:background,color,border-color,opacity;-webkit-transition-duration:0s,0s,0s,0.6s;-o-transition-property:background,color,border-color,opacity;-o-transition-duration:0s,0s,0s,0.6s;-moz-transition-property:background,color,border-color,opacity;-moz-transition-duration:0s,0s,0s,0.6s;transition-property:background,color,border-color,opacity;transition-duration:0s,0s,0s,0.6s;';
				$out .= sprintf($printf_rules, $selectors, $border_extra_rules);
				$out .= sprintf($printf_rules, $selectors, 'color: #fff !important;');
				$selectors_wth_pseudo = str_replace( ':hover', '', $selectors );
				$out .= sprintf($printf_rules, $selectors_wth_pseudo, $transition_extra_rules);
			}
		}
		return $out;
	}

	public function cws_print_paddings($paddings = array()) {
		if ($paddings && is_array($paddings)) {
			$out = '';
			foreach ( $paddings as $key => $value ){
				if ( !empty( $value ) || $value == '0' ){
					$out .= "padding-".esc_attr($key). ": " . esc_attr($value) . "px;";
				}
			}
		}
		return $out;
	}

	public function cws_print_margins($margins = array()) {
		if ($margins && is_array($margins)) {
			$out = '';
			foreach ( $margins as $key => $value ){
				if ( !empty( $value ) || $value == '0' ){
					$out .= "margin-".esc_attr($key). ": " . esc_attr($value) . "px;";
				}
			}
		}
		return $out;
	}	

	public function cws_print_background($props = null) {
		if ($props && is_array($props)) {
			$out = '';
			foreach ($props as $key => $value) {
				if ('image' === $key) {
					$out .= 'background-'.esc_attr($key).':';
					$out .= sprintf('url(%s);', esc_url($value['src']));
				}
			}
			$out .=  $this->cws_print_css_keys($props, 'background-');
		}
		return $out;
	}

	public function cws_print_border($box) {
		$out = '';
		if ( !empty($box) && !empty($box['border_box']) ){
			$width_type_color = sprintf('%spx %s %s', $box['width'], $box['type'], $box['color']);
			foreach ($box['border_box'] as $key => $value) {
				$out .= "border-".esc_attr($value).":".esc_attr($width_type_color).";";
			}
		}
		return $out;
	}

	public function cws_print_overlay($o){
		$bg_styles = $type = '';
		if(!empty($o)){
			extract($o);
		}
		
		switch ($type) {
			case 'gradient':
				$bg_styles = $this->cws_print_gradient($gradient);
				$bg_styles .= "opacity:".esc_attr($opacity).";";
				break;
			case 'color':
				$bg_styles = $this->cws_print_rgba('background-color', $color, $opacity);
				break;
		}
		return $bg_styles;
	}

	public function cws_print_rgba($prefix, $color, $op = 100){
		return sprintf('%s:rgba(%s,%s);', $prefix, $this->cws_Hex2RGB($color), (int)$op/100);
	}

	// prints associative array keys with prefix and value
	public function cws_print_keys($a, $prefix = '') {
		$out = '';
		if (is_array($a)) {
			foreach ($a as $key => $value) {
				if (!is_array($key) && !empty($value)) {
					$out .= $prefix . $key . '="' . $value . '" ';
				}
			}
		}
		return trim($out);
	}

	public function cws_print_css_keys($a, $prefix = '', $suffix = '') {
		$out = '';
		if (is_array($a)) {
			foreach ($a as $key => $value) {
				if (!is_array($a[$key]) && !empty($value)) {
					if ('position' === $key) {
						$out .= $prefix . $key . ':' . $this->cws_print9positions($value) . $suffix . ';';
					} else {
						$out .= $prefix . $key . ':' . $value . $suffix . ';';
					}
				}
			}
		}
		return trim($out);
	}

	public function cws_print_parallaxify_atts($opts, &$atts, &$layer_atts) {
		if (!empty($opts)) {
			$atts .= $this->cws_print_keys($opts, 'data-');
			$layer_atts .= 'position:absolute;z-index:1;left:-'.esc_attr($opts['limit-y']).'px;right:-'.esc_attr($opts['limit-y']).'px;top:-'.esc_attr($opts['limit-x']).'px;bottom:-'.esc_attr($opts['limit-x']).'px;';
		}
	}	

	public function cws_print_border_box($box) {
		$out = $type_color = '';
		if ( !empty($box) && !empty($box['border']) ){
			if(isset($box['border_type']) && isset($box['border_color'])){
				$type_color = sprintf('%s %s', $box['border_type'], $box['border_color']);
			}
			
			if(isset($box['border']) && is_array($box['border'])){
				foreach ($box['border'] as $key => $value) {
					$out .= "border-{$value}:1px {$type_color};";
				}				
			}
		}
		return $out;
	}

	public function cws_print_img_html($img, $img_args, &$img_height = null) {
		$src = '';
		$img_h = 0;

		if ($img && !is_array($img) ) {
			$attach = wp_get_attachment_image_src( $img, 'full' );
			if ($attach) {
				list($src, $width, $height) = $attach;
				$img = array('src'=> $src, 'width' => $width, 'height' => $height, 'is_high_dpi' => '1', 'id' => $img);
			} else {
				return $src;
			}
		} else if ($img && !isset($img['is_high_dpi'] ) ) {
			$img['is_high_dpi'] = '1';
		} else if (empty($img['width']) && empty($img['height'])) {
			$attach = wp_get_attachment_image_src( $img['id'], 'full' );
			if ($attach) {
				list($src, $width, $height) = $attach;
				$img['width'] = $width;
				$img['height'] = $height;
			}
		}

		$is_high_dpi = (isset($img['is_high_dpi']) && $img['is_high_dpi'] == '1');

		$img_source = isset($img['id']) ? $img['id'] : $img['src'];

		if ( $is_high_dpi ) {
			if ( empty($img_args['width']) && empty($img_args['height']) ) {
				if (isset($img['width']) && isset($img['height'])) {

					$img_args = array(
						'width' => floor( (int) $img['width'] / 2 ),
						'height' => floor( (int) $img['height'] / 2 ),
						'crop' => true
					);
				}
			}

			$thumb_obj = cws_thumb( $img_source, $img_args );

			if ($thumb_obj) {
				$img_h = !empty($img_args["height"]) ? $img_args["height"] : '';
				$thumb_path_hdpi = !empty($thumb_obj[3]) ? " src='". esc_url( $thumb_obj[0] ) ."' data-at2x='" . esc_attr( $thumb_obj[3] ) ."'" : " src='". esc_url( $thumb_obj[0] ) . "' data-no-retina";
				$img_alt = get_post_meta($img_source, '_wp_attachment_image_alt', true); 
				$src = $thumb_path_hdpi ." alt='" . (!empty($img_alt) ? $img_alt : get_the_title($img_source)) . "'";
			}
		} else {			
			if ( empty($img_args['width']) && empty($img_args['height']) ) {
				if (isset($img['width']) && isset($img['height'])) {
					$img_args = array(
						'width' => floor( (int) $img['width'] ),
						'height' => floor( (int) $img['height'] ),
						'crop' => true
					);
				}
			}
			$thumb_obj = cws_thumb( $img_source, $img_args );

			if ($thumb_obj) {
				$img_h = !empty($img_args["height"]) ? $img_args["height"] : '';
				$thumb_path_hdpi = !empty($thumb_obj[3]) ? " src='". esc_url( $thumb_obj[0] ) ."' data-at2x='" . esc_attr( $thumb_obj[3] ) ."'" : " src='". esc_url( $thumb_obj[0] ) . "' data-no-retina";
				$img_alt = get_post_meta($img_source, '_wp_attachment_image_alt', true); 
				$src = $thumb_path_hdpi ." alt='" . (!empty($img_alt) ? $img_alt : get_the_title($img_source)) . "'";
			}
		}

		if ($img_height) {
			$img_height = $img_h;
		}
		return $src;
	}

	public function cws_print_svg_html($img, $img_args, &$img_height = null) {

		$svg = '';
		if ( !empty($img_args['width']) && !empty($img_args['height']) ) {
			$svg .= "<span class='cws_logotype_svg' style='width:{$img_args['width']}px;height:{$img_args['height']}px'>";
		}
		if(!empty($img['src'])){
			global $wp_filesystem;
			WP_Filesystem();
			$upload_dir = wp_upload_dir();
			$file_parts = pathinfo($img['src']);	
			$dir = str_replace($upload_dir['baseurl'], "", $file_parts['dirname']);
			$dir = $wp_filesystem->find_folder($upload_dir['basedir'] . $dir);			  		
		    $file = trailingslashit($dir) . $file_parts['basename'];
		    if($wp_filesystem->exists($file)){
		    	$svg .= $wp_filesystem->get_contents($file);
		    }
		}

		if ( !empty($img_args['width']) && !empty($img_args['height']) ) {
			$svg .= "</span>";
		}
		return $svg;
	}

	public function cws_print9positions($pos){
		$bg_pos = '';
		for ($i=0; $i<2;$i++) {
			$c = $pos[$i];
			switch ($c) {
				case 'l':
					$bg_pos .= ' left';
					break;
				case 'r':
					$bg_pos .= ' right';
					break;
				case 'c':
					$bg_pos .= ' center';
					break;
				case 'b':
					$bg_pos .= ' bottom';
					break;
				case 't':
					$bg_pos .= ' top';
					break;
			}
		}
		return trim($bg_pos);
	}	
	//****************************** //CWS PRINT FUNCTIONS ******************************

	public function cws_process_blur() {
		//Get metaboxes from page
		$header_box = $this->cws_get_meta_option( 'header_box' );
		extract($header_box, EXTR_PREFIX_ALL, 'header_box');

		if (isset($header_box_use_blur) && $header_box_use_blur == '1'){
			$out = '.pic.blured img.blured-img,
					.item .pic_alt .img_cont>img.blured-img,
					.pic .img_cont>img.blured-img,
					.cws-widget .post_item .post_thumb:hover img,
					.cws_img_frame:hover img,
					.cws-widget .portfolio_item_thumb .pic .blured-img{
						-webkit-filter: blur('.esc_attr($header_box_blur_intensity).'px);
							-moz-filter: blur('.esc_attr($header_box_blur_intensity).'px);
							-o-filter: blur('.esc_attr($header_box_blur_intensity).'px);
							-ms-filter: blur('.esc_attr($header_box_blur_intensity).'px);
							filter: blur('.esc_attr($header_box_blur_intensity).'px);
					}';
			return $out;
		}
	}

	public function cws_loader() {
		$cws_loader = $this->cws_get_option('overlay_loader_color');
		if(!empty($cws_loader)){
			$out = '#cws_page_loader .inner:before{
				    background-image: -webkit-linear-gradient(top, '.$cws_loader.', '.$cws_loader.');
	    			background-image: -moz-linear-gradient(top, '.$cws_loader.', '.$cws_loader.');
	   				background-image: linear-gradient(to bottom, '.$cws_loader.', '.$cws_loader.');
			}';		
			$out .= '#cws_page_loader .inner:after{
				    background-image: -webkit-linear-gradient(top, #ffffff, '.$cws_loader.');
	    			background-image: -moz-linear-gradient(top, #ffffff, '.$cws_loader.');
	   				background-image: linear-gradient(to bottom, #ffffff, '.$cws_loader.');
			}';
			return $out;			
		}

	}	

	/* THEME FOOTER */
	public function cws_page_footer (){
		//Get metaboxes from page
		$footer = $this->cws_get_meta_option( 'footer' );
		extract($footer, EXTR_PREFIX_ALL, 'footer');

		$instagram_feed_content = '';

		if ($footer_instagram_feed == '1') {
			$instagram_feed_content = do_shortcode(wp_specialchars_decode($footer_instagram_feed_shortcode, ENT_QUOTES));
		}

		$footer_class = 'page_footer';
		$footer_class .= ($footer_ripped == '1' ? ' ripped_footer' : '');
		$footer_class .= (isset($footer_border['line']) && $footer_border['line'] == '1' ? ' border_line' : '');
		$footer_class .= empty( $footer_sidebar ) || !is_active_sidebar( $footer_sidebar ) ? ' empty_footer' : '';
		$footer_class .= $footer_instagram_feed == '1' ? (($footer_instagram_feed_full_width == '1' ) ? ' instagram_feed instagram_feed_full_width' : ' instagram_feed') : '';

		if ($footer_instagram_feed == '1' || (!empty( $footer_sidebar ) && is_active_sidebar( $footer_sidebar )) ){

			echo "<footer class='".esc_attr($footer_class)."'>";
				echo "<div class='bg_layer'></div>";

				if ( !empty($footer_pattern["src"]) ) {
					echo "<div class='footer-pattern'></div>";
				}

				if ($footer_instagram_feed == '1' && $footer_instagram_feed_full_width == '1') echo sprintf("%s", $instagram_feed_content);
				echo "<div class='container".($footer_wide == '1' ? ' wide_container' : '')."'>";
					echo "<div class='footer_container col-".esc_attr($footer_layout)."'>";
						if ($footer_instagram_feed == '1' && $footer_instagram_feed_full_width == '0') echo sprintf("%s", $instagram_feed_content);

						$GLOBALS['footer_is_rendered'] = true;
						if ( !empty( $footer_sidebar ) && is_active_sidebar( $footer_sidebar ) ) {
							dynamic_sidebar( $footer_sidebar );
						}
						unset( $GLOBALS['footer_is_rendered'] );
					echo '</div>';
				echo '</div>';
			echo "</footer>";
		}

		$footer_copyrights_text = stripslashes($footer_copyrights_text);
		$social_links = '';
		$social_links = $this->cws_render_social_links('copyrights');
		$show_wpml_footer = CWS_WPML_ACTIVE;

		$flags = '';
		if ( function_exists('wpml_init_language_switcher') ) {
			global $wpml_language_switcher;
			$slot = $wpml_language_switcher->get_slot( 'statics', 'footer' );
			$template = $slot->get_model();
			$flags = $slot->is_enabled();
		}

		$menu_locations = get_nav_menu_locations();

		ob_start();

		if ( !empty( $footer_copyrights_text ) ) {
			echo "<div class='copyrights' >$footer_copyrights_text</div>";
		}	

		$custom_menu = isset($footer_override_menu) && $footer_override_menu == '1' && !empty($footer_custom_menu) ? $footer_custom_menu : '';

		if ( !empty( $show_wpml_footer ) ) {
			echo "<div class='copyrights_panel'>";
				echo "<div class='copyrights_panel_wrapper'>";
					echo !empty( $social_links ) ? $social_links : '';
					$class_wpml = '';
					if(isset($template['template']) && !empty($template['template'])){
						if($template['template'] == 'wpml-legacy-vertical-list'){
							$class_wpml = 'wpml_language_switch lang_bar '. esc_attr($template['template']);
						}
						else{
							$class_wpml = 'wpml_language_switch horizontal_bar '.esc_attr($template['template']);
						}
					} else{
						$class_wpml = 'lang_bar';
					}
					ob_start();
						do_action( 'wpml_footer_language_selector');
					$wpml_footer_result = ob_get_clean();

					if ( $show_wpml_footer && !empty($flags) && !empty($wpml_footer_result) ) : ?>
						<div class="<?php echo esc_attr($class_wpml);?>">
							<?php
							echo sprintf("%s", $wpml_footer_result);
							?>
						</div>
					<?php endif;
				echo '</div>';
			echo '</div>';
		}
		
		$copyrights_content = ob_get_clean();

		$copyrights_area_class = 'copyrights_area';

		if ( !empty( $copyrights_content ) ) {
			echo "<div class='".esc_attr($copyrights_area_class)."'>";
				echo "<div class='container ".($footer_wide == '1' ? ' wide_container' : '')."'>";
					echo "<div class='copyrights_container".(isset($this->cws_get_option('social')['location']) && is_array($this->cws_get_option('social')['location']) && !in_array('copyrights', $this->cws_get_option('social')['location']) ? ' a-center': '')."'>";
						echo sprintf("%s", $copyrights_content);
					echo '</div>';
				echo '</div>';
			echo '</div>';
		}

		echo (isset($this->cws_get_meta_option('boxed')['layout']) && $this->cws_get_meta_option('boxed')['layout'] == '1') ? '</div>' : '';
	}
	/* END THEME FOOTER */

	/******************** \TYPOGRAPHY ********************/

	public function cws_layout_class ($classes=array()) {
		$menu_box = $this->cws_get_meta_option( 'menu_box' );
		if (!empty($menu_box['enable_mobile']) && $menu_box['enable_mobile'] == '1'){
			array_push( $classes, 'show_mobile_menu' );
		}

		//Boxed layout
		$boxed_enable = $this->cws_get_meta_option('MB_boxed') == '1';
		if ($boxed_enable) {
			array_push( $classes, 'override_boxed_layout' );
			array_push( $classes, 'layout_meta' );
		} else {
			array_push( $classes, 'wide' );
		}

		//Check if mobile
		if (wp_is_mobile()){
			array_push( $classes, 'cws_wp_mobile' );
		}

		return $classes;
	}

	public function cws_widgets_init() {
		$sidebars = $this->cws_get_option('sidebars');
		$sidebars = isset($sidebars) ? $sidebars :
		array(
			array('title' => 'Footer'),
			array('title' => 'Blog Right'),
			array('title' => 'Page Right'),
		); //Check default

		if (!empty($sidebars) && function_exists('register_sidebars')) {
			foreach ($sidebars as $sb) {
				if ($sb && !empty($sb['title'])) {
					register_sidebar( array(
						'name' => $sb['title'],
						'id' => strtolower(preg_replace("/[^a-z0-9\-]+/i", "_", esc_attr($sb['title']) )),
						//Uncomment this line to add divider to widgets
						'before_widget' => '<div class="cws-widget">',
						'after_widget' => '</div>',
						'before_title' => '<div class="widget-title"><div class="inherit-wt">',
						'after_title' => '</div></div>',
					));
				}
			}
		}
	}

	public function cws_theme_reset_styles() {
		wp_enqueue_style('reset', VINTWOOD_URI . '/css/reset.css');
	}

	public function cws_theme_enqueue_styles() {
		if(is_admin() && !is_shortcode_preview()) {
			return;
		}
		wp_register_style( 'empty', false );
		wp_enqueue_style( 'empty' );
		$styles =	array(
			'layout' => 'layout.css',
			'fancybox' => 'jquery.fancybox.css',
			'select2_init' => 'select2.css',
			'animate' => 'animate.css',
		);

		foreach($styles as $key=>$sc){
			wp_enqueue_style( $key, VINTWOOD_URI . '/css/' . $sc);
		}

		$cwsfi = get_option('cwsfi');
		if (!empty($cwsfi) && isset($cwsfi['css'])) {
			wp_enqueue_style( 'cwsfi-css', $cwsfi['css']);
		} else {
			wp_enqueue_style( 'cws_flaticon', VINTWOOD_URI . '/fonts/flaticon/flaticon.css' );
		};

		wp_enqueue_style( 'font-awesome', VINTWOOD_URI . '/fonts/font-awesome/font-awesome.css' );
		wp_enqueue_style( 'cws_iconpack', VINTWOOD_URI . '/fonts/cws-iconpack/flaticon.css' );

		$is_custom_color = $this->cws_get_option('is-custom-color');
		if ($is_custom_color != '1') {
			$style = $this->cws_get_option('stylesheet');
			if (!empty($style)) {
				wp_enqueue_style( 'style-color', VINTWOOD_URI . '/css/' . $style . '.css' );
			}
		}
		wp_enqueue_style( 'cws_main', VINTWOOD_URI . '/css/main.css' );
	}

	public function cws_enqueue_theme_stylesheet () {
		wp_enqueue_style( 'style', get_stylesheet_uri() );
	}

	public function cws_admin_init( $hook ) {
		$this->cws_read_options();
		wp_enqueue_style('admin-css', VINTWOOD_URI . '/core/css/mb-post-styles.css' );
		wp_enqueue_style('wp-color-picker');
		wp_enqueue_script('custom-admin', VINTWOOD_URI . '/core/js/custom-admin.js', array( 'jquery' ) );

		$cwsfi = get_option('cwsfi');
		if (!empty($cwsfi) && isset($cwsfi['css'])) {
			wp_enqueue_style( 'cwsfi-css', $cwsfi['css']);
		}else{
			wp_enqueue_style( 'flaticon', VINTWOOD_URI . '/fonts/flaticon/flaticon.css' );
		};

		if (('toplevel_page_Vintwood' == $hook) || ('toplevel_page_VintwoodChildTheme' == $hook)) {
			wp_enqueue_style( 'cws-redux-style' , VINTWOOD_URI . '/core/css/cws-redux-style.css' );
		}
	}

	public function cws_register_fonts () {
		vintwood_render_fonts_url ();
		$gf_url = esc_url( vintwood_render_fonts_url () );
		wp_enqueue_style( '', $gf_url );
	}

	public function cws_after_setup_theme() {
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support(' widgets ');
		add_theme_support( 'title-tag' );
		add_theme_support( 'html5', array( 'search-form', 'comment-form', 'comment-list' ) );
		add_theme_support( 'post-formats', self::$cws_theme_config['post-formats'] );

		// Add Gutenberg Compatibility
		add_theme_support( 'align-wide' );		

		$nav_menus = self::$cws_theme_config['nav-menus'];
		register_nav_menus($nav_menus);

		add_theme_support( 'woocommerce' );

		add_theme_support( 'custom-background', array(
			'wp-head-callback' => 'cws_custom_background',
			'default-color'    => '616262',
			'default-repeat'         => 'no-repeat',
			'default-position-x'     => 'center',
			'default-position-y'     => 'top',
			'default-size'           => 'contain',
			'default-attachment'     => 'scroll',
		));

		$user = wp_get_current_user();
		$user_nav_adv_options = get_user_option( 'managenav-menuscolumnshidden', get_current_user_id() );
		if ( is_array($user_nav_adv_options) ) {
			$css_key = array_search('css-classes', $user_nav_adv_options);
			if (false !== $css_key) {
				unset($user_nav_adv_options[$css_key]);
				update_user_option($user->ID, 'managenav-menuscolumnshidden', $user_nav_adv_options,	true);
			}
		}

		add_editor_style();
	}

	// THEME COLOR HOOK

	private function cws_print_theme_color() {
		ob_start();
		do_action( 'theme_color_hook' );
		return ob_get_clean();
	}

	public function cws_theme_color_action() {
		$out = '';

		$background = $this->cws_get_meta_option('theme-background-color');
		$first_color = $this->cws_get_meta_option('theme-first-color');
		$second_color = $this->cws_get_meta_option('theme-second-color');
		$second_hex_color = $this->cws_get_meta_option('theme-second-color');
		$helper_color = $this->cws_get_meta_option('theme-helper-color');

		global $wp_filesystem;
		if( empty( $wp_filesystem ) ) {
			require_once( ABSPATH .'/wp-admin/includes/file.php' );
			WP_Filesystem();
		}

		$file = get_template_directory() . '/css/theme-color.css';
		if ( $wp_filesystem->exists($file) ) {
			$file = $wp_filesystem->get_contents( $file );
				$colors = array();
				$colors[0] = '|#theme-color-1#|';
				$colors[1] = '|#theme-color-2#|';
				$colors[2] = '|#theme-color-3#|';
				$colors[3] = '|#theme-hex-color-2#|';
				$replace = array();
				$replace[0] = $this->cws_Hex2RGB($first_color);
				$replace[1] = $this->cws_Hex2RGB($second_color);
				$replace[2] = $this->cws_Hex2RGB($helper_color);
				$replace[3] = $second_hex_color;
				$new_css = preg_replace($colors, $replace, $file);
				$out .= $new_css;
		}

		$result = $out;
		$result .= "
			.cws_pricing_plan .pricing_title:before,
			.cws_pricing_plan .pricing_title:after,
			.cws_pricing_plan.highlighted .price_row_info,
			.cws_pricing_plan.highlighted .cws_custom_button,
			.cws_service_icon_wrapper .cws_service_icon,
			.cws_service_top_part .cws_service_title,
			.item.cws_staff_post .cws_staff_post_info .cws_staff_post_title a,
			.item.cws_staff_post .cws_staff_post_info .cws_staff_post_title .no_link,
			.testimonial.style_2 .testimonial_name,
			.news .item .post_media .inline_date .day,
			.comment_info_header .comment-meta .author-name,
			.news.posts_grid_1 .item:not(.format-link):not(.format-quote) .post_title a,
			.news.posts_grid_medium .item:not(.format-link):not(.format-quote) .post_title a,
			.news.posts_grid_small .item:not(.format-link):not(.format-quote) .post_title a,
			.grid_row.single_related .item .post_title a,
			.grid_row.related_portfolio .item .post_title a,
			.woo_banner_wrapper .woo_banner .woo_banner_text,
			.wc-tabs > li.active > a,
			#main .cws-widget .widget-title .inherit-wt,
			.cws-widget .tagcloud a:hover,
			.cws-widget .tagcloud a:hover:before,
			.footer_container .cws-widget ul.menu li >a:after,
			.cws-widget .recentcomments .comment-author-link > a,
			.cws-widget .recentcomments .comment-author-link,
			.cws_info_wrapper .cws_info_title,
			.date-content span:first-child,
			.cws_pricing_plan .pricing_plan_title{
				color: ".$background.";
			}

			body,
			.cws_pricing_plan.highlighted .cws_custom_button:before,
			.cws_pricing_plan.highlighted .cws_custom_button:after,
			.cws_service_icon_wrapper:after,
			.vintwood_banner .banner_wrapper .icon,
			.item.cws_staff_post .cws_staff_post_media .cws_staff_photo:after,
			.post_single .cws_staff_post_media .cws_staff_photo:before,
			.mini-cart .woo_mini_cart,
			form.theme_bg input,
			form.theme_bg textarea,
			.news .item.sticky-post,
			.main-nav-container .sub-menu{
				background-color: ".$background.";
			}
			
			.cws_pricing_plan.highlighted .cws_custom_button,
			.cws_pricing_plan.highlighted .pricing_plan_content,
			.cws_pricing_plan.highlighted .pricing_plan_price .main_price_part,
			.cws_service_icon_wrapper .cws_service_icon,
			.cws_vc_shortcode_sc_carousel.custom_border .cws_wrapper,
			.posts_grid.cws_portfolio_posts_grid .item .item_content .post_media .pic:before{
				border-color: ".$background.";
			}
		";
		echo sprintf("%s", $result);
	}

	public function cws_theme_rgba_color () {
		$out = '';
		$font_array = $this->cws_get_option('theme-first-color');
		$rgb_color = $this->cws_Hex2RGB( $font_array );
		$rgb_color = esc_attr($rgb_color);

		$lighter_rgba_color = $rgb_color .  ",1";

		echo preg_replace('/\s+/',' ', $out);
	}

	//****************************** CWS CUSTOM STYLES FUNCTIONS ******************************
	public function cws_custom_sticky_menu_styles_action () {

		//Get metaboxes from page
		$sticky_menu = $this->cws_get_meta_option( 'sticky_menu' );
		extract($sticky_menu, EXTR_PREFIX_ALL, 'sticky_menu');

		$sticky_menu_style = sprintf('rgba(%s,%s)', $this->cws_Hex2RGB( $sticky_menu_background_color ), $sticky_menu_background_opacity / 100);
		$sticky_menu_border_style = '';
		if( isset($sticky_menu_border) && !empty($sticky_menu_border) ){
			$sticky_menu_border_style = $this->cws_print_border($sticky_menu_border);
		}

		ob_start();

		if ( $sticky_menu_enable == '1' ){

			if( !empty($sticky_menu_style) ){
				echo "
					.sticky_header .header_cont .header_container .menu_box{
						background-color: ". esc_attr($sticky_menu_style) .";
					}
				";
			}

			if( !empty($sticky_menu_border_style) ){
				echo "
					.sticky_header .header_cont .header_container .menu_box{
						".$sticky_menu_border_style."
					}
				";
			}

			if( !empty($sticky_menu_font_color) ){
				// ----------> Customized menu font
				echo "
					.sticky_header .main-menu > .menu-item > a,
					.sticky_header .main-menu > .menu-item > .cws_megamenu_item_title
					{
						color: ". esc_attr($sticky_menu_font_color) .";
					}
				";

				// ----------> Customized menu-box icons
				echo "
					.sticky_header .main-nav-container .mini-cart .woo_icon,
					.sticky_header .main-nav-container .search_menu:before
					{
						color: ". esc_attr($sticky_menu_font_color) .";
					}
				";
				echo "
					.sticky_header .side_panel_icon span
					{
						background-color: ". esc_attr($sticky_menu_font_color) .";
					}
				";
			}

			if( !empty($sticky_menu_font_color_hover) ){
				// ----------> Customized menu font on hover
				echo "
					.sticky_header .main-menu > .menu-item:hover > a,
					.sticky_header .main-menu > .menu-item.current_page_item > a,
					.sticky_header .main-menu > .menu-item.current-menu-item > a,
					.sticky_header .main-menu > .menu-item.current-menu-item > .cws_megamenu_item_title,
					.sticky_header .main-menu > .menu-item.current_page_ancestor > a,
					.sticky_header .main-menu > .menu-item:hover > .cws_megamenu_item_title
					{
						color: ". esc_attr($sticky_menu_font_color_hover) .";
					}
				";

				echo "
					.sticky_header .main-menu > .menu-item:hover > a,
					.sticky_header .main-menu > .menu-item.current_page_item > a,
					.sticky_header .main-menu > .menu-item.current-menu-item > a,
					.sticky_header .main-menu > .menu-item.current-menu-item > .cws_megamenu_item_title,
					.sticky_header .main-menu > .menu-item.current_page_ancestor > a,
					.sticky_header .main-menu > .menu-item:hover > .cws_megamenu_item_title
					{
						filter: drop-shadow(2px 2px 0px ".$this->cws_Hex2RGBA($sticky_menu_font_color_hover, .27).");
					}
				";

				// ----------> Customized menu-box icons on hover
				echo "
					.sticky_header .main-nav-container .mini-cart .woo_icon:hover,
					.sticky_header .main-nav-container .search_menu:hover:before
					{
						color: ". esc_attr($sticky_menu_font_color_hover) .";
					}
				";
				echo "
					.sticky_header .side_panel_icon:hover span
					{
						background-color: ". esc_attr($sticky_menu_font_color_hover) .";
					}
				";
			}

		}
		echo ob_get_clean();
	}

	public function cws_custom_header_styles_action () {
		//Get metaboxes from page
		$header_styles = '';
		$header = $this->cws_get_meta_option( 'header' );
		extract($header, EXTR_PREFIX_ALL, 'header');

		if ( isset($header_spacings) ){
			foreach ( $header_spacings as $key => $value ){
				if ( !empty( $value ) || $value == '0' ){
					$header_styles .= "padding-".esc_attr($key) . ": " . esc_attr($value) . "px;";
				}
			}
		}

		$header_styles .= isset($header_background_image['image']['src']) && !empty($header_background_image['image']['src']) ? $this->cws_print_background($header_background_image) : '';
		$header_overlay_styles = isset($header_overlay) ? "style='".esc_attr($this->cws_print_overlay($header_overlay))."'" : '';

		$styles = '';
		if ( isset( $header_order ) ) {
			$count = count($header_order);
			foreach ($header_order as $key => $value){
				if ( !empty($value) && !in_array( $value['val'], array('drop_zone_start', 'drop_zone_end', 'before_header', 'after_header') ) ){
					$z_index = $count-$key;
					$styles .= esc_attr(".header_wrapper_container .".esc_attr($value['val'])."{z-index:".esc_attr($z_index).";} ");
				}
			}
		}
		ob_start();
		echo sprintf("%s", $styles);

		if (isset($header_background_image['image']['src']) && !empty($header_background_image['image']['src']) && $header_customize == '1'){
			?>	
			.header_zone{
				<?php echo esc_attr($header_styles) ?>;
			}
			<?php
		}

		if ($header_customize == '1' && $header_overlay['type'] != 'none'){
			?>			
			.header_overlay{
				<?php echo esc_attr($header_overlay_styles) ?>;
			}
			<?php
		}

		echo ob_get_clean();		
	}

	public function cws_custom_top_bar_styles_action () {
		$top_bar_box_style = '';
		//Get metaboxes from page
		$top_bar_box = $this->cws_get_meta_option( 'top_bar_box' );
		extract($top_bar_box, EXTR_PREFIX_ALL, 'top_bar_box');

		if( isset($top_bar_box_title_styles) && $top_bar_box_title_styles == 1 ){
			$top_bar_box_style = 'background-color:'.sprintf('rgba(%s,%s);', $this->cws_Hex2RGB( $top_bar_box_background_color ), $top_bar_box_background_opacity / 100);
		}
		$top_bar_box_style .= isset($top_bar_box_border) ? $this->cws_print_border($top_bar_box_border) : '';
		$top_bar_box_padding = '';

		if ( isset($top_bar_box_spacings) ){
			foreach ( $top_bar_box_spacings as $key => $value ){
				if ( !empty( $value ) || $value == '0' ){
					$top_bar_box_padding .= "padding-".esc_attr($key). ": " . esc_attr($value) . "px;";

					if($key == 'top'){
						$top_bar_padding_top = $value;
					} else {
						$top_bar_padding_bottom = $value;
					}
				}
			}
		}

		ob_start();

		if( isset($top_bar_box_custom_pattern) && !empty($top_bar_box_custom_pattern) ){
			echo "
				#site_top_panel:before{
					background-image: url('".$top_bar_box_custom_pattern['src']."');
				}
			";
		}

		if( !empty($top_bar_box_pattern_opacity) ){
			echo "
				#site_top_panel:before{
					opacity: ". ($top_bar_box_pattern_opacity / 100) .";
				}
			";
		}

		if( !empty($top_bar_box_background_color) ){
			echo "
				.top_bar_trigger:before{
					border-color: ".esc_attr($top_bar_box_background_color)." transparent transparent transparent;
				}
			";
		}

		if( !empty($top_bar_padding_top) || !empty($top_bar_padding_bottom) ){
			echo "
				#site_top_panel #top_panel_links:before{
					height: calc(100% - ".esc_attr($top_bar_padding_top)."px - ". esc_attr($top_bar_padding_bottom) ."px);
					top: <?php echo esc_attr($top_bar_padding_top); ?>px;
				}
			";
		}

		if( !empty($top_bar_box_padding) ){
			echo "
				#site_top_panel{
					".esc_attr($top_bar_box_padding)."
				}
			";
		}

		if( !empty($top_bar_box_style) ){
			echo "
				.header_wrapper_container .top_bar_box{
					".esc_attr($top_bar_box_style)."
				}
			";
		}

		if ($this->cws_get_meta_option('header')['customize'] == '1'){
			$top_bar_box_font_color = $this->cws_get_meta_option('header')['override_topbar_color'];
			$top_bar_box_hover_font_color = $this->cws_get_meta_option('header')['override_topbar_color_hover'];
		}

		if( !empty($top_bar_box_font_color) ){
			echo "
				.top_bar_box_content_wrapper,
				.top_bar_box_content_wrapper a,
				#top_panel_links .row_text_search .search-field,
				#top_panel_links .row_text_search .search-field::placeholder,
				#top_panel_links .search_icon:before,
				#top_panel_links .mini-cart .woo_icon:before,
				#top_panel_links .side_panel_icon:before{
					color: ".esc_attr($top_bar_box_font_color).";
				}
			";

			echo "
				#top_social_links_wrapper a{
					color: ".esc_attr($top_bar_box_font_color)." !important;
				}
			";

			echo "
				#site_top_panel .topbar_right_icons > * + *:not(:empty):after{
					background-color: ".esc_attr($top_bar_box_font_color).";
				}
			";
		}

		if( !empty($top_bar_box_hover_font_color) ){
			echo "
				.top_bar_box_content_wrapper span:hover,
				#top_panel_links .search_icon:hover:before,
				#top_panel_links .mini-cart .woo_icon:hover:before,
				#top_panel_links .side_panel_icon:hover:before{
					color: ".esc_attr($top_bar_box_hover_font_color).";
				}
			";

			echo "
				.top_bar_box_content_wrapper a.top_bar_box_text span:before{
					background-color: ".esc_attr($top_bar_box_hover_font_color).";
				}
			";

			echo "
				#top_social_links_wrapper a:hover{
					color: ".esc_attr($top_bar_box_hover_font_color)." !important;
				}
			";
		}

		echo ob_get_clean();
	}	

	public function cws_custom_logo_box_styles_action(){
		//Get metaboxes from page
		$logo_box = $this->cws_get_meta_option( 'logo_box' );	
		extract($logo_box, EXTR_PREFIX_ALL, 'logo_box');

		$logo_style = '';
		$logo_lr_spacing = $logo_tb_spacing = '';
		$logo_style .= $this->cws_print_css_keys($logo_box_margin, 'padding-', 'px');
		$logo_style .= isset($logo_box_border) ? $this->cws_print_border($logo_box_border) : '';

		$logo_m = $logo_box_margin;
		if ( is_array( $logo_m ) ) {
			$logo_lr_spacing = $this->cws_print_css_keys($logo_m, 'margin-', 'px');
			$logo_tb_spacing = $this->cws_print_css_keys($logo_m, 'padding-', 'px');
		}

		$logo_box_overlay_styles = isset($logo_box_overlay) ? $this->cws_print_overlay($logo_box_overlay) : '';

		ob_start();
		?>

		.header_container .logo_box{
			<?php echo esc_attr($logo_style) ?>
		}

		.header_wrapper_container .logo_box{
			<?php echo esc_attr($logo_box_overlay_styles) ?>
		}		

		<?php
		echo ob_get_clean();
	}		

	public function cws_custom_menu_box_styles_action () {
		//Get metaboxes from page
		$menu_box = $this->cws_get_meta_option( 'menu_box' );
		extract($menu_box, EXTR_PREFIX_ALL, 'menu_box');

		$header_box = $this->cws_get_meta_option( 'header_box' );
		extract($header_box, EXTR_PREFIX_ALL, 'header_box');

		$menu_style_margin = $this->cws_print_css_keys($menu_box_margin, 'padding-', 'px');
		$menu_style_background = $this->cws_print_rgba('background-color', $menu_box_background_color, $menu_box_background_opacity);

		$menu_style = '';
		$menu_helper_color = '';
		$menu_style .= $menu_style_background;
		$menu_style .= isset($menu_box_border) ? $this->cws_print_border($menu_box_border) : '';

		if( isset($header_box_overlay['gradient']) && !empty($header_box_overlay['gradient']) && !empty($header_box_overlay['gradient']['c2']) ){
			$menu_helper_color = $header_box_overlay['gradient']['c2'];
		} else if ( isset($header_box_overlay['color']) && !empty($header_box_overlay['color']) ){
			$menu_helper_color = $header_box_overlay['color'];
		} else {
			$menu_helper_color = $this->cws_get_meta_option('theme-helper-color');;
		}

		ob_start();
		if( $menu_box_menu_stripes ){
			if( !empty($menu_box_stripes_offset['top']) ){
				echo "
					.site_header.logo-in-menu.logo-center .main-nav-container .left-stripe:before,
					.site_header.logo-in-menu.logo-center .main-nav-container .right-stripe:before,
					.site_header.logo-in-menu.logo-left .header_nav_part:before,
					.site_header.logo-in-menu.logo-right .header_nav_part:before{
						top: ".esc_attr($menu_box_stripes_offset['top'])."px;
					}
				";
			}
			if( !empty($menu_box_stripes_offset['bottom']) ){
				echo "
					.site_header.logo-in-menu.logo-center .main-nav-container .left-stripe:after,
					.site_header.logo-in-menu.logo-center .main-nav-container .right-stripe:after,
					.site_header.logo-in-menu.logo-left .header_nav_part:after,
					.site_header.logo-in-menu.logo-right .header_nav_part:after{
						bottom: ".esc_attr($menu_box_stripes_offset['bottom'])."px;
					}
				";
			}
		}

		if( !empty($menu_helper_color) ){
			echo "
				.main-nav-container .main-menu > .menu-item:not(:last-child):after{
					color: ".esc_attr($menu_helper_color).";
				}

				.site_header.logo-in-menu.logo-center .main-nav-container .right-stripe:before,
				.site_header.logo-in-menu.logo-center .main-nav-container .right-stripe:after,
				.site_header.logo-in-menu.logo-center .main-nav-container .left-stripe:before,
				.site_header.logo-in-menu.logo-center .main-nav-container .left-stripe:after,
				.site_header.logo-in-menu .header_nav_part:before,
				.site_header.logo-in-menu .header_nav_part:after{
					background-color: ".esc_attr($menu_helper_color).";
				}
			";
		}

		if( $menu_box_background_color != 'transparent' ){
			echo "
				.header_container .menu_box{
					". esc_attr($menu_style_background) ."
				}
			";
		}

		if( !empty($menu_box_margin) ){
			echo "
				.main-nav-container{	
					". esc_attr($menu_style_margin) ."
				}
			";

			$menu_padding_top = 0;
			if( !empty($menu_box_margin['top']) ){
				$menu_padding_top = $menu_box_margin['top'];
			}

			$menu_padding_bottom = 0;
			if( !empty($menu_box_margin['bottom']) ){
				$menu_padding_bottom = $menu_box_margin['bottom'];
			}

			echo "
				.header_wrapper_container .site_header.logo-in-menu.logo-center .main-nav-container .left-stripe,
				.header_wrapper_container .site_header.logo-in-menu.logo-center .main-nav-container .right-stripe{
					height: calc(100% - ".$menu_padding_top."px - ".$menu_padding_bottom."px);
				}
			";
		}

		if( $menu_box_background_color != 'transparent' || !empty($menu_box_border) ){
			echo "
				.header_wrapper_container .header_container .menu_box{
					margin-top: 5px;
					margin-bottom: 5px;
					border-radius: 15px;
				}				
			";
		} else if( (empty($menu_box_background_color) || $menu_box_background_color == 'transparent') && empty($menu_box_border) ){
			echo "
				@media screen and (max-width: 1199px) and (min-width: 768px){
					.header_wrapper_container .header_container .menu_box{
						margin-top: 10px;
						margin-bottom: 10px;
					}
					.mobile_menu_wrapper.show_on_tablets{
						margin-top: 10px;
						-webkit-border-radius: 15px;
								border-radius: 15px;
					}
				}
			";
		}

		echo ob_get_clean();
	}

	public function cws_custom_page_title_styles_action () {
		$title_area_font_color = '';
		$bg_layer_styles = '';
		$stat_img_cont_styles = '';
		$header_box_use_blur = '';
		$header_box_effect = '';
		//Get metaboxes from page
		$header_box = $this->cws_get_meta_option( 'header_box' );
		extract($header_box, EXTR_PREFIX_ALL, 'header_box');

		$top_bar_box = $this->cws_get_meta_option( 'top_bar_box' );
		extract($top_bar_box, EXTR_PREFIX_ALL, 'top_bar_box');

		$pid = get_the_id();

		$post_meta = get_post_meta( $pid, 'cws_mb_post' );
		$post_meta = isset( $post_meta[0] ) ? $post_meta[0] : array();

		if ($header_box_customize == '1'){
			$title_area_font_color = $header_box_font_color;
		}

		$header_box_style = isset($header_box_border) ? $this->cws_print_border($header_box_border) : '';

		if (isset($header_box_overlay)){
			$bg_layer_styles .= isset($header_box_overlay) ? $this->cws_print_overlay($header_box_overlay) : '';		
		}

		if (isset($header_box_parallax_options)){
			$this->cws_print_parallaxify_atts($header_box_parallax_options, $header_box_parallaxify_atts, $header_box_parallaxify_layer_atts);					
		}

		ob_start();

		if( $header_box_customize ){

			// -----> TopBar takes title box styles
			if( (!isset($top_bar_box_title_styles) || $top_bar_box_title_styles != 1) && isset($header_box_custom_pattern) && !empty($header_box_custom_pattern) ){
				echo "
					.site_header #site_top_panel:before{
						background-image: url('".$header_box_custom_pattern['src']."');
					}
				";
			}

			if( (!isset($top_bar_box_title_styles) || $top_bar_box_title_styles != 1) && isset($header_box_overlay) && !empty($header_box_overlay) ){
				echo "
					.site_header #site_top_panel{
						". esc_attr($bg_layer_styles) ."
					}
				";
			}

			if( (!isset($top_bar_box_title_styles) || $top_bar_box_title_styles != 1) && (isset($header_box_rotate_img) && $header_box_rotate_img == true) ){
				echo "
					#site_top_panel .top_bar_rotate_img_wrapper img{
						-webkit-animation: cws_top_spin 400s infinite linear;
						animation: cws_top_spin 400s infinite linear;
					}
				";
			}

			if( isset($header_box_overlay['color']) ){
				echo "
					.top_bar_trigger:before{
						border-color: ".esc_attr($header_box_overlay['color'])." transparent transparent transparent;
					}
				";
			} else if( isset($header_box_overlay['gradient']['c1']) ){
				echo "
					.top_bar_trigger:before{
						border-color: ".esc_attr($header_box_overlay['gradient']['c1'])." transparent transparent transparent;
					}
				";
			}

			// -----> Title box styles
			if( isset($header_box_custom_pattern) && !empty($header_box_custom_pattern) ){
				echo "
					.header_wrapper_container.disabled_top_bar:after,
					.bg_page_header .bg_layer:before{
						background-image: url('".$header_box_custom_pattern['src']."');
					}
				";
			}

			if( !empty($header_box_pattern_opacity) ){
				echo "
					.header_wrapper_container.disabled_top_bar:after
					.bg_page_header .bg_layer:before{
						opacity: ". ($header_box_pattern_opacity / 100) .";
					}
				";
			}

			if( isset($header_box_rotate_img) && $header_box_rotate_img == true ){
				echo "
					.bg_page_header.with_image .header_img_wrap img{
						-webkit-animation: cws_spin 400s infinite linear;
						animation: cws_spin 400s infinite linear;
					}
				";
			}

			if( !empty($bg_layer_styles) ){
				echo "
					.header_wrapper_container.disabled_top_bar:before,
					.bg_page_header .bg_layer{
						". esc_attr($bg_layer_styles) ."
					}
				";
			}

			if( !empty($title_area_font_color) ){
				echo "
					.bg_page_header .page_title .title h1{
						background-color: ". esc_attr($title_area_font_color) .";	
					}
				";
			}

			if( !empty($header_box_style) ){
				echo "
					.bg_page_header{
						". esc_attr($header_box_style) .";
					}
				";
			}

			if( !empty($header_box_stroke_color) ){
				echo "
					.header_box .page_title .title h1{
						-webkit-text-stroke-color: ".esc_attr($header_box_stroke_color).";
					}
				";
			}

			if( !empty($header_box_drop_shadow_prop) && !empty($header_box_drop_shadow_color) ){
				echo "
					.header_box .page_title .title h1{
						filter: drop-shadow(".esc_attr($header_box_drop_shadow_prop)." 0 ".esc_attr($header_box_drop_shadow_color).");
					}

					@media(max-width: 1199px){
						.header_box .page_title .title h1{
							filter: drop-shadow(4px 5px 0 ".esc_attr($header_box_drop_shadow_color).");
						}
					}

					@media(max-width: 991px){
						.header_box .page_title .title h1{
							filter: drop-shadow(3px 4px 0 ".esc_attr($header_box_drop_shadow_color).");
						}
					}

					@media(max-width: 767px){
						.header_box .page_title .title h1{
							filter: drop-shadow(2px 3px 0 ".esc_attr($header_box_drop_shadow_color).");
						}
					}
				";
			}
		}

		echo ob_get_clean();
	}

	public function cws_custom_side_panel_styles_action(){
		$side_panel_bg = '';
		$side_panel_aside = '';
		$side_panel_wrapper = '';
		//Get metaboxes from page
		$side_panel = $this->cws_get_meta_option( 'side_panel' );
		extract($side_panel, EXTR_PREFIX_ALL, 'side_panel');

		ob_start();
		if ($side_panel_enable) {
			$bg_image = $this->cws_get_option( 'side_panel' )['bg_' . $side_panel_theme]; //Call from ThemeOptions
			$bg_src = isset($bg_image) ? $bg_image['src'] : '';
			$bg_size = $side_panel_bg_size;
			$bg_opacity = (int) $side_panel_bg_opacity / 100;
			$bg_pos = $this->cws_print9positions($side_panel_bg_position);

			$side_panel_overlay_styles = isset($side_panel_overlay) ? esc_attr($this->cws_print_overlay($side_panel_overlay)) : '';
			$side_panel_bg .= 'background-size:'.esc_attr($bg_size).';background-image: url('.esc_url($bg_src).'); background-position: '.esc_attr($bg_pos).';';
			$side_panel_aside .= 'background-color: rgba('.esc_attr($this->cws_Hex2RGB( $side_panel_bg_color )).','.esc_attr($bg_opacity).');';
			$side_panel_wrapper .= 'text-align:'.esc_attr($side_panel_logo_position);

			?>
				aside.side_panel,
				aside.side_panel a,
				aside.side_panel .cws-widget .recentcomments,
				aside.side_panel .cws-widget ul.menu li .widgettitle,
				aside.side_panel .cws-widget .post_item .post_title a,
				aside.side_panel .cws-widget .cws_tweet:before,
				aside.side_panel .cws-widget span.product-title,
				aside.side_panel .cws-widget ul li:before,
				aside.side_panel .cws-widget .widget-title,
				aside.side_panel .cws-widget ul > li a,
				aside.side_panel .cws-widget ul > li a:hover,
				aside.side_panel .cws-widget .menu .menu-item:hover>.opener,
				aside.side_panel .cws-widget .menu .menu-item.current-menu-ancestor>.opener,
				aside.side_panel .cws-widget .menu .menu-item.current-menu-item>.opener,
				aside.side_panel .menu .menu-item:hover>a,
				aside.side_panel .menu .menu-item:hover>.cws_megamenu_item_title,
				aside.side_panel .menu .menu-item.current-menu-ancestor>a,
				aside.side_panel .menu .menu-item.current-menu-item>a,
				aside.side_panel  .cws-widget .ourteam_item_title a,
				aside.side_panel  .cws-widget .ourteam_item_position a,
				.side_panel_container .side_panel_bottom p,
				.side_panel_container .side_panel_bottom i,
				.side_panel_container .side_panel_bottom .cws_social_links,
				aside.side_panel .cws-widget .parent_archive .widget_archive_opener:before,
				aside.side_panel .cws-widget .menu-item-has-children .opener:before
				{
					color: <?php echo esc_attr($side_panel_bg_font_color) ?>;
				}

				aside.side_panel .cws-widget .search-form input{
					border-color: <?php echo esc_attr($side_panel_bg_font_color) ?>;
				}
				aside.side_panel .cws-widget .search-form input{
					border-left-color: <?php echo esc_attr($side_panel_bg_color) ?>;
				}
				aside.side_panel .cws-widget .search-form input,
				aside.side_panel .cws-widget .search-form input[type='submit']{
					color: <?php echo esc_attr($side_panel_bg_color) ?>;
				}

				.side_panel_container .side_panel_bottom .cws_social_links .cws_social_link
				{
					color: <?php echo esc_attr($side_panel_bg_font_color) ?> !important;
				}				

				aside.side_panel .cws-widget .search-form input,
				aside.side_panel .cws-widget .search-form input[type='submit'],
				aside.side_panel .mobile_menu_hamburger span::before,
				aside.side_panel .mobile_menu_hamburger span::after,
				aside.side_panel .mobile_menu_hamburger:hover span::before,
				aside.side_panel .mobile_menu_hamburger:hover span::after,
				aside.side_panel .owl-pagination .owl-page.active:before
				{
					background-color: <?php echo esc_attr($side_panel_bg_font_color) ?>;
				}

				aside.side_panel .owl-pagination .owl-page
				{
					-webkit-box-shadow: 0px 0px 0px 1px <?php echo esc_attr($side_panel_bg_font_color) ?>;
					-moz-box-shadow: 0px 0px 0px 1px <?php echo esc_attr($side_panel_bg_font_color) ?>;
					box-shadow: 0px 0px 0px 1px <?php echo esc_attr($side_panel_bg_font_color) ?>;
				}

				.side_panel_wrapper{
					<?php echo esc_attr($side_panel_wrapper) ?>
				}

				.side_panel_bg,
				aside.side_panel{
					<?php echo esc_attr($side_panel_aside) ?>
				}

				body .side_panel_bg{
					<?php echo esc_attr($side_panel_bg) ?>
				}

				body .side_panel_overlay{
					<?php echo esc_attr($side_panel_overlay_styles) ?>			
				}

			<?php
		}
		echo ob_get_clean();
	}	

	public function cws_custom_footer_styles_action() {
		//Get metaboxes from page
		$footer = $this->cws_get_meta_option( 'footer' );
		extract($footer, EXTR_PREFIX_ALL, 'footer');

		$footer_style = '';
		$footer_layer_style = '';
		$footer_pattern_style = '';
		$footer_style .= isset($footer_border) ? $this->cws_print_border($footer_border) : '';
		$footer_style .= isset($footer_background_image['image']['src']) && !empty($footer_background_image['image']['src']) ? $this->cws_print_background($footer_background_image) : '';

		if ( isset($footer_spacings) ){
			$footer_style .= $this->cws_print_paddings($footer_spacings);
		}
		$footer_style .= 'background-color:'.esc_attr($footer_background_color).';';
		$footer_layer_style .= $this->cws_print_overlay($footer_overlay);
		

		if (isset($footer_pattern_image['image']['src']) && !empty($footer_pattern_image['image']['src'])){
			$footer_pattern_style .= $this->cws_print_background($footer_pattern_image);
		}

		ob_start();
		?>

			.page_footer .footer-pattern{
				<?php echo esc_attr($footer_pattern_style) ?>
			}

			.page_footer{
				<?php echo esc_attr($footer_style) ?>
			}

			.page_footer .bg_layer{
				<?php echo esc_attr($footer_layer_style) ?>
			}

			.page_footer .footer_container .cws-widget h3,
			.page_footer .footer_container .cws-widget .widget-title,
			.page_footer .footer_container .cws-widget .widget-title span
			{
				color: <?php echo esc_attr($footer_title_color) ?>;
			}

			.page_footer,
			.page_footer .footer_container .cws-widget .cws_social_links a:not(.fill_icon) .cws_fa,
			.footer_container .cws-widget ul li>a,
			.footer_container .cws-widget ul.menu li>a:hover,
			.footer_container .cws-widget ul li>.cws_megamenu_item_title,
			.footer_container .cws-widget .about_me .user_name,
			.footer_container .cws-widget .about_me .user_position,
			.footer_container .cws-widget .about_me .user_description,
			.footer_container .cws-widget .post_item .post_content,
			.footer_container .cws-widget .post_item .quote_author a,
			.footer_container .cws-widget .post_item .post_date,
			.footer_container .cws-widget .post_item .post_comments a,
			.footer_container .cws-widget .cws_tweets .tweet_content,
			.footer_container .cws-widget .recentcomments,
			.footer_container .cws-widget .information_group,
			footer .cws-widget ul.menu li .widgettitle,
			footer .cws-widget.widget-recent-posts ul li .post-date
			{
				color: <?php echo esc_attr($footer_font_color) ?>;
			}

			footer .cws-widget ul li:before,
			footer .cws-widget ul li > a span.post_count:before
			{
				background-color: <?php echo esc_attr($footer_font_color) ?>;
			}


			.copyrights_area{
				color: <?php echo esc_attr($footer_copyrights_font_color) ?>;
				background-color: <?php echo esc_attr($footer_copyrights_background_color) ?>;
			}

			.footer-nav-container .main-menu.copyrights-menu li:not(:first-child) a:before,
			.footer-nav-container .copyrights-menu .menu-item a{
				color: <?php echo esc_attr($footer_copyrights_font_color) ?>;
			}

			.footer-nav-container .copyrights-menu .menu-item.current-menu-item > a,
			.footer-nav-container .copyrights-menu .menu-item a:hover{
				color: <?php echo esc_attr($footer_copyrights_hover_color) ?>;
			}			

			.copyrights_panel_wrapper .wpml_language_switch.lang_bar:after{
				background-color: <?php echo esc_attr($footer_copyrights_font_color) ?>;
			}

		<?php
		echo ob_get_clean();
	}

	public function cws_custom_boxed_layout_styles_action() {
		$boxed_style = $boxed_background_image = $boxed_overlay = '';
		//Get metaboxes from page
		$boxed = $this->cws_get_meta_option( 'boxed' );
		if (isset($boxed)){
			extract($boxed, EXTR_PREFIX_ALL, 'boxed');
			ob_start();
				$bb = $boxed_background_image;
				if ( !empty($bb['image']['src']) ){
					$atts = $this->cws_print_css_keys($bb, 'background-');
					$atts .= 'background-image:url('.esc_url($bb['image']['src']).');';
					$atts .= 'background-color:#ffffff;';
					?>
						body.override_boxed_layout.layout_meta{
							<?php print esc_attr($atts); ?>;
						}
					<?php
				}

				$boxed_style .= $this->cws_print_overlay($boxed_overlay);

				?>
				body .body_overlay{
					<?php echo esc_attr($boxed_style) ?>			
				}
				<?php			
			echo ob_get_clean();			
		}
	}	

	public function cws_custom_styles_action(){
		$page_spacing = $this->cws_get_meta_option('page_spacing');
		$page_content_style = '';
		if ( isset($page_spacing) ){
			foreach ( $page_spacing as $key => $value ){
				if ( !empty( $value ) || $value == '0' ){
					$page_content_style .= "padding-".esc_attr($key). ": " . esc_attr($value) . "px;";
				}
			}

			ob_start();
			?>
				#main .page_content{
					<?php echo esc_attr($page_content_style) ?>
				}

			<?php
			echo ob_get_clean();
		}
	}	

	//****************************** //CWS CUSTOM STYLES FUNCTIONS ******************************

	private function cws_print_theme_gradient () {
		ob_start();
		do_action( 'theme_gradient_hook' );
		return ob_get_clean();
	}

	public function cws_theme_gradient_action () {
		$out = '';
		$use_gradients = $this->cws_get_option('use_gradients');
		if ( $use_gradients ) {
			$gradient_settings = $this->cws_get_option( 'gradient_settings' );
			require_once( get_template_directory() . "/css/gradient_selectors.php" );
			if ( function_exists( "get_gradient_selectors" ) ) {
				$gradient_selectors = get_gradient_selectors();
				$out .= $this->cws_print_gradient( array(
					'settings' => $gradient_settings,
					'selectors' => $gradient_selectors,
					'use_extra_rules' => true
				));
			}
		}
		echo preg_replace('/\s+/',' ', $out);
	}

	public function cws_gradients_body_class ( $classes ) {
		$use_gradients = $this->cws_get_option('use_gradients');
		if ( $use_gradients ) {
			$classes[] = "cws_gradients";
		}
		return $classes;
	}

	public function cws_process_colors() {
		$out = $this->cws_print_theme_color();
		return $out;
	}

	public function cws_Hex2RGB($hex) {
		$hex = str_replace('#', '', $hex);
		$color = '';

		if(strlen($hex) == 3) {
			$color = hexdec(mb_substr($hex, 0, 1)) . ',';
			$color .= hexdec(mb_substr($hex, 1, 1)) . ',';
			$color .= hexdec(mb_substr($hex, 2, 1));
		}
		else if(strlen($hex) == 6) {
			$color = hexdec(mb_substr($hex, 0, 2)) . ',';
			$color .= hexdec(mb_substr($hex, 2, 2)) . ',';
			$color .= hexdec(mb_substr($hex, 4, 2));
		}
		return $color;
	}

	// \  COLOR HOOK

	public function cws_theme_header_process_fonts (){
		return $this->cws_process_fonts();
	}

	public function cws_theme_header_process_colors (){
		return $this->cws_process_colors();
	}

	public function cws_theme_header_process_blur (){
		return $this->cws_process_blur();
	}	

	public function cws_theme_loader (){
		return $this->cws_loader();
	}	
	/* END THE HEADER META */

	/* Comments */
	public function cws_comment_nav() {
		// Are there comments to navigate through?
		if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) {
		?>
		<div class="comments_nav carousel_nav_panel clearfix">
			<?php
				if ( $prev_link = get_previous_comments_link( "<span class='prev'></span><span>" . esc_html__( 'Older Comments', 'vintwood' ) . "</span>" ) ) {
					printf( '<div class="prev_section">%s</div>', esc_html($prev_link) );
				}

				if ( $next_link = get_next_comments_link( "<span>" . esc_html__( 'Newer Comments', 'vintwood' ) . "</span><span class='next'></span>" ) ) {
					printf( '<div class="next_section">%s</div>', esc_html($next_link) );
				}
			?>
		</div><!-- .comment-navigation -->
		<?php
		}
	}

	public function cws_comment_post( $incoming_comment ) {
		$comment = strip_tags($incoming_comment['comment_content']);
		$comment = esc_html($comment);
		$incoming_comment['comment_content'] = $comment;
		return $incoming_comment;
	}
	/* /Comments */

	/* SIDE PANEL */
	public function cws_side_panel() {
		//Get metaboxes from page
		$side_panel = $this->cws_get_meta_option( 'side_panel' );
		extract($side_panel, EXTR_PREFIX_ALL, 'side_panel');

		if ($side_panel_enable) {			
			$logo = $this->cws_get_option( 'side_panel' )['logo_' . $side_panel_theme]; //Call from ThemeOptions

			$logo_src = '';
			if ( !empty( $logo['src'] ) ) {
				$logo_hw = $this->cws_get_option( 'side_panel' )['logo_dimensions']; //Call from ThemeOptions

				$bfi_args = array();
				if (is_array($logo_hw)) {
					foreach ($logo_hw as $key => $value) {
						if ( !empty($value) ){
							$bfi_args[$key] = $value;
							$bfi_args['crop'] = false;
						}
					}
				}

				$main_logo_height = '';
				$logo_src = $this->cws_print_img_html($logo, $bfi_args, $main_logo_height);
			}

			echo '
			<div class="side_panel_overlay '.esc_attr($side_panel_appear).'"></div>
			<div class="side_panel_container '.esc_attr($side_panel_position).' '.esc_attr($side_panel_appear).'">
				<div class="side_panel_bg '.esc_attr($side_panel_position).' '.esc_attr($side_panel_appear).'"></div>
				<aside class="side_panel '.esc_attr($side_panel_position).' '.esc_attr($side_panel_appear).(isset($side_panel_bottom_bar['info_icons']) ? ' bottom_bar' : '').'">
					<div class="side_panel_wrapper close-'.esc_attr($side_panel_close_position).'">
						'.(!empty($logo_src) ? "<img ".$logo_src." />" : "").'
						<div class="mobile_menu_bar">
							<div class="close_side_panel mobile_menu_hamburger mobile_menu_hamburger--htx deactive">
								<span></span>
							</div>
						</div>
					</div>';					

				if (!empty($side_panel_sidebar) && is_active_sidebar( $side_panel_sidebar ) ) {
					dynamic_sidebar($side_panel_sidebar);
				}
				echo '
				</aside>';

				if (isset($side_panel_bottom_bar)){

					if (isset($side_panel_bottom_bar['info_icons'])){
					?>
						<div class="side_panel_bottom">
							<div class="info_icons_rows">
								<?php foreach ($side_panel_bottom_bar['info_icons'] as $key => $value) { ?>
									<p><i class="<?php echo esc_attr($value['icon']) ?>"></i><span><?php echo esc_html($value['title']); ?></span></p>
								<?php }
							echo '</div>'; 

							$social_links = $this->cws_render_social_links('side_panel');
							echo !empty($social_links) ? $social_links : '';
							?>
						</div>
					<?php				
					}

				}
			echo '</div>';
		}
	}
	/* SIDE PANEL */

	/* BODY OVERLAY */
	public function cws_body_overlay() {

		if (isset($this->cws_get_meta_option('boxed')['layout']) && $this->cws_get_meta_option('boxed')['layout'] == '1') {
			echo "<div class='body_overlay'></div>";
		}

	}
	/* BODY OVERLAY */

	public function cws_widget_title_icon_rendering( $args = array() ) {
		extract( shortcode_atts(
			array(
				'icon_type' => '',
				'icon_fa' => '',
				'icon_img' => array(),
				'icon_color' => '#fff',
				'icon_bg_type' => 'color',
				'icon_bgcolor' => VINTWOOD_FIRST_COLOR,
				'gradient_first_color' => VINTWOOD_FIRST_COLOR,
				'gradient_second_color' => '#0eecbd',
				'gradient_type' => '',
				'gradient_linear_angle' => '',
				'gradient_radial_shape' => '',
				'gradient_radial_type' => '',
				'gradient_radial_size_key' => '',
				'gradient_radial_size' => '',
				), $args));

		$r = $icon_styles = '';
		if ( $icon_type == 'fa' && !empty( $icon_fa ) ) {
			switch ($icon_bg_type) {
				case 'none':
					$icon_styles .= "border-width: 1px; border-style: solid;";
					break;
				case 'color':
					$icon_styles .= "background-color:$icon_bgcolor;";
					break;
				case 'gradient':
					$gradient_settings = $this->cws_extract_array_prefix($args, 'gradient');
					$gradient_settings_arr = array(
						'first_color' => $gradient_settings["first_color"],
						'second_color' => $gradient_settings["second_color"],
						'type' => $gradient_settings["type"],
						'linear_settings' => array(
							'angle' => $gradient_settings["linear_angle"],
						),
						'radial_settings' => array(
							'shape_settings' => $gradient_settings["radial_shape"],
							'shape' => $gradient_settings["radial_type"],
							'size_keyword' => $gradient_settings["radial_size_key"],
							'size' => $gradient_settings["radial_size"],
						),
					);

					$gradient_settings = isset( $gradient_settings_arr ) ? $gradient_settings_arr : new stdClass();
					$settings = new stdClass();

					foreach ($gradient_settings_arr as $key => $value) {
						$settings->$key = $value;
					}

					$icon_styles .= esc_attr( $this->cws_print_gradient( array( 'settings' => $settings ) ) );
					break;
			}

			$icon_styles .= "color:$icon_color;";
			$r .= "<i class='$icon_fa' style='$icon_styles'></i>";
		}	else if ( $icon_type == 'img' && !empty( $icon_img['src'] ) ) {

			$font = $this->cws_get_meta_option( 'body-font' );
			$font_size = isset( $font['font_size'] ) ? preg_replace( 'px', '', $font['font_size'] ) : '15';
			$thumb_size = (int)round( (float)$font_size * 2 );

			$g_img = $this->cws_print_img_html(array('src' => $icon_img['src']), array( 'width' => $thumb_size, 'height' => $thumb_size ));
			$this->echo_ne($g_img, "<img{$g_img}/>");

		}
		return $r;
	}

	private function cws_extract_array_prefix($arr, $prefix) {
		$ret = array();
		$pref_len = strlen($prefix);
		foreach ($arr as $key => $value) {
			if (0 === strpos($key, $prefix . '_') ) {
				$ret[mb_substr($key, $pref_len+1)] = $value;
			}
		}
		return $ret;
	}

	public function cws_move_comment_field_to_bottom( $fields ) {
		$comment_field = $fields['comment'];
		unset( $fields['comment'] );
		$fields['comment'] = $comment_field;
		return $fields;
	}
}
/* end of Theme's Class */

//Functions

function cws_custom_background() {
    ob_start();

    _custom_background_cb(); // Default handler

    $style = ob_get_clean();

    echo sprintf("%s", $style);
}

if(!function_exists('cws_pagination')){
	function cws_page_links(){
		$args = array(
			'before'		   => '',
			'after'			=> '',
			'link_before'	  => '<span>',
			'link_after'	   => '</span>',
			'next_or_number'   => 'number',
			'nextpagelink'	 =>  esc_html__("Next Page",'vintwood'),
			'previouspagelink' => esc_html__("Previous Page",'vintwood'),
			'pagelink'		 => '%',
			'echo'			 => 0
		);
		$pagination = wp_link_pages( $args );
		echo !empty( $pagination ) ? "<div class='pagination'><div class='page_links'>$pagination</div></div>" : '';
	}
}

if(!function_exists('cws_pagination')){
	function cws_pagination ( $paged=1, $max_paged=1, $dynamic = true ){
		$is_rtl = is_rtl();

		$pagenum_link = html_entity_decode( get_pagenum_link() );
		$query_args   = array();
		$url_parts	= explode( '?', $pagenum_link );

		if ( isset( $url_parts[1] ) ) {
			wp_parse_str( $url_parts[1], $query_args );
		}

		$permalink_structure = get_option('permalink_structure');

		$pagenum_link = remove_query_arg( array_keys( $query_args ), $pagenum_link );
		$pagenum_link = $permalink_structure ? trailingslashit( $pagenum_link ) . '%_%' : trailingslashit( $pagenum_link ) . '?%_%';
		$pagenum_link = add_query_arg( $query_args, $pagenum_link );

		$format  = $permalink_structure && preg_match( '#^/*index.php#', $permalink_structure ) && ! strpos( $pagenum_link, 'index.php' ) ? 'index.php/' : '';
		$format .= $permalink_structure ? user_trailingslashit( 'page/%#%', 'paged' ) : 'paged=%#%';
		$classes = '';
		$classes .= $dynamic ? ' dynamic' : '';
		?>

		<div class="pagination<?php echo sprintf("%s", $classes); ?>">
			<div class='page_links'>
			<?php
			$pagination_args = array( 'base' => $pagenum_link,
				'format' => $format,
				'current' => $paged,
				'total' => $max_paged,
				"prev_text" => "<i class='" . ( $is_rtl ? "rtl" : "" ) . "'></i>",
				"next_text" => "<i class='" . ( $is_rtl ? "rtl" : "" ) . "'></i>",
				"link_before" => '',
				"link_after" => '',
				"before" => '',
				"after" => '',
				"mid_size" => 2,
			);
			$pagination = paginate_links($pagination_args);
			echo sprintf("%s", $pagination);
			?>
			</div>
		</div>
		<?php

	}
}

if(!function_exists('cws_loader_html')){
	function cws_loader_html ( $args = array() ){
		extract( wp_parse_args( $args, array(
			'holder_id'		=> '',
			'holder_class' 	=> '',
			'loader_id'		=> '',
			'loader_class'	=> ''
		)));
		$holder_class 	.= " cws_loader_holder";
		$loader_class 	.= " cws_loader";
		$holder_id		= esc_attr( $holder_id );
		$holder_class 	= esc_attr( trim( $holder_class ) );
		$loader_id		= esc_attr( $loader_id );
		$loader_class 	= esc_attr( trim( $loader_class ) );
		echo "<div " . ( !empty( $holder_id ) ? " id='$holder_id'" : "" ) . " class='$holder_class'>";
			echo "<div " . ( !empty( $loader_id ) ? " id='$loader_id'" : "" ) . " class='$loader_class'>";
				?>
				<svg width='104px' height='104px' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" class="uil-default"><rect x="0" y="0" width="100" height="100" fill="none" class="bk"></rect><rect  x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(0 50 50) translate(0 -30)'>  <animate attributeName='opacity' from='1' to='0' dur='1s' begin='0s' repeatCount='indefinite'/></rect><rect  x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(30 50 50) translate(0 -30)'>  <animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.08333333333333333s' repeatCount='indefinite'/></rect><rect  x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(60 50 50) translate(0 -30)'>  <animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.16666666666666666s' repeatCount='indefinite'/></rect><rect  x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(90 50 50) translate(0 -30)'>  <animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.25s' repeatCount='indefinite'/></rect><rect  x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(120 50 50) translate(0 -30)'>  <animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.3333333333333333s' repeatCount='indefinite'/></rect><rect  x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(150 50 50) translate(0 -30)'>  <animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.4166666666666667s' repeatCount='indefinite'/></rect><rect  x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(180 50 50) translate(0 -30)'>  <animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.5s' repeatCount='indefinite'/></rect><rect  x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(210 50 50) translate(0 -30)'>  <animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.5833333333333334s' repeatCount='indefinite'/></rect><rect  x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(240 50 50) translate(0 -30)'>  <animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.6666666666666666s' repeatCount='indefinite'/></rect><rect  x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(270 50 50) translate(0 -30)'>  <animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.75s' repeatCount='indefinite'/></rect><rect  x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(300 50 50) translate(0 -30)'>  <animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.8333333333333334s' repeatCount='indefinite'/></rect><rect  x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(330 50 50) translate(0 -30)'>  <animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.9166666666666666s' repeatCount='indefinite'/></rect></svg>
				<?php
			echo "</div>";
		echo "</div>";
	}	
}

if(!function_exists('cws_load_more')){
	function cws_load_more ( $paged = 1, $max_paged = PHP_INT_MAX ){
		$aligning = isset($GLOBALS['aligning_more'] ) ?  $GLOBALS['aligning_more']  : "";
	?>	
		<div class='aligning_more<?php echo !empty($aligning) ? " ".$aligning : " center"; ?>'>
			<a class="cws_custom_button advanced cws_load_more" href="#"><?php esc_html_e( "LOAD MORE", 'vintwood' ); ?></a>
		</div>

	<?php
	}
}

//Add inline styles to enqueue
if(!function_exists('Cws_shortcode_css')){
    function Cws_shortcode_css() {
        return Cws_shortcode_css::instance();
    }
}

if ( !class_exists( "Cws_shortcode_css" ) ){
    class Cws_shortcode_css{
        public $settings;
        protected static $instance = null;

        public static function instance() {
            if ( is_null( self::$instance ) ) {
                self::$instance = new self();
            }
            return self::$instance;
        }    
        public function enqueue_cws_css( $style ) {
            if(!empty($style)){
                ob_start();             
                    echo sprintf("%s", $style);
                $css = ob_get_clean();
                $css = apply_filters( 'cws_enqueue_shortcode_css', $css, $style );

                wp_register_style( 'cws-footer', false );
                wp_enqueue_style( 'cws-footer' );
                wp_add_inline_style( 'cws-footer', $css );      
            }

        }
    }
}
//Add inline styles to enqueue

/* FA ICONS */
function cws_get_all_fa_icons() {
	$meta = get_option('cws_fa');
	if (!empty($meta) || (time() - $meta['t']) > 3600*7 ) {
		global $wp_filesystem;
		if( empty( $wp_filesystem ) ) {
			require_once( ABSPATH .'/wp-admin/includes/file.php' );
			WP_Filesystem();
		}
		$file = get_template_directory() . '/fonts/font-awesome/font-awesome.css';
		$fa_content = '';
		if ( $wp_filesystem && $wp_filesystem->exists($file) ) {
			$fa_content = $wp_filesystem->get_contents($file);
			if ( preg_match_all( "/fa-((\w+|-?)+):before/", $fa_content, $matches, PREG_PATTERN_ORDER ) ) {
				return $matches[1];
			}
		}
	} else {
		return $meta['fa'];
	}
}
/* \FA ICONS */

/* FL ICONS */
function cws_get_all_flaticon_icons() {
	$cwsfi = get_option('cwsfi');
	if (!empty($cwsfi) && isset($cwsfi['entries'])) {
		return $cwsfi['entries'];
	} else {
		global $wp_filesystem;
		if( empty( $wp_filesystem ) ) {
			require_once( ABSPATH .'/wp-admin/includes/file.php' );
			WP_Filesystem();
		}
		$file = get_template_directory() . '/fonts/flaticon/flaticon.css';
		$fi_content = '';
		$out = '';
		if ( $wp_filesystem && $wp_filesystem->exists($file) ) {
			$fi_content = $wp_filesystem->get_contents($file);
			if ( preg_match_all( "/flaticon-((\w+|-?)+):before/", $fi_content, $matches, PREG_PATTERN_ORDER ) ){
				return $matches[1];
			}
		}
	}
}
/* \FL ICONS */

/********************************** !!! **********************************/

function cws_twitter_renderer ( $atts, $content = '' ) {
	extract( shortcode_atts( array(
		'in_widget' => false,
		'title' => '',
		'centertitle' => '0',
		'items' => get_option( 'posts_per_page' ),
		'visible' => get_option( 'posts_per_page' ),
		'showdate' => '0'
	), $atts));
	$out = '';
	global $cws_theme_funcs;
	$tw_username = $cws_theme_funcs->cws_get_option( 'tw-username' );
	if ( !is_numeric( $items ) || !is_numeric( $visible ) ) return $out;
	$tweets = cws_getTweets( (int)$items );
	if ( is_string( $tweets ) ) {
		$out .= do_shortcode( "[cws_sc_msg_box title='" . esc_attr__( 'Twitter responds:', 'vintwood' ) . "' text='$tweets' is_closable='1'][/cws_sc_msg_box]" );
	}
	else if ( is_array( $tweets ) && isset($tweets['error']) ){
		echo esc_html($tweets['error']);
	}
	else if ( is_array( $tweets ) ) {
		$use_carousel = count( $tweets ) > $visible;
		$section_class = "cws_tweets";
		$section_class .= $use_carousel ? " tweets_carousel" : '';
		$section_class .= $use_carousel && empty( $title ) ? " paginated" : '';
		$out .= !empty( $title ) ? $cws_theme_funcs::THEME_BEFORE_CE_TITLE . "<div" . ( $centertitle ? " style='text-align:center;'" : '' ) . ">".esc_html($title)."</div>" . $cws_theme_funcs::THEME_AFTER_CE_TITLE : '';
		if ( $use_carousel && !$in_widget ) {
			$out .= "<div class='tweets_carousel_header'>";
				$out .= "<a href='http://twitter.com/".esc_attr($tw_username)."' class='follow_us fa fa-twitter' target='_blank'></a>";
			$out .= "</div>";
		}
		$out .= "<div class='".esc_attr($section_class)."'>";
			$out .= "<div class='cws_wrapper'>";
				$carousel_item_closed = false;
				for ( $i=0; $i<count( $tweets ); $i++ ) {
					$tweet = $tweets[$i];
					if ( $use_carousel && ( $i == 0 || $carousel_item_closed ) ) {
						wp_enqueue_script ('owl_carousel');
						$out .= "<div class='item'>";
						$carousel_item_closed = false;
					}
					$tweet_text = isset( $tweet['text'] ) ? $tweet['text'] : '';
					$tweet_entitties = isset( $tweet['entities'] ) ? $tweet['entities'] : array();
					$tweet_urls = isset( $tweet_entitties['urls'] ) && is_array( $tweet_entitties['urls'] ) ? $tweet_entitties['urls'] : array();
					foreach ( $tweet_urls as $tweet_url ) {
						$display_url = isset( $tweet_url['display_url'] ) ? $tweet_url['display_url'] : '';
						$received_url = isset( $tweet_url['url'] ) ? $tweet_url['url'] : '';
						$html_url = "<a href='".esc_url($received_url)."'>".esc_html($display_url)."</a>";
						$tweet_text = substr_replace( $tweet_text, $html_url, strpos( $tweet_text, $received_url ), strlen( $received_url ) );
					}
					$item_content = '';
					$item_content .= !empty( $tweet_text ) ? "<div class='tweet_content'>$tweet_text</div>" : '';
					if ( $showdate ) {
						$tweet_date = isset( $tweet['created_at'] ) ? $tweet['created_at'] : '';
						$tweet_date_formatted = cws_time_elapsed_string( date( "U", strtotime( $tweet_date ) ) );
						$item_content .= "<div class='tweet_date'>$tweet_date_formatted</div>";
					}
					$out .= !empty( $item_content ) ? "<div class='cws_tweet'>$item_content</div>" : '';
					$temp1 = ( $i + 1 ) / (int)$visible;
					if ( $use_carousel && ( $temp1 - floor( $temp1 ) == 0 || $i == count( $tweets ) - 1 ) ) {
						$out .= "</div>";
						$carousel_item_closed = true;
					}
				}
			$out .= "</div>";
		$out .= "</div>";
	}
	return $out;
}

function cws_time_elapsed_string($ptime){
    $etime = time() - $ptime;

    if ($etime < 1)
    {
        return '0 seconds';
    }

    $a = array( 365 * 24 * 60 * 60  =>  'year',
                 30 * 24 * 60 * 60  =>  'month',
                      24 * 60 * 60  =>  'day',
                           60 * 60  =>  'hour',
                                60  =>  'minute',
                                 1  =>  'second'
                );
    $a_plural = array( 'year'   => 'years',
                       'month'  => 'months',
                       'day'    => 'days',
                       'hour'   => 'hours',
                       'minute' => 'minutes',
                       'second' => 'seconds'
                );

    foreach ($a as $secs => $str)
    {
        $d = $etime / $secs;
        if ($d >= 1)
        {
            $r = round($d);
            return $r . ' ' . ($r > 1 ? $a_plural[$str] : $str) . ' ago';
        }
    }
}

function cws_getTweets( $count = 20 ) {
	$res = null;
	global $cws_theme_funcs;

	if ( '0' != $cws_theme_funcs->cws_get_option( 'turn-twitter' ) ) {
		$twitt_name = trim($cws_theme_funcs->cws_get_option( 'tw-username' )) ? trim($cws_theme_funcs->cws_get_option( 'tw-username' )) : 'Creative_WS';
		if (function_exists('getTweets')) {
			$res = getTweets($twitt_name, $count);
		}
	}

	return $res;
}

if ( ! isset( $content_width ) ) $content_width = 1170;

	/* Full width blog */

	if(!function_exists('cws_load_more')){
		function cws_load_more ( $paged = 1, $max_paged = PHP_INT_MAX ){
			$aligning = isset($GLOBALS['aligning_more'] ) ?  $GLOBALS['aligning_more']  : "";
		?>	
			<div class='aligning_more<?php echo !empty($aligning) ? " ".$aligning : " center"; ?>'>
				<div class="cws_custom_button_wrapper advanced second_color_scheme load_more">
					<span>
						<a class="cws_custom_button cws_load_more" href="#"><?php esc_html_e( "LOAD MORE", 'vintwood' ); ?></a>
					</span>
				</div>
			</div>
		<?php
		}
	}

	function cws_portfolio_loader(){
		ob_start();
		?>
			<div class='portfolio_loader_wraper'>
				<div class='portfolio_loader_container'>
					<svg width='104px' height='104px' xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" class="uil-default"><rect x="0" y="0" width="100" height="100" fill="none" class="bk"></rect><rect x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(0 50 50) translate(0 -30)'><animate attributeName='opacity' from='1' to='0' dur='1s' begin='0s' repeatCount='indefinite'/></rect><rect x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(30 50 50) translate(0 -30)'><animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.083s' repeatCount='indefinite'/></rect><rect x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(60 50 50) translate(0 -30)'><animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.1667s' repeatCount='indefinite'/></rect><rect x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(90 50 50) translate(0 -30)'><animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.25s' repeatCount='indefinite'/></rect><rect x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(120 50 50) translate(0 -30)'><animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.33s' repeatCount='indefinite'/></rect><rect x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(150 50 50) translate(0 -30)'><animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.4166s' repeatCount='indefinite'/></rect><rect x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(180 50 50) translate(0 -30)'><animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.5s' repeatCount='indefinite'/></rect><rect x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(210 50 50) translate(0 -30)'><animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.5833s' repeatCount='indefinite'/></rect><rect x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(240 50 50) translate(0 -30)'><animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.67s' repeatCount='indefinite'/></rect><rect x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(270 50 50) translate(0 -30)'><animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.75s' repeatCount='indefinite'/></rect><rect x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(300 50 50) translate(0 -30)'><animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.83s' repeatCount='indefinite'/></rect><rect x='46.5' y='40' width='7' height='20' rx='5' ry='5' fill='#000000' transform='rotate(330 50 50) translate(0 -30)'><animate attributeName='opacity' from='1' to='0' dur='1s' begin='0.9167s' repeatCount='indefinite'/></rect></svg>
				</div>
			</div>
		<?php
		echo ob_get_clean();
	}

/****************** WALKER CUSTOM MENU *********************/
class Walker_Nav_Menu_Edit_Custom extends Walker_Nav_Menu  {
	/**
	 * @see Walker_Nav_Menu::start_lvl()
	 * @since 3.0.0
	 *
	 * @param string $output Passed by reference.
	 */
	function start_lvl( &$output, $depth = 0, $args = array() ) {
	}

	/**
	 * @see Walker_Nav_Menu::end_lvl()
	 * @since 3.0.0
	 *
	 * @param string $output Passed by reference.
	 */
	function end_lvl( &$output, $depth = 0, $args = array() ) {
	}

	/**
	 * @see Walker::start_el()
	 * @since 3.0.0
	 *
	 * @param string $output Passed by reference. Used to append additional content.
	 * @param object $item Menu item data object.
	 * @param int $depth Depth of menu item. Used for padding.
	 * @param object $args
	 */
	function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
		global $_wp_nav_menu_max_depth;

		$_wp_nav_menu_max_depth = $depth > $_wp_nav_menu_max_depth ? $depth : $_wp_nav_menu_max_depth;

		$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

		ob_start();
		$item_id = esc_attr( $item->ID );
		$removed_args = array(
			'action',
			'customlink-tab',
			'edit-menu-item',
			'menu-item',
			'page-tab',
			'_wpnonce',
		);

		$original_title = '';
		if ( 'taxonomy' == $item->type ) {
			$original_title = get_term_field( 'name', $item->object_id, $item->object, 'raw' );
			if ( is_wp_error( $original_title ) )
				$original_title = false;
		} elseif ( 'post_type' == $item->type ) {
			$original_object = get_post( $item->object_id );
			$original_title = $original_object->post_title;
		}

		$classes = array(
			'menu-item menu-item-depth-' . $depth,
			'menu-item-' . esc_attr( $item->object ),
			'menu-item-edit-' . ( ( isset( $_GET['edit-menu-item'] ) && $item_id == $_GET['edit-menu-item'] ) ? 'active' : 'inactive'),
		);

		$title = $item->title;

		if ( ! empty( $item->_invalid ) ) {
			$classes[] = 'menu-item-invalid';
			/* translators: %s: title of menu item which is invalid */
			$title = sprintf( esc_html__( '%s (Invalid)', 'vintwood' ), $item->title );
		} elseif ( isset( $item->post_status ) && 'draft' == $item->post_status ) {
			$classes[] = 'pending';
			/* translators: %s: title of menu item in draft status */
			$title = sprintf( esc_html__('%s (Pending)', 'vintwood'), $item->title );
		}

		$title = empty( $item->label ) ? $title : $item->label;

		?>
		<li id="menu-item-<?php echo esc_attr($item_id); ?>" class="<?php echo implode(' ', $classes ); ?>">
			<dl class="menu-item-bar">
				<dt class="menu-item-handle">
					<span class="item-title"><?php echo esc_html( $title ); ?></span>
					<span class="item-controls">
						<span class="spinner"></span>
						<span class="item-type"><?php echo esc_html( $item->type_label ); ?></span>
						<span class="item-order hide-if-js">
							<a href="<?php
								echo esc_url(wp_nonce_url(
									add_query_arg(
										array(
											'action' => 'move-up-menu-item',
											'menu-item' => $item_id,
										),
										remove_query_arg($removed_args, admin_url( 'nav-menus.php' ) )
									),
									'move-menu_item'
								));
							?>" class="item-move-up"><abbr title="<?php esc_attr_e('Move up', 'vintwood'); ?>">&#8593;</abbr></a>
							|
							<a href="<?php
								echo esc_url(wp_nonce_url(
									add_query_arg(
										array(
											'action' => 'move-down-menu-item',
											'menu-item' => $item_id,
										),
										remove_query_arg($removed_args, admin_url( 'nav-menus.php' ) )
									),
									'move-menu_item'
								));
							?>" class="item-move-down"><abbr title="<?php esc_attr_e('Move down', 'vintwood'); ?>">&#8595;</abbr></a>
						</span>
						<a class="item-edit" id="edit-<?php echo esc_attr($item_id); ?>" title="<?php esc_attr_e('Edit Menu Item', 'vintwood'); ?>" href="<?php
							echo ( isset( $_GET['edit-menu-item'] ) && $item_id == $_GET['edit-menu-item'] ) ? admin_url( 'nav-menus.php' ) : esc_url(add_query_arg( 'edit-menu-item', $item_id, remove_query_arg( $removed_args, admin_url( 'nav-menus.php#menu-item-settings-' . $item_id ) ) ));
						?>"><?php esc_html_e( 'Edit Menu Item', 'vintwood' ); ?></a>
					</span>
				</dt>
			</dl>

			<div class="menu-item-settings wp-clearfix" id="menu-item-settings-<?php echo esc_attr($item_id); ?>">
				<?php if( 'custom' == $item->type ) : ?>
					<p class="field-url description description-wide">
						<label for="edit-menu-item-url-<?php echo esc_attr($item_id); ?>">
							<?php esc_html_e( 'URL', 'vintwood' ); ?><br />
							<input type="text" id="edit-menu-item-url-<?php echo esc_attr($item_id); ?>" class="widefat code edit-menu-item-url" name="menu-item-url[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->url ); ?>" />
						</label>
					</p>
				<?php endif; ?>
				<p class="description description-thin">
					<label for="edit-menu-item-title-<?php echo esc_attr($item_id); ?>">
						<?php esc_html_e( 'Navigation Label', 'vintwood' ); ?><br />
						<input type="text" id="edit-menu-item-title-<?php echo esc_attr($item_id); ?>" class="widefat edit-menu-item-title" name="menu-item-title[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->title ); ?>" />
					</label>
				</p>
				<p class="description description-thin">
					<label for="edit-menu-item-attr-title-<?php echo esc_attr($item_id); ?>">
						<?php esc_html_e( 'Title Attribute', 'vintwood' ); ?><br />
						<input type="text" id="edit-menu-item-attr-title-<?php echo esc_attr($item_id); ?>" class="widefat edit-menu-item-attr-title" name="menu-item-attr-title[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->post_excerpt ); ?>" />
					</label>
				</p>
				<p class="field-link-target description">
					<label for="edit-menu-item-target-<?php echo esc_attr($item_id); ?>">
						<input type="checkbox" id="edit-menu-item-target-<?php echo esc_attr($item_id); ?>" value="_blank" name="menu-item-target[<?php echo esc_attr($item_id); ?>]"<?php checked( $item->target, '_blank' ); ?> />
						<?php esc_html_e( 'Open link in a new window/tab', 'vintwood' ); ?>
					</label>
				</p>
				<p class="field-css-classes description description-thin">
					<label for="edit-menu-item-classes-<?php echo esc_attr($item_id); ?>">
						<?php esc_html_e( 'CSS Classes (optional)', 'vintwood' ); ?><br />
						<input type="text" id="edit-menu-item-classes-<?php echo esc_attr($item_id); ?>" class="widefat code edit-menu-item-classes" name="menu-item-classes[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( implode(' ', $item->classes ) ); ?>" />
					</label>
				</p>
				<p class="field-xfn description description-thin">
					<label for="edit-menu-item-xfn-<?php echo esc_attr($item_id); ?>">
						<?php esc_html_e( 'Link Relationship (XFN)', 'vintwood' ); ?><br />
						<input type="text" id="edit-menu-item-xfn-<?php echo esc_attr($item_id); ?>" class="widefat code edit-menu-item-xfn" name="menu-item-xfn[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->xfn ); ?>" />
					</label>
				</p>
				<p class="field-description description description-wide">
					<label for="edit-menu-item-description-<?php echo esc_attr($item_id); ?>">
						<?php esc_html_e( 'Description', 'vintwood' ); ?><br />
						<textarea id="edit-menu-item-description-<?php echo esc_attr($item_id); ?>" class="widefat edit-menu-item-description" rows="3" cols="20" name="menu-item-description[<?php echo esc_attr($item_id); ?>]"><?php echo esc_html( $item->description ); ?></textarea>
						<span class="description"><?php esc_html_e('The description will be displayed in the menu if the current theme supports it.', 'vintwood'); ?></span>
					</label>
				</p>

				<?php
				/* New fields insertion starts here */
				?>

				<p class="field-custom description description-thin description-thin-custom">
					<label for="edit-menu-item-align-<?php echo esc_attr($item_id); ?>">
						<?php esc_html_e( 'Text alignment', 'vintwood' ); ?><br />
						<select class="widefat" id="edit-menu-item-align<?php echo esc_attr($item_id); ?>" data-item-option data-name="align-<?php echo sprintf("%s", $item_id); ?>">
							<option value="left" <?php if($item->align == "left"){echo 'selected="selected"';} ?>>Left</option>
							<option value="center" <?php if($item->align == "center"){echo 'selected="selected"';} ?>>Center</option>
							<option value="right" <?php if($item->align == "right"){echo 'selected="selected"';} ?>>Right</option>
						</select>
					</label>
				</p>

				<?php
				$icon_data_attr = 'icon-'. esc_attr($item_id);

				$icons = cws_get_all_fa_icons();
				$isIcons = !empty($icons);

				$ficons = cws_get_all_flaticon_icons();
				$isFlatIcons = !empty($ficons);

				$output_icons = '<option value=""></option>';
				?>

				<p class="field-custom description description-thin description-thin-custom">
					<label for="edit-menu-item-icon-<?php echo esc_attr($item_id); ?>">
						<?php esc_html_e( 'Icon', 'vintwood' ); ?><br />
						<select class="widefat icons-select" id="edit-menu-item-icon<?php echo esc_attr($item_id); ?>" data-item-option data-name="<?php echo esc_attr($icon_data_attr); ?>">
							<?php
							if ($isIcons){
								$output_icons .= '<optgroup label="Font Awesome">';
								foreach ($icons as $icon) {
									$selected = ($item->icon === 'fa fa-' . $icon) ? ' selected' : '';
									$output_icons .= '<option value="fa fa-' . esc_attr($icon) . '" '.esc_attr($selected).'>' . esc_attr($icon) . '</option>';
								}
								$output_icons .= '</optgroup>';
							}

							if ($isFlatIcons){
								$output_icons .= '<optgroup label="Flaticon">';
								foreach ($ficons as $icon) {
									$selected = ($item->icon === 'flaticon-' . $icon) ? ' selected' : '';
									$output_icons .= '<option value="flaticon-' . esc_attr($icon) . '" '.esc_attr($selected).'>' . esc_attr($icon) . '</option>';
								}
								$output_icons .= '</optgroup>';
							}

							echo sprintf("%s", $output_icons);
							?>
						</select>
						<br/><?php esc_html_e( 'Select icon from list', 'vintwood' ); ?>
					</label>
				</p>

				<p class="field-custom description description-thin">
					<?php
					$value = $item->hide;
					if($value != "") $value = "checked";
					?>
					<label for="edit-menu-item-hide-<?php echo esc_attr($item_id); ?>">
						<input type="checkbox" id="edit-menu-item-hide-<?php echo esc_attr($item_id); ?>" class="code edit-menu-item-custom" data-item-option data-name="hide-<?php echo sprintf("%s", $item_id); ?>" value="hide" <?php echo esc_attr($value); ?> />
						<?php esc_html_e( "Don't show in menu", 'vintwood' ); ?>
					</label>
				</p>

				<p class="field-custom description description-thin description-thin-custom">
					<?php
					$value = $item->tag;
					if($value != "") $value = "checked";
					?>
					<label for="edit-menu-item-tag-<?php echo esc_attr($item_id); ?>">
						<input type="checkbox" id="edit-menu-item-tag-<?php echo esc_attr($item_id); ?>" class="code edit-menu-item-custom" data-item-option data-name="tag-<?php echo sprintf("%s", $item_id); ?>" value="tag" <?php echo esc_attr($value); ?> />
						<?php esc_html_e( "Show tag label", 'vintwood' ); ?>
					</label>
				</p>				

				<p class="field-custom description description-wide description-wide-custom">
					<label for="edit-menu-item-tag_text-<?php echo esc_attr($item_id); ?>">
						<?php esc_html_e( 'Tag text', 'vintwood' ); ?><br />
						<input type="text" id="edit-menu-item-tag_text-<?php echo esc_attr($item_id); ?>" class="widefat code edit-menu-item-tag_text" data-item-option data-name="tag_text-<?php echo sprintf("%s", $item_id); ?>" value="<?php echo esc_attr( $item->tag_text ); ?>" />
					</label>
				</p>

				<p class="field-custom description description-thin description-thin-custom">
					<label for="edit-menu-item-tag_font_color-<?php echo esc_attr($item_id); ?>">
						<?php esc_html_e( 'Tag color', 'vintwood' ); ?><br />
						<input type="text" data-default-color="<?php echo esc_attr(VINTWOOD_FIRST_COLOR);?>" id="edit-menu-item-tag_font_color-<?php echo esc_attr($item_id); ?>" class="color_picker widefat code edit-menu-item-tag_font_color" data-item-option data-name="tag_font_color-<?php echo sprintf("%s", $item_id); ?>" value="<?php echo esc_attr( $item->tag_font_color ); ?>" />
					</label>
				</p>

				<p class="field-custom description description-thin description-thin-custom">
					<label for="edit-menu-item-tag_bg_color-<?php echo esc_attr($item_id); ?>">
						<?php esc_html_e( 'Tag background', 'vintwood' ); ?><br />
						<input type="text" data-default-color="#ffffff" id="edit-menu-item-tag_bg_color-<?php echo esc_attr($item_id); ?>" class="color_picker widefat code edit-menu-item-tag_bg_color" data-item-option data-name="tag_bg_color-<?php echo sprintf("%s", $item_id); ?>" value="<?php echo esc_attr( $item->tag_bg_color ); ?>" />
					</label>
				</p>								

				<?php
				/* New fields insertion ends here */
				?>
				<div class="menu-item-actions description-wide submitbox">
					<?php if( 'custom' != $item->type && $original_title !== false ) : ?>
						<p class="link-to-original">
							<?php printf( esc_html__('Original: %s', 'vintwood'), '<a href="' . esc_attr( $item->url ) . '">' . esc_html( $original_title ) . '</a>' ); ?>
						</p>
					<?php endif; ?>
					<a class="item-delete submitdelete deletion" id="delete-<?php echo esc_attr($item_id); ?>" href="<?php
					echo esc_url(wp_nonce_url(
						add_query_arg(
							array(
								'action' => 'delete-menu-item',
								'menu-item' => $item_id,
							),
							remove_query_arg($removed_args, admin_url( 'nav-menus.php' ) )
						),
						'delete-menu_item_' . esc_attr($item_id)
					)); ?>"><?php esc_html_e('Remove', 'vintwood'); ?></a> <span class="meta-sep"> | </span> <a class="item-cancel submitcancel" id="cancel-<?php echo esc_attr($item_id); ?>" href="<?php echo esc_url( add_query_arg( array('edit-menu-item' => $item_id, 'cancel' => time()), remove_query_arg( $removed_args, admin_url( 'nav-menus.php' ) ) ) );
						?>#menu-item-settings-<?php echo esc_attr($item_id); ?>"><?php esc_html_e('Cancel', 'vintwood'); ?></a>
				</div>

				<input class="menu-item-data-db-id" type="hidden" name="menu-item-db-id[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr($item_id); ?>" />
				<input class="menu-item-data-object-id" type="hidden" name="menu-item-object-id[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->object_id ); ?>" />
				<input class="menu-item-data-object" type="hidden" name="menu-item-object[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->object ); ?>" />
				<input class="menu-item-data-parent-id" type="hidden" name="menu-item-parent-id[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->menu_item_parent ); ?>" />
				<input class="menu-item-data-position" type="hidden" name="menu-item-position[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->menu_order ); ?>" />
				<input class="menu-item-data-type" type="hidden" name="menu-item-type[<?php echo esc_attr($item_id); ?>]" value="<?php echo esc_attr( $item->type ); ?>" />
			</div><!-- .menu-item-settings-->
			<ul class="menu-item-transport"></ul>
		<?php

		$output .= ob_get_clean();

		}
}
/****************** /WALKER CUSTOM MENU *********************/

/****************** WALKER *********************/
class Vintwood_Walker_Nav_Menu extends Walker {
	private $elements;
	private $elements_counter = 0;
	private $cws_theme_funcs;

	function __construct($a) {
		$this->cws_theme_funcs = $a;
	}

	function walk ($items, $depth, ...$args) {
		$this->elements = $this->get_number_of_root_elements($items);
		return parent::walk($items, $depth);
	}

	/**
	 * @see Walker::$tree_type
	 * @since 3.0.0
	 * @var string
	 */
	var $tree_type = array( 'post_type', 'taxonomy', 'custom' );

	/**
	 * @see Walker::$db_fields
	 * @since 3.0.0
	 * @todo Decouple this.
	 * @var array
	 */
	var $db_fields = array( 'parent' => 'menu_item_parent', 'id' => 'db_id' );

	/**
	 * @see Walker::start_lvl()
	 * @since 3.0.0
	 *
	 * @param string $output Passed by reference. Used to append additional content.
	 * @param int $depth Depth of page. Used for padding.
	 */
	function start_lvl( &$output, $depth = 0, $args = array() ) {
		$indent = str_repeat("\t", $depth);
		$output .= "\n$indent<span class='button_open'></span><ul class=\"sub-menu\">";
		$output .= "\n";
	}
	/**
	 * @see Walker::end_lvl()
	 * @since 3.0.0
	 *
	 * @param string $output Passed by reference. Used to append additional content.
	 * @param int $depth Depth of page. Used for padding.
	 */
	function end_lvl( &$output, $depth = 0, $args = array() ) {
		$indent = str_repeat("\t", $depth);
		$output .= "$indent</ul>\n";
	}
	/**
	 * @see Walker::start_el()
	 * @since 3.0.0
	 *
	 * @param string $output Passed by reference. Used to append additional content.
	 * @param object $item Menu item data object.
	 * @param int $depth Depth of menu item. Used for padding.
	 * @param int $current_page Menu item ID.
	 * @param object $args
	 */

	function logo_ini( $indent, $item ) {
		$logo_box = $this->cws_theme_funcs->cws_get_meta_option( 'logo_box' );
		extract($logo_box, EXTR_PREFIX_ALL, 'logo_box');

		$logo_cont = '';

		$logo_lr_spacing = $logo_tb_spacing = $main_logo_height = '';

		if( isset($this->cws_theme_funcs->cws_get_option('logo_box')[$logo_box_default]) ){
			$logo = $this->cws_theme_funcs->cws_get_option('logo_box')[$logo_box_default];
		} else if( $this->cws_theme_funcs->cws_get_meta_option('logo_box')['default'] == 'custom' ){
			$logo = $this->cws_theme_funcs->cws_get_meta_option('logo_box')['custom'];
		} else {
			$logo = '';
		}

		if ( $logo_box_position == 'center' && $logo_box_in_menu == '1' && $logo_box_enable ) {
			if ( !empty($logo['src']) ) {			
				$bfi_args = $bfi_args_sticky = $bfi_args_mobile = array();
				if ( isset($logo_box_dimensions) && is_array( $logo_box_dimensions ) ) {
					foreach ( $logo_box_dimensions as $key => $value ) {
						if ( !empty( $value ) ) {
							$bfi_args[ $key ] = $value;
							$bfi_args['crop'] = true;
						}
					}
				}
				if ( isset($logo_box_dimensions_sticky) && is_array( $logo_box_dimensions_sticky ) ) {
					foreach ( $logo_box_dimensions_sticky as $key => $value ) {
						if ( !empty( $value ) ) {
							$bfi_args_sticky[ $key ] = $value;
							$bfi_args_sticky['crop'] = true;
						}
					}
				}				
				if ( isset($logo_box_dimensions_mobile) && is_array( $logo_box_dimensions_mobile ) ) {
					foreach ( $logo_box_dimensions_mobile as $key => $value ) {
						if ( !empty( $value ) ) {
							$bfi_args_mobile[ $key ] = $value;
							$bfi_args_mobile['crop'] = true;
						}
					}
				}

				$logo_lr_spacing = $logo_tb_spacing = '';
				if ( is_array( $logo_box_margin ) ) {
					$logo_lr_spacing = $this->cws_theme_funcs->cws_print_css_keys($logo_box_margin, 'margin-', 'px');
					$logo_tb_spacing = $this->cws_theme_funcs->cws_print_css_keys($logo_box_margin, 'padding-', 'px');
				}

				$img_mrg = ! empty( $logo_lr_spacing ) ? "style='".esc_attr( $logo_lr_spacing )."'" : '';

				$logo_src = $this->cws_theme_funcs->cws_print_img_html($logo, $bfi_args, $main_logo_height);

				$img_result = '';
				if(!empty($logo_src)){
					$img_result .= '<img '. $logo_src .' '.$img_mrg.' class="logo_desktop" />';		
				}



				if(!empty($logo['src'])){
					$file_parts = pathinfo($logo['src']);
					if($file_parts['extension'] == 'svg'){
						$img_result = $this->cws_theme_funcs->cws_print_svg_html($logo, $bfi_args, $main_logo_height);
					}			
				}

				$logo_sticky = $this->cws_theme_funcs->cws_get_option('logo_box')['sticky'];
				if ( isset($logo_sticky) && !empty( $logo_sticky['src'] ) ) {
					$logo_sticky_src = $this->cws_theme_funcs->cws_print_img_html($logo_sticky['id'], (!empty($bfi_args_sticky) ? $bfi_args_sticky : null));
				}

				$logo_mobile = $this->cws_theme_funcs->cws_get_option('logo_box')['mobile'];
				if (isset($logo_mobile) && !empty($logo_mobile['src'])) {
					$logo_mobile_src = $this->cws_theme_funcs->cws_print_img_html($logo_mobile['id'], (!empty($bfi_args_mobile) ? $bfi_args_mobile : null));
				}

				$rety = home_url();

				$logo_cont .= '</ul></div>';

				$logo_cont .= '<div class="header_logo_part menu-center-part'.( empty($logo_mobile['src']) ? ' no_mobile_logo' : '' ).'">';
					$logo_cont .= '<a class="logo" href="'.$rety.'">';

						if (!empty($logo_sticky_src)){
							$file_parts_sticky = pathinfo($logo['src']);
							if ($file_parts_sticky['extension'] != 'svg'){
								$logo_cont .= ($logo_sticky_src ?  '<img '.$logo_sticky_src." class='logo_sticky' />" : '');
							} else {
								$logo_cont .= "<span class='logo_sticky'>";
								$logo_cont .= $this->cws_theme_funcs->cws_print_svg_html($logo_sticky, $bfi_args);
								$logo_cont .= "</span>";
							}
						}						

						if (!empty($logo_mobile_src)){
							$file_parts_mobile = pathinfo($logo['src']);
							if ($file_parts_mobile['extension'] != 'svg'){
								$logo_cont .= ($logo_mobile_src ? '<img '.$logo_mobile_src." class='logo_mobile' />" : '');
							} else {
								$logo_cont .= "<span class='logo_mobile'>";
								$logo_cont .= $this->cws_theme_funcs->cws_print_svg_html($logo_mobile, $bfi_args);
								$logo_cont .= "</span>";
							}
						}
						$logo_cont .= $img_result;
					$logo_cont .= '</a>';

				$logo_cont .= '</div>';

				$logo_cont .= '<div class="menu-right-part">';
					$logo_cont .= '<ul class="main-menu">';

			} else {
				$logo_cont = '
				</ul></div>
					<div class="header_logo_part menu-center-part">
						<h1 class="header_site_title">'.esc_html(get_bloginfo( 'name' )).'</h1>
					</div>
				<div class="menu-right-part"><ul class="main-menu">';
			}
		}

		return $logo_cont;

	}

	function site_name_ini( $indent, $item ) {
		$logo_box_position = $this->cws_theme_funcs->cws_get_meta_option( 'logo_box' )['position'];
		if ( $indent == 0 && $logo_box_position == 'center' ) {
			ob_start();
			?>
			</ul></div>
				<div class="header_logo_part site_name menu-center-part" <?php echo isset( $logo_box_position ) && !empty( $logo_box_position ) && $logo_box_position == 'center' && ! empty( $logo_tb_spacing ) ? " style='".esc_attr($logo_tb_spacing)."'" : ''; ?>>
					<a <?php echo ( ! empty( $logo_lr_spacing ) ? " style='".esc_attr($logo_lr_spacing)."'" : '') ?> class="logo" href="<?php echo esc_url( home_url() ); ?>" >
						<h1 class='header_site_title'><?php echo get_bloginfo( 'name' ); ?></h1>
					</a>
							</div>
					<div class="menu-right-part"><ul class="main-menu">
						<?php
						$site_name_cont = ob_get_clean();
		} else {
			$site_name_cont = '';
		}
		return $site_name_cont;
	}

	function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
		$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

		$class_names = $value = '';

		$classes = empty( $item->classes ) ? array() : (array) $item->classes;
		$classes[] = 'menu-item-' . sanitize_html_class( $item->ID );

		//Custom menu fields
		if ($item->align != 'left'){
			array_push($classes,'link_align_'.$item->align);
		}

		if ($item->hide == 'hide'){
			array_push($classes,'hide_link');
		}	
		//Custom menu fields	

		if ($item->menu_item_parent=="0") {
			$this->elements_counter += 1;
			if ($this->elements_counter>$this->elements/2){
				array_push($classes,'right');
			}
		}

		$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );
		$class_names = $class_names ? ' class="' . $class_names  . '"' : '';

		$id = apply_filters( 'nav_menu_item_id', 'menu-item-'. sanitize_html_class( $item->ID ), $item, $args );
		$id = $id ? ' id="' . $id . '"' : '';

		// logo in cont init;
		if ( $item->menu_item_parent == '0' && $this->elements_counter == floor(($this->elements / 2)+1) ) {
			$logo_container = $this->logo_ini( $indent, $item );
		} else {
			$logo_container = '';
		}

		$output .= $indent . (!empty($search_and_woo_icon_start) ? $search_and_woo_icon_start : '' ) . $logo_container .(!empty($site_name_container) ? $site_name_container : ''). '<li' . $id . $value . $class_names .'>';

		$atts = array();
		$atts['title']  = ! empty( $item->attr_title ) ? $item->attr_title : '';
		$atts['target'] = ! empty( $item->target )	 ? $item->target	 : '';
		$atts['rel']	= ! empty( $item->xfn )		? $item->xfn		: '';
		$atts['href']   = ! empty( $item->url )		? $item->url		: '';

		$atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args );

		$attributes = '';
		foreach ( $atts as $attr => $value ) {
			if ( ! empty( $value ) ) {
				$value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
				$attributes .= ' ' . $attr . '="' . $value . '"';
			}
		}
		$item_output = !empty($args->before) ? $args->before : '';
		$item_output .= '<a'. $attributes .'>';

		$item_output .= ( !empty($args->link_before) ? $args->link_before : "" ) .
			apply_filters( 'nav_menu_item_title', $item->title, $item, $args, $depth ) .
			(is_rtl() ? '&#x200E;' : '') . ( !empty($args->link_after ) ? $args->link_after : "" );

		$item_output .= '</a>';
		$item_output .= ( !empty($args->after) ? $args->after : '' );

		$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
	}

	/**
	 * @see Walker::end_el()
	 * @since 3.0.0
	 *
	 * @param string $output Passed by reference. Used to append additional content.
	 * @param object $item Page data object. Not used.
	 * @param int $depth Depth of page. Not Used.
	 */


	function end_el( &$output, $item, $depth = 0, $args = array() ) {
		$output .= "</li>\n".(!empty($search_and_woo_icon_end) ? $search_and_woo_icon_end : '');
	}
}
/****************** /WALKER *********************/

/****************** MOBILE WALKER *********************/
class Vintwood_Walker_Nav_Mobile_Menu extends Walker {
	private $elements;
	private $elements_counter = 0;
	private $cws_theme_funcs;

	function __construct($a) {
		$this->cws_theme_funcs = $a;
	}

	function walk ($items, $depth, ...$args) {
		$this->elements = $this->get_number_of_root_elements($items);
		return parent::walk($items, $depth);
	}

	var $tree_type = array( 'post_type', 'taxonomy', 'custom' );
	var $db_fields = array( 'parent' => 'menu_item_parent', 'id' => 'db_id' );

	function start_lvl( &$output, $depth = 0, $args = array() ) {
		$indent = str_repeat("\t", $depth);
		$output .= "\n$indent<ul class=\"sub-menu\">";
		$output .= "\n";
	}

	function end_lvl( &$output, $depth = 0, $args = array() ) {
		$indent = str_repeat("\t", $depth);
		$output .= "$indent</ul>\n";
	}

	function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
		$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

		$class_names = $value = '';

		$classes = empty( $item->classes ) ? array() : (array) $item->classes;
		$classes[] = 'menu-item-' . sanitize_html_class( $item->ID );

		if ($item->menu_item_parent=="0") {
			$this->elements_counter += 1;
			if ($this->elements_counter>$this->elements/2){
				array_push($classes,'right');
			}
		}

		$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );
		$class_names = $class_names ? ' class="' . $class_names  . '"' : '';

		$id = apply_filters( 'nav_menu_item_id', 'menu-item-'. sanitize_html_class( $item->ID ), $item, $args );
		$id = $id ? ' id="' . $id . '"' : '';

		$output .= $indent . '<li' . $id . $value . $class_names .'>';

		$atts = array();
		$atts['title']  = ! empty( $item->attr_title ) ? $item->attr_title : '';
		$atts['target'] = ! empty( $item->target )	 ? $item->target	 : '';
		$atts['rel']	= ! empty( $item->xfn )		? $item->xfn		: '';
		$atts['href']   = ! empty( $item->url )		? $item->url		: '';

		$atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args );

		$attributes = '';
		foreach ( $atts as $attr => $value ) {
			if ( ! empty( $value ) ) {
				$value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
				$attributes .= ' ' . $attr . '="' . $value . '"';
			}
		}

		$item_output = !empty($args->before) ? $args->before : '';
		$item_output .= '<span class="menu_row"><a'. $attributes .'>';

		$item_output .= ( !empty($args->link_before) ? $args->link_before : '' ) . apply_filters( 'the_title', $item->title, $item->ID ) . (is_rtl() ? '&#x200E;' : '') . ( !empty($args->link_after ) ? $args->link_after : '' );
		$item_output .= '</a>';

		if (is_array($item->classes)){
			if ( in_array( 'menu-item-has-children', $item->classes ) ){
				$item_output .= "<span class='button_open'></span>";
			}
		}

		$item_output .= '</span>';
		$item_output .= ( !empty($args->after) ? $args->after : '' );

		$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
	}

	function end_el( &$output, $item, $depth = 0, $args = array() ) {
		$output .= "</li>\n";

		if( $this->elements_counter == $this->elements ){
			$output .= "<li class='mobile_menu_search'>". $this->cws_theme_funcs->cws_clean_search_form() . "</li>";
		}
	}
}
/****************** /MOBILE WALKER *********************/

/****************** SCROLL TO TOP *********************/
function cws_scroll_to_top (){
	ob_start();

	echo "<div id='scroll_to_top' class='animated'></div>";
	
	return ob_get_clean();
}
/****************** /SCROLL TO TOP *********************/

/****************** COPYRIGHTS WALKER *********************/
class Vintwood_Walker_Nav_Copyright_Menu extends Walker {
	private $elements;
	private $elements_counter = 0;
	private $cws_theme_funcs;

	function __construct($a) {
		$this->cws_theme_funcs = $a;
	}

	function walk ($items, $depth, ...$args) {
		$this->elements = $this->get_number_of_root_elements($items);
		return parent::walk($items, $depth);
	}

	var $tree_type = array( 'post_type', 'taxonomy', 'custom' );
	var $db_fields = array( 'parent' => 'menu_item_parent', 'id' => 'db_id' );

	function start_lvl( &$output, $depth = 0, $args = array() ) {
		$indent = str_repeat("\t", $depth);
		$output .= "\n$indent<ul class=\"sub-menu\">";
		$output .= "\n";
	}

	function end_lvl( &$output, $depth = 0, $args = array() ) {
		$indent = str_repeat("\t", $depth);
		$output .= "$indent</ul>\n";
	}

	function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
		$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

		$class_names = $value = '';

		$classes = empty( $item->classes ) ? array() : (array) $item->classes;
		$classes[] = 'menu-item-' . sanitize_html_class( $item->ID );

		if ($item->menu_item_parent=="0") {
			$this->elements_counter += 1;
			if ($this->elements_counter>$this->elements/2){
				array_push($classes,'right');
			}
		}

		$class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );
		$class_names = $class_names ? ' class="' . esc_attr($class_names)  . '"' : '';

		$id = apply_filters( 'nav_menu_item_id', 'top-bar-menu-item-'. sanitize_html_class( $item->ID ), $item, $args );
		$id = $id ? ' id="' . $id . '"' : '';

		$output .= $indent . '<li' . $id . $value . $class_names .'>';

		$atts = array();
		$atts['title']  = ! empty( $item->attr_title ) ? $item->attr_title : '';
		$atts['target'] = ! empty( $item->target )	 ? $item->target	 : '';
		$atts['rel']	= ! empty( $item->xfn )		? $item->xfn		: '';
		$atts['href']   = ! empty( $item->url )		? $item->url		: '';

		$atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args );

		$attributes = '';
		foreach ( $atts as $attr => $value ) {
			if ( ! empty( $value ) ) {
				$value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
				$attributes .= ' ' . $attr . '="' . $value . '"';
			}
		}

		$item_output = !empty($args->before) ? $args->before : '';
		$item_output .= '<a'. $attributes .'>';

		$item_output .= ( !empty($args->link_before) ? $args->link_before : '' ) . apply_filters( 'the_title', $item->title, $item->ID ) . (is_rtl() ? '&#x200E;' : '') . ( !empty($args->link_after ) ? $args->link_after : '' );
		$item_output .= '</a>';

		if ( in_array( 'menu-item-has-children', $item->classes ) ){
			$item_output .= "<span class='button_open'></span>";
		}
		$item_output .= ( !empty($args->after) ? $args->after : '' );

		$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
	}

	function end_el( &$output, $item, $depth = 0, $args = array() ) {
		$output .= "</li>\n";
	}
}

/****************** /COPYRIGHTS WALKER *********************/

/* Comments */
class VINTWOOD_Walker_Comment extends Walker_Comment {
	// init classwide variables
	var $tree_type = 'comment';
	var $db_fields = array( 'parent' => 'comment_parent', 'id' => 'comment_ID' );
	function __construct() { ?>
		<div class="comment_list">
	<?php }

	/** START_LVL
	 * Starts the list before the CHILD elements are added. Unlike most of the walkers,
	 * the start_lvl function means the start of a nested comment. It applies to the first
	 * new level under the comments that are not replies. Also, it appear that, by default,
	 * WordPress just echos the walk instead of passing it to &$output properly. Go figure.  */
	function start_lvl( &$output, $depth = 0, $args = array() ) {
		$GLOBALS['comment_depth'] = $depth + 1; ?>
		<div class="comments_children">
	<?php }

	/** END_LVL
	 * Ends the children list of after the elements are added. */
	function end_lvl( &$output, $depth = 0, $args = array() ) {
		$GLOBALS['comment_depth'] = $depth + 1; ?>
		</div><!-- /.children -->

	<?php }

	/** START_EL */
	function start_el( &$output, $comment, $depth = 0, $args = array(), $id = 0 ) {
		$depth++;
		global $cws_theme_funcs;
		$GLOBALS['comment_depth'] = $depth;
		$GLOBALS['comment'] = $comment;
		$parent_class = ( empty( $args['has_children'] ) ? '' : 'parent' );
		$old_version = 0;
		?>

		<div <?php comment_class( $parent_class ); ?> id="comment-<?php comment_ID() ?>">
			<div id="comment-body-<?php comment_ID() ?>" class="comment-body clearfix">

				<div class="avatar_section">
					<?php if($args['avatar_size'] != 0){echo get_avatar($comment, $args['avatar_size']);} ?>

				</div>
				<div class="comment_info_section">
					<div class="comment_info_header">
							<?php $reply_args = array(
								'reply_text' => esc_html__( 'Reply', 'vintwood' ),
								'depth' => $depth,
								'max_depth' => $args['max_depth']
							);
						?>
						<div class="comment-meta comment-meta-data">
							<cite class="fn n author-name"><?php echo get_comment_author_link(); ?></cite>
							<p class="comment_info">
								<span class="comment_date"><?php
									echo "<span class='date'>";
										comment_date();
									echo "</span>";
									esc_html_e( ' at', 'vintwood' );
									echo " <span class='time'>";
										comment_time();
									echo "</span>";
									?>
								</span>
								<?php edit_comment_link( '(Edit)' ); ?>
							</p>
						</div><!-- /.comment-meta -->


					</div>

					<div id="comment-content-<?php comment_ID(); ?>" class="comment-content">
						<?php
						if( !$comment->comment_approved )
						{ ?>
						    <em class="comment-awaiting-moderation"><?php esc_html_e('Your comment is awaiting moderation.', 'vintwood'); ?></em>
						<?php
						} else {
						    if ($comment->comment_type != 'pingback')
						    {
						        comment_text();
						    }
						} ?>
					</div><!-- /.comment-content -->
					<?php 
					echo "<div class='button-content reply'>";
					comment_reply_link( array_merge( $args, $reply_args ) );
					echo '</div>'; 
					?>
				</div>
			</div><!-- /.comment-body -->

	<?php }

	function end_el(&$output, $comment, $depth = 0, $args = array() ) { ?>

		</div><!-- /#comment-' . get_comment_ID() . ' -->

	<?php }

	/** DESTRUCTOR
	 * I just using this since we needed to use the constructor to reach the top
	 * of the comments list, just seems to balance out :) */
	function __destruct() { ?>

	</div><!-- /#comment-list -->

	<?php }
}
/* \Comments */

?>