<?php

function cws_sc_blog($p){
	return function_exists( "cws_blog_output" ) ? cws_blog_output( $p ) : "";
}

//Get defaults values for Blog
function cws_blog_defaults( $extra_vars = array() ){
	global $cws_theme_funcs;

	$def_blogtype = $cws_theme_funcs ? $cws_theme_funcs->cws_get_option( "def_blogtype" ) : 'def';
	$def_chars_count = $cws_theme_funcs ? $cws_theme_funcs->cws_get_option( "def_chars_count" ) : '200';
	$def_chars_count = isset( $def_chars_count ) && is_numeric( $def_chars_count ) ? $def_chars_count : '200';

	$defaults = array(
		'display_style'							=> 'grid',	
		'blog_aligning'							=> 'center',	
		'button_aligning'						=> 'center',
		'auto_play_carousel'                    => '',
		'navigation_carousel'                   => '',
		'pagination_carousel'                   => '',
		'layout'								=> $def_blogtype,
		'content_align'							=> 'top',
		'orderby'								=> 'date',
		'order'									=> 'DESC',
		'huge_spacings'							=> false,
		'crop_featured'							=> false,
		'more_btn_text'							=> esc_html__('CONTINUE READING', 'vintwood'),
		'link_show'								=> 'single_link',
		'post_hide_meta_override'				=> false,
		'post_hide_meta'						=> array(),
		'total_items_count'						=> '',
		'items_pp'								=>  esc_html( get_option( 'posts_per_page' ) ),
		'pagination_grid'						=> '',
		'aligning'      						=> 'center',
		'chars_count'							=> $def_chars_count,

		//Service params
		'tax'									=> '',
		'titles'								=> '',
		'terms'									=> '',
		'addl_query_args'						=> array(),
		'full_width'							=> '',
		'el_class'								=> '',
		"css_animation"							=> "none",
		'related_items'							=> '',
	);

	if (!empty($extra_vars)){
		$defaults = array_merge($defaults, $extra_vars);
	}

	return $defaults;
}

function cws_meta_default() {
	return array(
		'post_header_box_image' => 
			array(
				'src' => '',
				'id' => '',
			),
		'gallery_type' => 'slider',
		'gallery' => '',
		'video' => '',
		'audio' => '',
		'link' => '',
		'link_title' => '',
		'quote_text' => '',
		'quote_author' => '',
		'post_sidebars' => 
			array(
				'layout' => 'none',
			),
		'author_info' => '1',
		'show_featured' => '1',
		'full_width_featured' => '0',
		'show_related' => '1',
		'rpo' => 
			array(
				'title' => 'Related items',
				'text_length' => '90',
				'cols' => '3',
				'items_show' => '3',
				'posts_hide' => 
					array(
						'none',
						'tags',
						'author',
						'likes',
						'comments',
						'read_more',
						'social',
						'excerpt',
					),
			),
		'post_cust_color' => '0',
	);
}

//Fill atts from function to function
function cws_blog_fill_atts( $atts = array() ){
	global $cws_theme_funcs;

	extract( $atts );

	$post_id = get_the_id();
	$post_meta = get_post_meta( $post_id, 'cws_mb_post' );
	$post_meta = isset( $post_meta[0] ) ? $post_meta[0] : array();

	$total_items_count = !empty( $total_items_count ) ? (int)$total_items_count : PHP_INT_MAX;
	if ($cws_theme_funcs) {
		$huge_layout = $cws_theme_funcs->cws_get_meta_option('boxed')['huge_layout'];
	} else { 
		$huge_layout = '';
	}
	$def_post_layout = $cws_theme_funcs ? $cws_theme_funcs->cws_get_option( 'def_blogtype' ) : 'def';
	$def_post_layout = isset( $def_post_layout ) ? $def_post_layout : "";
	$layout = ( empty( $layout ) || $layout === "def" ) ? $def_post_layout : $layout; 
	$cws_row_atts = isset($GLOBALS['cws_row_atts']) && !empty($GLOBALS['cws_row_atts']) ? $GLOBALS['cws_row_atts'] : "";
	$full_width = isset($cws_row_atts['full_width']) && ($cws_row_atts['full_width'] == 'stretch_row_content' || $cws_row_atts['full_width'] == 'stretch_row_content_no_spaces');

	$sb = $cws_theme_funcs ? $cws_theme_funcs->cws_render_sidebars( get_queried_object_id() ) : '';
	$sb_layout = isset( $sb['layout_class'] ) ? $sb['layout_class'] : '';	

	$post_hide_meta_override = !empty( $post_hide_meta_override ) ? true : false;
	$post_hide_meta = is_string($post_hide_meta) ? explode( ",", $post_hide_meta ) : $post_hide_meta;
	$post_def_hide_meta = $cws_theme_funcs ? $cws_theme_funcs->cws_get_option( 'def_post_hide_meta' ) : array();
	$post_def_hide_meta  = is_array( $post_def_hide_meta ) ? $post_def_hide_meta : array();
	$post_hide_meta = $post_hide_meta_override ? $post_hide_meta : $post_def_hide_meta;

	if ($related_items){
		$def_post_hide_meta_related_items = $cws_theme_funcs ? $cws_theme_funcs->cws_get_option( 'def_post_hide_meta_related_items' ) : array();
		if (!empty($def_post_hide_meta_related_items)){
			$post_hide_meta = $def_post_hide_meta_related_items;
		}	
	}

	//Set GLOBALS vars
	$GLOBALS['cws_vc_shortcode_posts_grid_atts'] = array(
		'post_id'				=> $post_id,
		'post_meta'				=> $post_meta,
		'layout'				=> $layout,
		'sb_layout'				=> $sb_layout,
		'post_hide_meta'		=> $post_hide_meta,
		'chars_count'			=> $chars_count,
		'full_width'			=> $full_width,
		'related_items'			=> $related_items,
		'more_btn_text'			=> $more_btn_text,
		'link_show'				=> $link_show,
		'huge_spacings'			=> $huge_spacings,
		'crop_featured'			=> $crop_featured,
		'orderby'				=> $orderby,
		'order'					=> $order,
		'huge_layout'			=> $huge_layout,
		'total_items_count'		=> $total_items_count
	);

	return array(
		'layout'				=> $layout,
		'sb_layout'				=> $sb_layout,
		'post_hide_meta'		=> $post_hide_meta,
		'full_width'			=> $full_width,
		'related_items'			=> $related_items,
		'more_btn_text'			=> $more_btn_text,
		'huge_spacings'			=> $huge_spacings,
		'crop_featured'			=> $crop_featured,
		'orderby'				=> $orderby,
		'order'					=> $order,
		'huge_layout'			=> $huge_layout,
		'total_items_count'		=> $total_items_count
	);
}

function cws_blog_output ( $atts = array(), $content = "" ){
	global $cws_theme_funcs;
	$out = "";
	$defaults = cws_blog_defaults();
	$atts = shortcode_atts( $defaults, $atts );
	extract( $atts );

	global $display_post;
	$display_post = isset($display_style) && !empty($display_style) ? $display_style : "";
	$post_type = "post";
	$section_id = uniqid( 'posts_grid_' );
	$blog_class = '';
	if ($cws_theme_funcs) {
		$huge_layout = $cws_theme_funcs->cws_get_meta_option('boxed')['huge_layout'];
	} else { 
		$huge_layout = '';
	}
	$items_pp = !empty( $items_pp ) ? (int)$items_pp : esc_html( get_option( 'posts_per_page' ) );
	$paged = get_query_var( 'paged' );
	$home_paged = get_query_var('page');
	if(isset($home_paged) && !empty($home_paged)){
		$paged = empty( $home_paged ) ? 1 : get_query_var('page');
	}
	else{
		$paged = empty( $paged ) ? 1 : $paged;
	}
	$titles = !empty($titles) ? explode( ',', $titles ) : null;
	if ( $tax == 'title' && !empty( $titles ) ) {
		$items_pp = count( $titles );
	}
	$blog_class .= $layout == 'checkerboard' ? 'content_'.esc_attr($content_align).' ' : '';
	$blog_class .= $huge_spacings == '1' ? 'huge_spacings ' : '';
	$fill_atts = cws_blog_fill_atts($atts);
	extract( $fill_atts );

	$el_class = esc_attr( $el_class );

	$terms = explode( ",", $terms );	
	$terms_temp = array();
	foreach ( $terms as $term ) {
		if ( !empty( $term ) ){
			array_push( $terms_temp, $term );
		}
	}
	$terms = $terms_temp;
	$all_terms = array();
	$all_terms_temp = !empty( $tax ) ? get_terms( $tax ) : array();
	$all_terms_temp = !is_wp_error( $all_terms_temp ) ? $all_terms_temp : array();
	foreach ( $all_terms_temp as $term ){
		array_push( $all_terms, $term->slug );
	}
	$terms = !empty( $terms ) ? $terms : array();
	$not_in = (1 == $paged) ? array() : get_option( 'sticky_posts' );
	$query_args = array('post_type'			=> array( $post_type ),
						'post_status'		=> 'publish',
						'post__not_in'		=> $not_in
						);
	if ( in_array( $display_style, array( 'grid' ) ) ){
		$query_args['posts_per_page']		= $items_pp;
		$query_args['paged']		= $paged;
	}
	else{
		$query_args['nopaging']				= true;
		$query_args['posts_per_page']		= -1;
	}
	if ( !empty( $terms ) ){
		$query_args['tax_query'] = array(
			array(
				'taxonomy'		=> $tax,
				'field'			=> 'slug',
				'terms'			=> $terms
			)
		);
	}
	if (!empty($titles)) {
		$query_args['post__in'] = $titles;
	}
	$query_args['orderby'] 	= $orderby;
	$query_args['order']	= $order;
	$query_args = array_merge( $query_args, $addl_query_args );
	$q = new WP_Query( $query_args );
	$found_posts = $q->found_posts;
	$requested_posts = $found_posts > $total_items_count ? $total_items_count : $found_posts;
	$max_paged = $found_posts > $total_items_count ? ceil( $total_items_count / $items_pp ) : ceil( $found_posts / $items_pp );
	$cols = in_array( $layout, array( 'medium', 'small', 'checkerboard', 'fw_img' ) ) ? 1 : (int)$layout;
	$is_carousel = $requested_posts > $cols && $display_style == 'carousel';
	wp_enqueue_script( 'owl_carousel' );
	wp_enqueue_script( 'isotope' );
	wp_enqueue_script( 'imagesloaded' );
	wp_enqueue_script( 'fancybox' );
	$use_pagination = in_array( $display_style, array( 'grid' ) ) && $max_paged > 1;
	$use_carousel = in_array( $display_style, array( 'carousel') );
	$data_attr = '';
	if ( $is_carousel ){
		$data_attr .= isset($auto_play_carousel) && !empty($auto_play_carousel) ? ' auto_play_owl' : "";
		$data_attr .= isset($navigation_carousel) && !empty($navigation_carousel) ? ' navigation_owl arrows_default arrows_on_hover' : "";
		$data_attr .= isset($pagination_carousel) && !empty($pagination_carousel) ? ' pagination_owl' : "";
	}
	
	if ( !empty( $styles ) ){
		Cws_shortcode_css()->enqueue_cws_css($styles);
	}

	$animation = '';
	if ( '' !== $css_animation && 'none' !== $css_animation ) {
		wp_enqueue_script( 'waypoints' );
		$animation = ' wpb_animate_when_almost_visible wpb_' . $css_animation . ' ' . $css_animation;
	}

	ob_start ();
	echo "<section id='$section_id' class='".(!empty($blog_class) ? $blog_class : "")."news $animation blog_post posts_grid {$post_type}_posts_grid posts_grid_{$layout} blog_aligning_{$blog_aligning} button_aligning_{$button_aligning} posts_grid_{$display_style}".(!empty($data_attr) ? $data_attr : "").( !empty( $el_class ) ? " $el_class" : "" ) . "'>";

		if ( $is_carousel && !empty($navigation_carousel) ){
			echo "<div class='carousel_nav_panel'>
				<span class='prev'></span>
				<span class='next'></span>
			</div>";
		}
		echo "<div class='cws_vc_shortcode_wrapper'>";
			echo "<div class='" . ( $is_carousel ? "cws_vc_shortcode_carousel arrows_default arrows_on_hover" : "cws_vc_shortcode_grid grid" . ( is_numeric( $layout ) ? " isotope" : "" ) ) . ( !empty($layout ) ? " layout-{$layout}" : " layout-def" ) . "'" . ( $is_carousel ? " data-cols='" . ( !is_numeric( $layout ) ? "1" : $layout ) . "'" : "" ) . ">";
				cws_blog_posts($q);
				unset( $GLOBALS['cws_vc_shortcode_posts_grid_atts'] );
				unset( $GLOBALS['display_post'] );
			echo "</div>";
			if ( $use_pagination && $cws_theme_funcs){
				cws_loader_html();
			}
		echo "</div>";

		if ($cws_theme_funcs){

			if ( !is_single() && $use_pagination){
				if ( $pagination_grid == 'load_more' ){
					echo cws_load_more ();
				}
				elseif($pagination_grid == 'standard_with_ajax'){
					echo cws_pagination($paged, $max_paged, true);
				}
				else{
					echo cws_pagination($paged, $max_paged, false);
				}

				$ajax_data['section_id']						= $section_id;
				$ajax_data['post_type']							= 'post';
				$ajax_data['post_hide_meta']					= $post_hide_meta;
				$ajax_data['layout']							= $layout;
				$ajax_data['sb_layout']							= $sb_layout;
				$ajax_data['total_items_count']					= $total_items_count;
				$ajax_data['items_pp']							= $items_pp;
				$ajax_data['page']								= $paged;
				$ajax_data['max_paged']							= $max_paged;
				$ajax_data['tax']								= $tax;
				$ajax_data['terms']								= $terms;
				$ajax_data['huge_layout']						= $huge_layout;
				$ajax_data['current_filter_val']				= '_all_';
				$ajax_data['addl_query_args']					= $addl_query_args;
				$ajax_data['full_width']						= $full_width;
				$ajax_data['pagination_grid']					= $pagination_grid;
				$ajax_data['related_items']						= $related_items;
				$ajax_data['more_btn_text']						= $more_btn_text;
				$ajax_data['link_show']							= $link_show;
				$ajax_data['crop_featured']						= $crop_featured;
				$ajax_data['chars_count']						= $chars_count;
				$ajax_data_str = json_encode( $ajax_data );
				echo "<form id='{$section_id}_data' class='ajax_data_form cws_blog_ajax_data_form posts_grid_ajax_data_form'>";
					echo "<input type='hidden' id='{$section_id}_ajax_data' class='ajax_data cws_blog_ajax_data posts_grid_ajax_data' name='{$section_id}_ajax_data' value='$ajax_data_str' />";
				echo "</form>";
			}

		} else {
			echo cws_pagination($paged, $max_paged, false);
		}
		
	echo "</section>";
	$out = ob_get_clean();

	return $out;
}

function cws_blog_post_format (){
	global $post;
	if ( isset( $post ) ){
		$pf = get_post_format ();

		$out = "$pf";
		return $out;
	}
	else{
		return "";
	}
}

function cws_blog_thumbnail_dims ( $eq_thumb_height = false, $real_dims = array(), $post_format = null ) {
	$def_grid_atts = array(
		'layout'		=> '1',
		'sb_layout'		=> '',
		'crop_featured'	=> false,
		'full_width'	=> ''
	);
	$def_single_atts = array(
		'sb_layout'		=> '',
	);
	$grid_atts = isset( $GLOBALS['cws_vc_shortcode_posts_grid_atts'] ) ? $GLOBALS['cws_vc_shortcode_posts_grid_atts'] : $def_grid_atts;
	$single_atts = isset( $GLOBALS['cws_vc_shortcode_single_post_atts'] ) ? $GLOBALS['cws_vc_shortcode_single_post_atts'] : $def_single_atts;
	$display_post_style = isset( $GLOBALS['display_post'] ) ? $GLOBALS['display_post'] : "";
	global $cws_theme_funcs;
	$single = is_single();
	extract( $grid_atts );
	if ( $single ){
		extract( $single_atts );
	}
	$sb_layout = !empty($sb_layout) ? str_replace("_sidebar","", $sb_layout) : $sb_layout;
	if ($cws_theme_funcs) {
		$huge_layout = $cws_theme_funcs->cws_get_meta_option('boxed')['huge_layout'];
	} else { 
		$huge_layout = '';
	}
	$crop_featured = (bool)$crop_featured ? true : false;
	$dims = array( 'width' => 0, 'height' => 0, 'crop' => $crop_featured);
	if ( $single && empty($related_items)){
		if ( empty( $sb_layout ) ){
			if ($huge_layout == 1) {
				$dims['width'] = 1400;
			} else if ( ( empty( $real_dims ) || ( isset( $real_dims['width'] ) && $real_dims['width'] > 1170 ) ) || $eq_thumb_height ){
				$dims['width'] = 1170;
				if ( $eq_thumb_height ) $dims['height'] = 659;
			}
		}
		else if ( $sb_layout === "single" ){
			if ( ( empty( $real_dims ) || ( isset( $real_dims['width'] ) && $real_dims['width'] > 870 ) ) || $eq_thumb_height ){
				$dims['width'] = 870;				
				if ( $eq_thumb_height ) $dims['height'] = 490;
			}
		}
		else if ( $sb_layout === "double" ){
			if ( ( empty( $real_dims ) || ( isset( $real_dims['width'] ) && $real_dims['width'] > 570 ) ) || $eq_thumb_height ){
				$dims['width'] = 570;
				if ( $eq_thumb_height ) $dims['height'] = 321;
			}
		}
	} else if ($full_width){
		switch ($layout){
			case "1":	
				$dims['width'] = 1920;
				if ( !isset( $real_dims['height'] ) ){
					$dims['height'] = 1080;
				}		
				break;
			case '2':
				$dims['width'] = 1000;
				if ( !isset( $real_dims['height'] ) ){
					$dims['height'] = 550;
				}		
				break;
			case '3':
				$dims['width'] = 750;
				if ( !isset( $real_dims['height'] ) ){
					$dims['height'] = 450;
				}		
				break;
			case '4':
				$dims['width'] = 500;
				if ( !isset( $real_dims['height'] ) ){
					$dims['height'] = 350;
				}
				break;
		}
	} else if ($huge_layout == 1){
		switch ($layout){
			case "1":
				if ( empty( $sb_layout ) ){
					$dims['width'] = 1400;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 800;
					}	
				}
				else if ( $sb_layout === "single" ){
					$dims['width'] = 1040;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 636;
					}	
				}
				else if ( $sb_layout === "double" ){
					$dims['width'] = 680;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 540;
					}	
				}
				break;			
			case "large":
				if ( empty( $sb_layout ) ){
					$dims['width'] = 1400;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 720;
					}	
				}
				else if ( $sb_layout === "single" ){
					$dims['width'] = 1040;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 636;
					}	
				}
				else if ( $sb_layout === "double" ){
					$dims['width'] = 680;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 540;
					}	
				}
				break;
			case "fw_img":
				$dims['width'] = 570;
				if ( !isset( $real_dims['height'] ) ){
					$dims['height'] = 290;
				}	
				break;
			case "checkerboard":
				$dims['width'] = 700;
				if ( !isset( $real_dims['height'] ) ){
					$dims['height'] = 600;
				}	
				break;	
			case "medium":
				$dims['width'] = 685;
				if ( !isset( $real_dims['height'] ) ){
					$dims['height'] = 385;
				}	
				break;
			case "small":		
				$dims['width'] = 420;
				$dims['height'] = 420;
				break;
			case '2':
				if ( empty( $sb_layout ) ){	
					$dims['width'] = 685;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 685;
					}
				}
				else if ( $sb_layout === "single" ){
					$dims['width'] = 505;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 505;
					}	
				}
				else if ( $sb_layout === "double" ){
					$dims['width'] = 270;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 270;
					}	
				}
				break;
			case '3': 
				if ( empty( $sb_layout ) ){
					$dims['width'] = 450;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 450;
					}
				}
				else if ( $sb_layout === "single" ){
					$dims['width'] = 326;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 200;
					}
					else{
						$dims['height'] = 326;
					}	
				}
				else if ( $sb_layout === "double" ){
					$dims['width'] = 270;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 152;
					}	
					else{
						$dims['height'] = 270;
					}
				}
				break;
			case '4':
				$dims['width'] = 500;
				$dims['height'] = 500;
				break;
		}
	} else{
		switch ($layout){
			case "1":
				if ( empty( $sb_layout ) ){
					$dims['width'] = 1170;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 659;
					}	
				}
				else if ( $sb_layout === "single" ){
					$dims['width'] = 870;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 490;
					}	
				}
				else if ( $sb_layout === "double" ){
					$dims['width'] = 570;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 321;
					}	
				}
				break;			
			case "large":
				if ( empty( $sb_layout ) ){
					$dims['width'] = 1170;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 659;
					}	
				}
				else if ( $sb_layout === "single" ){
					$dims['width'] = 870;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 490;
					}	
				}
				else if ( $sb_layout === "double" ){
					$dims['width'] = 570;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 321;
					}	
				}
				break;
			case "fw_img":
				$dims['width'] = 570;
				if ( !isset( $real_dims['height'] ) ){
					$dims['height'] = 290;
				}	
				break;
			case "checkerboard":
				$dims['width'] = 585;
				if ( !isset( $real_dims['height'] ) ){
					$dims['height'] = 290;
				}	
				break;	
			case "medium":
				$dims['width'] = 570;
				if ( !isset( $real_dims['height'] ) ){
					$dims['height'] = 321;
				}	
				break;
			case "small":		
				$dims['width'] = 420;
				$dims['height'] = 420;
				break;
			case '2':
				if ( empty( $sb_layout ) ){	
					$dims['width'] = 570;
					$dims['height'] = 351;
				}
				else if ( $sb_layout === "single" ){
					$dims['width'] = 570;
					$dims['height'] = 351;	
				}
				else if ( $sb_layout === "double" ){
					$dims['width'] = 270;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 152;
					}	
				}
				break;
			case '3': 

				if ( empty( $sb_layout ) ){
					$dims['width'] = 370;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 370;
					}	
				}
				else if ( $sb_layout === "single" ){
					$dims['width'] = 270;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 152;
					}	
				}
				else if ( $sb_layout === "double" ){
					$dims['width'] = 270;
					if ( !isset( $real_dims['height'] ) ){
						$dims['height'] = 152;
					}	
				}
			
				break;
			case '4':
				$dims['width'] = 270;
				$dims['height'] = 270;
				break;
		}
	}
	return $dims;
}

function cws_blog_posts ( $q = null ){
	if ( !isset( $q ) ) return;
	$def_grid_atts = array(
					'layout'				=> '1',
					'post_hide_meta'		=> array(),
					'total_items_count'		=> PHP_INT_MAX
				);
	$grid_atts = isset( $GLOBALS['cws_vc_shortcode_posts_grid_atts'] ) ? $GLOBALS['cws_vc_shortcode_posts_grid_atts'] : $def_grid_atts;
	extract( $grid_atts );

	$paged = $q->query_vars['paged'];
	if ( $paged == 0 && $total_items_count < $q->post_count ){
		$post_count = $total_items_count;
	}
	else{
		$ppp = $q->query_vars['posts_per_page'];
		$posts_left = $total_items_count - ( $paged - 1 ) * $ppp;
		$post_count = $posts_left < $ppp ? $posts_left : $q->post_count;
	}
	if ( $q->have_posts() ):
		ob_start();
		while( $q->have_posts() && $q->current_post < $post_count - 1 ):
			$q->the_post();
			cws_blog_article();
		endwhile;
		wp_reset_postdata();
		ob_end_flush();
	endif;				
}

function cws_blog_styles ($uniq_pid){

	$def_grid_atts = array('related_items' => false);
	$grid_atts = isset( $GLOBALS['cws_vc_shortcode_posts_grid_atts'] ) ? $GLOBALS['cws_vc_shortcode_posts_grid_atts'] : $def_grid_atts;
	$related_items = $grid_atts['related_items'];
	$post_id = get_the_id();
	$post_meta = get_post_meta( $post_id, 'cws_mb_post' );
	$post_meta = isset( $post_meta[0] ) ? $post_meta[0] : array();
	$comments_n = get_comments_number();
	$image_from_post = isset($post_meta['post_header_box_image']) ? $post_meta['post_header_box_image'] : '';
	$post_title_color = isset($post_meta['post_title_color']) ? $post_meta['post_title_color'] : '';
	$post_font_meta_color = isset($post_meta['post_font_meta_color']) ? $post_meta['post_font_meta_color'] : '';
	$post_font_color = isset($post_meta['post_font_color']) ? $post_meta['post_font_color'] : '';
	$post_font_sec_color = isset($post_meta['post_font_sec_color']) ? $post_meta['post_font_sec_color'] : '';
	$post_custom_color = isset($post_meta['post_custom_color']) ? $post_meta['post_custom_color'] : '';
	$apply_color = isset($post_meta['apply_color']) ? $post_meta['apply_color'] : '';
	/* styles */

	$custom_style = '';
	if($apply_color == 'list_color'){
		$custom_style = '.page';
	} else if($apply_color == 'single_color'){
		$custom_style = '.single-post';
	} else if($apply_color == 'both_color'){
		$custom_style = '';
	}

	ob_start();
	if ( $post_custom_color ) {

		echo "
			".$custom_style." #{$uniq_pid} .post_title a{
				color: ".esc_attr($post_title_color).";
			}

			".$custom_style." #{$uniq_pid} .post_post_info.posts_grid_post_info > hr{
				background: ".cws_Hex2RGBA($post_title_color,.2).";
			}

			".$custom_style." .news #{$uniq_pid} .post_top_wrapper a,
			".$custom_style." .news #{$uniq_pid} .single_post_meta a,
			".$custom_style." .news #{$uniq_pid} .post_top_wrapper{
				".(!empty($post_font_meta_color) ? "color: ".esc_attr($post_font_meta_color).";" : "color: ".esc_attr($post_title_color).";")."
			}
			
			".$custom_style." .news #{$uniq_pid} .single_post_meta a:hover,
			".$custom_style." .news #{$uniq_pid} .post_top_wrapper a:hover{
				".(!empty($post_font_meta_hover_color) ? "color: ".esc_attr($post_font_meta_hover_color).";" : "color: ".esc_attr($post_title_color).";")."
			}

			".$custom_style." #{$uniq_pid} .btn-read-more a.more-link:hover{
				background: transparent;
			}

			".$custom_style." #{$uniq_pid} .btn-read-more a:before{
				border-color: ".esc_attr($post_title_color).";
			}

			".$custom_style." #{$uniq_pid} .post_content{
				color: ".esc_attr($post_font_color).";
			}

			".$custom_style." #{$uniq_pid} .date-content{
				background-color: ".esc_attr($post_font_sec_color).";
			}
		";
	}
	/* \styles */
	$styles = ob_get_clean();

	if ( !empty( $styles ) && !$related_items ){
		Cws_shortcode_css()->enqueue_cws_css($styles);
	}	
}

function cws_blog_article(){
	$def_grid_atts = array(
		'layout'				=> '1',
		'post_hide_meta'		=> array(),
	);
	$grid_atts = isset( $GLOBALS['cws_vc_shortcode_posts_grid_atts'] ) ? $GLOBALS['cws_vc_shortcode_posts_grid_atts'] : $def_grid_atts;
	extract( $grid_atts );
	$pid = get_the_id();
	$post_hide_meta = isset($post_hide_meta) && !empty($post_hide_meta) ? $post_hide_meta : array();
	$post_format = get_post_format();
	$uniq_pid = uniqid( "post_post_" );
	cws_blog_styles($uniq_pid);
	echo "<article id='$uniq_pid'";
	post_class( array( 'item', 'post', (in_array( 'likes', $post_hide_meta ) ? 'no_likes' : '' ), 'post_post', 'posts_grid_post', (is_sticky(get_the_id()) ? 'sticky-post': '') ) );
	echo ">";
		if (!empty($image_from_post) && $layout == 'fw_img') {
			$back_img_src = $image_from_post['src'];
			echo "<div class='back_img' style='background-image: url(".esc_url($back_img_src).");'></div>";
		}
		echo "<div class='post_wrapper post_post_wrapper posts_grid_post_wrapper clearfix'>";

			cws_blog_media($uniq_pid);
			echo "<div class='post_post_info posts_grid_post_info'>";
					echo "<div class='post_top_wrapper'>";
						echo cws_blog_meta_author();
						if( empty(get_the_post_thumbnail(get_the_ID())) || ($post_format == 'quote' || $post_format == 'link' ) ){
							cws_blog_date();
						}
						cws_blog_taxanomy();
						echo cws_blog_meta_comments();
						echo cws_blog_meta_likes();
					echo "</div>";
				if($post_format != 'link' && $post_format != 'quote'){
					echo cws_blog_title();
				}
				cws_blog_content();
				cws_blog_btn_more();
			echo "</div>";

		echo "</div>";	
	echo "</article>";
}

function cws_blog_date(){
	$def_grid_atts = array(
		'post_hide_meta' => array(),
	);
	$grid_atts = isset( $GLOBALS['cws_vc_shortcode_posts_grid_atts'] ) ? $GLOBALS['cws_vc_shortcode_posts_grid_atts'] : $def_grid_atts;
	extract( $grid_atts );
	$post_hide_meta = isset($post_hide_meta) && !empty($post_hide_meta) ? $post_hide_meta : array();
	$pid = get_the_id();
	$is_single = is_single( $pid );

	if ( !in_array( 'date', $post_hide_meta ) ){
		$date = get_the_time( get_option("date_format") );
		$day = get_the_time('d');
		$year = get_the_time('Y');
		$month = get_the_time('M');
		$date_link = get_month_link($year, $month);
		if ( !empty( $date ) ){
			echo "<div class='inline_date'>";
				echo "<a href=".esc_attr($date_link).">";
					esc_html($date);
						echo "<span class='day'>".esc_html($day)."</span>";
						echo "<span class='month'>".esc_html($month)."</span>";
				echo "</a>";
			echo "</div>";		
		}
	}
}

function cws_blog_title(){
	$def_grid_atts = array(
		'post_hide_meta' => array(),
	);
	$grid_atts = isset( $GLOBALS['cws_vc_shortcode_posts_grid_atts'] ) ? $GLOBALS['cws_vc_shortcode_posts_grid_atts'] : $def_grid_atts;
	extract( $grid_atts );
	$post_hide_meta = isset($post_hide_meta) && !empty($post_hide_meta) ? $post_hide_meta : array();

	$pid = get_the_id();
	$is_single = is_single( $pid );
	$title = get_the_title();
	$permalink = get_the_permalink();

	if ($is_single){
		$title_part = $title;
	} else {
		$title_part = "<h3 class='post_title post_post_title posts_grid_post_title'><a href='".esc_url($permalink)."'>". $title ."</a></h3>";
	}

	if ( !in_array( 'title', $post_hide_meta )){
		!empty( $title_part ) ? $title_part : "";
	} else {
		$title_part = '';
	}

	return $title_part;
}

function cws_blog_media (){
	$pid = get_the_id();
	$is_single = is_single( $pid );
	$def_grid_atts = array(
		'layout'				=> '1',
		'post_hide_meta'		=> array(),
		'sb_layout'				=> '',
		'full_width'			=> '',
		'link_show'				=> '',
	);
	$grid_atts = isset( $GLOBALS['cws_vc_shortcode_posts_grid_atts'] ) ? $GLOBALS['cws_vc_shortcode_posts_grid_atts'] : $def_grid_atts;	
	extract( $grid_atts );
	$post_hide_meta = isset($post_hide_meta) && !empty($post_hide_meta) ? $post_hide_meta : array();
	global $cws_theme_funcs;
	$post_url = get_the_permalink();
	$post_format = get_post_format( );
	$eq_thumb_height = in_array( $post_format, array( 'gallery' ) );
	$media_meta = get_post_meta( get_the_ID(), 'cws_mb_post' );
	$media_meta = isset( $media_meta[0] ) ? $media_meta[0] : array();


	$thumbnail_props = has_post_thumbnail( ) ? wp_get_attachment_image_src(get_post_thumbnail_id( ),'full') : array();
	$thumbnail = !empty( $thumbnail_props ) ? $thumbnail_props[0] : '';
	$real_thumbnail_dims = array();
	if ( !empty( $thumbnail_props ) && isset( $thumbnail_props[1] ) ) $real_thumbnail_dims['width'] = $thumbnail_props[1];
	if ( !empty( $thumbnail_props ) && isset( $thumbnail_props[2] ) ) $real_thumbnail_dims['height'] = $thumbnail_props[2];
	$thumbnail_dims = cws_blog_thumbnail_dims( $eq_thumb_height, $real_thumbnail_dims, $post_format );

	$full_width_featured = isset($media_meta['full_width_featured']) && $media_meta['full_width_featured'] == '1';

	if ($is_single && $full_width_featured){
		$thumbnail_dims = array( 'width' => 0, 'height' => 0 );
	}

	$full_width = isset($GLOBALS['cws_row_atts']) && !empty($GLOBALS['cws_row_atts']) ? $GLOBALS['cws_row_atts'] : "";

	if (is_single() && isset($related_items) && $related_items && $cws_theme_funcs->cws_get_option( "crop_related_items" ) == '1'){
		$thumbnail_dims['height'] = $thumbnail_dims['width'];
		$thumbnail_dims['crop'] = array(
			$cws_theme_funcs->cws_get_option( "crop_x" ),
			$cws_theme_funcs->cws_get_option( "crop_y" )
		);
	}

	$buf1 = "";
	$thumb_media = false;
	$allow_cut_media = false;
	$some_media = false;
	ob_start();
	switch ($post_format) {
		case 'link':
			$link = isset( $media_meta['link'] ) ? esc_url( $media_meta['link'] ) : "";
			$link_title = isset( $media_meta['link_title'] ) ? esc_html( $media_meta['link_title'] ) : "";
			
			if ( !empty( $link ) ) {
				echo "<h3 class='post_title'><a class='post_media_link post_post_media_link posts_grid_post_media_link' href='$link'>$link_title</a></h3>";
			} else {
				echo cws_blog_title();
			}
			break;
		case 'video':
			$video = isset($media_meta[$post_format]) ? $media_meta[$post_format] : "";
			if ( !empty( $video ) ) {
				echo "<div class='video'>" . apply_filters('the_content',"[embed width='" . $thumbnail_dims['width'] . "']" . $video . "[/embed]") . "</div>";
			}
			break;
		case 'audio':
			$audio = isset($media_meta[$post_format]) ? esc_attr( $media_meta[$post_format]) : "";
			$is_soundcloud = is_int( strpos( (string) $audio, 'https://soundcloud' ) );
			if ( !empty( $thumbnail ) && !$is_soundcloud ){
				$thumb_obj = cws_thumb( get_post_thumbnail_id( ), $thumbnail_dims, false );
				$thumb_url = isset( $thumb_obj[0] ) ? esc_url( $thumb_obj[0] ) : "";
				$thumbnail = esc_url($thumbnail);
				$retina_thumb = isset( $thumb_obj[3] ) ? $thumb_obj[3] : false;

				$get_alt = get_post_meta(get_post_thumbnail_id( ), '_wp_attachment_image_alt', true); 
				$img_alt = " alt='" . (!empty($get_alt) ? $get_alt : get_the_title(get_post_thumbnail_id( ))) . "'";


				echo "<div class='pic'>";
					if ( $retina_thumb ) {
						echo "<img src='".esc_url($thumb_url)."' data-at2x='".esc_url($retina_thumb)."' ".$img_alt ." />";
					}
					else{
						echo "<img src='".esc_url($thumb_url)."' data-no-retina ".$img_alt ." />";
					}
				echo "</div>";
				if ( empty( $audio ) ){
					echo "<a class='fancy post_media_link post_post_media_link ".($is_single ? 'post_single_post_media_link' : 'posts_grid_post_media_link')."' href='".esc_url($thumbnail)."'></a>";					
					$thumb_media = true;				
				}					
			}
			if ( !empty( $audio ) ){
				echo "<div class='audio" . ( $is_soundcloud ? " soundcloud" : "" ) . "'>";
					echo apply_filters( 'the_content', $audio );
				echo "</div>";
			}
			break;
		case 'quote':
			$quote = isset( $media_meta['quote_text'] ) ? $media_meta['quote_text'] : '';
			$author_name = isset( $media_meta['quote_author'] ) ? $media_meta['quote_author'] : '';				
			if ( !empty( $quote ) ) {
				echo "<div class='quote_wrap'>";
					echo "<h3 class='post_title quote_text'><a href='".get_permalink()."'>$quote</a></h3>";
					echo !empty($author_name) ? "<h6 class='author_name'>".esc_html($author_name)."</h6>" : '';
				echo "</div>";
			} else {
				echo cws_blog_title();
			}
			break;
		case 'gallery':
			$gallery_type = isset( $media_meta['gallery_type'] ) ? $media_meta['gallery_type'] : "";
			$custom_grid = isset( $media_meta['custom_grid'] ) ? $media_meta['custom_grid'] : "";
			$gallery = isset( $media_meta[$post_format] ) ? $media_meta[$post_format] : "";
			if ($gallery_type == 'new_grid' && !empty($gallery)) {
				$size_count = 0;
				wp_enqueue_script( 'imagesloaded' );
				wp_enqueue_script( 'isotope' );

				$match = preg_match_all("/\d+/",$gallery,$images);
				if ($match){
					$images = $images[0];
					$image_srcs = array();

					foreach ( $images as $image ) {
						$image_temp = array();
						$image_src = wp_get_attachment_image_src($image,'full');
						if ( $image_src ){
							$image_temp = array('url' => $image_src[0], 'id' => $image);
							array_push( $image_srcs, $image_temp );
						}
					}
					if ($custom_grid == 'var_1') {
						$col_arr = array('2', '6', '2', '2', '2', '2' );
						$line_arr = array('3', '6', '2', '2', '3', '2' );
					} else if ($custom_grid == 'var_2') {
						$col_arr = array('2', '2', '6', '2', '2', '2' );
						$line_arr = array('2', '3', '6', '2', '3', '2' );
					} else if ($custom_grid == 'var_3') { 
						$col_arr = array('5', '5', '5' );
						$line_arr = array('2', '5', '3' );
					} else if ($custom_grid == 'var_4') { 
						$col_arr = array('2', '2', '6', '6', '2', '2' );
						$line_arr = array('3', '3', '3', '3', '3', '3' );
					} else if ($custom_grid == 'var_5') { 
						$col_arr = array('2', '4', '4', '4', '6' );
						$line_arr = array('2', '2', '2', '4', '4' );
					} else if ($custom_grid == 'var_6') { 
						$col_arr = array('2', '8', '4', '4', '2' );
						$line_arr = array('4', '4', '2', '2', '2' );
					} else if ($custom_grid == 'var_7') { 
						$col_arr = array('2', '6', '2', '2', '2', '2' );
						$line_arr = array('3', '5', '2', '1', '2', '2' );
					}

					echo "<div class='blog_gallery_grid isotope'>";
					foreach ( $image_srcs as $image_src ) {
						if ($size_count < count($col_arr)) {
							$size_count ++;
							$col_width_arr = array();
							$col_style_width_arr = array();
							$line_width_arr = array();

							$width_origin = $thumbnail_dims['width'];
							$width_new = ($width_origin + 10) / 10;

							foreach ($col_arr as $value) {
								$col = $value * $width_new;
								array_push($col_width_arr, $col);
								array_push($col_style_width_arr, $value);
							}
							foreach ($line_arr as $value) {
								$line = $value * $width_new;
								array_push($line_width_arr, $line);
							}

							$col = $col_width_arr[$size_count - 1];
							$col_style_width = $col_style_width_arr[$size_count - 1];
							$line = $line_width_arr[$size_count - 1];
							$col = $col - 10;
							$line = $line - 10;

							$thumbnail_dims_new = array('width' => $col, 'height' => $line, 'crop' => true );

							$data_line = $line_arr[$size_count - 1];
							$data_col = $col_arr[$size_count - 1];
							$img_obj = cws_thumb( $image_src['id'], $thumbnail_dims_new , false );
							$img_url = isset( $img_obj[0] ) ? esc_url( $img_obj[0] ) : "";
							$thumb_obj = cws_thumb( get_post_thumbnail_id( ), $thumbnail_dims, false );
							$retina_thumb = isset( $thumb_obj[3] ) ? $thumb_obj[3] : false;

							$get_alt = get_post_meta($image_src['id'], '_wp_attachment_image_alt', true); 
							$img_alt = " alt='" . (!empty($get_alt) ? $get_alt : get_the_title($image_src['id'])) . "'";

							echo "<div class='pic' data-col='$data_col' data-line='$data_line' style='width:".$col_style_width."0%'>";
								if ( $retina_thumb ) {
									echo "<img src='".esc_url($img_url)."' data-at2x='".esc_url($retina_thumb)."' ".$img_alt." />";
								}
								else{
									echo "<img src='".esc_url($img_url)."' data-no-retina ".$img_alt." />";
								}
								echo "<a href='".esc_url($image_src['url'])."' class='fancy blog_gallery_fancy'><div class='hover'></div></a>";
							echo "</div>";
						} 
					}
					echo "</div>";
				}
			} else if ( !empty( $gallery ) ) {
				$match = preg_match_all("/\d+/",$gallery,$images);
				if ($match){
					$images = $images[0];
					$image_srcs = array();

					foreach ( $images as $image ) {
						$image_temp = array();
						$image_src = wp_get_attachment_image_src($image,'full');
						if ( $image_src ){
							$image_temp = array('url' => $image_src[0], 'id' => $image);
							array_push( $image_srcs, $image_temp );
						}
					}
					$carousel = count($image_srcs) > 1 ? true : false;
					$gallery_id = uniqid( 'cws-gallery-' );
					if($carousel){
						echo "
						<div class='gallery_post_carousel_wrapper'>
							<div class='carousel_nav_panel'>
								<a class='gallery_post_carousel_nav carousel_nav prev'></a>
								<a class='gallery_post_carousel_nav carousel_nav next'></a>
							</div>
							<div class='gallery_post_carousel'>";
					}
					if ($carousel) wp_enqueue_script( 'owl_carousel' );
					foreach ( $image_srcs as $image_src ) {
						$img_obj = cws_thumb( $image_src['id'], $thumbnail_dims , false );
						$img_url = isset( $img_obj[0] ) ? esc_url( $img_obj[0] ) : "";
						$retina_thumb = isset( $thumb_obj[3] ) ? $thumb_obj[3] : false;

						$get_alt = get_post_meta($image_src['id'], '_wp_attachment_image_alt', true); 
						$img_alt = " alt='" . (!empty($get_alt) ? $get_alt : get_the_title($image_src['id'])) . "'";

						echo "<div class='pic'>";
							if ( $retina_thumb ) {
								echo "<img src='".esc_url($img_url)."' data-at2x='".esc_url($retina_thumb)."' ".$img_alt." />";
							}
							else{
								echo "<img src='".esc_url($img_url)."' data-no-retina ".$img_alt." />";
							}
								echo "<a href='".esc_url($image_src['url'])."'" . ( $carousel ? " data-fancybox-group='$gallery_id'" : "" ) . " class='fancy post_media_link post_post_media_link ".($is_single ? 'post_single_post_media_link' : 'posts_grid_post_media_link') . ( $carousel ? " fancy_gallery" : "" ) . "'>";
								echo "</a>";
						echo "</div>";
					}
					if($carousel){
						echo "</div></div>";
					}
				}
			}
			break;
	}
	$buf1 = ob_get_contents();

	if ( empty( $buf1 ) && !empty( $thumbnail ) ) {
		$thumb_obj = cws_thumb( get_post_thumbnail_id( ), $thumbnail_dims, false );
		$thumb_url = isset( $thumb_obj[0] ) ? esc_url($thumb_obj[0]) : "";
		$retina_thumb = isset( $thumb_obj[3] ) ? $thumb_obj[3] : false;

		$get_alt = get_post_meta(get_post_thumbnail_id( ), '_wp_attachment_image_alt', true); 
		$img_alt = " alt='" . (!empty($get_alt) ? $get_alt : get_the_title(get_post_thumbnail_id( ))) . "'";

		echo "<div class='pic'>";
			if ( $retina_thumb ) {
				echo "<img src='".esc_url($thumb_url)."' data-at2x='".esc_url($retina_thumb)."' ". $img_alt ." />";
			}
			else{
				echo "<img src='".esc_url($thumb_url)."' data-no-retina ". $img_alt ." />";
			}

			if($link_show == 'single_link'){
				echo "<a class='link_area_post_media post_media_link post_post_media_link ".($is_single ? 'post_single_post_media_link' : 'posts_grid_post_media_link')."' href='".esc_url($post_url)."'></a>";
			}
		echo "</div>";
		$thumb_media = true;
		$allow_cut_media = true;
	}
	$media_content = ob_get_clean();
	$some_media = !empty( $media_content );
	$floated_media = in_array( $layout, array( "medium", "small", 'checkerboard', 'fw_img' ) ) || ( $layout === "2" && empty( $sb_layout ) );	
	$cut_media = ( in_array( $layout, array( "small" ) ) || ( $layout === "2" && empty( $sb_layout ) ) ) && $allow_cut_media;
	$media_classes = array( "post_media", "post_post_media", ($is_single ? 'post_single_post_media' : 'posts_grid_post_media') );
	$classes = '';
	$classes .= $cut_media ? " cut_post_post_media" : "";
	$media_classes_str = implode( " ", $media_classes );
	$full_width_img = (isset($media_meta['full_width_featured']) && $media_meta['full_width_featured'] == '1');

	if ( !empty( $media_content ) ){
		if ( $floated_media ){
			?>
				<div class="floated_media post_floated_media <?php if($is_single){echo "post_single_floated_media_wrapper";}else{echo "posts_grid_floated_media_wrapper";} ?>">
					<div class="floated_media_wrapper post_floated_media_wrapper <?php if($is_single){echo "post_single_floated_media_wrapper";}else{echo "posts_grid_floated_media_wrapper";} echo sprintf("%s", $classes); ?>">
					<?php
						echo "<div class='$media_classes_str'>";
							echo sprintf("%s", $media_content);
							if( $post_format != 'quote' && $post_format != 'link' && !$full_width_img){
								cws_blog_date();
							}
						echo "</div>";
					?>
					</div>
				</div>
			<?php
		}
		else{
			echo "<div class='$media_classes_str'>";
				echo sprintf("%s", $media_content);
				if( $post_format != 'quote' && $post_format != 'link' && !$full_width_img){
					cws_blog_date();
				}
			echo "</div>";			
		}
	}
	if ( $thumb_media ){
		wp_enqueue_script( 'fancybox' );
	}
}

function cws_blog_content(){
	if(class_exists('WPBMap')){
		WPBMap::addAllMappedShortcodes();
	}
	global $post, $more, $cws_theme_funcs;
	$id = get_the_ID();
	$permalink = get_the_permalink( $id );
	$more = 0;
	$is_rtl = is_rtl();
	$def_grid_atts = array(
		'post_hide_meta'		=> array(),
		'chars_count'			=> '',
	);
	$grid_atts = isset( $GLOBALS['cws_vc_shortcode_posts_grid_atts'] ) ? $GLOBALS['cws_vc_shortcode_posts_grid_atts'] : $def_grid_atts;	
	extract( $grid_atts );
	$chars_count = isset($chars_count) && !empty( $chars_count ) ? $chars_count : cws_vc_shortcode_post_posts_grid_get_chars_count();
	$content = $proc_content = $excerpt = $proc_excerpt = "";
	$post_hide_meta = isset($post_hide_meta) && !empty($post_hide_meta) ? $post_hide_meta : array();
	$author = get_the_author();
	$post_format = get_post_format();
	$content = $post->post_content; 
	$excerpt = $post->post_excerpt;

	if ( is_single() && empty($grid_atts['related_items'])) {
		if(strpos( (string) $content, '<!--more-->' )){
			$proc_content .= $content;
		} else {
			$proc_content .= get_the_content();
		}
	} else {

		if ( !empty( $excerpt ) ){
			$proc_content = get_the_excerpt();
		}
		else if ( strpos( (string) $content, '<!--more-->' ) ){
			$proc_content = get_the_content( "" );
		}
		else if ( !empty( $content ) && !empty( $chars_count ) ){
			$proc_content = get_the_content( "" );

			preg_match('/\[cws_sc_dropcap.*\](.*)\[\/cws_sc_dropcap\]/', $proc_content, $matches);
			
			if( isset($matches[1]) ){
				$letter = $matches[1];
				$without_shortcodes_content = trim( preg_replace( '/[\s]{2,}/u', ' ', strip_shortcodes( strip_tags( $proc_content ) ) ) );
				$proc_content = $letter.$without_shortcodes_content;
			}

			$proc_content = trim( preg_replace( '/[\s]{2,}/u', ' ', strip_shortcodes( strip_tags( $proc_content ) ) ) );

			$chars_count = (int)$chars_count;
			$proc_content = mb_substr( $proc_content, 0, $chars_count );
		}
		else {
			$proc_content = get_the_content( "[...]" );		
		}
	}
	if (!is_single()) {
		if ($post_format !== 'link' && $post_format !== 'quote') {
			if(!in_array( 'excerpt', $post_hide_meta )){
				echo "<div class='post_content post_post_content posts_grid_post_content clearfix'>";	
					if ($cws_theme_funcs){
						echo apply_filters( 'the_content', $proc_content );
					} else {
						the_content();				
					}
				echo "</div>";
			}
		}
	} else {
		if(!in_array( 'excerpt', $post_hide_meta )){
			echo "<div class='post_content post_post_content posts_grid_post_content clearfix'>";	
				if ($cws_theme_funcs){
					echo apply_filters( 'the_content', $proc_content );
				} else {
					the_content();				
				}
			echo "</div>";
		}
	}
	
}

function cws_blog_btn_more(){
	global $post;
	global $more;
	$more = 0;

	$def_grid_atts = array(
		'post_hide_meta'		=> array(),
		'chars_count'			=> '',
		'more_btn_text'			=> esc_html__('CONTINUE READING', 'vintwood'),
	);
	$grid_atts = isset( $GLOBALS['cws_vc_shortcode_posts_grid_atts'] ) ? $GLOBALS['cws_vc_shortcode_posts_grid_atts'] : $def_grid_atts;	
	extract( $grid_atts );
	$post_hide_meta = isset($post_hide_meta) && !empty($post_hide_meta) ? $post_hide_meta : array();
		
	$id = get_the_ID();
	$permalink = get_the_permalink( $id );		
	$chars_count = isset($chars_count) && !empty( $chars_count ) ? $chars_count : cws_vc_shortcode_post_posts_grid_get_chars_count();
	$content = $proc_content = $excerpt = $proc_excerpt = "";
	$content = $post->post_content;
	$excerpt = $post->post_excerpt;
	$read_more_exists = false;

	if ( !empty( $excerpt ) ){
		$read_more_exists = !empty( $content );
	}
	else if ( strpos( (string) $content, '<!--more-->' ) ){
		$read_more_exists = true;
	}
	else if ( !empty( $content ) && !empty( $chars_count ) ){
		$proc_content = get_the_content( "" );
		$proc_content = trim( preg_replace( '/[\s]{2,}/u', ' ', strip_shortcodes( strip_tags( $proc_content ) ) ) );
		$chars_count = (int)$chars_count;
		$proc_content = mb_substr( $proc_content, 0, $chars_count );
		$read_more_exists = strlen( $proc_content ) < strlen( $content );
	}

	if ( $read_more_exists && !in_array( 'read_more', $post_hide_meta ) ){
		if( !empty($more_btn_text) ){
			echo "<div class='button_wrapper'>";
				echo "<a href='".esc_url($permalink)."' class='cws_custom_button advanced small'>$more_btn_text</a>";
			echo "</div>";
		}
	}
}

function cws_vc_shortcode_post_posts_grid_get_chars_count() {
	
	$def_blogtype = "1";
	$def_grid_atts = array(
		'layout'	=> $def_blogtype
	);
	$grid_atts = isset( $GLOBALS['cws_vc_shortcode_posts_grid_atts'] ) ? $GLOBALS['cws_vc_shortcode_posts_grid_atts'] : $def_grid_atts;	
	extract( $grid_atts );
	$number 	= NULL;
	$p_id 		= get_queried_object_id();
	$sb 		= function_exists("cws_vc_shortcode_get_sidebars") ? cws_vc_shortcode_get_sidebars( $p_id ) : "";
	$sb_layout 	= isset( $sb['layout_class'] ) ? $sb['layout_class'] : '';
	switch ( $layout ) {
		case '1':
		case 'medium':
		case 'small':
			switch ( $sb_layout ) {
				case 'double':
					$number = NULL;
					break;
				case 'single':
					$number = NULL;
					break;
				default:
					$number = NULL;
			}
			break;
		case '2':
			switch ( $sb_layout ) {
				case 'double':
					$number = 55;
					break;
				case 'single':
					$number = 90;
					break;
				default:
					$number = 130;
			}
			break;
		case '3':
			switch ( $sb_layout ) {
				case 'double':
					$number = 60;
					break;
				case 'single':
					$number = 60;
					break;
				default:
					$number = 70;
			}
			break;
	}
	return $number;
}

function cws_blog_meta(){
	$meta = "";

	$author = cws_blog_meta_author();
	$post_format = cws_blog_meta_post_format();
	$comments = cws_blog_meta_comments();
	$date = cws_blog_meta_date();

	$meta = 
		$author .
		$post_format .
		$comments 
	;

	if ( !empty( $meta ) ){
		echo "<div class='post_meta post_info post_post_meta posts_grid_post_meta'>";
			echo sprintf("%s", $meta);
		echo "</div>";		
	}
}

function cws_blog_meta_author(){
	global $cws_theme_funcs;
	$def_grid_atts = array(
		'post_hide_meta' => array(),
	);
	$post_id = get_the_id();
	$post_meta = get_post_meta( $post_id, 'cws_mb_post' );
	$post_meta = isset( $post_meta[0] ) ? $post_meta[0] : array();
	$author_info = isset($post_meta['author_info']) ? $post_meta['author_info'] : '';
	$grid_atts = isset( $GLOBALS['cws_vc_shortcode_posts_grid_atts'] ) ? $GLOBALS['cws_vc_shortcode_posts_grid_atts'] : $def_grid_atts;
	extract( $grid_atts );
	$post_hide_meta = isset($post_hide_meta) && !empty($post_hide_meta) ? $post_hide_meta : array();
	$show_author = $cws_theme_funcs ? $cws_theme_funcs->cws_get_option( "blog_author" ) : true;

	if ($author_info){
		$show_author = true;
	}

	$author_part = '';
	if ( !in_array( 'author', $post_hide_meta ) && $show_author){
		$author = get_the_author();
		if ( !empty($author) ){
			ob_start();
				the_author_posts_link();
			$author_link = ob_get_clean();
			$author_part .= "<div class='info'>".esc_html__('by ', 'vintwood')."<span class='post_author'>".$author_link."</span></div>";
		}
	}
	return $author_part;
}

function cws_blog_meta_likes(){
	global $cws_theme_funcs;
	$def_grid_atts = array(
		'post_hide_meta' => array(),
	);
	$grid_atts = isset( $GLOBALS['cws_vc_shortcode_posts_grid_atts'] ) ? $GLOBALS['cws_vc_shortcode_posts_grid_atts'] : $def_grid_atts;
	extract( $grid_atts );
	$post_hide_meta = isset($post_hide_meta) && !empty($post_hide_meta) ? $post_hide_meta : array();
	$like_func = function_exists("cws_vc_shortcode_get_simple_likes_button") ? cws_vc_shortcode_get_simple_likes_button( get_the_ID() ) : "";
	$likes_part = '';
	if ( !in_array( 'likes', $post_hide_meta ) ){
		if ($cws_theme_funcs){
			$likes_part .= "<div class='like new_style'>".$like_func."</div>";
		}
	}
	return $likes_part;
}

function cws_blog_meta_post_format(){
	$post_format_part = '';
	return $post_format_part;
}

function cws_blog_meta_comments(){
	$def_grid_atts = array(
		'post_hide_meta' => array(),
	);
	$grid_atts = isset( $GLOBALS['cws_vc_shortcode_posts_grid_atts'] ) ? $GLOBALS['cws_vc_shortcode_posts_grid_atts'] : $def_grid_atts;
	extract( $grid_atts );
	$pid = get_the_id();
	$permalink = get_the_permalink( $pid );	
	$post_hide_meta = isset($post_hide_meta) && !empty($post_hide_meta) ? $post_hide_meta : array();
	$comments_part = '';
	if ( !in_array( 'comments', $post_hide_meta ) ){
		$comments_n = get_comments_number();
		if ( (int) $comments_n > 0 ) {
			$permalink .= "#comments";
			$comment_text = ($comments_n == '1') ? esc_html__( 'Сomment', 'vintwood') : esc_html__('Comments', 'vintwood');
			$comments_part .= "<a href='".esc_url($permalink)."' class='comments_link'>$comments_n</a>";
		}
	}
	return $comments_part;
}

function cws_blog_meta_date(){
	$def_grid_atts = array(
		'post_hide_meta' => array(),
	);
	$grid_atts = isset( $GLOBALS['cws_vc_shortcode_posts_grid_atts'] ) ? $GLOBALS['cws_vc_shortcode_posts_grid_atts'] : $def_grid_atts;
	extract( $grid_atts );
	$post_hide_meta = isset($post_hide_meta) && !empty($post_hide_meta) ? $post_hide_meta : array();

	$date_part = '';
	if ( !in_array( 'date', $post_hide_meta ) ){
		$date = get_the_time( get_option("date_format") );
		if ( !empty( $date ) ){
			$date_part .= "<div class='post_meta_date'>" . $date . "</div>";
		}
	}
	return $date_part;
}

function cws_blog_taxanomy(){
	$taxanomy = "";

	$category = cws_vc_shortcode_post_posts_grid_post_cats();									
	$tags = cws_vc_shortcode_post_posts_grid_post_tags();

	$taxanomy = 
		$category .
		$tags
	;

	if ( !empty( $taxanomy ) ){
		echo "<div class='post_meta post_categories'>";
			echo sprintf("%s", $taxanomy);
		echo "</div>";		
	}
}

function cws_vc_shortcode_post_posts_grid_post_cats (){
	$def_grid_atts = array(
		'post_hide_meta' => array(),
	);
	$grid_atts = isset( $GLOBALS['cws_vc_shortcode_posts_grid_atts'] ) ? $GLOBALS['cws_vc_shortcode_posts_grid_atts'] : $def_grid_atts;
	extract( $grid_atts );
	$post_hide_meta = isset($post_hide_meta) && !empty($post_hide_meta) ? $post_hide_meta : array();

	$category_part = '';
	if ( !in_array( 'cats', $post_hide_meta ) ){
		if ( has_category() ) {
			$category_part .= "<div class='post_category'>";	
				$cats = "";
				if ( has_category() ) {
					ob_start();
					the_category ( " " );
					$cats .= ob_get_clean();
				}
				if ( !empty( $cats ) ){
						$category_part .= $cats;
				}
			$category_part .= "</div>";
		}
	}
	return $category_part;
}

function cws_vc_shortcode_post_posts_grid_post_tags(){
	$def_grid_atts = array(
		'post_hide_meta' => array(),
	);
	$grid_atts = isset( $GLOBALS['cws_vc_shortcode_posts_grid_atts'] ) ? $GLOBALS['cws_vc_shortcode_posts_grid_atts'] : $def_grid_atts;
	extract( $grid_atts );
	$post_hide_meta = isset($post_hide_meta) && !empty($post_hide_meta) ? $post_hide_meta : array();

	$tags_part = '';
	if ( !in_array( 'tags', $post_hide_meta ) ){
		if ( has_tag() ) {
			$tags_part .= "<div class='post_tags'>";
				$tags = "";
				if ( has_tag() ) {
					ob_start();
					the_tags ( "", " ", "" );
					$tags .= ob_get_clean();
				}
				if ( !empty( $tags ) ){
					$tags_part .= $tags;
				}
			$tags_part .= "</div>";
		}
	}
	return $tags_part;
}

function cws_blog_social(){
	$def_grid_atts = array(
		'post_hide_meta' => array(),
	);
	$grid_atts = isset( $GLOBALS['cws_vc_shortcode_posts_grid_atts'] ) ? $GLOBALS['cws_vc_shortcode_posts_grid_atts'] : $def_grid_atts;
	extract( $grid_atts );
	$post_hide_meta = isset($post_hide_meta) && !empty($post_hide_meta) ? $post_hide_meta : array();

	$social_part = '';
	if ( !in_array( 'social', $post_hide_meta ) ){	
		if ( function_exists('wsl_activate') ){
			$social_part .= "<div class='social_share'>".do_shortcode('[wordpress_social_login]')."</div>";
		}
	}
	echo sprintf("%s", $social_part);
}

function cws_single_post_output ( $atts = array() ) {
	extract( $atts );
	$fill_atts = cws_blog_fill_atts($atts);
	$pid = get_the_id();
	$post_hide_meta = isset($post_hide_meta) && !empty($post_hide_meta) ? $post_hide_meta : array();
	$uniq_pid = uniqid( "post_post_" );
	cws_blog_styles($uniq_pid);
	$post_format = get_post_format();
	$media_meta = get_post_meta( $pid, 'cws_mb_post' );
	$media_meta = isset( $media_meta[0] ) ? $media_meta[0] : cws_meta_default();
	$full_width_img = (isset($media_meta['full_width_featured']) && $media_meta['full_width_featured'] == '1');

	echo "<article id='$uniq_pid' ";
	post_class( array( 'item', 'post', 'post_post', (in_array( 'likes', $post_hide_meta ) ? 'no_likes' : '' ), 'posts_grid_post' ) );
	echo ">";

		if (!empty($image_from_post) && $layout == 'fw_img') {
			$back_img_src = $image_from_post['src'];
			echo "<div class='back_img' style='background-image: url(".esc_url($back_img_src).");'></div>";
		}

		echo "<div class='post_wrapper post_post_wrapper posts_grid_post_wrapper clearfix'>";

			if ($media_meta['show_featured'] && isset($media_meta['full_width_featured'])){
				if ($media_meta['full_width_featured'] == '0'){
					cws_blog_media();		
				}
			} else if($media_meta['show_featured']) {
				cws_blog_media();	
			}

			echo "<div class='post_post_info posts_grid_post_info'>";
				echo "<div class='post_top_wrapper'>";
					if(is_single()){
						echo "<div class='post_meta post_info post_post_meta posts_grid_post_meta'>";
							echo cws_blog_meta_author();
							if( $full_width_img ){
								cws_blog_date();
							}
							echo cws_blog_meta_comments();
						echo "</div>";
						echo cws_blog_meta_likes();
					} else {
						cws_blog_meta();
						cws_blog_taxanomy();
						echo cws_blog_meta_likes();
					}
				echo "</div>";
				cws_blog_content();
				if(is_single()){
					echo "<div class='single_post_meta post_meta post_categories'>";
						echo cws_vc_shortcode_post_posts_grid_post_cats();
						echo cws_vc_shortcode_post_posts_grid_post_tags();
					echo "</div>";
				}
			echo "</div>";

		echo "</div>";	
		cws_page_links();
	echo "</article>";
}

?>