<?php
function cwsfw_get_sections() {
	$l_components = cwsfw_get_local_components();
	$g_components = array();
	if (function_exists('cws_core_get_base_components')) {
		$g_components = cws_core_get_base_components();
		$g_components = cws_core_merge_components($g_components, $l_components);
	}

	$settings = array(
		'general_setting' => array(
			'type' => 'section',
			'title' => esc_html__( 'Header', 'vintwood' ),
			'icon' => array('fa', 'header'),
			'layout' => array(
				'general_cont' => array(
					'type' => 'tab',
					'init' => 'open',
					'icon' => array('fa', 'arrow-circle-o-up'),
					'title' => esc_html__( 'Header', 'vintwood' ),
					'layout' => array(

						'header' => array(
							'type' => 'fields',
							'addrowclasses' => 'inside-box groups grid-col-12 box main-box',
							'layout' => array(
								'order' => array(
									'type' => 'group',
									'addrowclasses' => 'group sortable drop grid-col-12 no_overflow',
									'tooltip' => array(
										'title' => esc_html__( 'Header Order', 'vintwood' ),
										'content' => esc_html__( 'Drag to reorder and customize the header.', 'vintwood' ),
									),
									'title' => esc_html__('Header order', 'vintwood' ),
									'button_title' => esc_html__('Add new sidebar', 'vintwood' ),
									'value' => array(
										array('title' => 'Top Bar','val' => 'top_bar_box'),
										array('title' => 'Header Zone','val' => 'drop_zone_start'),
										array('title' => 'Logo','val' => 'logo_box'),
										array('title' => 'Menu','val' => 'menu_box'),
										array('title' => 'Header Zone','val' => 'drop_zone_end'),
										array('title' => 'Title area','val' => 'header_box'),
									),
									'layout' => array(
										'title' => array(
											'type' => 'text',
											'value' => '',
											'atts' => 'data-role="title"',
											'title' => esc_html__('Sidebar', 'vintwood' ),
										),

										'val' => array(
											'type' => 'text',
										)

									)
								),
								'fixed' => array(
									'title' => esc_html__( 'Apply Fixed header', 'vintwood' ),
									'addrowclasses' => 'checkbox grid-col-12',
									'type' => 'checkbox',
								),							
								'customize' => array(
									'title' => esc_html__( 'Customize', 'vintwood' ),
									'addrowclasses' => 'checkbox grid-col-12',
									'type' => 'checkbox',
									'atts' => 'data-options="e:background_image;e:overlay;e:spacings;e:override_topbar_color;e:override_topbar_color_hover;e:override_menu_color;e:override_menu_color_hover;"',
								),
								'background_image' => array(
									'type' => 'fields',
									'addrowclasses' => 'grid-col-12 inside-box groups',
									'layout' => '%image_layout%',
								),
								'overlay' => array(
									'type' => 'fields',
									'addrowclasses' => 'grid-col-12 disable inside-box groups',
									'layout' => array(
										'type'	=> array(
											'title'		=> esc_html__( 'Add Color overlay', 'vintwood' ),
											'addrowclasses' => 'grid-col-4',
											'type'	=> 'select',
											'source'	=> array(
												'none' => array( esc_html__( 'None', 'vintwood' ),  true, 'd:opacity;d:color;d:gradient;' ),
												'color' => array( esc_html__( 'Color', 'vintwood' ),  false, 'e:opacity;e:color;d:gradient;' ),
												'gradient' => array( esc_html__('Gradient', 'vintwood' ), false, 'e:opacity;d:color;e:gradient;' )
											),
										),
										'color'	=> array(
											'title'	=> esc_html__( 'Color', 'vintwood' ),
											'atts' => 'data-default-color="' . VINTWOOD_FIRST_COLOR . '"',
											'addrowclasses' => 'grid-col-4',
											'value' => VINTWOOD_FIRST_COLOR,
											'type'	=> 'text',
										),
										'opacity' => array(
											'type' => 'number',
											'title' => esc_html__( 'Opacity (%)', 'vintwood' ),
											'placeholder' => esc_attr__( 'In percents', 'vintwood' ),
											'value' => '40',
											'addrowclasses' => 'grid-col-4',
										),
										'gradient' => array(
											'type' => 'fields',
											'addrowclasses' => 'grid-col-12 disable box inside-box groups',
											'layout' => '%gradient_layout%',
										),
									),
								),
								'override_menu_color'	=> array(
									'title'	=> esc_html__( 'Override Menu\'s Font Color', 'vintwood' ),
									'atts' => 'data-default-color="#ffffff"',
									'addrowclasses' => 'grid-col-6 disable',
									'value' => '#ffffff',
									'type'	=> 'text',
								),
								'override_menu_color_hover'	=> array(
									'title'	=> esc_html__( 'Override Menu\'s Font Color on Hover', 'vintwood' ),
									'atts' => 'data-default-color="#ffffff"',
									'addrowclasses' => 'grid-col-6 disable',
									'value' => '#ffffff',
									'type'	=> 'text',
								),
								'override_topbar_color'	=> array(
									'title'	=> esc_html__( 'Override TopBar\'s Font Color', 'vintwood' ),
									'atts' => 'data-default-color="#ffffff"',
									'addrowclasses' => 'grid-col-6 disable',
									'value' => '#ffffff',
									'type'	=> 'text',
								),
								'override_topbar_color_hover' => array(
									'title'	=> esc_html__( 'Override TopBar\'s Font Color on Hover', 'vintwood' ),
									'atts' => 'data-default-color="#ffffff"',
									'addrowclasses' => 'grid-col-6 disable',
									'value' => '#ffffff',
									'type'	=> 'text',
								),
								'spacings' => array(
									'title' => esc_html__( 'Add Spacings', 'vintwood' ),
									'type' => 'margins',
									'addrowclasses' => 'disable grid-col-4 two-inputs',
									'value' => array(
										'top' => array('placeholder' => esc_attr__( 'Top', 'vintwood' ), 'value' => ''),
										'bottom' => array('placeholder' => esc_attr__( 'Bottom', 'vintwood' ), 'value' => ''),
									),
								),
							),
						),

					)
				),
				'logo_cont' => array(
					'type' => 'tab',
					'icon' => array('fa', 'arrow-circle-o-up'),
					'title' => esc_html__( 'Logo', 'vintwood' ),
					'layout' => array(

						'logo_box' => array(
							'type' => 'fields',
							'addrowclasses' => 'inside-box groups grid-col-12 box main-box',
							'layout' => array(
								'enable' => array(
									'title' => esc_html__( 'Logo', 'vintwood' ),
									'addrowclasses' => 'checkbox alt grid-col-12',
									'type' => 'checkbox',
									'atts' => 'checked',
								),															
								'default'	=> array(
									'title'		=> esc_html__( 'Default Logo Variation', 'vintwood' ),
									'addrowclasses' => 'grid-col-12',
									'type'	=> 'select',
									'source'	=> array(
										'dark' => array( esc_html__( 'Dark', 'vintwood' ),  true, '' ),
										'light' => array( esc_html__( 'Light', 'vintwood' ),  false, '' ),
									),
								),
								'dark' => array(
									'title' => esc_html__( 'Dark Logo', 'vintwood' ),
									'type' => 'media',
									'url-atts' => 'readonly',
									'addrowclasses' => 'grid-col-6',
									'layout' => array(
										'is_high_dpi' => array(
											'title' => esc_html__( 'High-Resolution logo', 'vintwood' ),
											'addrowclasses' => 'checkbox',
											'type' => 'checkbox',
										),
									),
								),
								'light' => array(
									'title' => esc_html__( 'Light Logo', 'vintwood' ),
									'type' => 'media',
									'url-atts' => 'readonly',
									'addrowclasses' => 'grid-col-6',
									'layout' => array(
										'is_high_dpi' => array(
											'title' => esc_html__( 'High-Resolution logo', 'vintwood' ),
											'addrowclasses' => 'checkbox',
											'type' => 'checkbox',
										),
									),
								),
								'sticky' => array(
									'title' => esc_html__( 'Sticky Logo', 'vintwood' ),
									'type' => 'media',
									'url-atts' => 'readonly',
									'addrowclasses' => 'grid-col-6',
									'layout' => array(
										'logo_sticky_is_high_dpi' => array(
											'title' => esc_html__( 'High-Resolution sticky logo', 'vintwood' ),
											'addrowclasses' => 'checkbox',
											'type' => 'checkbox',
										),
									),
								),
								'mobile' => array(
									'title' => esc_html__( 'Mobile Logo', 'vintwood' ),
									'type' => 'media',
									'url-atts' => 'readonly',
									'addrowclasses' => 'grid-col-6',
									'layout' => array(
										'logo_mobile_is_high_dpi' => array(
											'title' => esc_html__( 'High-Resolution mobile logo', 'vintwood' ),
											'addrowclasses' => 'checkbox',
											'type' => 'checkbox',
										),
									),
								),
								'dimensions' => array(
									'title' => esc_html__( 'Dimensions', 'vintwood' ),
									'type' => 'dimensions',
									'addrowclasses' => 'grid-col-4',
									'value' => array(
										'width' => array('placeholder' => esc_attr__( 'Width', 'vintwood' ), 'value' => ''),
										'height' => array('placeholder' => esc_attr__( 'Height', 'vintwood' ), 'value' => ''),
									),
								),
								'dimensions_sticky' => array(
									'title' => esc_html__( 'Dimensions (Sticky)', 'vintwood' ),
									'type' => 'dimensions',
									'addrowclasses' => 'grid-col-4',
									'value' => array(
										'width' => array('placeholder' => esc_attr__( 'Width', 'vintwood' ), 'value' => ''),
										'height' => array('placeholder' => esc_attr__( 'Height', 'vintwood' ), 'value' => ''),
									),
								),				
								'dimensions_mobile' => array(
									'title' => esc_html__( 'Dimensions (Mobile)', 'vintwood' ),
									'type' => 'dimensions',
									'addrowclasses' => 'grid-col-4',
									'value' => array(
										'width' => array('placeholder' => esc_attr__( 'Width', 'vintwood' ), 'value' => ''),
										'height' => array('placeholder' => esc_attr__( 'Height', 'vintwood' ), 'value' => ''),
									),
								),													
								'margin' => array(
									'title' => esc_html__( 'Margins (px)', 'vintwood' ),
									'type' => 'margins',
									'addrowclasses' => 'grid-col-12',
									'value' => array(
										'top' => array('placeholder' => esc_attr__( 'Top', 'vintwood' ), 'value' => '6'),
										'left' => array('placeholder' => esc_attr__( 'left', 'vintwood' ), 'value' => '0'),
										'right' => array('placeholder' => esc_attr__( 'Right', 'vintwood' ), 'value' => '0'),
										'bottom' => array('placeholder' => esc_attr__( 'Bottom', 'vintwood' ), 'value' => '-10'),
									),
								),														
								'position' => array(
									'title' => esc_html__( 'Position', 'vintwood' ),
									'type' => 'radio',
									'subtype' => 'images', //
									'addrowclasses' => 'grid-col-4',
									'value' => array(
										'left' => array( esc_html__('Left', 'vintwood'), false, 'd:site_name_in_menu;e:with_site_name;', '/img/align-left.png' ),
										'center' =>array( esc_html__('Center', 'vintwood'), true, 'e:site_name_in_menu;e:with_site_name;', '/img/align-center.png', ),
										'right' =>array( esc_html__('Right', 'vintwood'), false, 'd:site_name_in_menu;e:with_site_name;', '/img/align-right.png', ),
									),
								),
								'in_menu' => array(
									'title' => esc_html__( 'Logo in menu box', 'vintwood' ),
									'addrowclasses' => 'checkbox grid-col-12',
									'type' => 'checkbox',
									'atts' => 'data-options="d:wide;d:overlay;d:border;"',
								),
								'wide' => array(
									'title' => esc_html__( 'Apply Full-Width Container', 'vintwood' ),
									'addrowclasses' => 'checkbox grid-col-12',
									'type' => 'checkbox',
								),

								'overlay' => array(
									'type' => 'fields',
									'addrowclasses' => 'grid-col-12 box inside-box groups',
									'layout' => array(
										'type'	=> array(
											'title'		=> esc_html__( 'Add Color overlay', 'vintwood' ),
											'addrowclasses' => 'grid-col-4',
											'type'	=> 'select',
											'source'	=> array(
												'none' => array( esc_html__( 'None', 'vintwood' ),  true, 'd:opacity;d:color;d:gradient;' ),
												'color' => array( esc_html__( 'Color', 'vintwood' ),  false, 'e:opacity;e:color;d:gradient;' ),
												'gradient' => array( esc_html__('Gradient', 'vintwood' ), false, 'e:opacity;d:color;e:gradient;' )
											),
										),
										'color'	=> array(
											'title'	=> esc_html__( 'Color', 'vintwood' ),
											'atts' => 'data-default-color="' . VINTWOOD_FIRST_COLOR . '"',
											'addrowclasses' => 'grid-col-4',
											'value' => VINTWOOD_FIRST_COLOR,
											'type'	=> 'text',
										),
										'opacity' => array(
											'type' => 'number',
											'title' => esc_html__( 'Opacity (%)', 'vintwood' ),
											'placeholder' => esc_attr__( 'In percents', 'vintwood' ),
											'value' => '40',
											'addrowclasses' => 'grid-col-4',
										),
										'gradient' => array(
											'type' => 'fields',
											'addrowclasses' => 'grid-col-12 disable box inside-box groups',
											'layout' => '%gradient_layout%',
										),
									),
								),
								'border' => array(
									'type' => 'fields',
									'addrowclasses' => 'grid-col-12 inside-box groups',
									'layout' => '%border_layout%',
								),
							),
						),

					)
				),
				'menu_cont' => array(
					'type' => 'tab',
					'icon' => array('fa', 'arrow-circle-o-up'),
					'title' => esc_html__( 'Menu', 'vintwood' ),
					'layout' => array(

						'menu_box' => array(
							'type' => 'fields',
							'addrowclasses' => 'inside-box groups grid-col-12 box main-box',
							'layout' => array(
								'enable' => array(
									'title' => esc_html__( 'Menu', 'vintwood' ),
									'addrowclasses' => 'checkbox alt grid-col-12',
									'type' => 'checkbox',
									'atts' => 'checked',
								),
								'position' => array(
									'title' => esc_html__( 'Menu Alignment', 'vintwood' ),
									'type' => 'radio',
									'subtype' => 'images',
									'addrowclasses' => 'grid-col-3',
									'value' => array(
										'left' => array( esc_html__( 'Left', 'vintwood' ), 	false, '', '/img/align-left.png' ),
										'center' =>array( esc_html__( 'Center', 'vintwood' ), true, '', '/img/align-center.png' ),
										'right' =>array( esc_html__( 'Right', 'vintwood' ), false, '', '/img/align-right.png' ),
									),
								),
								'search_place' => array(
									'title' => esc_html__( 'Search Icon Location', 'vintwood' ),
									'type' => 'radio',
									'subtype' => 'images',
									'addrowclasses' => 'grid-col-3',
									'value' => array(
										'none' => array( esc_html__( 'None', 'vintwood' ), 	false, '', '/img/no_layout.png' ),
										'top' => array( esc_html__( 'Top', 'vintwood' ), 	false, '', '/img/search-social-right.png' ),
										'left' =>array( esc_html__( 'Left', 'vintwood' ), false, '', '/img/search-menu-left.png' ),
										'right' =>array( esc_html__( 'Right', 'vintwood' ), true, '', '/img/search-menu-right.png' ),
									),
								),						
								'mobile_place' => array(
									'title' => esc_html__( 'Mobile Menu Location', 'vintwood' ),
									'type' => 'radio',
									'subtype' => 'images',
									'addrowclasses' => 'grid-col-3',
									'value' => array(
										'left' =>array( esc_html__( 'Left', 'vintwood' ), false, '', '/img/hamb-left.png' ),
										'right' =>array( esc_html__( 'Right', 'vintwood' ), true, '', '/img/hamb-right.png' ),
									),
								),
								'background_color' => array(
									'title' => esc_html__( 'Background color', 'vintwood' ),
									'atts' => 'data-default-color="transparent"',
									'value' => 'transparent',
									'addrowclasses' => 'grid-col-4',
									'type' => 'text',
								),
								'background_opacity' => array(
									'type' => 'number',
									'title' => esc_html__( 'Background Opacity', 'vintwood' ),
									'placeholder' => esc_attr__( 'In percents', 'vintwood' ),
									'addrowclasses' => 'grid-col-4',
									'value' => '100'
								),
								'margin' => array(
									'title' => esc_html__( 'Add Spacings', 'vintwood' ),
									'type' => 'margins',
									'addrowclasses' => 'grid-col-4 two-inputs',
									'value' => array(
										'top' => array('placeholder' => esc_attr__( 'Top', 'vintwood' ), 'value' => '0'),
										'bottom' => array('placeholder' => esc_attr__( 'Bottom', 'vintwood' ), 'value' => '0'),
									),
								),
								'font_color' => array(
									'type' => 'text',
									'title' => esc_html__( 'Custom Font Color', 'vintwood' ),
									'atts' => 'data-default-color="'.VINTWOOD_FIRST_COLOR.'"',
									'value' => VINTWOOD_FIRST_COLOR,
									'addrowclasses' => 'grid-col-4',
								),
								'font_color_hover' => array(
									'type' => 'text',
									'title' => esc_html__( 'Custom Font Color on Hover', 'vintwood' ),
									'atts' => 'data-default-color="'.VINTWOOD_SECOND_COLOR.'"',
									'value' => VINTWOOD_SECOND_COLOR,
									'addrowclasses' => 'grid-col-4',
								),
								'border' => array(
									'type' => 'fields',
									'addrowclasses' => 'grid-col-12 box inside-box groups',
									'layout' => '%border_layout%',
								),
								'menu_stripes' => array(
									'title' => esc_html__( 'Add stripes to menu', 'vintwood' ),
									'addrowclasses' => 'checkbox grid-col-6',
									'atts' => 'checked data-options="e:stripes_offset;"',
									'type' => 'checkbox',
								),
								'stripes_offset' => array(
									'title' => esc_html__( 'Top and Bottom Stripes Offset', 'vintwood' ),
									'type' => 'margins',
									'addrowclasses' => 'grid-col-12 two-inputs',
									'value' => array(
										'top' => array('placeholder' => esc_attr__( 'Top', 'vintwood' ), 'value' => '21'),
										'bottom' => array('placeholder' => esc_attr__( 'Bottom', 'vintwood' ), 'value' => '17'),
									),
								),
								'enable_mobile' => array(
									'title' => esc_html__( 'Enable Mobile menu on tablets', 'vintwood' ),
									'addrowclasses' => 'checkbox grid-col-6',
									'atts' => 'checked',
									'type' => 'checkbox',
								),
								'header_outside_slider' => array(
									'title' => esc_html__( 'Header overlays slider', 'vintwood' ),
									'addrowclasses' => 'checkbox grid-col-6',
									'type' => 'checkbox',
								),
								'wide' => array(
									'title' => esc_html__( 'Apply Full-Width Menu', 'vintwood' ),
									'addrowclasses' => 'checkbox grid-col-6',
									'type' => 'checkbox',
									'atts' => 'checked',
								),
							),
						),

					)
				),
				'sticky_menu_cont' => array(
					'type' => 'tab',
					'icon' => array('fa', 'arrow-circle-o-up'),
					'title' => esc_html__( 'Sticky', 'vintwood' ),
					'layout' => array(

						'sticky_menu' => array(
							'type' => 'fields',
							'addrowclasses' => 'inside-box groups grid-col-12 box main-box',
							'layout' => array(
								'enable' => array(
									'title' => esc_html__( 'Sticky menu', 'vintwood' ),
									'addrowclasses' => 'checkbox grid-col-6 alt',
									'type' => 'checkbox',
								),
								'mode'	=> array(
									'title'		=> esc_html__( 'Select a Sticky\'s Mode', 'vintwood' ),
									'type'	=> 'select',
									'addrowclasses' => 'grid-col-12',
									'source'	=> array(
										'smart' => array( esc_html__( 'Smart', 'vintwood' ),  true ),
										'simple' => array( esc_html__( 'Simple', 'vintwood' ), false ),
									),
								),								
								'background_color' => array(
									'title' => esc_html__( 'Background color', 'vintwood' ),
									'tooltip' => array(
										'title' => esc_html__( 'Background Color', 'vintwood' ),
										'content' => esc_html__( 'This color is applied to header section including top bar.', 'vintwood' ),
									),
									'atts' => 'data-default-color="#ffffff"',
									'value' => '#ffffff',
									'addrowclasses' => 'grid-col-6',
									'type' => 'text',
								),
								'background_opacity' => array(
									'type' => 'number',
									'title' => esc_html__( 'Opacity', 'vintwood' ),
									'tooltip' => array(
										'title' => esc_html__( 'Header Opacity', 'vintwood' ),
										'content' => esc_html__( 'This option will apply the transparent header when set to "0".', 'vintwood' ),
									),
									'placeholder' => esc_attr__( 'In percents', 'vintwood' ),
									'addrowclasses' => 'grid-col-6',
									'value' => '100'
								),
								'font_color' => array(
									'title' => esc_html__( 'Override Font color', 'vintwood' ),
									'tooltip' => array(
										'title' => esc_html__( 'Override Font Color', 'vintwood' ),
										'content' => esc_html__( 'This color is applied to main menu items only, submenus will use the color which is set in Typography section.<br /> This option is very useful when transparent menu is set.', 'vintwood' ),
									),
									'atts' => 'data-default-color="'.VINTWOOD_FIRST_COLOR.'"',
									'value' => VINTWOOD_FIRST_COLOR,
									'addrowclasses' => 'grid-col-6',
									'type' => 'text',
								),
								'font_color_hover' => array(
									'title' => esc_html__( 'Override Font Color on Hover', 'vintwood' ),
									'atts' => 'data-default-color="'.VINTWOOD_SECOND_COLOR.'"',
									'value' => VINTWOOD_SECOND_COLOR,
									'addrowclasses' => 'grid-col-6',
									'type' => 'text',
								),
								'border' => array(
									'type' => 'fields',
									'addrowclasses' => 'grid-col-12 box inside-box groups',
									'layout' => '%border_layout%',
								),
								'shadow' => array(
									'title' => esc_html__( 'Add Shadow', 'vintwood' ),
									'addrowclasses' => 'checkbox grid-col-12',
									'type' => 'checkbox',
								),
							),
						),

					)
				),
				'title_area_cont' => array(
					'type' => 'tab',
					'icon' => array( 'fa', 'fa-book' ),
					'title' => esc_html__( 'Title', 'vintwood' ),
					'layout' => array(

						'header_box' => array(
							'type' => 'fields',
							'addrowclasses' => 'inside-box groups grid-col-12 box main-box',
							'layout' => array(
								'enable' => array(
									'title' => esc_html__( 'Title area', 'vintwood' ),
									'addrowclasses' => 'checkbox grid-col-12 alt',
									'type' => 'checkbox',
									'atts' => 'checked',
								),
								'no_title' => array(
									'title' => esc_html__( 'Hide Page Title', 'vintwood' ),
									'addrowclasses' => 'checkbox grid-col-3',
									'type' => 'checkbox',
								),	
								'customize' => array(
									'title' => esc_html__( 'Customize', 'vintwood' ),
									'addrowclasses' => 'checkbox grid-col-3',
									'type' => 'checkbox',
									'atts' => 'data-options="e:rotate_img;e:animate;e:slide_down;e:font_color;e:show_on_posts;e:show_on_archives;e:background_image;e:overlay;e:use_pattern;e:use_blur;e:effect;e:title_height;e:stroke_color;e:drop_shadow_prop;e:drop_shadow_color;"',
								),
								'rotate_img' => array(
									'title' => esc_html__( 'Apply infinite spin to background image', 'vintwood' ),
									'addrowclasses' => 'disable checkbox grid-col-4',
									'atts' => 'checked',
									'type' => 'checkbox',
								),
								'show_on_posts' => array(
									'title' => esc_html__( 'Use Custom Settings on Posts', 'vintwood' ),
									'addrowclasses' => 'disable checkbox grid-col-5',
									'atts' => 'checked',
									'type' => 'checkbox',
								),
								'show_on_archives' => array(
									'title' => esc_html__( 'Use Custom Settings on Archives', 'vintwood' ),
									'addrowclasses' => 'disable checkbox grid-col-5',
									'type' => 'checkbox',
								),
								'overlay' => array(
									'type' => 'fields',
									'addrowclasses' => 'grid-col-12 disable box inside-box groups',
									'layout' => array(
										'type'	=> array(
											'title'		=> esc_html__( 'Add Background Color', 'vintwood' ),
											'addrowclasses' => 'grid-col-4',
											'type'	=> 'select',
											'source'	=> array(
												'none' => array( esc_html__( 'None', 'vintwood' ),  true, 'd:opacity;d:color;d:gradient;' ),
												'color' => array( esc_html__( 'Color', 'vintwood' ),  false, 'e:opacity;e:color;d:gradient;' ),
												'gradient' => array( esc_html__('Gradient', 'vintwood' ), false, 'e:opacity;d:color;e:gradient;' )
											),
										),
										'color'	=> array(
											'title'	=> esc_html__( 'Color', 'vintwood' ),
											'atts' => 'data-default-color="#6eb8b3"',
											'addrowclasses' => 'grid-col-4',
											'value' => "#6eb8b3",
											'type'	=> 'text',
										),
										'opacity' => array(
											'type' => 'number',
											'title' => esc_html__( 'Opacity (%)', 'vintwood' ),
											'placeholder' => esc_attr__( 'In percents', 'vintwood' ),
											'value' => '100',
											'addrowclasses' => 'grid-col-4',
										),
										'gradient' => array(
											'type' => 'fields',
											'addrowclasses' => 'grid-col-12 disable box inside-box groups',
											'layout' => '%gradient_layout%',
										),
									),
								),
								'background_image' => array(
									'title' => esc_html__( 'Background image', 'vintwood' ),
									'type' => 'media',
									'url-atts' => 'readonly',
									'addrowclasses' => 'grid-col-6'
								),
								'custom_pattern' => array(
									'title' => esc_html__( 'Add pattern', 'vintwood' ),
									'type' => 'media',
									'url-atts' => 'readonly',
									'addrowclasses' => 'grid-col-6',
								),
								'title_height' => array(
									'type' => 'number',
									'title' => esc_html__( 'Title Area Min-Height (px)', 'vintwood' ),
									'placeholder' => esc_attr__( 'In pixels', 'vintwood' ),
									'value' => '500',
									'addrowclasses' => 'grid-col-6',
								),
								'pattern_opacity' => array(
									'type' => 'number',
									'title' => esc_html__( 'Pattern Opacity (%)', 'vintwood' ),
									'placeholder' => esc_attr__( 'In percents', 'vintwood' ),
									'value' => '100',
									'addrowclasses' => 'grid-col-6',
								),
								'font_color' => array(
									'title'	=> esc_html__( 'Override Font Color', 'vintwood' ),
									'atts' => 'data-default-color="#4f7b70"',
									'value' => '#4f7b70',
									'addrowclasses' => 'disable grid-col-6',
									'type'	=> 'text',
								),
								'page_title_size' => array(
									'type' => 'number',
									'title' => esc_html__( 'Page Title Size', 'vintwood' ),
									'value' => '55',
									'addrowclasses' => 'grid-col-6',
								),
								'stroke_color' => array(
									'title'	=> esc_html__( 'Title Stroke Color', 'vintwood' ),
									'atts' => 'data-default-color="#E4DDD3"',
									'value' => '#E4DDD3',
									'addrowclasses' => 'disable grid-col-4',
									'type'	=> 'text',
								),
								'drop_shadow_prop' => array(
									'type' => 'text',
									'title' => esc_html__( 'Drop-Shadow Properties', 'vintwood' ),
									'addrowclasses' => 'disable grid-col-4',
									'value'	=> '2px 3px',
								),
								'drop_shadow_color' => array(
									'type' => 'text',
									'title' => esc_html__( 'Drop-Shadow Color', 'vintwood' ),
									'atts' => 'data-default-color="'.VINTWOOD_FIRST_COLOR.'"',
									'value' => VINTWOOD_FIRST_COLOR,
									'addrowclasses' => 'disable grid-col-4',
									'type'	=> 'text',
								),
							),
						),

					)
				),
				'top_bar_cont' => array(
					'type' => 'tab',
					'icon' => array('fa', 'arrow-circle-o-up'),
					'title' => esc_html__( 'Top Bar', 'vintwood' ),
					'layout' => array(

						'top_bar_box' => array(
							'type' => 'fields',
							'addrowclasses' => 'inside-box groups grid-col-12 box main-box',
							'layout' => array(
								'enable' => array(
									'title' => esc_html__( 'Top Panel', 'vintwood' ),
									'addrowclasses' => 'grid-col-12 checkbox alt',
									'type' => 'checkbox',
								),
								'wide' => array(
									'title' => esc_html__( 'Apply Full-Width Top Bar', 'vintwood' ),
									'addrowclasses' => 'grid-col-12 checkbox',
									'type' => 'checkbox',
								),
								'language_bar' => array(
									'title' => esc_html__( 'Add Language Bar', 'vintwood' ),
									'addrowclasses' => 'grid-col-12 checkbox',
									'atts' => 'checked data-options="e:language_bar_position;"',
									'type' => 'checkbox',
								),
								'language_bar_position' => array(
									'title' => esc_html__( 'Language Bar Alignment', 'vintwood' ),
									'type' => 'radio',
									'subtype' => 'images',
									'addrowclasses' => 'disable grid-col-4',
									'value' => array(
										'left' => array( esc_html__( 'Left', 'vintwood' ), 	true, '', '/img/multilingual-left.png' ),
										'right' =>array( esc_html__( 'Right', 'vintwood' ), false, '', '/img/multilingual-right.png' ),
									),
								),
								'social_place' => array(
									'title' => esc_html__( 'Social Icons Alignment', 'vintwood' ),
									'type' => 'radio',
									'subtype' => 'images',
									'addrowclasses' => 'grid-col-4',
									'value' => array(
										'left' =>array( esc_html__( 'Left', 'vintwood' ), true, '', '/img/social-left.png' ),
										'right' =>array( esc_html__( 'Right', 'vintwood' ), false, '', '/img/social-right.png' ),
									),
								),
								'content_place' => array(
									'title' => esc_html__( 'Content Alignment', 'vintwood' ),
									'type' => 'radio',
									'subtype' => 'images',
									'addrowclasses' => 'grid-col-4',
									'value' => array(
										'left' =>array( esc_html__( 'Left', 'vintwood' ), true, '', '/img/social-left.png' ),
										'right' =>array( esc_html__( 'Right', 'vintwood' ), false, '', '/img/social-right.png' ),
									),
								),						
								'content_items' => array(
									'type' => 'group',
									'addrowclasses' => 'grid-col-12 group expander sortable box',
									'title' => esc_html__('Top Bar Info', 'vintwood' ),
									'button_title' => esc_html__('Add new info row', 'vintwood' ),
									'layout' => array(
										'icon' => array(
											'type' => 'select',
											'addrowclasses' => 'grid-col-3 fai',
											'source' => 'fa',
											'title' => esc_html__('Select the icon', 'vintwood' )
										),
										'title' => array(
											'type' => 'text',
											'atts' => 'data-role="title"',
											'addrowclasses' => 'grid-col-3',
											'title' => esc_html__('Write main info', 'vintwood' ),
										),
										'url' => array(
											'type' => 'text',
											'addrowclasses' => 'grid-col-3',
											'title' => esc_html__('Write URL', 'vintwood' ),
										),
										'link_type' => array(
											'type' => 'select',
											'addrowclasses' => 'grid-col-3 fai',
											'source' => array(
												'link' => array( esc_html__( 'Link', 'vintwood' ),  true, '' ),
												'mailto:' => array( esc_html__( 'Email', 'vintwood' ),  false, '' ),
												'skype:' => array( esc_html__( 'Skype', 'vintwood' ),  false, '' ),
												'tel:' => array( esc_html__( 'Phone', 'vintwood' ),  false, '' ),
											),
											'title' => esc_html__('Select link type', 'vintwood' )
										),
									),
								),
								'title_styles' => array(
									'title' => esc_html__( 'Customize Top Bar', 'vintwood' ),
									'addrowclasses' => 'alt checkbox grid-col-12',
									'type' => 'checkbox',
									'atts' => 'data-options="e:background_color;e:background_opacity;e:custom_pattern;e:pattern_opacity;"',
								),
								'background_color' => array(
									'title' => esc_html__( 'Customize Background', 'vintwood' ),
									'atts' => 'data-default-color="#6eb8b3"',
									'value' => '#6eb8b3',
									'addrowclasses' => 'disable new_row grid-col-6',
									'type' => 'text',
								),
								'background_opacity' => array(
									'type' => 'number',
									'title' => esc_html__( 'Background Opacity (%)', 'vintwood' ),
									'placeholder' => esc_attr__( 'In percents', 'vintwood' ),
									'value' => '100',
									'addrowclasses' => 'disable grid-col-6',
								),
								'custom_pattern' => array(
									'title' => esc_html__( 'Add pattern', 'vintwood' ),
									'type' => 'media',
									'url-atts' => 'readonly',
									'addrowclasses' => 'disable grid-col-6',
								),
								'pattern_opacity' => array(
									'type' => 'number',
									'title' => esc_html__( 'Pattern Opacity (%)', 'vintwood' ),
									'placeholder' => esc_attr__( 'In percents', 'vintwood' ),
									'value' => '100',
									'addrowclasses' => 'disable grid-col-6',
								),
								'font_color' => array(
									'title' => esc_html__( 'Font Color', 'vintwood' ),
									'atts' => 'data-default-color="#224A49"',
									'value' => '#224A49',
									'addrowclasses' => 'grid-col-6',
									'type' => 'text',
								),
								'hover_font_color' => array(
									'title' => esc_html__( 'Hover Color', 'vintwood' ),
									'atts' => 'data-default-color="#E53E26"',
									'value' => '#E53E26',
									'addrowclasses' => 'grid-col-6',
									'type' => 'text',
								),
								'border' => array(
									'type' => 'fields',
									'addrowclasses' => 'grid-col-12 box inside-box groups',
									'layout' => '%border_layout%',
								),
								'spacings' => array(
									'title' => esc_html__( 'Add Spacings (px)', 'vintwood' ),
									'type' => 'margins',
									'addrowclasses' => 'new_row grid-col-12 two-inputs',
									'value' => array(
										'top' => array('placeholder' => esc_attr__( 'Top', 'vintwood' ), 'value' => '5'),
										'bottom' => array('placeholder' => esc_attr__( 'Bottom', 'vintwood' ), 'value' => '5'),
									),
								),	
							),
						),

					)
				),
				'side_panel_cont' => array(
					'type' => 'tab',
					'icon' => array('fa', 'arrow-circle-o-up'),
					'title' => esc_html__( 'Sidebar', 'vintwood' ),
					'layout' => array(

						'side_panel' => array(
							'type' => 'fields',
							'addrowclasses' => 'inside-box groups grid-col-12 box main-box',
							'layout' => array(
								'enable' => array(
									'title' => esc_html__( 'Side Panel', 'vintwood' ),
									'addrowclasses' => 'alt checkbox grid-col-12',
									'type' => 'checkbox',
								),	
								// 1st row
								'theme'	=> array(
									'title'		=> esc_html__( 'Color Variation', 'vintwood' ),
									'addrowclasses' => 'grid-col-12',
									'type'	=> 'select',
									'source'	=> array(
										'dark' => array( esc_html__( 'Dark', 'vintwood' ),  true, '' ),
										'light' => array( esc_html__( 'Light', 'vintwood' ),  false, '' ),
									),
								),
								'place' => array(
									'title' => esc_html__( 'Menu Icon Location', 'vintwood' ),
									'type' => 'radio',
									'subtype' => 'images',
									'addrowclasses' => 'grid-col-12',
									'value' => array(
										'topbar_left' =>array( esc_html__( 'TopBar (Left)', 'vintwood' ), false, '', '/img/top-hamb-left.png' ),
										'topbar_right' => array( esc_html__( 'TopBar (Right)', 'vintwood' ), 	false, '', '/img/top-hamb-right.png' ),
										'menu_left' =>array( esc_html__( 'Menu (Left)', 'vintwood' ), true, '', '/img/hamb-left.png' ),
										'menu_right' =>array( esc_html__( 'Menu (Right)', 'vintwood' ), false, '', '/img/hamb-right.png' ),
									),
								),
								'position' => array(
									'title' 			=> esc_html__('Side Panel Position', 'vintwood' ),
									'type' 				=> 'radio',
									'subtype' 			=> 'images',
									'addrowclasses' => 'grid-col-12',
									'value' 			=> array(
										'left' 				=> 	array( esc_html__('Left', 'vintwood' ), true, '',	'/img/left.png' ),
										'right' 			=> 	array( esc_html__('Right', 'vintwood' ), false, '', '/img/right.png' ),
									),
								),								
								'sidebar' => array(
									'title' 		=> esc_html__('Select the Sidebar Area', 'vintwood' ),
									'type' 			=> 'select',
									'addrowclasses' => 'new_row grid-col-12',
									'source' 		=> 'sidebars',
									'value' => 'side_panel',
								),
								'appear'	=> array(
									'title'		=> esc_html__( 'Animation Format', 'vintwood' ),
									'type'	=> 'select',
									'addrowclasses' => 'grid-col-12',
									'source'	=> array(
										'fade' => array( esc_html__( 'Fade', 'vintwood' ),  true ),
										'slide' => array( esc_html__( 'Slide', 'vintwood' ), false ),
										'pull' => array( esc_html__( 'Pull', 'vintwood' ), false ),
									),
								),
								'logo_dark' => array(
									'title' => esc_html__( 'Logo (Dark)', 'vintwood' ),
									'type' => 'media',
									'url-atts' => 'readonly',
									'addrowclasses' => 'grid-col-6',
									'layout' => array(
										'is_high_dpi' => array(
											'title' => esc_html__( 'High-Resolution logo', 'vintwood' ),
											'addrowclasses' => 'checkbox',
											'type' => 'checkbox',
										),
									),
								),
								'logo_light' => array(
									'title' => esc_html__( 'Logo (Light)', 'vintwood' ),
									'type' => 'media',
									'url-atts' => 'readonly',
									'addrowclasses' => 'grid-col-6',
									'layout' => array(
										'is_high_dpi' => array(
											'title' => esc_html__( 'High-Resolution logo', 'vintwood' ),
											'addrowclasses' => 'checkbox',
											'type' => 'checkbox',
										),
									),
								),
								'logo_position' => array(
									'title' => esc_html__( 'Logo position', 'vintwood' ),
									'addrowclasses' => 'grid-col-12',
									'type' => 'radio',
									'value' => array(
										'left' => array( esc_html__( 'Left', 'vintwood' ),  true, '' ),
										'center' =>array( esc_html__( 'Center', 'vintwood' ), false,  '' ),
										'right' =>array( esc_html__( 'Right', 'vintwood' ), false,  '' ),
									),
								),
								'logo_dimensions' => array(
									'title' => esc_html__( 'Logo Dimensions', 'vintwood' ),
									'type' => 'dimensions',
									'addrowclasses' => 'grid-col-12',
									'value' => array(
										'width' => array('placeholder' => esc_attr__( 'Width', 'vintwood' ), 'value' => ''),
										'height' => array('placeholder' => esc_attr__( 'Height', 'vintwood' ), 'value' => ''),
									),
								),
								'close_position' => array(
									'title' => esc_html__( 'Close button position', 'vintwood' ),
									'addrowclasses' => 'grid-col-12',
									'type' => 'radio',
									'value' => array(
										'left' => array( esc_html__( 'Left', 'vintwood' ),  true, '' ),
										'right' =>array( esc_html__( 'Right', 'vintwood' ), false,  '' ),
									),
								),								
								// 4th row
								'bg_dark' => array(
									'title' => esc_html__( 'Background (Dark)', 'vintwood' ),
									'type' => 'media',
									'url-atts' => 'readonly',
									'addrowclasses' => 'grid-col-6',
								),
								'bg_light' => array(
									'title' => esc_html__( 'Background (Light)', 'vintwood' ),
									'type' => 'media',
									'url-atts' => 'readonly',
									'addrowclasses' => 'grid-col-6',
								),
								// 5th row
								'bg_size' => array(
									'title' => esc_html__( 'Background size', 'vintwood' ),
									'addrowclasses' => 'grid-col-4',
									'type' => 'radio',
									'value' => array(
										'cover' => array( esc_html__( 'Cover', 'vintwood' ),  true, '' ),
										'contain' =>array( esc_html__( 'Contain', 'vintwood' ), false,  '' ),
									),
								),
								'bg_opacity' => array(
									'type' => 'number',
									'title' => esc_html__( 'Background Opacity', 'vintwood' ),
									'placeholder' => esc_attr__( 'In percents', 'vintwood' ),
									'addrowclasses' => 'grid-col-4',
									'value' => '100'
								),
								'bg_position' => array(
									'title' => esc_html__( 'Background Position', 'vintwood' ),
									'addrowclasses' => 'grid-col-4',
									'cols' => 3,
									'type' => 'radio',
									'value' => array(
										'tl'=>	array( '', false ),
										'tc'=>	array( '', false ),
										'tr'=>	array( '', false ),
										'cl'=>	array( '', false ),
										'cc'=>	array( '', true ),
										'cr'=>	array( '', false ),
										'bl'=>	array( '', false ),
										'bc'=>	array( '', false ),
										'br'=>	array( '', false ),
									),
								),
								'bg_color'	=> array(
									'title'	=> esc_html__( 'Background Color', 'vintwood' ),
									'atts' => 'data-default-color="#ffffff"',
									'addrowclasses' => 'grid-col-6',
									'value' => '#ffffff',
									'type'	=> 'text',
								),
								'bg_font_color'	=> array(
									'title'	=> esc_html__( 'Font color', 'vintwood' ),
									'atts' => 'data-default-color="#4c4c4c"',
									'addrowclasses' => 'grid-col-6',
									'value' => '#4c4c4c',
									'type'	=> 'text',
								),
								// 6th row
								'overlay' => array(
									'type' => 'fields',
									'addrowclasses' => 'grid-col-12 box inside-box groups',
									'layout' => array(
										'type'	=> array(
											'title'		=> esc_html__( 'Overlay color', 'vintwood' ),
											'addrowclasses' => 'grid-col-4',
											'type'	=> 'select',
											'source'	=> array(
												'none' => array( esc_html__( 'None', 'vintwood' ),  true, 'd:opacity;d:color;d:gradient;' ),
												'color' => array( esc_html__( 'Color', 'vintwood' ),  false, 'e:opacity;e:color;d:gradient;' ),
												'gradient' => array( esc_html__('Gradient', 'vintwood' ), false, 'e:opacity;d:color;e:gradient;' )
											),
										),
										'color'	=> array(
											'title'	=> esc_html__( 'Color', 'vintwood' ),
											'atts' => 'data-default-color="' . VINTWOOD_FIRST_COLOR . '"',
											'addrowclasses' => 'grid-col-4',
											'value' => VINTWOOD_FIRST_COLOR,
											'type'	=> 'text',
										),
										'opacity' => array(
											'type' => 'number',
											'title' => esc_html__( 'Opacity (%)', 'vintwood' ),
											'placeholder' => esc_attr__( 'In percents', 'vintwood' ),
											'value' => '40',
											'addrowclasses' => 'grid-col-4',
										),
										'gradient' => array(
											'type' => 'fields',
											'addrowclasses' => 'grid-col-12 disable box inside-box groups',
											'layout' => '%gradient_layout%',
										),
									),
								),
								'bottom_bar' => array(
									'type' => 'fields',
									'addrowclasses' => 'inside-box groups grid-col-12 box',
									'layout' => array(
										'info_icons' => array(
											'type' => 'group',
											'addrowclasses' => 'group sortable grid-col-12 box',
											'title' => esc_html__('Information', 'vintwood' ),
											'button_title' => esc_html__('Add new information row', 'vintwood' ),
											'button_icon' => 'fa fa-plus',
											'layout' => array(
												'title' => array(
													'type' => 'text',
													'atts' => 'data-role="title"',
													'addrowclasses' => 'grid-col-6',
													'title' => esc_html__('Title', 'vintwood' ),
												),
												'icon' => array(
													'type' => 'select',
													'addrowclasses' => 'fai grid-col-6',
													'source' => 'fa',
													'title' => esc_html__('Icon', 'vintwood' )
												),
											)
										),																
									),
								),

							),
						),

					)
				),
			)
		),
		// end of sections
		'footer_options' => array(
			'type' => 'section',
			'title' => esc_html__('Footer', 'vintwood' ),
			'icon' => array('fa', 'list-alt'),
			'layout' => array(
				'footer_cont' => array(
					'type' => 'tab',
					'init' => 'open',
					'icon' => array( 'fa', 'fa-book' ),
					'title' => esc_html__( 'Footer', 'vintwood' ),
					'layout' => array(

						'footer' => array(
							'type' => 'fields',
							'addrowclasses' => 'inside-box groups grid-col-12 box main-box',
							'layout' => array(					
								'wide' => array(
									'title' => esc_html__( 'Apply Full-Width Footer', 'vintwood' ),
									'addrowclasses' => 'checkbox grid-col-12',
									'type' => 'checkbox',
								),
								'ripped' => array(
									'title' => esc_html__( '"Ripped" footer', 'vintwood' ),
									'addrowclasses' => 'checkbox grid-col-12',
									'type' => 'checkbox',
								),						
								'layout' => array(
									'type' => 'select',
									'title' => esc_html__( 'Select a layout', 'vintwood' ),
									'addrowclasses' => 'grid-col-6',
									'source' => array(
										'1' => array( esc_html__( '1/1 Column', 'vintwood' ),  false ),
										'2' => array( esc_html__( '2/2 Column', 'vintwood' ), false ),
										'3' => array( esc_html__( '3/3 Column', 'vintwood' ), false ),
										'4' => array( esc_html__( '4/4 Column', 'vintwood' ), false ),
										'two-three' => array( esc_html__( '2/3 + 1/3 Column', 'vintwood' ), false ),
										'one-two' => array( esc_html__( '1/3 + 2/3 Column', 'vintwood' ), false ),
										'one-three' => array( esc_html__( '1/4 + 3/4 Column', 'vintwood' ), false ),
										'one-one-two' => array( esc_html__( '1/4 + 1/4 + 2/4 Column', 'vintwood' ), false ),
										'two-one-one' => array( esc_html__( '2/4 + 1/4 + 1/4 Column', 'vintwood' ), true ),
										'one-two-one' => array( esc_html__( '1/4 + 2/4 + 1/4 Column', 'vintwood' ), false ),
									),
								),
								'sidebar' => array(
									'title' 		=> esc_html__('Select Footer\'s Sidebar Area', 'vintwood' ),
									'type' 			=> 'select',
									'addrowclasses' => 'grid-col-6',
									'source' 		=> 'sidebars',
								),
								'text_alignment' => array(
									'type' => 'select',
									'title' => esc_html__( 'Text Alignment', 'vintwood' ),
									'addrowclasses' => 'grid-col-6',
									'source' => array(
										'left' => array( esc_html__( 'Left', 'vintwood' ), 	false, '' ), 
										'center' => array( esc_html__( 'Center', 'vintwood' ), 	false, '' ),
										'right' => array( esc_html__( 'Right', 'vintwood' ), 	false, '' ), 
									),
								),							
								'copyrights_text' => array(
									'title' => esc_html__( 'Copyrights content', 'vintwood' ),
									'type' => 'textarea',
									'addrowclasses' => 'grid-col-12 full_row',
									'value' => 'Copyright 2018. All rights reserved.',
									'atts' => 'rows="6"',
								),
								'background_image' => array(
									'type' => 'fields',
									'addrowclasses' => 'box grid-col-12 inside-box groups',
									'layout' => '%image_layout%',
								),							
								'background_color'	=> array(
									'title'	=> esc_html__( 'Background Color', 'vintwood' ),
									'atts'	=> 'data-default-color="#222222"',
									'value' => '#222222',
									'addrowclasses' => 'grid-col-4',
									'type'	=> 'text'
								),
								'title_color' => array(
									'title' => esc_html__( 'Titles Color', 'vintwood' ),
									'atts' => 'data-default-color="#ffffff"',
									'value' => '#ffffff',
									'addrowclasses' => 'grid-col-4',
									'type' => 'text',
								),								
								'font_color' => array(
									'title' => esc_html__( 'Font Color', 'vintwood' ),
									'atts' => 'data-default-color="#a6a6a6"',
									'value' => '#a6a6a6',
									'addrowclasses' => 'grid-col-4',
									'type' => 'text',
								),
								'copyrights_background_color' => array(
									'title'	=> esc_html__( 'Background Color (Copyrights)', 'vintwood' ),
									'atts' => 'data-default-color="#24273a"',
									'value' => '#24273a',
									'addrowclasses' => 'grid-col-4',
									'type'	=> 'text'
								),
								'copyrights_font_color' => array(
									'title' => esc_html__( 'Font color (Copyrights)', 'vintwood' ),
									'atts' => 'data-default-color="#a6a6a6"',
									'value' => '#a6a6a6',
									'addrowclasses' => 'grid-col-4',
									'type' => 'text',
								),
								'copyrights_hover_color' => array(
									'title' => esc_html__( 'Hover color (Copyrights)', 'vintwood' ),
									'atts' => 'data-default-color="#ffffff"',
									'value' => '#ffffff',
									'addrowclasses' => 'grid-col-4',
									'type' => 'text',
								),				
								'pattern_image' => array(
									'type' => 'fields',
									'title' => esc_html__( 'Pattern Image', 'vintwood' ),
									'addrowclasses' => 'box grid-col-12 inside-box groups',
									'layout' => '%image_layout%',
								),
								'overlay' => array(
									'type' => 'fields',
									'addrowclasses' => 'grid-col-12 box inside-box groups',
									'layout' => array(
										'type'	=> array(
											'title'		=> esc_html__( 'Color overlay', 'vintwood' ),
											'addrowclasses' => 'grid-col-4',
											'type'	=> 'select',
											'source'	=> array(
												'none' => array( esc_html__( 'None', 'vintwood' ),  true, 'd:opacity;d:color;d:gradient;' ),
												'color' => array( esc_html__( 'Color', 'vintwood' ),  false, 'e:opacity;e:color;d:gradient;' ),
												'gradient' => array( esc_html__('Gradient', 'vintwood' ), false, 'e:opacity;d:color;e:gradient;' )
											),
										),
										'color'	=> array(
											'title'	=> esc_html__( 'Color', 'vintwood' ),
											'atts' => 'data-default-color="' . VINTWOOD_FIRST_COLOR . '"',
											'addrowclasses' => 'grid-col-4',
											'value' => VINTWOOD_FIRST_COLOR,
											'type'	=> 'text',
											'customizer' => array( 'show' => true )
										),
										'opacity' => array(
											'type' => 'number',
											'title' => esc_html__( 'Opacity (%)', 'vintwood' ),
											'placeholder' => esc_attr__( 'In percents', 'vintwood' ),
											'value' => '40',
											'addrowclasses' => 'grid-col-4',
										),
										'gradient' => array(
											'type' => 'fields',
											'addrowclasses' => 'grid-col-12 disable box inside-box groups',
											'layout' => '%gradient_layout%',
										),
									),
								),
								'border' => array(
									'type' => 'fields',
									'addrowclasses' => 'grid-col-12 box inside-box groups',
									'layout' => '%border_layout%',
								),
								'instagram_feed' => array(
									'title' => esc_html__( 'Add Instagram Feed', 'vintwood' ),
									'addrowclasses' => 'checkbox grid-col-6',
									'type' => 'checkbox',
									'atts' => 'data-options="e:instagram_feed_shortcode;e:instagram_feed_full_width;"',
								),
								'instagram_feed_full_width' => array(
									'title' => esc_html__( 'Apply Full-Width Feed', 'vintwood' ),
									'addrowclasses' => 'disable checkbox grid-col-12',
									'type' => 'checkbox',
								),							
								'instagram_feed_shortcode' => array(
									'title' => esc_html__( 'Instagram Shortcode', 'vintwood' ),
									'addrowclasses' => 'disable grid-col-12 full_row',
									'type' => 'textarea',
									'atts' => 'rows="3"',
									'default' => '',
									'value' => '[instagram-feed cols=8 num=8 imagepadding=0 imagepaddingunit=px showheader=false showbutton=true showfollow=true]'
								),
								'spacings' => array(
									'title' => esc_html__( 'Add Spacings (px)', 'vintwood' ),
									'type' => 'margins',
									'addrowclasses' => 'new_row grid-col-12 two-inputs',
									'value' => array(
										'top' => array('placeholder' => esc_attr__( 'Top', 'vintwood' ), 'value' => '0'),
										'bottom' => array('placeholder' => esc_attr__( 'Bottom', 'vintwood' ), 'value' => '0'),
									),
								),	

							),
						),
					),
				),	
			)
		),	// end of sections

		'styling_options' => array(
			'type' => 'section',
			'title' => esc_html__('Styling options', 'vintwood' ),
			'icon' => array('fa', 'paint-brush'),
			'layout' => array(
				'theme_colors' => array(
					'type' => 'tab',
					'init' => 'open',
					'icon' => array('fa', 'calendar-plus-o'),
					'title' => esc_html__( 'Theme colors', 'vintwood' ),
					'layout' => array(
						'theme-background-color' => array(
							'title' => esc_html__( 'Background color', 'vintwood' ),
							'atts' => 'data-default-color="#f7f2e8"',
							'value' => '#f7f2e8',
							'addrowclasses' => 'grid-col-3',
							'type' => 'text',
						),
						'theme-first-color' => array(
							'title' => esc_html__( 'Main color', 'vintwood' ),
							'atts' => 'data-default-color="' . VINTWOOD_FIRST_COLOR . '"',
							'value' => VINTWOOD_FIRST_COLOR,
							'addrowclasses' => 'grid-col-3',
							'type' => 'text',
						),
						'theme-second-color' => array(
							'title' => esc_html__( 'Second color', 'vintwood' ),
							'atts' => 'data-default-color="' . VINTWOOD_SECOND_COLOR . '"',
							'value' => VINTWOOD_SECOND_COLOR,
							'addrowclasses' => 'grid-col-3',
							'type' => 'text',
						),
						'theme-helper-color' => array(
							'title' => esc_html__( 'Helper color', 'vintwood' ),
							'atts' => 'data-default-color="' . VINTWOOD_HELPER_COLOR . '"',
							'value' => VINTWOOD_HELPER_COLOR,
							'addrowclasses' => 'grid-col-3',
							'type' => 'text',
						),
					)
				)
			),
		),	// end of sections

		'layout_options' => array(
			'type' => 'section',
			'title' => esc_html__('Page layouts', 'vintwood' ),
			'icon' => array('fa', 'columns'),
			'layout'	=> array(
				'layout_options_homepage'	=> array(
					'type' => 'tab',
					'init'	=> 'open',
					'icon' => array('fa', 'arrow-circle-o-up'),
					'title' => esc_html__( 'Home', 'vintwood' ),
					'layout' => array(
						'home-slider-type' => array(
							'title' => esc_html__('Slider', 'vintwood' ),
							'type' => 'radio',
							'value' => array(
								'none' => 	array( esc_html__('None', 'vintwood' ), true, 'd:home-header-slider-options;d:slidersection-start;d:static_img_section' ),
								'img-slider'=>	array( esc_html__('Image Slider', 'vintwood' ), false, 'e:home-header-slider-options;d:slidersection-start;d:static_img_section' ),
								'video-slider' => 	array( esc_html__('Video Slider', 'vintwood' ), false, 'd:home-header-slider-options;e:slidersection-start;d:static_img_section' ),
								'stat-img-slider' => 	array( esc_html__('Static image', 'vintwood' ), false, 'd:home-header-slider-options;d:slidersection-start;e:static_img_section' ),
							),
						),
						'home-header-slider-options' => array(
							'title' => esc_html__( 'Slider shortcode', 'vintwood' ),
							'addrowclasses' => 'disable',
							'type' => 'text',
							'value' => '[rev_slider homepage]',
						),
						'slidersection-start' => array(
							'title' => esc_html__( 'Video Slider Setting', 'vintwood' ),
							'type' => 'fields',
							'addrowclasses' => 'disable groups',
							'layout' => array(
								'slider_switch' => array(
									'title' => esc_html__( 'Slider', 'vintwood' ),
									'addrowclasses' => 'grid-col-12 checkbox',
									'type' => 'checkbox',
									'atts' => 'data-options="e:slider_shortcode;"',
								),
								'slider_shortcode' => array(
									'title' => esc_html__( 'Slider shortcode', 'vintwood' ),
									'addrowclasses' => 'grid-col-12 disable box',
									'type' => 'text',
								),
								'set_video_header_height' => array(
									'title' => esc_html__( 'Set Video height', 'vintwood' ),
									'type' => 'checkbox',
									'addrowclasses' => 'grid-col-12 checkbox',
									'atts' => 'data-options="e:video_header_height"',
								),
								'video_header_height' => array(
									'title' => esc_html__( 'Video height', 'vintwood' ),
									'addrowclasses' => 'grid-col-12 disable box',
									'type' => 'number',
									'value' => '600',
								),
								'video_type' => array(
									'title' => esc_html__('Video type', 'vintwood' ),
									'addrowclasses' => 'grid-col-12',
									'type' => 'radio',
									'value' => array(
										'self_hosted' => 	array( esc_html__('Self-hosted', 'vintwood' ), true, 'e:sh_source;d:youtube_source;d:vimeo_source' ),
										'youtube'=>	array( esc_html__('Youtube clip', 'vintwood' ), false, 'd:sh_source;e:youtube_source;d:vimeo_source' ),
										'vimeo' => 	array( esc_html__('Vimeo clip', 'vintwood' ), false, 'd:sh_source;d:youtube_source;e:vimeo_source' ),
									),
								),
								'sh_source' => array(
									'title' => esc_html__( 'Add video', 'vintwood' ),
									'addrowclasses' => 'grid-col-12 box',
									'url-atts' => 'readonly',
									'type' => 'media',
								),
								'youtube_source' => array(
									'title' => esc_html__( 'Youtube video code', 'vintwood' ),
									'addrowclasses' => 'grid-col-12 disable box',
									'type' => 'text',
								),
								'vimeo_source' => array(
									'title' => esc_html__( 'Vimeo embed url', 'vintwood' ),
									'addrowclasses' => 'grid-col-12 disable box',
									'type' => 'text',
								),
								'color_overlay_type' => array(
									'title' => esc_html__( 'Overlay', 'vintwood' ),
									'addrowclasses' => 'grid-col-4',
									'type' => 'select',
									'source' => array(
										'none' => array( esc_html__( 'None', 'vintwood' ), 	true, 'd:overlay_color;d:slider_gradient_settings;d:color_overlay_opacity;'),
										'color' => array( esc_html__( 'Color', 'vintwood' ), 	false, 'e:overlay_color;d:slider_gradient_settings;e:color_overlay_opacity;'),
										'gradient' =>array( esc_html__( 'Gradient', 'vintwood' ), false, 'd:overlay_color;e:slider_gradient_settings;e:color_overlay_opacity;'),
									),
								),
								'overlay_color' => array(
									'title' => esc_html__( 'Color', 'vintwood' ),
									'addrowclasses' => 'grid-col-12',
									'atts' => 'data-default-color=""',
									'addrowclasses' => 'box',
									'type' => 'text',
								),
								'color_overlay_opacity' => array(
									'type' => 'number',
									'addrowclasses' => 'grid-col-4 box',
									'title' => esc_html__( 'Opacity', 'vintwood' ),
									'placeholder' => esc_attr__( 'In percents', 'vintwood' ),
									'value' => '40'
								),
								'slider_gradient_settings' => array(
									'title' => esc_html__( 'Gradient settings', 'vintwood' ),
									'addrowclasses' => 'grid-col-12',
									'type' => 'fields',
									'addrowclasses' => 'disable box groups',
									'layout' => array(
										'first_color' => array(
											'type' => 'text',
											'addrowclasses' => 'grid-col-6',
											'title' => esc_html__( 'From', 'vintwood' ),
											'atts' => 'data-default-color=""',
										),
										'second_color' => array(
											'type' => 'text',
											'addrowclasses' => 'grid-col-6',
											'title' => esc_html__( 'To', 'vintwood' ),
											'atts' => 'data-default-color=""',
										),
										'first_color_opacity' => array(
											'type' => 'number',
											'addrowclasses' => 'grid-col-6',
											'title' => esc_html__( 'From (Opacity %)', 'vintwood' ),
											'value' => '100',
										),
										'second_color_opacity' => array(
											'type' => 'number',
											'addrowclasses' => 'grid-col-6',
											'title' => esc_html__( 'To (Opacity %)', 'vintwood' ),
											'value' => '100',
										),
										'type' => array(
											'title' => esc_html__( 'Gradient type', 'vintwood' ),
											'addrowclasses' => 'grid-col-12',
											'type' => 'radio',
											'value' => array(
												'linear' => array( esc_html__( 'Linear', 'vintwood' ),  true, 'e:linear_settings;d:radial_settings' ),
												'radial' =>array( esc_html__( 'Radial', 'vintwood' ), false,  'd:linear_settings;e:radial_settings' ),
											),
										),
										'linear_settings' => array(
											'title' => esc_html__( 'Linear settings', 'vintwood'  ),
											'type' => 'fields',
											'addrowclasses' => 'disable',
											'layout' => array(
												'angle' => array(
													'type' => 'number',
													'title' => esc_html__( 'Angle', 'vintwood' ),
													'value' => '45',
												),
											)
										),
										'radial_settings' => array(
											'title' => esc_html__( 'Radial settings', 'vintwood'  ),
											'type' => 'fields',
											'addrowclasses' => 'disable',
											'layout' => array(
												'shape_settings' => array(
													'title' => esc_html__( 'Shape', 'vintwood' ),
													'type' => 'radio',
													'value' => array(
														'simple' => array( esc_html__( 'Simple', 'vintwood' ),  true, 'e:shape;d:size;d:size_keyword;' ),
														'extended' =>array( esc_html__( 'Extended', 'vintwood' ), false, 'd:shape;e:size;e:size_keyword;' ),
													),
												),
												'shape' => array(
													'title' => esc_html__( 'Gradient type', 'vintwood' ),
													'type' => 'radio',
													'value' => array(
														'ellipse' => array( esc_html__( 'Ellipse', 'vintwood' ),  true ),
														'circle' =>array( esc_html__( 'Circle', 'vintwood' ), false ),
													),
												),
												'size_keyword' => array(
													'type' => 'select',
													'title' => esc_html__( 'Size keyword', 'vintwood' ),
													'addrowclasses' => 'disable',
													'source' => array(
														'closest-side' => array(esc_html__( 'Closest side', 'vintwood' ), false),
														'farthest-side' => array(esc_html__( 'Farthest side', 'vintwood' ), false),
														'closest-corner' => array(esc_html__( 'Closest corner', 'vintwood' ), false),
														'farthest-corner' => array(esc_html__( 'Farthest corner', 'vintwood' ), true),
													),
												),
												'size' => array(
													'type' => 'text',
													'addrowclasses' => 'disable',
													'title' => esc_html__( 'Size', 'vintwood' ),
													'atts' => 'placeholder="'.esc_attr__( 'Two space separated percent values, for example (60% 55%)', 'vintwood' ).'"',
												),
											)
										)

									),
								),
								'use_pattern' => array(
									'title' => esc_html__( 'Use pattern image', 'vintwood' ),
									'type' => 'checkbox',
									'addrowclasses' => 'grid-col-12 checkbox',
									'atts' => 'data-options="e:pattern_image"',
								),
								'pattern_image' => array(
									'title' => esc_html__( 'Pattern image', 'vintwood' ),
									'addrowclasses' => 'grid-col-12 disable box',
									'url-atts' => 'readonly',
									'type' => 'media',
								),
							),
						),// end of video-section
						'static_img_section' => array(
							'title' => esc_html__( 'Static image Slider Setting', 'vintwood' ),
							'type' => 'fields',
							'addrowclasses' => 'groups',
							'layout' => array(
								'home_header_image_options' => array(
									'title' => esc_html__( 'Static image', 'vintwood' ),
									'type' => 'media',
									'url-atts' => 'readonly',
									'layout' => array(
										'is_high_dpi' => array(
											'title' => esc_html__( 'High-Resolution image', 'vintwood' ),
											'type' => 'checkbox',
											'addrowclasses' => 'checkbox',
										),
									),
								),
								'set_static_image_height' => array(
									'title' => esc_html__( 'Set Image height', 'vintwood' ),
									'addrowclasses' => 'grid-col-12 checkbox',
									'type' => 'checkbox',
									'atts' => 'data-options="e:static_image_height;"',
								),
								'static_image_height' => array(
									'title' => esc_html__( 'Static Image Height', 'vintwood' ),
									'addrowclasses' => 'grid-col-12 disable box',
									'type' => 'number',
									'default' => '600',
								),
								'static_customize_colors' => array(
									'title' => esc_html__( 'Customize colors', 'vintwood' ),
									'addrowclasses' => 'grid-col-12 checkbox',
									'type' => 'checkbox',
									'atts' => 'data-options="e:img_header_color_overlay_type;e:img_header_overlay_color;e:img_header_color_overlay_opacity;"',
								),
								'img_header_color_overlay_type'	=> array(
									'title'		=> esc_html__( 'Color overlay type', 'vintwood' ),
									'type'	=> 'select',
									'addrowclasses' => 'grid-col-12 box disable',
									'source'	=> array(
										'color' => array( esc_html__( 'Color', 'vintwood' ),  true, 'e:img_header_overlay_color;d:img_header_gradient_settings;' ),
										'gradient' => array( esc_html__( 'Gradient', 'vintwood' ), false, 'd:img_header_overlay_color;e:img_header_gradient_settings;' )
									),
								),
								'img_header_overlay_color'	=> array(
									'title'	=> esc_html__( 'Overlay color', 'vintwood' ),
									'atts' => 'data-default-color="' . VINTWOOD_FIRST_COLOR . '"',
									'value' => VINTWOOD_FIRST_COLOR,
									'addrowclasses' => 'box disable',
									'type'	=> 'text',
								),
								'img_header_gradient_settings' => array(
									'title' => esc_html__( 'Gradient Settings', 'vintwood' ),
									'type' => 'fields',
									'addrowclasses' => 'disable box groups',
									'layout' => array(
										'first_color' => array(
											'type' => 'text',
											'title' => esc_html__( 'From', 'vintwood' ),
											'atts' => 'data-default-color=""',
										),
										'second_color' => array(
											'type' => 'text',
											'title' => esc_html__( 'To', 'vintwood' ),
											'atts' => 'data-default-color=""',
										),
										'first_color_opacity' => array(
											'type' => 'number',
											'title' => esc_html__( 'From (Opacity %)', 'vintwood' ),
											'value' => '100',
										),
										'second_color_opacity' => array(
											'type' => 'number',
											'title' => esc_html__( 'To (Opacity %)', 'vintwood' ),
											'value' => '100',
										),
										'type' => array(
											'title' => esc_html__( 'Gradient type', 'vintwood' ),
											'type' => 'radio',
											'value' => array(
												'linear' => array( esc_html__( 'Linear', 'vintwood' ),  true, 'e:img_header_gradient_linear_settings;d:img_header_gradient_radial_settings' ),
												'radial' =>array( esc_html__( 'Radial', 'vintwood' ), false,  'd:img_header_gradient_linear_settings;e:img_header_gradient_radial_settings' ),
											),
										),
										'linear_settings' => array(
											'title' => esc_html__( 'Linear settings', 'vintwood'  ),
											'type' => 'fields',
											'addrowclasses' => 'disable',
											'layout' => array(
												'angle' => array(
													'type' => 'number',
													'title' => esc_html__( 'Angle', 'vintwood' ),
													'value' => '45',
												),
											)
										),
										'radial_settings' => array(
											'title' => esc_html__( 'Radial settings', 'vintwood'  ),
											'type' => 'fields',
											'addrowclasses' => 'disable',
											'layout' => array(
												'shape_settings' => array(
													'title' => esc_html__( 'Shape', 'vintwood' ),
													'type' => 'radio',
													'value' => array(
														'simple' => array( esc_html__( 'Simple', 'vintwood' ),  true, 'e:img_header_gradient_shape;d:img_header_gradient_size;d:img_header_gradient_size_keyword;' ),
														'extended' =>array( esc_html__( 'Extended', 'vintwood' ), false, 'd:img_header_gradient_shape;e:img_header_gradient_size;e:img_header_gradient_size_keyword;' ),
													),
												),
												'shape' => array(
													'title' => esc_html__( 'Gradient type', 'vintwood' ),
													'type' => 'radio',
													'value' => array(
														'ellipse' => array( esc_html__( 'Ellipse', 'vintwood' ),  true ),
														'circle' =>array( esc_html__( 'Circle', 'vintwood' ), false ),
													),
												),
												'img_header_gradient_size_keyword' => array(
													'type' => 'select',
													'title' => esc_html__( 'Size keyword', 'vintwood' ),
													'addrowclasses' => 'disable',
													'source' => array(
														'closest-side' => array(esc_html__( 'Closest side', 'vintwood' ), false),
														'farthest-side' => array(esc_html__( 'Farthest side', 'vintwood' ), false),
														'closest-corner' => array(esc_html__( 'Closest corner', 'vintwood' ), false),
														'farthest-corner' => array(esc_html__( 'Farthest corner', 'vintwood' ), true),
													),
												),
												'img_header_gradient_size' => array(
													'type' => 'text',
													'addrowclasses' => 'disable',
													'title' => esc_html__( 'Size', 'vintwood' ),
													'atts' => 'placeholder="'.esc_attr__( 'Two space separated percent values, for example (60% 55%)', 'vintwood' ).'"',
												),
											)
										)
									)
								),
								'img_header_color_overlay_opacity' => array(
									'type' => 'number',
									'title' => esc_html__( 'Opacity', 'vintwood' ),
									'addrowclasses' => 'box disable',
									'placeholder' => esc_attr__( 'In percents', 'vintwood' ),
									'value' => '40'
								),
								'img_header_use_pattern' => array(
									'title' => esc_html__( 'Add pattern', 'vintwood' ),
									'addrowclasses' => 'grid-col-12 checkbox',
									'type' => 'checkbox',
									'atts' => 'data-options="e:img_header_pattern_image;"',
								),
								'img_header_pattern_image' => array(
									'title' => esc_html__( 'Pattern image', 'vintwood' ),
									'type' => 'media',
									'addrowclasses' => 'grid-col-12 disable box',
									'url-atts' => 'readonly',
								),
								'img_header_parallaxify' => array(
									'title' => esc_html__( 'Parallaxify image', 'vintwood' ),
									'addrowclasses' => 'grid-col-12 checkbox',
									'type' => 'checkbox',
									'atts' => 'data-options="e:img_header_parallax_options;"',
								),
								'img_header_parallax_options' => array(
									'title' => esc_html__( 'Parallax options', 'vintwood' ),
									'type' => 'fields',
									'addrowclasses' => 'disable box groups',
									'layout' => array(
										'img_header_scalar-x' => array(
											'type' => 'number',
											'title' => esc_html__( 'x-axis parallax intensity', 'vintwood' ),
											'placeholder' => esc_attr__( 'Integer', 'vintwood' ),
											'value' => '2'
										),
										'img_header_scalar-y' => array(
											'type' => 'number',
											'title' => esc_html__( 'y-axis parallax intensity', 'vintwood' ),
											'placeholder' => esc_attr__( 'Integer', 'vintwood' ),
											'value' => '2'
										),
										'img_header_limit-x' => array(
											'type' => 'number',
											'title' => esc_html__( 'Maximum x-axis shift', 'vintwood' ),
											'placeholder' => esc_attr__( 'Integer', 'vintwood' ),
											'value' => '15'
										),
										'img_header_limit-y' => array(
											'type' => 'number',
											'title' => esc_html__( 'Maximum y-axis shift', 'vintwood' ),
											'placeholder' => esc_attr__( 'Integer', 'vintwood' ),
											'value' => '15'
										),
									),
								),
							),
						),// end of static img slider-section
						'home_sidebars' => array(
							'title' => esc_html__( 'Home Page Sidebar Layout', 'vintwood' ),
							'type' => 'fields',
							'addrowclasses' => 'box inside-box groups',
							'layout' => array(
								'layout' => array(
									'title' => esc_html__('Sidebar Position', 'vintwood' ),
									'type' => 'radio',
									'addrowclasses' => 'grid-col-12',
									'subtype' => 'images',
									'value' => array(
										'left' => 	array( esc_html__('Left', 'vintwood' ), false, 'e:sb1;d:sb2',	'/img/left.png' ),
										'right' => 	array( esc_html__('Right', 'vintwood' ), false, 'e:sb1;d:sb2', '/img/right.png' ),
										'both' => 	array( esc_html__('Double', 'vintwood' ), false, 'e:sb1;e:sb2', '/img/both.png' ),
										'none' => 	array( esc_html__('None', 'vintwood' ), false, 'd:sb1;d:sb2', '/img/none.png' )
									),
								),
								'sb1' => array(
									'title' => esc_html__('Select a sidebar', 'vintwood' ),
									'type' => 'select',
									'addrowclasses' => 'grid-col-12 disable box clear',
									'source' => 'sidebars',
								),
								'sb2' => array(
									'title' => esc_html__('Select right sidebar', 'vintwood' ),
									'type' => 'select',
									'addrowclasses' => 'grid-col-12 disable box',
									'source' => 'sidebars',
								),
							),
						),
					)
				),
				'layout_options_page' => array(
					'type' => 'tab',
					'icon' => array( 'fa', 'fa-book' ),
					'title' => esc_html__( 'Page', 'vintwood' ),
					'layout' => array(
						'page_sidebars' => array(
							'title' => esc_html__( 'Page Sidebar Layout', 'vintwood' ),
							'type' => 'fields',
							'addrowclasses' => 'box inside-box groups',
							'layout' => array(
								'layout' => array(
									'type' => 'radio',
									'subtype' => 'images',
									'value' => array(
										'left' => 	array( esc_html__('Left', 'vintwood' ), false, 'e:sb1;d:sb2',	'/img/left.png' ),
										'right' => 	array( esc_html__('Right', 'vintwood' ), false, 'e:sb1;d:sb2', '/img/right.png' ),
										'both' => 	array( esc_html__('Double', 'vintwood' ), false, 'e:sb1;e:sb2', '/img/both.png' ),
										'none' => 	array( esc_html__('None', 'vintwood' ), true, 'd:sb1;d:sb2', '/img/none.png' )
									),
								),
								'sb1' => array(
									'title' => esc_html__('Select a sidebar', 'vintwood' ),
									'type' => 'select',
									'addrowclasses' => 'disable box',
									'source' => 'sidebars',
								),
								'sb2' => array(
									'title' => esc_html__('Select right sidebar', 'vintwood' ),
									'type' => 'select',
									'addrowclasses' => 'disable box',
									'source' => 'sidebars',
								),
							),
						),
					)
				),
				'layout_options_blog' => array(
					'type' => 'tab',
					'icon' => array( 'fa', 'fa-book' ),
					'title' => esc_html__( 'Blog', 'vintwood' ),
					'layout' => array(
						'blog_sidebars' => array(
							'title' => esc_html__( 'Blog Sidebars Settings', 'vintwood' ),
							'type' => 'fields',
							'addrowclasses' => 'box inside-box groups grid-col-12',
							'layout' => array(
								'layout' => array(
									'title' => esc_html__('Sidebar Position', 'vintwood' ),
									'type' => 'radio',
									'subtype' => 'images',
									'addrowclasses' => 'grid-col-4',
									'value' => array(
										'left' => 	array( esc_html__('Left', 'vintwood' ), false, 'e:sb1;d:sb2',	'/img/left.png' ),
										'right' => 	array( esc_html__('Right', 'vintwood' ), false, 'e:sb1;d:sb2', '/img/right.png' ),
										'both' => 	array( esc_html__('Double', 'vintwood' ), false, 'e:sb1;e:sb2', '/img/both.png' ),
										'none' => 	array( esc_html__('None', 'vintwood' ), true, 'd:sb1;d:sb2', '/img/none.png' )
									),
								),
								'sb1' => array(
									'title' => esc_html__('Select a sidebar', 'vintwood' ),
									'type' => 'select',
									'addrowclasses' => 'disable grid-col-4',
									'source' => 'sidebars',
								),
								'sb2' => array(
									'title' => esc_html__('Select right sidebar', 'vintwood' ),
									'type' => 'select',
									'addrowclasses' => 'disable grid-col-4',
									'source' => 'sidebars',
								),
							),
						),
						'blog_content_align' => array(
							'title' => 'Content Alignment',
							'addrowclasses' => 'grid-col-4',
							'type' => 'radio',
							'value' => array(
								'left' => array( esc_html__( 'Left', 'vintwood' ), true),
								'center' => array( esc_html__( 'Center', 'vintwood' ), false),
								'right' => array( esc_html__( 'Right', 'vintwood' ), false),
							),
						),
						'blog_button_align' => array(
							'title' => 'Button Alignment',
							'type' => 'radio',
							'addrowclasses' => 'grid-col-4',
							'value' => array(
								'left' => array( esc_html__( 'Left', 'vintwood' ), false),
								'center' => array( esc_html__( 'Center', 'vintwood' ), false),
								'right' => array( esc_html__( 'Right', 'vintwood' ), true),
							),
						),						
						'blog_button_name' => array(
							'title' => esc_html__( 'Button Name', 'vintwood' ),
							'type' => 'text',
							'value' => 'Read More',
							'addrowclasses' => 'grid-col-6',	
						),
						'def_blog_chars_count' => array(
							'title' => esc_html__( 'Text Length', 'vintwood' ),
							'type' => 'text',
							'addrowclasses' => 'grid-col-6',
						),						
						'def_blogtype' => array(
							'title'		=> esc_html__( 'Blog Layout', 'vintwood' ),
							'desc'		=> esc_html__( 'Default Blog Layout', 'vintwood' ),
							'type'		=> 'radio',
							'subtype' => 'images',
							'addrowclasses' => 'grid-col-6',
							'value' => array(
								'1' => array( esc_html__('Large', 'vintwood' ), true, '', '/img/large.png'),
								'medium' => array( esc_html__('Medium', 'vintwood' ), false, '', '/img/medium.png'),
								'small' => array( esc_html__('Small', 'vintwood' ), false, '', '/img/small.png'),
								'2' => array( esc_html__('2 Cols', 'vintwood' ), false, '', '/img/pinterest_2_columns.png'),
								'3' => array( esc_html__('3 Cols', 'vintwood' ), false, '', '/img/pinterest_3_columns.png'),
								'4' => array( esc_html__('4 Cols', 'vintwood' ), false, '', '/img/pinterest_4_columns.png'),
							),
						),
						'blog_slug' => array(
							'title' => esc_html__( 'Rename Blog', 'vintwood' ),
							'addrowclasses' => 'requirement grid-col-6',
							'type' 	=> 'text',
							'value'	=> 'Blog'
						),
						'crop_related_items' => array(
							'title' => esc_html__( 'Crop Related Items of Single Posts', 'vintwood' ),
							'addrowclasses' => 'new_row checkbox grid-col-12',
							'type' => 'checkbox',
						),
						'def_post_hide_meta_related_items'	=> array(
							'title'		=> esc_html__( 'Hide meta (Related Items)', 'vintwood' ),
							'type'		=> 'select',
							'atts'		=> 'multiple',
							'addrowclasses' => 'grid-col-12',
							'source'		=> array(
								'' 				=> array( esc_html__( 'None', 'vintwood' ), false),
								'title' 		=> array( esc_html__( 'Title', 'vintwood' ), false),
								'cats' 			=> array( esc_html__( 'Categories', 'vintwood' ), false),
								'tags' 			=> array( esc_html__( 'Tags', 'vintwood' ), false),
								'author' 		=> array( esc_html__( 'Author', 'vintwood' ), false),
								'likes' 		=> array( esc_html__( 'Likes', 'vintwood' ), false),
								'date' 			=> array( esc_html__( 'Date', 'vintwood' ), false),
								'comments' 		=> array( esc_html__( 'Comments', 'vintwood' ), false),
								'read_more' 	=> array( esc_html__( 'Read More', 'vintwood' ), false),
								'social' 		=> array( esc_html__( 'Social Icons', 'vintwood' ), false),
								'excerpt' 		=> array( esc_html__( 'Excerpt', 'vintwood' ), false),
							)
						),
						'blog_aspect_ratio' => array(
							'title' => esc_html__( 'Keep Aspect Ratio', 'vintwood' ),
							'type' => 'checkbox',
							'addrowclasses' => 'checkbox grid-col-12',
						),						
					)
				),
				'layout_options_portfolio' => array(
					'type' => 'tab',
					'icon' => array( 'fa', 'fa-book' ),
					'title' => esc_html__( 'Portfolio', 'vintwood' ),
					'layout' => array(
						'def_layout_portfolio' => array(
							'title'		=> esc_html__( 'Portfolio Layout', 'vintwood' ),
							'type'		=> 'radio',
							'subtype' => 'images',
							'tooltip' => array(
								'title' => esc_html__( 'Portfolio Layout', 'vintwood' ),
								'content' => esc_html__( 'This option is applied to portfolio archive pages only', 'vintwood' ),
							),
							'value' => array(
								'1' => array( esc_html__('Large', 'vintwood' ), false, '', '/img/large.png'),
								'2' => array( esc_html__('2 Cols', 'vintwood' ), false, '', '/img/pinterest_2_columns.png'),
								'3' => array( esc_html__('3 Cols', 'vintwood' ), false, '', '/img/pinterest_3_columns.png'),
								'4' => array( esc_html__('4 Cols', 'vintwood' ), true, '', '/img/pinterest_4_columns.png'),
							),
						),
						'portfolio_mode' => array(
							'title' => esc_html__( 'Display as', 'vintwood' ),
							'type' => 'select',
							'source' => array(
								'grid' => array('Grid', true), // Title, isselected, data-options
								'grid_with_filter' => array('Grid with filter', false),
								'carousel' => array('Carousel', false)
							),
						),
						'def_cws_portfolio_data_to_show'	=> array(
							'title'		=> esc_html__( 'Show Meta Data', 'vintwood' ),
							'type'		=> 'select',
							'atts'		=> 'multiple',
							'source'		=> array(
									'title'		=> array( esc_html__( 'Title', 'vintwood' ), true ),
									'excerpt'	=> array( esc_html__( 'Excerpt', 'vintwood' ), true ),
									'cats'		=> array( esc_html__( 'Categories', 'vintwood' ), false )
							)
						),
						'portfolio_mode' => array(
							'title' => esc_html__( 'Display as', 'vintwood' ),
							'type' => 'select',
							'source' => array(
								'grid' => array('Grid', true), // Title, isselected, data-options
								'filter_with_ajax' => array('Grid with filter(Ajax)', false),
								'filter' => array('Grid with filter', false),
								'carousel' => array('Carousel', false)
							),
						),


						'portfolio_pagination_style' => array(
							'title' => esc_html__( 'Pagination style', 'vintwood' ),
							'type' => 'radio',
							'value' => array(
								'paged' => array( 'Paged', true ),
								'load_more' => array( 'Load More', false )
							),
						),


						'portfolio_slug' => array(
							'title' => esc_html__( 'Portfolio slug', 'vintwood' ),
							'type' => 'text',
							'value' => 'portfolio',
						),
					)
				),
				'layout_options_staff' => array(
					'type' => 'tab',
					'icon' => array( 'fa', 'fa-book' ),
					'title' => esc_html__( 'Staff', 'vintwood' ),
					'layout' => array(
						'def_cws_staff_layout' => array(
							'title'		=> esc_html__( 'Staff Layout', 'vintwood' ),
							'type'		=> 'radio',
							'subtype' => 'images',
							'tooltip' => array(
								'title' => esc_html__( 'Staff Layout', 'vintwood' ),
								'content' => esc_html__( 'This option is applied to Staff archive pages only', 'vintwood' ),
							),
							'value' => array(
								'1' => array( esc_html__('Large', 'vintwood' ), false, '', '/img/large.png'),
								'2' => array( esc_html__('2 Cols', 'vintwood' ), false, '', '/img/pinterest_2_columns.png'),
								'3' => array( esc_html__('3 Cols', 'vintwood' ), false, '', '/img/pinterest_3_columns.png'),
								'4' => array( esc_html__('4 Cols', 'vintwood' ), true, '', '/img/pinterest_4_columns.png'),
							),
						),
						'def_cws_staff_data_to_hide'	=> array(
							'title'		=> esc_html__( 'Hide Meta Data', 'vintwood' ),
							'type'		=> 'select',
							'atts'		=> 'multiple',
							'source'		=> array(
								'deps'			=> array( esc_html__( 'Departments', 'vintwood' ), true ),
								'poss'			=> array( esc_html__( 'Positions', 'vintwood' ), false ),
								'excerpt'		=> array( esc_html__( 'Excerpt', 'vintwood' ), true ),
								'experience'	=> array( esc_html__( 'Experience', 'vintwood' ), true ),
								'email'			=> array( esc_html__( 'Email', 'vintwood' ), true ),
								'biography'		=> array( esc_html__( 'Biography', 'vintwood' ), true ),
								'link_button'	 => array( esc_html__( 'Link Button', 'vintwood' ), true ),
								'socials'		=> array( esc_html__( 'Social Links', 'vintwood' ), false )
							)
						),
						'staff_slug' => array(
							'title' => esc_html__( 'Staff slug', 'vintwood' ),
							'type' => 'text',
							'value' => 'staff',
						),

					)
				),				
// Uncomment this line to activate Classes
/*				'layout_options_classes' => array(
					'type' => 'tab',
					'icon' => array( 'fa', 'fa-book' ),
					'title' => esc_html__( 'Classes', 'vintwood' ),
					'layout' => array(
						'def_cws_classes_layout' => array(
							'title'		=> esc_html__( 'Classes Layout', 'vintwood' ),
							'type'		=> 'radio',
							'subtype' => 'images',
							'value' => array(
								'1' => array( esc_html__('Large', 'vintwood' ), false, '', '/img/large.png'),
								'2' => array( esc_html__('2 Cols', 'vintwood' ), false, '', '/img/pinterest_2_columns.png'),
								'3' => array( esc_html__('3 Cols', 'vintwood' ), false, '', '/img/pinterest_3_columns.png'),
								'4' => array( esc_html__('4 Cols', 'vintwood' ), true, '', '/img/pinterest_4_columns.png'),
							),
						),
						'def_cws_classes_data_to_hide'	=> array(
							'title'		=> esc_html__( 'Hide Meta Data', 'vintwood' ),
							'type'		=> 'select',
							'atts'		=> 'multiple',
							'source'		=> array(
								'title'			=> array( esc_html__( 'Title', 'vintwood' ), false ),
								'excerpt'			=> array( esc_html__( 'Excerpt', 'vintwood' ), false ),
								'cats'		=> array( esc_html__( 'Categories', 'vintwood' ), false ),
								'teach'	=> array( esc_html__( 'Teacher', 'vintwood' ), false ),
								'working_days'			=> array( esc_html__( 'Working Days', 'vintwood' ), false ),
								'time_events'		=> array( esc_html__( 'Time Events', 'vintwood' ), false ),
								'venue_events'	 => array( esc_html__( 'Venue Events', 'vintwood' ), false ),
								'read_more'		=> array( esc_html__( 'Read More Button', 'vintwood' ), false )
							)
						),					
						'def_cws_classes_data_to_hide_related'	=> array(
							'title'		=> esc_html__( 'Related Items Hide Meta Data', 'vintwood' ),
							'type'		=> 'select',
							'atts'		=> 'multiple',
							'source'		=> array(
								'title'			=> array( esc_html__( 'Title', 'vintwood' ), false ),
								'excerpt'			=> array( esc_html__( 'Excerpt', 'vintwood' ), false ),
								'cats'		=> array( esc_html__( 'Categories', 'vintwood' ), true ),
								'teach'	=> array( esc_html__( 'Teacher', 'vintwood' ), true ),
								'working_days'			=> array( esc_html__( 'Working Days', 'vintwood' ), true ),
								'time_events'		=> array( esc_html__( 'Time Events', 'vintwood' ), true ),
								'venue_events'	 => array( esc_html__( 'Venue Events', 'vintwood' ), true ),
								'read_more'		=> array( esc_html__( 'Read More Button', 'vintwood' ), true )
							)
						),
						'classes_slug' => array(
							'title' => esc_html__( 'Classes slug', 'vintwood' ),
							'type' => 'text',
							'value' => 'classes',
						),

					)
				),*/
				'layout_options_testimonials' => array(
					'type' => 'tab',
					'icon' => array( 'fa', 'fa-book' ),
					'title' => esc_html__( 'Testimonials', 'vintwood' ),
					'layout' => array(
						'def_layout_testimonials' => array(
							'title'		=> esc_html__( 'Testimonials Layout', 'vintwood' ),
							'type'		=> 'radio',
							'subtype' => 'images',
							'tooltip' => array(
								'title' => esc_html__( 'Testimonials Layout', 'vintwood' ),
								'content' => esc_html__( 'This option is applied to testimonials archive pages only', 'vintwood' ),
							),
							'value' => array(
								'1' => array( esc_html__('Large', 'vintwood' ), true, '', '/img/large.png'),
								'2' => array( esc_html__('2 Cols', 'vintwood' ), false, '', '/img/pinterest_2_columns.png'),
							),
						),
						'testimonials_slug' => array(
							'title' => esc_html__( 'Testimonials slug', 'vintwood' ),
							'type' => 'text',
							'value' => 'testimonials',
						),
					)
				),
				'layout_options_sidebar_generator' => array(
					'type' => 'tab',
					'customizer' 	=> array( 'show' => false ),
					'icon' => array('fa', 'calendar-plus-o'),
					'title' => esc_html__( 'Sidebars', 'vintwood' ),
					'layout' => array(
						'sidebars' => array(
							'type' => 'group',
							'addrowclasses' => 'group single_field requirement',
							'title' => esc_html__('Sidebar generator', 'vintwood' ),
							'button_title' => esc_html__('Add new sidebar', 'vintwood' ),
							'value' => array(
									array('title' => 'Footer'),
									array('title' => 'Blog Right'),
									array('title' => 'Blog Left'),
									array('title' => 'Page Right'),
									array('title' => 'Page Left'),
									array('title' => 'Side Panel'),
							),
							'layout' => array(
								'title' => array(
									'type' => 'text',
									'value' => 'New Sidebar',
									'atts' => 'data-role="title"',
									'verification' => array (
										'length' => array( array('!0'), esc_html__('Title should not be empty', 'vintwood' )),
									),
									'title' => esc_html__('Sidebar', 'vintwood' ),
								)
							)
						),
						'sticky_sidebars' => array(
							'title' => esc_html__( 'Sticky sidebars', 'vintwood' ),
							'addrowclasses' => 'checkbox alt',
							'atts' => 'checked',
							'type' => 'checkbox',
						)
					)
				),
			)
		),	// end of sections
		'typography_options' => array(
			'type' => 'section',
			'title' => esc_html__('Typography', 'vintwood' ),
			'icon' => array('fa', 'font'),
			'layout' => array(
				'menu_font_options' => array(
					'type' => 'tab',
					'init' => 'open',
					'icon' => array('fa', 'arrow-circle-o-up'),
					'title' => esc_html__( 'Menu', 'vintwood' ),
					'layout' => array(
						'menu-font' => array(
							'title' => esc_html__('Menu Font', 'vintwood' ),
							'type' => 'font',
							'font-color' => true,
							'font-size' => true,
							'font-sub' => true,
							'line-height' => true,
							'value' => array(
								'font-size' => '30px',
								'line-height' => 'initial',
								'color' => '#224a49',
								'font-family' => 'Barlow Condensed',
								'font-weight' => array( 'regular', '700' ),
								'font-sub' => array('latin'),
							)
						)
					)
				),
				'header_font_options' => array(
					'type' => 'tab',
					'icon' => array('fa', 'font'),
					'title' => esc_html__( 'Header', 'vintwood' ),
					'layout' => array(
						'header-font' => array(
							'title' => esc_html__('Header\'s Font', 'vintwood' ),
							'type' => 'font',
							'font-color' => true,
							'font-size' => true,
							'font-sub' => true,
							'line-height' => true,
							'value' => array(
								'font-size' => '180px',
								'line-height' => 'initial',
								'color' => '#224a49',
								'font-family' => 'Barlow Condensed',
								'font-weight' => array( 'regular', '700' ),
								'font-sub' => array('latin'),
							),
						)
					)
				),
				'body_font_options' => array(
					'type' => 'tab',
					'icon' => array('fa', 'arrow-circle-o-up'),
					'title' => esc_html__( 'Body', 'vintwood' ),
					'layout' => array(
						'body-font' => array(
							'title' => esc_html__('Body Font', 'vintwood' ),
							'type' => 'font',
							'font-color' => true,
							'font-size' => true,
							'font-sub' => true,
							'line-height' => true,
							'value' => array(
								'font-size' => '18px',
								'line-height' => '27px',
								'color' => '#333333',
								'font-family' => 'Merriweather',
								'font-weight' => array( '300', 'regular', '700' ),
								'font-sub' => array('latin'),
							)
						)
					)
				),
				'helper_font_options' => array(
					'type' => 'tab',
					'icon' => array('fa', 'arrow-circle-o-up'),
					'title' => esc_html__( 'Helper', 'vintwood' ),
					'layout' => array(
						'helper-font' => array(
							'title' => esc_html__('Helper Font', 'vintwood' ),
							'type' => 'font',
							'font-color' => true,
							'font-size' => true,
							'font-sub' => true,
							'line-height' => true,
							'value' => array(
								'font-size' => '45px',
								'line-height' => 'initial',
								'color' => '#eae5de',
								'font-family' => 'Satisfy',
								'font-weight' => array( 'regular' ),
								'font-sub' => array('latin'),
							)
						)
					)
				),
			)
		), // end of sections
		'help_options' => array(
			'type' => 'section',
			'title' => esc_html__('Maintenance & Help', 'vintwood' ),
			'icon' => array('fa', 'life-ring'),
			'layout' => array(
				'maintenance' => array(
					'type' => 'tab',
					'init' => 'open',
					'icon' => array('fa', 'calendar-plus-o'),
					'title' => esc_html__( 'Maintenance', 'vintwood' ),
					'layout' => array(
						'show_loader' => array(
							'title' => esc_html__( 'ShowLoader', 'vintwood' ),
							'addrowclasses' => 'grid-col-12 checkbox alt',
							'type' => 'checkbox',
							'atts' => 'checked data-options="e:loader_logo;e:overlay_loader_color"',
						),
						'loader_logo' => array(
							'title' => esc_html__( 'Loader logo (Square)', 'vintwood' ),
							'type' => 'media',
							'url-atts' => 'readonly',
							'addrowclasses' => 'grid-col-12 disable',
							'layout' => array(
								'logo_is_high_dpi' => array(
									'title' => esc_html__( 'High-Resolution logo', 'vintwood' ),
									'addrowclasses' => 'checkbox',
									'type' => 'checkbox',
								),
							),
						),
						'overlay_loader_color' => array(
							'title' => esc_html__( 'Loader Color', 'vintwood' ),
							'atts' => 'data-default-color="' . VINTWOOD_FIRST_COLOR . '"',
							'value' => VINTWOOD_FIRST_COLOR,
							'addrowclasses' => 'disable grid-col-12',
							'type' => 'text',
						),
						'breadcrumbs' => array(
							'title' => esc_html__( 'Show breadcrumbs', 'vintwood' ),
							'addrowclasses' => 'checkbox alt',
							'atts' => 'checked',
							'type' => 'checkbox',
						),
						'blog_author' => array(
							'title' => esc_html__( 'Show post author', 'vintwood' ),
							'addrowclasses' => 'checkbox alt',
							'atts' => 'checked',
							'type' => 'checkbox',
						),
						'_theme_purchase_code' => array(
							'title' => esc_html__( 'Theme purchase code', 'vintwood' ),
							'tooltip' => array(
								'title' => esc_html__( 'Item Purchase Code', 'vintwood' ),
								'content' => esc_html__( 'Fill in this field with your Item Purchase Code in order to get the demo content and further theme updates.<br/> Please note, this code is applied to the theme only, it will not register Revolution Slider or any other plugins.', 'vintwood' ),
							),
							'type' 	=> 'text',
							'value'	=> '',
							'customizer' 	=> array( 'show' => false )
						),
					)
				),
		    'animation' => array(
			     'type' => 'tab',
			     'icon' => array('fa', 'arrow-circle-o-up'),
			     'title' => esc_html__( 'Animation', 'vintwood' ),
			     'layout' => array(
					'animation_curve_menu'	=> array(
						'title'	=> esc_html__( 'Animation (Menu Anchors)', 'vintwood' ),
						'type'	=> 'select',
						'addrowclasses' => 'grid-col-4',
						'source'	=> array(
							'linear' => array( esc_html__( '1. linear', 'vintwood' ), false ),
							'swing' => array( esc_html__( '2. swing', 'vintwood' ), false ),
							'easeInQuad' => array( esc_html__( '3. easeInQuad', 'vintwood' ), false ),
							'easeOutQuad' => array( esc_html__( '4. easeOutQuad', 'vintwood' ), false ),
							'easeInOutQuad' => array( esc_html__( '5. easeInOutQuad', 'vintwood' ), false ),
							'easeInCubic' => array( esc_html__( '6. easeInCubic', 'vintwood' ), false ),
							'easeOutCubic' => array( esc_html__( '7. easeOutCubic', 'vintwood' ), true ),
							'easeInOutCubic' => array( esc_html__( '8. easeInOutCubic', 'vintwood' ), false ),
							'easeInQuart' => array( esc_html__( '9. easeInQuart', 'vintwood' ), false ),
							'easeOutQuart' => array( esc_html__( '10. easeOutQuart', 'vintwood' ), false ),
							'easeInOutQuart' => array( esc_html__( '11. easeInOutQuart', 'vintwood' ), false ),
							'easeInQuint' => array( esc_html__( '12. easeInQuint', 'vintwood' ), false ),
							'easeOutQuint' => array( esc_html__( '13. easeOutQuint', 'vintwood' ), false ),
							'easeInOutQuint' => array( esc_html__( '14. easeInOutQuint', 'vintwood' ), false ),
							'easeInSine' => array( esc_html__( '15. easeInSine', 'vintwood' ), false ),
							'easeOutSine' => array( esc_html__( '16. easeOutSine', 'vintwood' ), false ),
							'easeInOutSine' => array( esc_html__( '17. easeInOutSine', 'vintwood' ), false ),
							'easeInExpo' => array( esc_html__( '18. easeInExpo', 'vintwood' ), false ),
							'easeOutExpo' => array( esc_html__( '19. easeOutExpo', 'vintwood' ), false ),
							'easeInOutExpo' => array( esc_html__( '20. easeInOutExpo', 'vintwood' ), false ),
							'easeInCirc' => array( esc_html__( '21. easeInCirc', 'vintwood' ), false ),
							'easeOutCirc' => array( esc_html__( '22. easeOutCirc', 'vintwood' ), false ),
							'easeInOutCirc' => array( esc_html__( '23. easeInOutCirc', 'vintwood' ), false ),
							'easeInElastic' => array( esc_html__( '24. easeInElastic', 'vintwood' ), false ),
							'easeOutElastic' => array( esc_html__( '25. easeOutElastic', 'vintwood' ), false ),
							'easeInOutElastic' => array( esc_html__( '26. easeInOutElastic', 'vintwood' ), false ),
							'easeInBack' => array( esc_html__( '27. easeInBack', 'vintwood' ), false ),
							'easeOutBack' => array( esc_html__( '28. easeOutBack', 'vintwood' ), false ),
							'easeInOutBack' => array( esc_html__( '29. easeInOutBack', 'vintwood' ), false ),
							'easeInBounce' => array( esc_html__( '30. easeInBounce', 'vintwood' ), false ),
							'easeOutBounce' => array( esc_html__( '31. easeOutBounce', 'vintwood' ), false ),
							'easeInOutBounce' => array( esc_html__( '32. easeInOutBounce', 'vintwood' ), false ),
						),
					),
					'animation_curve_scrolltop'	=> array(
						'title'	=> esc_html__( 'Animation (ScrollTop)', 'vintwood' ),
						'type'	=> 'select',
						'addrowclasses' => 'grid-col-4',
						'source'	=> array(
							'linear' => array( esc_html__( '1. linear', 'vintwood' ), false ),
							'swing' => array( esc_html__( '2. swing', 'vintwood' ), false ),
							'easeInQuad' => array( esc_html__( '3. easeInQuad', 'vintwood' ), false ),
							'easeOutQuad' => array( esc_html__( '4. easeOutQuad', 'vintwood' ), false ),
							'easeInOutQuad' => array( esc_html__( '5. easeInOutQuad', 'vintwood' ), true ),
							'easeInCubic' => array( esc_html__( '6. easeInCubic', 'vintwood' ), false ),
							'easeOutCubic' => array( esc_html__( '7. easeOutCubic', 'vintwood' ), false ),
							'easeInOutCubic' => array( esc_html__( '8. easeInOutCubic', 'vintwood' ), false ),
							'easeInQuart' => array( esc_html__( '9. easeInQuart', 'vintwood' ), false ),
							'easeOutQuart' => array( esc_html__( '10. easeOutQuart', 'vintwood' ), false ),
							'easeInOutQuart' => array( esc_html__( '11. easeInOutQuart', 'vintwood' ), false ),
							'easeInQuint' => array( esc_html__( '12. easeInQuint', 'vintwood' ), false ),
							'easeOutQuint' => array( esc_html__( '13. easeOutQuint', 'vintwood' ), false ),
							'easeInOutQuint' => array( esc_html__( '14. easeInOutQuint', 'vintwood' ), false ),
							'easeInSine' => array( esc_html__( '15. easeInSine', 'vintwood' ), false ),
							'easeOutSine' => array( esc_html__( '16. easeOutSine', 'vintwood' ), false ),
							'easeInOutSine' => array( esc_html__( '17. easeInOutSine', 'vintwood' ), false ),
							'easeInExpo' => array( esc_html__( '18. easeInExpo', 'vintwood' ), false ),
							'easeOutExpo' => array( esc_html__( '19. easeOutExpo', 'vintwood' ), false ),
							'easeInOutExpo' => array( esc_html__( '20. easeInOutExpo', 'vintwood' ), false ),
							'easeInCirc' => array( esc_html__( '21. easeInCirc', 'vintwood' ), false ),
							'easeOutCirc' => array( esc_html__( '22. easeOutCirc', 'vintwood' ), false ),
							'easeInOutCirc' => array( esc_html__( '23. easeInOutCirc', 'vintwood' ), false ),
							'easeInElastic' => array( esc_html__( '24. easeInElastic', 'vintwood' ), false ),
							'easeOutElastic' => array( esc_html__( '25. easeOutElastic', 'vintwood' ), false ),
							'easeInOutElastic' => array( esc_html__( '26. easeInOutElastic', 'vintwood' ), false ),
							'easeInBack' => array( esc_html__( '27. easeInBack', 'vintwood' ), false ),
							'easeOutBack' => array( esc_html__( '28. easeOutBack', 'vintwood' ), false ),
							'easeInOutBack' => array( esc_html__( '29. easeInOutBack', 'vintwood' ), false ),
							'easeInBounce' => array( esc_html__( '30. easeInBounce', 'vintwood' ), false ),
							'easeOutBounce' => array( esc_html__( '31. easeOutBounce', 'vintwood' ), false ),
							'easeInOutBounce' => array( esc_html__( '32. easeInOutBounce', 'vintwood' ), false ),
						),
					),
					'animation_curve_speed' => array(
						'type' => 'number',
						'title' => esc_html__( 'Animation Speed', 'vintwood' ),
						'placeholder' => esc_attr__( 'In milliseconds', 'vintwood' ),
						'value' => '300',
						'addrowclasses' => 'grid-col-4',
					),
					'curves' => array(
						'type' => 'info',
						'addrowclasses' => 'grid-col-12',
						'value' => '<img src="'. get_template_directory_uri() . '/img/easing.png" />',
						'title' => esc_html__('Easing curves', 'vintwood' )
					),
			    )
		    ),
				'help' => array(
					'type' => 'tab',
					'icon' => array('fa', 'calendar-plus-o'),
					'title' => esc_html__( 'Help', 'vintwood' ),
					'layout' => array(
						'help' => array(
								 'title' 			=> esc_html__( 'Help', 'vintwood' ),
								 'type' 			=> 'info',
								 'subtype'		=> 'custom',
								 'value' 			=> '<a class="cwsfw_info_button" href="http://vintwood.cwsthemes.com/manual" target="_blank"><i class="fa fa-life-ring"></i>&nbsp;&nbsp;' . esc_html__( 'Online Tutorial', 'vintwood' ) . '</a>&nbsp;&nbsp;<a class="cwsfw_info_button" href="https://www.youtube.com/user/cwsvideotuts/playlists" target="_blank"><i class="fa fa-video-camera"></i>&nbsp;&nbsp;' . esc_html__( 'Video Tutorial', 'vintwood' ) . '</a>',
							),
					)
				),
				'crop' => array(
					'type' => 'tab',
					'icon' => array('fa', 'calendar-plus-o'),
					'title' => esc_html__( 'Crop Images', 'vintwood' ),
					'layout' => array(
						'crop_x' => array(
							'title' => esc_html__( 'Crop X', 'vintwood' ),
							'type' => 'radio',
							'addrowclasses' => 'grid-col-3',
							'value' => array(
								'left' => array( esc_html__( 'Left', 'vintwood' ),  false, '' ),
								'center' => array( esc_html__( 'Center', 'vintwood' ),  true, '' ),
								'right' => array( esc_html__( 'Right', 'vintwood' ),  false, '' ),
							),
						),
						'crop_y' => array(
							'title' => esc_html__( 'Crop Y', 'vintwood' ),
							'type' => 'radio',
							'addrowclasses' => 'grid-col-3',
							'value' => array(
								'top' => array( esc_html__( 'Top', 'vintwood' ),  false, '' ),
								'center' => array( esc_html__( 'Center', 'vintwood' ),  true, '' ),
								'bottom' => array( esc_html__( 'Bottom', 'vintwood' ),  false, '' ),
							),
						),

					)
				),
			)
		),
		
		'social_options' => array(
			'type' => 'section',
			'title' => esc_html__('Social Networks', 'vintwood' ),
			'icon' => array('fa', 'share-alt'),
			'layout' => array(
				'social_cont'	=> array(
					'type' => 'tab',
					'init'	=> 'open',
					'icon' => array('fa', 'arrow-circle-o-up'),
					'title' => esc_html__( 'Social Networks', 'vintwood' ),
					'layout' => array(

						'social' => array(
							'type' => 'fields',
							'addrowclasses' => 'inside-box groups grid-col-12 box',
							'layout' => array(
								'location'	=> array(
									'title'		=> esc_html__( 'Social Icons Location', 'vintwood' ),
									'type'	=> 'select',
									'atts' => 'multiple',
									'addrowclasses' => 'grid-col-12 box',
									'source'	=> array(
										'top_bar' => array( esc_html__( 'Top Bar', 'vintwood' ), false, ''),
										'menu' => array( esc_html__( 'Menu', 'vintwood' ), false, ''),
										'copyrights' => array( esc_html__( 'Copyrights area', 'vintwood' ), false, ''),
										'side_panel' => array( esc_html__( 'Side panel', 'vintwood' ), false, ''),
									),
								),
								'icons' => array(
									'type' => 'group',
									'addrowclasses' => 'group sortable grid-col-12 box',
									'title' => esc_html__('Social Networks', 'vintwood' ),
									'button_title' => esc_html__('Add new social network', 'vintwood' ),
									'button_icon' => 'fa fa-plus',
									'layout' => array(
										'title' => array(
											'type' => 'text',
											'atts' => 'data-role="title"',
											'addrowclasses' => 'grid-col-4',
											'title' => esc_html__('Social account title', 'vintwood' ),
										),
										'icon' => array(
											'type' => 'select',
											'addrowclasses' => 'fai grid-col-4',
											'source' => 'fa',
											'title' => esc_html__('Icon for this social contact', 'vintwood' )
										),										
										'url' => array(
											'type' => 'text',
											'addrowclasses' => 'grid-col-4',
											'title' => esc_html__('Url to your account', 'vintwood' ),
										),
										'color'	=> array(
											'title'	=> esc_html__( 'Icon color', 'vintwood' ),
											'addrowclasses' => 'grid-col-3',
											'atts' => 'data-default-color="#ffffff"',
											'value' => '#ffffff',
											'type'	=> 'text',
										),
										'bg_color'	=> array(
											'title'	=> esc_html__( 'Background color', 'vintwood' ),
											'addrowclasses' => 'grid-col-3',
											'atts' => 'data-default-color="#000000"',
											'value' => '#000000',
											'type'	=> 'text',
										),			
										'hover_color'	=> array(
											'title'	=> esc_html__( 'Icon color (Hover)', 'vintwood' ),
											'addrowclasses' => 'grid-col-3',
											'atts' => 'data-default-color="#ffffff"',
											'value' => '#ffffff',											
											'type'	=> 'text',
										),
										'hover_bg_color'	=> array(
											'title'	=> esc_html__( 'Background color (Hover)', 'vintwood' ),
											'addrowclasses' => 'grid-col-3',
											'atts' => 'data-default-color="#000000"',
											'value' => '#000000',
											'type'	=> 'text',
										),
									)
								),
							),
						),

					)
				),
			)
		), // end of sections
	);
	if ( class_exists( 'woocommerce' ) )  {
		$settings['woo_options'] = array(
			'type'		=> 'section',
			'title'		=> esc_html__( 'WooCommerce', 'vintwood' ),
			'icon'		=> array('fa', 'shopping-cart'),
			'layout'	=> array(
				'woo_options' => array(
					'type' 	=> 'tab',
					'init'	=> 'open',
					'icon' 	=> array('fa', 'arrow-circle-o-up'),
					'title' => esc_html__( 'Woocommerce', 'vintwood' ),
					'layout' => array(
						'woo_cart_enable'	=> array(
							'title'			=> esc_html__( 'Show WooCommerce Cart', 'vintwood' ),
							'type'			=> 'checkbox',
							'addrowclasses'	=> 'checkbox alt grid-col-12',
							'atts' => 'checked data-options="e:woo_cart_place;"',
						),
						'woo_cart_place' => array(
							'title' => esc_html__( 'WooCommerce Cart position', 'vintwood' ),
							'type' => 'radio',
							'subtype' => 'images',
							'addrowclasses' => 'disable grid-col-12',
							'value' => array(
								'top' =>array( esc_html__( 'TopBar', 'vintwood' ), false, '', '/img/woo-cart-top-right.png' ),
								'left' =>array( esc_html__( 'Menu (Left)', 'vintwood' ), false, '', '/img/woo-cart-menu-left.png' ),
								'right' =>array( esc_html__( 'Menu (Right)', 'vintwood' ), true, '', '/img/woo-cart-menu-right.png' ),
							),
						),
						'woo_sb_layout' => array(
							'title' => esc_html__('Sidebar Position', 'vintwood' ),
							'type' => 'radio',
							'subtype' => 'images',
							'addrowclasses' => 'grid-col-12',
							'value' => array(
								'left' => 	array( esc_html__('Left', 'vintwood' ), false, 'e:woo_sidebar;',	'/img/left.png' ),
								'right' => 	array( esc_html__('Right', 'vintwood' ), true, 'e:woo_sidebar;', '/img/right.png' ),
								'none' => 	array( esc_html__('None', 'vintwood' ), false, 'd:woo_sidebar;', '/img/none.png' )
							),
						),
						'woo_sidebar' => array(
							'title' => esc_html__('Select a sidebar', 'vintwood' ),
							'type' => 'select',
							'addrowclasses' => 'disable grid-col-12',
							'source' => 'sidebars',
						),	
						'woo_sb_layout_single' => array(
							'title' => esc_html__('Sidebar Position Single', 'vintwood' ),
							'type' => 'radio',
							'subtype' => 'images',
							'addrowclasses' => 'grid-col-12',
							'value' => array(
								'left' => 	array( esc_html__('Left', 'vintwood' ), false, 'e:woo_sidebar_single;',	'/img/left.png' ),
								'right' => 	array( esc_html__('Right', 'vintwood' ), false, 'e:woo_sidebar_single;', '/img/right.png' ),
								'none' => 	array( esc_html__('None', 'vintwood' ), true, 'd:woo_sidebar_single;', '/img/none.png' )
							),
						),					
						'woo_sidebar_single' => array(
							'title' => esc_html__('Select a Single sidebar', 'vintwood' ),
							'type' => 'select',
							'addrowclasses' => 'disable grid-col-12',
							'source' => 'sidebars',
						),
						'woo_columns' => array(
							'type' => 'select',
							'title' => esc_html__( 'Columns layout', 'vintwood' ),
							'addrowclasses' => 'grid-col-6',
							'source' => array(
								'2' => array('Two Columns',false, ''),
								'3' => array('Three Columns',true, ''),
								'4' => array('Four Columns',false, '')
							),
						),
						'woo_num_products'	=> array(
							'title'			=> esc_html__( 'Products per page', 'vintwood' ),
							'type'			=> 'number',
							'addrowclasses' => 'grid-col-6',
							'value'			=> get_option( 'posts_per_page' )
						),
						'woo_related_columns' => array(
							'type' => 'select',
							'title' => esc_html__( 'Columns layout (Related)', 'vintwood' ),
							'addrowclasses' => 'grid-col-6',
							'source' => array(
								'2' => array('Two Columns',false, ''),
								'3' => array('Three Columns',true, ''),
								'4' => array('Four Columns',false, '')
							),
						),						
						'woo_related_num_products'	=> array(
							'title'			=> esc_html__( 'Products per page (Related)', 'vintwood' ),
							'type'			=> 'number',
							'addrowclasses' => 'grid-col-6',
							'value'			=> get_option( 'posts_per_page' )
						),
						'shop-slider-type' => array(
							'title' => esc_html__('Slider', 'vintwood' ),
							'type' => 'radio',
							'addrowclasses' => 'grid-col-12',
							'value' => array(
								'none' => 	array( esc_html__('None', 'vintwood' ), true, 'd:shop-header-slider-options;d:shopslidersection-start;d:static_img_section' ),
								'img-slider'=>	array( esc_html__('Image Slider', 'vintwood' ), false, 'e:shop-header-slider-options;d:shopslidersection-start;d:static_img_section' ),
								'video-slider' => 	array( esc_html__('Video Slider', 'vintwood' ), false, 'd:shop-header-slider-options;e:shopslidersection-start;d:static_img_section' ),
								'stat-img-slider' => 	array( esc_html__('Static image', 'vintwood' ), false, 'd:shop-header-slider-options;d:shopslidersection-start;e:static_img_section' ),
							),
						),
						'shop-header-slider-options' => array(
							'title' => esc_html__( 'Slider shortcode', 'vintwood' ),
							'addrowclasses' => 'disable grid-col-12',
							'type' => 'text',
							'value' => '[rev_slider shoppage]',
						),
						'shopslidersection-start' => array(
							'title' => esc_html__( 'Video Slider Setting', 'vintwood' ),
							'type' => 'fields',
							'addrowclasses' => 'disable groups',
							'layout' => array(
								'slider_switch' => array(
									'title' => esc_html__( 'Slider', 'vintwood' ),
									'addrowclasses' => 'checkbox',
									'type' => 'checkbox',
									'atts' => 'data-options="e:slider_shortcode;"',
								),
								'slider_shortcode' => array(
									'title' => esc_html__( 'Slider shortcode', 'vintwood' ),
									'addrowclasses' => 'disable box',
									'type' => 'text',
								),
								'set_video_header_height' => array(
									'title' => esc_html__( 'Set Video height', 'vintwood' ),
									'type' => 'checkbox',
									'addrowclasses' => 'checkbox',
									'atts' => 'data-options="e:video_header_height"',
								),
								'video_header_height' => array(
									'title' => esc_html__( 'Video height', 'vintwood' ),
									'addrowclasses' => 'disable box',
									'type' => 'number',
									'value' => '600',
								),
								'video_type' => array(
									'title' => esc_html__('Video type', 'vintwood' ),
									'type' => 'radio',
									'value' => array(
										'self_hosted' => 	array( esc_html__('Self-hosted', 'vintwood' ), true, 'e:sh_source;d:youtube_source;d:vimeo_source' ),
										'youtube'=>	array( esc_html__('Youtube clip', 'vintwood' ), false, 'd:sh_source;e:youtube_source;d:vimeo_source' ),
										'vimeo' => 	array( esc_html__('Vimeo clip', 'vintwood' ), false, 'd:sh_source;d:youtube_source;e:vimeo_source' ),
									),
								),
								'sh_source' => array(
									'title' => esc_html__( 'Add video', 'vintwood' ),
									'addrowclasses' => 'box',
									'url-atts' => 'readonly',
									'type' => 'media',
								),
								'youtube_source' => array(
									'title' => esc_html__( 'Youtube video code', 'vintwood' ),
									'addrowclasses' => 'disable box',
									'type' => 'text',
								),
								'vimeo_source' => array(
									'title' => esc_html__( 'Vimeo embed url', 'vintwood' ),
									'addrowclasses' => 'disable box',
									'type' => 'text',
								),
								'color_overlay_type' => array(
									'title' => esc_html__( 'Overlay type', 'vintwood' ),
									'type' => 'select',
									'source' => array(
										'none' => array( esc_html__( 'None', 'vintwood' ), 	true, 'd:overlay_color;d:slider_gradient_settings;d:color_overlay_opacity;'),
										'color' => array( esc_html__( 'Color', 'vintwood' ), 	false, 'e:overlay_color;d:slider_gradient_settings;e:color_overlay_opacity;'),
										'gradient' =>array( esc_html__( 'Gradient', 'vintwood' ), false, 'd:overlay_color;e:slider_gradient_settings;e:color_overlay_opacity;'),
									),
								),
								'overlay_color' => array(
									'title' => esc_html__( 'Overlay Color', 'vintwood' ),
									'atts' => 'data-default-color=""',
									'addrowclasses' => 'box',
									'type' => 'text',
								),
								'color_overlay_opacity' => array(
									'type' => 'number',
									'addrowclasses' => 'box',
									'title' => esc_html__( 'Opacity', 'vintwood' ),
									'placeholder' => esc_attr__( 'In percents', 'vintwood' ),
									'value' => '40'
								),
								'slider_gradient_settings' => array(
									'title' => esc_html__( 'Gradient settings', 'vintwood' ),
									'type' => 'fields',
									'addrowclasses' => 'disable box groups',
									'layout' => array(
										'first_color' => array(
											'type' => 'text',
											'title' => esc_html__( 'From', 'vintwood' ),
											'atts' => 'data-default-color=""',
										),
										'second_color' => array(
											'type' => 'text',
											'title' => esc_html__( 'To', 'vintwood' ),
											'atts' => 'data-default-color=""',
										),
										'first_color_opacity' => array(
											'type' => 'number',
											'title' => esc_html__( 'From (Opacity %)', 'vintwood' ),
											'value' => '100',
										),
										'second_color_opacity' => array(
											'type' => 'number',
											'title' => esc_html__( 'To (Opacity %)', 'vintwood' ),
											'value' => '100',
										),
										'type' => array(
											'title' => esc_html__( 'Gradient type', 'vintwood' ),
											'type' => 'radio',
											'value' => array(
												'linear' => array( esc_html__( 'Linear', 'vintwood' ),  true, 'e:linear_settings;d:radial_settings' ),
												'radial' =>array( esc_html__( 'Radial', 'vintwood' ), false,  'd:linear_settings;e:radial_settings' ),
											),
										),
										'linear_settings' => array(
											'title' => esc_html__( 'Linear settings', 'vintwood'  ),
											'type' => 'fields',
											'addrowclasses' => 'disable',
											'layout' => array(
												'angle' => array(
													'type' => 'number',
													'title' => esc_html__( 'Angle', 'vintwood' ),
													'value' => '45',
												),
											)
										),
										'radial_settings' => array(
											'title' => esc_html__( 'Radial settings', 'vintwood'  ),
											'type' => 'fields',
											'addrowclasses' => 'disable',
											'layout' => array(
												'shape_settings' => array(
													'title' => esc_html__( 'Shape', 'vintwood' ),
													'type' => 'radio',
													'value' => array(
														'simple' => array( esc_html__( 'Simple', 'vintwood' ),  true, 'e:shape;d:size;d:size_keyword;' ),
														'extended' =>array( esc_html__( 'Extended', 'vintwood' ), false, 'd:shape;e:size;e:size_keyword;' ),
													),
												),
												'shape' => array(
													'title' => esc_html__( 'Gradient type', 'vintwood' ),
													'type' => 'radio',
													'value' => array(
														'ellipse' => array( esc_html__( 'Ellipse', 'vintwood' ),  true ),
														'circle' =>array( esc_html__( 'Circle', 'vintwood' ), false ),
													),
												),
												'size_keyword' => array(
													'type' => 'select',
													'title' => esc_html__( 'Size keyword', 'vintwood' ),
													'addrowclasses' => 'disable',
													'source' => array(
														'closest-side' => array(esc_html__( 'Closest side', 'vintwood' ), false),
														'farthest-side' => array(esc_html__( 'Farthest side', 'vintwood' ), false),
														'closest-corner' => array(esc_html__( 'Closest corner', 'vintwood' ), false),
														'farthest-corner' => array(esc_html__( 'Farthest corner', 'vintwood' ), true),
													),
												),
												'size' => array(
													'type' => 'text',
													'addrowclasses' => 'disable',
													'title' => esc_html__( 'Size', 'vintwood' ),
													'atts' => 'placeholder="'.esc_attr__( 'Two space separated percent values, for example (60% 55%)', 'vintwood' ).'"',
												),
											)
										)

									),
								),
								'use_pattern' => array(
									'title' => esc_html__( 'Use pattern image', 'vintwood' ),
									'type' => 'checkbox',
									'addrowclasses' => 'checkbox',
									'atts' => 'data-options="e:pattern_image"',
								),
								'pattern_image' => array(
									'title' => esc_html__( 'Pattern image', 'vintwood' ),
									'addrowclasses' => 'disable box',
									'url-atts' => 'readonly',
									'type' => 'media',
								),
							),
						),// end of video-section
						'static_img_section' => array(
							'title' => esc_html__( 'Static image Slider Setting', 'vintwood' ),
							'type' => 'fields',
							'addrowclasses' => 'groups',
							'layout' => array(
								'shop_header_image_options' => array(
									'title' => esc_html__( 'Static image', 'vintwood' ),
									'type' => 'media',
									'url-atts' => 'readonly',
									'layout' => array(
										'is_high_dpi' => array(
											'title' => esc_html__( 'High-Resolution image', 'vintwood' ),
											'type' => 'checkbox',
											'addrowclasses' => 'checkbox',
										),
									),
								),
								'set_static_image_height' => array(
									'title' => esc_html__( 'Set Image height', 'vintwood' ),
									'addrowclasses' => 'checkbox',
									'type' => 'checkbox',
									'atts' => 'data-options="e:static_image_height;"',
								),
								'static_image_height' => array(
									'title' => esc_html__( 'Static Image Height', 'vintwood' ),
									'addrowclasses' => 'disable box',
									'type' => 'number',
									'default' => '600',
								),
								'static_customize_colors' => array(
									'title' => esc_html__( 'Customize colors', 'vintwood' ),
									'addrowclasses' => 'checkbox',
									'type' => 'checkbox',
									'atts' => 'data-options="e:img_header_color_overlay_type;e:img_header_overlay_color;e:img_header_color_overlay_opacity;"',
								),
								'img_header_color_overlay_type'	=> array(
									'title'		=> esc_html__( 'Color overlay type', 'vintwood' ),
									'type'	=> 'select',
									'addrowclasses' => 'box disable',
									'source'	=> array(
										'color' => array( esc_html__( 'Color', 'vintwood' ),  true, 'e:img_header_overlay_color;d:img_header_gradient_settings;' ),
										'gradient' => array( esc_html__( 'Gradient', 'vintwood' ), false, 'd:img_header_overlay_color;e:img_header_gradient_settings;' )
									),
								),
								'img_header_overlay_color'	=> array(
									'title'	=> esc_html__( 'Overlay color', 'vintwood' ),
									'atts' => 'data-default-color="' . VINTWOOD_FIRST_COLOR . '"',
									'value' => VINTWOOD_FIRST_COLOR,
									'addrowclasses' => 'box disable',
									'type'	=> 'text',
								),
								'img_header_gradient_settings' => array(
									'title' => esc_html__( 'Gradient Settings', 'vintwood' ),
									'type' => 'fields',
									'addrowclasses' => 'disable box groups',
									'layout' => array(
										'first_color' => array(
											'type' => 'text',
											'title' => esc_html__( 'From', 'vintwood' ),
											'atts' => 'data-default-color=""',
										),
										'second_color' => array(
											'type' => 'text',
											'title' => esc_html__( 'To', 'vintwood' ),
											'atts' => 'data-default-color=""',
										),
										'first_color_opacity' => array(
											'type' => 'number',
											'title' => esc_html__( 'From (Opacity %)', 'vintwood' ),
											'value' => '100',
										),
										'second_color_opacity' => array(
											'type' => 'number',
											'title' => esc_html__( 'To (Opacity %)', 'vintwood' ),
											'value' => '100',
										),
										'type' => array(
											'title' => esc_html__( 'Gradient type', 'vintwood' ),
											'type' => 'radio',
											'value' => array(
												'linear' => array( esc_html__( 'Linear', 'vintwood' ),  true, 'e:img_header_gradient_linear_settings;d:img_header_gradient_radial_settings' ),
												'radial' =>array( esc_html__( 'Radial', 'vintwood' ), false,  'd:img_header_gradient_linear_settings;e:img_header_gradient_radial_settings' ),
											),
										),
										'linear_settings' => array(
											'title' => esc_html__( 'Linear settings', 'vintwood'  ),
											'type' => 'fields',
											'addrowclasses' => 'disable',
											'layout' => array(
												'angle' => array(
													'type' => 'number',
													'title' => esc_html__( 'Angle', 'vintwood' ),
													'value' => '45',
												),
											)
										),
										'radial_settings' => array(
											'title' => esc_html__( 'Radial settings', 'vintwood'  ),
											'type' => 'fields',
											'addrowclasses' => 'disable',
											'layout' => array(
												'shape_settings' => array(
													'title' => esc_html__( 'Shape', 'vintwood' ),
													'type' => 'radio',
													'value' => array(
														'simple' => array( esc_html__( 'Simple', 'vintwood' ),  true, 'e:img_header_gradient_shape;d:img_header_gradient_size;d:img_header_gradient_size_keyword;' ),
														'extended' =>array( esc_html__( 'Extended', 'vintwood' ), false, 'd:img_header_gradient_shape;e:img_header_gradient_size;e:img_header_gradient_size_keyword;' ),
													),
												),
												'shape' => array(
													'title' => esc_html__( 'Gradient type', 'vintwood' ),
													'type' => 'radio',
													'value' => array(
														'ellipse' => array( esc_html__( 'Ellipse', 'vintwood' ),  true ),
														'circle' =>array( esc_html__( 'Circle', 'vintwood' ), false ),
													),
												),
												'img_header_gradient_size_keyword' => array(
													'type' => 'select',
													'title' => esc_html__( 'Size keyword', 'vintwood' ),
													'addrowclasses' => 'disable',
													'source' => array(
														'closest-side' => array(esc_html__( 'Closest side', 'vintwood' ), false),
														'farthest-side' => array(esc_html__( 'Farthest side', 'vintwood' ), false),
														'closest-corner' => array(esc_html__( 'Closest corner', 'vintwood' ), false),
														'farthest-corner' => array(esc_html__( 'Farthest corner', 'vintwood' ), true),
													),
												),
												'img_header_gradient_size' => array(
													'type' => 'text',
													'addrowclasses' => 'disable',
													'title' => esc_html__( 'Size', 'vintwood' ),
													'atts' => 'placeholder="'.esc_attr__( 'Two space separated percent values, for example (60% 55%)', 'vintwood' ).'"',
												),
											)
										)
									)
								),
								'img_header_color_overlay_opacity' => array(
									'type' => 'number',
									'title' => esc_html__( 'Opacity', 'vintwood' ),
									'addrowclasses' => 'box disable',
									'placeholder' => esc_attr__( 'In percents', 'vintwood' ),
									'value' => '40'
								),
								'img_header_use_pattern' => array(
									'title' => esc_html__( 'Add pattern', 'vintwood' ),
									'addrowclasses' => 'checkbox',
									'type' => 'checkbox',
									'atts' => 'data-options="e:img_header_pattern_image;"',
								),
								'img_header_pattern_image' => array(
									'title' => esc_html__( 'Pattern image', 'vintwood' ),
									'type' => 'media',
									'addrowclasses' => 'disable box',
									'url-atts' => 'readonly',
								),
								'img_header_parallaxify' => array(
									'title' => esc_html__( 'Parallaxify image', 'vintwood' ),
									'addrowclasses' => 'checkbox',
									'type' => 'checkbox',
									'atts' => 'data-options="e:img_header_parallax_options;"',
								),
								'img_header_parallax_options' => array(
									'title' => esc_html__( 'Parallax options', 'vintwood' ),
									'type' => 'fields',
									'addrowclasses' => 'disable box groups',
									'layout' => array(
										'img_header_scalar-x' => array(
											'type' => 'number',
											'title' => esc_html__( 'x-axis parallax intensity', 'vintwood' ),
											'placeholder' => esc_attr__( 'Integer', 'vintwood' ),
											'value' => '2'
										),
										'img_header_scalar-y' => array(
											'type' => 'number',
											'title' => esc_html__( 'y-axis parallax intensity', 'vintwood' ),
											'placeholder' => esc_attr__( 'Integer', 'vintwood' ),
											'value' => '2'
										),
										'img_header_limit-x' => array(
											'type' => 'number',
											'title' => esc_html__( 'Maximum x-axis shift', 'vintwood' ),
											'placeholder' => esc_attr__( 'Integer', 'vintwood' ),
											'value' => '15'
										),
										'img_header_limit-y' => array(
											'type' => 'number',
											'title' => esc_html__( 'Maximum y-axis shift', 'vintwood' ),
											'placeholder' => esc_attr__( 'Integer', 'vintwood' ),
											'value' => '15'
										),
									),
								),
							),
						),// end of static img slider-section
					)
				),
				'woo_menu_options' => array(
					'type' 	=> 'tab',
					'icon' 	=> array('fa', 'arrow-circle-o-up'),
					'title' => esc_html__( 'Menu', 'vintwood' ),
					'layout' => array(
						'woo_customize_menu'	=> array(
							'title'	=> esc_html__( 'Customize WooCommerce Menu', 'vintwood' ),
							'type'	=> 'checkbox',
							'addrowclasses' => 'checkbox alt grid-col-12',
							'atts' => 'data-options="e:show_menu_bg_color;e:woo_menu_font_color;e:woo_menu_font_color_hover;e:woo_header_covers_slider"',		
						),							
						'show_menu_bg_color' => array(
							'title' => esc_html__( 'Add Background Color', 'vintwood' ),
							'addrowclasses' => 'checkbox disable',
							'type' => 'checkbox',
							'atts' => 'data-options="e:woo_menu_opacity;e:woo_menu_bg_color"',
						),
						'woo_menu_bg_color' => array(
							'title' 		=> esc_html__( 'Background Color', 'vintwood' ),
							'tooltip' => array(
								'title' => esc_html__( 'Background Color', 'vintwood' ),
								'content' => esc_html__( 'Change the background color of the menu and logo area.', 'vintwood' ),
							),							
							'type' 			=> 'text',
							'addrowclasses' => 'grid-col-6 disable',
							'atts' 			=> 'data-default-color="#f8f8f8"',
							'value'			=> '#f8f8f8'
						),
						'woo_menu_opacity' => array(
							'title' 		=> esc_html__( 'Opacity', 'vintwood' ),
							'tooltip' => array(
								'title' => esc_html__( 'Menu Opacity', 'vintwood' ),
								'content' => esc_html__( 'This option will apply a transparent header when set to 0. Options available from 0 to 100', 'vintwood' ),
							),								
							'type' 			=> 'number',
							'addrowclasses' => 'grid-col-6 disable',
							'atts' 			=> " min='0' max='100'",
							'value'			=> '100'
						),
						'woo_menu_font_color' => array(
							'title' 		=> esc_html__( 'Override Font Color', 'vintwood' ),
							'tooltip' => array(
								'title' => esc_html__( 'Override Font Color', 'vintwood' ),
								'content' => esc_html__( 'This color is applied to the main menu only, sub-menu items will use the color which is set in Typography section.<br /> This option is very useful when menu and logo covers title area or slider.', 'vintwood' ),
							),							
							'type' 			=> 'text',
							'addrowclasses' => 'grid-col-12 disable',
							'atts' 			=> 'data-default-color="#fff;"',
							'value'			=> '#fff'
						),
						'woo_menu_font_color_hover' => array(
							'title' 		=> esc_html__( 'Override Font Color on Hover', 'vintwood' ),					
							'type' 			=> 'text',
							'addrowclasses' => 'grid-col-12 disable',
							'atts' 			=> 'data-default-color="#fff;"',
							'value'			=> '#fff'
						),
						'woo_header_covers_slider' => array(
							'title' => esc_html__( 'Header Hover Slider', 'vintwood' ),
							'tooltip' => array(
								'title' => esc_html__( 'Menu Overlays Slider', 'vintwood' ),
								'content' => esc_html__( 'This option will force the menu and logo sections to overlay the title area. <br> It is useful when using transparent menu.', 'vintwood' ),
							),							
							'type' => 'checkbox',
							'addrowclasses' => 'checkbox grid-col-12 disable'
						),		
						'woo_customize_logotype'	=> array(
							'title'	=> esc_html__( 'Customize WooCommerce Logotype', 'vintwood' ),
							'type'	=> 'checkbox',
							'addrowclasses' => 'checkbox alt grid-col-12',
							'atts' => 'data-options="e:logo_woo"',		
						),
						'logo_woo' => array(
							'title' => esc_html__( 'Logotype Woocommerce', 'vintwood' ),
							'type' => 'media',
							'url-atts' => 'readonly',
							'addrowclasses' => 'grid-col-12 disable',
							'layout' => array(
								'is_high_dpi' => array(
									'title' => esc_html__( 'High-Resolution logo', 'vintwood' ),
									'addrowclasses' => 'checkbox',
									'type' => 'checkbox',
								),
							),
						),
					)
				),
				'woo_title_options' => array(
					'type' 	=> 'tab',
					'icon' 	=> array('fa', 'arrow-circle-o-up'),
					'title' => esc_html__( 'Title Area', 'vintwood' ),
					'layout' => array(
						'woo_customize_title'	=> array(
							'title'	=> esc_html__( 'Customize WooCommerce Title Area', 'vintwood' ),
							'type'	=> 'checkbox',
							'atts' => 'data-options="e:woo_hide_title"',
							'addrowclasses' => 'checkbox alt grid-col-12'		
						),	
						'woo_hide_title'	=> array(
							'title'	=> esc_html__( 'Switch on/off the title area', 'vintwood' ),
							'type'	=> 'checkbox',
							'atts' => 'data-options="e:woo_page_title_spacings;e:woo_default_header_image;e:woo_header_font_color;e:woo_color_overlay_type;e:woo_header_center;e:woo_breadcrumbs_divider;e:woo_breadcrumbs_dimensions;e:woo_breadcrumbs-margin"',
							'addrowclasses' => 'checkbox alt grid-col-12 disable'		
						),	
						'woo_page_title_spacings' => array(
							'title' => esc_html__( 'Add Spacings (px)', 'vintwood' ),
							'type' => 'margins',
							'value' => array(
								'top' => array('placeholder' => esc_attr__( 'Top', 'vintwood' ), 'value' => '60'),
								'left' => array('placeholder' => esc_attr__( 'left', 'vintwood' ), 'value' => '0'),
								'right' => array('placeholder' => esc_attr__( 'Right', 'vintwood' ), 'value' => '0'),
								'bottom' => array('placeholder' => esc_attr__( 'Bottom', 'vintwood' ), 'value' => '60'),
							),
							'addrowclasses' => 'grid-col-6 disable'
						),
						'woo_default_header_image'	=> array(
							'title'	=> esc_html__( 'Add Background Image', 'vintwood' ),
							'addrowclasses' => 'grid-col-6 disable',
							'type'	=> 'media'
						),
						'woo_header_font_color' => array(
							'title' 			=> esc_html__( 'Override Font Color', 'vintwood' ),
							'atts' 				=> 'data-default-color=""',
							'type' 				=> 'text',
							'addrowclasses' 	=> 'grid-col-12 disable',
							'value'				=> 	""
						),
						'woo_color_overlay_type'	=> array(
							'title'		=> esc_html__( 'Color Overlay', 'vintwood' ),
							'addrowclasses' => 'grid-col-12 disable',
							'type'	=> 'select',
							'source'	=> array(
								'none' => array( esc_html__( 'None', 'vintwood' ),  true, 'd:woo_color_overlay_opacity;d:woo_overlay_color;d:woo_gradient_settings;' ),
								'color' => array( esc_html__( 'Color', 'vintwood' ),  false, 'e:woo_color_overlay_opacity;e:woo_overlay_color;d:woo_gradient_settings;' ),
								'gradient' => array( esc_html__( 'Gradient', 'vintwood' ), false, 'e:woo_color_overlay_opacity;d:woo_overlay_color;e:woo_gradient_settings;' )
								),
							),
						'woo_color_overlay_opacity' => array(
							'type' => 'number',
							'addrowclasses' => 'disable grid-col-12',
							'title' => esc_html__( 'Opacity', 'vintwood' ),
							'placeholder' => esc_attr__( 'In percents', 'vintwood' ),
							'value' => '40'
							),
						'woo_overlay_color'	=> array(
							'title'	=> esc_html__( 'Overlay color', 'vintwood' ),
							'atts' => 'data-default-color="' . VINTWOOD_FIRST_COLOR . '"',
							'addrowclasses' => 'disable grid-col-12',
							'value' => VINTWOOD_FIRST_COLOR,
							'type'	=> 'text'
							),
						'woo_gradient_settings' => array(
							'title' => esc_html__( 'Gradient Settings', 'vintwood' ),
							'type' => 'fields',
							'addrowclasses' => 'disable box inside-box groups grid-col-12',
							'layout' => array(
								'first_color' => array(
									'type' => 'text',
									'title' => esc_html__( 'From', 'vintwood' ),
									'atts' => 'data-default-color=""',
									),
								'second_color' => array(
									'type' => 'text',
									'title' => esc_html__( 'To', 'vintwood' ),
									'atts' => 'data-default-color=""',
									),
								'first_color_opacity' => array(
									'type' => 'number',
									'title' => esc_html__( 'From (Opacity %)', 'vintwood' ),
									'value' => '100',
									),
								'second_color_opacity' => array(
									'type' => 'number',
									'title' => esc_html__( 'To (Opacity %)', 'vintwood' ),
									'value' => '100',
									),
								'type' => array(
									'title' => esc_html__( 'Gradient type', 'vintwood' ),
									'type' => 'radio',
									'value' => array(
										'linear' => array( esc_html__( 'Linear', 'vintwood' ),  true, 'e:linear_settings;d:radial_settings' ),
										'radial' =>array( esc_html__( 'Radial', 'vintwood' ), false,  'd:linear_settings;e:radial_settings' ),
										),
									),
								'linear_settings' => array(
									'title' => esc_html__( 'Linear settings', 'vintwood'  ),
									'type' => 'fields',
									'addrowclasses' => 'disable',
									'layout' => array(
										'angle' => array(
											'type' => 'number',
											'title' => esc_html__( 'Angle', 'vintwood' ),
											'value' => '45',
											),
										)
									),
								'radial_settings' => array(
									'title' => esc_html__( 'Radial settings', 'vintwood'  ),
									'type' => 'fields',
									'addrowclasses' => 'disable',
									'layout' => array(
										'shape_settings' => array(
											'title' => esc_html__( 'Shape', 'vintwood' ),
											'type' => 'radio',
											'value' => array(
												'simple' => array( esc_html__( 'Simple', 'vintwood' ),  true, 'e:shape;d:size;d:size_keyword;' ),
												'extended' =>array( esc_html__( 'Extended', 'vintwood' ), false, 'd:shape;e:size;e:size_keyword;' ),
												),
											),
										'shape' => array(
											'title' => esc_html__( 'Gradient type', 'vintwood' ),
											'type' => 'radio',
											'value' => array(
												'ellipse' => array( esc_html__( 'Ellipse', 'vintwood' ),  true ),
												'circle' =>array( esc_html__( 'Circle', 'vintwood' ), false ),
												),
											),
										'size_keyword' => array(
											'type' => 'select',
											'title' => esc_html__( 'Size keyword', 'vintwood' ),
											'addrowclasses' => 'disable',
											'source' => array(
												'closest-side' => array(esc_html__( 'Closest side', 'vintwood' ), false),
												'farthest-side' => array(esc_html__( 'Farthest side', 'vintwood' ), false),
												'closest-corner' => array(esc_html__( 'Closest corner', 'vintwood' ), false),
												'farthest-corner' => array(esc_html__( 'Farthest corner', 'vintwood' ), true),
												),
											),
										'size' => array(
											'type' => 'text',
											'addrowclasses' => 'disable',
											'title' => esc_html__( 'Size', 'vintwood' ),
											'atts' => 'placeholder="'.esc_attr__( 'Two space separated percent values, for example (60% 55%)', 'vintwood' ).'"',
											),
										)
									),
								)
							),
						'woo_header_center' => array(
							'title' => esc_html__( 'Center Title & Breadcrumbs', 'vintwood' ),
							'addrowclasses' => 'grid-col-6 disable',
							'type' => 'checkbox',
						),
						'woo_breadcrumbs_divider' => array(
							'title' => esc_html__( 'Breadcrumbs Divider', 'vintwood' ),
							'type' => 'media',
							'url-atts' => 'readonly',
							'addrowclasses' => 'grid-col-12',
							'layout' => array(
								'is_high_dpi' => array(
									'title' => esc_html__( 'High-Resolution logo', 'vintwood' ),
									'addrowclasses' => 'checkbox',
									'type' => 'checkbox',
								),
							),
						),

						'woo_breadcrumbs_dimensions' => array(
							'title' => esc_html__( 'Breadcrumbs Divider Dimensions', 'vintwood' ),
							'type' => 'dimensions',
							'addrowclasses' => 'disable grid-col-12',
							'value' => array(
								'width' => array('placeholder' => esc_attr__( 'Width', 'vintwood' ), 'value' => ''),
								'height' => array('placeholder' => esc_attr__( 'Height', 'vintwood' ), 'value' => ''),
								),
							),
						'woo_breadcrumbs-margin' => array(
							'title' => esc_html__( 'Margins (px)', 'vintwood' ),
							'type' => 'margins',
							'addrowclasses' => 'disable grid-col-4',
							'value' => array(
								'top' => array('placeholder' => esc_attr__( 'Top', 'vintwood' ), 'value' => '6'),
								'left' => array('placeholder' => esc_attr__( 'left', 'vintwood' ), 'value' => '0'),
								'right' => array('placeholder' => esc_attr__( 'Right', 'vintwood' ), 'value' => '0'),
								'bottom' => array('placeholder' => esc_attr__( 'Bottom', 'vintwood' ), 'value' => '-10'),
								),
							),
					)
				)
			)
		);
	}
	if (function_exists('cws_core_build_settings')) {
		cws_core_build_settings($settings, $g_components);
	}
	return $settings;
}

/*
	here local or overrided components can be added/changed
*/
function cwsfw_get_local_components() {
	return array();
}
?>