<?php defined('ABSPATH') or die("No script kiddies please!"); ?>

<div id="wpbody" role="main">

    <div id="wpbody-content" aria-label="Main content" tabindex="0">
        <div class="wrap estp-wrap">
            <div class="estp-header-wrap">
                <h3><span class="estp-admin-title">How to use</span></h3>
                <div class="logo">
                    <img src="<?php echo ESTP_IMAGE_DIR; ?>/logo.png" alt="<?php esc_attr_e('AccessPress Social Icons', 'easy-side-tab-pro'); ?>">
                </div>
            </div>
            <div class="estp-form-wrap">
                <div class="estp-content-wrap">
                    <div class="estp-content-section">
                        <h5 class="description">For detailed documentation, please visit <a href="https://accesspressthemes.com/documentation/easy-side-tab-pro/" target="_blank">here</a>.</h5>

                        <h4 class="estp-content-title">Tab Settings</h4>
                        <p>In this section you can change the settings of the tab such as:</p>
                        <ul>
                            <li><strong>Tab Title</strong> -Here,  you should assign  the name for your tab.</li>
                            <li><strong>Tab Text</strong> - In this section you should input the name which is to be displayed on the tab.</li>
                            <li><strong>Choose Icon Type</strong> - Choose icon as Available Fonts (Font Awesome/Dashicons/Genericons) or Upload your own custom icon here.</li>
                            <li><strong>Tab Type</strong> - This field determines the type of tab that you are going to display on your    website which are as:
                                <ul>
                                    <li><strong>Internal</strong> -This field comes with a option to redirect to the internal page of your website.</li>
                                    <li><strong>External </strong> -This field has a URL field where you should give the external link url (eg:https://www.google.com).</li>
                                    <li><strong>Content Slider</strong> -Under this field there is a field where you write content so that content will be displayed on tab click.</li>
                                </ul>
                            </li>
                            <li><strong>Content Type</strong> - This options includes altogether 6 advanced components to fill on tab content which are mentioned below:
                                <ul>
                                    <li><strong>Html Content : </strong>Fill any html content here.</li>
                                    <li><strong>Recent Blogs : </strong>Display recent post or products as tab content.</li>
                                    <li><strong>Twitter Feed : </strong>Settings to show your tweets as tab content.</li>
                                    <li><strong>Custom Shortcode : </strong>Fill any external shortcode.</li>
                                    <li><strong>Woocommerce Product : </strong>Option to display your woocommerce products by type and category.</li>
                                    <li><strong>Subscription Form : </strong>Fill your subscription form details which will be displayed in the tab.</li>
                                    <li><strong>Social Icons : </strong>Add Social media icons which are connected to your profiles.</li>
                                </ul>
                            </li>
                        </ul>
                    </div>
                    <div class="estp-content-section">
                        <h4 class="estp-content-title">Layout Settings</h4>
                        <h5>Tab Layout</h5>
                        <p>With this option you can choose the template layout designs as you desire.</p>

                        <h5>Display Position</h5>
                        <p>This section determines whether you want the tab position to be fixed when the page is scrolled or absolute(ie. move when the page is scrolled) on your website.</p>

                        <h5>Customize Setting</h5>
                        <p>With this option selected you can choose the desired colors for your tab such as background color, text color, background hover color, text hover color, slider content background and text color.</p><br>
                    </div>
                    <div class="estp-content-section">
                        <h4 class="estp-content-title">Side Tab General Settings</h4>
                        <p>This is the main control of our plugin which is common for all of your tab settings. Here you get the settings option for 4 different tab positions ie left middle, right middle, bottom left & bottom right which are as :</p>
                        <ul>
                            <li><strong>Enable Side Tab</strong> -Switching the Tab on or off on your website.</li>
                            <li><strong>Enable On Mobile Devices</strong> -Enable or disable the plugin for mobile device.</li>
                            <li><strong>Enable Offset</strong> -Give offset to your tab from top(for left middle and right middle tabs), bottom left(for bottom left tab) and from bottom right(for bottom right tab).</li>
                            <li><strong>Display Pages</strong> -Option whether to display tab on homepage or all pages.</li>
                            <li><strong>Selected Tab</strong> -Select tab that you want to display for that specific position.</li>
                        </ul>
                    </div>

                    <div class="estp-content-section">
                        <h4 class="estp-content-title">Twitter Feed Settings</h4>
                        <p>This is the main setting page for your twitter account which is common for all of your tab settings. Here you are required to fill your twitter consumer key, consumer secret ,access token and access token secret for displaying twitter feeds on specific tab content as per setup. :</p>
                        <h5>Cache Setting</h5>
                        <p>The plugin has inbuilt caching method to prevent the frequent API calls due to which site won’t get slow. So in this tab you can set up the cache period on how often the latest twitter feeds should be fetched from API.</p>
                        <ul>
                            <li><strong>Cache Period</strong> - Enter the time period in minutes in which the feeds should be fetched.Default is 60 Minutes.</li>
                            <li><strong>Disable Cache</strong> - Check if you want to disable caching of tweets and want to fetch new tweets every time your site loads.</li>
                        </ul>
                    </div>

                    <div class="estp-content-section">
                        <h4 class="estp-content-title">Subscribers</h4>
                        
                        <p>In this section you can view the lists of peoples who are subscribe to your channel with their email. There is also the option to export the subscribers information into the CSV format file.</p>
                    </div>

                    <div class="estp-content-section">
                        <h4 class="estp-content-title">Import / Export</h4>
                        
                        <p>Here you can backup and secure your tab settings by selecting the tab you want to export and then click on export. Then you can import the tab settings whenever you want.</p>
                    </div>

                </div>
            </div>
        </div>

        <div class="clear"></div>
    </div><!-- wpbody-content -->
    
    <div class="clear"></div>
</div>