<?php
	/**
	 * CWS Banner Widget Class
	 */
class CWS_Banner extends WP_Widget {

	public $fields = array();
	public function init_fields() {
		$this->fields = array(
			'title' => array(
				'title' => esc_html__( 'Widget title', 'cws-essentials' ),
				'atts' => 'id="widget-title"',
				'type' => 'text',
				'value' => '',
			),
			'banner_title' => array(
				'title' => esc_html__( 'Banner title', 'cws-essentials' ),
				'type' => 'textarea',
				'atts' => 'rows="2" placeholder="'.esc_attr__('Enter title', 'cws-essentials').'"',
				'value' => '',
			),
			'title_desc' => array(
				'title' => esc_html__( 'Title Description', 'cws-essentials' ),
				'type' => 'textarea',
				'atts' => 'rows="4" placeholder="'.esc_attr__('Enter title description', 'cws-essentials').'"',
				'value' => '',
			),
			'banner_url' => array(
				'title' => esc_html__( 'Banner Link', 'cws-essentials' ),
				'type' => 'textarea',
				'atts' => 'rows="4" placeholder="'.esc_attr__('Enter banner link', 'cws-essentials').'"',
				'value' => '',
			),
			'main_color' => array(
				'type'      => 'text',
				'title'     => esc_html__( 'Main color( borders & title color )', 'cws-essentials' ),
				'atts' => 'data-default-color="#000000"',
			),
			'desc_color' => array(
				'type'      => 'text',
				'title'     => esc_html__( 'Desctiption color', 'cws-essentials' ),
				'atts' => 'data-default-color="#000000"',
			),
			'desc_bg' => array(
				'type'      => 'text',
				'title'     => esc_html__( 'Description background', 'cws-essentials' ),
				'atts' => 'data-default-color="#ff0000"',
			),
		);
	}
	function __construct() {
		$widget_ops = array( 'classname' => 'widget-cws-banner', 'description' => esc_html__( 'Add information about yourself', 'cws-essentials' ) );
		parent::__construct( 'cws-banner', esc_html__( 'CWS Banner', 'cws-essentials' ), $widget_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );

		extract( shortcode_atts( array(
			'title' => '',
			'banner_title' => '',
			'title_desc' => '',
			'banner_url' => '',
			'main_color' => '#000000',
			'desc_color' => '#000000',
			'desc_bg' => '#ff0000',
			'new_tab' => false,
		), $instance));
		global $cws_theme_funcs;

		$title = esc_html($title);

		echo sprintf('%s',$before_widget);
			if (!empty( $title )){
				echo sprintf("%s", $before_title) . esc_html($title) . $after_title;
			}

			if (!empty($banner_url)){
				$tag_open = "<a href='$banner_url'";
				$tag_close = "</a>";
			} else {
				$tag_open = "<div";
				$tag_close = "</div>";
			}

			echo "$tag_open class='cws_widget_banner' style='border-color:$main_color;'>";
					echo "<div class='banner_wrapper' style='border-color:$main_color;'>";
						echo "<div class='banner_content'>";
							echo !empty( $banner_title ) ? "<h3 class='banner_title' style='color:$main_color;'>$banner_title</h3>" : "";
							echo !empty( $title_desc ) ? "<span class='banner_desc' style='color:$desc_color; background-color:$desc_bg;'>$title_desc</span>" : "";
						echo "</div>";
					echo "</div>";
			echo "$tag_close";
		
		echo sprintf('%s',$after_widget);	
	}

	function update( $new_instance, $old_instance ) {
		$instance = (array)$new_instance;
		foreach ($new_instance as $key => $v) {
			if ($v == 'on') {
				$v = '1';
			}
			switch ($this->fields[$key]['type']) {
				case 'text':
					$instance[$key] = strip_tags($v);
					break;
			}
		}
		return $instance;
	}

	function form( $instance ) {
		$this->init_fields();
		if (function_exists('cws_core_build_layout') ) {
			echo cws_core_build_layout($instance, $this->fields, 'widget-' . $this->id_base . '[' . $this->number . '][');
		}
	}
}
?>