<?php
	/**
	 * CWS About Widget Class
	 */

class CWS_About extends WP_Widget {
	public $fields = array();
	public function init_fields() {
		$this->fields = array(
			'title' => array(
				'title' => esc_html__( 'Widget title', 'cws-essentials' ),
				'atts' => 'id="widget-title"',
				'type' => 'text',
				'value' => '',
			),
			'avatar' => array(
				'title' => esc_html__( 'Avatar', 'cws-essentials' ),
				'addrowclasses' => 'wide_picture',
				'type' => 'media',
			),
			'width' => array(
				'type' => 'number',
				'title' => esc_html__( 'Width (px)', 'cws-essentials' ),
				'value' => '270',
			),
			'height' => array(
				'type' => 'number',
				'title' => esc_html__( 'Height (px)', 'cws-essentials' ),
				'value' => '270',
			),
			'link' => array(
				'type'      => 'text',
				'title'     => esc_html__( 'Avatar link', 'cws-essentials' ),
				'atts' => 'placeholder="'.esc_attr__('http://', 'cws-essentials').'"',
			),
			'name' => array(
				'type'      => 'text',
				'title'     => esc_html__( 'Name', 'cws-essentials' ),
			),
			'position' => array(
				'type'      => 'text',
				'title'     => esc_html__( 'Position', 'cws-essentials' ),
			),
			'description' => array(
				'title' => esc_html__( 'About Me', 'cws-essentials' ),
				'type' => 'textarea',
				'atts' => 'rows="10" placeholder="'.esc_attr__('Enter information about self', 'cws-essentials').'"',
				'value' => '',
			),
			'signature' => array(
				'title' => esc_html__( 'Signature', 'cws-essentials' ),
				'addrowclasses' => 'wide_picture',
				'type' => 'media',
			),
		);
	}
	function __construct() {
		$widget_ops = array( 'classname' => 'widget-cws-about', 'description' => esc_html__( 'Add information about yourself', 'cws-essentials' ) );
		parent::__construct( 'cws-about', esc_html__( 'CWS About', 'cws-essentials' ), $widget_ops );
	}

	function widget( $args, $instance ) {
		extract( $args );

		extract( shortcode_atts( array(
			'title' => '',
			'avatar' => '',
			'width' => '270',
			'height' => '270',
			'link' => '',
			'name' => '',
			'position' => '',
			'description' => '',
			'signature' => '',
		), $instance));
		global $cws_theme_funcs;

		$title = esc_html($title);

		$avatar_id = !empty($avatar) ? $avatar['id'] : '';

		if ( !empty($width) || !empty($height) ) {
			$thumb_obj = cws_thumb( $avatar_id, array( 'width' => $width, 'height' => $height, 'crop' => true ), false );
			$avatar_src = $thumb_obj[0];
		}

		$signature_src = !empty($signature) ? $signature['src'] : '';

		echo sprintf('%s',$before_widget);
		if (!empty( $title )){
			echo sprintf("%s", $before_title);
			echo esc_html($title) . $after_title;
			if (!empty($avatar_src)) { ?>
				<div class="user_avatar">
				<?php if (!empty($link)) { ?> <a href="<?php echo esc_url($link) ?>"> <?php } ?>
					<img src="<?php echo esc_url($avatar_src) ?>" alt="<?php echo (!empty($name) ? $name : '') ?>" />
				<?php if (!empty($link)) { ?> </a> <?php } ?>
				</div>
			<?php }
		}

		echo "<div class='cws_textwidget_content'>";
			ob_start();
			?>
				<div class="about_me">
					<?php echo (!empty($name) ? '<h4 class="user_name">'.$name.'</h4>' : '') ?>
					<?php echo (!empty($position) ? '<h5 class="user_position">'.$position.'</h5>' : '') ?>
					<?php echo (!empty($description) ? '<p class="user_description">'.esc_html($description).'</p>' : '') ?>
					<?php if (!empty($signature_src)) { ?>
						<div class="user_signature">
							<img src="<?php echo esc_url($signature_src) ?>" alt="<?php esc_attr_e('Signature', 'cws-essentials'); ?>" />
						</div>
					<?php } ?>
				</div>
			<?php
			echo ob_get_clean();
		echo "</div>";
		
		echo sprintf('%s',$after_widget);	
	}

	function update( $new_instance, $old_instance ) {
		$instance = (array)$new_instance;
		foreach ($new_instance as $key => $v) {
			if ($v == 'on') {
				$v = '1';
			}
			switch ($this->fields[$key]['type']) {
				case 'text':
					$instance[$key] = strip_tags($v);
					break;
			}
		}
		return $instance;
	}

	function form( $instance ) {
		$this->init_fields();
		if (function_exists('cws_core_build_layout') ) {
			echo cws_core_build_layout($instance, $this->fields, 'widget-' . $this->id_base . '[' . $this->number . '][');
		}
	}
}
?>