<?php
/*
Plugin Name: CWS Essentials
Version: 	 1.0.4
Plugin URI:  http://cwsthemes.com
Description: Internal use for cwsthemes themes only.
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Author:      CWSThemes
Text Domain: cws-essentials
*/

//Check if plugin active
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

if (!defined('CWS_SHORTCODES_PLUGIN_NAME'))
	define('CWS_SHORTCODES_PLUGIN_NAME', trim(dirname(plugin_basename(__FILE__)), '/'));

if (!defined('CWS_SHORTCODES_PLUGIN_DIR'))
	define('CWS_SHORTCODES_PLUGIN_DIR', WP_PLUGIN_DIR . '/' . CWS_SHORTCODES_PLUGIN_NAME);


if (!defined('CWS_SHORTCODES_PLUGIN_URL'))
	define('CWS_SHORTCODES_PLUGIN_URL', WP_PLUGIN_URL . '/' . CWS_SHORTCODES_PLUGIN_NAME);

/**
 * Load plugin textdomain.
 */
function cws_load_textdomain() {
  load_plugin_textdomain( 'cws-essentials', false, basename( dirname( __FILE__ ) ) . '/languages' ); 
}
add_action( 'plugins_loaded', 'cws_load_textdomain' );

//Add Widgets
add_action( "widgets_init", "cws_register_widgets" );
function cws_register_widgets() {

	require_once('widgets/cws_text.php');
	require_once('widgets/cws_latest_posts.php');
	require_once('widgets/cws_portfolio.php');
	require_once('widgets/cws_twitter.php');
	require_once('widgets/cws_contact.php');
	require_once('widgets/cws_about.php');
	require_once('widgets/cws_categories.php');
	require_once('widgets/cws_gallery.php');
	require_once('widgets/cws_banner.php');	

	register_widget('CWS_Text');
	register_widget('CWS_Latest_Posts');
	register_widget('CWS_Portfolio');
	register_widget('CWS_Twitter');
	register_widget('CWS_Contact');
	register_widget('CWS_About');
	register_widget('CWS_Categories');
	register_widget('CWS_Gallery');
	register_widget('CWS_Banner');
}

require_once( CWS_SHORTCODES_PLUGIN_DIR . '/cws-metaboxes.php' );

//Get custom post types slugs
function cws_get_slug($slug) {
	$new_slug = '';
	global $cws_theme_funcs;
	if(!empty($cws_theme_funcs)){
		$new_slug = $cws_theme_funcs->cws_get_option($slug.'_slug');
	}
	$new_slug = !empty( $new_slug ) ? $new_slug : $slug;

	return sanitize_title($new_slug);
}

//Regenerate permalinks, if slug (blog / portfolio / staff / testimonials) changed
add_action( "init", "cws_rewrite_slug", 11 );

function cws_rewrite_slug() {
	$cws_rewrite_slug = get_option('cws_rewrite_slug');
	if ($cws_rewrite_slug){
		flush_rewrite_rules();
		update_option('cws_rewrite_slug', false);
	}
}
//-------------------------

function cwsCSSAnimation( $css_animation ) {
	$output = '';
	if ( '' !== $css_animation && 'none' !== $css_animation ) {
		wp_enqueue_script( 'waypoints' );
		$output = ' wpb_animate_when_almost_visible wpb_' . $css_animation . ' ' . $css_animation;
	}

	return $output;
}

//Add thumbnail image to posts
function add_post_thumb_name ($columns) {
	$columns = array_slice($columns, 0, 1, true) +
				array('post_thumbnail' => esc_html__('Thumbnails', 'cws-essentials')) +
				array_slice($columns, 1, NULL, true);
	return $columns;
}
add_filter('manage_post_posts_columns', 'add_post_thumb_name');

function add_post_thumb ($column, $id) {
	if ('post_thumbnail' === $column) {
		echo the_post_thumbnail('thumbnail');
	}
}
add_action('manage_post_posts_custom_column', 'add_post_thumb', 5, 2);
//Add thumbnail image to posts

/*Term images*/
// add_action( 'edit_term', 'cws_show_extra_term_fields' );
add_action( 'admin_init', 'cws_taxonomy_image_init');

/*Users extra profile fields*/
add_action( 'show_user_profile', 'cws_show_extra_profile_fields' );
add_action( 'edit_user_profile', 'cws_show_extra_profile_fields' );
add_action( 'personal_options_update', 'cws_save_extra_profile_fields' );
add_action( 'edit_user_profile_update', 'cws_save_extra_profile_fields' );

function cws_taxonomy_image_init(){
    $taxonomies = get_taxonomies();

    add_filter('manage_edit-category_columns', 'cws_category_columns');
    add_filter('manage_category_custom_column', 'cws_category_columns_fields', 10, 3);

    foreach ((array) $taxonomies as $taxonomy) {
    	if ($taxonomy == 'category'){
        	cws_add_custom_column_fields($taxonomy);
    	}
    }
}

function cws_add_custom_column_fields($taxonomy)
{
    add_action($taxonomy."_add_form_fields", 'cws_show_extra_term_fields');
    add_action($taxonomy."_edit_form_fields", 'cws_show_extra_term_fields');

	add_action("created_".$taxonomy, 'cws_save_extra_term_fields' );
	add_action("edited_".$taxonomy, 'cws_save_extra_term_fields' );

    //Add custom columns
    add_filter("manage_edit-".$taxonomy."_columns", 'cws_category_columns');
    add_filter("manage_".$taxonomy."_custom_column", 'cws_category_columns_fields', 10, 3);
}

function cws_category_columns($columns)
{
    $columns['image'] = esc_html__( 'Image', 'cws-essentials' );
    return $columns;
}

function cws_category_columns_fields($deprecated, $column_name, $term_id)
{
	$term_image = get_term_meta( $term_id, 'cws_mb_term' );
    if (!empty($term_image)){
		echo "<img class='term_table_img' src='".$term_image[0]['image']['src']."' alt=''>";
    }
}

// Extra term fields
function cws_show_extra_term_fields( $term_id ) {
	global $pagenow;

	$mb_attr = array(	
		'image' => array(
			'title' => esc_html__( 'Image', 'cws-essentials' ),
			'subtitle' => esc_html__( 'Upload your photo here.', 'cws-essentials' ),
			'addrowclasses' => 'hide_label wide_picture box grid-col-12',
			'type' => 'media',
		),
	);

	if ( in_array($pagenow,array('edit-tags.php','term.php')) ){
		echo '<h3>Additional categories information (CWS Themes)</h3>';
		echo '<div id="cws-post-metabox-id-1">';
			echo '<div class="inside" data-w="0">';
			wp_nonce_field( 'cws_mb_nonce', 'mb_nonce' );
			if (gettype ($term_id) == 'object'){
				$cws_stored_meta = get_term_meta( $term_id->term_id, 'cws_mb_term' );
			}
			if (function_exists('cws_core_cwsfw_fillMbAttributes') ) {
				if (!empty($cws_stored_meta[0])) {
					cws_core_cwsfw_fillMbAttributes($cws_stored_meta[0], $mb_attr);
				}
				echo cws_core_cwsfw_print_layout($mb_attr, 'cws_mb_');
			}
			echo "</div>";
		echo "</div>";
	}
}

function cws_save_extra_term_fields( $term_id/*, $tt_id*/) {
	$save_array = array();

	foreach($_POST as $key => $value) {
		if (0 === strpos($key, 'cws_mb_')) {
			if ('on' === $value) {
				$value = '1';
			}
			if (is_array($value)) {
				foreach ($value as $k => $val) {
					if (is_array($val)) {
						$save_array[substr($key, 7)][$k] = $val;
					} else {
						$save_array[substr($key, 7)][$k] = esc_html($val);
					}
				}
			} else {
				$save_array[substr($key, 7)] = esc_html($value);
			}
		}
	}
	if (!empty($save_array)) {
		update_term_meta( $term_id, 'cws_mb_term', $save_array );
	}
	return;
}

// Extra user fields
function cws_show_extra_profile_fields( $user ) {
	$mb_attr = array(
		'position' => array(
			'type' => 'text',
			'title' => esc_html__('Position', 'cws-essentials' ),
			'addrowclasses' => 'box grid-col-12',
		),		
		'avatar' => array(
			'title' => esc_html__( 'Avatar', 'cws-essentials' ),
			'subtitle' => esc_html__( 'Upload your photo here.', 'cws-essentials' ),
			'addrowclasses' => 'hide_label wide_picture box grid-col-12',
			'type' => 'media',
		),
		'social_group' => array(
			'type' => 'group',
			'addrowclasses' => 'group expander sortable box grid-col-12',
			'title' => esc_html__('Social networks', 'cws-essentials' ),
			'button_title' => esc_html__('Add new social network', 'cws-essentials' ),
			'button_icon' => 'fa fa-plus',
			'button_class' => 'button button-primary',
			'layout' => array(
				'title' => array(
					'type' => 'text',
					'atts' => 'data-role="title"',
					'addrowclasses' => 'grid-col-2',
					'title' => esc_html__('Social account title', 'cws-essentials' ),
				),
				'icon' => array(
					'type' => 'select',
					'addrowclasses' => 'fai grid-col-3',
					'source' => 'fa',
					'title' => esc_html__('Icon for this social contact', 'cws-essentials' )
				),
				'color'	=> array(
					'title'	=> esc_html__( 'Icon color', 'cws-essentials' ),
					'atts' => 'data-default-color="#595959"',
					'addrowclasses' => 'grid-col-3',
					'value' => '#595959',
					'type'	=> 'text',
				),										
				'url' => array(
					'type' => 'text',
					'addrowclasses' => 'grid-col-3',
					'title' => esc_html__('Url to your account', 'cws-essentials' ),
				)
			),
		),
		'author_url' => array(
			'type' => 'text',
			'title' => esc_html__('Author page URL', 'cws-essentials' ),
			'addrowclasses' => 'box grid-col-12',
		),			
	);

	echo '<h3>Additional profile information (CWS Themes)</h3>';
	echo '<div id="cws-post-metabox-id-1" class="postbox">';
		echo '<div class="inside" data-w="0">';
		wp_nonce_field( 'cws_mb_nonce', 'mb_nonce' );
		$cws_stored_meta = get_user_meta( $user->ID, 'cws_mb_user' );
		/*if (function_exists('cws_core_cwsfw_fillMbAttributes') ) {
			if (!empty($cws_stored_meta[0])) {
				cws_core_cwsfw_fillMbAttributes($cws_stored_meta[0], $mb_attr);
			}
			echo cws_core_cwsfw_print_layout($mb_attr, 'cws_mb_');
		}*/

		if (function_exists('cws_core_build_layout') ) {
			echo cws_core_build_layout((!empty($cws_stored_meta) ? $cws_stored_meta[0] : ''), $mb_attr, 'cws_mb_');
		}

		echo "</div>";
	echo "</div>";
}

function cws_save_extra_profile_fields( $user_id ) {
	if ( !current_user_can( 'edit_user', $user_id ) ) return false;

	$save_array = array();

	foreach($_POST as $key => $value) {
		if (0 === strpos($key, 'cws_mb_')) {
			if ('on' === $value) {
				$value = '1';
			}
			if (is_array($value)) {
				foreach ($value as $k => $val) {
					if (is_array($val)) {
						$save_array[substr($key, 7)][$k] = $val;
					} else {
						$save_array[substr($key, 7)][$k] = esc_html($val);
					}
				}
			} else {
				$save_array[substr($key, 7)] = esc_html($value);
			}
		}
	}
	if (!empty($save_array)) {
		update_user_meta( $user_id, 'cws_mb_user', $save_array );

	}
}

/*------------------------------------
-------------- PORTFOLIO -------------
------------------------------------*/
$theme = wp_get_theme();
if ($theme->get( 'Template' )) {
	if ( ! defined( 'THEME_SLUG' ) ) {
  		define('THEME_SLUG', $theme->get( 'Template' ));
  	}
} else {
	if ( ! defined( 'THEME_SLUG' ) ) {
  		define('THEME_SLUG', $theme->get( 'TextDomain' ));
  	}
}

add_action( "init", "register_cws_portfolio_cat", 1 );
add_action( "init", "register_cws_portfolio", 2 );

function register_cws_portfolio_cat(){
	$rewrite_slug = cws_get_slug('portfolio');

	register_taxonomy( 'cws_portfolio_cat', 'cws_portfolio', array(
		'hierarchical' => true,
		'show_admin_column' => true,
		'rewrite' => array( 'slug' => $rewrite_slug . '_cat' )
		));
}

function register_cws_portfolio (){
	$rewrite_slug = cws_get_slug('portfolio');

	$labels = array(
		'name' => esc_html__( 'Portfolio', 'cws-essentials' ),
		'singular_name' => esc_html__( 'Portfolio Item', 'cws-essentials' ),
		'menu_name' => esc_html__( 'Portfolio', 'cws-essentials' ),
		'add_new' => esc_html__( 'Add New', 'cws-essentials' ),
		'add_new_item' => esc_html__( 'Add New Portfolio Item', 'cws-essentials' ),
		'edit_item' => esc_html__('Edit Portfolio Item', 'cws-essentials' ),
		'new_item' => esc_html__( 'New Portfolio Item', 'cws-essentials' ),
		'view_item' => esc_html__( 'View Portfolio Item', 'cws-essentials' ),
		'search_items' => esc_html__( 'Search Portfolio Item', 'cws-essentials' ),
		'not_found' => esc_html__( 'No Portfolio Items found', 'cws-essentials' ),
		'not_found_in_trash' => esc_html__( 'No Portfolio Items found in Trash', 'cws-essentials' ),
		'parent_item_colon' => '',
		);

	register_post_type( 'cws_portfolio', array(
		'label' => esc_html__( 'Portfolio items', 'cws-essentials' ),
		'labels' => $labels,
		'public' => true,
		'rewrite' => array( 'slug' => $rewrite_slug ),
		'capability_type' => 'post',
		'supports' => array(
			'title',
			'editor',
			'excerpt',
			'page-attributes',
			'thumbnail'
			),
		'menu_position' => 23,
		'menu_icon' => 'dashicons-format-gallery',
		'taxonomies' => array( 'cws_portfolio_cat' ),
		'has_archive' => true
	));
}

//Add thumbnail image to portfolio posts
function add_cws_portfolio_thumb_name ($columns) {
	$columns = array_slice($columns, 0, 1, true) +
				array('cws_portfolio_thumbnail' => esc_html__('Thumbnails', 'cws-essentials')) +
				array_slice($columns, 1, NULL, true);
	return $columns;
}
add_filter('manage_cws_portfolio_posts_columns', 'add_cws_portfolio_thumb_name');

function add_cws_portfolio_thumb ($column, $id) {
	if ('cws_portfolio_thumbnail' === $column) {
		echo the_post_thumbnail('thumbnail');
	}
}
add_action('manage_cws_portfolio_posts_custom_column', 'add_cws_portfolio_thumb', 5, 2);
//Add thumbnail image to portfolio posts

/*------------------------------------
---------------- STAFF ---------------
------------------------------------*/

add_action( "init", "register_cws_staff_department", 3 );
add_action( "init", "register_cws_staff_position", 4 );
add_action( "init", "register_cws_staff", 5 );

function register_cws_staff (){
	$rewrite_slug = cws_get_slug('staff');

	$labels = array(
		'name' => esc_html__( 'Staff', 'cws-essentials' ),
		'singular_name' => esc_html__( 'Staff Item', 'cws-essentials' ),
		'menu_name' => esc_html__( 'Our team', 'cws-essentials' ),
		'all_items' => esc_html__( 'All', 'cws-essentials' ),
		'add_new' => esc_html__( 'Add New', 'cws-essentials' ),
		'add_new_item' => esc_html__( 'Add New Staff Item', 'cws-essentials' ),
		'edit_item' => esc_html__('Edit Staff Item\'s Info', 'cws-essentials' ),
		'new_item' => esc_html__( 'New Staff Item', 'cws-essentials' ),
		'view_item' => esc_html__( 'View Staff Item\'s Info', 'cws-essentials' ),
		'search_items' => esc_html__( 'Find Staff Item', 'cws-essentials' ),
		'not_found' => esc_html__( 'No Staff Items Found', 'cws-essentials' ),
		'not_found_in_trash' => esc_html__( 'No Staff Items Found in Trash', 'cws-essentials' ),
		'parent_item_colon' => '',
		);

	register_post_type( 'cws_staff', array(
		'label' => esc_html__( 'Staff Items', 'cws-essentials' ),
		'labels' => $labels,
		'public' => true,
		'rewrite' => array( 'slug' => $rewrite_slug ),
		'capability_type' => 'post',
		'supports' => array(
			'title',
			'editor',
			'excerpt',
			'page-attributes',
			'thumbnail'
			),
		'menu_position' => 24,
		'menu_icon' => 'dashicons-groups',
		'taxonomies' => array( 'cws_staff_member_position' ),
		'has_archive' => true
	));
}

function register_cws_staff_department(){
	$rewrite_slug = cws_get_slug('staff');

	$labels = array(
		'name' => esc_html__( 'Departments', 'cws-essentials' ),
		'singular_name' => esc_html__( 'Staff Department', 'cws-essentials' ),
		'all_items' => esc_html__( 'All Staff Departments', 'cws-essentials' ),
		'edit_item' => esc_html__( 'Edit Staff Department', 'cws-essentials' ),
		'view_item' => esc_html__( 'View Staff Department', 'cws-essentials' ),
		'update_item' => esc_html__( 'Update Staff Department', 'cws-essentials' ),
		'add_new_item' => esc_html__( 'Add Staff Department', 'cws-essentials' ),
		'new_item_name' => esc_html__( 'New Staff Department', 'cws-essentials' ),
		'parent_item' => esc_html__( 'Parent Staff Department', 'cws-essentials' ),
		'parent_item_colon' => esc_html__( 'Parent Staff Department:', 'cws-essentials' ),
		'search_items' => esc_html__( 'Search Staff Departments', 'cws-essentials' ),
		'popular_items' => esc_html__( 'Popular Staff Departments', 'cws-essentials' ),
		'separate_items_width_commas' => esc_html__( 'Separate with commas', 'cws-essentials' ),
		'add_or_remove_items' => esc_html__( 'Add or Remove Staff Departments', 'cws-essentials' ),
		'choose_from_most_used' => esc_html__( 'Choose from the most used Staff Departments', 'cws-essentials' ),
		'not_found' => esc_html__( 'No Staff Departments Found', 'cws-essentials' )
	);
	register_taxonomy( 'cws_staff_member_department', 'cws_staff', array(
		'labels' => $labels,
		'hierarchical' => true,
		'show_admin_column' => true,
		'rewrite' => array( 'slug' => $rewrite_slug . '_cat' )
	));
}

function register_cws_staff_position(){
	$rewrite_slug = cws_get_slug('staff');

	$labels = array(
		'name' => esc_html__( 'Positions', 'cws-essentials' ),
		'singular_name' => esc_html__( 'Staff Position', 'cws-essentials' ),
		'all_items' => esc_html__( 'All Staff Positions', 'cws-essentials' ),
		'edit_item' => esc_html__( 'Edit Staff Position', 'cws-essentials' ),
		'view_item' => esc_html__( 'View Staff Position', 'cws-essentials' ),
		'update_item' => esc_html__( 'Update Staff Position', 'cws-essentials' ),
		'add_new_item' => esc_html__( 'Add Staff Position', 'cws-essentials' ),
		'new_item_name' => esc_html__( 'New Staff Position', 'cws-essentials' ),
		'search_items' => esc_html__( 'Search Staff Positions', 'cws-essentials' ),
		'popular_items' => esc_html__( 'Popular Staff Positions', 'cws-essentials' ),
		'separate_items_width_commas' => esc_html__( 'Separate with commas', 'cws-essentials' ),
		'add_or_remove_items' => esc_html__( 'Add or Remove Staff Positions', 'cws-essentials' ),
		'choose_from_most_used' => esc_html__( 'Choose from the most used Staff Positions', 'cws-essentials' ),
		'not_found' => esc_html__( 'No Staff Member positions found', 'cws-essentials' )
	);
	register_taxonomy( 'cws_staff_member_position', 'cws_staff', array(
		'labels' => $labels,
		'show_admin_column' => true,
		'rewrite' => array( 'slug' => $rewrite_slug . '_tag' ),
		'show_tagcloud' => false
	));
}
// =====================================================================================================================================================

/* Testimonials */
// Uncomment this line to activate Testimonials
// add_action( "init", "register_cws_testimonial_department", 6 );
// add_action( "init", "register_cws_testimonial_position", 7 );
// add_action( "init", "register_cws_testimonials", 8 );

//Categories
function register_cws_testimonial_department(){
	$rewrite_slug = cws_get_slug('testimonials');
	
	$labels = array(
		'name' => esc_html__( 'Departments', 'cws-essentials' ),
		'singular_name' => esc_html__( 'Department', 'cws-essentials' ),
		'all_items' => esc_html__( 'All Departments', 'cws-essentials' ),
		'edit_item' => esc_html__( 'Edit Department', 'cws-essentials' ),
		'view_item' => esc_html__( 'View Department', 'cws-essentials' ),
		'update_item' => esc_html__( 'Update Department', 'cws-essentials' ),
		'add_new_item' => esc_html__( 'Add Department', 'cws-essentials' ),
		'new_item_name' => esc_html__( 'New Department', 'cws-essentials' ),
		'parent_item' => esc_html__( 'Parent Department', 'cws-essentials' ),
		'parent_item_colon' => esc_html__( 'Parent Department:', 'cws-essentials' ),
		'search_items' => esc_html__( 'Search Departments', 'cws-essentials' ),
		'popular_items' => esc_html__( 'Popular Departments', 'cws-essentials' ),
		'separate_items_width_commas' => esc_html__( 'Separate with commas', 'cws-essentials' ),
		'add_or_remove_items' => esc_html__( 'Add or Remove Departments', 'cws-essentials' ),
		'choose_from_most_used' => esc_html__( 'Choose from the most used Departments', 'cws-essentials' ),
		'not_found' => esc_html__( 'No Departments found', 'cws-essentials' )
	);

	register_taxonomy( 'cws_testimonial_department', 'cws_testimonial', array(
		'labels' => $labels,
		'hierarchical' => true,
		'show_admin_column' => true,
		'rewrite' => array( 'slug' => $rewrite_slug . '_cat' )
	));
}

//Tags
function register_cws_testimonial_position(){
	$rewrite_slug = cws_get_slug('testimonials');

	$labels = array(
		'name' => esc_html__( 'Positions', 'cws-essentials' ),
		'singular_name' => esc_html__( 'Position', 'cws-essentials' ),
		'all_items' => esc_html__( 'All Positions', 'cws-essentials' ),
		'edit_item' => esc_html__( 'Edit Position', 'cws-essentials' ),
		'view_item' => esc_html__( 'View Position', 'cws-essentials' ),
		'update_item' => esc_html__( 'Update Position', 'cws-essentials' ),
		'add_new_item' => esc_html__( 'Add Position', 'cws-essentials' ),
		'new_item_name' => esc_html__( 'New Position', 'cws-essentials' ),
		'search_items' => esc_html__( 'Search Positions', 'cws-essentials' ),
		'popular_items' => esc_html__( 'Popular Positions', 'cws-essentials' ),
		'separate_items_width_commas' => esc_html__( 'Separate with commas', 'cws-essentials' ),
		'add_or_remove_items' => esc_html__( 'Add or Remove Positions', 'cws-essentials' ),
		'choose_from_most_used' => esc_html__( 'Choose from the most used  Positions', 'cws-essentials' ),
		'not_found' => esc_html__( 'No  Positions found', 'cws-essentials' )
	);

	register_taxonomy( 'cws_testimonial_position', 'cws_testimonial', array(
		'labels' => $labels,
		'show_admin_column' => true,
		'rewrite' => array( 'slug' => $rewrite_slug . '_tag' ),
		'show_tagcloud' => false
	));
}


function register_cws_testimonials (){
	$rewrite_slug = cws_get_slug('testimonials');

	$labels = array(
		'name' => esc_html__( 'Testimonials', 'cws-essentials' ),
		'singular_name' => esc_html__( 'Testimonial', 'cws-essentials' ),
		'menu_name' => esc_html__( 'Testimonials', 'cws-essentials' ),
		'all_items' => esc_html__( 'All', 'cws-essentials' ),
		'add_new' => esc_html__( 'Add New', 'cws-essentials' ),
		'add_new_item' => esc_html__( 'Add New', 'cws-essentials' ),
		'edit_item' => esc_html__('Edit Testimonial', 'cws-essentials' ),
		'new_item' => esc_html__( 'New Testimonial', 'cws-essentials' ),
		'view_item' => esc_html__( 'View Testimonial', 'cws-essentials' ),
		'search_items' => esc_html__( 'Search Testimonials', 'cws-essentials' ),
		'not_found' => esc_html__( 'No Testimonials Items Found', 'cws-essentials' ),
		'not_found_in_trash' => esc_html__( 'No Testimonials Items Found in Trash', 'cws-essentials' ),
		'parent_item_colon' => '',
		);

	register_post_type( 'cws_testimonial', array(
		'label' => esc_html__( 'Testimonials', 'cws-essentials' ),
		'labels' => $labels,
		'public' => true,
		'rewrite' => array( 'slug' => $rewrite_slug ),
		'capability_type' => 'post',
		'supports' => array(
			'title',
			'editor',
			'excerpt',
			'page-attributes', // Sortable column "Order"
			'thumbnail'
			),
		'menu_position' => 22,
		'menu_icon' => 'dashicons-format-quote',
		'taxonomies' => array( 'cws_testimonial_department' ),
		'has_archive' => true
	));
}


function add_order_column( $columns ) {
  $columns['menu_order'] = "Order";
  return $columns;
}
add_action('manage_edit-cws_staff_columns', 'add_order_column');
add_action('manage_edit-cws_portfolio_columns', 'add_order_column');
add_action('manage_edit-cws_testimonial_columns', 'add_order_column');

/**
* show custom order column values
*/
function show_order_column($name){
  global $post;
  switch ($name) {
    case 'menu_order':
      $order = $post->menu_order;
      echo $order;
      break;
   default:
      break;
   }
}

//Add thumbnail image to staff posts
function add_cws_staff_thumb_name ($columns) {
	$columns = array_slice($columns, 0, 1, true) +
				array('cws_staff_thumbnail' => esc_html__('Thumbnails', 'cws-essentials')) +
				array_slice($columns, 1, NULL, true);
	return $columns;
}
add_filter('manage_cws_staff_posts_columns', 'add_cws_staff_thumb_name');

function add_cws_staff_thumb ($column, $id) {
	if ('cws_staff_thumbnail' === $column) {
		echo the_post_thumbnail('thumbnail');
	}
}
add_action('manage_cws_staff_posts_custom_column', 'add_cws_staff_thumb', 5, 2);
//Add thumbnail image to staff posts

add_action('manage_cws_staff_posts_custom_column','show_order_column');
add_action('manage_cws_portfolio_posts_custom_column','show_order_column');
add_action('manage_cws_testimonial_posts_custom_column','show_order_column');

/**
* make column sortable
*/
function order_column_register_sortable( $columns ){
	$new_columns = array(
		"menu_order" 	=> "menu_order",
		"date"			=> "date",
		"title"			=> "title"
	);
	return $new_columns;
}
add_filter('manage_edit-cws_staff_sortable_columns','order_column_register_sortable');
add_filter('manage_edit-cws_portfolio_sortable_columns','order_column_register_sortable');
add_filter('manage_edit-cws_testimonial_sortable_columns','order_column_register_sortable');

// Uncomment this line to activate Classes
// add_action( "init", "register_cws_classes", 9 );
// add_action( "init", "register_cws_classes_cat", 10 );

function register_cws_classes_cat(){
	$rewrite_slug = cws_get_slug('classes');

	register_taxonomy( 'cws_classes_cat', 'cws_classes', array(
		'hierarchical' => true,
		'show_admin_column' => true,
		'rewrite' => array( 'slug' => $rewrite_slug . '_cat' )
		));
}

function register_cws_classes (){
	$rewrite_slug = cws_get_slug('classes');

	$labels = array(
		'name' => esc_html__( 'Classes', 'cws-essentials' ),
		'singular_name' => esc_html__( 'Classes', 'cws-essentials' ),
		'menu_name' => esc_html__( 'Our Classes', 'cws-essentials' ),
		'all_items' => esc_html__( 'All', 'cws-essentials' ),
		'add_new' => esc_html__( 'Add New', 'cws-essentials' ),
		'add_new_item' => esc_html__( 'Add New Class', 'cws-essentials' ),
		'edit_item' => esc_html__('Edit Class', 'cws-essentials' ),
		'new_item' => esc_html__( 'New Class', 'cws-essentials' ),
		'view_item' => esc_html__( 'View Class', 'cws-essentials' ),
		'search_items' => esc_html__( 'Find Classes', 'cws-essentials' ),
		'not_found' => esc_html__( 'No Classess found', 'cws-essentials' ),
		'not_found_in_trash' => esc_html__( 'No Classess found in Trash', 'cws-essentials' ),
		'parent_item_colon' => '',
		);

	register_post_type( 'cws_classes', array(
		'label' => esc_html__( 'Classes', 'cws-essentials' ),
		'labels' => $labels,
		'public' => true,
		'rewrite' => array( 'slug' => $rewrite_slug ),
		'capability_type' => 'post',
		'supports' => array(
			'title',
			'editor',
			'excerpt',
			'page-attributes',
			'thumbnail'
			),
		'menu_position' => 24,
		'menu_icon' => 'dashicons-clipboard',
		'taxonomies' => array( 'cws_classes_member_position' ),
		'has_archive' => true
	));
}

// =====================================================================================================================================================



function add_order_column_classes( $columns ) {
  $columns['menu_order'] = "Order";
  return $columns;
}
add_action('manage_edit-cws_classes_columns', 'add_order_column_classes');

/**
* show custom order column values
*/
function show_order_column_classes($name){
  global $post;
  switch ($name) {
    case 'menu_order':
      $order = $post->menu_order;
      echo $order;
      break;
   default:
      break;
   }
}
add_action('manage_cws_classes_posts_custom_column','show_order_column_classes');

/**
* make column sortable
*/
function order_column_register_sortable_classes( $columns ){
	$new_columns = array(
		"menu_order" 	=> "menu_order",
		"date"			=> "date",
		"title"			=> "title"
	);
	return $new_columns;
}
add_filter('manage_edit-cws_classes_sortable_columns','order_column_register_sortable_classes');

if(!function_exists('cws_Hex2RGBA')){
	function cws_Hex2RGBA( $color, $opacity ) {
		$output = '';
		if (!empty($color)){
			//Sanitize $color if "#" is provided 
			if (substr($color, 0, 4) === 'rgba') {
				if(!empty($opacity)){
					$rgba_o = str_replace("rgba(", "", $color);
					$rgba_o = explode(",", $rgba_o);
					return "rgba(".$rgba_o[0].",".$rgba_o[1].",".$rgba_o[2].", ".$opacity.")";
				}
				return $color;
			}

		    if ($color[0] == '#' ) {
		    	$color = substr( $color, 1 );
		    }
		    //Check if color has 6 or 3 characters and get values
		    if (strlen($color) == 6) {
		            $hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
		    } elseif ( strlen( $color ) == 3 ) {
		            $hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
		    } else {
		            return $default;
		    }

		    //Convert hexadec to rgb
		    $rgb =  array_map('hexdec', $hex);

		    //Check if opacity is set(rgba or rgb)
		    if($opacity){
		    	if(abs($opacity) > 1)
		    		$opacity = 1.0;
		    	$output = 'rgba('.implode(",",$rgb).','.$opacity.')';
		    } else {
		    	$output = 'rgb('.implode(",",$rgb).')';
		    }

		    //Return rgb(a) color string
		    return $output;
		}

	}	
}


/****************** POSTS GRID AJAX *******************/

function cws_vc_shortcode_posts_grid_dynamic_pagination (){
	extract( wp_parse_args( $_POST['data'], array(
		'section_id'				=> '',
		'post_type' 				=> '',
		'post_hide_meta'			=> array(),
		'cws_portfolio_data_to_show'=> '',
		'cws_staff_data_to_hide'	=> array(),
		'cws_testimonial_data_to_hide'	=> array(),
		'change_title'              => '',
		'title_btn'					=> '',
		'massonry'					=> '',
		'layout'					=> '1',
		'sb_layout'					=> '',
		'total_items_count'			=> get_option( 'posts_per_page' ),
		'items_pp'					=> get_option( 'posts_per_page' ),
		'page'						=> '1',
		'tax'						=> '',
		'terms'						=> array(),
		'filter'					=> 'false',
		'current_filter_val'		=> '',
		'req_page_url'				=> '',
		'crop_featured'				=> '',
		'crop_images'				=> '',
		'sort_by'					=> 'date',
		'sorting'					=> 'DESC',		
		'post_hide_meta'			=> '',
		'pagination_grid'			=> '',
		'full_width'				=> '',
		'addl_query_args'			=> array(),
		'post_hide_meta_override'	=> '',
		'post_hide_meta'			=> '',						
		'info_align'				=> '',
		'aligning'					=> '',
		'display_style'				=> '',
		'portfolio_style'			=> '',
		'info_pos'					=> '',
		'masonry'					=> '',
		'anim_style'				=> '',
		'item_shadow'				=> '',
		'en_hover_color'			=> '',
		'en_cat_color'				=> '',
		'hover_color'				=> '',
		'title_color'				=> '',
		'cat_color'					=> '',
		'huge_layout'				=> '',
		'appear_style'				=> '',
		'more_btn_text'				=> '',
		'link_show'					=> '',
		'isotope_line_count'		=> '',
		'isotope_col_count'			=> '',
		'chars_count'				=> '',
		'add_divider'				=> '',
		'tax'						=> '',
		'filter_vals'				=> '',
		'hover_bg_color'			=> '',
		'proc_atts'					=> '',
		'bg_hover_color'			=> '',
	)));

	$req_page = $page;
	if ( !empty( $req_page_url ) ){
		$match = preg_match( "#paged?(=|/)(\d+)#", $req_page_url, $matches );
		$req_page = $match ? $matches[2] : '1';								// if page parameter absent show first page
	};

	$not_in = ( 1 == $req_page ) ? array() : get_option( 'sticky_posts' );
	$query_args = array('post_type'			=> array( $post_type ),
						'post_status'		=> 'publish',
						'post__not_in'		=> $not_in
						);
	$query_args['posts_per_page']		= $items_pp;
	$query_args['paged']				= $paged = $req_page;
	$old_terms = $terms;
	if ( $filter == 'true' && $current_filter_val != '_all_' && !empty( $current_filter_val ) ){
		$terms = array( $current_filter_val );

		if($post_type == 'cws_portfolio' && $display_style == 'filter' && !empty($old_terms)){
			$terms = $old_terms;
		}	
	}
	if ( !empty( $terms ) ){
		$query_args['tax_query'] = array(
			array(
				'taxonomy'		=> $tax,
				'field'			=> 'slug',
				'terms'			=> $terms
			)
		);
	}
	if ( in_array( $post_type, array( "cws_portfolio", "cws_staff", "cws_testimonial", "tribe_events", "cws_classes" ) ) ){
		if (!empty($sort_by) && !empty($sorting)){
			$query_args['orderby'] 	= $sort_by;
			$query_args['order']	= $sorting;	
		} else {
			$query_args['orderby'] 	= "menu_order date title";
			$query_args['order']	= "ASC";
		}
	}
	$query_args = array_merge( $query_args, $addl_query_args );
	$q = new WP_Query( $query_args );
	$found_posts = $q->found_posts;
	$max_paged = $found_posts > $total_items_count ? ceil( $total_items_count / $items_pp ) : ceil( $found_posts / $items_pp );
	$GLOBALS['cws_vc_shortcode_posts_grid_atts'] = array(
		'post_type'					=> $post_type,
		'layout'					=> $layout,
		'massonry'					=> $massonry,
		'sb_layout'					=> $sb_layout,
		'post_hide_meta'			=> $post_hide_meta,
		'cws_portfolio_data_to_show'=> $cws_portfolio_data_to_show,
		'cws_staff_data_to_hide'	=> $cws_staff_data_to_hide,
		'cws_testimonial_data_to_hide'	=> $cws_testimonial_data_to_hide,
		'change_title'              => $change_title,
		'title_btn'					=> $title_btn,
		'crop_featured'				=> $crop_featured,
		'crop_images'				=> $crop_images,
		'sort_by'					=> $sort_by,
		'sorting'					=> $sorting,			
		'total_items_count'			=> $total_items_count,
		'full_width'				=> $full_width,
		'pagination_grid'			=> $pagination_grid,
		'post_hide_meta_override'	=> $post_hide_meta_override,
		'info_align'				=> $info_align,
		'aligning'					=> $aligning,
		'display_style'				=> $display_style,
		'portfolio_style'			=> $portfolio_style,
		'info_pos'					=> $info_pos,
		'masonry'					=> $masonry,
		'huge_layout'				=> $huge_layout,
		'anim_style'				=> $anim_style,
		'item_shadow'				=> $item_shadow,
		'en_hover_color'			=> $en_hover_color,
		'en_cat_color'				=> $en_cat_color,
		'hover_color'				=> $hover_color,
		'title_color'				=> $title_color,
		'cat_color'					=> $cat_color,
		'appear_style'				=> $appear_style,
		'more_btn_text'				=> $more_btn_text,
		'link_show'					=> $link_show,
		'isotope_line_count'		=> $isotope_line_count,
		'isotope_col_count'			=> $isotope_col_count,
		'chars_count'				=> $chars_count,
		'add_divider'				=> $add_divider,
		'tax'						=> $tax,
		'filter_vals'				=> $filter_vals,
		'hover_bg_color'			=> $hover_bg_color,
		'proc_atts'					=> $proc_atts,
		'bg_hover_color'			=> $bg_hover_color,

	);

	if ($post_type == 'post'){
		cws_blog_posts($q);
	} elseif ( function_exists( "cws_vc_shortcode_{$post_type}_posts_grid_posts" ) ){
		call_user_func_array( "cws_vc_shortcode_{$post_type}_posts_grid_posts", array( $q ) );
	}
	
	if ( $pagination_grid == 'load_more' ){
		echo cws_load_more ();
	}
	elseif($pagination_grid == 'standard_with_ajax'){
		echo cws_pagination($paged, $max_paged, true);
	}
	else{
		echo cws_pagination($paged, $max_paged, false);
	}
	unset ( $GLOBALS['cws_vc_shortcode_posts_grid_atts'] );
	echo "<input type='hidden' id='{$section_id}_dynamic_pagination_page_number' name='{$section_id}_dynamic_pagination_page_number' class='cws_vc_shortcode_posts_grid_dynamic_pagination_page_number' value='$req_page' />";
	wp_die();
}
add_action( 'wp_ajax_cws_vc_shortcode_posts_grid_dynamic_pagination', 'cws_vc_shortcode_posts_grid_dynamic_pagination' );
add_action( 'wp_ajax_nopriv_cws_vc_shortcode_posts_grid_dynamic_pagination', 'cws_vc_shortcode_posts_grid_dynamic_pagination' );

function cws_vc_shortcode_posts_grid_dynamic_filter (){
	extract( wp_parse_args( $_POST['data'], array(
		'section_id'				=> '',
		'post_type' 				=> '',
		'post_hide_meta'			=> array(),
		'massonry'					=> '',
		'cws_portfolio_data_to_show'=> '',
		'cws_classes_data_to_show'	=> '',
		'cws_staff_data_to_hide'	=> array(),
		'cws_testimonial_data_to_hide'	=> array(),
		'layout'					=> '1',
		'sb_layout'					=> '',
		'total_items_count'			=> get_option( 'posts_per_page' ),
		'items_pp'					=> get_option( 'posts_per_page' ),
		'page'						=> '1',
		'tax'						=> '',
		'terms'						=> array(),
		'filter'					=> 'false',
		'current_filter_val'		=> '',
		'crop_images' 				=> '',
		'sort_by'					=> 'date',
		'sorting'					=> 'DESC',		
		'pagination_grid'			=> '',
		'full_width'				=> '',
		'customize_colors'			=> '',
		'custom_color'				=> '',
		'font_color'				=> '',
		'bg_color'					=> '',
		'addl_query_args'			=> array(),
		'info_align'				=> '',
		'aligning'					=> '',
		'display_style'				=> '',
		'portfolio_style'			=> '',
		'info_pos'					=> '',
		'masonry'					=> '',
		'anim_style'				=> '',
		'huge_layout'				=> '',
		'item_shadow'				=> '',
		'en_hover_color'			=> '',
		'en_cat_color'				=> '',
		'hover_color'				=> '',
		'title_color'				=> '',
		'cat_color'					=> '',
		'appear_style'				=> '',
		'link_show'					=> '',
		'isotope_line_count'		=> '',
		'isotope_col_count'			=> '',
		'chars_count'				=> '',
		'add_divider'				=> '',
		'filter_vals'				=> '',
		'hover_bg_color'			=> '',
		'proc_atts'					=> '',
		'bg_hover_color'			=> '',
		'custom_title_color'		=> '',
		'cws_gradient_color_from'   => '',
		'cws_gradient_color_to'     => '',


	)));
	$not_in = ( 1 == $req_page ) ? array() : get_option( 'sticky_posts' );
	$query_args = array('post_type'			=> array( $post_type ),
						'post_status'		=> 'publish',
						'post__not_in'		=> $not_in
						);
	$query_args['posts_per_page']		= $items_pp;
	$query_args['paged']		= $page;
	if ( $current_filter_val != '_all_' && !empty( $current_filter_val ) ){
		$terms = array( $current_filter_val );
	}
	if ( !empty( $terms ) ){
		$query_args['tax_query'] = array(
			array(
				'taxonomy'		=> $tax,
				'field'			=> 'slug',
				'terms'			=> $terms
			)
		);
	}
	if ( in_array( $post_type, array( "cws_portfolio", "cws_staff", "cws_testimonial", "tribe_events", "cws_classes" ) ) ){
		if (!empty($sort_by) && !empty($sorting)){
			$query_args['orderby'] 	= $sort_by;
			$query_args['order']	= $sorting;	
		} else {
			$query_args['orderby'] 	= "menu_order date title";
			$query_args['order']	= "ASC";
		}
	}
	$query_args = array_merge( $query_args, $addl_query_args );
	$q = new WP_Query( $query_args );
	$found_posts = $q->found_posts;
	$max_paged = $found_posts > $total_items_count ? ceil( $total_items_count / $items_pp ) : ceil( $found_posts / $items_pp );
	$is_pagination = $max_paged > 1;
	$GLOBALS['cws_vc_shortcode_posts_grid_atts'] = array(
		'post_type'						=> $post_type,
		'layout'						=> $layout,
		'customize_colors'				=> $customize_colors,
		'custom_color'					=> $custom_color,
		'font_color'					=> $font_color,
		'bg_color'						=> $bg_color,
		'sb_layout'						=> $sb_layout,
		'massonry'						=> $massonry,
		'post_hide_meta'				=> $post_hide_meta,
		'cws_portfolio_data_to_show'	=> $cws_portfolio_data_to_show,
		'cws_classes_data_to_show'		=> $cws_classes_data_to_show,
		'cws_staff_data_to_hide'		=> $cws_staff_data_to_hide,
		'cws_testimonial_data_to_hide'	=> $cws_testimonial_data_to_hide,
		'crop_images'					=> $crop_images,
		'sort_by'						=> $sort_by,
		'sorting'						=> $sorting,					
		'total_items_count'				=> $total_items_count,
		'pagination_grid'				=> $pagination_grid,
		'full_width'					=> $full_width,
		'info_align'					=> $info_align,
		'aligning'						=> $aligning,
		'display_style'					=> $display_style,
		'portfolio_style'				=> $portfolio_style,
		'info_pos'						=> $info_pos,
		'masonry'						=> $masonry,
		'anim_style'					=> $anim_style,
		'item_shadow'					=> $item_shadow,
		'en_hover_color'				=> $en_hover_color,
		'huge_layout'					=> $huge_layout,
		'en_cat_color'					=> $en_cat_color,
		'hover_color'					=> $hover_color,
		'title_color'					=> $title_color,
		'cat_color'						=> $cat_color,
		'appear_style'					=> $appear_style,
		'link_show'						=> $link_show,
		'isotope_line_count'			=> $isotope_line_count,
		'isotope_col_count'				=> $isotope_col_count,
		'chars_count'					=> $chars_count,
		'add_divider'					=> $add_divider,
		'filter_vals'					=> $filter_vals,
		'tax'							=> $tax,
		'hover_bg_color'				=> $hover_bg_color,
		'proc_atts'						=> $proc_atts,
		'bg_hover_color'				=> $bg_hover_color,
		'custom_title_color'			=> $custom_title_color,
		'cws_gradient_color_from'   	=> $cws_gradient_color_from,
		'cws_gradient_color_to'     	=> $cws_gradient_color_to
	);

	if ($post_type == 'post'){
		cws_blog_posts($q);
	} elseif ( function_exists( "cws_vc_shortcode_{$post_type}_posts_grid_posts" ) ){
		call_user_func_array( "cws_vc_shortcode_{$post_type}_posts_grid_posts", array( $q ) );
	}	
	
	if ( $is_pagination ){
		if ( $pagination_grid == 'load_more' ){
			echo cws_load_more ();
		}
		else{
			echo cws_pagination ( $page, $max_paged,true );
		}
	}
	unset ( $GLOBALS['cws_vc_shortcode_posts_grid_atts'] );
	wp_die();
}
add_action( 'wp_ajax_cws_vc_shortcode_posts_grid_dynamic_filter', 'cws_vc_shortcode_posts_grid_dynamic_filter' );
add_action( 'wp_ajax_nopriv_cws_vc_shortcode_posts_grid_dynamic_filter', 'cws_vc_shortcode_posts_grid_dynamic_filter' );

/****************** \POSTS GRID AJAX ******************/

function cws_portfolio_single(){
	$data = isset( $_POST['data'] ) ? $_POST['data'] : array();
	extract( shortcode_atts( array(
			'initial_id' => '',
			'requested_id' => ''
		), $data));
	if ( empty( $initial_id ) || empty( $requested_id ) ) die();

	$pid = $requested_id;
	$post_meta = get_post_meta( $pid, 'cws_mb_post' );
	$post_meta = isset( $post_meta[0] ) ? $post_meta[0] : array();
	$full_width = isset( $post_meta['full_width'] ) ? $post_meta['full_width'] : "";	
	
	ob_start();
		cws_vc_shortcode_cws_portfolio_single_post_post_media ($requested_id);
	$media = ob_get_clean();
	if ( !empty($full_width) ) {
		echo "<div class='cws_ajax_response_media_full'>";
			echo "<div class='cws_ajax_media'>";
				echo $media;
			echo "</div>";
		echo "</div>";
	}

	echo "<div class='cws_ajax_response'>";
		$pid = $requested_id;
		echo "<article id='cws_portfolio_post_{$pid}' class='cws_portfolio_post post_single item clearfix'>";
		if ( empty($full_width) ) {
			ob_start();
			cws_vc_shortcode_cws_portfolio_single_post_post_media ($requested_id);
			$media = ob_get_clean();
			$floated_media = isset( $GLOBALS['cws_vc_shortcode_cws_portfolio_single_post_floated_media'] ) ? $GLOBALS['cws_vc_shortcode_cws_portfolio_single_post_floated_media'] : false;
			unset( $GLOBALS['cws_vc_shortcode_cws_portfolio_single_post_floated_media'] );
			if ( $floated_media ){
				echo "<div class='floated_media cws_portfolio_floated_media single_post_floated_media'>";
				echo "<div class='floated_media_wrapper cws_portfolio_floated_media_wrapper single_post_floated_media_wrapper'>";
				echo $media;
				echo "</div>";
				echo "</div>";						
			}
			else{
				echo $media;
			}
		}
		ob_start();
		cws_vc_shortcode_cws_portfolio_single_post_title ( $pid );
		cws_vc_shortcode_cws_portfolio_single_post_content ($pid);
		$content_terms = ob_get_clean();
		if ( !empty( $content_terms ) ){
			if ( $floated_media ){
				echo "<div class='clearfix'>";
				echo $content_terms;
				echo "</div>";
			}
			else{
				echo $content_terms;
			}
		}
		echo "</article>";
	echo "</div>";
	die();
}
add_action( "wp_ajax_cws_portfolio_single", "cws_portfolio_single" );
add_action( "wp_ajax_nopriv_cws_portfolio_single", "cws_portfolio_single" );

function cws_classes_single(){
	$data = isset( $_POST['data'] ) ? $_POST['data'] : array();
	extract( shortcode_atts( array(
			'initial_id' => '',
			'requested_id' => ''
		), $data));
	if ( empty( $initial_id ) || empty( $requested_id ) ) die();

	echo "<div class='cws_ajax_response'>";
		$pid = $requested_id;
		$post_meta = get_post_meta( $pid, 'cws_mb_post' );
		$post_meta = isset( $post_meta[0] ) ? $post_meta[0] : array();
		$price = isset( $post_meta['price'] ) ? $post_meta['price'] : '';
		$date_events = isset( $post_meta['date_events'] ) ? $post_meta['date_events'] : '';
		$destinations = isset( $post_meta['destinations'] ) ? $post_meta['destinations'] : '';
		$time_events = isset( $post_meta['time_events'] ) ? $post_meta['time_events'] : '';
		if(!empty($price)){
			preg_match('/(.*[^0-9])(\d+)([\.,]\d+)/', $price, $matches);
			list(, $currency, $price, $pfraction) = $matches;
		}
		echo "<article id='cws_classes_post_{$pid}' class='cws_classes_post post_single item clearfix'>";
		ob_start();
		cws_vc_shortcode_cws_classes_single_post_post_media ($requested_id);
		$media = ob_get_clean();
		$floated_media = isset( $GLOBALS['cws_vc_shortcode_cws_classes_single_post_floated_media'] ) ? $GLOBALS['cws_vc_shortcode_cws_classes_single_post_floated_media'] : false;
		unset( $GLOBALS['cws_vc_shortcode_cws_classes_single_post_floated_media'] );
		if ( $floated_media ){
			echo "<div class='floated_media cws_classes_floated_media single_post_floated_media'>";
			echo "<div class='floated_media_wrapper cws_classes_floated_media_wrapper single_post_floated_media_wrapper'>";
			echo $media;
			echo "</div>";
			echo "</div>";						
		}
		else{
			echo $media;
		}

		ob_start();
		echo "<div class='wrap_title'>";
		echo "<div class='title_single_classes'>";
		cws_vc_shortcode_title($pid);
		echo "</div>";
		if(!empty($price)){
			echo "<div class='price_single_classes'>";
			echo "<span class='currency_price'>";
				echo esc_html($currency);
			echo "</span>";
			echo "<span class='price'>";
				echo esc_html($price);
			echo "</span>";
			echo "<span class='pfraction'>";
				echo esc_html($pfraction);
			echo "</span>";
			echo "</div>";						
		}
		echo "</div>";
		if(!empty($date_events)){
			echo "<div class='date_ev_single_classes'>";
			echo esc_html($date_events);
			echo "</div>";								
		}
		if(!empty($time_events) || !empty($destinations)){
			echo "<div class='wrap_desc_info'>";
			if(!empty($time_events)){
				echo "<div class='time_ev_single_classes'>";
					echo esc_html($time_events);
				echo "</div>";								
			}
			if(!empty($destinations)){
				echo "<div class='destinations_single_classes'>";
					echo esc_html($destinations);
				echo "</div>";	
			}
			echo "</div>";
		}

		cws_vc_shortcode_cws_classes_single_post_content ($pid);
		cws_vc_shortcode_cws_classes_teacher ($pid);
		$content_terms = ob_get_clean();
		if ( !empty( $content_terms ) ){
			if ( $floated_media ){
				echo "<div class='clearfix'>";
				echo $content_terms;
				echo "</div>";
			}
			else{
				echo $content_terms;
			}
		}
		echo "</article>";
	echo "</div>";
	die();
}
add_action( "wp_ajax_cws_classes_single", "cws_classes_single" );
add_action( "wp_ajax_nopriv_cws_classes_single", "cws_classes_single" );

function cws_vc_shortcode_single_portfolio_ajax_load () {
	$query_args = array('post_type'			=> 'cws_portfolio',
						'p' 				=> $_POST['post_id']
						);
	$post_query = new WP_Query( $query_args );
	while( $post_query->have_posts() ) : $post_query->the_post();

		$sb = cws_vc_shortcode_render_sidebars( get_queried_object_id() );
		$fixed_header = cws_get_meta_option( 'fixed_header' );
		$class = $sb['layout_class'].' '. $sb['sb_class'];
		$sb['sb_class'] = apply_filters('cws_print_single_class', $class);

		$p_id = get_queried_object_id ();
		$post_meta = get_post_meta( get_the_ID(), 'cws_mb_post' );
		$post_meta = isset( $post_meta[0] ) ? $post_meta[0] : array();
		$def_row_fw_atts = array(
						'full_width'				=> false,
					);
		$shot = isset( $GLOBALS['cws_row_atts'] ) ? $GLOBALS['cws_row_atts'] : $def_row_fw_atts;
		extract($shot);
		extract( wp_parse_args( $post_meta, array(
			'show_related' 		=> false,
			'rpo_title'			=> '',
			'rpo_cols'			=> '4',
			'carousel'			=> false,
			'img_size'			=> '1',
			'rpo_items_count'	=> get_option( 'posts_per_page' ),
		)));
		if ($full_width == 'stretch_row_content' || $full_width == 'stretch_row_content_no_spaces') {
			$full_width = true;
		}else{
			$full_width = '';
		} 
		$ajax_width = 1920;
		$show_related = isset( $post_meta['show_related'] ) ? $post_meta['show_related'] : false;
		$rpo_title = isset( $post_meta['rpo_title'] ) ? esc_html( $post_meta['rpo_title'] ) : "";
		$rpo_items_count = isset( $post_meta['rpo_items_count'] ) ? esc_textarea( $post_meta['rpo_items_count'] ) : esc_textarea( get_option( "posts_per_page" ) );
		$rpo_cols = isset( $post_meta['rpo_cols'] ) ? esc_textarea( $post_meta['rpo_cols'] ) : 4;
		$title = get_the_title();
		ob_start();
		cws_vc_shortcode_cws_portfolio_single_post_post_media ();
		$media = ob_get_clean();
		$floated_media = isset( $GLOBALS['cws_vc_shortcode_cws_portfolio_single_post_floated_media'] ) ? $GLOBALS['cws_vc_shortcode_cws_portfolio_single_post_floated_media'] : false;
		unset( $GLOBALS['cws_vc_shortcode_cws_portfolio_single_post_floated_media'] );
		if ( $img_size == 2 ) {
			echo $media;
		}

		echo (isset($sb['content']) ? $sb['content'] : '');
		$GLOBALS['cws_vc_shortcode_single_ajax_atts'] = array(
			'sb_layout'						=> $sb_layout_class,
			'display_style'					=> 'showcase',
		);
		$pid = get_the_id();
		echo "<div id='cws_portfolio_post_{$pid}' class='cws_portfolio_post post_single clearfix'>";
			ob_start();
			cws_vc_shortcode_cws_portfolio_single_post_post_media (false,$ajax_width);
			$media = ob_get_clean();
			$floated_media = isset( $GLOBALS['cws_vc_shortcode_cws_portfolio_single_post_floated_media'] ) ? $GLOBALS['cws_vc_shortcode_cws_portfolio_single_post_floated_media'] : false;
			unset( $GLOBALS['cws_vc_shortcode_cws_portfolio_single_post_floated_media'] );
			if ( $img_size == 1 ) {
				if ( $floated_media ){
					echo "<div class='floated_media cws_portfolio_floated_media single_post_floated_media'>";
						echo "<div class='floated_media_wrapper cws_portfolio_floated_media_wrapper single_post_floated_media_wrapper'>";
							echo $media;
						echo "</div>";
					echo "</div>";						
				}
				else{
					echo $media;
				}
			}
			ob_start();
			cws_vc_shortcode_cws_portfolio_single_post_terms ();
			cws_vc_shortcode_cws_portfolio_single_post_content ();
			$content_terms = ob_get_clean();
			echo "<div class='container'>";
				if ( !empty( $content_terms ) ){
					if ( $floated_media && $img_size == 1 ){
						echo "<div class='clearfix floated_media_content cws_portfolio_single_content'>";
							echo $content_terms;
						echo "</div>";
					}
					else{
						echo "<div class='cws_portfolio_single_content'>";
							echo $content_terms;
						echo "</div>";
					}
				}

				if ( wp_get_referer() )
				{
					$previous = wp_get_referer();
					echo "<div class='back_link_case'><a href='$previous'><i class='flaticon-left-arrow'></i>" . esc_html__('Back to Projects' , 'cws-essentials') . "</a></div>";
				}
			echo "</div>";
			global $cws_theme_funcs;
			cws_page_links();
		echo "</div>";
		wp_reset_postdata();
		unset( $GLOBALS['cws_vc_shortcode_single_post_atts'] );
		echo (isset($sb['content']) && !empty($sb['content']) ) ? '</div>' : '';
		if ( $show_related ){
			$terms = wp_get_post_terms( $p_id, 'cws_portfolio_cat' );
			$term_slugs = array();
			for ( $i=0; $i < count( $terms ); $i++ ){
				$term = $terms[$i];
				$term_slug = $term->slug;
				array_push( $term_slugs, $term_slug );
			}
			$term_slugs = implode( ",", $term_slugs );
			if ( !empty( $term_slugs ) ){
				$rp_args = array(
					'title'							=> $rpo_title,
					'post_type'						=> 'cws_portfolio',
					'total_items_count'				=> $rpo_items_count,
					'display_style'					=> 'carousel',
					'cws_portfolio_layout_override'	=> true,
					'cws_portfolio_layout'			=> $rpo_cols,
					'tax'							=> 'cws_portfolio_cat',
					'terms'							=> $term_slugs,
					'addl_query_args'				=> array(
						'post__not_in'					=> array( $p_id ),
					),
				);
				$related_projects = cws_vc_shortcode_posts_grid( $rp_args );
				if ( !empty( $related_projects ) ){
					echo "<hr />";
					echo $related_projects;
				}
			}
		}
	endwhile;
	exit;
}
add_action ( 'wp_ajax_cws_vc_shortcode_single_portfolio_ajax_load', 'cws_vc_shortcode_single_portfolio_ajax_load' );
add_action ( 'wp_ajax_nopriv_cws_vc_shortcode_single_portfolio_ajax_load', 'cws_vc_shortcode_single_portfolio_ajax_load' );

add_action ( 'wp_ajax_cws_vc_shortcode_page_load', 'cws_vc_shortcode_page_load' );
add_action ( 'wp_ajax_nopriv_cws_vc_shortcode_page_load', 'cws_vc_shortcode_page_load' );

function cws_vc_shortcode_page_load(){
	$data = isset( $_POST['data'] ) ? $_POST['data'] : array();
	echo "<div class='cws_ajax_response'>";

	$sb = cws_vc_shortcode_render_sidebars( get_queried_object_id() );
	$fixed_header = cws_get_meta_option( 'fixed_header' );
	$class = $sb['layout_class'].' '. $sb['sb_class'];
	$sb['sb_class'] = apply_filters('cws_print_single_class', $class);

	echo '<div class="'.(isset($sb['sb_class']) ? $sb['sb_class'] : '').'">';
		echo (isset($sb['content']) ? $sb['content'] : ''); 
		echo '<main'.($fixed_header == '1' ? ' class="header_shadow"' : '').' >';
			echo apply_filters('the_content', get_post_field('post_content', 40));

				$is_blog = cws_get_meta_option( 'is_blog' ) == '1';
				if ( $is_blog ) get_template_part( 'content', 'blog' );
				comments_template();
		
		echo '</main>';
		echo (isset($sb['content']) && !empty($sb['content']) ) ? '</div>' : '';
	echo '</div>';
	echo "</div>";
	die();
}

if(!function_exists('essentials_register_scripts')){
	function essentials_register_scripts (){
		$js_path = plugin_dir_url( __FILE__ ) . 'assets/js/';

		$common_scripts = array( 
			'jquery-ajax-shortcode'   => array('ajax_plugin.js', true),
			'jquery-shortcode-velocity'  => array('velocity.min.js', false),
			'jquery-shortcode-velocity-ui' => array('velocity.ui.min.js', false)
		);

		foreach ($common_scripts as $alias => $value) {

			list($path, $enqueue) = $value;
			if ($path) {
				$path = (0 === strrpos($path, 'http')) ? $path : $js_path . $path;
			}

			if ($enqueue){
				wp_enqueue_script( $alias, $path, array( 'jquery' ), '', true );
			} else {
				wp_register_script( $alias, $path, array( 'jquery' ), '', true );
			}

		}

		wp_localize_script('jquery-ajax-shortcode', 'cws_vc_sh', array(
			'ajax_nonce' => wp_create_nonce('cws_vc_sh_nonce'),
		)); 

		wp_register_style ( 'cws_front_css',  plugin_dir_url( __FILE__ ) . '/assets/css/main.css' );   
		wp_enqueue_style ( 'cws_front_css' );  
	} 
}
add_action( 'wp_enqueue_scripts', 'essentials_register_scripts' );

if(!function_exists('cws_vc_shortcode_render_sidebars')){
	function cws_vc_shortcode_render_sidebars($pid) {
		// !!! this must be in superclass
		$out = '';
		$sb = cws_vc_shortcode_get_sidebars( $pid );

		$layout_class = $sb && $sb['layout_class'] != 'none' ? $sb['layout_class'].'_sidebar' : '';
		$sb1_class = $sb && $sb['layout'] == 'right' ? 'sb_right' : 'sb_left';
		$sbl = $sb['sbl'];
		if ( $sbl ){
			$out .= '<div class="container">';
			if ( !empty($sb['sb1']) ) {
				$out .= sprintf('<aside class="%s">', sanitize_html_class($sb1_class));
				ob_start();
					dynamic_sidebar( $sb['sb1'] );
				$out .= ob_get_clean();
				$out .= '</aside>';
			}
			if ( !empty($sb['sb2']) ){
				$out .= '<aside class="sb_right">';
				ob_start();
					dynamic_sidebar( $sb['sb2'] );
				$out .= ob_get_clean();
				$out .= '</aside>';
			}
		}
		return array(
			'layout_class' => $layout_class,
			'sb_class' => $sb1_class,
			'content' => $out,
		);
	}
}

if(!function_exists('cws_vc_shortcode_get_option')){
	function cws_vc_shortcode_get_option($name){
		$ret = null;
		if (is_customize_preview()) {
			global $cwsfw_settings;
			if (isset($cwsfw_settings[$name])) {
				$ret = $cwsfw_settings[$name];
				if (is_array($ret)) {
					$theme_options = get_option( THEME_SLUG );
					if (isset($theme_options[$name])) {
						$to = $theme_options[$name];
						foreach ($ret as $key => $value) {
							$to[$key] = $value;
						}
						$ret = $to;
					}
				}
				return $ret;
			}
		}
		$theme_options = get_option( THEME_SLUG );
		$ret = isset($theme_options[$name]) ? $theme_options[$name] : null;
		$ret = stripslashes_deep( $ret );
		return $ret;
	}
}

if(!function_exists('cws_vc_shortcode_get_post_term_links_str')){
	function cws_vc_shortcode_get_post_term_links_str ( $tax = "", $delim = "", $show_url = false ){
		$pid = get_the_id();
		$terms_arr = wp_get_post_terms( $pid, $tax );
		$terms = "";
		if ( is_wp_error( $terms_arr ) ){
			return $terms;
		}
		for( $i = 0; $i < count( $terms_arr ); $i++ ){
			$term_obj	= $terms_arr[$i];
			$term_slug	= $term_obj->slug;
			$term_name	= esc_html( $term_obj->name );
			if($show_url){
				$term_link	= esc_url( get_term_link( $term_slug, $tax ) );
				$terms		.= "<a href='$term_link'>$term_name</a>" . ( $i < ( count( $terms_arr ) - 1 ) ? $delim : "" );				
			} else {
				$terms		.= "<span>$term_name</span>" . ( $i < ( count( $terms_arr ) - 1 ) ? $delim : "" );
			}
		}
		return $terms;
	}
}

if(!function_exists('cws_print_img_html')){
	function cws_print_img_html($img, $img_args, &$img_height = null) {
		$src = '';
		$img_h = 0;

		if ($img && !is_array($img) ) {
			$attach = wp_get_attachment_image_src( $img, 'full' );
			if ($attach) {
				list($src, $width, $height) = $attach;
				$img = array('src'=> $src, 'width' => $width, 'height' => $height, 'is_high_dpi' => '1', 'id' => $img);
			} else {
				return $src;
			}
		} else if ($img && !isset($img['is_high_dpi'] ) ) {
			$img['is_high_dpi'] = '1';
		} else if (empty($img['width']) && empty($img['height'])) {
			$attach = wp_get_attachment_image_src( $img['id'], 'full' );
			if ($attach) {
				list($src, $width, $height) = $attach;
				$img['width'] = $width;
				$img['height'] = $height;
			}
		}

		$is_high_dpi = (isset($img['is_high_dpi']) && $img['is_high_dpi'] == '1');

		if ( $is_high_dpi ) {
			if ( empty($img_args['width']) && empty($img_args['height']) ) {
				if (isset($img['width']) && isset($img['height'])) {
					$img_args = array(
						'width' => floor( (int) $img['width'] / 2 ),
						'height' => floor( (int) $img['height'] / 2 ),
						'crop' => true,
						);
				}
			}

			$thumb_obj = cws_thumb( isset($img['id']) ? $img['id'] : $img['src'], $img_args );
			if ($thumb_obj) {
				$img_h = !empty($img_args["height"]) ? $img_args["height"] : '';
				$thumb_path_hdpi = !empty($thumb_obj[3]) ? " src='". esc_url( $thumb_obj[0] ) ."' data-at2x='" . esc_attr( $thumb_obj[3] ) ."'" : " src='". esc_url( $thumb_obj[0] ) . "' data-no-retina";
				$src = $thumb_path_hdpi;
			}
		} else {
			$img_h = $img['height'];
			$src = " src='".esc_url( $img['src'] )."' data-no-retina";
		}
		if ($img_height) {
			$img_height = $img_h;
		}
		return $src;
	}
}

if(!function_exists('cws_get_meta_option')){
	function cws_get_meta_option($name = '', $check_first_key = false) {
		global $cws_theme_funcs;
		$value = '';
		if(!empty($cws_theme_funcs)){
			$value = isset($cws_theme_funcs::$options[$name]) ? $cws_theme_funcs::$options[$name] : null;
			while (is_string($value) && '{' === substr($value, 0, 1)) {
				$g_name = substr($value, 1, -1);
				$value = isset($cws_theme_funcs::$options[$g_name]) ? $cws_theme_funcs::$options[$g_name] : null;
			}
			if ($check_first_key && is_array($value)) {
				// it's better to set $check_first_key specifically when there's a chance
				// like in case of sidebars processing
				// check if need to replace value with theme option array
				reset($value);
				$first_key = key($value);
				$val = $value[$first_key];
				if (is_string($val) && '{' === substr($val, 0, 1)) {
					$g_name = substr($val, 1, -1);
					$value = isset($cws_theme_funcs::$options[$g_name]) ? $cws_theme_funcs::$options[$g_name] : null;
				}
			}
		}

		return $value;
				
	}
}

if(!function_exists('cws_vc_shortcode_get_sidebars')){
	function cws_vc_shortcode_get_sidebars( $p_id = null ) { /*!*/
		$page_type = 'page';
		$sb = null;
		$post_type = get_post_type($p_id);
		if ($p_id && !is_home() ) {
			switch ($post_type) {
				case 'page':	
				$page_type = 'page';
				break;
				case 'post':
				case 'attachment':
				case 'cws_portfolio':
				case 'cws_staff':
				$page_type = 'post';
				break;
			}
		} else if (is_home()) {
			/* default home page have no ID */
			$page_type = 'home';
		}

		if (!$sb) {
			$sb = cws_get_meta_option("{$page_type}_sidebars", true);
		}

		if ($sb){
		$ret = $sb;

		$sb_enabled = isset($sb['layout']) && $sb['layout'] != 'none';
		$sbl = 0;
		if ($sb_enabled) {
			$sbl = (int)!empty($sb['sb1']) | ((int)!empty($sb['sb2'])*2);
		}
		$class = '';
		switch ($sbl) {
			case 1:
			case 2:
			$class = 'single';
			break;
			case 3:
			$class = 'double';
			break;
		}

		$ret['layout_class'] = $class;
		$ret['sbl'] = $sbl;
		return $ret;
	}

	}
}


// require_once( CWS_SHORTCODES_PLUGIN_DIR . '/templates-modules/cws_sc_blog.php' );
require_once( CWS_SHORTCODES_PLUGIN_DIR . '/templates-modules/cws_sc_portfolio.php' );
require_once( CWS_SHORTCODES_PLUGIN_DIR . '/templates-modules/cws_sc_staff.php' );

// Uncomment this line to activate Testimonials
// require_once( CWS_SHORTCODES_PLUGIN_DIR . '/templates-modules/cws_sc_testimonials.php' );

// Uncomment this line to activate Classes
// require_once( CWS_SHORTCODES_PLUGIN_DIR . '/templates-modules/cws_sc_classes.php' );

require_once( CWS_SHORTCODES_PLUGIN_DIR . '/templates-modules/cws_sc_events.php' );

add_action('wp_ajax_cws_vc_shortcode_tribe_events_posts_grid', 'cws_vc_shortcode_tribe_events_posts_grid');
add_action( 'wp_ajax_nopriv_cws_vc_shortcode_tribe_events_posts_grid', 'cws_vc_shortcode_tribe_events_posts_grid' );

function cws_vc_shortcode_msg_box ( $atts = array(), $content = "" ){
	$body_font_options 		= cws_vc_shortcode_get_option( 'body_font' );
	$body_font_color 		= esc_attr( $body_font_options['color'] );
	extract( shortcode_atts( array(
		'type'					=> 'success',
		'title'					=> '',
		'text'					=> '',
		'is_closable'			=> '',
		'customize'				=> '',
		'icon_lib'				=> '',
		'custom_fill_color'		=> '#e6eaed',
		'custom_font_color'		=> $body_font_color,
		"css_animation"			=> "none",
		'el_class'				=> ''
	), $atts));
	$out = "";
	$type 			= esc_html( $type );
	$is_closable 	= (bool)$is_closable;
	$customize 		= (bool)$customize;
	$icon_lib 		= esc_attr( $icon_lib );
	$icon 			= function_exists('cws_ext_vc_sc_get_icon') ? cws_ext_vc_sc_get_icon( $atts ) : "";
	$el_class 		= esc_attr( $el_class );
	$content 		= !empty( $text ) ? $text : $content;
	$section_id 	= uniqid( "cws_vc_shortcode_msg_box_" );
	ob_start();
	if ( $customize ){
		echo !empty( $custom_font_color ) ? "color: $custom_font_color;" : "";
	}
	$section_styles = ob_get_clean();
	ob_start();
	if ( $customize ){
		echo "
			#{$section_id},
			#{$section_id} .icon_part:before{
   				" . (!empty($custom_fill_color) ? 'background-color: '.$custom_fill_color.' !important' : '') . ";
			} ";
		echo "
			#{$section_id} .close_button,
			#{$section_id} .icon_part,
			#{$section_id} .content_part p,
			#{$section_id} .title{
   				" . (!empty($custom_font_color) ? 'color: '.$custom_font_color.' !important' : '') . ";
			} ";
	}
	$styles = ob_get_clean();
	if ( !empty( $styles ) ){
		Cws_shortcode_css()->enqueue_cws_css($styles);
	}
	$icon_class = "msg_icon";
	$icon_html = "";
	if ( $customize && !empty( $icon ) ){
		if ( function_exists( 'vc_icon_element_fonts_enqueue' ) ){
			vc_icon_element_fonts_enqueue( $icon_lib );
		}
		if($icon_lib == 'cws_svg'){
			$svg_icon = json_decode(str_replace("``", "\"", $icon), true);
			$upload_dir = wp_upload_dir();
			$this_folder = $upload_dir['basedir'] . '/cws-svgicons/' . md5($svg_icon['collection']) . '/';				
			$icon_html .= '<i class="svg" style="width:'.$svg_icon['width'].'px;height:'.$svg_icon['height'].'px">'.file_get_contents($this_folder . $svg_icon['name']).'</i>';
		}else{
			$icon_class .= " $icon custom";
		}
		
	}

	$animation = cwsCSSAnimation($css_animation);

	if ( !empty( $title ) || !empty( $content ) ){
		$out .= "<div id='$section_id' class='cws_vc_shortcode_msg_box cws_vc_shortcode_module". $animation . ( !empty( $type ) ? " $type" : "" ) . ( $is_closable ? " closable" : "" ) . ( !empty( $el_class ) ? " $el_class" : "" ) . "'" . ( !empty( $section_styles ) ? " style='$section_styles'" : "" ) . ">";
			$out .= "<div class='icon_part".($icon_lib == 'cws_svg' ? " svg_icon" : "")."'>";
				if($icon_lib == 'cws_svg'){
					$out .= $icon_html;
				}else{
					$out .= "<i class='$icon_class'></i>";
				}
				
			$out .= "</div>";
			$out .= "<div class='content_part'>";
				$out .= !empty( $title ) ? "<h3 class='title'>$title</h3>" : "";
				$out .= !empty( $content ) ? "<p>$content</p>" : "";
			$out .= "</div>";
			$out .= $is_closable ? "<a class='close_button'></a>" : "";
		$out .= "</div>";
	}
	return $out;
}

add_shortcode( 'cws_sc_msg_box', 'cws_vc_shortcode_msg_box' );

add_shortcode( 'cws_sc_portfolio_posts_grid', 'cws_vc_shortcode_cws_portfolio_posts_grid' );

// Uncomment this line to activate Classes
// add_shortcode( 'cws_sc_classes_posts_grid', 'cws_vc_shortcode_cws_classes_posts_grid' );

// Uncomment this line to activate Testimonials
// add_shortcode( 'cws_sc_testimonial_posts', 'cws_vc_shortcode_cws_testimonial_posts_grid' );

add_shortcode( 'cws_sc_staff_posts_grid', 'cws_vc_shortcode_cws_staff_posts_grid' );

add_shortcode( 'cws_sc_events_posts_grid', 'cws_vc_shortcode_tribe_events_posts_grid' );

function cws_vc_shortcode_sc_vc_blog ( $atts = array(), $content = "" ){
	$post_type = "post";
/*	$def_blog_layout = cws_vc_shortcode_get_option( 'def_blog_layout' );
	$def_blog_layout = isset( $def_blog_layout ) ? $def_blog_layout : "";
	$def_chars_count = cws_vc_shortcode_get_option( 'def_blog_chars_count' );
	$def_chars_count = isset( $def_chars_count ) && is_numeric( $def_chars_count ) ? $def_chars_count : '200';
	$defaults = array(
		'title'						=> '',
		'title_align'				=> 'left',
		'content_align'				=> 'top',
		'no_spacings'				=> false,
		'total_items_count'			=> '',
		'layout'					=> $def_blog_layout,
		'post_hide_meta_override'	=> false,
		'post_hide_meta'			=> '',
		'chars_count'				=> $def_chars_count,
		'display_style'				=> 'grid',
		'items_pp'					=> esc_html( get_option( 'posts_per_page' ) ),
		'el_class'					=> '',
		'auto_play_carousel'        => '',
		'navigation_carousel'       => '',
		'hover_effects'				=> '',
		'date_container'			=> 'outside',
		'hover_color'				=> 'rgba(0,0,0,0.5)',
		'pagination_carousel'       => '',
		'link_show'      			=> '',
		'pagination_grid'       	=> '',
		'aligning'      			=> 'center',
		'hover_effects_more_btn'    => 'style_1',
	);*/
	$defaults = cws_blog_defaults();
	$proc_atts = shortcode_atts( $defaults, $atts );
	extract( $proc_atts );
	$out = "";
	$tax = isset( $atts[$post_type . '_tax'] ) ? $atts[$post_type . '_tax'] : '';
	$terms = isset( $atts["{$post_type}_{$tax}_terms"] ) ? $atts["{$post_type}_{$tax}_terms"] : "";
	$proc_atts = array_merge( $proc_atts, array(
		'post_hide_meta_override'				=> $post_hide_meta_override,
		'post_hide_meta'						=> $post_hide_meta,
		'tax'									=> $tax,
		'terms'									=> $terms
	));
	$out .= function_exists( "cws_sc_blog" ) ? cws_sc_blog( $proc_atts ) : "";
	return $out;
}
add_shortcode( 'cws_sc_vc_blog', 'cws_vc_shortcode_sc_vc_blog' );
add_shortcode( 'cws_sc_blog', 'cws_sc_blog' );


function cws_vc_shortcode_carousel ( $atts, $content ){
	$theme_color 			= esc_attr( cws_vc_shortcode_get_option( 'theme-first-color' ) );
	$second_theme_color 			= esc_attr( cws_vc_shortcode_get_option( 'theme-second-color' ) );

	extract( shortcode_atts( array(
		'columns' 					=> '1',
		'custom_border' 			=> '',
		'bullets_nav' 				=> '',
		'arrows_nav' 				=> '',
		'arrows_on_hover' 			=> true,
		'customize_colors'			=> false,
		'background_color'		 	=> '',
		'custom_pagination_color' 	=> $second_theme_color,
		'custom_arrow_color' 		=> '',
		'carousel_paddings' 		=> '0px 0px 0px 0px',
		'margins_pagination' 		=> '',
		"css_animation"				=> "none",
	), $atts));

	$arrows_on_hover 	= (bool)$arrows_on_hover;
	$carousel_paddings 	= esc_attr($carousel_paddings);
	$customize_colors	= (bool)$customize_colors;

	$section_class = "cws_vc_shortcode_sc_carousel cws_sc_carousel cws_vc_shortcode_module";
	$section_class .= $arrows_on_hover ? " arrows_on_hover" : " arrows_default";
	$section_class .= !empty($arrows_nav) ? " arrows_nav" : "";
	$section_class .= !empty($bullets_nav) ? " bullets_nav" : "";
	$section_class .= !empty($custom_border) ? " custom_border" : "";
	$section_atts = " data-columns='$columns'";
	$out = "";
	$module_id 			= uniqid( "cws_vc_shortcode_carousel_" );

	ob_start();
	if ( $background_color ){
		echo "#{$module_id}{
   				background-color: $background_color;
			} ";
	}
	if ( $custom_pagination_color ){	
		echo "
			#{$module_id} .owl-pagination .owl-page.active:before,
			#{$module_id} .owl-pagination .owl-page:hover:before{
   				background-color: {$custom_pagination_color};
			}
		";	
	}
	if($custom_arrow_color){
		echo "#{$module_id} .carousel_nav_panel .prev,#{$module_id} .carousel_nav_panel .next{
   			border-color: {$custom_arrow_color};
		} ";
		echo "#{$module_id} .carousel_nav_panel .prev:before,#{$module_id} .carousel_nav_panel .next:before{
   			color: {$custom_arrow_color};
		} ";
		echo "#{$module_id} .carousel_nav_panel .prev:after,#{$module_id} .carousel_nav_panel .next:after{
   			background: {$custom_arrow_color};
		} ";
	}
	if(!empty($carousel_paddings)){
		echo "#{$module_id}{
   			padding: {$carousel_paddings};
		} ";
	}
	if(!empty($margins_pagination)){
		echo "#{$module_id} .owl-controls{
   			margin: {$margins_pagination};
		} ";
	}
	$styles = ob_get_clean();

	$animation = cwsCSSAnimation($css_animation);

	if ( !empty( $content ) ){
		$out .= "<div id='{$module_id}' class='$section_class $animation'" . ( !empty( $section_atts ) ? $section_atts : "" ) . ">";
			if ( !empty( $styles ) ){
				Cws_shortcode_css()->enqueue_cws_css($styles);
			}
			if ( !empty($arrows_nav) ){
				$out .= "<div class='carousel_nav_panel'>";
					$out .= "<span class='prev'></span>";
					$out .= "<span class='next'></span>";
				$out .= "</div>";
			}
			$out .= "<div class='cws_vc_shortcode_wrapper cws_wrapper'>";
				$out .= do_shortcode( $content );
			$out .= "</div>";
		$out .= "</div>";
	}
	wp_enqueue_script( 'owl_carousel' );
	return $out;
}
add_shortcode( 'cws_sc_carousel', 'cws_vc_shortcode_carousel' );

function cws_vc_shortcode_sc_icon ( $atts = array(), $content = "" ){
	$first_color = esc_attr( cws_vc_shortcode_get_option( 'theme-first-color' ) );
	$second_color = esc_attr( cws_vc_shortcode_get_option( 'theme-second-color' ) );
	$helper_color = esc_attr( cws_vc_shortcode_get_option( 'theme-helper-color' ) );

	extract( shortcode_atts( array(
		"icon"							=> "",
		"icon_lib"	 					=> "",
		"icon_url"	 					=> "",
		"icon_style"	 				=> "advanced",
		"icon_align"	 				=> "left",
		"icon_settings"	 				=> false,
		"icon_size"	 					=> "42px",
		"icon_hover_size"				=> "42px",
		"icon_color"	 				=> "#DCD0BF",
		"icon_hover_color"	 			=> $second_color,
		"icon_background"	 			=> false,
		"icon_bg_color"	 				=> $second_color,
		"icon_bg_hover_color"	 		=> "transparent",
		"icon_inner"	 				=> false,
		"inner_size"	 				=> "22px",
		"inner_hover_size"	 			=> "32px",
		"icon_inner_color"	 			=> "transparent",
		"icon_inner_hover_color"		=> "transparent",
		"icon_outer"	 				=> false,
		"outer_size"	 				=> "13px",
		"outer_hover_size"	 			=> "13px",
		"icon_outer_color"	 			=> $helper_color,
		"icon_outer_hover_color"		=> $helper_color,
		"css_animation"					=> "none",
		"el_class"	 					=> "",
	), $atts));

	$icon 							= function_exists('cws_ext_vc_sc_get_icon') ? cws_ext_vc_sc_get_icon( $atts ) : "";
	$icon_lib	 					= esc_attr( $icon_lib );
	$icon_url	 					= esc_attr( $icon_url );
	$icon_style	 					= esc_attr( $icon_style );
	$icon_align	 					= esc_attr( $icon_align );
	$icon_settings	 				= (bool)$icon_settings;
	$icon_size	 					= esc_attr( $icon_size );
	$icon_hover_size				= esc_attr( $icon_hover_size );
	$icon_color	 					= esc_attr( $icon_color );
	$icon_hover_color	 			= esc_attr( $icon_hover_color );
	$icon_background	 			= (bool)$icon_background;
	$icon_bg_color	 				= esc_attr( $icon_bg_color );
	$icon_bg_hover_color	 		= esc_attr( $icon_bg_hover_color );
	$icon_inner	 					= (bool)$icon_inner;
	$inner_size	 					= esc_attr( $inner_size );
	$inner_hover_size	 			= esc_attr( $inner_hover_size );
	$icon_inner_color	 			= esc_attr( $icon_inner_color );
	$icon_inner_hover_color			= esc_attr( $icon_inner_hover_color );
	$icon_outer	 					= (bool)$icon_outer;
	$outer_size	 					= esc_attr( $outer_size );
	$outer_hover_size	 			= esc_attr( $outer_hover_size );
	$icon_outer_color	 			= esc_attr( $icon_outer_color );
	$icon_outer_hover_color			= esc_attr( $icon_outer_hover_color );
	$el_class	 					= esc_attr( $el_class );

	$out = "";
	$classes = "";
	$icon_id = uniqid( "cws_vc_shortcode_icon_" );

	if ( empty( $icon ) ) return $out;

	if ( function_exists( 'vc_icon_element_fonts_enqueue' ) ){
		vc_icon_element_fonts_enqueue( $icon_lib );
	}

	//Icon Styles
	ob_start();

	//Advanced Icon Module Properties
	if( $icon_style == 'advanced' ){
		$inner_icon_size = ((int)$icon_size + 50);

		echo "
			#$icon_id .icon_holder{
				height: ".$inner_icon_size."px;
				width: ".$inner_icon_size."px;
				top: ".((int)$inner_size + (int)$outer_size)."px;
			}
			#$icon_id{
				min-height: ".($inner_icon_size + ((int)$inner_size * 2) + ((int)$outer_size * 2))."px;
			}
		";
	}

	//Advanced Icon Properties
	if( $icon_settings && $icon_style == 'advanced' ){
		if( !empty($icon_size) ){
			echo "
				#$icon_id .cws_sc_icon:before{
					font-size: ".(int)$icon_size."px;
				}
				#$icon_id .cws_sc_icon{
					width: ".$inner_icon_size."px;
					height: ".$inner_icon_size."px;
					line-height: ".$inner_icon_size."px;
				}
			";
		}
	}

	if( $icon_settings ){
		if( !empty($icon_size) ){
			echo "
				#$icon_id .cws_sc_icon:before{
					font-size: ".(int)$icon_size."px;
				}
			";
		}
		if( !empty($icon_hover_size) ){
			echo "
				#$icon_id .icon_holder:hover .cws_sc_icon:before{
					font-size: ".(int)$icon_hover_size."px;
				}
			";
		}
		if( !empty($icon_color) ){
			if( $icon_lib == 'cws_svg' ){
				echo "
					#$icon_id .svg{
						fill: ".$icon_color.";
					}
				";
			} else {
				echo "
					#$icon_id .cws_sc_icon{
						color: ".$icon_color.";
					}
				";
			}
		}
		if( !empty($icon_hover_color) ){
			if( $icon_lib == 'cws_svg' ){
				echo "
					#$icon_id .icon_holder:hover .svg{
						fill: ".$icon_hover_color.";
					}
				";
			} else {
				echo "
					#$icon_id .icon_holder:hover .cws_sc_icon{
						color: ".$icon_hover_color.";
					}
				";
			}
		}
	}

	//Advanced Icon Background Properties
	if( $icon_background && $icon_style == 'advanced' ){
		if( !empty($icon_bg_color) ){
			echo "
				#$icon_id .cws_sc_icon{
					background-color: ".$icon_hover_color.";
				}
			";
		}
		if( !empty($icon_bg_hover_color) ){
			echo "
				#$icon_id .icon_holder:hover .cws_sc_icon{
					background-color: ".$icon_bg_hover_color.";
				}
			";
		}
	}

	//Advanced Icon Inner Border Properties
	if( $icon_inner && $icon_style == 'advanced' ){
		if( !empty($inner_size) && !empty($icon_inner_color) ){
			echo "
				#$icon_id .icon_holder:before{
					width: calc(100% + ".((int)$inner_size * 2)."px);
					height: calc(100% + ".((int)$inner_size * 2)."px);
					background-color: ".$icon_inner_color.";
				}
			";
		}
		if( !empty($inner_hover_size) && !empty($icon_inner_hover_color) ){
			echo "
				#$icon_id .icon_holder:hover:before{
					width: calc(100% + ".((int)$inner_hover_size * 2)."px);
					height: calc(100% + ".((int)$inner_hover_size * 2)."px);
					background-color: ".$icon_inner_hover_color.";
				}
			";
		}
	}

	//Advanced Icon Outer Border Properties
	if( $icon_outer && $icon_style == 'advanced' ){
		if( !empty($outer_size) && !empty($icon_outer_color) ){
			echo "
				#$icon_id .icon_holder:after{
					width: calc(100% + ".( ((int)$outer_size * 2) + ((int)$inner_size * 2) )."px);
					height: calc(100% + ".( ((int)$outer_size * 2) + ((int)$inner_size * 2) )."px);
					background-color: ".$icon_outer_color.";
				}
			";
		}
		if( !empty($outer_hover_size) && !empty($icon_outer_hover_color) ){
			echo "
				#$icon_id .icon_holder:hover:after{
					width: calc(100% + ".( ((int)$outer_hover_size * 2) + ((int)$inner_hover_size * 2) )."px);
					height: calc(100% + ".( ((int)$outer_hover_size * 2) + ((int)$inner_hover_size * 2) )."px);
					background-color: ".$icon_outer_hover_color.";
				}
			";
		}
	}

	$styles = ob_get_clean();

	if( !empty($styles) ){
		Cws_shortcode_css()->enqueue_cws_css($styles);
	}

	$animation = cwsCSSAnimation($css_animation);

	$classes .= 'align_'.$icon_align;
	$classes .= ' style_'.$icon_style;
	$classes .= ' '.$el_class;

	$tag_start = '<div';
	$tag_end = '</div>';

	if( !empty($icon_url) ){
		$tag_start = '<a href="'.$icon_url.'"';
		$tag_end = '</a>';
	}

	//Icon Render
	$out .= "<div id='".$icon_id."' class='cws_sc_icon_wrapper ".$classes . $animation."'>";
		$out .= $tag_start." class='icon_holder'>";

			if( $icon_lib == 'cws_svg' ){
				$svg_icon = json_decode(str_replace("``", "\"", $icon), true);
				$out .= function_exists('cwssvg_shortcode') ? cwssvg_shortcode($svg_icon) : "";			
			} else {
				$out .= "<i class='cws_sc_icon ".$icon."'></i>";
			}

		$out .= $tag_end;
	$out .= "</div>";

	return $out;
}
add_shortcode( 'cws_sc_icon', 'cws_vc_shortcode_sc_icon' );

function cws_vc_shortcode_sc_button ( $atts = array(), $content = "" ){
	$header_font = cws_vc_shortcode_get_option('header-font');
	$header_color = esc_attr( $header_font['color'] );
	$first_color = esc_attr( cws_vc_shortcode_get_option( 'theme-first-color' ) );
	$second_color = esc_attr( cws_vc_shortcode_get_option( 'theme-second-color' ) );
	extract( shortcode_atts( array(
		"title"						=> "",
		"url"						=> "",
		"new_tab"					=> "",
		"btn_type"					=> "simple",
		"size"						=> "regular",
		"ofs"						=> "",
		"aligning"					=> "left",
		"aligning_mob"				=> "center",
		"customize_size_title"  	=> "",
		"size_t" 					=> "22px",
		"weight_t" 					=> "400",
		"font_color"				=> "",
		"font_color_hover"			=> "",
		"css_animation"				=> "none",
		"el_class"					=> ""
	), $atts));
	$out = "";
	$title 					= esc_html( $title );
	$url  					= esc_url( $url );
	$new_tab				= (bool)$new_tab;
	$size 					= esc_html( $size );
	$ofs 					= esc_attr( $ofs );
	$aligning				= esc_html( $aligning );
	$aligning_mob			= esc_html( $aligning_mob );
	$customize_size_title	= (bool)$customize_size_title;
	$size_t					= esc_attr( $size_t );
	$weight_t				= esc_attr( $weight_t );
	$font_color				= esc_attr( $font_color );
	$font_color_hover		= esc_attr( $font_color_hover );
	$el_class				= esc_attr( $el_class );
	$button_id = uniqid( "cws_vc_shortcode_button_" );

	ob_start();

	/*Standart colors*/
	if( !empty( $font_color ) ){
		echo "
			#$button_id{
				color: $font_color;
				border-color: $font_color;
			}
			#$button_id:before,
			#$button_id:after{
				background-color: $font_color;
			}
		";
	}

	/*Custom paddings*/
	if( !empty($ofs) ){
		echo "#$button_id{
			padding: ".$ofs.";
		}";
	}

	/*Hover colors*/
	if( !empty( $font_color_hover ) ){
		echo "
			#$button_id:hover{
				color: $font_color_hover;
				border-color: $font_color_hover;
			}
			#$button_id:hover:before,
			#$button_id:hover:after{
				background-color: $font_color_hover;
			}
		";
	}

	/*Customize title*/
	if ( $customize_size_title ){
		if( !empty($size_t) ){
			echo "
				#$button_id{
					font-size: ".(int)$size_t."px;
				}
			";
		}
		if( !empty($weight_t) ){
			echo "
				#$button_id{
					font-weight: ".(int)$weight_t.";
				}
			";
		}
	}

	$styles = ob_get_clean();
	/* \styles */
	$wrapper_tag = "div";
	$wrapper_tag_atts = $wrapper_tag;
	$wrapper_tag_atts .= " id='$button_id'";

	$tag = "a";
	$tag_atts = !empty( $url ) ? "$tag href='$url'" : $tag;
	$classes = "cws_custom_button $size";
	$classes .= !empty( $el_class ) ? " $el_class" : "";
	$btn_type == 'simple' ? $classes .= ' simple' : '';
	$btn_type == 'advanced' ? $classes .= ' advanced' : '';
	$tag_atts .= " class='$classes'";
	$tag_atts .= " id='$button_id'";
	$tag_atts .= !empty( $url ) && $new_tab ? " target='_blank'" : "";

	if( !empty($styles) ){
		Cws_shortcode_css()->enqueue_cws_css($styles);
	}

	$animation = cwsCSSAnimation($css_animation);

	$out .= "<div class='sc_button_wrapper ".$animation . (!empty( $aligning ) ? " align-{$aligning}" : "") . (!empty($aligning_mob) ? " mobile-align-{$aligning_mob}" : "") . "'>";
			$out .= "<$tag_atts>";
				$out .= $title;
			$out .= "</$tag>";
	$out .= "</div>";
	return $out;
}
add_shortcode( 'cws_sc_button', 'cws_vc_shortcode_sc_button' );

function cws_vc_shortcode_sc_dropcap ( $atts = array(), $content = "" ){
	return "<span class='dropcap'>$content</span>";
}
add_shortcode( 'cws_sc_dropcap', 'cws_vc_shortcode_sc_dropcap' );

function cws_vc_shortcode_sc_mark ( $atts = array(), $content = "" ){
	$theme_color = esc_attr( cws_vc_shortcode_get_option( 'theme_color' ) );
	extract( shortcode_atts( array(
		'font_color'	=> '#fff',
		'bg_color'		=> $theme_color
	), $atts));
	return "<mark style='color: $font_color;background-color: $bg_color;'>$content</mark>";
}
add_shortcode( 'cws_sc_mark', 'cws_vc_shortcode_sc_mark' );

function cws_vc_shortcode_sc_embed ( $atts, $content ) {
	extract( shortcode_atts( array(
		'url' => '',
		'width' => '',
		'height' => '',
	), $atts));
	$url = esc_url( $url );
	return !empty( $url ) ? apply_filters( "the_content", "[embed" . ( !empty( $width ) && is_numeric( $width ) ? " width='$width'" : "" ) . ( !empty( $height ) && is_numeric( $height ) ? " height='$height'" : "" ) . "]" . $url . "[/embed]" ) : "";
}
add_shortcode( 'cws_sc_embed', 'cws_vc_shortcode_sc_embed' );

function cws_vc_shortcode_sc_call_to_action ( $atts = array(), $content = "" ){
	$theme_color 			= esc_attr( cws_vc_shortcode_get_option( "theme-first-color" ) );
	extract( shortcode_atts( array(
		"subtitle"				=> "",
		"title"					=> "",
		"desc_subtitle"			=> "",
		"icon_lib"				=> "",
		"add_button"			=> "",
		"add_banner"			=> "",
		"button_title"			=> "",
		"button_url"			=> "",
		"button_new_tab"		=> "",		
		"banner_new_tab"		=> "",		
		"banner_title"			=> "",
		"banner_price"			=> "",
		"banner_description"	=> "",
		"banner_url"			=> "",
		"custom_styles"			=> "",
		"customize_colors"		=> "",
		"overlay_color"			=> "",
		"title_color"			=> "",
		"featured_color"		=> $theme_color,
		"display_color"			=> $theme_color,
		"display_font_color"	=> $theme_color,
		"css_animation"			=> "none",
		"icon_color"			=> "rgba(255,255,255,0.5)",
		"el_class"				=> ""
	), $atts));

	$out = "";

	$custom_styles = esc_attr( $custom_styles );
	

	if ( is_plugin_active('js_composer/js_composer.php') ){
	$custom_css_class 	= apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $custom_styles, ' ' ), 'cws_sc_call_to_action', $atts );
	} else {
		$custom_css_class = '';
	}
	
	$bg_color 			= $theme_color;
	if ( !empty( $custom_styles ) ){
		$match = preg_match_all( "@background(-color)?:\s+((\#\w+)|(rgba\((\d|\,|\.)+\)))@", $custom_styles, $matches );
		if ( $match && isset( $matches[2][0] ) ){
			$bg_color = $matches[2][0];
		}
	}	

	$subtitle 			= esc_html( $subtitle );
	$desc_subtitle 			= esc_html( $desc_subtitle );
	$title 				= wp_kses( $title, array(
		"span"		=> array(),
		"mark"		=> array(),
		"strong"	=> array(),
		"b"			=> array(),
		"br"		=> array()
	));
	$icon_lib			= esc_attr ( $icon_lib );
	$icon 				= function_exists('cws_ext_vc_sc_get_icon') ? cws_ext_vc_sc_get_icon( $atts ) : "";
	$icon 				= esc_attr( $icon );
	$add_button 		= (bool)$add_button;
	$button_new_tab 	= (bool)$button_new_tab;
	$banner_new_tab 	= (bool)$banner_new_tab;
	$customize_colors	= (bool)$customize_colors;
	$featured_color		= esc_attr( $featured_color );
	$display_color		= esc_attr( $display_color );
	$display_font_color	= esc_attr( $display_font_color );
	$title_color		= esc_attr( $title_color );
	$icon_color			= esc_attr( $icon_color );
	$el_class			= esc_attr( $el_class );
	$module_id 			= uniqid( "cta_" );
	if ( empty( $subtitle ) && empty( $title ) && empty( $icon ) ){
		return $out;
	}
	$classes 	= "cws_vc_shortcode_cta cws_vc_shortcode_module";
	$classes	.= !empty( $el_class ) ? " $el_class" : "";
	$classes 	.= !empty( $custom_css_class ) ? " $custom_css_class" : "";
	$tag = "a";
	$styles = "";
	ob_start();
	echo $custom_styles;
	if ( $customize_colors ){
		echo "
		#{$module_id} .cta_subtitle,
		#{$module_id} .cta_desc_subtitle{
			color: $featured_color;
		}
		#{$module_id} .cta_title{
			color: $featured_color;
		}
		#{$module_id} .cta_icon{
			color: $icon_color;
		}
		#{$module_id} .cta_button .cws_vc_shortcode_button,#{$module_id} .cta_offer + .cta_banner .cws_vc_shortcode_cta_banner{
			color: $display_font_color;
		}
		#{$module_id} .cta_button .cws_vc_shortcode_button.skew:before,
		#{$module_id} .cta_button .cws_vc_shortcode_button.skew:after{
			border-color: $featured_color;
		}
		#{$module_id} .cta_button .cws_vc_shortcode_button.skew:hover:before{
			background-color: $featured_color;
		}
		#{$module_id} mark{
			color: $featured_color;
		}
		#{$module_id} .cws_vc_shortcode_button:before{
			border-color:$display_color;
		}
		#{$module_id} .cta_button .cws_vc_shortcode_button,#{$module_id} .cta_offer + .cta_banner .cws_vc_shortcode_cta_banner{
			background:$display_color;
		}

		
		";
	}
	$styles = ob_get_clean();

	$button_html = "";
	if ( $add_button && !empty( $button_title ) && !empty( $button_url ) ){
		$button_html = "<a".(!empty($button_new_tab) ? " target='_blank'" : "")." href='" . esc_url( $button_url ) . "' class='cws_vc_shortcode_button'><span class='cws_vc_shortcode_button_content'>" . esc_html( $button_title ) . "</span></a>";
	}	

	$banner_html = "";
	if ( $add_banner && !empty( $banner_title ) && !empty( $banner_url ) ){
		$banner_html = "<a".(!empty($banner_new_tab) ? " target='_blank'" : "")." href='" . esc_url( $banner_url ) . "' class='cws_vc_shortcode_cta_banner'>";
		$banner_html .= "<span class='cws_vc_shortcode_banner_title'>" . esc_html( $banner_title ) . "</span>";
		$banner_html .= !empty($banner_price) ? "<span class='cws_vc_shortcode_banner_price'>" . esc_html( $banner_price ) . "</span>" : "";
		$banner_html .= !empty($banner_description) ? "<span class='cws_vc_shortcode_banner_desc'>" . esc_html( $banner_description ) . "</span>" : "";
		$banner_html .= "</a>";
	}

	$text_content = "";
	$text_content .= !empty( $subtitle ) ? "<div class='cta_subtitle'>$subtitle</div>" : "";
	$text_content .= !empty( $title ) ? "<div class='cta_title'>$title</div>" : "";			
	$text_content .= !empty( $desc_subtitle ) ? "<div class='cta_desc_subtitle'>$desc_subtitle</div>" : "";

	$animation = cwsCSSAnimation($css_animation);

	$out .= "<div id='$module_id' class='$classes $animation'>";
		if(!empty($overlay_color) && !empty($customize_colors)){
			$out .= "<div class='overlay_cta_color' style='background:".$overlay_color."'></div>";
		}
		
		if ( !empty( $styles ) ){
			//echo "<style id='cta_{$module_id}'>";
			//	echo $styles;
			//echo "</style>";
			Cws_shortcode_css()->enqueue_cws_css($styles);
		}
		$out .= "<div class='cta_holder'>";
			if ( !empty( $icon ) || !empty( $text_content ) ){
				$out .= "<div class='cta_offer'>";
					$out .= !empty( $icon )	 ? "<div class='cta_icon'><i class='$icon'></i></div>" : "";
					$out .= !empty( $text_content ) ? "<div class='cta_text'>$text_content</div>" : "";
				$out .= "</div>";
			}
			$out .= !empty( $button_html ) ? "<div class='cta_button'>$button_html</div>" : "";
			$out .= !empty( $banner_html ) ? "<div class='cta_banner'>$banner_html</div>" : "";
		$out .= "</div>";
	$out .= "</div>";
	return $out;
}
add_shortcode( 'cws_sc_call_to_action', 'cws_vc_shortcode_sc_call_to_action' );

function cws_vc_shortcode_sc_progress_bar ( $atts = array(), $content = "" ){
	$theme_color 			= esc_attr( cws_vc_shortcode_get_option( 'theme-first-color' ) );
	extract( shortcode_atts( array(
		'title'				=> '',
		'progress'			=> '',
		'use_custom_color'	=> '',
		'custom_fill_color'	=> $theme_color,
		'custom_title_color' => '#fff',
		'custom_percents_color' => $theme_color,
		"css_animation"		=> "none",
		'el_class'			=> ''
	), $atts));
	$title 				= esc_html( $title );
	$progress 			= esc_html( $progress );
	$use_custom_color 	= (bool)$use_custom_color;
	$custom_fill_color 	= esc_attr( $custom_fill_color );
	$el_class			= esc_attr( $el_class );
	$animation 			= cwsCSSAnimation($css_animation);
	$out = "";
	$out .= "<div class='cws_vc_shortcode_pb cws_vc_shortcode_module". $animation . ( !empty( $el_class ) ? " $el_class" : "" ) . "'>";
		$out .= !empty( $title ) ? "<p class='cws_vc_shortcode_pb_title' style='" . ( $use_custom_color && !empty( $custom_title_color ) ? "color: $custom_title_color;" : "" ) . "'>$title</p>" : "";
		$out .= "<div class='pb_bar_title' style='" . ( $use_custom_color && !empty( $custom_percents_color ) ? "color: $custom_percents_color;" : "" ) . "'>";
		$out .= (int)$progress."%";
		$out .= "</div>";
		$out .= "<div class='cws_vc_shortcode_pb_bar'>";
			$out .= "<div class='cws_vc_shortcode_pb_progress' data-value='$progress' style='width:0%;" . ( $use_custom_color && !empty( $custom_fill_color ) ? "background-color: $custom_fill_color;" : "" ) . "'>";
			$out .= "</div>";
		$out .= "</div>";
	$out .= "</div>";
	return $out;
}
add_shortcode( 'cws_sc_progress_bar', 'cws_vc_shortcode_sc_progress_bar' );

function cws_vc_shortcode_sc_ribbon ( $atts = array(), $content = "" ){
	$helper_color = esc_attr( cws_vc_shortcode_get_option( 'theme-helper-color' ) );
	extract( shortcode_atts( array(
		'ribbon_link'			=> '',
		'background_color'		=> $helper_color,
		'image'					=> '',
		'ribbon_pos'			=> 'left',
		'ribbon_top_offset'		=> '0',
		'ribbon_side_offset'	=> '0',
		"css_animation"			=> "none",
		'el_class'				=> ''
	), $atts));

	$ribbon_link 			= esc_attr( $ribbon_link );
	$background_color 		= esc_attr( $background_color );
	$image 					= esc_attr( $image );
	$ribbon_pos 			= esc_attr( $ribbon_pos );
	$ribbon_top_offset 		= esc_attr( $ribbon_top_offset );
	$ribbon_side_offset 	= esc_attr( $ribbon_side_offset );
	$el_class				= esc_attr( $el_class );
	$ribbon_img 			= wp_get_attachment_image_src($image, 'full');

	$id = uniqid('cws_ribbon_');

	$styles = 'text-align:'.$ribbon_pos.'; ';
	$styles .= ( !empty($ribbon_top_offset) ? 'margin-top: '.(int)$ribbon_top_offset.'px;' : '' );
	if( !empty($ribbon_side_offset) ){
		if( $ribbon_pos == 'left' ){
			$styles .= 'left:'.(int)$ribbon_side_offset.'px; ';
		} else {
			$styles .= 'right:'.(int)$ribbon_side_offset.'px; ';
		}
	}

	$css = '';
	if( !empty($background_color) ){
		$css = '
			#'.$id.' .cws_ribbon_wrapper svg{
				filter: drop-shadow(5px 8px 0 '.cws_Hex2RGBA($background_color, 0.2).');
			}
			#'.$id.' .cws_ribbon_wrapper:before{
				border-color: transparent transparent '.$background_color.' transparent;
			}
			#'.$id.' .cws_ribbon_wrapper:after{
				border-color: transparent transparent transparent '.$background_color.';
			}
		';
	}
	$out = "";

	$animation = cwsCSSAnimation($css_animation);

	$out .= "<div id='".$id."' class='cws_ribbon ". $animation .( !empty( $el_class ) ? " $el_class" : "" )."' style='".$styles."'>";
		if( !empty($css) ){
			Cws_shortcode_css()->enqueue_cws_css($css);
		}

		if( !empty($ribbon_link) ){
			$out .= "<a href='".$ribbon_link."' target='_blank' class='cws_ribbon_wrapper'>";
		} else {
			$out .= "<div class='cws_ribbon_wrapper'>";
		}
		
			$out .= '
				<svg height="305" width="249">
					<defs>
					  <pattern id="ribbon_pattern" patternUnits="objectBoundingBox" width="100%" height="100%">
					  	<rect x="0" y="0" width="100%" height="100%" stroke-width="0" fill="'.$background_color.'"/>
					  </pattern>
					</defs>

					<polygon class="st2" points="248.6,304.9 124.3,262 0.1,304.9 0.1,0 248.6,0" fill="url(#ribbon_pattern)"/>
				</svg>
			';
			$out .= "<div class='ribbon_img'><img src=".$ribbon_img[0]." alt=".$ribbon_img[3]."></div>";

		if( !empty($ribbon_link) ){
			$out .= "</a>";
		} else {
			$out .= "</div>";
		}

	$out .= "</div>";

	return $out;
}
add_shortcode( 'cws_sc_ribbon', 'cws_vc_shortcode_sc_ribbon' );

function cws_vc_shortcode_sc_info ( $atts = array(), $content = "" ){
	$first_color = esc_attr( cws_vc_shortcode_get_option( 'theme-first-color' ) );
	$second_color = esc_attr( cws_vc_shortcode_get_option( 'theme-second-color' ) );
	$helper_color = esc_attr( cws_vc_shortcode_get_option( 'theme-helper-color' ) );
	extract( shortcode_atts( array(
		'info_title' 				=> '',
		'image' 					=> '',
		'info_divider' 				=> '',
		'bg_image' 					=> '',
		'bordered_bg' 				=> false,
		'bg_pattern' 				=> '',
		'customize' 				=> false,
		'title_color' 				=> '#E9E4DD',
		'title_background_color' 	=> $helper_color,
		'divider_color' 			=> $helper_color,
		'text_color' 				=> '#333333',
		"css_animation"				=> "none",
		'el_class' 					=> '',
		'custom_styles'				=> '',
	), $atts));

	$info_title 					= esc_attr($info_title);
	$info_divider 					= (bool)$info_divider;
	$content 						= apply_filters( "the_content", $content );
	$bordered_bg 					= (bool)$bordered_bg;
	$customize 						= (bool)$customize;
	$title_color 					= esc_attr($title_color);
	$title_background_color 		= esc_attr($title_background_color);
	$divider_color 					= esc_attr($divider_color);
	$text_color 					= esc_attr($text_color);
	$el_class 						= esc_attr($el_class);
	$custom_styles 					= esc_attr( $custom_styles );
	$info_img	 					= wp_get_attachment_image_src($image, 'full');
	$info_bg_img	 				= wp_get_attachment_image_src($bg_image, 'full');
	$info_bg_pattern	 			= wp_get_attachment_image_src($bg_pattern, 'full');

	$id = uniqid('cws_info_');

	$css = "";
	$out = "";

	if( $customize ){
		if( !empty($title_color) ){
			$css .= "
				#$id .cws_info_title{
					color: $title_color;
				}
			";
		}
		if( !empty($title_background_color) ){
			$css .= "
				#$id .cws_info_title{
					background-color: $title_background_color;
				}
				#$id .cws_info_title:before{
					border-color: $title_background_color $title_background_color $title_background_color transparent;
				}
				#$id .cws_info_title:after{
					border-color: $title_background_color transparent $title_background_color $title_background_color;
				}
			";
		}
		if( !empty($divider_color) ){
			$css .= "
				#$id.star_divider .cws_content:before{
					background-color: $divider_color;
				}
			";
		}
		if( !empty($text_color) ){
			$css .= "
				#$id .cws_content a,
				#$id .cws_content{
					color: $text_color;
				}
			";
		}
	}

	// Default VC Styles
	$custom_css_class = "";

	if ( is_plugin_active('js_composer/js_composer.php') ){
		$custom_css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $custom_styles, ' ' ), 'cws_sc_info', $atts );
	} else {
		$custom_css_class = '';
	}

	$classes = $bordered_bg ? ' bg_in_border' : '';
	$classes .= $info_divider ? ' star_divider' : '';
	$classes .= !empty($el_class) ? " $el_class" : "";
	$classes .= !empty( $custom_css_class ) ? " $custom_css_class" : "";

	$styles = !empty($bg_image) && $bordered_bg ? "styles='border-image: url(".$info_bg_img[0].")' 12 round" : "";

	if( !empty($bg_image) ){
		if( $bordered_bg ){
			$styles = "style='border-image: url(".$info_bg_img[0].") 12 round; ".(!empty($bg_pattern) ? 'background-image: url('.$info_bg_pattern[0].');' : '')."'";
		} else {
			$styles = "style='background-image: url(".$info_bg_img[0].") !important;'";
		}
	} else {
		$styles = "";
	}

	$animation = cwsCSSAnimation($css_animation);

	$out .= "<div id='".$id."' class='cws_info_wrapper".$classes.$animation."' ".$styles.">";
		if( !empty($css) ){
			Cws_shortcode_css()->enqueue_cws_css($css);
		}

		if( !empty($info_title) ){
			$out .= "<div class='cws_info_title'>".$info_title."</div>";
		}
		if( !empty($image) ){
			$out .= "<div class='cws_info_img'><img src=".$info_img[0]." alt=".$info_img[3]."></div>";
		}
		if( !empty($content) ){
			$out .= "<div class='cws_content'>".$content."</div>";
		}



	$out .= "</div>";

	return $out;
}
add_shortcode( 'cws_sc_info', 'cws_vc_shortcode_sc_info' );

function cws_vc_shortcode_sc_milestone ( $atts = array(), $content = "" ){
	$theme_color = esc_attr( cws_vc_shortcode_get_option( 'theme-first-color' ) );
	$second_color = esc_attr( cws_vc_shortcode_get_option( 'theme-second-color' ) );
	$helper_color = esc_attr( cws_vc_shortcode_get_option( 'theme-helper-color' ) );

	extract( shortcode_atts( array(
		'icon_lib'					=> '',
		'icon_pos'					=> 'center',
		'number'					=> '',
		'title'						=> '',
		'speed'						=> '',
		'module_alignment'			=> 'center',
		'text_alignment'			=> '',
		'icon_color'				=> $helper_color,
		'title_color'				=> $helper_color,
		'text_color'				=> $second_color,
		'number_color'				=> $theme_color,
		'size'						=> '',
		'custom_size_i'				=> '',
		'size_i'					=> '48px',
		'custom_color'				=> '',
		'desc'						=> '',
		"css_animation"				=> "none",
		'el_class'					=> ''
	), $atts));
	$icon_html = '';
	$icon_lib 			= esc_attr( $icon_lib );
	$icon_pos 			= esc_attr( $icon_pos );
	$icon 				= function_exists('cws_ext_vc_sc_get_icon') ? cws_ext_vc_sc_get_icon( $atts ) : "";
	$icon 				= esc_attr( $icon );
	$number				= esc_html( $number );
	$title 				= esc_html( $title );
	$desc 				= esc_html( $desc );
	$speed				= esc_html( $speed );
	$module_alignment 	= esc_attr( $module_alignment );
	$text_alignment 	= esc_attr( $text_alignment );
	$custom_color 		= (bool)$custom_color;
	$icon_color 		= esc_attr( $icon_color );
	$title_color 		= esc_attr( $title_color );
	$text_color 		= esc_attr( $text_color );
	$number_color 		= esc_attr( $number_color );
	$el_class			= esc_attr( $el_class );
	$size				= esc_attr( $size );
	$custom_size_i		= esc_attr( $custom_size_i );
	$size_i 			= esc_html($size_i);
	$size_i 			= !empty($size_i) ? (int) $size_i : "";

	$out = $styles = "";
	$module_id 			= uniqid( "cws_vc_shortcode_milestone_" );

	wp_enqueue_script( 'odometer' );
	if ( !empty( $icon ) ){
		if ( function_exists( 'vc_icon_element_fonts_enqueue' ) ){
			vc_icon_element_fonts_enqueue( $icon_lib );
		}
		if($icon_lib == 'cws_svg'){
			$svg_icon = json_decode(str_replace("``", "\"", $icon), true);
			$upload_dir = wp_upload_dir();
			$this_folder = $upload_dir['basedir'] . '/cws-svgicons/' . md5($svg_icon['collection']) . '/';				
			$icon_html .= '<i class="svg cws_vc_shortcode_milestone_icon" style="width:'.$svg_icon['width'].'px;height:'.$svg_icon['height'].'px">'.file_get_contents($this_folder . $svg_icon['name']).'</i>';
		}
	}
	if ( $custom_size_i ){
		$styles .= "
			#{$module_id} .cws_vc_shortcode_milestone_icon{
				" . ( !empty( $size_i ) ? "font-size:".(int)$size_i."px;" : "" ) .  "
			}
		";
	}
	if ( $custom_color ){
		$styles .= "
			#{$module_id} .cws_vc_shortcode_milestone_icon{
				" . ( !empty( $icon_color ) ? "color:$icon_color;" : "" ) .  "
				" . ( !empty( $icon_color ) ? "fill:$icon_color;" : "" ) .  "
			}
			#{$module_id} .cws_vc_shortcode_milestone_title{
				" . ( !empty( $title_color ) ? "color:$title_color;" : "" ) .  "
			}
			#{$module_id} .cws_vc_shortcode_milestone_desc{
				" . ( !empty( $text_color ) ? "color:$text_color;" : "" ) .  "
			}
			#{$module_id} .cws_milestone_number_wrapper{
				" . ( !empty( $number_color ) ? "color:$number_color;" : "" ) .  "
			}
		";
	}

	$milestone_head = '';
	ob_start();
	$milestone_head = ob_get_clean();	
	$classes = "cws_vc_shortcode_milestone cws_vc_shortcode_module";
	$classes .= !empty( $module_alignment ) ? " a-{$module_alignment}" : "" ;
	$classes .= !empty( $icon_pos ) ? " icon_{$icon_pos}" : "";
	$classes .= !empty( $el_class ) ? " $el_class" : "" ;

	$animation = cwsCSSAnimation($css_animation);

	$out .= "<div id='$module_id' class='{$classes}".$animation."'>";
		!empty( $styles ) ? Cws_shortcode_css()->enqueue_cws_css($styles) : "";
		$out .= !empty($milestone_head) ? $milestone_head : "";
		$out .= "<div class='milestone_wrapper'>";
			$out .= "<div class='cws_vc_shortcode_milestone_wrapper" . ( !empty( $text_alignment ) ? " a-{$text_alignment}" : "" ) . "'>";
				
				$out .= "<div class='cws_vc_shortcode_milestone_data'>";
					$out .= "<div class='cws_milestone_number_wrapper'>";
						$out .= "<div class='cws_vc_shortcode_milestone_number'" . ( !empty( $speed ) && is_numeric( $speed ) ? " data-speed='$speed'" : "" ) . ">$number</div>";
						if( !empty($icon) ){
							if ($icon_lib == 'cws_svg'){
								$out .= $icon_html;
							} else {
								$out .= "<div class='cws_vc_shortcode_milestone_icon" . ( !empty( $size ) ? " cws_vc_shortcode_icon_$size" : " cws_vc_shortcode_icon_3x" ) . "'><i class='$icon'></i></div>";
							}
						}
					$out .= "</div>";
					$out .= !empty( $title ) ? "<h6 class='cws_vc_shortcode_milestone_title'>$title</h6>" : "";
					if( !empty($desc) ){
						$out .= "<div class='cws_vc_shortcode_milestone_desc'>";
							$out .= $desc;
						$out .= "</div>";				
					}
				$out .= "</div>";

			$out .= "</div>";
		$out .= "</div>";
	$out .= "</div>";
	return $out;
}
add_shortcode( 'cws_sc_milestone', 'cws_vc_shortcode_sc_milestone' );

function cws_vc_shortcode_sc_benefits ( $atts = array(), $content = "" ){
	$first_color 	= esc_attr( cws_vc_shortcode_get_option( 'theme-first-color' ) );
	$second_color 	= esc_attr( cws_vc_shortcode_get_option( 'theme-second-color' ) );

	extract( shortcode_atts( array(
		"subtitle" 					=> '',
		"subtitle_note" 			=> '',
		"title" 					=> '',
		"category" 					=> '',
		"description" 				=> '',
		"block_size" 				=> '900',
		"block_size_mob" 			=> '400',
		"add_button" 				=> true,
		"no_paddings" 				=> false,
		"button_url" 				=> '',
		"button_link" 				=> '',
		"new_window" 				=> false,
		"customize_colors" 			=> false,
		"subtitle_color" 			=> $second_color,
		"background_color" 			=> $first_color,
		"background_color_hover" 	=> $second_color,
		"text_color" 				=> '#fff',
		"text_color_hover" 			=> '#fff',
		"button_color" 				=> '#fff',
		"button_color_hover" 		=> '#fff',
		"css_animation"				=> "none",
	), $atts));

	$subtitle					= esc_html($subtitle);
	$subtitle_note				= esc_html($subtitle_note);
	$title						= esc_html($title);
	$category					= esc_html($category);
	$description				= esc_html($description);
	$block_size					= esc_attr($block_size);
	$block_size_mob				= esc_attr($block_size_mob);
	$add_button					= (bool)$add_button;
	$no_paddings				= (bool)$no_paddings;
	$button_url					= esc_attr($button_url);
	$button_link				= esc_attr($button_link);
	$new_window					= (bool)$new_window;
	$customize_colors			= (bool)$customize_colors;
	$background_color			= esc_attr($background_color);
	$background_color_hover		= esc_attr($background_color_hover);
	$subtitle_color				= esc_attr($subtitle_color);
	$text_color					= esc_attr($text_color);
	$text_color_hover			= esc_attr($text_color_hover);
	$button_color				= esc_attr($button_color);
	$button_color_hover			= esc_attr($button_color_hover);

	$out = $styles = '';
	$module_id = uniqid( 'cws_benefits_item_' );

	if($customize_colors){
		$styles .= "
			#{$module_id}{
				".(!empty($background_color) ? "background-color: ".$background_color.";" : "" ) . "
			}
		";
		$styles .= "
			#{$module_id}:hover{
				".(!empty($background_color_hover) ? "background-color: ".$background_color_hover.";" : "" ) . "
			}
		";
		$styles .= "
			#{$module_id} .benefits_subtitle,
			#{$module_id} .benefits_subtitle_wrapper{
				".(!empty($subtitle_color) ? "color: ".$subtitle_color.";" : "" ) . "
			}
		";
		$styles .= "
			#{$module_id} .benefits_title,
			#{$module_id}{
				".(!empty($text_color) ? "color: ".$text_color.";" : "" ) . "
			}
		";
		$styles .= "
			#{$module_id}:hover{
				".(!empty($text_color_hover) ? "color: ".$text_color_hover.";" : "" ) . "
			}
		";
		$styles .= "
			#{$module_id} .cws_custom_button_wrapper,
			#{$module_id} .cws_custom_button_wrapper .cws_custom_button{
				".(!empty($button_color) ? "color: ".$button_color.";" : "" ) . "
			}
		";
		$styles .= "
			#{$module_id} .cws_custom_button_wrapper:hover,
			#{$module_id} .cws_custom_button_wrapper:hover .cws_custom_button{
				".(!empty($button_color_hover) ? "color: ".$button_color_hover.";" : "" ) . "
			}
		";
	}
	if(!empty($block_size)){
		$styles .= "
			#{$module_id}{
				height: ".(int)$block_size."px;
			}
		";
	}
	if($no_paddings){
		$styles .= "
			#{$module_id}{
				padding: 0;
				overflow: hidden;
			}
		";
	}
	if(!empty($block_size_mob)){
		$styles .= "
			@media screen and (max-width: 980px){
				#{$module_id}{
					height: ".(int)$block_size_mob."px;
				}
			}
		";
	}

	$animation = cwsCSSAnimation($css_animation);

	ob_start();
		echo "<div id='".$module_id."' class='cws_benefits_item ".$animation."'>";
			echo "<div class='cws_benefits_info_wrapper'>";
				if ( !empty( $styles ) ){
					Cws_shortcode_css()->enqueue_cws_css($styles);
				}
				if( !empty($category) ){
					echo "<div class='benefits_category'>".$category."</div>";
				}
				if( !empty($subtitle) || !empty($subtitle_note) ){
					echo "<div class='benefits_subtitle_wrapper'>";
						if( !empty($subtitle) ){
							echo "<h6 class='benefits_subtitle'>".$subtitle."</h6>";
						}
						if( !empty($subtitle_note) ){
							echo "<span class='benefits_subtitle_note'>".$subtitle_note."</span>";
						}
					echo "</div>";
				}
				if( !empty($title) ){
					echo "<h4 class='benefits_title'>".$title."</h4>";
				}
				if( !empty($description) || $add_button ){
					echo "<div class='benefits_description_wrapper'>";
						if( !empty($description) ){
							echo "<p class='benefits_description'>".$description."</p>";
						}
						if( $add_button ){
							echo "<div class='cws_custom_button_wrapper simple'>";
								echo "<span>";
									echo "<a " . ($new_window ? 'target="_blank"' : '') . (!empty($button_url) ? 'href="'.$button_url.'"' : 'href="#"') . " class='cws_custom_button'>" . (!empty($button_link) ? $button_link : '') . "</a>";
								echo "</span>";
							echo "</div>";
						}
					echo "</div>";
				}
			echo "</div>";
		echo "</div>";
	$out .= ob_get_clean();

	return $out;
}
add_shortcode( 'cws_sc_benefits', 'cws_vc_shortcode_sc_benefits' );

function cws_vc_shortcode_sc_services ( $atts = array(), $content = "" ){
	$def_fill_color			= "rgba(255, 255, 255, 0.95)";
	$body_font_options		= cws_vc_shortcode_get_option( 'body_font' );
	$body_font_color		= esc_attr( $body_font_options['color'] );	
	$heading_font_options 	= cws_vc_shortcode_get_option( 'header_font' );
	$heading_font_color 	= esc_attr( $heading_font_options['color'] );	
	$theme_color 			= esc_attr( cws_vc_shortcode_get_option( 'theme-first-color' ) );
	$second_color 			= esc_attr( cws_vc_shortcode_get_option( 'theme-second-color' ) );
	$helper_color 			= esc_attr( cws_vc_shortcode_get_option( 'theme-helper-color' ) );
	$def_border_color 		= "rgba(255, 255, 255, 0.95)";

	extract( shortcode_atts( array(
		'title'							=> '',
		'icon_lib'						=> '',
		'alignment'						=> 'left',
		'paddings'						=> '',
		'text_spacings'					=> '',
		'text_line_height'				=> '1.6em',
		'customize_colors'				=> '',
		'hover_effects'					=> '',
		'size'							=> '',
		'size_i'						=> '45px',
		'size_t'						=> '16px',
		'customize_size'				=> '',
		'customize_size_title'			=> '',
		'add_hover'						=> '',
		'add_icon_hover'				=> '',
		'url'							=> '',
  		'custom_f_color'  				=> "",
  		'custom_icon_color'  			=> "#fff",
  		'custom_background_color'  		=> $second_color,
  		'custom_bg_color'  				=> $theme_color,
		'custom_font_color'				=> $body_font_color,
		'custom_title_color'			=> $theme_color,
		'custom_selection_color'		=> $theme_color,
		'background_color'				=> $second_color,
		'icon_color'					=> $theme_color,
		'bg_icon_color'					=> $helper_color,
		"css_animation"					=> "none",
		'el_class'						=> '',
		'custom_styles'					=> '',
		'add_animation'					=> '',
		'add_line_animation'			=> '',
	), $atts));

	$custom_styles = esc_attr( $custom_styles );
	$custom_css_class = "";
	$icon_html  = '';

	if ( is_plugin_active('js_composer/js_composer.php') ){
	$custom_css_class 	= apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $custom_styles, ' ' ), 'cws_sc_call_to_action', $atts );
	} else {
		$custom_css_class = '';
	}
			
	$title 						= esc_html( $title );
	$size_i 					= esc_html( $size_i );
	$size_t 					= esc_html( $size_t );
	$icon_lib 					= esc_attr( $icon_lib );
	$icon 						= function_exists('cws_ext_vc_sc_get_icon') ? cws_ext_vc_sc_get_icon( $atts ) : "";
	$icon 						= esc_attr( $icon );
	$alignment					= esc_attr( $alignment );
	$paddings					= esc_html( $paddings );
	$text_spacings				= esc_html( $text_spacings );
	$text_line_height			= esc_html( $text_line_height );
	$customize_size				= esc_attr( $customize_size );
	$customize_size_title		= esc_attr( $customize_size_title );
	$customize_colors			= (bool)$customize_colors;
	$add_hover					= (bool)$add_hover;
	$add_icon_hover				= (bool)$add_icon_hover;
	$custom_font_color			= esc_attr( $custom_font_color );
	$size						= !empty($size) ? esc_attr( $size ) : "3х";
	$custom_title_color			= esc_attr( $custom_title_color );
	$background_color			= esc_attr( $background_color );
	$icon_color					= esc_attr( $icon_color );
	$hover_effects				= esc_attr( $hover_effects );
	$bg_icon_color				= esc_attr( $bg_icon_color );
	$custom_selection_color		= esc_attr( $custom_selection_color );
	$custom_f_color				= esc_attr( $custom_f_color );
	$custom_icon_color			= esc_attr( $custom_icon_color );
	$custom_background_color	= esc_attr( $custom_background_color );
	$custom_bg_color			= esc_attr( $custom_bg_color );
	$el_class					= esc_attr( $el_class );
	$add_animation				= esc_attr( $add_animation );
	$add_line_animation			= esc_attr( $add_line_animation );
	$content 					= apply_filters( 'the_content', $content );

	$out = $styles = "";
	if ( empty( $title ) && empty( $content ) && empty( $icon )) return $out;
	$module_id = uniqid( 'cws_service_item_' );

	if(!empty($customize_size_title)){
		$styles .= "
			#{$module_id} .cws_service_title{
				" . ( !empty( $customize_size_title ) && !empty($size_t) ? "font-size: ".(int)$size_t ."px;" : "" ) .  "
			}
		";
	}

	if( $customize_colors ){
		if( !empty($background_color) ){
			$styles .= "
				#{$module_id} .cws_service_icon_wrapper .cws_service_icon,
				#{$module_id} .cws_service_top_part .cws_service_title:before{
					background-color: ".$background_color.";
				}
				#{$module_id} .cws_service_top_part .cws_service_title .rect-pattern{
					fill: ".$background_color.";
				}
				#{$module_id} .cws_service_top_part .cws_service_title:after{
					border-color: transparent transparent ".$background_color." transparent;
				}
			";
		}
		if( !empty($icon_color) ){
			$styles .= "
				#{$module_id} .cws_service_icon_wrapper .cws_service_icon{
					color: ".$icon_color.";
				}
			";
		}
		if( !empty($bg_icon_color) ){
			$styles .= "
				#{$module_id} .cws_service_icon_wrapper:before{
					background-color: ".$bg_icon_color.";
				}
			";
		}
		if( !empty($custom_title_color) ){
			$styles .= "
				#{$module_id} .cws_service_top_part .cws_service_title{
					color: ".$custom_title_color.";
				}
			";
		}
		if( !empty($custom_font_color) ){
			$styles .= "
				#{$module_id} .cws_service_desc{
					color: ".$custom_font_color.";
				}
			";
		}
	}

	if( $add_hover ){
		if( !empty($custom_background_color) ){
			$styles .= "
				#{$module_id}:hover .cws_service_icon_wrapper .cws_service_icon,
				#{$module_id}:hover .cws_service_top_part .cws_service_title:before{
					background-color: ".$custom_background_color.";
				}
				#{$module_id}:hover .cws_service_top_part .cws_service_title .rect-pattern{
					fill: ".$custom_background_color.";
				}
				#{$module_id}:hover .cws_service_top_part .cws_service_title:after{
					border-color: transparent transparent ".$custom_background_color." transparent;
				}
			";
		}
		if( !empty($custom_icon_color) ){
			$styles .= "
				#{$module_id}:hover .cws_service_icon_wrapper .cws_service_icon{
					color: ".$custom_icon_color.";
				}
			";
		}
		if( !empty($custom_bg_color) ){
			$styles .= "
				#{$module_id}:hover .cws_service_icon_wrapper:before{
					background-color: ".$custom_bg_color.";
				}
			";
		}
		if( !empty($custom_selection_color) ){
			$styles .= "
				#{$module_id}:hover .cws_service_top_part .cws_service_title{
					color: ".$custom_selection_color.";
				}
			";
		}
		if( !empty($custom_f_color) ){
			$styles .= "
				#{$module_id}:hover .cws_service_desc{
					color: ".$custom_f_color.";
				}
			";
		}
	}

	if( !empty ( $text_line_height ) ){
		$styles .= "
			#{$module_id} .cws_service_desc{
				line-height: ".$text_line_height.";
			}
		";
	}

	if( !empty( $text_spacings ) ){
		$styles .= "
			#{$module_id} .cws_service_desc{
				margin-top: ".$text_spacings.";
			}
		";
	}

	if( !empty($size_i) ){
		$size_i = $size_i;
	} else {
		$size_i = '45px';		
	}

	$service_background = ((int)$size_i + 15);
	$service_offset = ($service_background + 10 + 30); //Service background size + border size + wrapper before size + wrapper after size;

	$styles .= "
		#{$module_id} .cws_service_icon_wrapper .cws_service_icon:before{
			font-size: ".(int)$size_i ."px;
		}

		#{$module_id} .cws_service_icon_wrapper .cws_service_icon{
			line-height: ".$service_background."px;
			height: ".$service_background."px;
			width: ".$service_background."px;
		}
		
		#{$module_id} .cws_service_top_part .cws_service_title:before{
			width: calc(100% + 45px + ".$service_offset."px);  
		}
		#{$module_id}.a-left .cws_service_top_part .cws_service_title:before{
			left: calc(-45px - ".$service_offset."px );
		}
		#{$module_id}.a-right .cws_service_top_part .cws_service_title:before{
			right: calc(-45px - ".$service_offset."px );
		}
		
		#{$module_id}.a-left .cws_service_item_wrapper.has_icon .cws_service_desc{
			padding-left: calc(".$service_offset."px + 15px);
		}
		#{$module_id}.a-right .cws_service_item_wrapper.has_icon .cws_service_desc{
			padding-right: calc(".$service_offset."px + 15px);
		}
	";

	$wrapper_open_tag = !empty( $url ) ? "<a href='" . esc_url( $url ) . "' class='cws_service_item_wrapper".(!empty($icon) ? ' has_icon' : '')." clearfix'>" : "<div class='cws_service_item_wrapper".(!empty($icon) ? ' has_icon' : '')." clearfix'>";
	$wrapper_close_tag = !empty( $url ) ? "</a>" : "</div>";

	$animation = cwsCSSAnimation($css_animation);

	ob_start();
	echo "<div id='$module_id' class='cws_service_item cws_vc_shortcode_module". $animation . ( !empty( $alignment ) ? " a-{$alignment}" : "" ) . ( !empty($add_hover) ? " add_hover" : "" ) .( !empty($add_icon_hover) ? " add_icon_hover" : "" ) . ( !empty( $el_class ) ? " $el_class" : "" ) . ( !empty( $custom_css_class ) ? " $custom_css_class" : "" ) . "'>";
		if ( !empty( $styles ) ){
			Cws_shortcode_css()->enqueue_cws_css($styles);
		}
		echo $wrapper_open_tag;
			if ( !empty( $icon ) || !empty($title) ){
				echo "<div class='cws_service_top_part'>";
					if( !empty($icon) ){
						if ( function_exists( 'vc_icon_element_fonts_enqueue' ) ){
							vc_icon_element_fonts_enqueue( $icon_lib );		
						}
						echo "<span class='cws_service_icon_wrapper cws_service_side'>";
							if($icon_lib == 'cws_svg'){
								$svg_icon = json_decode(str_replace("``", "\"", $icon), true);
								$upload_dir = wp_upload_dir();
								$this_folder = $upload_dir['basedir'] . '/cws-svgicons/' . md5($svg_icon['collection']) . '/';				
								$icon_html .= '<i class="svg" style="width:'.$svg_icon['width'].'px; height:'.$svg_icon['height'].'px">'.file_get_contents($this_folder . $svg_icon['name']).'</i>';
							}else{
								$icon_html .= !empty( $icon ) ? "<i class='cws_service_icon cws_vc_shortcode_icon_{$size} " . esc_attr( $icon ) . "'></i>" : "";
							}
							echo $icon_html;
						echo "</span>";
					}

					if( !empty($title) ){
						echo "<h6 class='cws_service_title'>";
							echo $title;
							$shape_left_ID = uniqid('service_left_shape_');
							$shape_right_ID = uniqid('service_right_shape_');

							if( $alignment == 'left' ){
								echo '
									<svg class="right-shape" width="78" height="52">
										<defs>
										  <pattern id="'.$shape_right_ID.'" patternUnits="userSpaceOnUse" width="100%" height="100%">
										  	<rect class="rect-pattern" x="0" y="0" width="100%" height="100%" stroke-width="0" />
										    <image href="'.get_template_directory_uri().'/img/patterns/shape_pattern.png" x="0" y="0" width="100%" height="100%" />
										    <rect x="0" y="0" width="100%" height="100%" stroke-width="0" fill="rgba(0,0,0,.15)" />
										  </pattern>
										</defs>

										<path id="'.$shape_right_ID.'_path" d="M0,0.4L0,51.6l76.9-0.1L64.9,26.1l12-25.9C76.8,0.2,0,0.4,0,0.4z" fill="url(#'.$shape_right_ID.')" />
									</svg>
								';
							} else {
								echo '
									<svg class="left-shape" width="78" height="52">
										<defs>
										  <pattern id="'.$shape_left_ID.'" patternUnits="objectBoundingBox" width="100%" height="100%">
										  	<rect class="rect-pattern" x="0" y="0" width="100%" height="100%" stroke-width="0" />
										    <image href="'.get_template_directory_uri().'/img/patterns/shape_pattern.png" x="0" y="0" width="100%" height="100%" />
										    <rect x="0" y="0" width="100%" height="100%" stroke-width="0" fill="rgba(0,0,0,.15)" />
										  </pattern>
										</defs>

										<path id="'.$shape_left_ID.'_path" d="M0.7,0.2l12,25.9L0.7,51.5l76.9,0.1l0.1-51.2C77.6,0.4,0.7,0.2,0.7,0.2z" fill="url(#'.$shape_left_ID.')" />
									</svg>
								';
							}
						echo "</h6>";
					}
				echo "</div>";
			}
			
			if ( !empty( $content ) ){
				echo "<div class='cws_service_desc clearfix'>";
					echo $content;
				echo "</div>";
			}

		echo $wrapper_close_tag;

	echo "</div>";
	$out .= ob_get_clean();
	return $out;
}
add_shortcode( 'cws_sc_services', 'cws_vc_shortcode_sc_services' );

/******************** TESTIMONIAL ********************/

function cws_vc_shortcode_testimonial_renderer( $atts ) {
	$second_color = esc_attr( cws_vc_shortcode_get_option( 'theme-second-color' ) );
	$helper_color = esc_attr( cws_vc_shortcode_get_option( 'theme-helper-color' ) );
	extract( shortcode_atts( array(
		'values'				=> '',
		'thumbnail'				=> null,
		'quote'					=> '',
		'author_name'			=> '',
		'item_grid'				=> '1',
		'use_carousel'			=> true,
		'autoplay'				=> false,
		'autoplay_speed'		=> '3000',
		"customize_colors"		=> false,
		"text_color"			=> '#3f485d',
		"author_color"			=> $second_color,
		"author_bg_color"		=> $helper_color,
		"dots_color"			=> $second_color,
		"css_animation"			=> "none",
		'el_class'				=> '',
	), $atts));
	$section_id = uniqid( 'vintwood_testimonial_' );

	$quote        		= esc_html( $quote );
	$author_name 		= esc_html( $author_name );
	$item_grid    		= esc_attr( $item_grid );
	$el_class    		= esc_attr( $el_class );
	$use_carousel		= (bool)$use_carousel;
	$autoplay			= (bool)$autoplay;
	$autoplay_speed		= esc_html( $autoplay_speed );
	$customize_colors 	= (bool)$customize_colors;
	$text_color 		= esc_attr($text_color);
	$author_color 		= esc_attr($author_color);
	$author_bg_color	= esc_attr($author_bg_color);
	$dots_color 		= esc_attr($dots_color);

	$module_id = uniqid( 'cws_testimonail_' );
	$classes = $output = $styles = '';
	$classes .= !empty($el_class) ? $el_class : '';
	$classes .= $use_carousel ? ' testimonials_carousel' : '';
	$classes .= " style_2";
	$classes .= $autoplay ? ' autoplay' : '';


	if(!empty($customize_colors)){
		$styles .= "
			#{$module_id} .quote_wrap{
				".(!empty($text_color) ? "color: ".$text_color.";" : "" ) . "
			}
			#{$module_id} .testimonial_name{
				".(!empty($author_color) ? "color: ".$author_color.";" : "" ) . "
			}
			#{$module_id} .testimonial_name:before{
				".(!empty($author_color) ? "background-color: ".$author_color.";" : "" ) . "
			}
			#{$module_id} .owl-pagination .owl-page.active:before,
			#{$module_id} .owl-pagination .owl-page:hover:before{
				".(!empty($dots_color) ? "background-color: ".$dots_color.";" : "" ) . "
			}
			#{$module_id} .testimonial_name{
				".(!empty($author_bg_color) ? "background-color: ".$author_bg_color.";" : "" ) . "
			}
		";
	}

	if ($use_carousel) wp_enqueue_script( 'owl_carousel' );
	// if (is_single()) 
	$attr = $use_carousel ? "data-col='$item_grid' ".($autoplay ? "data-autoplay='$autoplay_speed'" : '') : "";
	switch ($item_grid) {
		case '3':
			$col = 4;
			break;
		case '2':
			$col = 6;
			break;
		case '1':
			$col = 12;
			break;	
	}
	$values = (array) vc_param_group_parse_atts( $values );
	$item_data = array();
	foreach ( $values as $data ) {
		$new_data = $data;
		$new_data['thumbnail'] = isset( $data['thumbnail'] ) ? $data['thumbnail'] : '';
		$new_data['quote'] = isset( $data['quote'] ) ? $data['quote'] : '';
		$new_data['author_name'] = isset( $data['author_name'] ) ? $data['author_name'] : '';

		$item_data[] = $new_data;
	}

	$animation = cwsCSSAnimation($css_animation);

	$output .= "<div id='".$module_id."' class='testimonial $classes $animation' $attr>";
	if ( !empty( $styles ) ){
		Cws_shortcode_css()->enqueue_cws_css($styles);
	}

	foreach ( $item_data as $item_d ) {
		$img_obj = wp_get_attachment_image_src( $item_d['thumbnail'],'full' );
		
		$output .= "<div class='testimonial_item".(!$use_carousel ? " vc_col-md-".$col : '')."'>";
		if (!empty($img_obj)) {
			$output .= "<div class='testimonial_img'>";
				$output .= "<div class='testimonial_img_wrap' style='background-image: url(".$img_obj[0].")'></div>";
			$output .= "</div>";
		}
		if (!empty($src_img) || !empty($item_d['author_name']) || !empty($item_d['author_status']) || !empty($item_d['quote'])) {
			$output .= "<div class='content_wrap'>";
				if (!empty($item_d['quote'])) {
					$output .= "<div class='quote_wrap'>".$item_d['quote']."</div>";
				}
				if (!empty($item_d['author_name'])) {
					$output .= "<h5 class='testimonial_name'>".$item_d['author_name']."</h5>";
				}
			$output .= "</div>";
		}
		$output .= "</div>";
	}

	$output .= "</div>";


	return $output;
}

function cws_vc_shortcode_quote_renderer( $atts ) {
	extract( shortcode_atts( array(
		'thumbnail'		=> null,
		'quote'			=> '',
		'author_name'	=> '',
		'author_status'	=> ''
	), $atts));
	$quote        	= esc_html( $quote );
	$author_name 	= esc_html( $author_name );
	$author_status	= esc_html( $author_status );
	ob_start();
	$author_section = $quote_section = '';


	if(!empty($thumbnail)){
		$thumbnail = has_post_thumbnail( ) ? wp_get_attachment_image_src( get_post_thumbnail_id( ),'full' ) : '';
		$thumbnail = $thumbnail[0];
	}


	$quote_section_class = "quote";
	$quote_section_atts = '';
	$quote_section_atts .= !empty( $quote_section_class ) ? " class='" . trim( $quote_section_class ) . "'" : '';

	if ( !empty( $quote ) ){
		$quote_section .= "<div" . ( !empty( $quote_section_atts ) ? $quote_section_atts : "" ) . ">";

			$quote_section .= "<div class='content-quote'>$quote</div>";			
			if ( !empty( $author_name ) || !empty( $author_status ) ){
				if(!empty($author_name)){
					$arr = explode(' ',trim($author_name));
					$arr_all = str_replace($arr[0], "", $author_name);
				}
				$quote_section .= "<div class='author_info_box-quote'>";
					
					$quote_section .= !empty( $author_status ) ? "<span class='author_status author_info'>" . esc_html( $author_status ) . "</span>" : "";
					$quote_section .= !empty( $author_name ) ? "<p class='author_name author_info'> - "."<span>".$arr[0]."</span>". esc_html( $arr_all ) . "</p>" : "";
				$quote_section .= "</div>";
			}
			$quote_section .= "<div class='quote_bg_c'></div>";
		$quote_section .= "</div>";
		if(!empty($thumbnail)){
		$quote_section .= '<div class="quote_bg" style="background-image: url('.esc_attr($thumbnail).');background-position: center center;"></div>';
		}

	}

	if(!empty($url)){
		$quote_section .= "<div class='link-testimonials'>";
		$quote_section .= "<a class='testimonial-button' href='".$url."'>".esc_html__('Read more', 'cws-essentials')."</a>";
		$quote_section .= "</div>";
	}

	?>
	<div class="cws_vc_shortcode_module clearfix <?php echo $thumbnail ? '' : 'without_image'; echo !empty( $el_class ) ? " $el_class" : ""; ?>">
		<?php
		if ( !empty( $thumbnail ) ) {
			echo $author_section . $quote_section;
		}
		else{
			echo $quote_section;
		}
		?>
	</div>
	<?php
	return ob_get_clean();
}

/******************** \TESTIMONIAL ********************/


function cws_vc_shortcode_sc_vc_testimonial ( $atts = array(), $content = "" ){
	$atts['thumbnail'] = isset( $atts['thumbnail'] ) && !empty( $atts['thumbnail'] ) ? wp_get_attachment_url( $atts['thumbnail'] ) : "";
	return  function_exists( 'cws_vc_shortcode_testimonial_renderer' ) ? cws_vc_shortcode_testimonial_renderer( $atts, $content ) : '';
}
add_shortcode( 'cws_sc_vc_testimonial', 'cws_vc_shortcode_sc_vc_testimonial' );

function cws_vc_shortcode_sc_testimonial ( $atts = array(), $content = "" ){
	if ( !empty( $atts['thumbnail'] ) ){
		$thumbnail_data = json_decode( $atts['thumbnail'], true );
		$atts['thumbnail'] = ( isset( $thumbnail_data['@'] ) && isset( $thumbnail_data['@']['src'] ) ) ? $thumbnail_data['@']['src'] : "";
	}
	return function_exists( 'cws_vc_shortcode_testimonial_renderer' ) ? cws_vc_shortcode_testimonial_renderer( $atts, $content ) : '';
}
add_shortcode( 'cws_sc_testimonial', 'cws_vc_shortcode_sc_testimonial' );

function cws_vc_shortcode_sc_pricing_plan ( $atts = array(), $content = "" ){
	$theme_color = esc_attr( cws_vc_shortcode_get_option( 'theme-first-color' ) );
	$header_font = cws_vc_shortcode_get_option('header-font');
	$header_color = esc_attr( $header_font['color'] );
	extract( shortcode_atts( array(
		'title'						=> '',
		'values'					=> '',
		'price'						=> '15',
		'currency'					=> '',
		'price_desc'				=> '',
		'highlighted'				=> false,
		'add_button'				=> false,
		'custom_button_color'		=> false,
		'button_text'				=> '',
		'button_url'				=> '',
		'button_new_tab'			=> false,

		'customize'					=> false,
		'highlighted_color'			=> '#D9D052',
		'info_color'				=> '#b16c7e',
		'borders_color'				=> '#435476',
		"css_animation"				=> "none",
		'el_class'					=> ''
 	), $atts));

 	$title 				= esc_html( $title );
 	$price 				= esc_html( $price );
 	$currency 			= esc_html( $currency );
 	$price_desc 		= esc_html( $price_desc );
 	$highlighted		= (bool)$highlighted;
 	$add_button 		= (bool)$add_button;
 	$customize 			= (bool)$customize;
 	$highlighted_color 	= esc_attr($highlighted_color);
	$info_color 		= esc_attr($info_color);
	$borders_color 		= esc_attr($borders_color);
 	$el_class			= esc_attr( $el_class );
 	$button_new_tab		= (bool)$button_new_tab;

 	$out 				= "";
 	$styles 			= "";
	$section_id 		= uniqid( 'cws_pricing_plan_' );

	if ( !empty( $icon ) ){
		if ( function_exists( 'vc_icon_element_fonts_enqueue' ) ){
			vc_icon_element_fonts_enqueue( $icon_lib );
		}
		if($icon_lib == 'cws_svg'){
			$svg_icon = json_decode(str_replace("``", "\"", $icon), true);
			$upload_dir = wp_upload_dir();
			$this_folder = $upload_dir['basedir'] . '/cws-svgicons/' . md5($svg_icon['collection']) . '/';				
			$icon_html .= '<i class="svg pricing_table_icon" style="width:'.$svg_icon['width'].'px;height:'.$svg_icon['height'].'px">'.file_get_contents($this_folder . $svg_icon['name']).'</i>';
		}
	}

	$values = (array) vc_param_group_parse_atts( $values );
	$item_data = array();
	foreach ( $values as $data ) {
		$new_data = $data;
		$new_data['text'] = isset( $data['text'] ) ? $data['text'] : '';

		$item_data[] = $new_data;
	}

 	ob_start();
 	if ( isset( $price ) ){
		preg_match( "/(\.| |,)(\d+)$/", $price, $matches );	
 		echo "<div class='pricing_plan_price'>";
 			echo "<h6 class='main_price_part'>";
 				echo "<div class='left-part'>";
 					echo !empty($price) ? "<span class='currency'>$price</span>" : "";
 					echo !empty($currency) ? "<span class='currency'>$currency</span>" : "";
 				echo "</div>";
 				echo "<div class='right-part'>";
 					echo !empty($price_desc) ? "<span class='price_desc'>$price_desc</span>" : "";
 				echo "</div>";
 			echo "</h6>";
 		echo "</div>";
 	}
 	$plan = ob_get_clean();

	$section_class = "cws_pricing_plan";
	$section_class .= $highlighted ? " highlighted" : "";
	$section_class .= !empty( $el_class ) ? " $el_class" : "";


	if( $customize ){
		$styles .= "
			#$section_id.cws_pricing_plan .pricing_plan_price .main_price_part{
				border: 0;
			}
		";
		if( !empty($highlighted_color) ){
			$styles .= "
				#$section_id.cws_pricing_plan.highlighted .pricing_plan_title{
					color: $highlighted_color;
				}
				#$section_id.cws_pricing_plan.highlighted:before{
					display: none;
				}
				#$section_id.cws_pricing_plan.highlighted .pricing_plan_price .main_price_part{
					background-color: transparent;
					background-image: none;
				}
				#$section_id.cws_pricing_plan.highlighted:after{
					border: 0;
					background-image: none;
					background-color: $highlighted_color;
					opacity: .7;
				}
			";
		}
		if( !empty($info_color) ){
			$styles .= "
				#$section_id.cws_pricing_plan .price_row_info{
					color: #333;
				}
				#$section_id.cws_pricing_plan .pricing_title:before,
				#$section_id.cws_pricing_plan .cws_custom_button,
				#$section_id .pricing_plan_price .main_price_part{
					color: $info_color;
				}
				#$section_id.cws_pricing_plan .cws_custom_button{
					border-color: $info_color;
				}
				#$section_id.cws_pricing_plan .cws_custom_button:after,
				#$section_id.cws_pricing_plan .cws_custom_button:before{
					background-color: $info_color;
				}
			";
		}
		if( !empty($borders_color) ){
			$styles .= "
				#$section_id.cws_pricing_plan .pricing_plan_price{
					border-width: 0 3px 3px 3px;
					border-style: solid;
					border-color: $borders_color;
				}
				#$section_id.cws_pricing_plan .pricing_plan_content,
				#$section_id .pricing_plan_price .right-part{
					border-color: $borders_color;
				}
				#$section_id.cws_pricing_plan .pricing_title{
					background-color: $borders_color;
				}
				#$section_id .pricing_plan_content:before{
					background-image: -webkit-linear-gradient(left, $borders_color, $borders_color 50%, transparent 50%, transparent 100%);
    				background-image: -o-linear-gradient(left, $borders_color, $borders_color 50%, transparent 50%, transparent 100%);
    				background-image: linear-gradient(to right, $borders_color, $borders_color 50%, transparent 50%, transparent 100%);
				}
			";
		}
	}

	$animation = cwsCSSAnimation($css_animation);

	$out .= "<div id='$section_id' class='$section_class $animation'>";
	!empty( $styles ) ? Cws_shortcode_css()->enqueue_cws_css($styles) : "";
		if( !empty( $title ) || !empty($icon) ){
			$out .= "<div class ='pricing_title'>";
				$out .= !empty( $title ) ? "<h4 class='pricing_plan_title'>$title</h4>" : "";
				if( !empty($icon) ){
					if ($icon_lib == 'cws_svg'){
						$out .= $icon_html;
					} else {
						$out .= "<div class='pricing_table_icon'><i class='$icon'></i></div>";
					}
				}
			$out .= "</div>";
		}

		$out .= !empty( $plan ) ? "<div class='pricing_plan'>$plan</div>" : "";

		$out .= "<div class='pricing_plan_content'>";
			foreach ( $item_data as $item_d ) {

				if (!empty($item_d['text'])) {
					$out .= "<div class='price_row_info'>".$item_d['text']."</div>";
				}
			}
		$out .= "</div>";


		if( $add_button ){
			$out .= "<a href='".(!empty($button_url) ? $button_url : '')."' ".($button_new_tab ? 'target="_blank"' : '' )." class='cws_custom_button advanced'>".(!empty($button_text) ? $button_text : '')."</a>";
		}

	$out .= "</div>";
	return $out;
}
add_shortcode( 'cws_sc_pricing_plan', 'cws_vc_shortcode_sc_pricing_plan' );

function cws_vc_shortcode_sc_gifts_cards ( $atts = array(), $content = "" ){
	$theme_color = esc_attr( cws_vc_shortcode_get_option( 'theme-first-color' ) );
	extract( shortcode_atts( array(
		'add_divider'		=> true,
		'curency_alignment'	=> 'before',
		'price'				=> '',		
		'currency'			=> '',
		'price_desc'		=> '',
		'add_button'		=> '',
		'add_discount'		=> '',
		'button_text'		=> '',
		'button_url'		=> '',
		'button_new_tab'	=> '',
		'highlighted'		=> '',
		'use_custom_color'	=> '',
		'add_url'			=> '',
		'add_url_new_tab'	=> '',
		'title'				=> 'Gift Voucher',
		'cards_img'			=> '',
		'cards_logo'		=> '',
		'discount_text'		=> '',
		'add_hover'			=> '',
		'discount_color'	=> $theme_color,
		'custom_color'		=> $theme_color,
		'main_color'		=> $theme_color,
		'bg_color'			=> $theme_color,
		'btn_font_color'	=> $theme_color,
		"css_animation"		=> "none",
		'el_class'			=> ''
 	), $atts));
 	$title 				= wp_kses( $title, array(
 							'span'		=> array(),
 							'mark' 		=> array(),
 							'b'			=> array(),
 							'strong'	=> array(),
 							'br'		=> array()
 						), $title );
 	$cards_logo 			= esc_html( $cards_logo );
 	$currency 			= esc_html( $currency );
 	$price 				= esc_html( $price );
 	$discount_text 		= esc_html( $discount_text );
 	$price_desc 		= esc_html( $price_desc );
 	$add_button 		= (bool)$add_button;
 	$button_text 		= esc_html( $button_text );
 	$button_url 		= esc_url( $button_url );
 	$button_new_tab 	= (bool)$button_new_tab;
 	$highlighted		= (bool)$highlighted;
 	$use_custom_color 	= (bool)$use_custom_color;
 	$custom_color 		= esc_attr( $custom_color );
 	$add_divider 		= esc_attr( $add_divider );
 	$main_color 		= esc_attr( $main_color );
 	$curency_alignment 	= esc_attr( $curency_alignment );
 	$cards_img 			= esc_attr( $cards_img );
 	$bg_color 			= esc_attr( $bg_color );
 	$discount_color 	= esc_attr( $discount_color );
 	$add_discount 		= esc_attr( $add_discount );
 	$add_url_new_tab 	= esc_attr( $add_url_new_tab );
 	$add_url 			= esc_attr( $add_url );
 	$btn_font_color 	= esc_attr( $btn_font_color );
 	$add_hover 			= (bool)$add_hover;
 	$el_class			= esc_attr( $el_class );
 	$out = "";
	$section_id = uniqid( 'cws_vc_shortcode_gifts_cards_' );
	$plan_img_data = array();
	$plan_img_dims = array( 'height' => 125, 'width' => 125, 'crop' => true );
	$plan_img_html = "";
	if ( !empty( $cards_logo ) ){
		$plan_img_data = wp_get_attachment_image_src( $cards_logo, 'full' );
		if ( is_array( $plan_img_data ) ){
 			$plan_img_thumb_data = cws_thumb( $cards_logo, $plan_img_dims, false );
 			$plan_img_thumb_src = isset( $plan_img_thumb_data[0] ) ? $plan_img_thumb_data[0] : "";
 			$retina_thumb = isset( $plan_img_thumb_data[3] ) ? $plan_img_thumb_data[3] : false;

 			if ( !empty( $plan_img_thumb_src ) ){
 				$plan_img_html .= "<img src='".esc_url($plan_img_thumb_src)."' alt class='gifts_cards_img'" . ( !empty( $retina_thumb ) ? " data-at2x='".esc_url($retina_thumb)."'" : " data-no-retina" ) . " />";
 			}
		}
	}
	$cards_data = '';	
	if ( !empty( $cards_img ) ){
		$cards_data = wp_get_attachment_image_src( $cards_img, 'full' );
		if ( is_array( $cards_data ) ){
 			$cards_data = $cards_data[0];
		}
	}
	ob_start();
	echo !empty( $title ) ? "<h3 class='gifts_cards_title'>".$title."</h3>" : "";
	echo !empty($add_divider) ? "<span class='separator_css'></span>" : "";
 	if ( !empty( $price ) ){
		preg_match( "/(\.|,)(\d+)$/", $price, $matches );
		$fract_price_part = isset( $matches[2] ) ? $matches[2] : '';
		$main_price_part = !empty( $fract_price_part ) ? esc_html( substr( $price, 0, strpos( $price, $fract_price_part ) ) ) : esc_html( $price ); 		
 		echo "<div class='gifts_cards_price_wrapper'>";
	 		echo "<div class='gifts_cards_price'>";
	 			echo "<span class='price'>";
	 				if($curency_alignment == 'before'){
	 					echo !empty( $currency ) ? "<span class='currency'>$currency</span>" : "";
	 				}
		 			echo "<span class='main_price_part'>$main_price_part</span>";
		 			echo !empty( $fract_price_part ) ? "<span class='fract_price_part'>$fract_price_part</span>" : "";
		 			if($curency_alignment == 'after'){
	 					echo !empty( $currency ) ? "<span class='currency'>$currency</span>" : "";
	 				}
	 			echo "</span>";
	 			echo !empty( $price_desc ) ? "<span class='price_desc'>$price_desc</span>" : "";
	 		echo "</div>";
	 	echo "</div>";
	 	
 	}	
 	$plan_body = ob_get_clean();
 	
 	ob_start();
 	if ( !empty( $plan_img_html ) ){
 		echo "<div class='gifts_cards_left'>";
 			echo "<div class='gifts_cards_head_wrapper'>";
 				echo $plan_img_html;
 			echo "</div>";
 		echo "</div>";
 	}
 	if ( !empty( $plan_body ) ){
 		echo "<div class='gifts_cards_right'>";
 			echo $plan_body;
		 	ob_start();
		 	if ( $add_button && !empty( $button_text ) && !empty( $button_url ) ){
		 		echo "<a href='$button_url' class='gifts_cards_button'" . ( $button_new_tab ? " target='_blank'" : "" ) . ">$button_text</a>";
		 	}
		 	$button = ob_get_clean();		
		 	if ( !empty( $button ) ){
				echo "<div class='gifts_cards_button_holder'>";
					echo $button;
				echo "</div>";
			} 		
 		echo "</div>";
 	}		 	

 	$gifts_cards_html = ob_get_clean();

	$styles = "";
	ob_start();
	if ( $use_custom_color ){
		if(!empty($custom_color)){
		echo "#{$section_id}{
			color:$custom_color;
			} ";
		}			
	}
	if(!empty($discount_color)){
		echo "#{$section_id} .discount_gifts_cards{
			color:$discount_color;
		} ";	
	}
	$styles = ob_get_clean();

	ob_start();
	$content = apply_filters( 'the_content', $content );
	echo !empty( $content ) ? "<div class='gifts_cards_content'>$content</div>" : "";
	$content_back = ob_get_clean();

	$section_class = "cws_vc_shortcode_gifts_cards cws_vc_shortcode_module";
	$section_class .= !empty( $gifts_cards_html ) && !empty( $button ) ? " cws_vc_shortcode_flex_column_sb" : "";
	$section_class .= $highlighted ? " highlighted" : "";
	$section_class .= $add_hover ? " add_hover" : "";
	$section_class .= !empty( $el_class ) ? " $el_class" : "";
	//$out .= !empty( $styles ) ? "<style>$styles</style>" : "";
	!empty( $styles ) ? Cws_shortcode_css()->enqueue_cws_css($styles) : "";
	$animation = cwsCSSAnimation($css_animation);
	$out .= "<div id='$section_id' class='$section_class $animation'>";
		if(!empty($content_back)){
			$out .= "<div class='flip'>";
		}else{
			$out .= "<div class='no-flip'>";
		}
		
		if ( !empty( $gifts_cards_html ) ){
			$out .= "<div class='gifts_cards perspective_gifts front'".(!empty($bg_color) ? ' style="background-color:'.$bg_color.'"' : "").">";
			if(!empty($cards_data)){
				$out .= "<span class='bg_gifts_cards' style='background-repeat:no-repeat;background-image:url(".$cards_data.")'></span>";
			}
			if(!empty($add_discount) && !empty($discount_text)){
				$out .= "<div class='discount_gifts_cards'>";
					$out .= $discount_text;		
				$out .= "</div>";
			}	
				$out .= $gifts_cards_html;		
			$out .= "</div>";
		}	
		if(!empty($content_back)){
			$out .= "<div class='perspective_gifts back'".(!empty($bg_color) ? ' style="background-color:'.$bg_color.'"' : "").">";
			$out .= $content_back;
			$out .= "</div>";
		}
		$out .= "</div>";
		if(!empty($add_url) && !empty($button_url)){
			$out .= "<a href='{$button_url}' class='gifts_btn_url'".(!empty($add_url_new_tab) ? " target='_blank'" : "")."></a>";
		}

	$out .= "</div>";
	return $out;
}
add_shortcode( 'cws_sc_gift_cards', 'cws_vc_shortcode_sc_gifts_cards' );

function cws_vc_shortcode_sc_banners ( $atts = array(), $content = "" ){
	$header_font = cws_vc_shortcode_get_option('header-font');
	$header_color = esc_attr( $header_font['color'] );
	$helper_color = esc_attr( cws_vc_shortcode_get_option( 'theme-helper-color' ) );
	extract( shortcode_atts( array(
		"banner_style"				=> "simple",
		'icon_lib'					=> 'FontAwesome',
		"title"						=> "",
		"offer"						=> "",
		"banner_url"				=> "#",
		"text_color"				=> false,
		"text_font_color"			=> '#333333',
		"text_secondary_color"		=> '#e9e4dd',
		"add_button"				=> false,
		"button_text"				=> "",
		"button_url"				=> "",
		"button_new_tab"			=> false,
		"button_colors"				=> false,
		"font_color"				=> "#e9e4dd",
		"font_color_hover"			=> VINTWOOD_SECOND_COLOR,
		"button_style"				=> "simple",
		"text_pos"					=> "left",
		"bg_color"					=> $helper_color,
		"border_color"				=> "#333333",
		"css_animation"				=> "none",
		"el_class"					=> ""
	), $atts));
	$out = "";
	$icon					= function_exists('cws_ext_vc_sc_get_icon') ? cws_ext_vc_sc_get_icon( $atts ) : "";
	$icon 					= esc_attr( $icon );
	$banner_style			= esc_attr( $banner_style );
	$title					= esc_html( $title );
	$offer 					= esc_html( $offer );
	$add_button				= (bool)$add_button;
	$button_text			= esc_html( $button_text );
	$button_url				= esc_html( $button_url );
	$banner_url				= esc_html( $banner_url );
	$button_new_tab			= (bool)$button_new_tab;
	$button_colors			= (bool)$button_colors;
	$font_color				= esc_html( $font_color );
	$font_color_hover		= esc_html( $font_color_hover );
	$bg_color				= esc_html( $bg_color );
	$text_pos				= esc_html( $text_pos );
	$button_style			= esc_html( $button_style );
	$border_color			= esc_html( $border_color );
	$el_class				= esc_attr( $el_class );
	$banner_id 				= uniqid( "banner_id_" );

	if ( empty( $title ) && empty( $offer ) ){
		return $out;
	}

	$classes = "";
	$classes .= $add_button ? " with_button" : "";
	$classes .= !empty( $el_class ) ? " $el_class" : "";
	$button_atts = array(
		'title'						=> $button_text,
		'url'						=> $button_url,
		'new_tab'					=> $button_new_tab,
		'size'						=> 'regular',
		'btn_type'					=> $button_style,
		'aligning'					=> $text_pos,
		'alt'						=> true,
		'add_bg'					=> true,
		'font_color'				=> $font_color,
		'font_color_hover'			=> $font_color_hover,
	);
	$button = $add_button ? cws_vc_shortcode_sc_button( $button_atts ) : "";
	/* section styles */
	$bg_color = !empty($bg_color) ? $bg_color : 'transparent';
	ob_start();

	echo "#{$banner_id} .banner_wrapper{
		border-color: $border_color;
	}";
	echo "#{$banner_id} .banner_wrapper .banner_title{
		background-color: $text_font_color;
	}";
	
	if( $banner_style == 'simple' ){
		echo "#{$banner_id} .banner_wrapper:before{
			border-color: $border_color;
		}";
		echo "#{$banner_id} .banner_wrapper .banner_offer:before{
			background-color: $bg_color;
		}";
		echo "#{$banner_id} .banner_wrapper .banner_offer{
			border-color: $border_color;
			color : $text_secondary_color;
		}";
	} else {
		echo "#{$banner_id} .banner_wrapper:after{
			background-color: $bg_color;
		}";
		echo "#{$banner_id} .banner_wrapper:before{
			border-color: $text_secondary_color;
		}";
	}

	$styles = ob_get_clean();

	Cws_shortcode_css()->enqueue_cws_css($styles);

	$animation = cwsCSSAnimation($css_animation);

	/* \section styles */
	$out .= "<div id='$banner_id' class='vintwood_banner $banner_style $classes $animation'>";
		if( $add_button ){
			$out .= "<div class='banner_wrapper align_".$text_pos.($add_button ? ' flexed' : '')."'>";
		} else {
			$out .= "<a href='$banner_url' class='banner_wrapper align_".$text_pos.($add_button ? ' flexed' : '')."'>";
		}
			if(!empty($icon_lib)){
				if($icon_lib == 'cws_svg'){
					$icon = "icon_".$icon_lib;
					$svg_icon = json_decode(str_replace("``", "\"", $atts[$icon]), true);
					$upload_dir = wp_upload_dir();
					$this_folder = $upload_dir['basedir'] . '/cws-svgicons/' . md5($svg_icon['collection']) . '/';				
					$out .= '<span class="icon"><i class="svg" style="width:'.$svg_icon['width'].'px;height:'.$svg_icon['height'].'px">'.file_get_contents($this_folder . $svg_icon['name']).'</i></span>';
				} else {
					if(!empty($icon)){
						$out .=  "<span class='icon'><i class='".$icon."'></i></span>";
					}
				}
			}
			$out .= "<div class='banner_table'>";
				$out .= "<div class='banner_cell'>";
					$out .= !empty( $title ) ? "<h3 class='banner_title'>$title</h3>" : "";
					$out .= !empty( $offer ) ? "<span class='banner_offer'>$offer</span>" : "";
				$out .= "</div>";
			$out .= "</div>";
			if( $add_button ){
				$out .= "<div class='banner_button'>$button</div>";
			}
		if( $add_button ){
			$out .= "</div>";
		} else {
			$out .= "</a>";
		}
	$out .= "</div>";
	return $out;
}
add_shortcode( 'cws_sc_banners', 'cws_vc_shortcode_sc_banners' );

function vintwood_sc_social_icons ( $atts = array(), $content = "" ){
	$theme_color = esc_attr( cws_vc_shortcode_get_option( 'theme-first-color' ) );
	extract( shortcode_atts( array(
		'icon' 			=> '',
		'link' 			=> '',
		'title' 		=> '',
		'new_tab' 		=> true,
		'icon_size' 	=> 'regular',
		'icon_pos' 		=> 'left',
		'icon_color' 	=> '#ffffff',
		'icon_color_hover' 	=> $theme_color,
		'bg_color' 		=> $theme_color,
		'bg_hover_color'=> '#ffffff',
		'stroke_color' 		=> $theme_color,
		'stroke_hover_color'=> $theme_color,
		'icon_font'		=> '15',
		"css_animation"	=> "none",
		'values'		=> '',
	), $atts));
	$section_id = uniqid( 'vintwood_soc_icon_' );
	$output = $icon_style = '';
	$bg_color = !empty($bg_color) ? $bg_color : 'transparent';
	$bg_hover_color = !empty($bg_hover_color) ? $bg_hover_color : 'transparent';
	$stroke_color = !empty($stroke_color) ? $stroke_color : 'transparent';
	$stroke_hover_color = !empty($stroke_hover_color) ? $stroke_hover_color : 'transparent';
	/* styles */
	ob_start();
	echo "#$section_id.cws_social_icons .cws_icon:hover{
			color: $icon_color_hover !important;
		}
		#$section_id.cws_social_icons .cws_icon:hover{
			background: $bg_hover_color !important;
			border-color: $stroke_hover_color !important;
		}";
	/* \styles */
	$styles = ob_get_clean();
	if ( !empty( $styles ) ){
		Cws_shortcode_css()->enqueue_cws_css($styles);
	}
	$values = (array) vc_param_group_parse_atts( $values );
	$icon_data = array();
	foreach ( $values as $data ) {
		$new_data = $data;
		$new_data['icon'] = isset( $data['icon'] ) ? $data['icon'] : '';
		$new_data['link'] = isset( $data['link'] ) ? $data['link'] : '#';
		$new_data['title'] = isset( $data['title'] ) ? $data['title'] : '';
		$new_data['new_tab'] = isset( $data['new_tab'] ) ? $data['new_tab'] : '';

		$icon_data[] = $new_data;
	}
	$classes = 'cws_social_icons';
	$classes .= ' icon_size_'.$icon_size;
	$classes .= ' a-'.$icon_pos;
	$icon_style .= 'color:'.$icon_color.';';
	$icon_style .= 'background:'.$bg_color.';';
	$icon_style .= 'border-color:'.$stroke_color.';';
	$icon_style .= 'font-size:'.$icon_font.'px;';

	$animation = cwsCSSAnimation($css_animation);

	$output .= '<div id="'.$section_id.'" class="'.$classes.$animation.'">';
	foreach ( $icon_data as $icon_d ) {
		$title_tag = !empty( $icon_d['title'] ) ? " title='".$icon_d['title']."'" : "";
		$new_tab = !empty( $icon_d['link'] ) && (bool)$icon_d['new_tab'] ? "target='_blank'" : "";
		$output .= "<a href='".$icon_d['link']."' class='cws_icon ".$icon_d['icon']."' style='".$icon_style."' ".$new_tab." ".$title_tag."></a>";
	}
	$output .= '</div>';

	return $output;
}
add_shortcode( 'cws_sc_social_icons', 'vintwood_sc_social_icons' );

function cws_vc_shortcode_sc_divider ( $atts = array(), $content = "" ){
	$theme_color = esc_attr( cws_vc_shortcode_get_option( 'theme-first-color' ) );
	extract( shortcode_atts( array(
		"type"					=> "",
		"height_divider"		=> "3",
		"mtop"					=> "",
		"mbottom"				=> "",
		"customize_colors"		=> false,
		"add_stars"				=> false,
		"plan_img"				=> '',
		"icon_lib"				=> "FontAwesome",
		'icon_spacings'			=> '40px',
		"custom_color_icon"		=> $theme_color,
		"size"					=> "",
		"custom_color"			=> $theme_color,
		"css_animation"			=> "none",
		"el_class"				=> ""
 	), $atts));
	$icon				= function_exists('cws_ext_vc_sc_get_icon') ? cws_ext_vc_sc_get_icon( $atts ) : "";
	$icon 				= esc_attr( $icon );
 	$type 				= esc_attr( $type );
  	$mtop 				= esc_attr( (int)$mtop );
  	$mbottom 			= esc_attr( (int)$mbottom );
  	$add_stars 			= (bool)$add_stars;
  	$customize_colors 	= (bool)$customize_colors;
  	$icon_spacings 		= esc_attr( $icon_spacings );
  	$custom_color 		= esc_attr( $custom_color );
 	$el_class			= esc_attr( $el_class );
	$classes = "separator-wrapper";
	$classes .= !empty( $type ) ? " $type" : "";
	$classes .= $add_stars ? " stars_type" : "";
	$classes .= !empty( $el_class ) ? " $el_class" : "";
	$classes = trim( $classes );
	
	$id = uniqid( "cws_divider_" );

	$separator_css = '';
	$separator_css .= !empty($height_divider) ? "height:".(int) $height_divider."px;" : "";	
	
	$result = '';
	if(!empty($plan_img)){
		$thumb_src_obj = wp_get_attachment_image_src( $plan_img, 'full' );
		$thumb_src = isset( $thumb_src_obj[0] ) ? $thumb_src_obj[0] : "";
		$src_img = cws_print_img_html(array('src' => $thumb_src), array( 'width' => 40, 'height' => 40, 'crop' => true ) );
		$result .= "<span class='thumb'><img {$src_img} alt /></span>";
	}
	if(!empty($icon_lib)){
		if($icon_lib == 'cws_svg'){
			$icon = "icon_".$icon_lib;
			$svg_icon = json_decode(str_replace("``", "\"", $atts[$icon]), true);
			$upload_dir = wp_upload_dir();
			$this_folder = $upload_dir['basedir'] . '/cws-svgicons/' . md5($svg_icon['collection']) . '/';				
			$result .= '<span class="icon"><i class="svg" style="width:'.$svg_icon['width'].'px;height:'.$svg_icon['height'].'px">'.file_get_contents($this_folder . $svg_icon['name']).'</i></span>';
		}else{
			if(!empty($icon)){
				$icon_css = !empty($custom_color_icon) ? "color:{$custom_color_icon};" : "";
				$result .=  "<span class='icon'><i class='".(!empty($size) ? "cws_vc_shortcode_icon_$size $icon" : "cws_vc_shortcode_icon_3x $icon")." '".(!empty($icon_css) ? " style='{$icon_css}'" : "")."></i></span>";
			}			
		}
	}

	ob_start();
	if ( !empty( $mtop ) || !empty( $mbottom ) ){
		if (!empty($result)) {
			echo "
			#{$id}.separator-wrapper{
				" . ( !empty( $mtop ) ? "margin-top:{$mtop}px;" : "" ) . "
				" . ( !empty( $mbottom ) ? "margin-bottom:{$mbottom}px;" : "" ) . "
				}
			";
		} else {
			echo "
				#{$id} hr{
				" . ( !empty( $mtop ) ? "margin-top:{$mtop}px;" : "" ) . "
				" . ( !empty( $mbottom ) ? "margin-bottom:{$mbottom}px;" : "" ) . "
				}
			";	
		}
	}
	if( !empty($icon_spacings) && $icon ){
		echo "
			#{$id} .separator-line{
				width: calc(50% - " . (int)$icon_spacings . "px);
	}
		";
	}
	if ( $customize_colors && !empty( $custom_color ) ){

		if( $add_stars ){
			echo "
				#{$id} .separator-line:before, #{$id} hr:before{
					background-color: $custom_color;
				}
			";
		} else {
			echo "
				#{$id} .separator-line, #{$id} hr{
					background-color: $custom_color;
				}
			";
		}

	}

	$styles = ob_get_clean();
	$out = "";
	if ( !empty( $styles ) ){
		Cws_shortcode_css()->enqueue_cws_css($styles);
	}

	$animation = cwsCSSAnimation($css_animation);

	$out .= "<div id='{$id}'" . ( !empty( $classes ) ? " class='$classes $animation'" : "" ) . ">";
		if(!empty($result)){
			$out .= "<div class='separator-line separator-container-left-line'".(!empty($separator_css) ? " style='{$separator_css}'" : "" )."></div>";
			$out .= !empty($result) ? $result : "";
			$out .= "<div class='separator-line separator-container-right-line'".(!empty($separator_css) ? " style='{$separator_css}'" : "" )."></div>";			
		}else{
			$out .= "<hr".(!empty($separator_css) ? " style='{$separator_css}'" : "" ).">";
		}

	$out .= "</div>";
	return $out;
}
add_shortcode( 'cws_sc_divider', 'cws_vc_shortcode_sc_divider' );

function cws_vc_shortcode_sc_spacing ( $atts = array(), $content = "" ){
	extract( shortcode_atts( array(
		'height' => '',
		'responsive_es' => '',
		'height_size_sm_desctop' => '',
		'height_tablet' => '',
		'height_mobile' => '',
 	), $atts));
 	$classes = '';
	if ($responsive_es == 'true') {
		$classes .= !empty($height_size_sm_desctop || $height_size_sm_desctop == '0') ? ' cws_spacing_size_sm_desctop-on' : '';
		$classes .= !empty($height_tablet || $height_tablet == '0') ? ' cws_spacing_tablet-on' : '';
		$classes .= !empty($height_mobile || $height_mobile == '0') ? ' cws_spacing_mobile-on' : '';
	}

	$out = '';
	if (!empty($height) || $height == '0') {
		$out .= '<div class="cws_spacing'.esc_attr($classes).'">';
		$out .= '<div class="cws_spacing cws_spacing_default" style="height:'.(int)$height.'px;"></div>';
		if ($responsive_es == 'true') {
			$out .= !empty($height_size_sm_desctop || $height_size_sm_desctop == '0') ? ' <div class="cws_spacing cws_spacing_size_sm_desctop" style="height:'.(int)$height_size_sm_desctop.'px;"></div>' : '';
			$out .= !empty($height_tablet || $height_tablet == '0') ? ' <div class="cws_spacing cws_spacing_tablet" style="height:'.(int)$height_tablet.'px;"></div>' : '';
			$out .= !empty($height_mobile || $height_mobile == '0') ? ' <div class="cws_spacing cws_spacing_mobile" style="height:'.(int)$height_mobile.'px;"></div>' : '';
		}
		$out .= '</div>';
	}	
	return $out;
}
add_shortcode( 'cws_sc_spacing', 'cws_vc_shortcode_sc_spacing' );

function cws_vc_shortcode_sc_categories ( $atts = array(), $content = "" ){
	extract( shortcode_atts( array(
		"columns"			=> "3",
		"count"				=> "3",
		"square"			=> true,
		"use_carousel"		=> false,
		"autoplay"			=> false,
		"autoplay_speed"	=> "3000",
		"cat_terms" 		=> '',
		"css_animation"		=> "none",
		"el_class"			=> ""
 	), $atts));

	global $cws_theme_funcs;

	$section_id = uniqid( 'categories_grid_' );

 	$spacing = esc_attr( $columns );
 	$el_class = esc_attr( $el_class );
 	$use_carousel = (bool)$use_carousel;
 	$autoplay = (bool)$autoplay;
 	$out = $grid_class = "";
 	$counter = 0;
	
	$sb = $cws_theme_funcs->cws_render_sidebars( get_queried_object_id() );
	$sb_layout = isset( $sb['layout_class'] ) ? $sb['layout_class'] : '';
	$full_width = isset($GLOBALS['cws_row_atts']) && !empty($GLOBALS['cws_row_atts']) ? $GLOBALS['cws_row_atts'] : "";

	$GLOBALS['cws_vc_shortcode_posts_grid_atts'] = array(
		'layout'			=> $columns,
		'sb_layout'			=> $sb_layout,
		'crop_featured'		=> false,
		'full_width'		=> $full_width
	);
 	$thumbnail_dims = cws_blog_thumbnail_dims();
 	if ((bool)$square) {
 		$thumbnail_dims['crop'] = true;
 		$thumbnail_dims['width'] = 500;
 		$thumbnail_dims['height'] = 500;
	 	$image_object = wp_get_image_editor(get_template_directory_uri() . "/img/img_placeholder.png");
		if(!is_wp_error($image_object)){
			$image_object->resize('500', '500', true);
			$image_object->save(get_template_directory() . "/img/img_placeholder_crop.png");
		}
 	}
 	unset( $GLOBALS['cws_vc_shortcode_posts_grid_atts'] );
	if ($cat_terms == '') {
		$cat_terms = get_terms( 'category', array(
		    'fields' => 'id=>slug', //all, ids, names, id=>name, id=>slug
		));
	} else {
		$cat_terms = !empty($cat_terms) ? explode( ',', $cat_terms ) : null;
	}
	wp_enqueue_script( 'isotope' );
	if ($use_carousel) {
		wp_enqueue_script( 'owl_carousel' );
	}
	$grid_class .= $use_carousel ? ' category_carousel' : ''; 
	$grid_class .= $autoplay ? ' autoplay' : ''; 
	$attr = $use_carousel ? "data-col='$columns' ".($autoplay ? "data-autoplay='$autoplay_speed'" : '') : "";
	$animation = cwsCSSAnimation($css_animation);

	$out .= "<section id='$section_id' class='posts_categories news blog_post posts_grid post_posts_grid posts_grid_{$columns} posts_grid_grid $animation'>";
	$out .= "<div class='cws_vc_shortcode_wrapper'>";
	$out .=	"<div class='cws_vc_shortcode_grid grid $grid_class layout-{$columns}' $attr>";	
 	foreach ($cat_terms as $id => $slug) {
 		if ($counter >= $count) break;

 		$term = get_term_by('slug', $slug, 'category');
		$term_id = $term->term_id;
 		$term_name = $term->name;
		$link = get_category_link($term_id);
		$term_image = get_term_meta( $term_id, 'cws_mb_term' );
		if ((bool)$square) {
			$dummy_image = get_template_directory_uri() . "/img/img_placeholder_crop.png";
		} else {
			$dummy_image = get_template_directory_uri() . "/img/img_placeholder.png";
		}
		$is_dummy = true;

		ob_start();
			if (!empty($term_image[0]['image']['src'])){
				$is_dummy = false;
				$dims['crop'] = true;
				$img_obj = cws_thumb( $term_image[0]['image']['src'], $thumbnail_dims , true );
			}
			?>
				<article <?php post_class(array( 'item','categories-grid')); ?>>
					<a class='category-block' href="<?php echo esc_url($link);?>">
						<img src='<?php echo esc_url( !$is_dummy ? $img_obj[0] : $dummy_image ); ?>' alt=''>
						<span class='category-label'><?php echo sprintf("%s", $term_name); ?></span>
					</a>
				</article>

			<?php
		$out .= ob_get_clean();
		$counter++;
 	}
				$out .= "</div>";
			$out .= "</div>";

 	$out .= "</section>";

	return $out;
}
add_shortcode( 'cws_sc_categories', 'cws_vc_shortcode_sc_categories' );

function cws_vc_shortcode_sc_twitter ( $atts = array(), $content = "" ){
	$theme_color 			= cws_vc_shortcode_get_option( 'theme_color' );
	$font_options 			= cws_vc_shortcode_get_option( 'body_font' );
	$font_color 			= $font_options['color'];	
	extract( shortcode_atts( array(
		"icon_lib"					=> "",
		'number' 					=> 4,
		'visible_number' 			=> 2,
		"css_animation"				=> "none",
		"el_class"					=> ""
 	), $atts));
	$icon_lib 				= esc_attr( $icon_lib );
	$icon 					= function_exists('cws_ext_vc_sc_get_icon') ? cws_ext_vc_sc_get_icon( $atts ) : "";
	$icon 					= esc_attr( $icon );
  	$number 				= esc_textarea( $number );
  	$visible_number 		= esc_textarea( $visible_number );
  	$el_class				= esc_attr( $el_class );
 	$number = empty( $number ) ? 4 : (int)$number;
 	$visible_number = empty( $visible_number ) ? 2 : (int)$visible_number;
	$classes = "cws_twitter cws_vc_shortcode_module";
	$classes .= !empty( $el_class ) ? " $el_class" : "";
	$classes = trim( $classes );
	$id = uniqid( "cws_twitter_" );

	$number = (int)$number;
	$visible_number = (int)$visible_number;
	$visible_number = $visible_number == 0 ? $number : $visible_number;
	$retrieved_tweets_number = 0;
	$is_plugin_installed = function_exists( 'cws_getTweets' );
	$tweets = $is_plugin_installed ? cws_getTweets( $number ) : array();
	$retrieved_tweets_number = count( $tweets );
	$is_carousel = $retrieved_tweets_number > $visible_number;
	if ( $is_carousel ){
		wp_enqueue_script( 'owl_carousel' );
	}
	$tweets_received = false;
	$animation = cwsCSSAnimation($css_animation);
	ob_start();
	if ( !empty( $tweets ) ){
		if ( isset( $tweets['error'] ) && !empty( $tweets['error'] ) ){
			echo do_shortcode( "[cws_sc_msg_box title='" . esc_html__( 'Error', 'cws-essentials' ) . "' type='error']" . esc_html( $tweets['error'] ) . "[/cws_sc_msg_box]" );
		}
		else{
			if ( $is_carousel ){
				echo "<ul class='cws_tweets widget_carousel bullets_nav $animation'>";
				$groups_count = ceil( $retrieved_tweets_number / $visible_number );
				for ( $i = 0; $i < $groups_count; $i++ ){
					echo "<li class='cws_tweets_group'>";
						echo "<ul>";
						for( $j = $i * $visible_number; ( ( $j < ( $i + 1 ) * $visible_number ) && ( $j < $retrieved_tweets_number ) ); $j++ ){
							$tweet = $tweets[$j];
							$tweet_text = $tweet['text'];
							$tweet_date = $tweet['created_at'];
							echo "<li class='tweet'>";
								echo "<div class='text'>";
									echo esc_html( $tweet_text );
								echo "</div>";
								echo "<div class='date'>";
									echo esc_html( date( "Y-m-d H:i:s", strtotime( $tweet_date ) ) );
								echo "</div>";	
							echo "</li>";						
						}
						echo "</ul>";
					echo "</li>";
				}
				echo "</ul>";
			}
			else{
				echo "<ul class='cws_tweets $animation'>";
					foreach ( $tweets as $tweet ) {
						echo "<li class='tweet'>";
							$tweet_text = $tweet['text'];
							$tweet_date = $tweet['created_at'];
							echo "<div class='text'>";
								echo esc_html( $tweet_text );
							echo "</div>";
							echo "<div class='date'>";
								echo esc_html( date( "Y-m-d H:i:s", strtotime( $tweet_date ) ) );
							echo "</div>";
						echo "</li>";
					}
				echo "</ul>";
			}
			$tweets_received = true;
		}
	}
	else{
		if ( !$is_plugin_installed ){
			echo do_shortcode( "[cws_sc_msg_box title='" . esc_html__( 'Plugin not installed', 'cws-essentials' ) . "' type='warn']" . esc_html__( 'Please install and activate required plugin ', 'cws-essentials' ) . "<a href='https://ru.wordpress.org/plugins/oauth-twitter-feed-for-developers/'>" . esc_html__( "oAuth Twitter Feed for Developers", 'cws-essentials' ) . "</a>[/cws_sc_msg_box]" );
		}
	}
	$twitter_response = ob_get_clean();

	ob_start();
		echo $twitter_response;
	$out = ob_get_clean();

	return $out;
}
add_shortcode( 'cws_sc_twitter', 'cws_vc_shortcode_sc_twitter' );

function cws_vc_shortcode_sc_text ( $atts = array(), $content = "" ){
	global $cws_theme_funcs;
	$theme_first_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-first-color' ) );	
	$theme_second_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-second-color' ) );	
	$theme_helper_color = esc_attr( $cws_theme_funcs->cws_get_option( 'theme-helper-color' ) );	

	$defaults = array(
		'subtitle'					=> '',
		'subtitile_decor'			=> true,
		'title'						=> '',
		'drop_shadow_prop'			=> '5px 6px',
		'drop_shadow_color'			=> '#A9C9BB',
		'title_tag'					=> 'h3',
		'banner'					=> '',
		'text_alignment'			=> 'left',
		'no_infinite'				=> false,
		'tablet_center'				=> false,
		'mobile_center'				=> false,
		'marked_list'				=> '',
		'button_title'				=> '',
		'button_url'				=> '#',
		'width'						=> '',
		'add_button'				=> false,
		'customize_colors'			=> true,
		'custom_font_color'			=> '',
		'custom_title_color'		=> $theme_second_color,
		'custom_title_bg_color'		=> '',
		'custom_subtitle_color'		=> $theme_first_color,
		'custom_banner_font_color'	=> '#eae5de',
		'custom_banner_bg_color'	=> $theme_second_color,
		'custom_button_color'		=> $theme_second_color,
		'custom_hover_button_color'	=> $theme_first_color,
		'size'						=> '3x',
		'customize_size'			=> '',
		'title_margins'				=> '0px 0px 0px 0px',
		'text_margins'				=> '0px 0px 0px 0px',
		'subtitle_size'				=> '30px',
		'title_size'				=> '175px',
		'banner_size'				=> '45px',
		'size_i'					=> '',
		"css_animation"				=> "none",
		'el_class'					=> '',
		'custom_styles'				=> '',
 	);
	$proc_atts = shortcode_atts( $defaults, $atts );
	extract( $proc_atts );
	$drop_shadow_prop			= esc_attr( $drop_shadow_prop );
	$drop_shadow_color 			= esc_attr( $drop_shadow_color );
	$title_tag 					= esc_attr( $title_tag );
	$text_alignment 			= esc_attr( $text_alignment );
	$no_infinite 				= (bool)$no_infinite;
	$tablet_center 				= (bool)$tablet_center;
	$mobile_center 				= (bool)$mobile_center;
	$add_button 				= (bool)$add_button;
	$button_title 				= esc_html($button_title);
	$button_url 				= esc_attr($button_url);
	$customize_colors 			= (bool)$customize_colors;
	$custom_font_color 			= esc_attr( $custom_font_color );
	$custom_subtitle_color 		= esc_attr( $custom_subtitle_color );
	$custom_title_color 		= esc_attr( $custom_title_color );
	$custom_title_bg_color 		= esc_attr( $custom_title_bg_color );
	$custom_banner_font_color 	= esc_attr( $custom_banner_font_color );
	$custom_banner_bg_color 	= esc_attr( $custom_banner_bg_color );
	$custom_button_color 		= esc_attr( $custom_button_color );
	$custom_hover_button_color 	= esc_attr( $custom_hover_button_color );
	$el_class					= esc_attr( $el_class );
	$subtitle_size				= esc_attr( $subtitle_size );
	$title_margins				= esc_attr( $title_margins );
	$text_margins				= esc_attr( $text_margins );
	$banner_size				= esc_attr( $banner_size );
	$title_size					= esc_attr( $title_size );
	$size						= !empty($size) ? esc_attr( $size ) : "5х";

	$custom_styles = esc_attr( $custom_styles );
	$custom_css_class = "";

	if ( is_plugin_active('js_composer/js_composer.php') ){
		$custom_css_class 	= apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $custom_styles, ' ' ), 'cws_sc_text', $atts );
	} else {
		$custom_css_class = '';
	}

	$title = wp_kses( $title, array(
		"b"			=> array(),
		"strong"	=> array(),
		"mark"		=> array(),
		"br"		=> array()
	));
	$content = apply_filters( "the_content", $content );
	$module_id = uniqid( "cws_textmodule_" );
	$out = $titles = $icon_html = $styles = "";
	$animation = cwsCSSAnimation($css_animation);
		
	ob_start();
	if ( !empty( $title ) || !empty( $subtitle ) || !empty( $content ) || !empty( $icon ) ){
		$out .= "<div class='cws_textmodule cws_vc_shortcode_module" . $animation . ( !empty( $el_class ) ? " $el_class" : "" ) . ( !empty( $custom_css_class ) ? " $custom_css_class" : "" ) . "' id='$module_id'>";

			if( $subtitile_decor && !empty($custom_subtitle_color) ){
				$styles .= "
					#{$module_id} .cws_textmodule_titles .cws_textmodule_subtitle_wrapper .subtitile_right_decor:after,
					#{$module_id} .cws_textmodule_titles .cws_textmodule_subtitle_wrapper .subtitile_left_decor:after,
					#{$module_id} .cws_textmodule_titles .cws_textmodule_subtitle_wrapper .subtitile_right_decor:before,
					#{$module_id} .cws_textmodule_titles .cws_textmodule_subtitle_wrapper .subtitile_left_decor:before{
						background-color: ".$custom_subtitle_color.";
					}
				";
			}
			if( !empty($drop_shadow_prop) && !empty($drop_shadow_color) ){
				$styles .= "
					#{$module_id} .cws_textmodule_title{
						filter: drop-shadow(".$drop_shadow_prop." 0 ".$drop_shadow_color.");
					}
					@media(max-width: 767px){
						#{$module_id} .cws_textmodule_title{
							filter: drop-shadow(2px 3px 0 ".$drop_shadow_color.");
						}
					}
				";
			}
			if( !empty($customize_size) ){
				$styles .= "
					#{$module_id} .cws_service_icon{
						" . ( !empty($size_i) ? "font-size: ".(int)$size_i ."px;" : "" ) .  "
					}
					#{$module_id} .cws_textmodule_titles .cws_textmodule_subtitle{
						" . ( !empty($subtitle_size) ? "font-size: ".(int)$subtitle_size ."px;" : "" ) .  "
					}
					#{$module_id} .cws_textmodule_titles .cws_textmodule_title{
						" . ( !empty($title_size) ? "font-size: ".(int)$title_size ."px;" : "" ) .  "
					}
					#{$module_id} .cws_textmodule_titles .cws_textmodule_title{
						" . ( !empty($title_margins) ? "margin: ".$title_margins .";" : "" ) .  "
					}
					#{$module_id} .cws_textmodule_content .text_content_wrapper{
						" . ( !empty($text_margins) ? "margin: ".$text_margins .";" : "" ) .  "
					}
					#{$module_id} .cws_textmodule_banner{
						" . ( !empty($banner_size) ? "font-size: ".(int)$banner_size ."px;" : "" ) .  "
					}
				";
			}
			if( $customize_colors ){
				if( !empty($custom_title_bg_color) ){
					$styles .= "
						#{$module_id} .cws_textmodule_title{
							background-color: ".$custom_title_bg_color.";
							box-shadow: -6px 0 0 ".$custom_title_bg_color.";
						}
					";
				}
				if( !empty($custom_banner_bg_color) ){
					$styles .= "
						#{$module_id} .cws_textmodule_text.text_align_right .cws_textmodule_banner:after,
						#{$module_id} .cws_textmodule_text.text_align_left .cws_textmodule_banner:before,
						#{$module_id} .cws_textmodule_banner{
							background-color: ".$custom_banner_bg_color.";
						}
						#{$module_id} .cws_textmodule_banner:before,
						#{$module_id} .cws_textmodule_banner:after{
							border-color: transparent transparent ".$custom_banner_bg_color." transparent;
						}
						#{$module_id} .cws_textmodule_banner .left-shape .rect-pattern,
						#{$module_id} .cws_textmodule_banner .right-shape .rect-pattern{
							fill: ".$custom_banner_bg_color.";
						}
					";
				}
				$styles .= "
					#{$module_id}{
						" . ( !empty( $custom_font_color ) ? "color:$custom_font_color;" : "" ) .  "
					}
					#{$module_id} .cws_textmodule_subtitle{
						" . ( !empty( $custom_subtitle_color ) ? "color:$custom_subtitle_color;" : "" ) .  "
					}
					#{$module_id} .cws_textmodule_title{
						" . ( !empty( $custom_title_color ) ? "color:$custom_title_color;" : "" ) .  "
					}
					#{$module_id} .cws_textmodule_banner{
						" . ( !empty( $custom_banner_font_color ) ? "color:$custom_banner_font_color;" : "" ) .  "
					}
					#{$module_id} .cws_custom_button{
						" . ( !empty( $custom_button_color ) ? "color: $custom_button_color;" : "" ) .  "
						" . ( !empty( $custom_button_color ) ? "border-color: $custom_button_color;" : "" ) .  "
					}
					#{$module_id} .cws_custom_button:before,
					#{$module_id} .cws_custom_button:after{
						" . ( !empty( $custom_button_color ) ? "background-color: $custom_button_color;" : "" ) .  "
					}
					#{$module_id} .cws_custom_button:hover{
						" . ( !empty( $custom_hover_button_color ) ? "color: $custom_hover_button_color;" : "" ) .  "
						" . ( !empty( $custom_hover_button_color ) ? "border-color: $custom_hover_button_color;" : "" ) .  "
					}
					#{$module_id} .cws_custom_button:hover:before,
					#{$module_id} .cws_custom_button:hover:after{
						" . ( !empty( $custom_hover_button_color ) ? "background-color: $custom_hover_button_color;" : "" ) .  "
					}
				";
			}
			if ( !empty( $styles ) ){
				Cws_shortcode_css()->enqueue_cws_css($styles);
			}
			$out .= "<div class='cws_textmodule_wrapper'>";				
				if ( !empty( $title ) || !empty( $subtitle ) || !empty( $content ) ){
					$out .= "<div class='cws_textmodule_text" . ($no_infinite ? ' no_infinite' : '') . ($tablet_center ? ' tablet_center' : '') . ($mobile_center ? ' mobile_center' : '') . ( !empty( $text_alignment ) ? " text_align_{$text_alignment}" : "" ) . "'" . ( !empty( $width ) ? " style='max-width:{$width}px;'" : "" ) . ">";
						$out .= "<div class='cws_textmodule_titles'>";
							if ( !empty( $subtitle ) ){
								$out .= "<div class='cws_textmodule_subtitle_wrapper".($subtitile_decor ? ' with_decor' : '')."'>";
									if( $subtitile_decor ){
										$out .= "<span class='subtitile_left_decor'></span>";
									}
									$out .= "<h4 class='cws_textmodule_subtitle'>". esc_html( $subtitle )."</h4>";
									if( $subtitile_decor ){
										$out .= "<span class='subtitile_right_decor'></span>";
									}
								$out .= "</div>";
							}
							if ( !empty( $title ) ){
								$out .= "<". $title_tag ." class='cws_textmodule_title".(!empty($custom_title_bg_color) ? " with_bg" : "").((int)$title_size > 100 ? " large" : " small")."'>" . esc_html( $title ) ."</". $title_tag .">";
							}
						$out .= "</div>";
						if ( !empty( $banner ) ){
							$shape_left_ID = uniqid('banner_left_shape_');
							$shape_right_ID = uniqid('banner_right_shape_');

							$out .= "<div class='cws_textmodule_banner ".(!empty($text_alignment) ? "{$text_alignment}" : "")."'>";
								$out .= '
									<svg class="left-shape" width="78" height="52">
										<defs>
										  <pattern id="'.$shape_left_ID.'" patternUnits="objectBoundingBox" width="100%" height="100%">
										  	<rect class="rect-pattern" x="0" y="0" width="100%" height="100%" stroke-width="0" />
										    <image href="'.get_template_directory_uri().'/img/patterns/shape_pattern.png" x="0" y="0" width="100%" height="100%" />
										    <rect x="0" y="0" width="100%" height="100%" stroke-width="0" fill="rgba(0,0,0,.15)" />
										  </pattern>
										</defs>

										<path id="'.$shape_left_ID.'_path" d="M0.7,0.2l12,25.9L0.7,51.5l76.9,0.1l0.1-51.2C77.6,0.4,0.7,0.2,0.7,0.2z" fill="url(#'.$shape_left_ID.')" />
									</svg>
								';
								$out .= esc_html( $banner );
								$out .= '
									<svg class="right-shape" width="78" height="52">
										<defs>
										  <pattern id="'.$shape_right_ID.'" patternUnits="userSpaceOnUse" width="100%" height="100%">
										  	<rect class="rect-pattern" x="0" y="0" width="100%" height="100%" stroke-width="0" />
										    <image href="'.get_template_directory_uri().'/img/patterns/shape_pattern.png" x="0" y="0" width="100%" height="100%" />
										    <rect x="0" y="0" width="100%" height="100%" stroke-width="0" fill="rgba(0,0,0,.15)" />
										  </pattern>
										</defs>

										<path id="'.$shape_right_ID.'_path" d="M0,0.4L0,51.6l76.9-0.1L64.9,26.1l12-25.9C76.8,0.2,0,0.4,0,0.4z" fill="url(#'.$shape_right_ID.')" />
									</svg>
								';
							$out .= "</div>";
						}
						if ( !empty( $content ) || $add_button ){
							$out .= "<div class='cws_textmodule_content'>";
								$out .= "<div class='text_content_wrapper'>";
									if ( !empty( $content ) ){
										$out .= $content;
									}
								$out .= "</div>";
							$out .= "</div>";
							if ($add_button){
								$out .= "<a ".(!empty($button_url) ? 'href="'.$button_url.'"' : '')." class='cws_custom_button advanced'>".(!empty($button_title) ? $button_title : '')."</a>";
							}
						}
					$out .= "</div>";
				}
			$out .= "</div>";
		$out .= "</div>";
	}
	$out .= ob_get_clean();
	return $out;
}
add_shortcode( 'cws_sc_text', 'cws_vc_shortcode_sc_text' );


function cws_vc_shortcode_sc_tips($atts, $content=null, $tag) {
	extract( shortcode_atts( array(
		'image' => '',
		'width' => '',
		'color' => '',
		'ispulse' => 'yes',
		'pulsecolor' => 'pulse-white',
		'icon' => '',
		'iconsize' => '',
		'tooltipstyle' => 'shadow',
		'iconbackground' => 'rgba(0,0,0,0.8)',
		'tooltipanimation' => 'grow',
		'circlecolor' => '#FFFFFF',
		'opacity' => '1',
		'arrowposition' => '',
		'trigger' => '',
		'links' => '',
		'maxwidth' => '240',
		'custom_links_target' => '',
		'position' => '25%|30%,35%|20%,45%|60%,75%|20%',
		'containerwidth' => '',
		'marginoffset' => '',
		'icontype' => 'dot',
		'fonticon' => '',
		'isdisplayall' => 'off',
		'displayednum' => '1',
		'startnumber' => '1',
		'extra_class' => ''
		), $atts ) );

	$image_full = wp_get_attachment_image_src($image, 'full');
	$position = explode(',', $position);
	$color = explode(',', $color);
	$arrowposition = explode(',', $arrowposition);
	$links = explode(',', $links);
	$fonticon = explode(',', $fonticon);
	$i = -1;
	$is_new_tag = false;
          $content = wpb_js_remove_wpautop($content); // fix unclosed/unwanted paragraph tags in $content
          if(strpos($content, '[/cwstips]')===false){
          	$content = str_replace('</div>', '', trim($content));
          	$contentarr = explode('<div class="tooltip-content">', trim($content));
          }else{
          	$content = str_replace('[/cwstips]', '', trim($content));
          	$contentarr = explode('[cwstips]', trim($content));
          	$is_new_tag = true;
          }
          $pulseborder = "";
          $ispulse = $ispulse == "yes" ? $pulsecolor : "";
          array_shift($contentarr);
          $output = $tooltipcontent = '';
          $output .= '<div style="width:'.$containerwidth.';" class="cwstooltip-wrapper '.$extra_class.'" data-opacity="'.$opacity.'" data-tooltipanimation="'.$tooltipanimation.'" data-tooltipstyle="'.$tooltipstyle.'" data-trigger="'.$trigger.'" data-maxwidth="'.$maxwidth.'" data-marginoffset="'.$marginoffset.'" data-isdisplayall="'.$isdisplayall.'" data-displayednum="'.$displayednum.'">';

          $image_temp = $imagethumb = "";
          $fullimage = $image_full[0];
          $imagethumb = $fullimage;
          $attachment = get_post($image);
          if($width!=""){
          	if(function_exists('wpb_resize')){
          		$image_temp = wpb_resize($image, null, $width, null);
          		$imagethumb = $image_temp['url'];
          		if($imagethumb=="") $imagethumb = $fullimage;
          	}
          }

          $output .= '<img src="'.$imagethumb.'" alt="'.get_post_meta($attachment->ID, '_wp_attachment_image_alt', true ).'" />';
          $output .= '<div class="cws-hotspots">';
          foreach ($contentarr as $key => $thecontent) {
          	$i++;
          	$tooltipcontent = '';
          	if(!isset($position[$i])) $position[$i] = '25%|25%';
          	if(!isset($fonticon[$i])) $fonticon[$i] = '';
          	$iconposition = explode('|', trim($position[$i]));
          	if(!isset($iconposition[0])) $iconposition[0] = '25%';
          	if(!isset($iconposition[1])) $iconposition[1] = '25%';
          	if(!isset($color[$i])) $color[$i] = '';
          	if(!isset($arrowposition[$i])) $arrowposition[$i] = 'top';
          	if(!isset($links[$i])) $links[$i] = '';
          	if($color[$i]!="") {
          		$iconcolor = $color[$i];
          	}else{
          		$iconcolor = $iconbackground;
          	}
          	$tooltipcontent = trim($thecontent); 
          	$tooltipcontent = preg_replace("/(^)?(<br\s*\/?>\s*)+$/", "", $tooltipcontent);
          	$tooltipcontent = preg_replace('/^(<br \/>)*/', "", $tooltipcontent);
          	$tooltipcontent = preg_replace('/^(<\/p>)*/', "", $tooltipcontent);
          	$output .= '<div class="hotspot-item '.$ispulse.' '.$pulseborder.'" style="top:'.$iconposition[0].';left:'.$iconposition[1].';" data-top="'.$iconposition[0].'" data-left="'.$iconposition[1].'">';
          	if($links[$i]!=""){
          		$output .= '<a href="'.$links[$i].'" class="cws-tooltip" style="background:'.$iconcolor.';" data-tooltip="'.htmlspecialchars($tooltipcontent).'" data-arrowposition="'.trim($arrowposition[$i]).'" target="'.$custom_links_target.'">';
          	}else{
          		$output .= '<a href="#" class="cws-tooltip" style="background:'.$iconcolor.';" data-tooltip="'.htmlspecialchars($tooltipcontent).'" data-arrowposition="'.trim($arrowposition[$i]).'">';
          	}
          	if($icontype=="number"){
          		if($startnumber!=1){
          			$output .= '<i>';
          			$output .= $startnumber+$i;
          			$output .= '</i>';
          		}else{
          			$output .= '<i>';
          			$output .= $i+1;
          			$output .= '</i>';
          		}
          	}else if($icontype=="icon"){
          		if($fonticon[$i]!=""){
          			$output .= '<i class="fa '.$fonticon[$i].'" style="color:'.$circlecolor.';"></i>';
          		}else{
          			$output .= '<span style="background:'.$circlecolor.';">';
          			$output .= '</span>';
          		}
          	}else{
          		$output .= '<span style="background:'.$circlecolor.';">';
          		$output .= '</span>';
          	}

          	$output .= '</a>';
          	$output .= '</div>';
          }
          $output .= '</div>';
          $output .= '</div>';

          return $output;
}

add_shortcode( 'cws_sc_tips', 'cws_vc_shortcode_sc_tips' );

/***********
* LEARNPRESS
***********/
function cws_vc_shortcode_sc_vc_lp_course_posts_grid ( $atts = array(), $content = "" ){
	$post_type = defined( "LP_COURSE_CPT" ) ? LP_COURSE_CPT : "lp_course";	
	$defaults = array(
		'title'				=> '',
		'title_align'		=> 'left',
		'total_items_count'	=> '',
		'display_style'		=> 'grid',
		'layout'			=> '3',
		'items_pp'			=> esc_html( get_option( 'posts_per_page' ) ),
		'el_class'			=> '',
	);
	$proc_atts = shortcode_atts( $defaults, $atts );
	extract( $proc_atts );
	$out = "";
	$tax = isset( $atts[$post_type . '_tax'] ) ? $atts[$post_type . '_tax'] : '';
	$terms = isset( $atts["{$post_type}_{$tax}_terms"] ) ? $atts["{$post_type}_{$tax}_terms"] : "";
	$proc_atts = array_merge( $proc_atts, array(
		'tax'									=> $tax,
		'terms'									=> $terms
	));
	$out .= function_exists( "cws_vc_shortcode_sc_lp_course_posts_grid" ) ? cws_vc_shortcode_sc_lp_course_posts_grid( $proc_atts ) : "";
	return $out;
}

if ( is_plugin_active('learnpress/learnpress.php') ) {
	add_shortcode( 'cws_sc_vc_lp_course_posts_grid', 'cws_vc_shortcode_sc_vc_lp_course_posts_grid' );
}
/************
* \LEARNPRESS
************/

/**
 * Processes like/unlike
 * @since    0.5
 */
add_action( 'wp_enqueue_scripts', 'cws_vc_shortcode_sl_enqueue_scripts' );
function cws_vc_shortcode_sl_enqueue_scripts() {
	wp_enqueue_script( 'simple-likes-public-js', CWS_SHORTCODES_PLUGIN_URL . '/assets/js/simple-likes-public.js', array( 'jquery' ), '0.5', false );
	wp_localize_script( 'simple-likes-public-js', 'simpleLikes', array(
		'ajaxurl' => admin_url( 'admin-ajax.php' ),
		'like' => esc_html__( 'Like', 'cws-essentials' ),
		'unlike' => esc_html__( 'Unlike', 'cws-essentials' )
		) ); 
}

add_action( 'wp_ajax_nopriv_cws_vc_shortcode_process_simple_like', 'cws_vc_shortcode_process_simple_like' );
add_action( 'wp_ajax_cws_vc_shortcode_process_simple_like', 'cws_vc_shortcode_process_simple_like' );
function cws_vc_shortcode_process_simple_like() {
	// Security
	$nonce = isset( $_REQUEST['nonce'] ) ? sanitize_text_field( $_REQUEST['nonce'] ) : 0;
	if ( !wp_verify_nonce( $nonce, 'simple-likes-nonce' ) ) {
		exit( esc_html__( 'Not permitted', 'cws-essentials' ) );
	}
	// Test if javascript is disabled
	$disabled = ( isset( $_REQUEST['disabled'] ) && $_REQUEST['disabled'] == true ) ? true : false;
	// Test if this is a comment
	$is_comment = ( isset( $_REQUEST['is_comment'] ) && $_REQUEST['is_comment'] == 1 ) ? 1 : 0;
	// Base variables
	$post_id = ( isset( $_REQUEST['post_id'] ) && is_numeric( $_REQUEST['post_id'] ) ) ? $_REQUEST['post_id'] : '';
	$result = array();
	$post_users = NULL;
	$like_count = 0;
	// Get plugin options
	if ( $post_id != '' ) {
		$count = ( $is_comment == 1 ) ? get_comment_meta( $post_id, "_comment_like_count", true ) : get_post_meta( $post_id, "_post_like_count", true ); // like count
		$count = ( isset( $count ) && is_numeric( $count ) ) ? $count : 0;
		if ( !cws_vc_shortcode_already_liked( $post_id, $is_comment ) ) { // Like the post
			if ( is_user_logged_in() ) { // user is logged in
				$user_id = get_current_user_id();
				$post_users = cws_vc_shortcode_post_user_likes( $user_id, $post_id, $is_comment );
				if ( $is_comment == 1 ) {
					// Update User & Comment
					$user_like_count = get_user_option( "_comment_like_count", $user_id );
					$user_like_count =  ( isset( $user_like_count ) && is_numeric( $user_like_count ) ) ? $user_like_count : 0;
					update_user_option( $user_id, "_comment_like_count", ++$user_like_count );
					if ( $post_users ) {
						update_comment_meta( $post_id, "_user_comment_liked", $post_users );
					}
				} else {
					// Update User & Post
					$user_like_count = get_user_option( "_user_like_count", $user_id );
					$user_like_count =  ( isset( $user_like_count ) && is_numeric( $user_like_count ) ) ? $user_like_count : 0;
					update_user_option( $user_id, "_user_like_count", ++$user_like_count );
					if ( $post_users ) {
						update_post_meta( $post_id, "_user_liked", $post_users );
					}
				}
			} else { // user is anonymous
				$user_ip = cws_vc_shortcode_sl_get_ip();
				$post_users = cws_vc_shortcode_post_ip_likes( $user_ip, $post_id, $is_comment );
				// Update Post
				if ( $post_users ) {
					if ( $is_comment == 1 ) {
						update_comment_meta( $post_id, "_user_comment_IP", $post_users );
					} else { 
						update_post_meta( $post_id, "_user_IP", $post_users );
					}
				}
			}
			$like_count = ++$count;
			$response['status'] = "liked";
			$response['icon'] = cws_vc_shortcode_get_liked_icon();
		} else { // Unlike the post
			if ( is_user_logged_in() ) { // user is logged in
				$user_id = get_current_user_id();
				$post_users = cws_vc_shortcode_post_user_likes( $user_id, $post_id, $is_comment );
				// Update User
				if ( $is_comment == 1 ) {
					$user_like_count = get_user_option( "_comment_like_count", $user_id );
					$user_like_count =  ( isset( $user_like_count ) && is_numeric( $user_like_count ) ) ? $user_like_count : 0;
					if ( $user_like_count > 0 ) {
						update_user_option( $user_id, "_comment_like_count", --$user_like_count );
					}
				} else {
					$user_like_count = get_user_option( "_user_like_count", $user_id );
					$user_like_count =  ( isset( $user_like_count ) && is_numeric( $user_like_count ) ) ? $user_like_count : 0;
					if ( $user_like_count > 0 ) {
						update_user_option( $user_id, '_user_like_count', --$user_like_count );
					}
				}
				// Update Post
				if ( $post_users ) {	
					$uid_key = array_search( $user_id, $post_users );
					unset( $post_users[$uid_key] );
					if ( $is_comment == 1 ) {
						update_comment_meta( $post_id, "_user_comment_liked", $post_users );
					} else { 
						update_post_meta( $post_id, "_user_liked", $post_users );
					}
				}
			} else { // user is anonymous
				$user_ip = cws_vc_shortcode_sl_get_ip();
				$post_users = cws_vc_shortcode_post_ip_likes( $user_ip, $post_id, $is_comment );
				// Update Post
				if ( $post_users ) {
					$uip_key = array_search( $user_ip, $post_users );
					unset( $post_users[$uip_key] );
					if ( $is_comment == 1 ) {
						update_comment_meta( $post_id, "_user_comment_IP", $post_users );
					} else { 
						update_post_meta( $post_id, "_user_IP", $post_users );
					}
				}
			}
			$like_count = ( $count > 0 ) ? --$count : 0; // Prevent negative number
			$response['status'] = "unliked";
			$response['icon'] = cws_vc_shortcode_get_unliked_icon();
		}
		if ( $is_comment == 1 ) {
			update_comment_meta( $post_id, "_comment_like_count", $like_count );
			update_comment_meta( $post_id, "_comment_like_modified", date( 'Y-m-d H:i:s' ) );
		} else { 
			update_post_meta( $post_id, "_post_like_count", $like_count );
			update_post_meta( $post_id, "_post_like_modified", date( 'Y-m-d H:i:s' ) );
		}
		$response['count'] = get_like_count( $like_count );
		$response['testing'] = $is_comment;
		if ( $disabled == true ) {
			if ( $is_comment == 1 ) {
				wp_redirect( get_permalink( get_the_ID() ) );
				exit();
			} else {
				wp_redirect( get_permalink( $post_id ) );
				exit();
			}
		} else {
			wp_send_json( $response );
		}
	}
}

function cws_vc_shortcode_already_liked( $post_id, $is_comment ) {
	$post_users = NULL;
	$user_id = NULL;
	if ( is_user_logged_in() ) { // user is logged in
		$user_id = get_current_user_id();
		$post_meta_users = ( $is_comment == 1 ) ? get_comment_meta( $post_id, "_user_comment_liked" ) : get_post_meta( $post_id, "_user_liked" );
		if ( count( $post_meta_users ) != 0 ) {
			$post_users = $post_meta_users[0];
		}
	} else { // user is anonymous
		$user_id = cws_vc_shortcode_sl_get_ip();
		$post_meta_users = ( $is_comment == 1 ) ? get_comment_meta( $post_id, "_user_comment_IP" ) : get_post_meta( $post_id, "_user_IP" ); 
		if ( count( $post_meta_users ) != 0 ) { // meta exists, set up values
			$post_users = $post_meta_users[0];
		}
	}
	if ( is_array( $post_users ) && in_array( $user_id, $post_users ) ) {
		return true;
	} else {
		return false;
	}
}

function cws_vc_shortcode_get_simple_likes_button( $post_id, $is_comment = NULL ) {
	$is_comment = ( NULL == $is_comment ) ? 0 : 1;
	$output = '';
	$nonce = wp_create_nonce( 'simple-likes-nonce' ); // Security
	if ( $is_comment == 1 ) {
		$post_id_class = esc_attr( ' sl-comment-button-' . $post_id );
		$comment_class = esc_attr( ' sl-comment' );
		$like_count = get_comment_meta( $post_id, "_comment_like_count", true );
		$like_count = ( isset( $like_count ) && is_numeric( $like_count ) ) ? $like_count : 0;
	} else {
		$post_id_class = esc_attr( ' sl-button-' . $post_id );
		$comment_class = esc_attr( '' );
		$like_count = get_post_meta( $post_id, "_post_like_count", true );
		$like_count = ( isset( $like_count ) && is_numeric( $like_count ) ) ? $like_count : 0;
	}
	$count = get_like_count( $like_count );
	$icon_empty = cws_vc_shortcode_get_unliked_icon();
	$icon_full = cws_vc_shortcode_get_liked_icon();
	// Loader
	$loader = '<span class="sl-loader"></span>';
	// Liked/Unliked Variables
	if ( cws_vc_shortcode_already_liked( $post_id, $is_comment ) ) {
		$class = esc_attr( ' liked' );
		$title = esc_html__( 'Unlike', 'cws-essentials' );
		$icon = $icon_full;
	} else {
		$class = '';
		$title = esc_html__( 'Like', 'cws-essentials' );
		$icon = $icon_empty;
	}
	$output = '<span class="sl-wrapper"><a href="' . admin_url( 'admin-ajax.php?action=cws_vc_shortcode_process_simple_like' . '&post_id=' . $post_id . '&nonce=' . $nonce . '&is_comment=' . $is_comment . '&disabled=true' ) . '" class="sl-button' . $post_id_class . $class . $comment_class . '" data-nonce="' . $nonce . '" data-post-id="' . $post_id . '" data-iscomment="' . $is_comment . '" title="' . $title . '">' . $icon . $count . '</a>' . $loader . '</span>';
	return $output;
} 

add_shortcode( 'jmliker', 'cws_vc_shortcode_sl_shortcode' );
function cws_vc_shortcode_sl_shortcode() {
	return cws_vc_shortcode_get_simple_likes_button( get_the_ID(), 0 );
}

function cws_vc_shortcode_post_user_likes( $user_id, $post_id, $is_comment ) {
	$post_users = '';
	$post_meta_users = ( $is_comment == 1 ) ? get_comment_meta( $post_id, "_user_comment_liked" ) : get_post_meta( $post_id, "_user_liked" );
	if ( count( $post_meta_users ) != 0 ) {
		$post_users = $post_meta_users[0];
	}
	if ( !is_array( $post_users ) ) {
		$post_users = array();
	}
	if ( !in_array( $user_id, $post_users ) ) {
		$post_users['user-' . $user_id] = $user_id;
	}
	return $post_users;
}

function cws_vc_shortcode_post_ip_likes( $user_ip, $post_id, $is_comment ) {
	$post_users = '';
	$post_meta_users = ( $is_comment == 1 ) ? get_comment_meta( $post_id, "_user_comment_IP" ) : get_post_meta( $post_id, "_user_IP" );
	// Retrieve post information
	if ( count( $post_meta_users ) != 0 ) {
		$post_users = $post_meta_users[0];
	}
	if ( !is_array( $post_users ) ) {
		$post_users = array();
	}
	if ( !in_array( $user_ip, $post_users ) ) {
		$post_users['ip-' . $user_ip] = $user_ip;
	}
	return $post_users;
}

function cws_vc_shortcode_sl_get_ip() {
	if ( isset( $_SERVER['HTTP_CLIENT_IP'] ) && ! empty( $_SERVER['HTTP_CLIENT_IP'] ) ) {
		$ip = $_SERVER['HTTP_CLIENT_IP'];
	} elseif ( isset( $_SERVER['HTTP_X_FORWARDED_FOR'] ) && ! empty( $_SERVER['HTTP_X_FORWARDED_FOR'] ) ) {
		$ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
	} else {
		$ip = ( isset( $_SERVER['REMOTE_ADDR'] ) ) ? $_SERVER['REMOTE_ADDR'] : '0.0.0.0';
	}
	$ip = filter_var( $ip, FILTER_VALIDATE_IP );
	$ip = ( $ip === false ) ? '0.0.0.0' : $ip;
	return $ip;
}

function cws_vc_shortcode_get_liked_icon() {
	/* If already using Font Awesome with your theme, replace svg with: <i class="fa fa-heart"></i> */
	$icon = '<span class="sl-icon unliked"></span>';
	return $icon;
}

function cws_vc_shortcode_get_unliked_icon() {
	/* If already using Font Awesome with your theme, replace svg with: <i class="fa fa-heart-o"></i> */
	$icon = '<span class="sl-icon liked"></span>';
	return $icon;
}

function cws_vc_shortcode_sl_format_count( $number ) {
	$precision = 2;
	if ( $number >= 1000 && $number < 1000000 ) {
		$formatted = number_format( $number/1000, $precision ).'K';
	} else if ( $number >= 1000000 && $number < 1000000000 ) {
		$formatted = number_format( $number/1000000, $precision ).'M';
	} else if ( $number >= 1000000000 ) {
		$formatted = number_format( $number/1000000000, $precision ).'B';
	} else {
		$formatted = $number; // Number is less than 1000
	}
	$formatted = str_replace( '.00', '', $formatted );
	return $formatted;
}

function get_like_count( $like_count ) {
	$like_text = esc_html__( '0', 'cws-essentials' );
	if ( is_numeric( $like_count ) && $like_count > 0 ) { 
		$number = cws_vc_shortcode_sl_format_count( $like_count );
	} else {
		$number = $like_text;
	}
	$count = '<span class="sl-count">' . $number . '</span>';	


	return $count;
}

// User Profile List
add_action( 'show_user_profile', 'cws_vc_shortcode_show_user_likes' );
add_action( 'edit_user_profile', 'cws_vc_shortcode_show_user_likes' );
function cws_vc_shortcode_show_user_likes( $user ) { ?>        
	<table class="form-table">
		<tr>
			<th><label for="user_likes"><?php esc_html_e( 'You Like:', 'cws-essentials' ); ?></label></th>
			<td>
				<?php
				$types = get_post_types( array( 'public' => true ) );
				$args = array(
					'numberposts' => -1,
					'post_type' => $types,
					'meta_query' => array (
						array (
							'key' => '_user_liked',
							'value' => $user->ID,
							'compare' => 'LIKE'
							)
						) );		
				$sep = '';
				$like_query = new WP_Query( $args );
				if ( $like_query->have_posts() ) : ?>
					<p>
						<?php while ( $like_query->have_posts() ) : $like_query->the_post(); 
						echo sprintf('%s', $sep); ?><a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>"><?php the_title(); ?></a>
						<?php
						$sep = ' &middot; ';
						endwhile; 
						?>
					</p>
				<?php else : ?>
				<p><?php esc_html_e( 'You do not like anything yet.', 'cws-essentials' ); ?></p>
				<?php 
				endif; 
				wp_reset_postdata(); 
				?>
			</td>
		</tr>
	</table>
<?php }

?>