<?php

/**
 * Prevent switching to Writee on old versions of WordPress.
 *
 * Switches to the default theme.
 *
 */
function writee_switch_theme() {
	switch_theme( WP_DEFAULT_THEME );
	unset( $_GET['activated'] );
	add_action( 'admin_notices', 'writee_upgrade_notice' );
}
add_action( 'after_switch_theme', 'writee_switch_theme' );

/**
 * Adds a message for unsuccessful theme switch.
 *
 * Prints an update nag after an unsuccessful attempt to switch to
 * Writee on WordPress versions prior to 4.5.
 *
 * @global string $wp_version WordPress version.
 */
function writee_upgrade_notice() {
	$message = sprintf( __( 'Writee requires at least WordPress version 4.5. You are running version %s. Please upgrade and try again.', 'writee' ), $GLOBALS['wp_version'] );
	printf( '<div class="error"><p>%s</p></div>', $message );
}

/**
 * Prevents the Customizer from being loaded on WordPress versions prior to 4.5.
 
 * @global string $wp_version WordPress version.
 */
function writee_customize() {
	wp_die( sprintf( __( 'Writee requires at least WordPress version 4.5. You are running version %s. Please upgrade and try again.', 'writee' ), $GLOBALS['wp_version'] ), '', array(
		'back_link' => true,
	) );
}
add_action( 'load-customize.php', 'writee_customize' );

/**
 * Prevents the Theme Preview from being loaded on WordPress versions prior to 4.5.
 
 * @global string $wp_version WordPress version.
 */
function writee_preview() {
	if ( isset( $_GET['preview'] ) ) {
		wp_die( sprintf( __( 'Writee requires at least WordPress version 4.5. You are running version %s. Please upgrade and try again.', 'writee' ), $GLOBALS['wp_version'] ) );
	}
}
add_action( 'template_redirect', 'writee_preview' );
