<?php
/*---------------------------------------------------------------*/
/* Register shortcode within Visual Composer interface
/*---------------------------------------------------------------*/

add_action( 'init', 'mnky_vcpb_vc_map' );
function mnky_vcpb_vc_map() {

	if ( function_exists( 'vc_map' ) ) {
	$add_css_animation = vc_map_add_css_animation( true );
	} else {
	$add_css_animation = '';
	}

	$add_css_animation_delay = array(
		'type' => 'dropdown',
		'heading' => esc_html__('CSS Animation Delay', 'core-extend'),
		'param_name' => 'css_animation_delay',
		'value' => array(
			'0ms' => '', 
			'100ms' => 'delay-100', 
			'200ms' => 'delay-200', 
			'300ms' => 'delay-300', 
			'400ms' => 'delay-400', 
			'500ms' => 'delay-500', 
			'600ms' => 'delay-600', 
			'700ms' => 'delay-700', 
			'800ms' => 'delay-800', 
			'900ms' => 'delay-900', 
			'1000ms' => 'delay-1000', 
			'1100ms' => 'delay-1100', 
			'1200ms' => 'delay-1200', 
			'1300ms' => 'delay-1300', 
			'1400ms' => 'delay-1400', 
			'1500ms' => 'delay-1500', 
			'1600ms' => 'delay-1600',
			'1700ms' => 'delay-1700',
			'1800ms' => 'delay-1800', 
			'1900ms' => 'delay-1900', 
			'2000ms' => 'delay-2000'
		)
	);

	vc_map( array(
	"name"		=> __( 'Pricing', 'vc-pricing-box' ),
	"base"		=> "mnky_pricing_box",
	"icon"		=> "icon-wpb-mnky_pricing_box",
	"allowed_container_element" => false,
	"is_container" => true,
	"category"  => __('Premium', 'vc-pricing-box'),
	"description" => __('Styled pricing boxes', 'vc-pricing-box'),
	"admin_enqueue_js" => array( MNKY_VCPB_PLUGIN_URL . 'assets/js/pricing-box-views.js' ),
	"admin_enqueue_css" => array( MNKY_VCPB_PLUGIN_URL . 'assets/css/pricing-box-backend.css'),
	"params" => array(
			array(
				"type" => "textfield",
				"heading" => __( 'Title', 'vc-pricing-box' ),
				"param_name" => "title",
				"holder" => "h4",
				"description" => __( 'Give your plan a title.', 'vc-pricing-box' ),
				"value" => __( 'Starter Pack', 'vc-pricing-box' ),
			),
			array(
				"type" => "textfield",
				"heading" => __( 'Currency', 'vc-pricing-box' ),
				"param_name" => "currency",
				"holder" => "span",
				"description" => __( 'Enter currency symbol or text, e.g., $ or USD.', 'vc-pricing-box' ),
				"value" => __( '$', 'vc-pricing-box' )
			),	
			array(
				"type" => "textfield",
				"heading" => __( 'Price', 'vc-pricing-box' ),
				"param_name" => "price",
				"holder" => "span",
				"description" => __( 'Set the price for this plan.', 'vc-pricing-box' ),
				"value" => __( '10', 'vc-pricing-box' )
			),						
			array(
				"type" => "textfield",
				"heading" => __( 'Time', 'vc-pricing-box' ),
				"param_name" => "time",
				"holder" => "span",
				"description" => __( 'Choose time span for you plan, e.g., /mo, month or /yr.', 'vc-pricing-box' ),
				"value" => __( '/mo', 'vc-pricing-box' )
			),				
			array(
				"type" => "textfield",
				"heading" => __( 'Meta', 'vc-pricing-box' ),
				"param_name" => "meta",
				"holder" => "span",
				"description" => __( 'A short desciption or slogan for the plan.', 'vc-pricing-box' ),
				"value" => __( 'Great for small business', 'vc-pricing-box' )
			),
			array(
				"type" => "vc_link",
				"heading" => __( 'Add URL to the whole box (optional)', 'vc-pricing-box' ),
				"param_name" => "link",
			),
			$add_css_animation,
			$add_css_animation_delay,
			array(
				"type" => "textfield",
				"heading" => __( 'Extra class name', 'vc-pricing-box' ),
				"param_name" => "el_class",
				"description" => __( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'vc-pricing-box' )
			),
			array(
				"type" => "dropdown",
				"heading" => __( 'Select style', 'vc-pricing-box' ),
				"param_name" => "box_style",
				"value" => array('Minimal' => 'box-style-1', 'Strict' => 'box-style-2', 'Header' => 'box-style-3', 'Circle' => 'box-style-4'),
				"description" => __( 'Choose style for this pricing box.', 'vc-pricing-box' ),
				"group" => __('Design', 'vc-pricing-box')
			),	
			array(
				"type" => "colorpicker",
				"heading" => __( 'Background color', 'vc-pricing-box' ),
				"param_name" => "bg_color",
				"value" => "#FFFFFF",
				"description" => __( 'Set background color for pricing box body.', 'vc-pricing-box' ),
				"group" => __('Design', 'vc-pricing-box')
			),					
			array(
				"type" => "colorpicker",
				"heading" => __( 'Text color', 'vc-pricing-box' ),
				"param_name" => "color",
				"value" => "#5E5E5E",
				"description" => __( 'Set text color for pricing box content.', 'vc-pricing-box' ),
				"group" => __('Design', 'vc-pricing-box')
			),
			array(
				"type" => "colorpicker",
				"heading" => __( 'Header background color', 'vc-pricing-box' ),
				"param_name" => "header_bg",
				"value" => "#5E5E5E",
				"group" => __('Design', 'vc-pricing-box'),
				"description" =>  __( 'Set background color for box header.', 'vc-pricing-box' ),
				"dependency" => Array('element' => "box_style", 'value' => array('box-style-2', 'box-style-3', 'box-style-4') )
			),			
			array(
				"type" => "colorpicker",
				"heading" => __( 'Header text color', 'vc-pricing-box' ),
				"param_name" => "header_color",
				"value" => "#FFFFFF",
				"group" => __('Design', 'vc-pricing-box'),
				"description" => __( 'Set color for text inside box header area.', 'vc-pricing-box' ),
				"dependency" => Array('element' => "box_style", 'value' => array('box-style-2', 'box-style-3', 'box-style-4') )
			),
			array(
				"type" => "colorpicker",
				"heading" => __( 'Border color (optional)', 'vc-pricing-box' ),
				"param_name" => "border_color",
				"description" => __( 'Add border to whole box. Leave empty for no border.', 'vc-pricing-box' ),
				"group" => __('Design', 'vc-pricing-box')
			),			
			array(
				"type" => 'checkbox',
				"heading" => __( 'Add badge?', 'vc-pricing-box' ),
				"param_name" => "add_badge",
				"group" => __('Badge', 'vc-pricing-box'),
				"description" => "Adds a nice badge to your pricing box.",
				"value" => Array(__( 'Yes, please', 'vc-pricing-box' ) => 'on')
			),			
			array(
				"type" => "colorpicker",
				"heading" => __( 'Badge background color', 'vc-pricing-box' ),
				"param_name" => "badge_bg",
				"group" => __('Badge', 'vc-pricing-box'),
				"description" => __( 'Set a background color for the badge.', 'vc-pricing-box' ),
				"dependency" => Array('element' => "add_badge", 'not_empty' => true)
			),			
			array(
				"type" => "colorpicker",
				"heading" => __( 'Badge text color', 'vc-pricing-box' ),
				"param_name" => "badge_color",
				"group" => __('Badge', 'vc-pricing-box'),
				"value" => "#fff",
				"description" => __( 'Set a text color for the badge.', 'vc-pricing-box' ),
				"dependency" => Array('element' => "add_badge", 'not_empty' => true)
			),				
			array(
				"type" => "textfield",
				"heading" => __( 'Badge text', 'vc-pricing-box' ),
				"param_name" => "badge_text",
				"value" => __( 'Best Offer', 'vc-pricing-box' ),
				"group" => __('Badge', 'vc-pricing-box'),
				"description" => __( 'What do you want your badge to say? , E.g., 50% Off or Save 30%.', 'vc-pricing-box' ),
				"dependency" => Array('element' => "add_badge", 'not_empty' => true)
			),			
			array(
				"type" => "dropdown",
				"heading" => __( 'Hover effect', 'vc-pricing-box' ),
				"param_name" => "hover_effect",
				"value" => array('None' => '', 'Emphasize' => 'box-effect-1', 'Add Shadow' => 'box-effect-2', 'Emphasize + Add Shadow' => 'box-effect-3'),
				"description" => __( 'Enable and choose a hover effect.', 'vc-pricing-box' ),
				"group" => __('Effect', 'vc-pricing-box')
			),
			array(
				"type" => 'checkbox',
				"heading" => __( 'Always active? (by default only on hover state)', 'vc-pricing-box' ),
				"param_name" => "effect_active",
				"group" => __('Effect', 'vc-pricing-box'),
				"value" => Array(__( 'Yes, please', 'vc-pricing-box' ) => 'box-effect-active'),
				"description" => __( 'Use this option, if you want to accentuate one of the boxes.', 'vc-pricing-box' ),
			)			
		),
	"js_view" => 'VcPricingView'

	) );
	
}