<?php
/*
Plugin Name: MNKY | Visual Composer Pricing Boxes
Plugin URI: http://themeforest.net/user/MNKY
Description: Simple pricing box add-on for Visual Composer.
Version: 1.0.2
Author: MNKY
Author URI: http://mnkythemes.com/
License: Envato Marketplaces Licence
License URI: Envato Marketplace Item License Certificate 
*/


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) die;


class MNKY_VCPB_Core {
	
	function __construct() {
		$this->_constants();
		add_action( 'plugins_loaded', array( $this, 'init' ) );
	}
	
	protected function _constants() {
		define( 'MNKY_VCPB_PLUGIN_MAIN', __FILE__);
		define( 'MNKY_VCPB_PLUGIN_PATH', plugin_dir_path(__FILE__) );
		define( 'MNKY_VCPB_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
	}
	
	public function init() { 
		load_plugin_textdomain( 'vc-pricing-box', false,  plugin_basename( dirname( __FILE__ ) ) . '/languages' ); 
		
		// VC
		if ( ! function_exists( 'vc_map' ) ) {
			add_action('admin_notices', array( $this, 'vc_error' ) ); 
		} else {
			$this->vc_edit();
			add_action('wp_enqueue_scripts', array( $this, 'vc_scripts' ) );
		}
	}

	// Display notice if Visual Composer is not installed or activated
	public function vc_error() {
		echo '
		<div class="updated">
			<p>'. sprintf (esc_html_x( '%1$s MNKY | Visual Composer Pricing Boxes %2$s requires Visual Composer plugin to be installed and activated on your site.', '%1$s and %2$s stand for <strong> tags.' ,'vc-pricing-box' ), '<strong>', '</strong>') .'</p>
		</div>';
	}
	
	// Enqueue scripts
	public function vc_scripts() {
		wp_enqueue_style( 'vc-pricing-box-front', MNKY_VCPB_PLUGIN_URL . 'assets/css/pricing-box.css', array('js_composer_front'), '1.0.2' );
		wp_style_add_data( 'vc-pricing-box-front', 'rtl', MNKY_VCPB_PLUGIN_URL . 'assets/css/pricing-box-rtl.css' );
	}
		
	// Extend & configure VC	
	public function vc_edit() { 
		
		// Set shortcode template dir
		$dir = MNKY_VCPB_PLUGIN_PATH . '/include/vc/shortcodes/';
		vc_set_shortcodes_templates_dir($dir);
							
		// Add shortcodes
		require_once ('include/vc/classes/pricing-box.php');	
		
		// Edit VC map
		require_once ('include/vc/map.php');
		
	}
}
$mnky_vcpb_core = new MNKY_VCPB_Core();