<?php
/**
 * Plugin Name: Kiddie Custom Content
 * Plugin URI: http://zoutula.com
 * Description: This plugin handles Kiddie Theme custom content like staff, testimonials and more. It's activated/deactivated with the theme.
 * Version: 3.9
 * Author: Zoutula
 * Author URI: http://zoutula.com
 * Text Domain: zoutula
 * Domain Path: /languages
 */

define('ZTL_VER','pkkMJzedMT'); //ztl repo 3.9


function kiddie_custom_data() {

	//Staff custom taxonomy

	$labels = array(
		'name'                       => esc_html(_x( 'Staff','Category name', 'zoutula' )),
		'singular_name'              => esc_html(_x( 'Staff member','Category item', 'zoutula' )),
		'parent_item'                => null,
		'parent_item_colon'          => null,
		'add_new_item'               => esc_html__( 'Add Staff Member','zoutula' ),
		'menu_name'                  => esc_html__( 'Staff','zoutula' ),
	);

	$args = array(
		'hierarchical'          => false,
		'labels'                => $labels,
		'show_ui'               => false,
		'show_admin_column'     => true,
		'update_count_callback' => '',
		'query_var'             => true,
	);


	//Staff custom post

	register_post_type( 'kiddie_staff',
	    array(
	      'labels' => $labels,
	      'public' => true,
	      'has_archive' => 'false', //we use a custom template to display the listing
	      'supports' => array( 'title', 'editor', 'thumbnail', 'custom-fields', 'excerpt'),
	      'rewrite' => array('slug' => 'staff'),
	      'taxonomies' => array( 'staff'),
	      'menu_icon' =>'dashicons-groups',
	      'exclude_from_search' => 'true',
	    )
	 );

	register_taxonomy('staff','kiddie_staff', $args );


	//Courses custom taxonomy
	
	$labels = array(
		'name'                       => esc_html(_x( 'Courses','Category name', 'zoutula' )),
		'singular_name'              => esc_html(_x( 'Course','Category item', 'zoutula' )),
		'parent_item'                => null,
		'parent_item_colon'          => null,
		'add_new_item'               => esc_html__( 'Add Course','zoutula' ),
		'menu_name'                  => esc_html__( 'Courses','zoutula' ),
	);

	$args = array(
		'hierarchical'          => false,
		'labels'                => $labels,
		'show_ui'               => false,
		'show_admin_column'     => true,
		'update_count_callback' => '',
		'query_var'             => true,
	);


	//Course custom post

	register_post_type( 'kiddie_course',
	    array(
	      'labels' => $labels,
	      'public' => true,
	      'has_archive' => 'false', //we use a custom template to display the listing
	      'supports' => array( 'title', 'editor', 'thumbnail', 'custom-fields','excerpt'),
	      'rewrite' => array('slug' => 'course'),
	      'taxonomies' => array( 'course'),
	      'menu_icon' =>'dashicons-id-alt',
	      'exclude_from_search' => 'true',
	    )
	 );

	register_taxonomy('course','kiddie_course', $args );
	



	//Testimonials items

	$labels = array(
		'name'                       => esc_html(_x( 'Testimonials','Category name', 'zoutula' )),
		'singular_name'              => esc_html(_x( 'Testimonial','Category item', 'zoutula' )),
		'parent_item'                => null,
		'parent_item_colon'          => null,
		'add_new_item'               => esc_html__( 'Add Testimonial','zoutula' ),
		'menu_name'                  => esc_html__( 'Testimonials','zoutula' ),
	);

	$args = array(
		'hierarchical'          => false,
		'labels'                => $labels,
		'show_ui'               => false,
		'show_admin_column'     => true,
		'update_count_callback' => '',
		'query_var'             => true,
		
	);
	

	//Testimonial custom post

	register_post_type( 'kiddie_testimonial',
	    array(
	      'labels' => $labels,
	      'public' => true,
	      'has_archive' => true,
	      'supports' => array( 'title', 'editor', 'thumbnail', 'custom-fields'),
	      'rewrite' => array('slug' => 'testimonials'),
	      'taxonomies' => array( 'testimonials'),
	      'menu_icon' =>'dashicons-format-status',
	      'exclude_from_search' => 'true',
	    )
	 );

	register_taxonomy('testimonial','kiddie_testimonial', $args );

}

add_action('init','kiddie_custom_data');



add_action( 'plugins_loaded', 'kiddie_load_textdomain' );

function kiddie_load_textdomain() {
    // Load plugin textdomain. E.g.: wp-content/plugins/kiddie-custom-content/languages/zoutula-de_DE.mo
    load_plugin_textdomain( 'zoutula', FALSE, basename( dirname( __FILE__ ) ) . '/languages/' );
}


/* Predefined import settings */
function kiddie_ocdi_import_files() {
    return array(
        array(
	        'import_file_name'           => 'Kiddie Kindergarten',
	        'import_file_url'            => 'http://www.zoutula.com/repository/kiddie/' . ZTL_VER . '/imports/kindergarten/wordpress.xml',
	        'import_widget_file_url'     => 'http://www.zoutula.com/repository/kiddie/' . ZTL_VER . '/imports/kindergarten/widgets.wie',
	        'import_customizer_file_url' => 'http://www.zoutula.com/repository/kiddie/' . ZTL_VER . '/imports/kindergarten/customizer.dat',
	        'import_preview_image_url'   => 'http://www.zoutula.com/repository/kiddie/' . ZTL_VER . '/imports/kindergarten/preview.jpg',
            'import_notice'              => esc_html__( 'After you import this demo, you will have to import the Revolution Slider and Timetable data separately. Please follow documentation for this steps.', 'zoutula' ),
            'preview_url'                => 'http://demo.zoutula.com/kiddie',
        ),
    );
}
add_filter( 'pt-ocdi/import_files', 'kiddie_ocdi_import_files' );

/* Remove Branding*/
add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );

/* Setup the homepage and primary menu */
function kiddie_ocdi_after_import_setup() {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', array(
            'primary' => $main_menu->term_id,
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );


}
add_action( 'pt-ocdi/after_import', 'kiddie_ocdi_after_import_setup' );

//metaboxes
include ('metaboxes.php');
