<?php
/*
 * @package     WBC_Importer - Extension for Importing demo content
 * @author      Webcreations907
 * @version     1.0
 */


// make the default demo in first place of demo list
if ( !function_exists( 'wbc_filter_title' ) ) {

	function wbc_filter_title( $title ) {
		return trim( ucfirst( str_replace( "1", "Default", $title ) ) );
	}
	add_filter( 'wbc_importer_directory_title', 'wbc_filter_title', 10 );
}

if ( !function_exists( 'wbc_importer_description_text' ) ) {

	/**
	 * Filter for changing importer description info in options panel
	 * when not setting in Redux config file.
	 *
	 * @param [string] $title description above demos
	 *
	 * @return [string] return.
	 */

	function wbc_importer_description_text( $description ) {

		$message = '<p style="font-size: 16px;">'. esc_html__( 'Best if used on new WordPress install. Before you begin, make sure all the required plugins are activated.', 'avas' ) .'</p>';
		$message .= '<p style="color:#D85245;font-size:15px">'. esc_html__( 'Please do not activate Child Theme and WPBakery (Visual Composer) plugin while import demo.', 'avas' ) .'</p>';
		$message .= '<p>'. esc_html__( 'If import process get stuck, please refresh the page and click the "Import Demo" button again. By chance demo do not work properly after successfully imported then please click the "Re-Import" button again.', 'avas' ) .'</p>';
		$message .= '<p class="description">'.esc_html__( 'Psst: Elementor, Restaurant, Wedding, Agency 2, Mobile App, Pastry Shop, Tattoo Parlour, Business Landing Page, Designer, Coming Soon and Under Construction demo templates are under "Default" Demo.','avas' ).'</p>';
		$message .= '<p style="border-bottom:1px solid #e6e6e6;margin-top: 30px; margin-bottom: 35px;"></p>';
		return $message;
	}

	// Uncomment the below
	add_filter( 'wbc_importer_description', 'wbc_importer_description_text', 10 );
}
// add demo label in theme optins
if ( !function_exists( 'wbc_importer_label_text' ) ) {

	
	function wbc_importer_label_text( $label_text ) {

		$label_text = esc_html__( 'Demo Install','avas' );

		return $label_text;
	}

	add_filter( 'wbc_importer_label', 'wbc_importer_label_text', 10 );
}

if ( !function_exists( 'wbc_change_demo_directory_path' ) ) {

	function wbc_change_demo_directory_path( $demo_directory_path ) {

		$demo_directory_path = get_template_directory().'/inc/demo-data/';

		return $demo_directory_path;

	}
	// Uncomment the below
	 add_filter('wbc_importer_dir_path', 'wbc_change_demo_directory_path' );
}

if ( !function_exists( 'wbc_importer_before_widget' ) ) {

	/**
	 * Function/action ran before widgets get imported
	 *
	 * @param (array) $demo_active_import       Example below
	 * [wbc-import-1] => Array
	 *      (
	 *            [directory] => current demo data folder name
	 *            [content_file] => content.xml
	 *            [image] => screen-image.png
	 *            [theme_options] => theme-options.txt
	 *            [widgets] => widgets.json
	 *            [imported] => imported
	 *        )
	 * @param (string) $demo_data_directory_path path to current demo folder being imported.
	 *
	 * @return nothing
	 */

	function wbc_importer_before_widget( $demo_active_import , $demo_data_directory_path ) {

		//Do Something

	}

	// Uncomment the below
	// add_action('wbc_importer_before_widget_import', 'wbc_importer_before_widget', 10, 2 );
}

if ( !function_exists( 'wbc_after_theme_options' ) ) {

	/**
	 * Function/action ran after theme options set
	 *
	 * @param (array) $demo_active_import       Example below
	 * [wbc-import-1] => Array
	 *      (
	 *            [directory] => current demo data folder name
	 *            [content_file] => content.xml
	 *            [image] => screen-image.png
	 *            [theme_options] => theme-options.txt
	 *            [widgets] => widgets.json
	 *            [imported] => imported
	 *        )
	 * @param (string) $demo_data_directory_path path to current demo folder being imported.
	 *
	 * @return nothing
	 */

	function wbc_after_theme_options( $demo_active_import , $demo_data_directory_path ) {

		//Do Something

	}

	// Uncomment the below
	// add_action('wbc_importer_after_theme_options_import', 'wbc_after_theme_options', 10, 2 );
}


/************************************************************************
* Extended Example:
* Way to set menu, import revolution slider, and set home page.
*************************************************************************/

if ( !function_exists( 'wbc_extended_example' ) ) {
	function wbc_extended_example( $demo_active_import , $demo_directory_path ) {

		reset( $demo_active_import );
		$current_key = key( $demo_active_import );

		/************************************************************************
		* Import slider(s) for the current demo being imported
		*************************************************************************/

		if ( class_exists( 'RevSlider' ) ) {

			//rev slider set
			$wbc_sliders_array = array(
				'1' => 'avas-default.zip', //Set slider zip name
				'Agency' => 'avas-agency.zip', //Set slider zip name
				'App' => 'avas-app.zip', //Set slider zip name
				'Creative' => 'avas-creative.zip', //Set slider zip name
				'Business' => 'avas-business.zip', //Set slider zip name
				'Startup' => 'avas-startup.zip', //Set slider zip name
				'Creative Agency' => 'avas-creative-agency.zip', //Set slider zip name
				'News' => 'avas-news.zip', //Set slider zip name
				'Digital Agency' => 'digital-agency.zip', //Set slider zip name
				'Photographer' => 'avas-photograper.zip', //Set slider zip name
				'Corporate' => 'avas-corporate.zip', //Set slider zip name
				'Cleaning Services' => 'avas-cleaning-services.zip', //Set slider zip name
				'Construction' => 'avas-construction.zip', //Set slider zip name
				'Nice and Clean' => 'avas-nice-and-clean-header.zip', //Set slider zip name
				'Web Solutions' => 'avas-web-solutions.zip', //Set slider zip name
				'Finance' => 'avas-finance.zip', //Set slider zip name
				'Consultant' => 'avas-consultant.zip', //Set slider zip name
				'Lawyer' => 'avas-lawyer.zip', //Set slider zip name
				'Medical' => 'avas-medical.zip', //Set slider zip name
				'Gym' => 'avas-gym.zip', //Set slider zip name
				'Blog' => 'avas-blog.zip', //Set slider zip name
			);

			if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && array_key_exists( $demo_active_import[$current_key]['directory'], $wbc_sliders_array ) ) {
				$wbc_slider_import = $wbc_sliders_array[$demo_active_import[$current_key]['directory']];

				if ( file_exists( $demo_directory_path.$wbc_slider_import ) ) {
					$slider = new RevSlider();
					$slider->importSliderFromPost( true, true, $demo_directory_path.$wbc_slider_import );
				}
			}
		}

		/************************************************************************
		* Setting Menus
		*************************************************************************/
		$wbc_menu_array = array( '1', 'Agency', 'App', 'Creative', 'Business', 'Startup', 'Creative Agency', 'News', 'Digital Agency', 'Photographer', 'Corporate', 'Cleaning Services','Construction','Nice and Clean','Web Solutions','ICO Cryptocurrency','Finance','Consultant','Lawyer','Resume','Medical','Gym','Magazine','Blog' );

		if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && in_array( $demo_active_import[$current_key]['directory'], $wbc_menu_array ) ) {
			$top_menu = get_term_by( 'name', 'Top Menu', 'nav_menu' );
			$main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );
			$footer_menu = get_term_by( 'name', 'Footer Menu', 'nav_menu' );

			if ( isset( $main_menu->term_id ) ) {
				set_theme_mod( 'nav_menu_locations', array(
						'top_menu' => $top_menu->term_id,
						'main_menu' => $main_menu->term_id,
						'footer_menu'  => $footer_menu->term_id
					)
				);
			}

		}

		/************************************************************************
		* Set HomePage
		*************************************************************************/
		// array of demos/homepages to check/select from
		$wbc_home_pages = array(
			'1' => 'Home Default',
			'Agency' => 'Home Agency',
			'App' => 'Home App',
			'Creative' => 'Home Creative',
			'Business' => 'Home Business',
			'Startup' => 'Home Startup',
			'Creative Agency' => 'Home Creative Agency',
			'News' => 'Home News',
			'Digital Agency' => 'Home Digital Agency',
			'Photographer' => 'Home Photographer',
			'Corporate' => 'Home Corporate',
			'Cleaning Services' => 'Home Cleaning Services',
			'Construction' => 'Home Construction',
			'Nice and Clean' => 'Home Nice and Clean',
			'Web Solutions' => 'Home Web Solutions',
			'ICO Cryptocurrency' => 'Home ICO Cryptocurrency',
			'Finance' => 'Home Finance',
			'Consultant' => 'Home Consultant',
			'Lawyer' => 'Home Lawyer',
			'Resume' => 'Home Resume',
			'Medical' => 'Home Medical',
			'Gym' => 'Home Gym',
			'Magazine' => 'Home Magazine',
			'Blog' => 'Home Blog',
			
		);

		if ( isset( $demo_active_import[$current_key]['directory'] ) && !empty( $demo_active_import[$current_key]['directory'] ) && array_key_exists( $demo_active_import[$current_key]['directory'], $wbc_home_pages ) ) {
			$page = get_page_by_title( $wbc_home_pages[$demo_active_import[$current_key]['directory']] );
			if ( isset( $page->ID ) ) {
				update_option( 'page_on_front', $page->ID );
				update_option( 'show_on_front', 'page' );
			}
		}

// remove hello world post and sample page
		wp_delete_post( 1, true );
		wp_delete_post( 2, true );

		// remove default sidebars widgets 
		// $widgets = get_option('sidebars_widgets');
		// $widgets['main-sidebar'] = '';
		// $widgets['left-sidebar'] = '';

		// update_option('sidebars_widgets', $widgets);

		// update permalinks
		update_option('permalink_structure', '/%year%/%monthnum%/%postname%/');
	}

	// Uncomment the below
	 add_action( 'wbc_importer_after_content_import', 'wbc_extended_example', 10, 2 );
}

?>
