<?php
/**
* 
* @package bddex
* @author theme-x
* @link https://x-theme.com/
*======================================================================
* Header functions 
*======================================================================
*/
/* ---------------------------------------------------------
  Layout wide / boxed
------------------------------------------------------------ */
if (!function_exists('bddex_full_width')) {
function bddex_full_width() {
  global $bddex;
  if ($bddex['header_layout'] == '') {
    echo '-fluid';
  }
   if ($bddex['header_layout'] == 'boxed') {
    echo '';
  }
}
}
if(!function_exists('bddex_footer_width')){
function bddex_footer_width() {
  global $bddex;
  if ($bddex['footer_layout'] == '') {
    echo '';
  }
   if ($bddex['footer_layout'] == 'wide') {
    echo '-fluid';
  }
}
}
/* ---------------------------------------------------------
  Header Style / Select header
------------------------------------------------------------ */
add_action( 'header_select', 'bddex_header_select' );
if(!function_exists('bddex_header_select')):
function bddex_header_select() {
  global $bddex;
if($bddex['header_select'] == '1') {
                require_once THEME_PATH . '/inc/header/main-default.php'; 
            }
if($bddex['header_select'] == '2') {
                require_once THEME_PATH . '/inc/header/main-business.php'; 
            }            
if($bddex['header_select'] == '3') {
                require_once THEME_PATH . '/inc/header/main-news.php'; 
            }
if($bddex['header_select'] == '4') {
                require_once THEME_PATH . '/inc/header/main-center.php'; 
            }            
}
endif;
// Email or Time
add_action( 'email_time', 'bddex_email_time' );
if(!function_exists('bddex_email_time')):
function bddex_email_time() {
  global $bddex;
if($bddex['email_time'] == '1') { ?>
  <div class="upper-column info-box last">
    <div class="icon-box"><span class="flaticon-symbol"></span></div>
      <ul>
        <li><?php echo $bddex['send_email']; ?></li>
      </ul>
  </div>
<?php }
if($bddex['email_time'] == '2') { ?>
  <div class="upper-column info-box last">
    <div class="icon-box"><span class="flaticon-clock"></span></div>
      <ul>
        <li><?php echo $bddex['working_time']; ?></li>
      </ul>
  </div>
<?php }
}
endif;
// search
if (!function_exists('bddex_search')) :
  function bddex_search() { ?>
    <div id="search" class="search-form">
      <form role="search" id="search-form" class="search-box" action="<?php echo esc_url(home_url('/')); ?>" method="get">
          <input type="search" required="" aria-required="true" name="s" placeholder="<?php esc_html_e('Search here ...','avas'); ?>" value="<?php echo get_search_query(); ?>">
          <span class="search-close"><i class="fa fa-times"></i></span>
      </form>
    </div>
<?php  }
endif;  
add_action( 'bddex_search', 'bddex_search' );
// main menu
if(!function_exists('bddex_main_menu')) :
  function bddex_main_menu() { ?>
  <div class="collapse navbar-collapse bddex-menu-list" id="bs-example-navbar-collapse-1">
      <?php if(has_nav_menu('main_menu')) {
                wp_nav_menu( array(
                      'theme_location' => 'main_menu',
                      'container' =>false,
                      'menu_id' => 'nav',
                      'echo' => true,
                      'menu_class' => 'nav navbar-nav navbar-right',
                      'before' => '',
                      'after' => '',
                      'link_before' => '',
                      'link_after' => '',
                      'depth' => 3,
                      'walker'     => new wp_bootstrap_navwalker()
                      )
                      ); 
                      }else{
                      echo '<h5 class="no-menu">';
                      echo esc_html_e('No Menu assigned. Go to Appearance > Menus and create a menu or select a menu if already created.', 'avas');
                      echo '</h5>';
                      } ?>
    </div> <!-- menu end -->
<?php }
endif;                            
add_action( 'bddex_main_menu', 'bddex_main_menu' );
// menu button 
if (!function_exists('bddex_menu_btn')) :
   function bddex_menu_btn() {
    global $bddex;
    if($bddex['menu_btn_switch']) {
    ?>
    <div class="bddex-menu-btn-wrap">
      <a href="<?php if($bddex['menu_btn_url']){echo esc_url($bddex['menu_btn_url']);} ?>" <?php bddex_menu_btn_link_new_window(); ?> class="bddex-menu-btn"><?php if($bddex['menu_btn_txt']){printf(esc_html__('%s','avas'),$bddex['menu_btn_txt']);} ?></a>
    </div>
<?php }
 }
endif;
add_action( 'bddex_menu_btn', 'bddex_menu_btn' );
// side menu
if (!function_exists('bddex_side_menu')) :
   function bddex_side_menu() {
    global $bddex;
    if($bddex['side_menu']) {
    ?>
    <a id="side-menu-icon" href="#" class="side_menu_icon"><i class="fa fa-bars"></i></a>
    <?php get_template_part("/inc/header/sidemenu");
   }
 }
endif;
add_action( 'bddex_side_menu', 'bddex_side_menu' );
// search icon
if(!function_exists('bddex_search_icon')) :
  function bddex_search_icon() {
      global $bddex;
      if($bddex['search']) {  
        echo '<ul class="search-icon">';
        echo '<li><a href="#search"><i class="fa fa-search"></i></a></li>';
        echo '</ul>';
        }
  }
endif;
add_action( 'bddex_search_icon', 'bddex_search_icon' );
// cart icon
if(!function_exists('bddex_cart_icon')) :
  function bddex_cart_icon() {
    global $bddex;
    if($bddex['woo_cart']) : 
     if ( class_exists( 'WooCommerce' ) ) { ?> 
      <div class="woo_cart">
        <?php global $woocommerce;
          echo '<a id="header_cart" href="'. esc_url( wc_get_cart_url() ) .'"><i class="fa fa-shopping-cart"></i><span>'. $woocommerce->cart->cart_contents_count .'</span></a>';
        ?>
      </div>
        <?php  
          } else {
          echo esc_html_e('Please install / activate WooCommerce plugin or disable the Cart Icon via Theme Options > Woocommerce > Cart Icon.', 'avas');
          } 
          endif;
  }
endif;
add_action( 'bddex_cart_icon', 'bddex_cart_icon' );
// logo
if(!function_exists('bddex_logo')) :
  function bddex_logo() { 
    global $bddex; 
    ?>
    <div class="navbar-header">
      <div id="bddex-hamburger" class="bddex-hamburger"><span></span></div>
        <?php if (isset($bddex['bddex_logo']['url']) && ($bddex['bddex_logo']['url'] != "" )) : ?>
          <a class="navbar-brand" href="<?php echo esc_url(get_site_url()); ?>" title="<?php echo esc_attr(get_bloginfo('name')); ?>"><img src="<?php echo esc_url($bddex['bddex_logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>" /></a> 
            <?php endif; ?>
    </div>
<?php  }
endif;
add_action( 'bddex_logo', 'bddex_logo' );
/* ---------------------------------------------------------
   EOF
------------------------------------------------------------ */