<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class bddex_dual_testimonial extends Widget_Base {
    public function get_name() {
        return 'dual_testimonials';
    }
    public function get_title() {
        return esc_html__( 'Avas Dual Testimonials', 'avas' );
    }
    public function get_icon() {
        return 'fa fa-commenting-o';
    }
    public function get_categories() {
        return [ 'bddex' ];
    }
    protected function _register_controls() {
        $this->start_controls_section(
            'avas_dual_testimonial',
            [
                'label' => esc_html__( 'Save & reload page if not showing.', 'avas' )
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'testimonial_dual_style',
            [
                'label'                 => esc_html__( 'Custom colors', 'avas' ),
                'tab'                   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'name_color',
            [
                'label'                 => esc_html__( 'Client Name Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#111',              
                'selectors'             => [
                    '{{WRAPPER}} .client-name' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'company_color',
            [
                'label'                 => esc_html__( 'Company Name Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#8cc63f',              
                'selectors'             => [
                    '{{WRAPPER}} .client-left a,.client-left a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'content_color',
            [
                'label'                 => esc_html__( 'Content Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#fff',              
                'selectors'             => [
                    '{{WRAPPER}} .client-feedback' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'content_bg_color',
            [
                'label'                 => esc_html__( 'Content Background Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#00CDED',              
                'selectors'             => [
                    '{{WRAPPER}} .client-feedback' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'content_arrow_bg_color',
            [
                'label'                 => esc_html__( 'Content Background Arrow Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#00CDED',              
                'selectors'             => [
                    '{{WRAPPER}} .client-feedback:after' => 'border-top-color: {{VALUE}};',
                ],
            ]
        );
       $this->add_control(
            'arrow_bg_color',
            [
                'label'                 => esc_html__( 'Navigation Background Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#00CDED',              
                'selectors'             => [
                    '{{WRAPPER}} .testimonial.owl-carousel button.owl-prev,.testimonial.owl-carousel button.owl-next' => 'background: {{VALUE}};',
                ],
            ]
        );
       $this->add_control(
            'arrow_bg_hover_color',
            [
                'label'                 => esc_html__( 'Navigation Background Hover Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#8cc63f',              
                'selectors'             => [
                    '{{WRAPPER}} .testimonial button.owl-prev:hover, .testimonial.owl-carousel button.owl-next:hover' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render( ) {
        $settings = $this->get_settings();

global $bddex;
if (isset($bddex['testimonial-switch']) && !empty($bddex['testimonial-switch'])) : ?>
    <div class="testimonial owl-carousel">
<?php 
if($bddex['testimonial-slides']) :
foreach($bddex['testimonial-slides'] as $testimonial) : 
$sl_btntxt = $testimonial['btntxt'];
$sl_url = $testimonial['url'];  
?>
            <div class="item">
                <div class="client-left"><?php echo '<img src="' . $testimonial['image'] . '" alt="client" />'; ?>
                    <h6 class="client-name"><?php echo $testimonial['title']; ?></h6>
                    <?php if (isset($sl_url) && ($sl_btntxt)) : ?>
                    <a href="<?php echo $sl_url; ?>" target="_blank"><?php echo $sl_btntxt; ?></a>
                    <?php endif; ?>
                </div>     
                <div class="client-feedback">
                    <p><?php echo $testimonial['description']; ?></p>
                </div>    
            </div>

<?php endforeach; 
      endif;
?>
</div>
<?php endif; 



    }
}
Plugin::instance()->widgets_manager->register_widget_type( new bddex_dual_testimonial() );