<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class bddex_Widget_tm_carousel extends Widget_Base {
    public function get_name() {
        return 'avas-taem-member-carousel';
    }

    public function get_title() {
        return esc_html__( 'Avas Team Members Carousel', 'avas' );
    }
    public function get_icon() {
        return 'fa fa-users';
    }
    public function get_categories() {
        return [ 'bddex' ];
    }
    protected function _register_controls() {
        $this->start_controls_section(
            'team_carousel',
            [
                'label' => esc_html__( 'Save & reload if not showing.', 'avas' )
            ]
        );
        $this->end_controls_section();      
        $this->start_controls_section(
            'testimonial_dual_style',
            [
                'label'                 => esc_html__( 'Customize', 'avas' ),
                'tab'                   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'bg_color',
            [
                'label'                 => esc_html__( 'Background Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#8CC63F',              
                'selectors'             => [
                    '{{WRAPPER}} .engineers .eng-head' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'bg_hover_color',
            [
                'label'                 => esc_html__( 'Background Hover Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#00CDED',              
                'selectors'             => [
                    '{{WRAPPER}} .engineers figcaption' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'image_border_width',
            [
                'label' => esc_html__( 'Image Border Width', 'avas' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 5,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .engineers img' => 'border-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'image_border_color',
            [
                'label'                 => esc_html__( 'Image Border Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#fff',              
                'selectors'             => [
                    '{{WRAPPER}} .engineers img' => 'border-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'button_bg_color',
            [
                'label'                 => esc_html__( 'Button Background Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#0d162d',              
                'selectors'             => [
                    '{{WRAPPER}} .engineers .hire_me' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'button_bg_hover_color',
            [
                'label'                 => esc_html__( 'Button Background Hover Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#00CDED',              
                'selectors'             => [
                    '{{WRAPPER}} .engineers .hire_me:hover' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'button_color',
            [
                'label'                 => esc_html__( 'Button Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#fff',              
                'selectors'             => [
                    '{{WRAPPER}} .engineers .hire_me' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'button_hover_color',
            [
                'label'                 => esc_html__( 'Button Hover Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#fff',              
                'selectors'             => [
                    '{{WRAPPER}} .engineers .hire_me:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'name_color',
            [
                'label'                 => esc_html__( 'Name Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#fff',              
                'selectors'             => [
                    '{{WRAPPER}} .engineers .eng-head h4' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'position_color',
            [
                'label'                 => esc_html__( 'Position Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#444',              
                'selectors'             => [
                    '{{WRAPPER}} .engineers .eng-head p' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'social_icon_color',
            [
                'label'                 => esc_html__( 'Social Icon Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#fff',              
                'selectors'             => [
                    '{{WRAPPER}} .engineers .eng-social i' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'social_icon_border_color',
            [
                'label'                 => esc_html__( 'Social Icon Border Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#fff',              
                'selectors'             => [
                    '{{WRAPPER}} .eng-social li' => 'border-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'social_icon_hover_color',
            [
                'label'                 => esc_html__( 'Social Icon Hover Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#111',              
                'selectors'             => [
                    '{{WRAPPER}} .engineers .eng-social i:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'social_icon_border_hover_color',
            [
                'label'                 => esc_html__( 'Social Icon Border Hover Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#111',              
                'selectors'             => [
                    '{{WRAPPER}} .eng-social li:hover,.engineers .eng-social i:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'nav_color',
            [
                'label'                 => esc_html__( 'Navigation Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#233C75',              
                'selectors'             => [
                    '{{WRAPPER}} .cleaners .owl-prev,.cleaners .owl-next' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'nav_hover_color',
            [
                'label'                 => esc_html__( 'Navigation Hover Color', 'avas' ),
                'type'                  => Controls_Manager::COLOR,
                'default'               => '#00CDED',              
                'selectors'             => [
                    '{{WRAPPER}} .cleaners .owl-prev:hover, .cleaners .owl-next:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section(); 
    }
    protected function render( ) {
        $settings = $this->get_settings();

         $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
  $arg = array(
      'post_type' => 'team',
      'post_status' => 'publish',
      'posts_per_page' => -1

    );

  $query = new \WP_Query( $arg );


if ( $query->have_posts() ) : ?>

   <div class="engineers cleaners owl-carousel">
        
<?php while ( $query->have_posts() ) : $query->the_post(); ?>

                <figure>
                    <a href="<?php the_permalink(); ?>" rel="bookmark">
                    <?php the_post_thumbnail('bddex-team-full'); ?>      
                    </a>
                    <div class="eng-head">
                        <h4><?php the_title(); ?></h4>
                        <?php global $post; $cleaner_cat = get_the_term_list( $post->ID,'team-category', '', '<br> ', '');
                        if (!empty($cleaner_cat)) echo '<p>', strip_tags($cleaner_cat) ,'</p>'; ?>  
                    </div>  
                    <figcaption>
                            <?php
                            global $post;
                            $team_fb = get_post_meta( $post->ID, 'team_fb', true );
                            $team_tw = get_post_meta( $post->ID, 'team_tw', true );
                            $team_gp = get_post_meta( $post->ID, 'team_gp', true );
                            $team_ln = get_post_meta( $post->ID, 'team_ln', true );
                            $team_in = get_post_meta( $post->ID, 'team_in', true );
                            // $hire_me = get_post_meta( $post->ID, 'hire_me', true );
                            ?>

                            <a href="<?php the_permalink(); ?>" rel="bookmark" class="hire_me" ><?php esc_html_e( 'View Profile', 'coolwash' ); ?></a>
                        <div class="clearfix"></div>
                        <ul class="eng-social">
                            <?php if (!empty($team_fb)) : ?>
                            <li><a href="<?php echo esc_url($team_fb); ?>" target="_blank"><i class="fa fa-facebook"></i></a></li>
                            <?php endif; ?>
                            <?php if (!empty($team_tw)) : ?>
                            <li><a href="<?php echo esc_url($team_tw); ?>" target="_blank"><i class="fa fa-twitter"></i></a></li>
                            <?php endif; ?>
                            <?php if (!empty($team_gp)) : ?>
                            <li><a href="<?php echo esc_url($team_gp); ?>" target="_blank"><i class="fa fa-google-plus"></i></a></li>
                            <?php endif; ?>
                            <?php if (!empty($team_ln)) : ?>
                            <li><a href="<?php echo esc_url($team_ln); ?>" target="_blank"><i class="fa fa-linkedin"></i></a></li>
                            <?php endif; ?>
                            <?php if (!empty($team_in)) : ?>
                            <li><a href="<?php echo esc_url($team_in); ?>" target="_blank"><i class="fa fa-instagram"></i></a></li>
                            <?php endif; ?>
                        </ul>
                    </figcaption>
                </figure>
                        
    <?php endwhile; ?>
    </div> <!-- end loop -->
    <?php wp_reset_postdata(); ?>
    <?php else:  ?>
    <?php get_template_part('content', 'none'); ?>
    <?php endif;  
    }
}
Plugin::instance()->widgets_manager->register_widget_type( new bddex_Widget_tm_carousel() );