<?php

namespace Elementor;


if (!defined('ABSPATH'))
    exit; // Exit if accessed directly


class BDDEX_Pricing_Table_Widget extends Widget_Base {


    public function __construct($data = [], $args = null) {
        parent::__construct($data, $args);

        add_shortcode('lae_pricing_item', array($this, 'pricing_item_shortcode'));
    }

    public function pricing_item_shortcode($atts, $content = null, $tag) {

        $title = $value = '';

        extract(shortcode_atts(array(
            'title' => '',
            'value' => ''

        ), $atts));

        ob_start();

        ?>

        <div class="lae-pricing-item">

            <div class="lae-title">

                <?php echo htmlspecialchars_decode(wp_kses_post($title)); ?>

            </div>

            <div class="lae-value-wrap">

                <div class="lae-value">

                    <?php echo htmlspecialchars_decode(wp_kses_post($value)); ?>

                </div>

            </div>

        </div>

        <?php


        $output = ob_get_clean();

        return $output;
    }

    public function get_name() {
        return 'lae-pricing-table';
    }

    public function get_title() {
        return __('Avas Pricing Table 1', 'avas');
    }

    public function get_icon() {
        return 'eicon-price-table';
    }

    public function get_categories() {
        return array('bddex');
    }

    public function get_script_depends() {
        return [
            'lae-widgets-scripts',
            'lae-frontend-scripts',
            'jquery-flexslider'
        ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_pricing_table',
            [
                'label' => __('Pricing Table', 'avas'),
            ]
        );

        $this->add_control(
            'per_line',
            [
                'label' => __('Pricing plans in a row', 'avas'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 5,
                'step' => 1,
                'default' => 4,
            ]
        );

        $this->add_control(
            'pricing_heading',
            [
                'label' => __('Pricing Plans', 'avas'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'pricing_plans',
            [
                'type' => Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'pricing_title',
                        'type' => Controls_Manager::TEXT,
                        'label' => __('Pricing Plan Title', 'avas'),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'tagline',
                        'type' => Controls_Manager::TEXT,
                        'label' => __('Tagline Text', 'avas'),
                        'description' => __('Provide any subtitle or taglines like "Most Popular", "Best Value", "Best Selling", "Most Flexible" etc. that you would like to use for this pricing plan.', 'avas'),
                    ],

                    [
                        'name' => 'pricing_image',
                        'label' => __('Pricing Image', 'avas'),
                        'type' => Controls_Manager::MEDIA,
                        'default' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                        'label_block' => true,
                    ],

                    [
                        'name' => 'price_tag',
                        'type' => Controls_Manager::TEXT,
                        'label' => __('Price Tag', 'avas'),
                        'description' => __('Enter the price tag for the pricing plan. HTML is accepted.', 'avas'),
                    ],

                    [
                        'name' => 'button_text',
                        'type' => Controls_Manager::TEXT,
                        'label' => __('Text for Pricing Link/Button', 'avas'),
                    ],

                    [
                        'name' => 'button_url',
                        'label' => __('URL for the Pricing link/button', 'avas'),
                        'type' => Controls_Manager::URL,
                        'label_block' => true,
                        'default' => [
                            'url' => '',
                            'is_external' => 'true',
                        ],
                        'placeholder' => __('http://your-link.com', 'avas'),
                    ],


                    [
                        'name' => 'highlight',
                        'label' => __('Highlight Pricing Plan', 'avas'),
                        'type' => Controls_Manager::SWITCHER,
                        'label_off' => __('No', 'avas'),
                        'label_on' => __('Yes', 'avas'),
                        'return_value' => 'yes',
                        'default' => 'no',
                    ],

                    [
                        'name' => 'pricing_content',
                        'type' => Controls_Manager::TEXTAREA,
                        'label' => __('Pricing Plan Details', 'avas'),
                        'description' => __('Enter the content for the pricing plan that include information about individual features of the pricing plan. For prebuilt styling, enter shortcodes content like - [lae_pricing_item title="Storage Space" value="50 GB"] [lae_pricing_item title="Video Uploads" value="50"][lae_pricing_item title="Portfolio Items" value="20"]', 'avas'),
                        'show_label' => true,
                        'rows' => 10
                    ],

                    [
                        "type" => Controls_Manager::SELECT,
                        "name" => "widget_animation",
                        "label" => __("Animation Type", "avas"),
                   //     'options' => bddex_get_animation_options(),
                        'default' => 'none',
                    ],

                ],
               // 'title_field' => '{{{ pricing_title }}}',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_pricing_style',
            [
                'label' => __( 'Plan Name', 'avas' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'plan_name_tag',
            [
                'label' => __( 'HTML Tag', 'avas' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => __( 'H1', 'avas' ),
                    'h2' => __( 'H2', 'avas' ),
                    'h3' => __( 'H3', 'avas' ),
                    'h4' => __( 'H4', 'avas' ),
                    'h5' => __( 'H5', 'avas' ),
                    'h6' => __( 'H6', 'avas' ),
                    'div' => __( 'div', 'avas' ),
                ],
                'default' => 'h3',
            ]
        );

        $this->add_control(
            'plan_name_color',
            [
                'label' => __( 'Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-pricing-table .lae-top-header .lae-plan-name' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'plan_name_typography',
                'selector' => '{{WRAPPER}} .lae-pricing-table .lae-top-header .lae-plan-name',
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'section_plan_tagline',
            [
                'label' => __( 'Plan Tagline', 'avas' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'plan_tagline_color',
            [
                'label' => __( 'Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-pricing-table .lae-top-header .lae-tagline' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'plan_tagline_typography',
                'selector' => '{{WRAPPER}} .lae-pricing-table .lae-top-header .lae-tagline',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_plan_price',
            [
                'label' => __( 'Plan Price', 'avas' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_control(
            'plan_price_tag',
            [
                'label' => __( 'HTML Tag', 'avas' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => __( 'H1', 'avas' ),
                    'h2' => __( 'H2', 'avas' ),
                    'h3' => __( 'H3', 'avas' ),
                    'h4' => __( 'H4', 'avas' ),
                    'h5' => __( 'H5', 'avas' ),
                    'h6' => __( 'H6', 'avas' ),
                    'div' => __( 'div', 'avas' ),
                ],
                'default' => 'h4',
            ]
        );


        $this->add_control(
            'plan_price_color',
            [
                'label' => __( 'Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-pricing-table .lae-pricing-plan .lae-plan-price span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'plan_price_typography',
                'selector' => '{{WRAPPER}} .lae-pricing-table .lae-pricing-plan .lae-plan-price span',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_item_title',
            [
                'label' => __( 'Pricing Item Title', 'avas' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'item_title_color',
            [
                'label' => __( 'Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-pricing-table .lae-plan-details .lae-pricing-item .lae-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'item_title_typography',
                'selector' => '{{WRAPPER}} .lae-pricing-table .lae-plan-details .lae-pricing-item .lae-title',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_item_value',
            [
                'label' => __( 'Pricing Item Value', 'avas' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'item_value_color',
            [
                'label' => __( 'Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-pricing-table .lae-plan-details .lae-pricing-item .lae-value' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'item_value_typography',
                'selector' => '{{WRAPPER}} .lae-pricing-table .lae-plan-details .lae-pricing-item .lae-value',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_purchase_button',
            [
                'label' => __( 'Purchase Button', 'avas' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_control(
            'purchase_button_spacing',
            [
                'label' => __('Button Spacing', 'avas'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 15,
                    'right' => 15,
                    'bottom' => 15,
                    'left' => 15,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .lae-pricing-table .lae-purchase .lae-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'purchase_button_size',
            [
                'label' => __('Button Size', 'avas'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'default' => [
                    'top' => 12,
                    'right' => 25,
                    'bottom' => 12,
                    'left' => 25,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .lae-pricing-table .lae-purchase .lae-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'isLinked' => false
            ]
        );

        $this->add_control(
            'button_custom_color',
            [
                'label' => __('Button Color', 'avas'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .lae-pricing-table .lae-purchase .lae-button' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_custom_hover_color',
            [
                'label' => __('Button Hover Color', 'avas'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .lae-pricing-table .lae-purchase .lae-button:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'purchase_button_color',
            [
                'label' => __( 'Label Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-pricing-table .lae-purchase .lae-button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'purchase_button_typography',
                'selector' => '{{WRAPPER}} .lae-pricing-table .lae-purchase .lae-button',
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {

        $settings = $this->get_settings();

        if (empty($settings['pricing_plans']))
            return;

        ?>

        <?php $column_style = bddex_get_column_class(intval($settings['per_line'])); ?>

        <div class="lae-pricing-table lae-container">

            <?php

            foreach ($settings['pricing_plans'] as $pricing_plan) :

                $pricing_title = esc_html($pricing_plan['pricing_title']);
                $tagline = esc_html($pricing_plan['tagline']);
                $price_tag = htmlspecialchars_decode(wp_kses_post($pricing_plan['price_tag']));
                $pricing_img = $pricing_plan['pricing_image'];
                $pricing_url = (empty($pricing_plan['button_url']['url'])) ? '#' : esc_url($pricing_plan['button_url']['url']);
                $pricing_button_text = esc_html($pricing_plan['button_text']);
                $button_new_window = esc_html($pricing_plan['button_url']['is_external']);
                $highlight = ($pricing_plan['highlight'] == 'yes');

                $price_tag = (empty($price_tag)) ? '' : $price_tag;

                 list($animate_class, $animation_attr) = bddex_get_animation_atts($pricing_plan['widget_animation']);

                ?>

                <div class="lae-pricing-plan <?php echo ($highlight ? ' lae-highlight' : ''); ?> <?php echo $column_style; ?> <?php echo $animate_class; ?>"<?php echo $animation_attr; ?>>

                    <div class="lae-top-header">

                        <?php if (!empty($tagline))
                            echo '<p class="lae-tagline center">' . $tagline . '</p>'; ?>

                        <<?php echo $settings['plan_name_tag']; ?> class="lae-plan-name lae-center"><?php echo $pricing_title; ?></<?php echo $settings['plan_name_tag']; ?>>

                        <?php

                        if (!empty($pricing_img)) :
                            echo wp_get_attachment_image($pricing_img['id'], 'full', false, array('class' => 'lae-image full', 'alt' => $pricing_title));
                        endif;

                        ?>

                    </div>

                    <<?php echo $settings['plan_price_tag']; ?> class="lae-plan-price lae-plan-header lae-center">

                        <span class="lae-text">

                            <?php echo wp_kses_post($price_tag); ?>

                        </span>

                    </<?php echo $settings['plan_price_tag']; ?>>

                    <div class="lae-plan-details">

                        <?php echo $this->parse_text_editor($pricing_plan['pricing_content']) ?>

                    </div><!-- .lae-plan-details -->

                    <div class="lae-purchase">

                        <a class="lae-button default" href="<?php echo esc_url($pricing_url); ?>"
                            <?php if (!empty($button_new_window))
                                echo 'target="_blank"'; ?>><?php echo esc_html($pricing_button_text); ?></a>

                    </div>

                </div>
                <!-- .lae-pricing-plan -->

                <?php

            endforeach;

            ?>

        </div><!-- .lae-pricing-table -->

        <div class="lae-clear"></div>

        <?php
    }

    protected function content_template() {
    }

}

Plugin::instance()->widgets_manager->register_widget_type( new BDDEX_Pricing_Table_Widget() );