<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;

class bddex_Widget_post_block1 extends Widget_Base {

	public function get_name() {
		return 'avas-post-block1';
	}

	public function get_title() {
		return __( 'Avas Post Block List', 'avas' );
	}

	public function get_icon() {
		return 'eicon-post-list';
	}

	public function get_categories() {
		return [ 'bddex' ];
	}

	protected function _register_controls() {
		$this->start_controls_section(
            'thwsmart_post_block1',
            [
                'label' 	=> __( 'Post block list Info', 'avas' )
            ]
        );
		$this->add_control(
		  'post_count',
		  [
		    'label'         => __( 'Post count', 'avas' ),
            'type'          => Controls_Manager::NUMBER,
            'label_block'   => true,
            'default'       => __( '5', 'avas' ),

		  ]
        );
        $this->add_control(
            'post_offset',
            [
              'label'         => __( 'Post Offset', 'avas' ),
              'type'          => Controls_Manager::NUMBER,
              'label_block'   => true,
              'default'       => __( '0', 'avas' ),
  
            ]
        );
        $this->add_control(
          'post_catd',
          [
             'label'    => __( 'Select category', 'avas' ),
             'type'     => Controls_Manager::SELECT,
             'options'  => bddex_category_list( 'category' ),
             'multiple' => false,
             'default'  => '0'
          ]
        );
        $this->add_control(
            'custom_title_en',
            [
                'label'         => __( 'Enable custom title limit', 'avas' ),
                'type'          => Controls_Manager::SWITCHER,
                'default'       => 'no',
                'label_on'      => __( 'Yes', 'avas' ),
                'label_off'     => __( 'No', 'avas' ),
            ]
        );
        $this->add_control(
          'title_text_limit',
          [
            'label'         => __( 'Add title text limit', 'avas' ),
            'type'          => Controls_Manager::NUMBER,
            'label_block'   => true,
            'default'       => 50,
            'condition' => [
                'custom_title_en' => 'yes',
            ],
          ]
        );
        $this->add_control(
            'post_sortby',
            [
                'label'     => __( 'Post sort by', 'avas' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'latestpost',
                'options'   => [
                        'latestpost'      => __( 'Latest posts', 'avas' ),
                        'popularposts'    => __( 'Popular posts', 'avas' ),
                        'mostdiscussed'    => __( 'Most discussed', 'avas' ),
                    ],
            ]
        );
        $this->add_control(
            'post_data_en',
            [
                'label'         => __( 'Enable Date', 'avas' ),
                'type'          => Controls_Manager::SWITCHER,
                'default'       => 'yes',
                'label_on'      => __( 'Yes', 'avas' ),
                'label_off'     => __( 'No', 'avas' ),
            ]
        );
        $this->add_control(
            'post_cat_en',
            [
                'label'         => __( 'Enable Category', 'avas' ),
                'type'          => Controls_Manager::SWITCHER,
                'default'       => 'yes',
                'label_on'      => __( 'Yes', 'avas' ),
                'label_off'     => __( 'No', 'avas' ),
            ]
        );
        $this->add_control(
            'post_order',
            [
                'label'     => __( 'Post order', 'avas' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'DESC',
                'options'   => [
                        'DESC'      => __( 'Descending', 'avas' ),
                        'ASC'       => __( 'Ascending', 'avas' ),
                    ],
            ]
        );
        $this->add_control(
            'post_orderby',
            [
                'label'     => __( 'Post order by', 'avas' ),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'date',
                'options'   => [
                    'none'           => __( 'None', 'avas' ),
                    'date'           => __( 'Date', 'avas' ),
                    'title'          => __( 'Title', 'avas' ),
                    'name'           => __( 'Name', 'avas' ),
                    'modified'       => __( 'Modified', 'avas' ),
                    'rand'           => __( 'Random', 'avas' ),
                ],
                'condition' => [
                    'post_sortby' => ['latestpost'],
                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_title_style',
            [
                'label'     => __( 'Category', 'avas' ),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'cat_arrow_bg_color',
            [
                'label'     => __( 'Arrow background color', 'avas' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'default'   => '#1c1c1c',
                'selectors' => [
                    '{{WRAPPER}} .category-meta-bg a:before' => 'border-top-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'cat_arrow_h_bg_color',
            [
                'label'     => __( 'Arrow hover background color', 'avas' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'default'   => '#ec0000',
                'selectors' => [
                    '{{WRAPPER}} .category-meta-bg a:hover:before' => 'border-top-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'cat_bg_color1',
            [
                'label'     => __( 'Category Background color', 'avas' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'default'   => '#1c1c1c',
                'selectors' => [
                    '{{WRAPPER}} .category-meta-bg a' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'cat_h_bg_color1',
            [
                'label'     => __( 'Category hover background color', 'avas' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'default'   => '#ec0000',
                'selectors' => [
                    '{{WRAPPER}} .category-meta-bg a:hover' => 'background: {{VALUE}};',
                ],
            ]
        );

         $this->add_control(
            'cat_color',
            [
                'label'     => __( 'Category text color', 'avas' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'default'   => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .category-meta-bg a' => 'color: {{VALUE}};',
                ],
            ]
        );
         $this->add_control(
            'cat_h_color',
            [
                'label'     => __( 'Category text hover color', 'avas' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'default'   => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .category-meta-bg a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
         $this->add_control(
            'title_color',
            [
                'label'     => __( 'title text color', 'avas' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'default'   => '#1c1c1c',
                'selectors' => [
                    '{{WRAPPER}} .recent-posts-widget .post-info .post-title a' => 'color: {{VALUE}};',
                ],
            ]
        );
         $this->add_control(
            'title_h_color',
            [
                'label'     => __( 'title text hover color', 'avas' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'default'   => '#ec0000',
                'selectors' => [
                    '{{WRAPPER}} .recent-posts-widget .post-info .post-title a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
         $this->add_control(
            'date_color',
            [
                'label'     => __( 'date text color', 'avas' ),
                'type'      => Controls_Manager::COLOR,
                'scheme'    => [
                    'type'  => Scheme_Color::get_type(),
                    'value' => Scheme_Color::COLOR_1,
                ],
                'default'   => '#888',
                'selectors' => [
                    '{{WRAPPER}} .recent-posts-widget .post-meta time' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();
	}

	protected function render( ) {

		$settings 			= $this->get_settings();
        $post_count 		= $settings['post_count'];
        $post_offset                 = $settings['post_offset'];
		$post_catd 			= $settings['post_catd'];
        $post_order         = $settings['post_order'];
        $post_sortby        = $settings['post_sortby'];
		$post_orderby 		= $settings['post_orderby'];
        $custom_title_en    = $settings['custom_title_en'];
        $title_text_limit   = $settings['title_text_limit'];
        $post_data_en       = $settings['post_data_en'];
        $post_cat_en       = $settings['post_cat_en'];

        // post count
        if( $post_count ){
            $post_count = $post_count;
        } else {
            $post_count = 5;
        }
        // post offset
        if( $post_offset ){
            $post_offset = $post_offset;
        } else {
            $post_offset = 0;
        }
        // enable title text
        if( $custom_title_en ){
            $custom_title_en = $custom_title_en;
        } else {
            $custom_title_en = 'no';
        }

        // title text limit
        if( $title_text_limit ){
            $title_text_limit = $title_text_limit;
        } else {
            $title_text_limit = 50;
        }

        // enable date
        if( $post_data_en ){
            $post_data_en = $post_data_en;
        } else {
            $post_data_en = 'no';
        }

        // enable category
        if( $post_cat_en ){
            $post_cat_en = $post_cat_en;
        } else {
            $post_cat_en = 'no';
        }

        //post order
        if( $post_order ){
            $post_order = $post_order;
        } else {
            $post_order = 5;
        }

        //post sortby
        if( $post_sortby ){
            $post_sortby = $post_sortby;
        } else {
            $post_sortby = 'latestpost';
        }

        //post orderby
        if( $post_orderby ){
            $post_orderby = $post_orderby;
        } else {
            $post_orderby = 'date';
        }

        //post category
        if( $post_catd ){
            $post_catd = $post_catd;
        } else {
            $post_catd = '0';
        }

        if ( $post_sortby == 'popularposts' ) {
    		$arg = array(
    			'post_type'   =>  'post',
    			'post_status' => 'publish',
                'order' => $post_order,
                'posts_per_page' => $post_count,
                'meta_key' => '_post_views_count',
                'orderby' => 'meta_value_num',
                'category_name' => $post_catd,
                'offset' => $post_offset,
    		);
        } elseif ( $post_sortby == 'mostdiscussed' ) {
            $arg = array(
                'post_type'   =>  'post',
                'post_status' => 'publish',
                'order' => $post_order,
                'posts_per_page' => $post_count,
                'orderby' => 'comment_count',
                'category_name' => $post_catd,
                'offset' => $post_offset,
            );
        } else {
            $arg = array(
                'post_type'   =>  'post',
                'post_status' => 'publish',
                'posts_per_page' => $post_count,
                'order' => $post_order,
                'orderby' => $post_orderby,
                'category_name' => $post_catd,
                'offset' => $post_offset,
            );
        }

		$queryd = new \WP_Query( $arg );
	?>

		<?php if ( $queryd->have_posts() ) : ?>
            <div class="recent-posts-widget post-block1-element">
                <ul class="list-unstyled clearfix">
                    <?php
                    $i = 1;
                    while ($queryd->have_posts()) : $queryd->the_post();
                    if ( $i == 1 ) { ?>
                        <li>
                        <?php if (  (function_exists('has_post_thumbnail')) && (has_post_thumbnail())  ) { ?>
                                <div class="posts-thumb-full">
                                    <a href="<?php echo esc_url( get_permalink() ); ?>" rel="bookmark" title="<?php echo esc_attr( get_the_title() ); ?>"><?php the_post_thumbnail('bddex-xmedium-size'); ?></a>
                                    <div class="post-info-full">
                                        <?php if($post_cat_en == 'yes') { ?>
                                            <span class="category-meta-bg"><?php echo get_the_category_list(' '); ?></span>
                                        <?php }?>
                                        <?php if( $custom_title_en == 'yes' ){ ?>
                                            <h4 class="post-title"><a href="<?php echo esc_url( get_permalink()); ?>" rel="bookmark" title="<?php echo esc_attr( get_the_title() ); ?>"><?php echo bddex_title_max_charlength($title_text_limit); ?></a></h4>
                                        <?php } else { ?>
                                            <h4 class="post-title"><a href="<?php echo esc_url( get_permalink()); ?>" rel="bookmark" title="<?php echo esc_attr( get_the_title() ); ?>"><?php echo get_the_title(); ?></a></h4>
                                        <?php } ?>
                                        <?php if($post_data_en == 'yes') { ?>
                                            <p class="post-meta"><time class="post-date" datetime="<?php echo esc_attr( get_the_time( 'c' ) ); ?>"><?php echo get_the_date(); ?></time></p>
                                        <?php }?>
                                    </div>
                                </div>
                            <?php } else{?>
                                <div class="post-info-full">
                                    <?php if( $custom_title_en == 'yes' ){ ?>
                                        <h4 class="post-title"><a href="<?php echo esc_url( get_permalink()); ?>" rel="bookmark" title="<?php echo esc_attr( get_the_title() ); ?>"><?php echo bddex_title_max_charlength($title_text_limit); ?></a></h4>
                                    <?php } else { ?>
                                        <h4 class="post-title"><a href="<?php echo esc_url( get_permalink()); ?>" rel="bookmark" title="<?php echo esc_attr( get_the_title() ); ?>"><?php echo get_the_title(); ?></a></h4>
                                    <?php } ?>
                                    <?php if($post_data_en == 'yes') { ?>
                                        <p class="post-meta"><time class="post-date" datetime="<?php echo esc_attr( get_the_time( 'c' ) ); ?>"><?php echo get_the_date(); ?></time></p>
                                    <?php }?>
                                </div>
                            <?php } ?>
                            <div class="clearfix"></div>
                        </li>
                    <?php } else { ?>
                        <li class="media">
                            <?php if (  (function_exists('has_post_thumbnail')) && (has_post_thumbnail())  ) { ?>
                                <div class="posts-thumb d-flex mr-3">
                                    <a href="<?php echo esc_url( get_permalink() ); ?>" rel="bookmark" title="<?php echo esc_attr( get_the_title() ); ?>"><?php the_post_thumbnail('thumbnail'); ?></a>
                                    <?php if($post_cat_en == 'yes') { ?>
                                    <span class="category-meta-bg"><?php echo get_the_category_list(' '); ?></span>
                                    <?php } ?>
                                </div>
                                <div class="post-info media-body">
                                    <?php if( $custom_title_en == 'yes' ){ ?>
                                        <h4 class="post-title title-small mt-0 mb-1"><a href="<?php echo esc_url( get_permalink()); ?>" rel="bookmark" title="<?php echo esc_attr( get_the_title() ); ?>"><?php echo bddex_title_max_charlength($title_text_limit); ?></a></h4>
                                    <?php } else { ?>
                                        <h4 class="post-title title-small mt-0 mb-1"><a href="<?php echo esc_url( get_permalink()); ?>" rel="bookmark" title="<?php echo esc_attr( get_the_title() ); ?>"><?php echo get_the_title(); ?></a></h4>
                                    <?php } ?>
                                    <?php if($post_data_en == 'yes') { ?>
                                        <p class="post-meta"><time class="post-date" datetime="<?php echo esc_attr( get_the_time( 'c' ) ); ?>"><?php echo get_the_date(); ?></time></p>
                                    <?php }?>
                                </div>
                            <?php } else{?>
                                <div class="post-info media-body">
                                    <?php if( $custom_title_en == 'yes' ){ ?>
                                        <h4 class="post-title title-small mt-0 mb-1"><a href="<?php echo esc_url( get_permalink()); ?>" rel="bookmark" title="<?php echo esc_attr( get_the_title() ); ?>"><?php echo bddex_title_max_charlength($title_text_limit); ?></a></h4>
                                    <?php } else { ?>
                                        <h4 class="post-title title-small mt-0 mb-1"><a href="<?php echo esc_url( get_permalink()); ?>" rel="bookmark" title="<?php echo esc_attr( get_the_title() ); ?>"><?php echo get_the_title(); ?></a></h4>
                                    <?php } ?>
                                    <?php if($post_data_en == 'yes') { ?>
                                        <p class="post-meta"><time class="post-date" datetime="<?php echo esc_attr( get_the_time( 'c' ) ); ?>"><?php echo get_the_date(); ?></time></p>
                                    <?php }?>
                                </div>
                            <?php } ?>
                            <div class="clearfix"></div>
                        </li>

                    <?php }

                    $i ++;
                    endwhile; ?>
                    <?php wp_reset_postdata(); ?>
                </ul>
            </div>
	    <?php endif; ?>
	<?php }
	protected function _content_template() { }
}

Plugin::instance()->widgets_manager->register_widget_type( new bddex_Widget_post_block1() );