<?php


namespace Elementor;


if (!defined('ABSPATH'))
    exit; // Exit if accessed directly


class BDDEX_Any_Posts_Widget extends Widget_Base {

    public function get_name() {
        return 'lae-portfolio';
    }

    public function get_title() {
        return esc_html__('Avas Any Posts', 'avas');
    }

    public function get_icon() {
        return 'eicon-posts-grid';
    }

    public function get_categories() {
        return array('bddex');
    }

    public function get_script_depends() {
        return [
            'lae-widgets-scripts',
            'lae-frontend-scripts',
            'jquery-magnific-popup',
            'isotope.pkgd',
            'imagesloaded.pkgd'
        ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_query',
            [
                'label' => esc_html__('Post Query', 'avas'),
            ]
        );


        $this->add_control(
            'post_types',
            [
                'label' => esc_html__('Post Types', 'avas'),
                'type' => Controls_Manager::SELECT2,
                'default' => 'post',
                'options' => bddex_get_all_post_type_options(),
                'multiple' => true
            ]
        );

        $this->add_control(
            'tax_query',
            [
                'label' => esc_html__('Taxonomies', 'avas'),
                'type' => Controls_Manager::SELECT2,
                'options' => bddex_get_all_taxonomy_options(),
                'multiple' => true,
                'label_block' => true
            ]
        );

        $this->add_control(
            'post_in',
            [
                'label' => esc_html__('Post In', 'avas'),
                'description' => esc_html__('Provide a comma separated list of Post IDs to display in the grid.', 'avas'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => esc_html__('Posts Per Page', 'avas'),
                'type' => Controls_Manager::NUMBER,
                'default' => 6,
            ]
        );

        $this->add_control(
            'advanced',
            [
                'label' => esc_html__('Advanced', 'avas'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label' => esc_html__('Order By', 'avas'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'none' => esc_html__('No order', 'avas'),
                    'ID' => esc_html__('Post ID', 'avas'),
                    'author' => esc_html__('Author', 'avas'),
                    'title' => esc_html__('Title', 'avas'),
                    'date' => esc_html__('Published date', 'avas'),
                    'modified' => esc_html__('Modified date', 'avas'),
                    'parent' => esc_html__('By parent', 'avas'),
                    'rand' => esc_html__('Random order', 'avas'),
                    'comment_count' => esc_html__('Comment count', 'avas'),
                    'menu_order' => esc_html__('Menu order', 'avas'),
                    'post__in' => esc_html__('By include order', 'avas'),
                ),
                'default' => 'date',
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => esc_html__('Order', 'avas'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'ASC' => esc_html__('Ascending', 'avas'),
                    'DESC' => esc_html__('Descending', 'avas'),
                ),
                'default' => 'DESC',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_post_content',
            [
                'label' => esc_html__('Post Content', 'avas'),
            ]
        );

        $this->add_control(
            'heading',
            [
                'label' => esc_html__('Heading for the grid', 'avas'),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__('', 'avas'),
                'default' => esc_html__('', 'avas'),
            ]
        );

        $this->add_control(
            'taxonomy_filter',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Choose the taxonomy to display and filter on.', 'avas'),
                'label_block' => true,
                'description' => esc_html__('Choose the taxonomy information to display for posts/portfolio and the taxonomy that is used to filter the portfolio/post. Takes effect only if no taxonomy filters are specified when building query.', 'avas'),
                'options' => bddex_get_taxonomies_map(),
                'default' => 'portfolio_category',
            ]
        );

        $this->add_control(
            'display_title',
            [
                'label' => esc_html__('Display posts title below the post item?', 'avas'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'avas'),
                'label_off' => esc_html__('No', 'avas'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'display_summary',
            [
                'label' => esc_html__('Display post excerpt/summary below the post item?', 'avas'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'avas'),
                'label_off' => esc_html__('No', 'avas'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_post_meta',
            [
                'label' => esc_html__('Post Meta', 'avas'),
            ]
        );


        $this->add_control(
            'display_author',
            [
                'label' => esc_html__('Display post author info below the post item?', 'avas'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'avas'),
                'label_off' => esc_html__('No', 'avas'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );


        $this->add_control(
            'display_post_date',
            [
                'label' => esc_html__('Display post date info below the post item?', 'avas'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'avas'),
                'label_off' => esc_html__('No', 'avas'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );


        $this->add_control(
            'display_taxonomy',
            [
                'label' => esc_html__('Display taxonomy info below the post item? Choose the right taxonomy in Post Content section above.', 'avas'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'avas'),
                'label_off' => esc_html__('No', 'avas'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_settings',
            [
                'label' => esc_html__('General Settings', 'avas'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );

        $this->add_control(
            'image_linkable',
            [
                'label' => esc_html__('Link Images to Posts?', 'avas'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'avas'),
                'label_off' => esc_html__('No', 'avas'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'filterable',
            [
                'label' => esc_html__('Filterable?', 'avas'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'avas'),
                'label_off' => esc_html__('No', 'avas'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'per_line',
            [
                'label' => esc_html__('Columns per row', 'avas'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 5,
                'step' => 1,
                'default' => 3,
            ]
        );

        $this->add_control(
            'layout_mode',
            [
                'type' => Controls_Manager::SELECT,
                'label' => esc_html__('Choose a layout for the grid', 'avas'),
                'options' => array(
                    'fitRows' => esc_html__('Fit Rows', 'avas'),
                    'masonry' => esc_html__('Masonry', 'avas'),
                ),
                'default' => 'fitRows',
            ]
        );


        $this->add_control(
            'enable_lightbox',
            [
                'type' => Controls_Manager::SWITCHER,
                'label_off' => esc_html__('No', 'avas'),
                'label_on' => esc_html__('Yes', 'avas'),
                'return_value' => 'yes',
                'default' => 'yes',
                'label' => esc_html__('Enable Lightbox Gallery?', 'avas'),
            ]
        );

        $this->end_controls_section();

        // $this->start_controls_section(
        //     'section_pagination',
        //     [
        //         'label' => __('Pagination', 'avas'),
        //         'tab' => Controls_Manager::TAB_SETTINGS,
        //     ]
        // );

        // $this->add_control(
        //     'pagination',
        //     [
        //         'type' => Controls_Manager::SELECT,
        //         'label' => __('Pagination', 'avas'),
        //         'description' => __('Choose pagination type or choose None if no pagination is desired. Make sure the \'Post per page\' field value is set in the Build Query window to control number of posts to display per page.', 'avas'),
        //         'options' => array(
        //             'none' => __('None', 'avas'),
        //             'paged' => __('Paged', 'avas'),
        //             'load_more' => __('Load More', 'avas'),
        //         ),
        //         'default' => 'none',
        //     ]
        // );


        // $this->add_control(
        //     'show_remaining',
        //     [
        //         'label' => __('Display count of posts yet to be loaded with the load more button?', 'avas'),
        //         'type' => Controls_Manager::SWITCHER,
        //         'label_on' => __('Yes', 'avas'),
        //         'label_off' => __('No', 'avas'),
        //         'return_value' => 'yes',
        //         'default' => 'yes',
        //         'condition' => [
        //             'pagination' => 'load_more',
        //         ],
        //     ]
        // );

        // $this->end_controls_section();

        $this->start_controls_section(
            'section_responsive',
            [
                'label' => esc_html__('Gutter Options', 'avas'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );

        $this->add_control(
            'heading_desktop',
            [
                'label' => esc_html__( 'Desktop', 'avas' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'gutter',
            [
                'label' => esc_html__('Gutter', 'avas'),
                'description' => esc_html__('Space between columns in the grid.', 'avas'),
                'type' => Controls_Manager::NUMBER,
                'default' => 20,
                'selectors' => [
                    '{{WRAPPER}} .lae-portfolio' => 'margin-left: -{{VALUE}}px; margin-right: -{{VALUE}}px;',
                    '{{WRAPPER}} .lae-portfolio .lae-portfolio-item' => 'padding: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_control(
            'heading_tablet',
            [
                'label' => esc_html__( 'Tablet', 'avas' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'tablet_gutter',
            [
                'label' => esc_html__('Gutter', 'avas'),
                'description' => esc_html__('Space between columns.', 'avas'),
                'type' => Controls_Manager::NUMBER,
                'default' => 10,
                'selectors' => [
                    '(tablet-){{WRAPPER}} .lae-portfolio' => 'margin-left: -{{VALUE}}px; margin-right: -{{VALUE}}px;',
                    '(tablet-){{WRAPPER}} .lae-portfolio .lae-portfolio-item' => 'padding: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_control(
            'tablet_width',
            [
                'label' => esc_html__('Tablet Resolution', 'avas'),
                'description' => esc_html__('The resolution to treat as a tablet resolution.', 'avas'),
                'type' => Controls_Manager::NUMBER,
                'default' => 800,
            ]
        );


        $this->add_control(
            'heading_mobile',
            [
                'label' => esc_html__( 'Mobile Phone', 'avas' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'mobile_gutter',
            [
                'label' => esc_html__('Gutter', 'avas'),
                'description' => esc_html__('Space between columns.', 'avas'),
                'type' => Controls_Manager::NUMBER,
                'default' => 10,
                'selectors' => [
                    '(mobile-){{WRAPPER}} .lae-portfolio' => 'margin-left: -{{VALUE}}px; margin-right: -{{VALUE}}px;',
                    '(mobile-){{WRAPPER}} .lae-portfolio .lae-portfolio-item' => 'padding: {{VALUE}}px;',
                ],
            ]
        );

        $this->add_control(
            'mobile_width',
            [
                'label' => esc_html__('Tablet Resolution', 'avas'),
                'description' => esc_html__('The resolution to treat as a tablet resolution.', 'avas'),
                'type' => Controls_Manager::NUMBER,
                'default' => 480,
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'section_heading_styling',
            [
                'label' => esc_html__('Grid Heading', 'avas'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_control(
            'heading_tag',
            [
                'label' => esc_html__( 'Heading HTML Tag', 'avas' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => esc_html__( 'H1', 'avas' ),
                    'h2' => esc_html__( 'H2', 'avas' ),
                    'h3' => esc_html__( 'H3', 'avas' ),
                    'h4' => esc_html__( 'H4', 'avas' ),
                    'h5' => esc_html__( 'H5', 'avas' ),
                    'h6' => esc_html__( 'H6', 'avas' ),
                    'div' => esc_html__( 'div', 'avas' ),
                ],
                'default' => 'h3',
            ]
        );

        $this->add_control(
            'heading_color',
            [
                'label' => esc_html__( 'Heading Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-portfolio-wrap .lae-heading' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'heading_typography',
                'selector' => '{{WRAPPER}} .lae-portfolio-wrap .lae-heading',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_filters_styling',
            [
                'label' => esc_html__('Grid Filters', 'avas'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'filter_color',
            [
                'label' => esc_html__( 'Filter Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-portfolio-wrap .lae-taxonomy-filter .lae-filter-item a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filter_hover_color',
            [
                'label' => esc_html__( 'Filter Hover Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-portfolio-wrap .lae-taxonomy-filter .lae-filter-item a:hover, {{WRAPPER}} .lae-portfolio-wrap .lae-taxonomy-filter .lae-filter-item.lae-active a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filter_active_border',
            [
                'label' => esc_html__( 'Active Filter Border Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-portfolio-wrap .lae-taxonomy-filter .lae-filter-item.lae-active' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'filter_typography',
                'selector' => '{{WRAPPER}} .lae-portfolio-wrap .lae-taxonomy-filter .lae-filter-item a',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_grid_thumbnail_styling',
            [
                'label' => esc_html__('Grid Thumbnail', 'avas'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_control(
            'thumbnail_hover_bg_color',
            [
                'label' => esc_html__( 'Thumbnail Hover Background Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-portfolio-wrap .lae-portfolio .lae-portfolio-item .lae-project-image .lae-image-overlay' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'thumbnail_hover_opacity',
            [
                'label' => esc_html__( 'Thumbnail Hover Opacity (%)', 'avas' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 0.5,
                ],
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .lae-portfolio-wrap .lae-portfolio .lae-portfolio-item .lae-project-image:hover .lae-image-overlay' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_control(
            'heading_thumbnail_info',
            [
                'label' => esc_html__( 'Thumbnail Info Entry Title', 'avas' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__( 'Title HTML Tag', 'avas' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => esc_html__( 'H1', 'avas' ),
                    'h2' => esc_html__( 'H2', 'avas' ),
                    'h3' => esc_html__( 'H3', 'avas' ),
                    'h4' => esc_html__( 'H4', 'avas' ),
                    'h5' => esc_html__( 'H5', 'avas' ),
                    'h6' => esc_html__( 'H6', 'avas' ),
                    'div' => esc_html__( 'div', 'avas' ),
                ],
                'default' => 'h3',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-portfolio-wrap .lae-portfolio .lae-portfolio-item .lae-project-image .lae-image-info .lae-post-title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_hover_border_color',
            [
                'label' => esc_html__( 'Title Hover Border Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-portfolio-wrap .lae-portfolio .lae-portfolio-item .lae-project-image .lae-image-info .lae-post-title a:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .lae-portfolio-wrap .lae-portfolio .lae-portfolio-item .lae-project-image .lae-image-info .lae-post-title',
            ]
        );

        $this->add_control(
            'heading_thumbnail_info_taxonomy',
            [
                'label' => esc_html__( 'Thumbnail Info Taxonomy Terms', 'avas' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'thumbnail_info_tags_color',
            [
                'label' => esc_html__( 'Taxonomy Terms Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-portfolio-wrap .lae-portfolio .lae-portfolio-item .lae-project-image .lae-image-info .lae-terms, {{WRAPPER}} .lae-portfolio-wrap .lae-portfolio .lae-portfolio-item .lae-project-image .lae-image-info .lae-terms a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'tags_typography',
                'selector' => '{{WRAPPER}} .lae-portfolio-wrap .lae-portfolio .lae-portfolio-item .lae-project-image .lae-image-info .lae-terms, {{WRAPPER}} .lae-portfolio-wrap .lae-portfolio .lae-portfolio-item .lae-project-image .lae-image-info .lae-terms a',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_entry_title_styling',
            [
                'label' => esc_html__('Grid Item Entry Title', 'avas'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'entry_title_tag',
            [
                'label' => esc_html__( 'Entry Title HTML Tag', 'avas' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => esc_html__( 'H1', 'avas' ),
                    'h2' => esc_html__( 'H2', 'avas' ),
                    'h3' => esc_html__( 'H3', 'avas' ),
                    'h4' => esc_html__( 'H4', 'avas' ),
                    'h5' => esc_html__( 'H5', 'avas' ),
                    'h6' => esc_html__( 'H6', 'avas' ),
                    'div' => esc_html__( 'div', 'avas' ),
                ],
                'default' => 'h3',
            ]
        );

        $this->add_control(
            'entry_title_color',
            [
                'label' => esc_html__( 'Entry Title Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-portfolio-wrap .lae-portfolio .lae-portfolio-item .entry-title a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'entry_title_typography',
                'selector' => '{{WRAPPER}} .lae-portfolio-wrap .lae-portfolio .lae-portfolio-item .entry-title',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_entry_summary_styling',
            [
                'label' => esc_html__('Grid Item Entry Summary', 'avas'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'entry_summary_color',
            [
                'label' => esc_html__( 'Entry Summary Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-portfolio-wrap .lae-portfolio .lae-portfolio-item .entry-summary' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'entry_summary_typography',
                'selector' => '{{WRAPPER}} .lae-portfolio-wrap .lae-portfolio .lae-portfolio-item .entry-summary',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_entry_meta_styling',
            [
                'label' => esc_html__('Grid Item Entry Meta', 'avas'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'heading_entry_meta',
            [
                'label' => esc_html__( 'Entry Meta', 'avas' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'entry_meta_color',
            [
                'label' => esc_html__( 'Entry Meta Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-portfolio-wrap .lae-portfolio .lae-portfolio-item .lae-entry-meta span' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'entry_meta_typography',
                'selector' => '{{WRAPPER}} .lae-portfolio-wrap .lae-portfolio .lae-portfolio-item .lae-entry-meta span',
            ]
        );


        $this->add_control(
            'heading_entry_meta_link',
            [
                'label' => esc_html__( 'Entry Meta Link', 'avas' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'after',
            ]
        );

        $this->add_control(
            'entry_meta_link_color',
            [
                'label' => esc_html__( 'Entry Meta Link Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-portfolio-wrap .lae-portfolio .lae-portfolio-item .lae-entry-meta span a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'entry_meta_link_typography',
                'selector' => '{{WRAPPER}} .lae-portfolio-wrap .lae-portfolio .lae-portfolio-item .lae-entry-meta span a',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_pagination_styling',
            [
                'label' => esc_html__('Pagination', 'avas'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'pagination_border_color',
            [
                'label' => esc_html__( 'Border Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-portfolio-wrap .lae-pagination .lae-page-nav, {{WRAPPER}} .lae-portfolio-wrap .lae-pagination .lae-page-nav:first-child' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'pagination_hover_bg_color',
            [
                'label' => esc_html__( 'Hover Background Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-portfolio-wrap .lae-pagination .lae-page-nav:hover, {{WRAPPER}} .lae-portfolio-wrap .lae-pagination .lae-page-nav.lae-current-page' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'pagination_nav_icon_color',
            [
                'label' => esc_html__( 'Nav Icon Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-portfolio-wrap .lae-pagination .lae-page-nav i' => 'color: {{VALUE}};',
                ],
            ]
        );


        $this->add_control(
            'pagination_hover_nav_icon_color',
            [
                'label' => esc_html__( 'Hover Nav Icon Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-portfolio-wrap .lae-pagination .lae-page-nav.lae-disabled i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'pagination_disabled_nav_icon_color',
            [
                'label' => esc_html__( 'Disabled Nav Icon Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-portfolio-wrap .lae-pagination .lae-page-nav.lae-disabled i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'heading_nav_text',
            [
                'label' => esc_html__( 'Navigation text', 'avas' ),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_control(
            'pagination_text_color',
            [
                'label' => esc_html__( 'Nav Text Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-portfolio-wrap .lae-pagination .lae-page-nav' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'pagination_hover_text_color',
            [
                'label' => esc_html__( 'Hover Nav Text Color', 'avas' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .lae-portfolio-wrap .lae-pagination .lae-page-nav:hover, {{WRAPPER}} .lae-portfolio-wrap .lae-pagination .lae-page-nav.lae-current-page' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Nav Text Typography', 'avas' ),
                'name' => 'pagination_text_typography',
                'selector' => '{{WRAPPER}} .lae-portfolio-wrap .lae-pagination .lae-page-nav',
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {

        $settings = $this->get_settings();

        // Use the processed post selector query to find posts.
        $query_args = bddex_build_query_args($settings);

        $loop = new \WP_Query($query_args);

        // Loop through the posts and do something with them.
        if ($loop->have_posts()) :

            // Check if any taxonomy filter has been applied
            list($chosen_terms, $taxonomies) = bddex_get_chosen_terms($query_args);
            if (empty($chosen_terms))
                $taxonomies[] = $settings['taxonomy_filter'];

            ?>

            <div class="lae-portfolio-wrap lae-container"
                 data-query='<?php echo wp_json_encode($query_args); ?>'
                 data-settings='<?php echo wp_json_encode($settings); ?>'
                 data-taxonomies='<?php echo wp_json_encode($taxonomies); ?>'
                 data-current="1"
                 data-maxpages="<?php echo $loop->max_num_pages; ?>"
                 data-total="<?php echo $loop->found_posts; ?>">

                <?php if (!empty($settings['heading']) || $settings['filterable'] == 'yes'): ?>

                    <div class="lae-portfolio-header">

                        <?php if (!empty($settings['heading'])) : ?>

                            <<?php echo $settings['heading_tag']; ?> class="lae-heading"><?php echo wp_kses_post($settings['heading']); ?></<?php echo $settings['heading_tag']; ?>>

                        <?php endif; ?>

                        <?php

                        if ($settings['filterable'] == 'yes')
                            echo bddex_get_taxonomy_terms_filter($taxonomies, $chosen_terms);

                        ?>

                    </div>

                <?php endif; ?>

                <div id="lae-portfolio-<?php echo uniqid(); ?>"
                     class="lae-portfolio js-isotope lae-<?php echo esc_attr($settings['layout_mode']); ?>"
                     data-isotope-options='{ "itemSelector": ".lae-portfolio-item", "layoutMode": "<?php echo esc_attr($settings['layout_mode']); ?>" }'>

                    <?php bddex_posts_grid($loop, $settings, $taxonomies); ?>

                </div><!-- Isotope items -->

                <?php //echo lae_paginate_links($loop, $settings); ?>

            </div>

            <?php

        endif;
    }

    protected function content_template() {
    }

}

Plugin::instance()->widgets_manager->register_widget_type( new BDDEX_Any_Posts_Widget() );



function bddex_posts_grid($loop, $settings, $taxonomies) {

    $column_style = bddex_get_column_class(intval($settings['per_line'])); ?>

    <?php $current_page = get_queried_object_id(); ?>

    <?php while ($loop->have_posts()) : $loop->the_post(); ?>

        <?php $post_id = get_the_ID(); ?>

        <?php
        if ($post_id === $current_page)
            continue; // skip current page since we can run into infinite loop when users choose All option in build query
        ?>

        <?php
        $style = '';
        foreach ($taxonomies as $taxonomy) {
            $terms = get_the_terms($post_id, $taxonomy);
            if (!empty($terms) && !is_wp_error($terms)) {
                foreach ($terms as $term) {
                    $style .= ' term-' . $term->term_id;
                }
            }
        }
        ?>

        <div data-id="id-<?php echo $post_id; ?>"
             class="lae-portfolio-item <?php echo $style; ?> <?php echo $column_style; ?> lae-zero-margin">

            <article id="post-<?php echo $post_id; ?>" <?php post_class(); ?>>

                <?php if ($thumbnail_exists = has_post_thumbnail()): ?>

                    <div class="lae-project-image">

                        <?php if ($settings['image_linkable'] == 'yes'): ?>

                            <a href="<?php the_permalink(); ?>"> <?php the_post_thumbnail('large'); ?> </a>

                        <?php else: ?>

                            <?php the_post_thumbnail('large'); ?>

                        <?php endif; ?>

                        <div class="lae-image-info">

                            <div class="lae-entry-info">

                                <?php the_title('<'. $settings['title_tag']. ' class="lae-post-title"><a href="' . get_permalink() . '" title="' . get_the_title() . '"
                                               rel="bookmark">', '</a></'. $settings['title_tag'] . '>'); ?>

                                <?php echo bddex_get_info_for_taxonomies($taxonomies); ?>

                            </div>

                            <?php if ($settings['enable_lightbox'] == 'yes') : ?>

                                <?php
                                $featured_image_id = get_post_thumbnail_id($post_id);
                                $featured_image_data = wp_get_attachment_image_src($featured_image_id, 'full');
                                ?>
                                <?php if ($featured_image_data) : ?>

                                    <?php $featured_image_src = $featured_image_data[0]; ?>

                                    <a class="lae-lightbox-item"
                                       href="<?php echo $featured_image_src; ?>"
                                       title="<?php echo get_the_title(); ?>"><i
                                                class="lae-icon-full-screen"></i></a>

                                <?php endif; ?>

                            <?php endif; ?>

                        </div>

                        <div class="lae-image-overlay"></div>

                    </div>

                <?php endif; ?>

                <?php if (($settings['display_title'] == 'yes') || ($settings['display_summary'] == 'yes')) : ?>

                    <div
                            class="lae-entry-text-wrap <?php echo($thumbnail_exists ? '' : ' nothumbnail'); ?>">

                        <?php if ($settings['display_title'] == 'yes') : ?>

                            <?php the_title('<'. $settings['entry_title_tag']. ' class="entry-title"><a href="' . get_permalink() . '" title="' . get_the_title() . '"
                                               rel="bookmark">', '</a></'. $settings['entry_title_tag'] . '>'); ?>

                        <?php endif; ?>

                        <?php if (($settings['display_post_date'] == 'yes') || ($settings['display_author'] == 'yes') || ($settings['display_taxonomy'] == 'yes')) : ?>

                            <div class="lae-entry-meta">

                                <?php if ($settings['display_author'] == 'yes'): ?>

                                    <?php echo bddex_entry_author(); ?>

                                <?php endif; ?>

                                <?php if ($settings['display_post_date'] == 'yes'): ?>

                                    <?php echo bddex_entry_published(); ?>

                                <?php endif; ?>

                                <?php if ($settings['display_taxonomy'] == 'yes'): ?>

                                    <?php echo bddex_get_info_for_taxonomies($taxonomies); ?>

                                <?php endif; ?>

                            </div>

                        <?php endif; ?>

                        <?php if ($settings['display_summary'] == 'yes') : ?>

                            <div class="entry-summary">

                                <?php echo bddex_excerpt(10); ?>

                            </div>

                        <?php endif; ?>

                    </div>

                <?php endif; ?>

            </article><!-- .hentry -->

        </div>

    <?php endwhile; ?>

    <?php wp_reset_postdata(); ?>

    <?php

}


/** Isotope filtering support for Portfolio pages **/

function bddex_get_taxonomy_terms_filter($taxonomies, $chosen_terms = array()) {

    $output = '';
    $terms = array();

    if (empty($chosen_terms)) {

        foreach ($taxonomies as $taxonomy) {

            global $wp_version;

            if (version_compare($wp_version, '4.5', '>=')) {
                $taxonomy_terms = get_terms(array('taxonomy' => $taxonomy));
            }
            else {
                $taxonomy_terms = get_terms($taxonomy);
            }
            if (!empty($taxonomy_terms) && !is_wp_error($taxonomy_terms))
                $terms = array_merge($terms, $taxonomy_terms);
        }
    }
    else {
        $terms = $chosen_terms;
    }

    if (!empty($terms)) {

        $output .= '<div class="lae-taxonomy-filter">';

        $output .= '<div class="lae-filter-item segment-0 lae-active"><a data-value="*" href="#">' . esc_html__('All', 'livemesh-el-addons') . '</a></div>';

        $segment_count = 1;
        foreach ($terms as $term) {

            $output .= '<div class="lae-filter-item segment-' . intval($segment_count) . '"><a href="#" data-value=".term-' . intval($term->term_id) . '" title="' . esc_html__('View all items filed under ', 'livemesh-el-addons') . esc_attr($term->name) . '">' . esc_html($term->name) . '</a></div>';

            $segment_count++;
        }

        $output .= '</div>';

    }

    return $output;
}