<?php
/**
* 
* @package bddex
* @author theme-x
* @link https://x-theme.com/
*
* ============================
*         Header
* ============================
*
*/
global $bddex;
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo( 'charset' ); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="profile" href="http://gmpg.org/xfn/11">
        <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
        <?php bddex_favicon(); ?>
        <?php wp_head(); ?>
    </head>
<body <?php body_class(); ?>>
    <?php if($bddex['header_on_off']) : ?>
        <header id="header" itemscope="itemscope" itemtype="http://schema.org/WPHeader" class="header double-header">
           <?php if ($bddex['top_head']) : ?>
            <div id="top_head">
                <div class="container<?php echo bddex_full_width(); ?>">
                    <!-- <div class="row"> -->
                        <div class="col-lg-6 col-sm-6 col-xs-6">
                            <div class="head_contact">
                                <?php if($bddex['header_select'] == '2') {
                                        echo '<p class="welcome_msg">'.$bddex['welcome_msg'].'</p>';
                                        }
                                ?>
                                <?php if($bddex['bddex-date']) { ?>
                                <div class="bddex-date">
                                    <i class="fa fa-clock-o"></i><?php echo date(' F j, Y'); ?>
                                </div>
                                <?php } else {
                                    if ($bddex['phone_email']){ ?>
                                <ul class="phone_email">
                                    <li><i class="fa fa-phone"></i><a href="tel:<?php echo esc_html($bddex['phone']); ?>"><?php echo esc_html($bddex['phone']); ?></a></li>
                                    <li><i class="fa fa-envelope"></i><a href="mailto:<?php echo esc_html($bddex['email']); ?>"><?php echo esc_html($bddex['email']); ?></a></li>
                                </ul>
                                <?php }} ;?>

                            </div>
                        </div>
                <div class="col-md-6 col-lg-6">
                        <!-- top menu start -->
                <?php if($bddex['top_menu'] == 1 )  : ?>
                    <!-- login register -->
                    <?php if($bddex['login_register'] == 1) : 
                     bddex_login_register(); 
                     endif; ?> <!-- end login register -->
                    <?php
                    if ( has_nav_menu( 'top_menu' ) ) : 
                        wp_nav_menu( array(
                        'theme_location' => 'top_menu',
                        'menu_class'     => 'top_menu',
                        'depth'          => 1,
                        ) );
                    endif; ?>
                    
                    <?php endif; ?>
                    <?php if($bddex['top_menu'] == 0 )  : ?>
                    
                        <?php if ($bddex['social']) : ?>
                                    <div class="social_media"> 
                                        <?php echo bddex_social_media(); ?>
                                    </div>
                        <?php endif; ?>
                   
                <?php endif; ?> 
                </div><!-- top menu end -->
                  </div> <!-- container end -->
            </div><!-- Top Header end -->
            <?php endif; ?>
            <!-- Main header start -->
            <?php do_action('header_select'); ?>
            
            <!-- Main Header end -->
        </header>
<?php endif; ?>



   