<?php
/**
 * The template for displaying Comments.
 *
 * The area of the page that contains comments and the comment form.
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */
if ( post_password_required() )
    return;
?>

  <?php if ( have_comments() ) : ?>

    <!-- section subtitle start -->
    <h4 class="h4-comments">
        <?php comments_number( esc_html__('0 Comments', 'luxex'), esc_html__('1 Comment', 'luxex'), esc_html__('% Comments', 'luxex') ); ?>
    </h4>
    <!-- section subtitle end -->
    <!-- divider start -->
    <div class="divider-l"></div>
    <!-- divider end -->
    <!-- blog comments start -->
    <div class="blog-comments">
        <section class="comments">
            <?php wp_list_comments('callback=luxex_theme_comment'); ?>
        </section>
    </div>
    <!-- blog comments end -->
    <!-- divider start -->
    <div class="divider-xl"></div>
    <!-- divider end -->
    <?php
        if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
    ?>
    <div class="pagination_area">
        <nav>
            <ul class="pagination">
                <li> <?php paginate_comments_links( 
                        array(
                        'prev_text' => wp_specialchars_decode(esc_html__( '<i class="ion-ios-arrow-left"></i>', 'luxex' ),ENT_QUOTES),
                        'next_text' => wp_specialchars_decode(esc_html__( '<i class="ion-ios-arrow-right"></i>', 'luxex' ),ENT_QUOTES),
                        ));  
                    ?>
                </li>
            </ul>
       </nav>
    </div>
    <?php endif; ?>
    <!-- END PAGINATION --> 
    <?php endif; ?>  
    <div>
        <!-- divider start -->
        <div class="divider-l"></div>
        <!-- divider end -->      
        <div id="comment-form">
            <div class="extra-margin-blog">
            <?php
              if ( is_singular() ) wp_enqueue_script( "comment-reply" );
                  $aria_req = ( $req ? " aria-required='true'" : '' );
                  $comment_args = array(
                    'id_form' => 'form-3',        
                    'class_form' => 'comment-form',                         
                    'title_reply'=> esc_html__( 'Leave a comment', 'luxex' ),
                    'fields' => apply_filters( 'comment_form_default_fields', array(
                        'author' =>   ' <div class="col-sm-6 col-md-6 col-lg-6">
                                        <input type="text" class="requiredField-c name" name="author" id="name" placeholder="'.esc_attr__('Name', 'luxex').'">
                                        </div>',

                        'email' =>    ' <div class="col-sm-6 col-md-6 col-lg-6">
                                        <input id="email" class="requiredField-c email" placeholder="'.esc_attr__('Email', 'luxex').'" name="email" type="email">
                                        </div>',

                    ) ),   
                    'comment_field' => '<div class="make-space">
                                        <textarea id="comment" class="requiredField-c message" name="comment" '.$aria_req.' placeholder="'.esc_attr__('Write a comment...', 'luxex').'" required="required" data-error="Please,leave us a message."></textarea>
                                        </div>',   

                    'label_submit' => esc_html__( 'Post a comment', 'luxex' ),
                    'submit_button' =>  '<button type="submit" %3$s name="%1$s" id="submit %2$s" >%4$s',
                    'submit_field' =>   '<div>
                                            <div class="more-wraper-center more-wraper-center-form-2">
                                                <div class="more-button-bg-center more-button-bg-center-dark more-button-bg-center-dark-close more-button-circle"></div>
                                                <div class="more-button-txt-center more-button-txt-center-close">
                                            %1$s %2$s
                                        </div></div></div>',
                    'comment_notes_before' => '',
                    'comment_notes_after' => '',                 
                  )
            ?>
            
            <?php if ( comments_open() ) : ?>
              <?php comment_form($comment_args); ?>
            <?php endif; ?> 
            </div>
        </div>
    </div>