<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsTestimonials extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-testimonials';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Testimonials', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Testimonials widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-testimonial';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Testimonials widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'Testimonials' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_heading',
			[
				'label' => esc_html__( 'Testimonials', 'bdevs-elementor' ),
			]	
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Select Style', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'video'  => esc_html__( 'Background Video', 'bdevs-elementor' ),
					'image' => esc_html__( 'Background Image', 'bdevs-elementor' ),
				],
				'default'   => 'video',
			]
		);

		$this->add_control(
			'video',
			[
				'label'       => __( 'Link Background Video (mp4)', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'		=> __('#', 'bdevs-elementor'),
				'label_block' => true,
				'condition' => [
                    'chose_style' => ['video']
                ],
			]
		);

		$this->add_control(
			'background_bg',
			[
				'label'   => esc_html__( 'Background Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add image from here', 'bdevs-elementor' ),
				'condition' => [
                    'chose_style' => ['image']
                ],
			]
		);

		$this->add_control(
			'button',
			[
				'label'       => __( 'Button', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'		=> __('Button', 'bdevs-elementor'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'video_button',
			[
				'label'       => __( 'Link Video Button', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'		=> __('#', 'bdevs-elementor'),
				'label_block' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_quote',
			[
				'label' => esc_html__( 'Testimonials Items', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name'        => 'quote',
						'label'       => esc_html__( 'Quote', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Quote' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);

		$this->end_controls_section();

		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_button',
			[
				'label'   => esc_html__( 'Show Button', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings); ?>
		<?php if( $chose_style == 'video' ): ?>
		<div id="video-testimonials" class="section-all">
            <!-- container start -->
            <div class="container-fluid">
                <!-- row start -->
                <div class="row">
                	
                    <!-- parallax wrapper start -->
                    <div class="parallax parallax-all">
                        <!-- HTML5 video URL start -->
                        <video playsinline autoplay muted loop>
                            <source src="<?php print wp_kses_post($settings['video']); ?>" type="video/mp4">
                        </video>
                        <!-- HTML5 video URL end -->
                        <!-- parallax overlay start -->
                        <div class="parallax-overlay-video-testimonials"></div>
                        <!-- parallax overlay end -->
                        <!-- parallax content start -->
                        <div class="parallax-content">
                            <!-- line start -->
                            <div class="the-line the-line-light"></div>
                            <!-- line end -->
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                            <!-- testimonials start -->
                            <div class="owl-carousel owl-carousel-testimonials">
                            	<?php 
				                    foreach ( $settings['tabs'] as $item ) : 
								?>
                                <!-- testimonials quote start -->
                                <div class="testimonial testimonial-2">
                                    <div class="inner">
                                        <div class="quote">
                                            <blockquote class="quote-inner">
                                                <?php print wp_kses_post($item['quote']); ?>
                                            </blockquote>
                                        </div>
                                    </div>
                                </div>
                                <!-- testimonials quote end -->
                            	<?php endforeach; ?>
                            </div>
                            <!-- testimonials end -->
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                            <?php if ( $settings['show_button'] ) : ?>
                            <!-- button start -->
                            <div class="more-wraper-center">
                                <a data-lity="" href="<?php print wp_kses_post($settings['video_button']); ?>">
                                    <div class="more-button-bg-center more-button-circle"></div>
                                    <div class="more-button-txt-center">
                                        <span><?php print wp_kses_post($settings['button']); ?></span>
                                    </div>
                                </a>
                            </div>
                            <!-- button end -->
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                        	<?php endif; ?>
                            <!-- line start -->
                            <div class="the-line the-line-light"></div>
                            <!-- line end -->
                        </div>
                        <!-- parallax content end -->
                    </div>
                    <!-- parallax wrapper end -->
                </div>
                <!-- row end -->
            </div>
            <!-- container end -->
        </div>
        <?php elseif( $chose_style == 'image' ): ?>
        <div id="parallax-image" class="section-all">
            <!-- container start -->
            <div class="container-fluid">
                <!-- row start -->
                <div class="row">
                	
                    <!-- parallax wrapper start -->
                    <div class="parallax parallax-all parallax-image-bg-1" style="background-image: url(<?php echo wp_kses_post($settings['background_bg']['url']); ?>);" data-parallax-speed="0.75">
	                        <!-- parallax overlay start -->
                        <div class="parallax-overlay"></div>
                        <!-- HTML5 video URL end -->
                        <!-- parallax content start -->
                        <div class="parallax-content">
                            <!-- line start -->
                            <div class="the-line the-line-light"></div>
                            <!-- line end -->
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                            <!-- testimonials start -->
                            <div class="owl-carousel owl-carousel-testimonials">
                            	<?php 
				                    foreach ( $settings['tabs'] as $item ) : 
								?>
                                <!-- testimonials quote start -->
                                <div class="testimonial testimonial-2">
                                    <div class="inner">
                                        <div class="quote">
                                            <blockquote class="quote-inner">
                                                <?php print wp_kses_post($item['quote']); ?>
                                            </blockquote>
                                        </div>
                                    </div>
                                </div>
                                <!-- testimonials quote end -->
                            	<?php endforeach; ?>
                            </div>
                            <!-- testimonials end -->
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                            <?php if ( $settings['show_button'] ) : ?>
                            <!-- button start -->
                            <div class="more-wraper-center">
                                <a data-lity="" href="<?php print wp_kses_post($settings['video_button']); ?>">
                                    <div class="more-button-bg-center more-button-circle"></div>
                                    <div class="more-button-txt-center">
                                        <span><?php print wp_kses_post($settings['button']); ?></span>
                                    </div>
                                </a>
                            </div>
                            <!-- button end -->
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                        	<?php endif; ?>
                            <!-- line start -->
                            <div class="the-line the-line-light"></div>
                            <!-- line end -->
                        </div>
                        <!-- parallax content end -->
                    </div>
                    <!-- parallax wrapper end -->
                </div>
                <!-- row end -->
            </div>
            <!-- container end -->
        </div>
        <?php endif; ?>
	<?php
	}

}