<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsTeam extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-Team';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Team', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Team widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-person';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Team widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'Team' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_heading',
			[
				'label' => esc_html__( 'Team', 'bdevs-elementor' ),
			]	
		);

		$this->add_control(
			'number',
			[
				'label'       => __( 'Number', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'		=> __('Number', 'bdevs-elementor'),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Subheading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'		=> __('Subheading', 'bdevs-elementor'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'		=> __('This is heading', 'bdevs-elementor'),
				'label_block' => true,
			]
		);	

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_team',
			[
				'label' => esc_html__( 'Team Items', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name'    => 'tab_image',
						'label'   => esc_html__( 'Image', 'bdevs-elementor' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
					],
					[
						'name'        => 'title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'subtitle',
						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Subtitle' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'facebook',
						'label'       => esc_html__( 'Facebook', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Facebook' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'twitter',
						'label'       => esc_html__( 'Twitter', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Twitter' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'instagram',
						'label'       => esc_html__( 'Instagram', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Instagram' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'linkedin',
						'label'       => esc_html__( 'Linkedin', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Linkedin' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);

		$this->end_controls_section();

		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_subheading',
			[
				'label'   => esc_html__( 'Show Subheading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings); ?>
		<div id="team" class="section-all bg-dark">
            <div class="container-fluid nopadding">
                <!-- row start -->
                <div class="row">
                    <!-- col start -->
                    <div class="col-lg-12">
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                        <!-- line start -->
                        <div class="the-line"></div>
                        <!-- line end -->
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                    </div>
                    <!-- col end -->
                </div>
                <!-- row end -->
                <!-- row start -->
                <div class="row">
                    <!-- col start -->
                    <div class="col-lg-12">
                        <?php if ( $settings['show_subheading'] ) : ?>
                        <!-- section title start -->
                        <h2 class="section-heading">
                            <span><?php print wp_kses_post($settings['number']); ?> </span> <?php print wp_kses_post($settings['subheading']); ?>
                        </h2>
                        <!-- section title end -->
                        <!-- divider start -->
                        <div class="divider-m"></div>
                        <!-- divider end -->
                    	<?php endif; ?>
                    	<?php if ( $settings['show_heading'] ) : ?>
                        <!-- section title start -->
                        <h2 class="hero-heading hero-heading-dark">
                            <?php print wp_kses_post($settings['heading']); ?>
                        </h2>
                        <!-- section title end -->
                        <?php endif; ?>
                    </div>
                    <!-- col end -->
                </div>
                <!-- row end -->
                <!-- row start -->
                <div class="row">
                    <!-- col start -->
                    <div class="col-lg-12">
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                        <!-- line start -->
                        <div class="the-line"></div>
                        <!-- line end -->
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                    </div>
                    <!-- col end -->
                </div>
                <!-- row end -->
                <!-- carousel start -->
                <div class="carousel-item-img-wrapper carousel-item-img-wrapper-all">
                    <div class="extra-margin-owl">
                        <div class="owl-carousel owl-carousel-team popup-photo-gallery">
                        	<?php 
			                    foreach ( $settings['tabs'] as $item ) : 
							?>
                            <!-- section item start -->
                            <div class="post-box">
                                <div class="hover-effect-img">
                                    <div class="hover-icons">
                                    	<?php if ( '' !== $item['facebook'] ) : ?>
                                        <a class="iw-slide-left ion-social-facebook" href="<?php print wp_kses_post($item['facebook']); ?>"></a> 
                                        <?php endif; ?>
                                    	<?php if ( '' !== $item['twitter'] ) : ?>
                                        <a class="iw-slide-left ion-social-twitter" href="<?php print wp_kses_post($item['twitter']); ?>"></a> 
                                        <?php endif; ?>
                                        <a class="ion-plus popup-photo-gallery-open" href="<?php echo wp_kses_post($item['tab_image']['url']); ?>" title="<?php print wp_kses_post($item['image_description']); ?>"></a> 
                                        <?php if ( '' !== $item['instagram'] ) : ?>
                                        <a class="iw-slide-right ion-social-instagram" href="<?php print wp_kses_post($item['instagram']); ?>"></a>  
                                        <?php endif; ?>       
                                        <?php if ( '' !== $item['linkedin'] ) : ?>
                                        <a class="iw-slide-right ion-social-linkedin" href="<?php print wp_kses_post($item['linkedin']); ?>"></a>  
                                        <?php endif; ?>                         
                                    </div>
                                    <!-- circle wrapper start -->
                                    <div class="circle-wrapper-full">
                                        <div class="carousel-item-all carousel-item-team-01" style="background-image: url(<?php echo wp_kses_post($item['tab_image']['url']); ?>);"></div>
                                    </div>
                                    <!-- circle wrapper end -->
                                    <div class="hover-effect the-team"></div>
                                </div>
                                <!-- divider start -->
                                <div class="divider-m"></div>
                                <!-- divider end -->
                                <!-- section subtitle start -->            
                                <div class="post-box-inner">
                                    <a class="popup-photo" href="<?php echo wp_kses_post($item['tab_image']['url']); ?>" title="<?php print wp_kses_post($item['image_description']); ?>">
                                        <div class="team-box">
                                            <?php print wp_kses_post($item['title']); ?> <span><?php print wp_kses_post($item['subtitle']); ?></span>
                                        </div>
                                    </a>
                                </div>
                                <!-- section subtitle end -->
                            </div>
                            <!-- section item end -->
                        	<?php endforeach; ?>
                        </div>
                    </div>
                </div>
                <!-- carousel end -->
                <!-- divider start -->
                <div class="divider-l"></div>
                <!-- divider end -->
                <!-- owl nav start -->
                <div class="owl-nav owl-nav-custom-team"></div>
                <!-- owl nav end -->
                <!-- row start -->
                <div class="row">
                    <!-- col start -->
                    <div class="col-lg-12">
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                        <!-- line start -->
                        <div class="the-line"></div>
                        <!-- line end -->
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                    </div>
                    <!-- col end -->
                </div>
                <!-- row end -->
            </div>
        </div>
	<?php
	}

}