<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsSlider02 extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-slider-two';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Single Slider', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Slider widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-slides';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Slider widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'slider', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_heading',
			[
				'label' => esc_html__( 'Slider', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Select Style', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'slider_style_1'  => esc_html__( 'Image', 'bdevs-elementor' ),
					'slider_style_2' => esc_html__( 'Video', 'bdevs-elementor' ),
				],
				'default'   => 'slider_style_1',
			]
		);

		$this->add_control(
			'ch_style',
			[
				'label'     => esc_html__( 'Select Style', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'stars'  => esc_html__( 'Stars', 'bdevs-elementor' ),
					'sub' => esc_html__( 'Subheading', 'bdevs-elementor' ),
				],
				'default'   => 'stars',
			]
		);

		$this->add_control(
			'background_bg',
			[
				'label'   => esc_html__( 'Background Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add image from here', 'bdevs-elementor' ),
				'condition' => [
                    'chose_style' => ['slider_style_1']
                ],
			]
		);

		$this->add_control(
			'video',
			[
				'label'       => __( 'Link Video(mp4)', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'		=> __('#', 'bdevs-elementor'),
				'label_block' => true,
				'condition' => [
                    'chose_style' => ['slider_style_2']
                ],
			]
		);

		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Subheading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'		=> __('This is subheading', 'bdevs-elementor'),
				'label_block' => true,
				'condition' => [
                    'ch_style' => ['sub']
                ],
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'		=> __('This is heading', 'bdevs-elementor'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'button',
			[
				'label'       => __( 'Button', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'		=> __('Button', 'bdevs-elementor'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'link_button',
			[
				'label'       => __( 'Link Button', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'		=> __('#', 'bdevs-elementor'),
				'label_block' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_button',
			[
				'label'   => esc_html__( 'Show Button', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		extract($settings);
		?>
		
		<div class="upper-page bg-dark" id="home">
            <!-- hero bg start -->
            <div class="hero-fullscreen">
                <div class="hero-fullscreen-FIX">
                    <div class="hero-bg">
                        <!-- hero slider wrapper start -->
                        <div class="swiper-container-wrapper">
                            <!-- swiper container start -->
                            <div class="swiper-container swiper2">
                                <!-- swiper wrapper start -->
                                <div class="swiper-wrapper">
                                    <!-- swiper slider item start -->
                                    <div class="swiper-slide">
                                        <div class="swiper-slide-inner">
                                        	<?php if( $chose_style == 'slider_style_1' ): ?>
                                            <!-- swiper slider item IMG start -->
                                            <div class="swiper-slide-inner-bg bg-img-1 overlay overlay-dark" style="background-image: url(<?php echo wp_kses_post($settings['background_bg']['url']); ?>);">
                                            </div>
                                            <!-- swiper slider item IMG end -->
                                            <?php elseif( $chose_style == 'slider_style_2' ): ?>
                                            <div class="swiper-slide-inner-bg bg-img-1 overlay overlay-dark">
                                                <!-- HTML5 video URL start -->
                                                <video playsinline autoplay muted loop>
                                                    <source src="<?php print wp_kses_post($settings['video']); ?>" type="video/mp4">
                                                </video>
                                                <!-- HTML5 video URL end -->
                                            </div>
                                            <?php endif; ?>
                                            <!-- swiper slider item txt start -->
                                            <div class="swiper-slide-inner-txt-2">
                                            	<?php if( $ch_style == 'stars' ): ?>
                                                <!-- section subtitle start -->
                                                <div class="star-wrapper fadeIn-element">
                                                    <span class="ion-ios-star"></span>
                                                    <span class="ion-ios-star"></span>
                                                    <span class="ion-ios-star"></span>
                                                    <span class="ion-ios-star"></span>
                                                    <span class="ion-ios-star"></span>
                                                </div>
                                                <!-- section subtitle end -->
                                                <!-- divider start -->
                                                <div class="divider-m"></div>
                                                <!-- divider end -->
                                                <?php elseif( $ch_style == 'sub' ): ?>
                                                <div class="blog-tag blog-tag-light fadeIn-element"><?php print wp_kses_post($settings['subheading']); ?></div>
                                                <div class="divider-m"></div>
                                                <!-- divider end -->
                                                <?php endif; ?>
                                                <!-- section title start -->
                                                <h1 class="hero-heading hero-heading-home fadeIn-element">
                                                    <?php print wp_kses_post($settings['heading']); ?>
                                                </h1>
                                                <!-- section title end -->
                                                <!-- divider start -->
                                                <div class="divider-m"></div>
                                                <!-- divider end -->
                                                <?php if ( $settings['show_button'] ) : ?>
                                                <!-- button start -->
                                                <div class="more-wraper-center more-wraper-center-home fadeIn-element">
                                                    <a class="button button-effect"  href="<?php print wp_kses_post($settings['link_button']); ?>">
                                                        <div class="more-wraper-inner-home">
                                                            <i class="pulse"></i>
                                                            <div class="more-button-txt-center more-button-txt-center-home">
                                                                <span><?php print wp_kses_post($settings['button']); ?></span>
                                                            </div>
                                                        </div>
                                                    </a>
                                                </div>
                                                <!-- button end -->
                                            <?php endif; ?>                                
                                            </div>
                                            <!-- swiper slider item txt end -->
                                        </div>
                                    </div>
                                    <!-- swiper slider item end -->
                                </div>
                                <!-- swiper wrapper end -->   
                            </div>
                            <!-- swiper container end -->
                        </div>
                        <!-- hero slider wrapper end -->
                    </div>
                </div>
            </div>
            <!-- hero bg end -->
            <!-- scroll indicator start -->
            <div class="scroll-indicator">
                <div class="scroll-indicator-wrapper">
                    <div class="scroll-line fadeIn-element"></div>
                </div>
            </div>
            <!-- scroll indicator end -->
        </div>
        <!-- vertical lines start -->
        <div class="vertical-lines-wrapper">
            <div class="vertical-lines"></div>
        </div>
        <!-- vertical lines end -->
	<?php
	}

}