<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsServices extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-Services';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Services', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Services widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-image-box';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Services widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'Services' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_heading',
			[
				'label' => esc_html__( 'Services', 'bdevs-elementor' ),
			]	
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Select Style', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'style_1'  => esc_html__( 'Style 1', 'bdevs-elementor' ),
					'style_2' => esc_html__( 'Style 2', 'bdevs-elementor' ),
				],
				'default'   => 'style_1',
			]
		);

		$this->add_control(
			'number',
			[
				'label'       => __( 'Number', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'		=> __('Number', 'bdevs-elementor'),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Subheading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'		=> __('Subheading', 'bdevs-elementor'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'		=> __('This is heading', 'bdevs-elementor'),
				'label_block' => true,
			]
		);	

		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_content_service',
			[
				'label' => esc_html__( 'Service Items', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name'        => 'title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'subtitle',
						'label'       => esc_html__( 'Subtitle', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Subtitle' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'content',
						'label'       => esc_html__( 'Content', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'This is content' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'    => 'tab_image',
						'label'   => esc_html__( 'Background Image', 'bdevs-elementor' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
					],
					[
						'name'        => 'image_description',
						'label'       => esc_html__( 'Image Description', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Image Description' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'image_title',
						'label'       => esc_html__( 'Image Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Image Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'button',
						'label'       => esc_html__( 'Button', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Button' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'link_button',
						'label'       => esc_html__( 'Link Button', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( '#' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);

		$this->end_controls_section();
		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_subheading',
			[
				'label'   => esc_html__( 'Show Subheading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings); ?>
		<?php if( $chose_style == 'style_1' ): ?>
		<div id="rooms" class="section-all bg-dark">
            <!-- container start -->
            <div class="container">
                <!-- row start -->
                <div class="row">
                    <!-- col start -->
                    <div class="col-lg-12">
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                        <!-- line start -->
                        <div class="the-line"></div>
                        <!-- line end -->
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                    </div>
                    <!-- col end -->
                </div>
                <!-- row end -->
                <!-- row start -->
                <div class="row">
                    <!-- col start -->
                    <div class="col-lg-12">
                        <?php if ( $settings['show_subheading'] ) : ?>
                        <!-- section title start -->
                        <h2 class="section-heading">
                            <span><?php print wp_kses_post($settings['number']); ?> </span> <?php print wp_kses_post($settings['subheading']); ?>
                        </h2>
                        <!-- section title end -->
                        <!-- divider start -->
                        <div class="divider-m"></div>
                        <!-- divider end -->
                    	<?php endif; ?>
                    	<?php if ( $settings['show_heading'] ) : ?>
                        <!-- section title start -->
                        <h2 class="hero-heading hero-heading-dark">
                            <?php print wp_kses_post($settings['heading']); ?>
                        </h2>
                        <!-- section title end -->
                        <?php endif; ?>
                    </div>
                    <!-- col end -->
                </div>
                <!-- row end -->
                <!-- row start -->
                <div class="row">
                    <!-- col start -->
                    <div class="col-lg-12">
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                        <!-- line start -->
                        <div class="the-line"></div>
                        <!-- line end -->
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                    </div>
                    <!-- col end -->
                </div>
                <!-- row end -->
            </div>
            <!-- container end -->
            <!-- container start -->
            <div class="container-fluid nopadding">
                <!-- carousel start -->
                <div class="owl-carousel owl-carousel-rooms">

                	<?php $i=0;
	                    foreach ( $settings['tabs'] as $item ) : 
	                    $i++;
					?>
					<?php if($i%2 == 1){ ?>
                    <!-- halve start -->
                    <div class="halves">
                        <!-- halve IMG start -->
                        <div class="half post-bg-all rooms-bg-1 all-bg-right" style="background-image: url(<?php echo wp_kses_post($item['tab_image']['url']); ?>);"></div>
                        <a class="popup-photo" href="<?php echo wp_kses_post($item['tab_image']['url']); ?>" title="<?php print wp_kses_post($item['image_description']); ?>">
                            <div class="image-caption"><?php print wp_kses_post($item['image_title']); ?></div>
                        </a>
                        <!-- halve IMG end -->
                        <!-- halve TXT start -->
                        <div class="half half-color">
                            <!-- row start -->
                            <div class="row post-all-txt">
                                <!-- col start -->
                                <div class="col-md-12">
                                    <!-- divider start -->
                                    <div class="divider-l"></div>
                                    <!-- divider end -->
                                    <!-- section subtitle start -->
                                    <div class="star-wrapper">
                                        <span class="ion-ios-star"></span>
                                        <span class="ion-ios-star"></span>
                                        <span class="ion-ios-star"></span>
                                        <span class="ion-ios-star"></span>
                                        <span class="ion-ios-star"></span>
                                    </div>
                                    <!-- section subtitle end -->
                                    <!-- divider start -->
                                    <div class="divider-m"></div>
                                    <!-- divider end -->
                                    <!-- section title start -->
                                    <h2>
                                        <?php print wp_kses_post($item['title']); ?>
                                    </h2>
                                    <!-- divider start -->
                                    <div class="divider-l"></div>
                                    <!-- divider end -->
                                    <!-- section txt start -->
                                    <p>
                                        <?php print wp_kses_post($item['content']); ?>
                                    </p>
                                    <!-- section txt end -->
                                    <!-- divider start -->
                                    <div class="divider-l"></div>
                                    <!-- divider end -->
                                    <?php if ( '' !== $item['button'] ) : ?>
                                    <!-- button start -->
                                    <div class="more-wraper-center">
                                        <a href="<?php print wp_kses_post($item['link_button']); ?>">
                                            <div class="more-button-bg-center more-button-bg-center-dark more-button-bg-center-dark-close more-button-circle"></div>
                                            <div class="more-button-txt-center more-button-txt-center-close">
                                                <span><?php print wp_kses_post($item['button']); ?></span>
                                            </div>
                                        </a>
                                    </div>
                                    <!-- button end -->
                                    <!-- divider start -->
                                    <div class="divider-l"></div>
                                    <!-- divider end -->
                                	<?php endif; ?>
                                </div>
                                <!-- col end -->
                            </div>
                            <!-- row end -->
                        </div>
                        <!-- halve TXT end -->
                    </div>
                    <!-- halve end -->
                	<?php }else{ ?>
                    <!-- halve start -->
                    <div class="halves">
                        <!-- halve TXT start -->
                        <div class="half half-color">
                            <!-- row start -->
                            <div class="row post-all-txt">
                                <!-- col start -->
                                <div class="col-md-12">
                                    <!-- divider start -->
                                    <div class="divider-l"></div>
                                    <!-- divider end -->
                                    <!-- section subtitle start -->
                                    <div class="star-wrapper">
                                        <span class="ion-ios-star"></span>
                                        <span class="ion-ios-star"></span>
                                        <span class="ion-ios-star"></span>
                                        <span class="ion-ios-star"></span>
                                        <span class="ion-ios-star"></span>
                                    </div>
                                    <!-- section subtitle end -->
                                    <!-- divider start -->
                                    <div class="divider-m"></div>
                                    <!-- divider end -->
                                    <!-- section title start -->
                                    <h2>
                                        <?php print wp_kses_post($item['title']); ?>
                                    </h2>
                                    <!-- divider start -->
                                    <div class="divider-l"></div>
                                    <!-- divider end -->
                                    <!-- section txt start -->
                                    <p>
                                        <?php print wp_kses_post($item['content']); ?>
                                    </p>
                                    <!-- section txt end -->
                                    <!-- divider start -->
                                    <div class="divider-l"></div>
                                    <!-- divider end -->
                                    <?php if ( '' !== $item['button'] ) : ?>
                                    <!-- button start -->
                                    <div class="more-wraper-center">
                                        <a href="<?php print wp_kses_post($item['link_button']); ?>">
                                            <div class="more-button-bg-center more-button-bg-center-dark more-button-bg-center-dark-close more-button-circle"></div>
                                            <div class="more-button-txt-center more-button-txt-center-close">
                                                <span><?php print wp_kses_post($item['button']); ?></span>
                                            </div>
                                        </a>
                                    </div>
                                    <!-- button end -->
                                    <!-- divider start -->
                                    <div class="divider-l"></div>
                                    <!-- divider end -->
                                	<?php endif; ?>
                                </div>
                                <!-- col end -->
                            </div>
                            <!-- row end -->
                        </div>
                        <!-- halve TXT end -->
                        <!-- halve IMG start -->
                        <div class="half post-bg-all rooms-bg-2 all-bg-left" style="background-image: url(<?php echo wp_kses_post($item['tab_image']['url']); ?>);"></div>
                        <a class="popup-photo" href="<?php echo wp_kses_post($item['tab_image']['url']); ?>" title="<?php print wp_kses_post($item['image_description']); ?>">
                            <div class="image-caption"><?php print wp_kses_post($item['image_title']); ?></div>
                        </a>
                        <!-- halve IMG end -->
                    </div>
                    <!-- halve end -->
                	<?php } ?>
                	<?php endforeach; ?>
                </div>
                <!-- carousel end -->
                <!-- divider start -->
                <div class="divider-l"></div>
                <!-- divider end -->
                <!-- owl nav start -->
                <div class="owl-nav owl-nav-custom-rooms"></div>
                <!-- owl nav end -->
                <!-- row start -->
                <div class="row">
                    <!-- col start -->
                    <div class="col-lg-12">
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                        <!-- line start -->
                        <div class="the-line"></div>
                        <!-- line end -->
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                    </div>
                    <!-- col end -->
                </div>
                <!-- row end -->
            </div>
            <!-- container end -->
        </div>
        <!-- rooms end -->
        <?php elseif( $chose_style == 'style_2' ): ?>
        <div id="facilities" class="section-all bg-light">
            <!-- container start -->
            <div class="container">
                <!-- row start -->
                <div class="row">
                    <!-- col start -->
                    <div class="col-lg-12">
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                        <!-- line start -->
                        <div class="the-line"></div>
                        <!-- line end -->
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                    </div>
                    <!-- col end -->
                </div>
                <!-- row end -->
                <!-- row start -->
                <div class="row">
                    <!-- col start -->
                    <div class="col-lg-12">
                        <?php if ( $settings['show_subheading'] ) : ?>
                        <!-- section title start -->
                        <h2 class="section-heading">
                            <span><?php print wp_kses_post($settings['number']); ?> </span> <?php print wp_kses_post($settings['subheading']); ?>
                        </h2>
                        <!-- section title end -->
                        <!-- divider start -->
                        <div class="divider-m"></div>
                        <!-- divider end -->
                    	<?php endif; ?>
                    	<?php if ( $settings['show_heading'] ) : ?>
                        <!-- section title start -->
                        <h2 class="hero-heading hero-heading-dark">
                            <?php print wp_kses_post($settings['heading']); ?>
                        </h2>
                        <!-- section title end -->
                        <?php endif; ?>
                    </div>
                    <!-- col end -->
                </div>
                <!-- row end -->
                <!-- row start -->
                <div class="row">
                    <!-- col start -->
                    <div class="col-lg-12">
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                        <!-- line start -->
                        <div class="the-line"></div>
                        <!-- line end -->
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                    </div>
                    <!-- col end -->
                </div>
                <!-- row end -->
            </div>
            <!-- container end -->
            <!-- container start -->
            <div class="container-fluid nopadding">
                <!-- carousel start -->
                <div class="owl-carousel owl-carousel-facilities">
                    <!-- halve start -->
                    <?php $i=0;
	                    foreach ( $settings['tabs'] as $item ) : 
	                    $i++;
					?>
					<?php if($i%2 == 1){ ?>
                    <div class="halves">
                        <!-- halve IMG start -->
                        <div class="half post-bg-all facilities-bg-1 all-bg-right" style="background-image: url(<?php echo wp_kses_post($item['tab_image']['url']); ?>);"></div>
                        <a class="popup-photo" href="<?php echo wp_kses_post($item['tab_image']['url']); ?>" title="<?php print wp_kses_post($item['image_description']); ?>">
                            <div class="image-caption"><?php print wp_kses_post($item['image_title']); ?></div>
                        </a>
                        <!-- halve IMG end -->
                        <!-- halve TXT start -->
                        <div class="half half-color half-color-invert">
                            <!-- row start -->
                            <div class="row post-all-txt">
                                <!-- col start -->
                                <div class="col-md-12">
                                    <!-- divider start -->
                                    <div class="divider-l"></div>
                                    <!-- divider end -->
                                    <!-- section title start -->
                                    <h2>
                                        <?php print wp_kses_post($item['title']); ?>
                                    </h2>
                                    <!-- section title end -->
                                    <!-- divider start -->
                                    <div class="divider-m"></div>
                                    <!-- divider end -->
                                    <?php if ( '' !== $item['subtitle'] ) : ?>
                                    <!-- section subtitle start -->
                                    <div class="blog-tag"><?php print wp_kses_post($item['subtitle']); ?></div>
                                    <!-- section subtitle end -->
                                    <!-- divider start -->
                                    <div class="divider-l"></div>
                                    <!-- divider end -->
                                    <?php endif; ?>
                                    <!-- section txt start -->
                                    <p>
                                        <?php print wp_kses_post($item['content']); ?>
                                    </p>
                                    <!-- section txt end -->
                                    <!-- divider start -->
                                    <div class="divider-l"></div>
                                    <!-- divider end -->
                                    <?php if ( '' !== $item['button'] ) : ?>
                                    <!-- button start -->
                                    <div class="more-wraper-center">
                                        <a href="<?php print wp_kses_post($item['link_button']); ?>">
                                            <div class="more-button-bg-center more-button-bg-center-dark more-button-bg-center-dark-close more-button-circle"></div>
                                            <div class="more-button-txt-center more-button-txt-center-close">
                                                <span><?php print wp_kses_post($item['button']); ?></span>
                                            </div>
                                        </a>
                                    </div>
                                    <!-- button end -->
                                    <!-- divider start -->
                                    <div class="divider-l"></div>
                                    <!-- divider end -->
                                	<?php endif; ?>
                                </div>
                                <!-- col end -->
                            </div>
                            <!-- row end -->
                        </div>
                        <!-- halve TXT end -->
                    </div>
                    <!-- halve end -->
                	<?php }else{ ?>
                    <!-- halve start -->
                    <div class="halves">
                        <!-- halve TXT start -->
                        <div class="half half-color half-color-invert">
                            <!-- row start -->
                            <div class="row post-all-txt">
                                <!-- col start -->
                                <div class="col-md-12">
                                    <!-- divider start -->
                                    <div class="divider-l"></div>
                                    <!-- divider end -->
                                    <!-- section title start -->
                                    <h2>
                                        <?php print wp_kses_post($item['title']); ?>
                                    </h2>
                                    <!-- section title end -->
                                    <!-- divider start -->
                                    <div class="divider-m"></div>
                                    <!-- divider end -->
                                    <?php if ( '' !== $item['subtitle'] ) : ?>
                                    <!-- section subtitle start -->
                                    <div class="blog-tag"><?php print wp_kses_post($item['subtitle']); ?></div>
                                    <!-- section subtitle end -->
                                    <!-- divider start -->
                                    <div class="divider-l"></div>
                                    <!-- divider end -->
                                    <?php endif; ?>
                                    <!-- section txt start -->
                                    <p>
                                        <?php print wp_kses_post($item['content']); ?>
                                    </p>
                                    <!-- section txt end -->
                                    <!-- divider start -->
                                    <div class="divider-l"></div>
                                    <!-- divider end -->
                                    <?php if ( '' !== $item['button'] ) : ?>
                                    <!-- button start -->
                                    <div class="more-wraper-center">
                                        <a href="<?php print wp_kses_post($item['link_button']); ?>">
                                            <div class="more-button-bg-center more-button-bg-center-dark more-button-bg-center-dark-close more-button-circle"></div>
                                            <div class="more-button-txt-center more-button-txt-center-close">
                                                <span><?php print wp_kses_post($item['button']); ?></span>
                                            </div>
                                        </a>
                                    </div>
                                    <!-- button end -->
                                    <!-- divider start -->
                                    <div class="divider-l"></div>
                                    <!-- divider end -->
                                	<?php endif; ?>
                                </div>
                                <!-- col end -->
                            </div>
                            <!-- row end -->
                        </div>
                        <!-- halve TXT end -->
                        <!-- halve IMG start -->
                        <div class="half post-bg-all facilities-bg-2 all-bg-left" style="background-image: url(<?php echo wp_kses_post($item['tab_image']['url']); ?>);"></div>
                        <a class="popup-photo" href="<?php echo wp_kses_post($item['tab_image']['url']); ?>" title="<?php print wp_kses_post($item['image_description']); ?>">
                            <div class="image-caption"><?php print wp_kses_post($item['image_title']); ?></div>
                        </a>
                        <!-- halve IMG end -->
                    </div>
                    <!-- halve end -->
                	<?php } ?>
                	<?php endforeach; ?>
                </div>
                <!-- carousel end -->
                <!-- divider start -->
                <div class="divider-l"></div>
                <!-- divider end -->
                <!-- owl nav start -->
                <div class="owl-nav owl-nav-custom-facilities"></div>
                <!-- owl nav end -->
                <!-- row start -->
                <div class="row">
                    <!-- col start -->
                    <div class="col-lg-12">
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                        <!-- line start -->
                        <div class="the-line"></div>
                        <!-- line end -->
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                    </div>
                    <!-- col end -->
                </div>
                <!-- row end -->
            </div>
            <!-- container end -->
        </div>
        <?php endif; ?>
	<?php
	}

}