<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsRoom extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-room';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Room', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Room widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-parallax';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Room widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'Room' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_heading',
			[
				'label' => esc_html__( 'Room', 'bdevs-elementor' ),
			]	
		);

		$this->add_control(
			'post_number',
			[
				'label'     => esc_html__( 'Post Count', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your count', 'bdevs-elementor' ),
				'default'   => '4',
				'label_block' => true,
			]
		);

		$this->add_control(
			'post_order',
			[
				'label'     => esc_html__( 'Order', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'asc'  => esc_html__( 'ASC', 'bdevs-elementor' ),
					'desc' => esc_html__( 'DESC', 'bdevs-elementor' ),
				],
				'default'   => 'asc',
			]
		);

		$this->end_controls_section();

		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_stars',
			[
				'label'   => esc_html__( 'Show Stars', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display(); 
		extract($settings);	
		$post_number = $settings['post_number'];
	    $order = $settings['post_order'];
	    $wp_query = new \WP_Query(array('posts_per_page' => $post_number,'post_type' => 'room',  'orderby' => 'ID', 'order' => $order));
	   
	    //other style
	    $args = array('posts_per_page' => $post_number,'post_type' => 'room',  'orderby' => 'ID', 'order' => $order);	
	   	?>
	   	

		<div class="post-wrapper">
            <!-- post content start -->
            <div class="lower-page lower-page-post">
                <div class="post-content">
                	<?php $i=0;
		                $args = new \WP_Query(array(   
		                            'post_type' => 'post', 
		                        ));  
		                while ($wp_query -> have_posts()) : $wp_query -> the_post(); 
		                $i++;
		            ?>
		            <?php $feature_1 = get_post_meta(get_the_ID(),'_cmb_feature_1', true); ?>
					<?php $icon_1 = get_post_meta(get_the_ID(),'_cmb_icon_1', true); ?>
					<?php $feature_2 = get_post_meta(get_the_ID(),'_cmb_feature_2', true); ?>
					<?php $icon_2 = get_post_meta(get_the_ID(),'_cmb_icon_2', true); ?>
					<?php $feature_3 = get_post_meta(get_the_ID(),'_cmb_feature_3', true); ?>
					<?php $icon_3 = get_post_meta(get_the_ID(),'_cmb_icon_3', true); ?>
					<?php $feature_4 = get_post_meta(get_the_ID(),'_cmb_feature_4', true); ?>
					<?php $icon_4 = get_post_meta(get_the_ID(),'_cmb_icon_4', true); ?>
					<?php $feature_5 = get_post_meta(get_the_ID(),'_cmb_feature_5', true); ?>
					<?php $icon_5 = get_post_meta(get_the_ID(),'_cmb_icon_5', true); ?>
					<?php $feature_6 = get_post_meta(get_the_ID(),'_cmb_feature_6', true); ?>
					<?php $icon_6 = get_post_meta(get_the_ID(),'_cmb_icon_6', true); ?>
					<?php $feature_7 = get_post_meta(get_the_ID(),'_cmb_feature_7', true); ?>
					<?php $icon_7 = get_post_meta(get_the_ID(),'_cmb_icon_7', true); ?>
					<?php $feature_8 = get_post_meta(get_the_ID(),'_cmb_feature_8', true); ?>
					<?php $icon_8 = get_post_meta(get_the_ID(),'_cmb_icon_8', true); ?>
					<?php $image_description = get_post_meta(get_the_ID(),'_cmb_image_description', true); ?>
                    <!-- container start -->
                    <div class="container">
                        <div class="extra-margin-container extra-margin-container-post">
                            <!-- row start -->
                            <div class="row">
                                <!-- col start -->
                                <div class="col-lg-12">
                                    <!-- divider start -->
                                    <div class="divider-l"></div>
                                    <!-- divider end -->
                                    <!-- line start -->
                                    <div class="the-line"></div>
                                    <!-- line end -->
                                    <!-- divider start -->
                                    <div class="divider-l"></div>
                                    <!-- divider end -->
                                </div>
                                <!-- col end -->
                            </div>
                            <!-- row end -->
                            <!-- row start -->
                            <div class="row">
                                <!-- col start -->
                                <div class="col-lg-12">
                                    <div class="text">
                                    	<?php if ( $settings['show_stars'] ) : ?>
                                        <!-- section subtitle start -->
                                        <div class="star-wrapper">
                                            <span class="ion-ios-star"></span>
                                            <span class="ion-ios-star"></span>
                                            <span class="ion-ios-star"></span>
                                            <span class="ion-ios-star"></span>
                                            <span class="ion-ios-star"></span>
                                        </div>
                                        <!-- section subtitle end -->
                                        <!-- divider start -->
                                        <div class="divider-m"></div>
                                        <!-- divider end -->
                                    	<?php endif; ?>
                                        <!-- section title start -->
                                        <h2>
                                            <?php the_title(); ?>
                                        </h2>
                                        <!-- section title end -->
                                        <!-- divider start -->
                                        <div class="divider-l"></div>
                                        <!-- divider end -->
                                    </div>
                                </div>
                                <!-- col end -->
                            </div>
                            <!-- row end -->
                            <!-- row start -->
                            <div class="row">
		                        <?php if($feature_1 !='') { ?>
		                        <!-- col start -->
		                        <div class="col-md-3">
		                            <!-- section subtitle start -->
		                            <div class="blog-tag blog-tag-rooms"><?php echo wp_specialchars_decode(esc_attr($feature_1)); ?> <span class="<?php echo wp_specialchars_decode(esc_attr($icon_1)); ?>"></span></div>
		                            <!-- section subtitle end -->
		                            <!-- divider start -->
		                            <div class="divider-m"></div>
		                            <!-- divider end -->
		                        </div>
		                        <!-- col end -->
		                        <?php } ?>

		                        <?php if($feature_2 !='') { ?>
		                        <!-- col start -->
		                        <div class="col-md-3">
		                            <!-- section subtitle start -->
		                            <div class="blog-tag blog-tag-rooms"><?php echo wp_specialchars_decode(esc_attr($feature_2)); ?> <span class="<?php echo wp_specialchars_decode(esc_attr($icon_2)); ?>"></span></div>
		                            <!-- section subtitle end -->
		                            <!-- divider start -->
		                            <div class="divider-m"></div>
		                            <!-- divider end -->
		                        </div>
		                        <!-- col end -->
		                        <?php } ?>

		                        <?php if($feature_3 !='') { ?>
		                        <!-- col start -->
		                        <div class="col-md-3">
		                            <!-- section subtitle start -->
		                            <div class="blog-tag blog-tag-rooms"><?php echo wp_specialchars_decode(esc_attr($feature_3)); ?> <span class="<?php echo wp_specialchars_decode(esc_attr($icon_3)); ?>"></span></div>
		                            <!-- section subtitle end -->
		                            <!-- divider start -->
		                            <div class="divider-m"></div>
		                            <!-- divider end -->
		                        </div>
		                        <!-- col end -->
		                        <?php } ?>

		                        <?php if($feature_4 !='') { ?>
		                        <!-- col start -->
		                        <div class="col-md-3">
		                            <!-- section subtitle start -->
		                            <div class="blog-tag blog-tag-rooms"><?php echo wp_specialchars_decode(esc_attr($feature_4)); ?> <span class="<?php echo wp_specialchars_decode(esc_attr($icon_4)); ?>"></span></div>
		                            <!-- section subtitle end -->
		                            <!-- divider start -->
		                            <div class="divider-m"></div>
		                            <!-- divider end -->
		                        </div>
		                        <!-- col end -->
		                        <?php } ?>
		                    </div>
		                    <!-- row end -->
		                    <!-- row start -->
		                    <div class="row">
		                        <?php if($feature_5 !='') { ?>
		                        <!-- col start -->
		                        <div class="col-md-3">
		                            <!-- section subtitle start -->
		                            <div class="blog-tag blog-tag-rooms"><?php echo wp_specialchars_decode(esc_attr($feature_5)); ?> <span class="<?php echo wp_specialchars_decode(esc_attr($icon_5)); ?>"></span></div>
		                            <!-- section subtitle end -->
		                            <!-- divider start -->
		                            <div class="divider-m"></div>
		                            <!-- divider end -->
		                        </div>
		                        <!-- col end -->
		                        <?php } ?>

		                        <?php if($feature_6 !='') { ?>
		                        <!-- col start -->
		                        <div class="col-md-3">
		                            <!-- section subtitle start -->
		                            <div class="blog-tag blog-tag-rooms"><?php echo wp_specialchars_decode(esc_attr($feature_6)); ?> <span class="<?php echo wp_specialchars_decode(esc_attr($icon_6)); ?>"></span></div>
		                            <!-- section subtitle end -->
		                            <!-- divider start -->
		                            <div class="divider-m"></div>
		                            <!-- divider end -->
		                        </div>
		                        <!-- col end -->
		                        <?php } ?>

		                        <?php if($feature_7 !='') { ?>
		                        <!-- col start -->
		                        <div class="col-md-3">
		                            <!-- section subtitle start -->
		                            <div class="blog-tag blog-tag-rooms"><?php echo wp_specialchars_decode(esc_attr($feature_7)); ?> <span class="<?php echo wp_specialchars_decode(esc_attr($icon_7)); ?>"></span></div>
		                            <!-- section subtitle end -->
		                            <!-- divider start -->
		                            <div class="divider-m"></div>
		                            <!-- divider end -->
		                        </div>
		                        <!-- col end -->
		                        <?php } ?>

		                        <?php if($feature_8 !='') { ?>
		                        <!-- col start -->
		                        <div class="col-md-3">
		                            <!-- section subtitle start -->
		                            <div class="blog-tag blog-tag-rooms"><?php echo wp_specialchars_decode(esc_attr($feature_8)); ?> <span class="<?php echo wp_specialchars_decode(esc_attr($icon_8)); ?>"></span></div>
		                            <!-- section subtitle end -->
		                            <!-- divider start -->
		                            <div class="divider-m"></div>
		                            <!-- divider end -->
		                        </div>
		                        <!-- col end -->
		                        <?php } ?>
		                    </div>
		                    <!-- row end -->
                            <!-- row start -->
                            <div class="row">
                                <!-- col start -->
                                <div class="col-md-12">
                                    <!-- divider start -->
                                    <div class="divider-l"></div>
                                    <!-- divider end -->
                                    <!-- section txt start -->
                                    <p class="text">
                                        <?php if(isset($luxex_redux_demo['blog_excerpt'])){?>
						                <?php echo esc_attr(luxex_excerpt($luxex_redux_demo['blog_excerpt'])); ?>
						                <?php }else{?>
						                <?php echo esc_attr(luxex_excerpt(40)); 
						                ?> 
						            	<?php } ?>                                    
                                    </p>
                                    <!-- section txt end -->
                                </div>
                                <!-- col end -->
                            </div>
                            <!-- row end -->
                            <!-- row start -->
                            <div class="row">
                                <!-- col start -->
                                <div class="col-lg-12">
                                    <!-- divider start -->
                                    <div class="divider-l"></div>
                                    <!-- divider end -->
                                    <!-- line start -->
                                    <div class="the-line"></div>
                                    <!-- line end -->
                                    <!-- divider start -->
                                    <div class="divider-l"></div>
                                    <!-- divider end -->
                                </div>
                                <!-- col end -->
                            </div>
                            <!-- row end -->
                        </div>
                    </div>
                    <!-- container end -->
                    <!-- container start -->
                    <div class="container-fluid nopadding">
                        <!-- row start -->
                        <div class="row">
                            <!-- col start -->
                            <div class="col-lg-12">
                                <!-- item start -->
                                <div class="box-img">
                                    <!-- item IMG start -->
                                    <div class="img-fullwidth-all">
                                        <img alt="Img" src="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>">
                                    </div>
                                    <a class="popup-photo" href="<?php echo wp_get_attachment_url(get_post_thumbnail_id());?>" title="<?php echo wp_specialchars_decode(esc_attr($image_description)); ?>">
                                        <div class="image-caption"><?php echo wp_specialchars_decode(esc_attr($image_description)); ?></div>
                                    </a>
                                    <!-- item IMG end -->
                                </div>
                                <!-- item end -->
                            </div>
                            <!-- col end -->
                        </div>
                        <!-- row end -->
                        <!-- row start -->
                        <div class="row">
                            <!-- col start -->
                            <div class="col-md-12 col-sm-12">
                                <!-- divider start -->
                                <div class="divider-l"></div>
                                <!-- divider end -->
                                <!-- button start -->
                                <div class="more-wraper-center">
                                    <a href="<?php the_permalink(); ?>">
                                        <div class="more-button-bg-center more-button-bg-center-dark more-button-bg-center-dark-close more-button-circle"></div>
                                        <div class="more-button-txt-center more-button-txt-center-close">
                                            <span><?php if(isset($luxex_redux_demo['room_read_more'])){?>
						                            <?php echo wp_specialchars_decode(esc_attr($luxex_redux_demo['room_read_more']));?>
						                            <?php }else{?>
						                            <?php echo esc_html__( 'Details', 'luxex' );?>
						                        	<?php } ?></span>
                                        </div>
                                    </a>
                                </div>
                                <!-- button end -->
                            </div>
                            <!-- col end -->
                        </div>
                        <!-- row end -->
                    </div>
                    <!-- container end -->
                    <?php endwhile; ?>
                </div>
            </div>
            <!-- post content end -->
        </div>
        
	<?php
	}

}