<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsMenu extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-menu';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Menu', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Menu widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-nav-menu';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Menu widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'Menu' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_heading',
			[
				'label' => esc_html__( 'Menu', 'bdevs-elementor' ),
			]	
		);

		$this->add_control(
			'number',
			[
				'label'       => __( 'Number', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'		=> __('Number', 'bdevs-elementor'),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Subheading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'		=> __('Subheading', 'bdevs-elementor'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'		=> __('This is heading', 'bdevs-elementor'),
				'label_block' => true,
			]
		);	

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_title',
			[
				'label' => esc_html__( 'Menu Title', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Menu Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name'        => 'title',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);

		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_content_menu1',
			[
				'label' => esc_html__( 'Menu 1', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'tabs1',
			[
				'label' => esc_html__( 'Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name'    => 'tab_image_1',
						'label'   => esc_html__( 'Featured Image', 'bdevs-elementor' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
					],
					[
						'name'        => 'image_description_1',
						'label'       => esc_html__( 'Image Description', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Image Description' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'title_1',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'price_1',
						'label'       => esc_html__( 'Price', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Price' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'description_1',
						'label'       => esc_html__( 'Description', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Description' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_menu2',
			[
				'label' => esc_html__( 'Menu 2', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'tabs2',
			[
				'label' => esc_html__( 'Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name'    => 'tab_image_2',
						'label'   => esc_html__( 'Featured Image', 'bdevs-elementor' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
					],
					[
						'name'        => 'image_description_2',
						'label'       => esc_html__( 'Image Description', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Image Description' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'title_2',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'price_2',
						'label'       => esc_html__( 'Price', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Price' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'description_2',
						'label'       => esc_html__( 'Description', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Description' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_menu3',
			[
				'label' => esc_html__( 'Menu 3', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'tabs3',
			[
				'label' => esc_html__( 'Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name'    => 'tab_image_3',
						'label'   => esc_html__( 'Featured Image', 'bdevs-elementor' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
					],
					[
						'name'        => 'image_description_3',
						'label'       => esc_html__( 'Image Description', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Image Description' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'title_3',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'price_3',
						'label'       => esc_html__( 'Price', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Price' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'description_3',
						'label'       => esc_html__( 'Description', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Description' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_menu4',
			[
				'label' => esc_html__( 'Menu 4', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'tabs4',
			[
				'label' => esc_html__( 'Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name'    => 'tab_image_4',
						'label'   => esc_html__( 'Featured Image', 'bdevs-elementor' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
					],
					[
						'name'        => 'image_description_4',
						'label'       => esc_html__( 'Image Description', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Image Description' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'title_4',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'price_4',
						'label'       => esc_html__( 'Price', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Price' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'description_4',
						'label'       => esc_html__( 'Description', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Description' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_menu5',
			[
				'label' => esc_html__( 'Menu 5', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'tabs5',
			[
				'label' => esc_html__( 'Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name'    => 'tab_image_5',
						'label'   => esc_html__( 'Featured Image', 'bdevs-elementor' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
					],
					[
						'name'        => 'image_description_5',
						'label'       => esc_html__( 'Image Description', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Image Description' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'title_5',
						'label'       => esc_html__( 'Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'price_5',
						'label'       => esc_html__( 'Price', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Price' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'description_5',
						'label'       => esc_html__( 'Description', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Description' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);

		$this->end_controls_section();

		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_subheading',
			[
				'label'   => esc_html__( 'Show Subheading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings); ?>
		<div id="menu" class="section-all bg-light">
            <!-- container start -->
            <div class="container">
                <!-- row start -->
                <div class="row">
                    <!-- col start -->
                    <div class="col-lg-12">
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                        <!-- line start -->
                        <div class="the-line"></div>
                        <!-- line end -->
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                    </div>
                    <!-- col end -->
                </div>
                <!-- row end -->
                <!-- row start -->
                <div class="row">
                    <!-- col start -->
                    <div class="col-lg-12">
                        <?php if ( $settings['show_subheading'] ) : ?>
                        <!-- section title start -->
                        <h2 class="section-heading">
                            <span><?php print wp_kses_post($settings['number']); ?> </span> <?php print wp_kses_post($settings['subheading']); ?>
                        </h2>
                        <!-- section title end -->
                        <!-- divider start -->
                        <div class="divider-m"></div>
                        <!-- divider end -->
                    	<?php endif; ?>
                    	<?php if ( $settings['show_heading'] ) : ?>
                        <!-- section title start -->
                        <h2 class="hero-heading hero-heading-dark">
                            <?php print wp_kses_post($settings['heading']); ?>
                        </h2>
                        <!-- section title end -->
                        <?php endif; ?>
                    </div>
                    <!-- col end -->
                </div>
                <!-- row end -->
                <!-- row start -->
                <div class="row">
                    <!-- col start -->
                    <div class="col-lg-12">
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                        <!-- line start -->
                        <div class="the-line"></div>
                        <!-- line end -->
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                    </div>
                    <!-- col end -->
                </div>
                <!-- row end -->
            </div>
            <!-- container end -->
            <!-- container start -->
            <div class="container">
                <div class="extra-margin-container">
                    <!-- row start -->   
                    <div class="row">
                        <!-- col start -->
                        <div class="col-lg-12">
                            <!-- items selector start -->
                            <div class="owl-carousel owl-carousel-menu">
                            	<?php $i=0;
				                    foreach ( $settings['tabs'] as $item ) : 
				                    $i++;
								?>
                                <div class="item-selector">
                                    <a href="#" class="item-button" data-target="menu-<?php echo $i;  ?>"><?php print wp_kses_post($item['title']); ?></a>
                                </div>
                            	<?php endforeach; ?>
                            </div>
                            <!-- items selector end -->
                            <!-- divider start -->
                            <div class="divider-m"></div>
                            <!-- divider end -->
                            <!-- owl nav start -->
                            <div class="owl-nav owl-nav-custom-menu"></div>
                            <!-- owl nav end -->
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                            <!-- items group 1 start -->
                            <div class="menu menu-visible" id="menu-1">
                            	<?php 
				                    foreach ( $settings['tabs1'] as $item ) : 
								?>
                                <div class="item">
                                    <div class="item-wrapper">
                                        <!-- items img start -->
                                        <div class="menu-img">
                                            <div class="menu-img-inner">
                                                <a class="popup-photo" href="<?php echo wp_kses_post($item['tab_image_1']['url']); ?>" title="<?php print wp_kses_post($item['image_description_1']); ?>">
                                                <img src="<?php echo wp_kses_post($item['tab_image_1']['url']); ?>" alt="Img">
                                                </a>
                                            </div>
                                        </div>
                                        <!-- items img end -->
                                        <!-- section title start -->
                                        <h3 class="item-name"><?php print wp_kses_post($item['title_1']); ?></h3>
                                        <span class="item-divider"></span>
                                        <span class="item-price"><?php print wp_kses_post($item['price_1']); ?></span>

                                        <!-- section title end -->
                                    </div>
                                    <!-- divider start -->
                                    <div class="divider-m"></div>
                                    <!-- divider end -->
                                    <!-- section txt start -->
                                    <p class="item-description"><?php print wp_kses_post($item['description_1']); ?></p>
                                    <!-- section txt end -->
                                </div>
                            	<?php endforeach; ?>
                            </div>
                            <!-- items group 1 end -->
                            <!-- items group 2 start -->
                            <div class="menu" id="menu-2">
                                <?php 
				                    foreach ( $settings['tabs2'] as $item ) : 
								?>
                                <div class="item">
                                    <div class="item-wrapper">
                                        <!-- items img start -->
                                        <div class="menu-img">
                                            <div class="menu-img-inner">
                                                <a class="popup-photo" href="<?php echo wp_kses_post($item['tab_image_2']['url']); ?>" title="<?php print wp_kses_post($item['image_description_2']); ?>">
                                                <img src="<?php echo wp_kses_post($item['tab_image_2']['url']); ?>" alt="Img">
                                                </a>
                                            </div>
                                        </div>
                                        <!-- items img end -->
                                        <!-- section title start -->
                                        <h3 class="item-name"><?php print wp_kses_post($item['title_2']); ?></h3>
                                        <span class="item-divider"></span>
                                        <span class="item-price"><?php print wp_kses_post($item['price_2']); ?></span>

                                        <!-- section title end -->
                                    </div>
                                    <!-- divider start -->
                                    <div class="divider-m"></div>
                                    <!-- divider end -->
                                    <!-- section txt start -->
                                    <p class="item-description"><?php print wp_kses_post($item['description_2']); ?></p>
                                    <!-- section txt end -->
                                </div>
                            	<?php endforeach; ?>
                            </div>
                            <!-- items group 2 end -->
                            <!-- items group 3 start -->
                            <div class="menu" id="menu-3">
                                <?php 
				                    foreach ( $settings['tabs3'] as $item ) : 
								?>
                                <div class="item">
                                    <div class="item-wrapper">
                                        <!-- items img start -->
                                        <div class="menu-img">
                                            <div class="menu-img-inner">
                                                <a class="popup-photo" href="<?php echo wp_kses_post($item['tab_image_3']['url']); ?>" title="<?php print wp_kses_post($item['image_description_3']); ?>">
                                                <img src="<?php echo wp_kses_post($item['tab_image_3']['url']); ?>" alt="Img">
                                                </a>
                                            </div>
                                        </div>
                                        <!-- items img end -->
                                        <!-- section title start -->
                                        <h3 class="item-name"><?php print wp_kses_post($item['title_3']); ?></h3>
                                        <span class="item-divider"></span>
                                        <span class="item-price"><?php print wp_kses_post($item['price_3']); ?></span>

                                        <!-- section title end -->
                                    </div>
                                    <!-- divider start -->
                                    <div class="divider-m"></div>
                                    <!-- divider end -->
                                    <!-- section txt start -->
                                    <p class="item-description"><?php print wp_kses_post($item['description_3']); ?></p>
                                    <!-- section txt end -->
                                </div>
                            	<?php endforeach; ?>
                            </div>
                            <!-- items group 3 end -->
                            <!-- items group 4 start -->
                            <div class="menu" id="menu-4">
                                <?php 
				                    foreach ( $settings['tabs4'] as $item ) : 
								?>
                                <div class="item">
                                    <div class="item-wrapper">
                                        <!-- items img start -->
                                        <div class="menu-img">
                                            <div class="menu-img-inner">
                                                <a class="popup-photo" href="<?php echo wp_kses_post($item['tab_image_4']['url']); ?>" title="<?php print wp_kses_post($item['image_description_4']); ?>">
                                                <img src="<?php echo wp_kses_post($item['tab_image_4']['url']); ?>" alt="Img">
                                                </a>
                                            </div>
                                        </div>
                                        <!-- items img end -->
                                        <!-- section title start -->
                                        <h3 class="item-name"><?php print wp_kses_post($item['title_4']); ?></h3>
                                        <span class="item-divider"></span>
                                        <span class="item-price"><?php print wp_kses_post($item['price_4']); ?></span>

                                        <!-- section title end -->
                                    </div>
                                    <!-- divider start -->
                                    <div class="divider-m"></div>
                                    <!-- divider end -->
                                    <!-- section txt start -->
                                    <p class="item-description"><?php print wp_kses_post($item['description_4']); ?></p>
                                    <!-- section txt end -->
                                </div>
                            	<?php endforeach; ?>
                            </div>
                            <!-- items group 4 end -->
                            <!-- items group 5 start -->
                            <div class="menu" id="menu-5">
                                <?php 
				                    foreach ( $settings['tabs5'] as $item ) : 
								?>
                                <div class="item">
                                    <div class="item-wrapper">
                                        <!-- items img start -->
                                        <div class="menu-img">
                                            <div class="menu-img-inner">
                                                <a class="popup-photo" href="<?php echo wp_kses_post($item['tab_image_5']['url']); ?>" title="<?php print wp_kses_post($item['image_description_5']); ?>">
                                                <img src="<?php echo wp_kses_post($item['tab_image_5']['url']); ?>" alt="Img">
                                                </a>
                                            </div>
                                        </div>
                                        <!-- items img end -->
                                        <!-- section title start -->
                                        <h3 class="item-name"><?php print wp_kses_post($item['title_5']); ?></h3>
                                        <span class="item-divider"></span>
                                        <span class="item-price"><?php print wp_kses_post($item['price_5']); ?></span>

                                        <!-- section title end -->
                                    </div>
                                    <!-- divider start -->
                                    <div class="divider-m"></div>
                                    <!-- divider end -->
                                    <!-- section txt start -->
                                    <p class="item-description"><?php print wp_kses_post($item['description_5']); ?></p>
                                    <!-- section txt end -->
                                </div>
                            	<?php endforeach; ?>
                            </div>
                            <!-- items group 5 end -->
                        </div>
                        <!-- col end -->
                    </div>
                    <!-- row end -->
                    <!-- row start -->
                    <div class="row">
                        <!-- col start -->
                        <div class="col-lg-12">
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                            <!-- line start -->
                            <div class="the-line"></div>
                            <!-- line end -->
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                        </div>
                        <!-- col end -->
                    </div>
                    <!-- row end -->
                </div>
            </div>
            <!-- container end -->
        </div>
	<?php
	}

}