<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsGallery extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-Gallery';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Gallery', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Gallery widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-gallery-grid';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Gallery widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'Gallery' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_heading',
			[
				'label' => esc_html__( 'Gallery', 'bdevs-elementor' ),
			]	
		);

		$this->add_control(
			'number',
			[
				'label'       => __( 'Number', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'		=> __('Number', 'bdevs-elementor'),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Subheading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'		=> __('Subheading', 'bdevs-elementor'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'		=> __('This is heading', 'bdevs-elementor'),
				'label_block' => true,
			]
		);	

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_image',
			[
				'label' => esc_html__( 'Gallery Items', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name'    => 'tab_image',
						'label'   => esc_html__( 'Image', 'bdevs-elementor' ),
						'type'    => Controls_Manager::MEDIA,
						'dynamic' => [ 'active' => true ],
					],
					[
						'name'        => 'image_description',
						'label'       => esc_html__( 'Image Description', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Image Description' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);

		$this->end_controls_section();

		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_subheading',
			[
				'label'   => esc_html__( 'Show Subheading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);	

		$this->add_control(
			'show_all',
			[
				'label'   => esc_html__( 'Show Heading and Subheading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings); ?>
		<?php if ( $settings['show_all'] ) : ?>
		<div id="gallery" class="section-all bg-dark">
            <!-- container start -->
            <div class="container">
                <div class="extra-margin-container">
                    <!-- row start -->
                    <div class="row">
                        <!-- col start -->
                        <div class="col-lg-12">
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                            <!-- line start -->
                            <div class="the-line"></div>
                            <!-- line end -->
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                        </div>
                        <!-- col end -->
                    </div>
                    <!-- row end -->
                    <!-- row start -->
                    <div class="row">
                        <!-- col start -->
                        <div class="col-lg-12">
                            <?php if ( $settings['show_subheading'] ) : ?>
	                        <!-- section title start -->
	                        <h2 class="section-heading">
	                            <span><?php print wp_kses_post($settings['number']); ?> </span> <?php print wp_kses_post($settings['subheading']); ?>
	                        </h2>
	                        <!-- section title end -->
	                        <!-- divider start -->
	                        <div class="divider-m"></div>
	                        <!-- divider end -->
	                    	<?php endif; ?>
	                    	<?php if ( $settings['show_heading'] ) : ?>
	                        <!-- section title start -->
	                        <h2 class="hero-heading hero-heading-dark">
	                            <?php print wp_kses_post($settings['heading']); ?>
	                        </h2>
	                        <!-- section title end -->
	                        <?php endif; ?>
                        </div>
                        <!-- col end -->
                    </div>
                    <!-- row end -->
                    <!-- row start -->
                    <div class="row">
                        <!-- col start -->
                        <div class="col-lg-12">
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                            <!-- line start -->
                            <div class="the-line"></div>
                            <!-- line end -->
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                        </div>
                        <!-- col end -->
                    </div>
                    <!-- row end -->
                </div>
            </div>
            <!-- container end -->
        </div>
        <!-- gallery end -->
        <?php endif; ?>
        <!-- gallery IMG start -->
        <div id="gallery-img" class="bg-light">
            <!-- divider start -->
            <div class="divider-m-2"></div>
            <!-- divider end -->
            <!-- container start -->
            <div class="container-fluid">
                <!-- row start -->
                <div class="row">
                    <!-- photoSwipe start -->
                    <div class="legendary-gallery">
                    	<?php 
		                    foreach ( $settings['tabs'] as $item ) : 
						?>
                        <!-- gallery item start -->
                        <figure class="col-sm-12 col-md-4 hover-effect-img move-down">
                            <a data-size="1280x913" href="<?php echo wp_kses_post($item['tab_image']['url']); ?>"><img alt="Image description" class="img-responsive" src="<?php echo wp_kses_post($item['tab_image']['url']); ?>"></a>
                            <figcaption>
                                <span class="img-caption"><?php print wp_kses_post($item['image_description']); ?></span>
                                <div class="hover-effect"></div>
                                <div class="hover-icons">
                                    <a class="ion-plus" href="#"></a>
                                </div>
                            </figcaption>
                        </figure>
                        <!-- gallery item end -->
                    	<?php endforeach; ?>
                    </div>
                    <!-- photoSwipe end -->
                </div>
                <!-- row end -->
            </div>
            <!-- container end -->
        </div>
        <!-- gallery IMG end -->
	<?php
	}

}