<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsForm extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-form';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Form', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Form widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-form-horizontal';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Form widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'form' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_heading',
			[
				'label' => esc_html__( 'Form', 'bdevs-elementor' ),
			]	
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Select Style', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'style_1'  => esc_html__( 'Style 1', 'bdevs-elementor' ),
					'style_2' => esc_html__( 'Style 2', 'bdevs-elementor' ),
				],
				'default'   => 'style_1',
			]
		);

		$this->add_control(
			'shortcode',
			[
				'label'   => esc_html__( 'Contact Form', 'bdevs-elementor' ),
				'type'    => Controls_Manager::TEXTAREA,
				'dynamic' => [ 'active' => true ],
				'default'		=> __('Contact Form', 'bdevs-elementor'),
				'description' => esc_html__( 'Add your contact form here', 'bdevs-elementor' ),
				'label_block' => true,
			]
		);

		$this->end_controls_section();

		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings);
		?>
		<?php if( $chose_style == 'style_1' ): ?>
		<!-- separator start -->
        <div class="section-all bg-dark" id="reservation-form-wrapper">
            <!-- container start -->
            <div class="container-fluid nopadding nopadding-xs">
                <div class="extra-margin-container">
                    <!-- row start -->
                    <div class="row">
                        <!-- col start -->
                        <div class="col-lg-12">
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                            <!-- line start -->
                            <div class="the-line"></div>
                            <!-- line end -->
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                            <!-- divider start -->
                            <div class="divider-l visible-mobile-devices-2"></div>
                            <!-- divider end -->
                        </div>
                        <!-- col end -->
                    </div>
                    <!-- row end -->
                </div>
            </div>
            <!-- container end -->
        </div>
        <!-- separator end -->
        <!-- reservation form wrapper start -->
        <div class="reservation-form-wrapper">
            <!-- reservation form start -->
            <div class="reservation-wrapper">
                <!-- container start -->
                <div class="container">
                    <div class="extra-margin-container">
                        <div class="reservation-inner clearfix">
                            <?php print do_shortcode(html_entity_decode( $settings['shortcode'] )); ?>
                        </div>
                    </div>
                </div>
                <!-- container end -->
            </div>
            <!-- reservation form end -->
        </div>
        <!-- reservation form wrapper end -->
        <?php elseif( $chose_style == 'style_2' ): ?>
        <!-- separator start -->
        <div class="section-all bg-dark" id="reservation-form-wrapper">
            <!-- container start -->
            <div class="container-fluid nopadding nopadding-xs">
                <div class="extra-margin-container">
                    <!-- row start -->
                    <div class="row">
                        <!-- col start -->
                        <div class="col-lg-12">
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                            <!-- line start -->
                            <div class="the-line"></div>
                            <!-- line end -->
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                            <!-- divider start -->
                            <div class="divider-l visible-mobile-devices-2"></div>
                            <!-- divider end -->
                        </div>
                        <!-- col end -->
                    </div>
                    <!-- row end -->
                </div>
            </div>
            <!-- container end -->
        </div>
        <!-- separator end -->
        <!-- reservation form wrapper start -->
        <div class="reservation-form-wrapper">
            <!-- reservation form start -->
            <div class="reservation-wrapper">
                <!-- container start -->
                <div class="container">
                    <div class="extra-margin-container">
                        <div class="reservation-inner clearfix">
                            <?php print do_shortcode(html_entity_decode( $settings['shortcode'] )); ?>
                        </div>
                    </div>
                </div>
                <!-- container end -->
            </div>
            <!-- reservation form end -->
        </div>
        <!-- reservation form wrapper end -->
        <div class="section-all bg-dark">
            <!-- container start -->
            <div class="container-fluid nopadding nopadding-xs">
                <div class="extra-margin-container">
                    <!-- row start -->
                    <div class="row">
                        <!-- col start -->
                        <div class="col-lg-12">
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                            <!-- line start -->
                            <div class="the-line"></div>
                            <!-- line end -->
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                        </div>
                        <!-- col end -->
                    </div>
                    <!-- row end -->
                </div>
            </div>
            <!-- container end -->
        </div>
        <?php endif; ?>
	<?php
	}

}