<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsContact extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-contact';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Contact', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs Contact widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-headphones';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs Contact widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'contact', 'carousel' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_heading',
			[
				'label' => esc_html__( 'Contact', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Select Style', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'style_1'  => esc_html__( 'Video', 'bdevs-elementor' ),
					'style_2' => esc_html__( 'Contact Form', 'bdevs-elementor' ),
				],
				'default'   => 'style_1',
			]
		);

		$this->add_control(
			'video',
			[
				'label'       => __( 'Link Background Video (mp4)', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'		=> __('#', 'bdevs-elementor'),
				'label_block' => true,
				'condition' => [
                    'chose_style' => ['style_1']
                ],
			]
		);

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'		=> __('Heading', 'bdevs-elementor'),
				'label_block' => true,
				'condition' => [
                    'chose_style' => ['style_1']
                ],
			]
		);	

		$this->add_control(
			'button',
			[
				'label'       => __( 'Button', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'		=> __('Button', 'bdevs-elementor'),
				'label_block' => true,
				'condition' => [
                    'chose_style' => ['style_2']
                ],
			]
		);	

		$this->add_control(
			'form_title',
			[
				'label'       => __( 'Form Title', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'		=> __('Form Title', 'bdevs-elementor'),
				'label_block' => true,
				'condition' => [
                    'chose_style' => ['style_2']
                ],
			]
		);	

		$this->add_control(
			'shortcode',
			[
				'label'   => esc_html__( 'Contact Form', 'bdevs-elementor' ),
				'type'    => Controls_Manager::TEXTAREA,
				'dynamic' => [ 'active' => true ],
				'default'		=> __('Contact Form', 'bdevs-elementor'),
				'description' => esc_html__( 'Add your contact form here', 'bdevs-elementor' ),
				'label_block' => true,
				'condition' => [
                    'chose_style' => ['style_2']
                ],
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_contact',
			[
				'label' => esc_html__( 'Contact Info', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => esc_html__( 'Items', 'bdevs-elementor' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => [
					[
						'name'        => 'contact_title',
						'label'       => esc_html__( 'Contact Title', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXT,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Contact Title' , 'bdevs-elementor' ),
						'label_block' => true,
					],
					[
						'name'        => 'contact_info',
						'label'       => esc_html__( 'Contact Info', 'bdevs-elementor' ),
						'type'        => Controls_Manager::TEXTAREA,
						'dynamic'     => [ 'active' => true ],
						'default'     => esc_html__( 'Contact Info' , 'bdevs-elementor' ),
						'label_block' => true,
					],
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->end_controls_section();

	}

	public function render() {

		$settings  = $this->get_settings_for_display();
		extract($settings);
		?>
		<?php if( $chose_style == 'style_1' ): ?>
		<div id="contact" class="section-all bg-light">
            <!-- container start -->
            <div class="container-fluid">
                <!-- row start -->
                <div class="row">
                    <!-- col start -->
                    <div class="col-lg-12">
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                        <!-- line start -->
                        <div class="the-line"></div>
                        <!-- line end -->
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                    </div>
                    <!-- col end -->
                </div>
                <!-- row end -->
            </div>
            <!-- container end -->
            <!-- container start -->
            <div class="container">
                <!-- row start -->
                <div class="row">
                    <div class="post-spacing-3">
                        <?php 
		                    foreach ( $settings['tabs'] as $item ) : 
						?>
                        <!-- col start -->
                        <div class="col-md-4 col-sm-12">
                            <!-- section subtitle start -->
                            <div class="blog-tag"><?php print wp_kses_post($item['contact_title']); ?></div>
                            <!-- section subtitle end -->
                            <!-- divider start -->
                            <div class="divider-m"></div>
                            <!-- divider end -->
                            <!-- section TXT start -->
                            <div class="section-txt-2">
                                <p><?php print wp_kses_post($item['contact_info']); ?></p>
                            </div>
                            <!-- section TXT end -->
                            <!-- divider start -->
                            <div class="divider-l visible-mobile-devices"></div>
                            <!-- divider end -->
                        </div>
                        <!-- col end -->
                    	<?php endforeach; ?>
                    </div>
                </div>
                <!-- row end -->
            </div>
            <!-- container end -->
        </div>
        <!-- contact end -->
        <!-- container start -->
        <div class="container-fluid">
            <!-- row start -->
            <div class="row">
                <!-- col start -->
                <div class="col-lg-12">
                    <!-- divider start -->
                    <div class="divider-l"></div>
                    <!-- divider end -->
                    <!-- line start -->
                    <div class="the-line"></div>
                    <!-- line end -->
                    <!-- divider start -->
                    <div class="divider-l"></div>
                    <!-- divider end -->
                </div>
                <!-- col end -->
            </div>
            <!-- row end -->
            <!-- row start -->
            <div class="row">
                <!-- col start -->
                <div class="col-lg-12">
                    <!-- parallax wrapper start -->
                    <div class="parallax-title">
                        <!-- HTML5 video URL start -->
                        <video playsinline autoplay muted loop>
                            <source src="<?php print wp_kses_post($settings['video']); ?>" type="video/mp4">
                        </video>
                        <!-- HTML5 video URL end -->
                        <!-- page title start -->
                        <div class="parallax-title-content">
                            <?php print wp_kses_post($settings['heading']); ?>
                        </div>
                        <!-- page title end -->
                    </div>
                    <!-- parallax wrapper end -->
                </div>
                <!-- col end -->
            </div>
            <!-- row end -->
        </div>
        <!-- container end -->
        <?php elseif( $chose_style == 'style_2' ): ?>
        <div id="contact" class="section-all bg-light">
            <!-- container start -->
            <div class="container-fluid">
                <!-- row start -->
                <div class="row">
                    <!-- col start -->
                    <div class="col-lg-12">
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                        <!-- line start -->
                        <div class="the-line"></div>
                        <!-- line end -->
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                    </div>
                    <!-- col end -->
                </div>
                <!-- row end -->
            </div>
            <!-- container end -->
            <!-- container start -->
            <div class="container">
                <!-- row start -->
                <div class="row">
                    <div class="post-spacing-3">
                        <?php 
		                    foreach ( $settings['tabs'] as $item ) : 
						?>
                        <!-- col start -->
                        <div class="col-md-4 col-sm-12">
                            <!-- section subtitle start -->
                            <div class="blog-tag"><?php print wp_kses_post($item['contact_title']); ?></div>
                            <!-- section subtitle end -->
                            <!-- divider start -->
                            <div class="divider-m"></div>
                            <!-- divider end -->
                            <!-- section TXT start -->
                            <div class="section-txt-2">
                                <p><?php print wp_kses_post($item['contact_info']); ?></p>
                            </div>
                            <!-- section TXT end -->
                            <!-- divider start -->
                            <div class="divider-l visible-mobile-devices"></div>
                            <!-- divider end -->
                        </div>
                        <!-- col end -->
                    	<?php endforeach; ?>
                    </div>
                </div>
                <!-- row end -->
                <!-- row start -->
                <div class="row" id="use-the-form">
                    <!-- col start -->
                    <div class="col-lg-12">
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                        <!-- line start -->
                        <div class="the-line"></div>
                        <!-- line end -->
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                    </div>
                    <!-- col end -->
                </div>
                <!-- row end -->
                <!-- button start -->
                <div class="more-wraper-center contact-modal-launcher">
                    <div class="more-button-bg-center more-button-bg-center-dark more-button-bg-center-dark-close more-button-circle">
                    </div>
                    <div class="more-button-txt-center more-button-txt-center-close">
                        <span><?php print wp_kses_post($settings['button']); ?></span>
                    </div>
                </div>
                <!-- button end -->
            </div>
            <!-- container end -->
        </div>
        <div class="contact-modal">
            <!-- container start -->
            <div class="container">
                <!-- center container start -->
                <div class="center-container-contact-modal">
                    <!-- center block start -->
                    <div class="center-block-contact-modal">
                        <!-- row start -->
                        <div class="row center-block-contact-modal-padding-top">
                            <!-- col start -->
                            <div class="col-lg-12">
                                <!-- section title start -->
                                <h2 class="hero-heading hero-heading-dark">
                                    <?php print wp_kses_post($settings['form_title']); ?>
                                </h2>
                                <!-- section title end -->
                                <!-- divider start -->
                                <div class="divider-l"></div>
                                <!-- divider end -->
                            </div>
                            <!-- col end -->
                        </div>
                        <!-- row end -->
                        <!-- row start -->
                        <div class="row contact-modal-wrapper">
                            <!-- col start -->
                            <div>
                                <!-- contact form start -->
                                <div id="contact-form">
                                    <?php print do_shortcode(html_entity_decode( $settings['shortcode'] )); ?>
                                </div>
                                <!-- contact form end -->
                            </div>
                            <!-- col end -->
                        </div>
                        <!-- row end -->
                        <!-- divider start -->
                        <div class="divider-l"></div>
                        <!-- divider end -->
                        <!-- row start -->
                        <div class="row center-block-contact-modal-padding-bottom">
                            <div class="col-lg-12">
                                <!-- contact modal closer start -->
                                <div class="contact-modal-closer">
                                    <span class="ion-close"></span>
                                </div>
                                <!-- contact modal closer end -->
                            </div>
                        </div>
                        <!-- row end -->
                    </div>
                    <!-- center block end -->
                </div>
                <!-- center container end -->
            </div>
            <!-- container end -->
        </div>
        <?php endif; ?>
	<?php
	}

}