<?php
namespace BdevsElementor\Widget;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

/**
 * Bdevs Elementor Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
class BdevsAbout extends \Elementor\Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Bdevs Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'bdevs-about';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Bdevs Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'About', 'bdevs-elementor' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Bdevs About widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-favorite';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Bdevs About widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'bdevs-elementor' ];
	}

	public function get_keywords() {
		return [ 'about' ];
	}

	public function get_script_depends() {
		return [ 'bdevs-elementor'];
	}

	// BDT Position
	protected function element_pack_position() {
	    $position_options = [
	        ''              => esc_html__('Default', 'bdevs-elementor'),
	        'top-left'      => esc_html__('Top Left', 'bdevs-elementor') ,
	        'top-center'    => esc_html__('Top Center', 'bdevs-elementor') ,
	        'top-right'     => esc_html__('Top Right', 'bdevs-elementor') ,
	        'center'        => esc_html__('Center', 'bdevs-elementor') ,
	        'center-left'   => esc_html__('Center Left', 'bdevs-elementor') ,
	        'center-right'  => esc_html__('Center Right', 'bdevs-elementor') ,
	        'bottom-left'   => esc_html__('Bottom Left', 'bdevs-elementor') ,
	        'bottom-center' => esc_html__('Bottom Center', 'bdevs-elementor') ,
	        'bottom-right'  => esc_html__('Bottom Right', 'bdevs-elementor') ,
	    ];

	    return $position_options;
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_content_heading',
			[
				'label' => esc_html__( 'About', 'bdevs-elementor' ),
			]	
		);

		$this->add_control(
			'chose_style',
			[
				'label'     => esc_html__( 'Select Style', 'bdevs-elementor' ),
				'type'      => Controls_Manager::SELECT,
				'options'   => [
					'style_1'  => esc_html__( 'Right Image', 'bdevs-elementor' ),
					'style_2' => esc_html__( 'Left Image', 'bdevs-elementor' ),
				],
				'default'   => 'style_1',
			]
		);

		$this->add_control(
			'background_bg',
			[
				'label'   => esc_html__( 'Featured Image', 'bdevs-elementor' ),
				'type'    => Controls_Manager::MEDIA,
				'dynamic' => [ 'active' => true ],
				'description' => esc_html__( 'Add image from here', 'bdevs-elementor' ),
			]
		);

		$this->add_control(
			'number',
			[
				'label'       => __( 'Number', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'		=> __('Number', 'bdevs-elementor'),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'subheading',
			[
				'label'       => __( 'Subheading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'		=> __('This is subheading', 'bdevs-elementor'),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'heading',
			[
				'label'       => __( 'Heading', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'		=> __('This is heading', 'bdevs-elementor'),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'content',
			[
				'label'       => __( 'Content', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'		=> __('This is content', 'bdevs-elementor'),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'phone_title',
			[
				'label'       => __( 'Phone Title', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'		=> __('Phone Title', 'bdevs-elementor'),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'phone',
			[
				'label'       => __( 'Phone', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'		=> __('+1234567890', 'bdevs-elementor'),
				'label_block' => true,
			]
		);	

		$this->add_control(
			'link_phone',
			[
				'label'       => __( 'Link Phone', 'bdevs-elementor' ),
				'type'        => Controls_Manager::TEXT,
				'default'		=> __('tel:1234567890', 'bdevs-elementor'),
				'label_block' => true,
			]
		);	

		$this->end_controls_section();

		/** 
		*	Layout section 
		**/
		$this->start_controls_section(
			'section_content_layout',
			[
				'label' => esc_html__( 'Layout', 'bdevs-elementor' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label'   => esc_html__( 'Alignment', 'bdevs-elementor' ),
				'type'    => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'bdevs-elementor' ),
						'icon'  => 'fa fa-align-justify',
					],
				],
				'prefix_class' => 'elementor%s-align-',
				'description'  => 'Use align to match position',
				'default'      => 'left',
			]
		);

		$this->add_control(
			'show_subheading',
			[
				'label'   => esc_html__( 'Show Subheading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'   => esc_html__( 'Show Heading', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_content',
			[
				'label'   => esc_html__( 'Show Content', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_phone',
			[
				'label'   => esc_html__( 'Show Phone', 'bdevs-elementor' ),
				'type'    => Controls_Manager::SWITCHER,
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

	}

	public function render() {
		$settings  = $this->get_settings_for_display();
		extract($settings); ?>
		<?php if( $chose_style == 'style_1' ): ?>
		<div id="about" class="section-all bg-dark">
            <!-- container start -->
            <div class="container-fluid nopadding nopadding-xs">
                <div class="extra-margin-container">
                    <!-- row start -->
                    <div class="row">
                        <!-- col start -->
                        <div class="col-lg-12">
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                            <!-- line start -->
                            <div class="the-line"></div>
                            <!-- line end -->
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                        </div>
                        <!-- col end -->
                    </div>
                    <!-- row end -->
                    <!-- row start -->
                    <div class="row">
                        <!-- col start -->
                        <div class="col-lg-12">
                            <div class="post-list">
                                <div class="post-list-content-wrapper">
                                    <div class="post-list-wrapper">
                                        <!-- section item start -->
                                        <div class="post-list-item">
                                            <div class="container-custom post-list-item-container">
                                                <div class="row post-list-row">
                                                    <div class="col-lg-4-custom col-md-6-custom offset-lg-1-custom">
                                                        <div class="post-list-content post-list-content-reverse">
                                                            <!-- row start -->
                                                            <div class="row">
                                                                <!-- col start -->
                                                                <div class="col-md-12">
                                                                    <!-- divider start -->
                                                                    <div class="divider-l visible-mobile-devices"></div>
                                                                    <!-- divider end -->
                                                                    <?php if ( $settings['show_subheading'] ) : ?>
                                                                    <!-- section title start -->
                                                                    <h2 class="section-heading">
                                                                        <span><?php print wp_kses_post($settings['number']); ?> </span> <?php print wp_kses_post($settings['subheading']); ?>
                                                                    </h2>
                                                                    <!-- section title end -->
                                                                    <!-- divider start -->
                                                                    <div class="divider-m"></div>
                                                                    <!-- divider end -->
                                                                	<?php endif; ?>
                                                                    <?php if ( $settings['show_heading'] ) : ?>
                                                                    <!-- section title start -->
                                                                    <h2 class="hero-heading hero-heading-dark">
                                                                        <?php print wp_kses_post($settings['heading']); ?>
                                                                    </h2>
                                                                    <!-- section title end -->
                                                                    <!-- divider start -->
                                                                    <div class="divider-l"></div>
                                                                    <!-- divider end -->
                                                                	<?php endif; ?>
                                                                    <?php if ( $settings['show_content'] ) : ?>
                                                                    <!-- section txt start -->
                                                                    <div class="section-txt">
                                                                        <p>
                                                                            <?php print wp_kses_post($settings['content']); ?>
                                                                        </p>
                                                                    </div>
                                                                    <!-- section txt end -->
                                                                    <!-- divider start -->
                                                                    <div class="divider-l"></div>
                                                                    <!-- divider end -->     
                                                                    <?php endif; ?> 
                                                                    <?php if ( $settings['show_phone'] ) : ?>
                                                                    <!-- section txt start -->
                                                                    <div class="blog-tag blog-tag-rooms"><?php print wp_kses_post($settings['phone_title']); ?> <span class="ion-ios-telephone"></span></div>
                                                                    <!-- divider start -->
                                                                    <div class="divider-s"></div>
                                                                    <!-- divider end --> 
                                                                    <p><a class="link-effect" href="<?php print wp_kses_post($settings['link_phone']); ?>"><?php print wp_kses_post($settings['phone']); ?></a></p>
                                                                    <!-- section txt end -->
                                                                    <!-- divider start -->
                                                                    <div class="divider-l visible-mobile-devices"></div>
                                                                    <!-- divider end -->
                                                                	<?php endif; ?>
                                                                </div>
                                                                <!-- col end -->
                                                            </div>
                                                            <!-- row end -->
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- section img start -->
                                            <div class="post-list-bg post-list-bg-reverse post-list-bg-all about-bg-1" style="background-image: url(<?php echo wp_kses_post($settings['background_bg']['url']); ?>);"></div>
                                            <!-- section img end -->
                                        </div>
                                        <!-- section item end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- col end -->
                    </div>
                    <!-- row end -->
                    <!-- row start -->
                    <div class="row">
                        <!-- col start -->
                        <div class="col-lg-12">
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                            <!-- line start -->
                            <div class="the-line"></div>
                            <!-- line end -->
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                        </div>
                        <!-- col end -->
                    </div>
                    <!-- row end -->
                </div>
            </div>
            <!-- container end -->
        </div>
        <!-- about end -->
        <?php elseif( $chose_style == 'style_2' ): ?>
        <div id="about" class="section-all bg-dark">
            <!-- container start -->
            <div class="container-fluid nopadding nopadding-xs">
                <div class="extra-margin-container">
                    <!-- row start -->
                    <div class="row">
                        <!-- col start -->
                        <div class="col-lg-12">
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                            <!-- line start -->
                            <div class="the-line"></div>
                            <!-- line end -->
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                        </div>
                        <!-- col end -->
                    </div>
                    <!-- row end -->
                    <!-- row start -->
                    <div class="row">
                        <!-- col start -->
                        <div class="col-lg-12">
                            <div class="post-list">
                                <div class="post-list-content-wrapper">
                                    <div class="post-list-wrapper">
                                        <!-- section item start -->
                                        <div class="post-list-item">
                                            <div class="container-custom post-list-item-container">
                                                <div class="row post-list-row">
                                                    <div class="col-lg-4-custom col-md-6-custom offset-lg-7-custom">
                                                        <div class="post-list-content">
                                                            <!-- row start -->
                                                            <div class="row">
                                                                <!-- col start -->
                                                                <div class="col-md-12">
                                                                	<!-- divider start -->
                                                                    <div class="divider-l visible-mobile-devices"></div>
                                                                    <!-- divider end -->
                                                                    <?php if ( $settings['show_subheading'] ) : ?>
                                                                    <!-- section title start -->
                                                                    <h2 class="section-heading">
                                                                        <span><?php print wp_kses_post($settings['number']); ?> </span> <?php print wp_kses_post($settings['subheading']); ?>
                                                                    </h2>
                                                                    <!-- section title end -->
                                                                    <!-- divider start -->
                                                                    <div class="divider-m"></div>
                                                                    <!-- divider end -->
                                                                	<?php endif; ?>
                                                                    <?php if ( $settings['show_heading'] ) : ?>
                                                                    <!-- section title start -->
                                                                    <h2 class="hero-heading hero-heading-dark">
                                                                        <?php print wp_kses_post($settings['heading']); ?>
                                                                    </h2>
                                                                    <!-- section title end -->
                                                                    <!-- divider start -->
                                                                    <div class="divider-l"></div>
                                                                    <!-- divider end -->
                                                                	<?php endif; ?>
                                                                    <?php if ( $settings['show_content'] ) : ?>
                                                                    <!-- section txt start -->
                                                                    <div class="section-txt">
                                                                        <p>
                                                                            <?php print wp_kses_post($settings['content']); ?>
                                                                        </p>
                                                                    </div>
                                                                    <!-- section txt end -->
                                                                    <!-- divider start -->
                                                                    <div class="divider-l"></div>
                                                                    <!-- divider end -->     
                                                                    <?php endif; ?> 
                                                                    <?php if ( $settings['show_phone'] ) : ?>
                                                                    <!-- section txt start -->
                                                                    <div class="blog-tag blog-tag-rooms"><?php print wp_kses_post($settings['phone_title']); ?> <span class="ion-ios-telephone"></span></div>
                                                                    <!-- divider start -->
                                                                    <div class="divider-s"></div>
                                                                    <!-- divider end --> 
                                                                    <p><a class="link-effect" href="<?php print wp_kses_post($settings['link_phone']); ?>"><?php print wp_kses_post($settings['phone']); ?></a></p>
                                                                    <!-- section txt end -->
                                                                    <!-- divider start -->
                                                                    <div class="divider-l visible-mobile-devices"></div>
                                                                    <!-- divider end -->
                                                                	<?php endif; ?>
                                                                </div>
                                                                <!-- col end -->
                                                            </div>
                                                            <!-- row end -->
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- section img start -->
                                            <div class="post-list-bg facilities-bg-1" style="background-image: url(<?php echo wp_kses_post($settings['background_bg']['url']); ?>);"></div>
                                            <!-- section img end -->
                                        </div>
                                        <!-- section item end -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- col end -->
                    </div>
                    <!-- row end -->
                    <!-- row start -->
                    <div class="row">
                        <!-- col start -->
                        <div class="col-lg-12">
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                            <!-- line start -->
                            <div class="the-line"></div>
                            <!-- line end -->
                            <!-- divider start -->
                            <div class="divider-l"></div>
                            <!-- divider end -->
                        </div>
                        <!-- col end -->
                    </div>
                    <!-- row end -->
                </div>
            </div>
            <!-- container end -->
        </div>
        <!-- about end -->
        <?php endif; ?>
	<?php
	}

}