<?php
/**
 * Plugin Name: Meta Box
 * Plugin URI:  https://metabox.io
 * Description: Create custom meta boxes and custom fields in WordPress.
 * Version:     5.3.3
 * Author:      MetaBox.io
 * Author URI:  https://metabox.io
 * License:     GPL2+
 * Text Domain: meta-box
 * Domain Path: /languages/
 *
 * @package Meta Box
 */

if ( defined( 'ABSPATH' ) && ! defined( 'RWMB_VER' ) ) {
	register_activation_hook( __FILE__, 'rwmb_check_php_version' );

	/**
	 * Display notice for old PHP version.
	 */
	function rwmb_check_php_version() {
		if ( version_compare( phpversion(), '5.3', '<' ) ) {
			die( esc_html__( 'Meta Box requires PHP version 5.3+. Please contact your host to upgrade.', 'meta-box' ) );
		}
	}




	require_once dirname( __FILE__ ) . '/inc/loader.php';
	$rwmb_loader = new RWMB_Loader();
	$rwmb_loader->init();


	add_filter( 'rwmb_meta_boxes', function ( $meta_boxes ) {

	$prefix = '_cmb_';


  // Open Code

    $meta_boxes[] = array(

        'id'         => 'post_setting',

        'title'      => 'Post Setting',

        'pages'      => array('post'), // Post type

        'context'    => 'normal',

        'priority'   => 'high',

        'show_names' => true, // Show field names on the left

        //'show_on'    => array( 'key' => 'id', 'value' => array( 2, ), ), // Specific post IDs to display this metabox

        'fields' => array(

            array(
                'name' => 'Blog Single Button',
                'id'   => $prefix . 'button_blog',
                'type'    => 'text',
            ),

            array(
                'name' => 'Blog Single Button Link',
                'id'   => $prefix . 'link_button_blog',
                'type'    => 'textarea',
            ),

            array(
                'name' => 'Image Description',
                'id'   => $prefix . 'img_description',
                'type'    => 'text',
                'desc' => 'Show in blog page',
            ),

            array(
                'name' => 'Quote',
                'id'   => $prefix . 'quote',
                'type'    => 'textarea',
                'desc' => 'Show in blog page',
            ),
        )

    );

    $meta_boxes[] = array(

        'id'         => 'room_setting',

        'title'      => 'Room Setting',

        'pages'      => array('room'), // Post type

        'context'    => 'normal',

        'priority'   => 'high',

        'show_names' => true, // Show field names on the left

        //'show_on'    => array( 'key' => 'id', 'value' => array( 2, ), ), // Specific post IDs to display this metabox

        'fields' => array(

            array(
                'name' => 'Image Description',
                'id'   => $prefix . 'image_description',
                'type'    => 'text',
            ),

            array(
                'name' => 'Slider Button',
                'id'   => $prefix . 'button_1',
                'type'    => 'text',
            ),

            array(
                'name' => 'Slider Button Link',
                'id'   => $prefix . 'link_button_1',
                'type'    => 'text',
            ),

            array(
                'name' => 'Subtitle',
                'id'   => $prefix . 'subtitle',
                'type'    => 'text',
            ),

            array(
                'name' => 'Title',
                'id'   => $prefix . 'title',
                'type'    => 'text',
            ),

            array(
                'name' => 'Feature 1',
                'id'   => $prefix . 'feature_1',
                'type'    => 'text',
            ),

            array(
                'name' => 'Icon 1',
                'id'   => $prefix . 'icon_1',
                'type'    => 'text',
            ),

            array(
                'name' => 'Feature 2',
                'id'   => $prefix . 'feature_2',
                'type'    => 'text',
            ),
            
            array(
                'name' => 'Icon 2',
                'id'   => $prefix . 'icon_2',
                'type'    => 'text',
            ),

            array(
                'name' => 'Feature 3',
                'id'   => $prefix . 'feature_3',
                'type'    => 'text',
            ),
            
            array(
                'name' => 'Icon 3',
                'id'   => $prefix . 'icon_3',
                'type'    => 'text',
            ),

            array(
                'name' => 'Feature 4',
                'id'   => $prefix . 'feature_4',
                'type'    => 'text',
            ),
            
            array(
                'name' => 'Icon 4',
                'id'   => $prefix . 'icon_4',
                'type'    => 'text',
            ),

            array(
                'name' => 'Feature 5',
                'id'   => $prefix . 'feature_5',
                'type'    => 'text',
            ),
            
            array(
                'name' => 'Icon 5',
                'id'   => $prefix . 'icon_5',
                'type'    => 'text',
            ),

            array(
                'name' => 'Feature 6',
                'id'   => $prefix . 'feature_6',
                'type'    => 'text',
            ),
            
            array(
                'name' => 'Icon 6',
                'id'   => $prefix . 'icon_6',
                'type'    => 'text',
            ),

            array(
                'name' => 'Feature 7',
                'id'   => $prefix . 'feature_7',
                'type'    => 'text',
            ),
            
            array(
                'name' => 'Icon 7',
                'id'   => $prefix . 'icon_7',
                'type'    => 'text',
            ),

            array(
                'name' => 'Feature 8',
                'id'   => $prefix . 'feature_8',
                'type'    => 'text',
            ),
            
            array(
                'name' => 'Icon 8',
                'id'   => $prefix . 'icon_8',
                'type'    => 'text',
            ),

            array(
                'name' => 'Bottom Button',
                'id'   => $prefix . 'button_2',
                'type'    => 'text',
            ),

            array(
                'name' => 'Bottom Button Link',
                'id'   => $prefix . 'link_button_2',
                'type'    => 'text',
            ),
        )

    );

// End Code



    return $meta_boxes;
});
}