<?php

// register post type1 Room

add_action( 'init', 'register_luxex_Room' );

function register_luxex_Room() {

    

    $labels = array( 

        'name' => __( 'Room', 'luxex' ),

        'singular_name' => __( 'Room', 'luxex' ),

        'add_new' => __( 'Add New Room', 'luxex' ),

        'add_new_item' => __( 'Add New Room', 'luxex' ),

        'edit_item' => __( 'Edit Room', 'luxex' ),

        'new_item' => __( 'New Room', 'luxex' ),

        'view_item' => __( 'View Room', 'luxex' ),

        'search_items' => __( 'Search Room', 'luxex' ),

        'not_found' => __( 'No Room found', 'luxex' ),

        'not_found_in_trash' => __( 'No Room found in Trash', 'luxex' ),

        'parent_item_colon' => __( 'Parent Room:', 'luxex' ),

        'menu_name' => __( 'Room', 'luxex' ),

    );



    $args = array( 

        'labels' => $labels,

        'hierarchical' => true,

        'description' => 'List Room',

        'supports' => array( 'title', 'editor', 'thumbnail', 'comments'),

        'taxonomies' => array( 'Room', 'type1' ),

        'public' => true,

        'show_ui' => true,

        'show_in_menu' => true,

        'menu_position' => 5,

        'menu_icon' => 'dashicons-portfolio', 

        'show_in_nav_menus' => true,

        'publicly_queryable' => true,

        'exclude_from_search' => false,

        'has_archive' => true,

        'query_var' => true,

        'can_export' => true,

        'rewrite' => true,

        'capability_type' => 'post'

    );



    register_post_type( 'Room', $args );

}

add_action( 'init', 'create_type1_hierarchical_taxonomy', 0 );



//create a custom taxonomy name it Skillss for your posts



function create_type1_hierarchical_taxonomy() {



// Add new taxonomy, make it hierarchical like Skills

//first do the translations part for GUI



  $labels = array(

    'name' => __( 'Type', 'luxex' ),

    'singular_name' => __( 'Type', 'luxex' ),

    'search_items' =>  __( 'Search Type','luxex' ),

    'all_items' => __( 'All Type','luxex' ),

    'parent_item' => __( 'Parent Type','luxex' ),

    'parent_item_colon' => __( 'Parent Type:','luxex' ),

    'edit_item' => __( 'Edit Type','luxex' ), 

    'update_item' => __( 'Update Type','luxex' ),

    'add_new_item' => __( 'Add New Type','luxex' ),

    'new_item_name' => __( 'New Type Name','luxex' ),

    'menu_name' => __( 'Type','luxex' ),

  );     



// Now register the taxonomy



  register_taxonomy('type1',array('Room'), array(

    'hierarchical' => true,

    'labels' => $labels,

    'show_ui' => true,

    'show_admin_column' => true,

    'query_var' => true,

    'rewrite' => array( 'slug' => 'type1' ),

  ));



}


?>