<?php
/**
 * Mobile Header
 *
 * @package luxus
 */

// Options Logo
$brand_logo_opt = luxus_options('brand-logo');
$brand_logo_url = !$brand_logo_opt == null ? $brand_logo_opt['url'] : null;

$mob_brand_logo_opt = luxus_options('mob-brand-logo');
$mob_brand_logo_url = !$mob_brand_logo_opt == null ? $mob_brand_logo_opt['url'] : null;
$mobile_logo_url = !$mob_brand_logo_url == null ? $mob_brand_logo_url : $brand_logo_url;
$mobile_opt_logo = !$mobile_logo_url == null ? $mobile_logo_url : null;

// Page Logo
$brand_logo_meta = luxus_page_meta( '_page_logo' );
$brand_logo_meta_url = !$brand_logo_meta == null ? $brand_logo_meta['url'] : null;
$brand_page_logo = !$brand_logo_meta_url == null ? $brand_logo_meta_url : null;

// Mobile Logo Url
$mobile_logo = !$brand_page_logo == null ? $brand_page_logo : $mobile_opt_logo;

?>

<div class="container">
    <div class="row">
        <div class="mobile-menu">
            <nav class="stellarnav">
                <div class="mobile-brand">
                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                        <?php if (!$mobile_logo == null) : ?>
                            <img src="<?php echo esc_url( $mobile_logo ); ?>" alt="<?php esc_attr( bloginfo( 'name' ) ); ?>">
                        <?php else:
                            if ( function_exists( 'the_custom_logo' ) && has_custom_logo() ) {
								the_custom_logo();
							} else {
								echo '<h3>' . esc_html( get_bloginfo( 'name' ) ) . '</h3>';
							}
                        endif; ?>
                    </a>
                </div>
                <?php
                    wp_nav_menu( array(
                        'theme_location' => 'primary-menu',
                        'container'=>'',
                        'fallback_cb'    => false
                    ) );

                if( class_exists( 'CSF' ) ) :

                ?>
                    <div class="m-menu-right">
                        <?php
                            
                            if( is_user_logged_in() ):

                                $user = wp_get_current_user();

                                //GETTING PROFILE IMAGE OF USER
                                $user_meta_img_id = get_user_meta( $user->ID, 'profile_image_id', true );
                                $user_meta_img_url = !$user_meta_img_id == null ? wp_get_attachment_url( $user_meta_img_id ) : null;
                                $avatar_placeholder = esc_url(get_template_directory_uri()) . '/assets/images/luxus-avatar.png';
                                $luxus_user_avatar_url = !$user_meta_img_url == null ? $user_meta_img_url : $avatar_placeholder;

                             ?>
                                <div class="user-loged-in">
                                    <img src="<?php echo esc_url( $luxus_user_avatar_url ); ?>" class="user-pic" alt="<?php echo esc_attr( $user->display_name ); ?>">
                                    <div class="quick-links">
                                        <div class="user-name"><?php echo esc_html( $user->display_name ); ?></div>
                                        <ul>
                                        <?php if ( current_user_can('administrator') || current_user_can('editor') || current_user_can('author') || current_user_can('contributor') || current_user_can('subscriber') ) { ?>
                                            <li><a href="<?php echo esc_url(home_url('/wp-admin/')); ?>"><i class="fas fa-list"></i>Dashboard</a></li>
                                            <li><a href="<?php echo esc_url(home_url('/wp-admin/profile.php')); ?>"><i class="far fa-user"></i>Profile settings</a></li>
                                        <?php } else { ?>
                                            <li><a href="<?php echo esc_url(home_url('/user-dashboard')); ?>"><i class="fas fa-list"></i>Dashboard</a></li>
                                            <li><a href="<?php echo esc_url(home_url('/my-profile')); ?>"><i class="far fa-user"></i>Profile settings</a></li>
                                        <?php } ?>
                                            <li><a href="<?php echo esc_url( wp_logout_url( home_url() ) ); ?>"><i class="fas fa-sign-out-alt"></i>Logout</a></li>
                                        </ul>
                                    </div>
                                </div>
                            <?php else: ?>
                                <a class="sl-ajax-login" href=""><i class="sl-icon sl-avatar-o"></i><?php esc_html_e('Login', 'luxus'); ?></a>
                            <?php endif;
                        ?>
                    </div>
                <?php endif; ?>
            </nav>
        </div>
    </div>
</div>