<?php
/**
 * Template part for displaying Classic Header
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Luxus
 */

$classic_header_width = luxus_options('header-width');

// Options Logo
$brand_logo_opt = luxus_options('brand-logo');
$brand_logo_url = !$brand_logo_opt == null ? $brand_logo_opt['url'] : null;
$brand_opt_logo = !$brand_logo_url == null ? $brand_logo_url : null;

// Page Logo
$brand_logo_meta = luxus_page_meta( '_page_logo' );
$brand_logo_meta_url = !$brand_logo_meta == null ? $brand_logo_meta['url'] : null;
$brand_page_logo = !$brand_logo_meta_url == null ? $brand_logo_meta_url : null;

// Site Logo Url
$brand_logo = !$brand_page_logo == null ? $brand_page_logo : $brand_opt_logo;

$main_menu_position_opt = luxus_options('main-menu-position');
$main_menu_position = !empty( $main_menu_position_opt ) ? $main_menu_position_opt : "right";
$classic_user_avatar = luxus_options('user-avatar');
$classic_right_btn = luxus_options('right-btn');
$classic_right_btn_text = luxus_options('right-btn-text');
$classic_right_btn_link = luxus_options('right-btn-link');

?>
<header class="site-header">
	<div class="<?php echo esc_attr(!$classic_header_width == null ? $classic_header_width : 'container'); ?>">
		<div class="classic-header">
			<div class="box brand">
				<a href="<?php echo esc_url(home_url('/')); ?>" rel="home">
				<?php if (!$brand_logo == null) : ?>
					<!-- Brand Logo -->
					<img src="<?php echo esc_url( $brand_logo ); ?>" alt="<?php esc_attr( bloginfo( 'name' ) ); ?>">
				<?php else:
					if ( function_exists( 'the_custom_logo' ) && has_custom_logo() ) {
 						the_custom_logo();
					} else {
						echo '<h2>' . esc_html( get_bloginfo('name') ) . '</h2>';
					}
				endif; ?>
				</a>
			</div>
		    <div class="box main-menu" style="text-align: <?php  echo esc_attr( $main_menu_position ); ?>">
	    		<?php
	    			wp_nav_menu( array(
	    				'theme_location' => 'primary-menu',
	    				'container'=>'',
	    				'fallback_cb'    => false
	    			) );
	    		?>
	    	</div>
	    	<div class="box menu-right">
	    		<?php

	    			if( $classic_user_avatar == true ){

	                    if( is_user_logged_in() ):

	                        $user = wp_get_current_user();

	                        //GETTING PROFILE IMAGE OF USER
	                        $user_meta_img_id = get_user_meta( $user->ID, 'profile_image_id', true );
	                        $user_meta_img_url = !$user_meta_img_id == null ? wp_get_attachment_url( $user_meta_img_id ) : null;
	                        $avatar_placeholder = esc_url(get_template_directory_uri()) . '/assets/images/luxus-avatar.png';
	                        $luxus_user_avatar_url = !$user_meta_img_url == null ? $user_meta_img_url : $avatar_placeholder;

	                     ?>
	                        <div class="user-loged-in">
	                            <img src="<?php echo esc_url( $luxus_user_avatar_url );  ?>" class="user-pic" alt="<?php echo esc_attr( $user->display_name ); ?>">
	                            <div class="quick-links">
	                                <div class="user-name"><?php echo esc_html( $user->display_name ); ?></div>
	                                <ul>
                                	<?php if ( current_user_can('administrator') || current_user_can('editor') || current_user_can('author') || current_user_can('contributor') || current_user_can('subscriber') ) { ?>
                                		<li><a href="<?php echo esc_url(home_url('/wp-admin/')); ?>"><i class="fas fa-list"></i>Dashboard</a></li>
                                    	<li><a href="<?php echo esc_url(home_url('/wp-admin/profile.php')); ?>"><i class="far fa-user"></i>Profile settings</a></li>

                                    <?php } else { ?>
										<li><a href="<?php echo esc_url(home_url('/user-dashboard')); ?>"><i class="fas fa-list"></i>Dashboard</a></li>
                                    	<li><a href="<?php echo esc_url(home_url('/my-profile')); ?>"><i class="far fa-user"></i>Profile settings</a></li>

                                    <?php } ?>
	                                    <li><a href="<?php echo esc_url( wp_logout_url( home_url() ) ); ?>"><i class="fas fa-sign-out-alt"></i>Logout</a></li>
	                                </ul>
	                            </div>
	                        </div>

	                    <?php else:
	                    	$user_avatar_text = luxus_options('user-avatar-text');
	                    ?>
							<a class="sl-ajax-login" href=""><i class="sl-icon sl-avatar-o"></i> <?php echo !empty( $user_avatar_text ) ? esc_html( $user_avatar_text ) : esc_html__('Login', 'luxus'); ?></a>
	                    <?php endif;
	    			}

					if( class_exists( 'CSF' ) ) {

		    			if( $classic_right_btn == true ) { 

		    				echo '<a href="' . esc_url( $classic_right_btn_link ) . '" class="right-btn">' . esc_html( $classic_right_btn_text ) . '</a>';

		    			}
	    			}
	    		?>
	    	</div>
		</div>
	</div>
</header>