<?php if ( ! defined( 'ABSPATH' )  ) { die; } // Cannot access directly.

//-----------------
// Header Section Parent
//-----------------
CSF::createSection( $prefix, array(
  'id'    => 'header-section',
  'title' => esc_html__( 'Header Settings', 'luxus' ),
) );

//-----------------
// Header Section
//-----------------
CSF::createSection( $prefix, array(
  'parent'      => 'header-section',
  'title'  => esc_html__( 'Header', 'luxus' ),
  'fields' => array(

    // Brand Logo
    array(
      'id'    => 'brand-logo',
      'type'  => 'media',
      'title' => esc_html__( 'Upload Brand Logo', 'luxus' ),
    ),

    // Brand Logo Width
    array(
      'id'          => 'brand-logo-width',
      'type'        => 'number',
      'title'       => esc_html__( 'Logo Width', 'luxus' ),
      'unit'        => 'px',
      'output'      => '.brand img',
      'output_important'  => true,
      'output_mode' => 'width',
      'default'     => 150,
    ),


    // Select Site Header
    array(
      'id'          => 'site-header',
      'type'        => 'select',
      'title'       => esc_html__( 'Select Site Header', 'luxus' ),
      'placeholder' => esc_html__( 'Default Header', 'luxus' ),
      'options'     => 'post',
      'query_args'  => array(
        'post_type' => 'luxus_content_block',
        'meta_key'   => 'luxus_content_block_type',
        'meta_value' => 'header'
      ),
    ),

    // Header Width
    array(
      'id'          => 'header-width',
      'type'        => 'select',
      'title'       => esc_html__( 'Header Width', 'luxus' ),
      'options'     => array(
        'container' => esc_html__( 'Boxed', 'luxus' ),
        'container-fluid'  => esc_html__( 'Full Width', 'luxus' ),
      ),
      'default'     => 'container'

    ),

    // Header Line Height
    array(
      'id'          => 'site-header-line-height',
      'type'        => 'number',
      'title'       => esc_html__( 'Header Line Height', 'luxus' ),
      'unit'        => 'px',
      'output'      => '.site-header, header.sticky-header',
      'output_important'  => true,
      'output_mode' => 'line-height',
      'default'     => 100,
    ),

    // Header Background Color
    array(
      'id'    => 'header-bg-color',
      'type'  => 'color',
      'title' => esc_html__( 'Default Header Background Color', 'luxus' ),
      'output' => array( 'background' => '.site-header' ),
    ),

    // Custom Header Background Color
    array(
      'id'    => 'custom-header-bg-color',
      'type'  => 'color',
      'title' => esc_html__( 'Custom Header Background Color', 'luxus' ),
      'output' => array( 'background' => '.custom-site-header' ),
    ),

    // Main Menu Position
    array(
      'id'          => 'main-menu-position',
      'type'        => 'select',
      'title'       => esc_html__( 'Main Menu Position', 'luxus' ),
      'options'     => array(
        'left'    => 'Left',
        'center'  => 'Center',
        'right'   => 'Right',
      ),
      'default'   => 'center'
    ),

    // Main Menu Font
    array(
      'id'      => 'main-menu-font',
      'type'    => 'typography',
      'title'   => esc_html__( 'Main Menu Font', 'luxus' ),
      'output'  => '.main-menu ul li a',
      'output_important'  => true,
      'default' => array(
        'font-family'    => 'Inter',
        'font-size'      => '16',
        'font-weight'    => 500,
        'type'           => 'google',
        'unit'           => 'px',
      ),
      'color'          => false,
      'line_height'    => false,
      'letter_spacing' => false,
      'text_align'     => false,
      'subset'         => false,
    ),

    // Main Menu Color
    array(
      'id'      => 'main-menu-color',
      'type'    => 'link_color',
      'title'   => esc_html__( 'Main Menu Color', 'luxus' ),
      'output'  => '.main-menu ul li a',
    ),

    // Sub Menu Color
    array(
      'id'      => 'sub-menu-color',
      'type'    => 'link_color',
      'title'   => esc_html__( 'Sub Menu Color', 'luxus' ),
      'output'  => '.main-menu ul li ul.sub-menu li a',
      'output_important'  => true,
    ),

    // Active Menu Color
    array(
      'id'    => 'active-menu-color',
      'type'  => 'color',
      'title' => esc_html__( 'Active Menu Color', 'luxus' ),
      'output' => '.current-menu-item > a, .current-menu-ancestor > a, .main-menu ul li ul.sub-menu .current-menu-item > a',
	   'output_important'  => true,
    ),

    // Sub Menu Background
    array(
      'id'    => 'sub-menu-bg',
      'type'  => 'color',
      'title' => esc_html__( 'Sub Menu Background', 'luxus' ),
      'default' => '#ffffff',
      'output' => array( 'background' => '.main-menu ul.sub-menu' ),
      'output_important'  => true,
    ),

    // Sub Menu Hover Background
    array(
      'id'    => 'sub-menu-bg-h',
      'type'  => 'color',
      'title' => esc_html__( 'Sub Menu Hover Background', 'luxus' ),
      'default' => '#e7f7fe',
      'output' => array( 'background' => '.main-menu ul.sub-menu li:hover' ),
      'output_important'  => true,
    ),

    // Enable Sticky Header
    array(
      'id'         => 'sticky-header',
      'type'       => 'switcher',
      'title'      => esc_html__( 'Enable Sticky Header', 'luxus' ),
      'text_on'    => esc_html__( 'Enabled', 'luxus' ),
      'text_off'   => esc_html__( 'Disabled', 'luxus' ),
      'text_width' => 100,
      'default'    => true,
    ),

    // Sticky Brand Logo
    array(
      'dependency' => array( 'sticky-header', '==', 'true' ),
      'id'    => 'sticky-logo',
      'type'  => 'media',
      'title' => esc_html__( 'Upload Sticky Header Logo', 'luxus' ),
    ),

    // Header Background Color
    array(
	  'dependency' => array( 'sticky-header', '==', 'true' ),
      'id'    => 'sticky-header-bg-color',
      'type'  => 'color',
      'default' => '#00072D',
      'title' => esc_html__( 'Sticky Header Background Color', 'luxus' ),
      'output' => array( 'background' => 'header.sticky-header' ),
    ),

    // Sticky Main Menu Color
    array(
      'dependency' => array( 'sticky-header', '==', 'true' ),
      'id'      => 'sticky-menu-color',
      'type'    => 'link_color',
      'title'   => esc_html__( 'Sticky Header Menu Color', 'luxus' ),
      'output'  => '.sticky-header .main-menu ul li a',
      'default' => array(
        'color' => '#ffffff',
        'hover' => '',
      ),
    ),

    // Sticky Sub Menu Color
    array(
      'dependency' => array( 'sticky-header', '==', 'true' ),
      'id'      => 'sticky-sub-menu-color',
      'type'    => 'link_color',
      'title'   => esc_html__( 'Sticky Header Sub Menu Color', 'luxus' ),
      'output'  => '.sticky-header .main-menu ul.sub-menu li a',
    ),

    // Sticky Active Menu Color
    array(
      'id'    => 'sticky-active-menu-color',
      'type'  => 'color',
      'title' => esc_html__( 'Sticky Active Menu Color', 'luxus' ),
      'output' => '.sticky-header .main-menu ul li.current-menu-item > a, .sticky-header .main-menu ul li.current-menu-ancestor > a',
    ),

    // Sticky Sub Menu Background
    array(
      'dependency' => array( 'sticky-header', '==', 'true' ),
      'id'    => 'sticky-sub-menu-bg',
      'type'  => 'color',
      'title' => esc_html__( 'Sticky Header Sub Menu Background', 'luxus' ),
      'output' => array( 'background' => '.sticky-header .main-menu ul.sub-menu' ),
      'output_important'  => true,
    ),

    // Sticky Sub Menu Hover Background
    array(
      'dependency' => array( 'sticky-header', '==', 'true' ),
      'id'    => 'sticky-sub-menu-bg-h',
      'type'  => 'color',
      'title' => esc_html__( 'Sticky Header Sub Menu Hover Background', 'luxus' ),
      'output' => array( 'background' => '.sticky-header .main-menu ul.sub-menu li:hover' ),
      'output_important'  => true,
    ),

    // Enable User Avatar
    array(
      'id'         => 'user-avatar',
      'type'       => 'switcher',
      'title'      => esc_html__( 'Enable User Avatar', 'luxus' ),
      'text_on'    => esc_html__( 'Enabled', 'luxus' ),
      'text_off'   => esc_html__( 'Disabled', 'luxus' ),
      'text_width' => 100,
      'default'    => true,
    ),

    // User Avatar Text
    array(
      'id'      => 'user-avatar-text',
      'type'    => 'text',
      'title'   => esc_html__( 'User Avatar Text', 'luxus' ),
      'default' => esc_html__( 'Login', 'luxus' ),
      'dependency' => array( 'user-avatar', '==', 'true' ),
    ),
	  
    // User Avatar Text Color
    array(
      'id'    => 'user-avatar-text-color',
      'type'  => 'color',
      'title' => esc_html__( 'User Avatar Text Color', 'luxus' ),
      'output' => array( 'color' => '.site-header a.sl-ajax-login' ),
		  'dependency' => array( 'user-avatar', '==', 'true' ),
    ),
	  
    // Sticky User Avatar Text Color
    array(
      'id'    => 'user-avatar-text-color-sticky',
      'type'  => 'color',
      'title' => esc_html__( 'Sticky User Avatar Text Color', 'luxus' ),
      'output' => array( 'color' => '.sticky-header a.sl-ajax-login' ),
		  'dependency' => array( 'user-avatar', '==', 'true' ),
    ),

    // Enable Right Button
    array(
      'id'         => 'right-btn',
      'type'       => 'switcher',
      'title'      => esc_html__( 'Enable Right Button', 'luxus' ),
      'text_on'    => esc_html__( 'Enabled', 'luxus' ),
      'text_off'   => esc_html__( 'Disabled', 'luxus' ),
      'text_width' => 100,
      'default'    => true,
    ),

    // Right Button Text
    array(
      'id'      => 'right-btn-text',
      'type'    => 'text',
      'title'   => esc_html__( 'Right Button Text', 'luxus' ),
      'default' => esc_html__( 'Get Started', 'luxus' ),
      'dependency' => array( 'right-btn', '==', 'true' ),
    ),

    // Right Button Link
    array(
      'id'      => 'right-btn-link',
      'type'    => 'text',
      'title'   => esc_html__( 'Right Button Link', 'luxus' ),
      'default' => '#',
      'dependency' => array( 'right-btn', '==', 'true' ),
    ),

    // Right Button Text Color
    array(
      'id'      => 'right-btn-text-color',
      'type'    => 'link_color',
      'title'   => esc_html__( 'Right Button Text Color', 'luxus' ),
      'output'  => '.right-btn',
      'output_important'  => true,
      'dependency' => array( 'right-btn', '==', 'true' ),
    ),

    // Right Button Border
    array(
      'id'     => 'right-btn-border',
      'type'   => 'border',
      'title'  => esc_html__( 'Right Button Border', 'luxus' ),
      'output' => '.right-btn',
      'output_important'  => true,
      'default' => array(
        'unit'   => 'px',
      ),
      'dependency' => array( 'right-btn', '==', 'true' ),

    ),

    // Right Button Border Hover
    array(
      'id'     => 'right-btn-border-h',
      'type'   => 'border',
      'title'  => esc_html__( 'Right Button Hover Border', 'luxus' ),
      'output' => '.right-btn:hover',
      'output_important'  => true,
      'default' => array(
        'unit'   => 'px',
      ),
      'dependency' => array( 'right-btn', '==', 'true' ),

    ),

    // Right Button Border Radius
    array(
      'id'          => 'right-btn-border-r',
      'type'        => 'number',
      'title'       => esc_html__( 'Right Button Border Radius', 'luxus' ),
      'unit'        => 'px',
      'output'      => '.right-btn',
      'output_important'  => true,
      'output_mode' => 'border-radius',
      'default'     => 3,
      'dependency' => array( 'right-btn', '==', 'true' ),
    ),

    // Right Button Background
    array(
      'id'    => 'right-btn-bg',
      'type'  => 'color',
      'title' => esc_html__( 'Right Button Background', 'luxus' ),
      'output' => array( 'background' => '.right-btn' ),
      'output_important'  => true,
      'dependency' => array( 'right-btn', '==', 'true' ),
    ),

    // Right Button Hover Background
    array(
      'id'    => 'right-btn-bg-h',
      'type'  => 'color',
      'title' => esc_html__( 'Right Button Hover Background', 'luxus' ),
      'output' => array( 'background' => '.right-btn:hover' ),
      'output_important'  => true,
      'dependency' => array( 'right-btn', '==', 'true' ),
    ),
  )
) );

//-----------------
// Mobile Header Section
//-----------------
CSF::createSection( $prefix, array(
  'parent'      => 'header-section',
  'title'  => esc_html__( 'Mobile Header', 'luxus' ),
  'fields' => array(

    // Mobile Brand Logo
    array(
      'id'    => 'mob-brand-logo',
      'type'  => 'media',
      'title' => esc_html__( 'Upload Mobile Brand Logo', 'luxus' ),
    ),

    // Mobile Brand Logo Width
    array(
      'id'          => 'mob-brand-logo-width',
      'type'        => 'number',
      'title'       => esc_html__( 'Mobile Logo Width', 'luxus' ),
      'unit'        => 'px',
      'output'      => '.mobile-brand img',
      'output_important'  => true,
      'output_mode' => 'width',
      'default'     => 150,
    ),

    // Header Line Height
    array(
      'id'          => 'mob-header-line-height',
      'type'        => 'number',
      'title'       => esc_html__( 'Mobile Header Line Height', 'luxus' ),
      'unit'        => 'px',
      'output'      => '.sl-mob-menu .mobile-menu .stellarnav.dark',
      'output_important'  => true,
      'output_mode' => 'line-height',
      'default'     => 60,
    ),

    // Enable Sticky Header
    array(
      'id'         => 'mob-sticky-header',
      'type'       => 'switcher',
      'title'      => esc_html__( 'Enable Sticky Header', 'luxus' ),
      'text_on'    => esc_html__( 'Enabled', 'luxus' ),
      'text_off'   => esc_html__( 'Disabled', 'luxus' ),
      'text_width' => 100,
      'default'    => true,
    ),

    // Mobile Header Background Color
    array(
      'id'    => 'mob-header-bg',
      'type'  => 'color',
      'title' => esc_html__( 'Header Background Color', 'luxus' ),
      'default' => '#00072D',
      'output' => array( 'background' => '.sl-mob-menu' ),
    ),
	   
	// Mobile Menu Avatar Color
    array(
      'id'    => 'mob-menu-avatar-color',
      'type'  => 'color',
      'title' => esc_html__( 'Avatar Text Color', 'luxus' ),
      'default' => '#ffffff',
      'output' => array( 'color' => '.stellarnav.dark a.sl-ajax-login' ),
      'output_important'  => true,
    ),
	  
	// Mobile Menu Breadcrumb Color
    array(
      'id'    => 'mob-menu-breadcrumb-color',
      'type'  => 'color',
      'title' => esc_html__( 'Menu Breadcrumb Color', 'luxus' ),
      'default' => '#00bbff',
      'output' => array( 'background' => '.sl-mob-menu .mobile-menu .stellarnav .menu-toggle span.bars span' ),
      'output_important'  => true,
    ),

    // Mobile Menu Font
    array(
      'id'      => 'mob-menu-font',
      'type'    => 'typography',
      'title'   => esc_html__( 'Mobile Menu Font', 'luxus' ),
      'output'  => '.stellarnav.dark li a, .stellarnav.dark a',
      'default' => array(
        'font-family'    => 'Inter',
        'font-size'      => '16',
        'font-weight'    => 400,
        'type'           => 'google',
        'unit'           => 'px',
        'color'           => '#ffffff',
      ),
      'line_height'    => false,
      'letter_spacing' => false,
      'text_align'     => false,
      'subset'         => false,
    ),

    // Mobile Menu Background
    array(
      'id'    => 'mob-menu-bg',
      'type'  => 'color',
      'title' => esc_html__( 'Mobile Menu Background', 'luxus' ),
      'default' => '#000',
      'output' => array( 'background' => '.stellarnav.mobile.dark ul' ),
      'output_important'  => true,
    ),

    // Mobile Menu Icons Color
    array(
      'id'    => 'mob-menu-ico',
      'type'  => 'color',
      'title' => esc_html__( 'Mobile Menu Icons Color', 'luxus' ),
      'default' => '#ffffff',
      'output' => array( 'border-color' => '.stellarnav.dark .icon-close:before, .stellarnav.dark .icon-close:after, .stellarnav.dark a.dd-toggle .icon-plus:before, .stellarnav.dark a.dd-toggle .icon-plus:after' ),
      'output_important'  => true,
    ),

  )
) );