<?php if (!defined("ABSPATH")) {
    die();
} // Cannot access directly.

// Control core classes for avoid errors
if (class_exists("CSF")) {
    // Set a unique slug-like ID
    $prefix = "sl_page_options";
    $meta_prefix = "_";

    // Create a metabox
    CSF::createMetabox($prefix, [
        "title" => esc_html__( "Custom Options", "luxus" ),
        "post_type" => "page",
        "data_type" => "serialize",
    ]);

    // Create a section
    CSF::createSection($prefix, [
        "title" => esc_html__( "General Settings", "luxus" ),
        "fields" => [
            // Page Logo Classic
            [
                "id" => $meta_prefix . "page_logo",
                "type" => "media",
                "title" => esc_html__( "Upload Logo", "luxus" ),
            ],

            // Page Logo Sticky
            [
                "id" => $meta_prefix . "page_sticky_logo",
                "type" => "media",
                "title" => esc_html__( "Upload Sticky Logo", "luxus" ),
            ],

            // Page Background Color
            [
                "id" => $meta_prefix . "background_color",
                "type" => "color",
                "title" => esc_html__( "Background Color", "luxus" ),
                "output" => ".page-content",
                "output_mode" => "background-color",
            ],

            // Page Header
            [
                "id" => $meta_prefix . "page_header",
                "type" => "select",
                "title" => esc_html__( "Select Header", "luxus" ),
                "placeholder" => esc_html__( "Defalut Header", "luxus" ),
                "options" => "post",
                "query_args" => [
                    "post_type" => "luxus_content_block",
                    "meta_key" => "luxus_content_block_type",
                    "meta_value" => "header",
                ],
            ],

            // Page Footer
            [
                "id" => $meta_prefix . "page_footer",
                "type" => "select",
                "title" => esc_html__( "Select Footer", "luxus" ),
                "placeholder" => esc_html__( "Default Footer", "luxus" ),
                "options" => "post",
                "query_args" => [
                    "post_type" => "luxus_content_block",
                    "meta_key" => "luxus_content_block_type",
                    "meta_value" => "footer",
                ],
            ],

            // Header Background Color
            [
                "id" => $meta_prefix . "header_bg_color",
                "type" => "color",
                "title" => esc_html__( "Header Background Color", "luxus" ),
                "output" => ["background" => ".site-header"],
            ],

            // Menu Color
            [
                "id" => $meta_prefix . "menu_color",
                "type" => "link_color",
                "title" => esc_html__( "Menu Color", "luxus" ),
            ],

            // User Avatar Text Color
            [
                "id" => $meta_prefix . "avatar_text_color",
                "type" => "color",
                "title" => esc_html__( "Avatar Text Color", "luxus" ),
                "output" => ["color" => ".site-header a.sl-ajax-login"],
            ],

            // Sticky User Avatar Text Color
            [
                "id" => $meta_prefix . "avatar_text_color_sticky",
                "type" => "color",
                "title" => esc_html__( "Sticky Header Avatar Text Color", "luxus" ),
                "output" => ["color" => ".sticky-header a.sl-ajax-login"],
            ],

            // Page Padding Top
            [
                "id" => $meta_prefix . "page_pt",
                "type" => "number",
                "title" => esc_html__( "Page Padding Top", "luxus" ),
                "unit" => "px",
                "output" => ".page-content",
                "output_mode" => "padding-top",
                "default" => 60,
            ],

            // Page Padding Bottom
            [
                "id" => $meta_prefix . "page_pb",
                "type" => "number",
                "title" => esc_html__( "Pag Padding Bottom", "luxus" ),
                "unit" => "px",
                "output" => ".page-content",
                "output_mode" => "padding-bottom",
                "default" => 60,
            ],
        ],
    ]);

    // Create a section
    CSF::createSection($prefix, [
        "title" => esc_html__( "Page Title Settings", "luxus" ),
        "fields" => [
            // A Notice
            [
                "type" => "notice",
                "style" => "info",
                "content" => esc_html__( "Page Title Settings: Only for default page template", "luxus" ),
            ],

            // Enable Page Title
            [
                "id" => $meta_prefix . "enable_page_title",
                "type" => "switcher",
                "title" => esc_html__( "Enable Page Title", "luxus" ),
                "text_on" => esc_html__( "Enabled", "luxus" ),
                "text_off" => esc_html__( "Disabled", "luxus" ),
                "text_width" => 100,
                "default" => true,
            ],

            // Custom Page Title
            [
                "id" => $meta_prefix . "custom_page_title",
                "type" => "text",
                "title" => "Text",
            ],

            // Page Title Background
            [
                "dependency" => ["_enable_page_title", "==", "true"],
                "id" => $meta_prefix . "page_title_bg",
                "type" => "background",
                "title" => esc_html__( "Page Title Background", "luxus" ),
                "output" => ["background" => ".page-header"],
                "background_gradient" => true,
                "default" => [
                    "background-color" => "",
                    "background-gradient-color" => "",
                    "background-gradient-direction" => "",
                    "background-size" => "",
                    "background-position" => "",
                    "background-repeat" => "",
                ],
            ],

            // Page Title Typography
            [
                "dependency" => ["_enable_page_title", "==", "true"],
                "id" => $meta_prefix . "page_title_typo",
                "type" => "typography",
                "title" => esc_html__( "Page Title Typography", "luxus" ),
                "output" => ".page-title",
                "default" => [
                    "color" => "#ffffff",
                    "font-family" => "Inter",
                    "font-size" => "34",
                    "font-weight" => 700,
                    "line-height" => "44",
                    "letter-spacing" => "0",
                    "text-align" => "",
                    "text-transform" => "",
                    "subset" => "",
                    "type" => "google",
                    "unit" => "px",
                ],
            ],

            // Page Title Padding Top
            [
                "dependency" => ["_enable_page_title", "==", "true"],
                "id" => $meta_prefix . "page_title_pt",
                "type" => "number",
                "title" => esc_html__( "Page Title Padding Top", "luxus" ),
                "unit" => "px",
                "output" => ".page-header",
                "output_mode" => "padding-top",
                "default" => 60,
            ],

            // Page Title Padding Bottom
            [
                "dependency" => ["_enable_page_title", "==", "true"],
                "id" => $meta_prefix . "page_title_pb",
                "type" => "number",
                "title" => esc_html__( "Page Title Padding Bottom", "luxus" ),
                "unit" => "px",
                "output" => ".page-header",
                "output_mode" => "padding-bottom",
                "default" => 60,
            ],

            // Page Title Margin Top
            [
                "dependency" => ["_enable_page_title", "==", "true"],
                "id" => $meta_prefix . "page_title_mt",
                "type" => "number",
                "title" => esc_html__( "Page Title Margin Top", "luxus" ),
                "unit" => "px",
                "output" => ".page-header",
                "output_mode" => "margin-top",
                "default" => 0,
            ],

            // Page Title Margin Bottom
            [
                "dependency" => ["_enable_page_title", "==", "true"],
                "id" => $meta_prefix . "page_title_mb",
                "type" => "number",
                "title" => esc_html__( "Page Title Margin Bottom", "luxus" ),
                "unit" => "px",
                "output" => ".page-header",
                "output_mode" => "margin-bottom",
                "default" => 0,
            ],

            // Enable Breadcrumb
            [
                "dependency" => ["_enable_page_title", "==", "true"],
                "id" => $meta_prefix . "enable_breadcrumb",
                "type" => "switcher",
                "title" => esc_html__( "Enable Breadcrumb", "luxus" ),
                "text_on" => esc_html__( "Enabled", "luxus" ),
                "text_off" => esc_html__( "Disabled", "luxus" ),
                "text_width" => 100,
                "default" => true,
            ],

            // Breadcrumb Typography
            [
                "dependency" => [
                    ["_enable_page_title", "==", "true"],
                    ["_enable_breadcrumb", "==", "true"],
                ],
                "id" => $meta_prefix . "breadcrumb_typo",
                "type" => "typography",
                "title" => esc_html__( "Breadcrumb Typography", "luxus" ),
                "output" => ".sl_breadcrumb, .sl_breadcrumb a",
                "default" => [
                    "color" => "#ffffff",
                    "font-family" => "Roboto",
                    "font-size" => "15",
                    "font-weight" => 400,
                    "line-height" => "28",
                    "letter-spacing" => "0",
                    "text-align" => "",
                    "text-transform" => "",
                    "subset" => "",
                    "type" => "google",
                    "unit" => "px",
                ],
            ],
        ],
    ]);
}