<?php
/**
 * Luxus Header
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Luxus
 */

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">
	
	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'luxus' ); ?></a>
	
	<?php
	
		// Page Settings
		$page_header = luxus_page_meta( '_page_header' );
		$page_header_bg  = luxus_page_meta( '_header_bg_color' );
		$page_header_bg_color = $page_header_bg !== null ? $page_header_bg : 'rgba(0,0,0,0.0';

	    if ( post_type_exists( 'luxus_content_block' ) ) {
	    	
	        // Get All Custom Header Ids
	    	$all_header_ids = get_posts(array(
	            'post_type' => 'luxus_content_block',
	            'post_status'    => 'publish',
	            'fields'          => 'ids',
	            'posts_per_page'  => -1,
	            'meta_key'  => 'luxus_content_block_type',
	            'meta_value'  => 'header',
	        ));
	    }

		if( post_type_exists( 'luxus_content_block' ) && in_array( $page_header, $all_header_ids ) ) {

			echo '<header class="custom-header" style="background-color:'. esc_attr($page_header_bg_color) .';">';
					do_action( 'luxus_header' );
			echo '</header>';

		} else {

			$site_header = luxus_options('site-header');

			if( post_type_exists( 'luxus_content_block' ) && in_array( $site_header, $all_header_ids ) ){
				echo '<header class="custom-header" style="background-color:'. esc_attr($page_header_bg_color) .';">';
						do_action( 'luxus_header' );
				echo '</header>';
			} else {
				get_template_part( 'template-parts/header/header', 'classic');
			}
		}

		if( class_exists( 'CSF' ) ) {
			// Sticky Header
			$sticky_header = luxus_options('sticky-header');

			if ($sticky_header == true) {
				get_template_part( 'template-parts/header/header', 'sticky');
			}
		}
	
		// Sticky Mobile Header
		$mob_sticky_header = luxus_options('mob-sticky-header');

	?>

	<!-- Mobile Header -->
	<div class="sl-mob-menu <?php echo esc_attr( $mob_sticky_header == true ? 'sticky' : '' ); ?>">
		<?php get_template_part( 'template-parts/header/header', 'mobile'); ?>
	</div>
	<!-- Mobile Header End -->