<?php if ( ! defined( 'ABSPATH' )  ) { die; } // Cannot access directly.

/**
 * User Profile Custom Fields
 */
add_action( 'show_user_profile', 'luxus_user_profile_fields' );
add_action( 'edit_user_profile', 'luxus_user_profile_fields' );
function luxus_user_profile_fields( $user ) {

$user_role = $user->roles['0'];

if( $user_role == 'agent' || $user_role == 'agency') :

?>
    <!-- User Extra Information -->
    <h3><?php _e( 'User information', 'luxus-core' ); ?></h3>
    <table class="form-table">
        <tr>
            <th><label for="profile_image_id"><?php _e( 'User Profile Image ID', 'luxus-core' ); ?></label></th>
            <td>
                <input type="text" name="profile_image_id" id="profile_image_id" value="<?php echo esc_attr( get_the_author_meta( 'profile_image_id', $user->ID ) ); ?>" class="regular-text" />
            </td>
        </tr>
        <tr>
            <th><label for="position"><?php _e( 'Position', 'luxus-core' ); ?></label></th>
            <td>
                <input type="text" name="position" id="position" value="<?php echo esc_attr( get_the_author_meta( 'position', $user->ID ) ); ?>" class="regular-text" />
            </td>
        </tr>
        <tr>
            <th><label for="license"><?php _e( 'License', 'luxus-core' ); ?></label></th>
            <td>
                <input type="text" name="license" id="license" value="<?php echo esc_attr( get_the_author_meta( 'license', $user->ID ) ); ?>" class="regular-text" />
            </td>
        </tr>
        <tr>
            <th><label for="taxnumber"><?php _e( 'Tax Number', 'luxus-core' ); ?></label></th>
            <td>
                <input type="text" name="taxnumber" id="taxnumber" value="<?php echo esc_attr( get_the_author_meta( 'taxnumber', $user->ID ) ); ?>" class="regular-text" />
            </td>
        </tr>
        <tr>
            <th><label for="phone"><?php _e( 'Office Phone', 'luxus-core' ); ?></label></th>
            <td>
                <input type="text" name="phone" id="phone" value="<?php echo esc_attr( get_the_author_meta( 'phone', $user->ID ) ); ?>" class="regular-text" />
            </td>
        </tr>
        <tr>
            <th><label for="fax"><?php _e( 'Fax Number', 'luxus-core' ); ?></label></th>
            <td>
                <input type="text" name="fax" id="fax" value="<?php echo esc_attr( get_the_author_meta( 'fax', $user->ID ) ); ?>" class="regular-text" />
            </td>
        </tr>
        <tr>
            <th><label for="mobile"><?php _e( 'Mobile', 'luxus-core' ); ?></label></th>
            <td>
                <input type="text" name="mobile" id="mobile" value="<?php echo esc_attr( get_the_author_meta( 'mobile', $user->ID ) ); ?>" class="regular-text" />
            </td>
        </tr>
    </table>

    <!-- User Address Details -->
    <h3><?php _e( 'User Address', 'luxus-core' ); ?></h3>
    <table class="form-table">
        <tr>
            <th><label for="city"><?php _e( 'City', 'luxus-core' ); ?></label></th>
            <td>
                <?php

                    if ( $user_role  == 'agent' ) {
                        $cities = 'agent_city';
                    }
                    if ( $user_role  == 'agency' ) {
                        $cities = 'agency_city';
                    }
                    //Agent Taxonomy
                    $user_cities = get_terms( array( 'taxonomy' => $cities, 'hide_empty' => false ) );
                    $user_city = get_the_author_meta( 'city', $user->ID );

                ?>
                <select name="city" id="city" class="regular-text">
                    <?php
                    if( $user_cities != NULL ):
                        foreach($user_cities as $city) { ?>
                            <option <?php echo esc_attr( $user_city == $city->term_id  ? 'selected' : '' ); ?> value="<?php echo esc_attr($city->term_id); ?>"><?php echo esc_html($city->name); ?></option>
                    <?php } else: ?>
                        <option value="none"><?php _e( 'None', 'luxus-core' ); ?></option>
                    <?php endif; ?>
                </select>
            </td>
        </tr>
        <tr>
            <th><label for="state"><?php _e( 'State / Province', 'luxus-core' ); ?></label></th>
            <td>
                <?php

                    if ( $user_role  == 'agent' ) {
                        $provinces = 'agent_province';
                    }
                    if ( $user_role  == 'agency' ) {
                        $provinces = 'agency_province';
                    }
                
                    //Agent Taxonomy
                    $user_states = get_terms( array( 'taxonomy' => $provinces, 'hide_empty' => false ) );
                    $user_state = get_the_author_meta( 'state', $user->ID );

                ?>
                <select name="state" id="state" class="regular-text">
                    <?php
                    if( $user_states != NULL ):
                        foreach($user_states as $state) { ?>
                            <option <?php echo esc_attr( $user_state == $state->term_id  ? 'selected' : '' ); ?> value="<?php echo esc_attr($state->term_id); ?>"><?php echo esc_html($state->name); ?></option>
                    <?php } else: ?>
                        <option value="none"><?php _e( 'None', 'luxus-core' ); ?></option>
                    <?php endif; ?>
                </select>
            </td>
        </tr>
        <tr>
            <th><label for="zip"><?php _e( 'Zip / Postal Code', 'luxus-core' ); ?></label></th>
            <td>
                <input type="text" name="zip" id="zip" value="<?php echo esc_attr( get_the_author_meta( 'zip', $user->ID ) ); ?>" class="regular-text" />
            </td>
        </tr>
        <tr>
            <th><label for="state"><?php _e( 'Country', 'luxus-core' ); ?></label></th>
            <td>
                <?php

                    if ( $user_role  == 'agent' ) {
                        $countries = 'agent_country';
                    }
                    if ( $user_role  == 'agency' ) {
                        $countries = 'agency_country';
                    }
                
                    //Agent Taxonomy
                    $user_countries = get_terms( array( 'taxonomy' => $countries, 'hide_empty' => false ) );
                    $user_country = get_the_author_meta( 'country', $user->ID );

                ?>
                <select name="country" id="country" class="regular-text">
                    <?php
                    if( $user_countries != NULL ):
                        foreach($user_countries as $country) { ?>
                            <option <?php echo esc_attr( $user_country == $country->term_id  ? 'selected' : '' ); ?> value="<?php echo esc_attr($country->term_id); ?>"><?php echo esc_html($country->name); ?></option>
                    <?php } else: ?>
                        <option value="none"><?php _e( 'None', 'luxus-core' ); ?></option>
                    <?php endif; ?>
                </select>
            </td>
        </tr>
        <tr>
            <th><label for="address"><?php _e( 'Street Address' , 'luxus-core' ); ?></label></th>
            <td>
                <input type="text" name="address" id="address" value="<?php echo esc_attr( get_the_author_meta( 'address', $user->ID ) ); ?>" class="regular-text" />
            </td>
        </tr>
    </table>

    <!-- User Social Account Links -->
    <h3><?php _e( 'User Social Accounts', 'luxus-core' ); ?></h3>

    <table class="form-table">
        <tr>
            <th><label for="facebook"><?php _e( 'Facebook', 'luxus-core' ); ?></label></th>
            <td>
                <input type="text" name="facebook" id="facebook" value="<?php echo esc_attr( get_the_author_meta( 'facebook', $user->ID ) ); ?>" class="regular-text" />
            </td>
        </tr>
        <tr>
            <th><label for="twitter"><?php _e( 'Twitter', 'luxus-core' ); ?></label></th>
            <td>
                <input type="text" name="twitter" id="twitter" value="<?php echo esc_attr( get_the_author_meta( 'twitter', $user->ID ) ); ?>" class="regular-text" />
            </td>
        </tr>
        <tr>
            <th><label for="linkedin"><?php _e( 'Linkedin', 'luxus-core' ); ?></label></th>
            <td>
                <input type="text" name="linkedin" id="linkedin" value="<?php echo esc_attr( get_the_author_meta( 'linkedin', $user->ID ) ); ?>" class="regular-text" />
            </td>
        </tr>
        <tr>
            <th><label for="instagram"><?php _e( 'Instagram', 'luxus-core' ); ?></label></th>
            <td>
                <input type="text" name="instagram" id="instagram" value="<?php echo esc_attr( get_the_author_meta( 'instagram', $user->ID ) ); ?>" class="regular-text" />
            </td>
        </tr>
        <tr>
            <th><label for="pinterest"><?php _e( 'Pinterest', 'luxus-core' ); ?></label></th>
            <td>
                <input type="text" name="pinterest" id="pinterest" value="<?php echo esc_attr( get_the_author_meta( 'pinterest', $user->ID ) ); ?>" class="regular-text" />
            </td>
        </tr>
        <tr>
            <th><label for="vk"><?php _e( 'VK', 'luxus-core' ); ?></label></th>
            <td>
                <input type="text" name="vk" id="vk" value="<?php echo esc_attr( get_the_author_meta( 'vk', $user->ID ) ); ?>" class="regular-text" />
            </td>
        </tr>
        <tr>
            <th><label for="youtube"><?php _e( 'Youtube', 'luxus-core' ); ?></label></th>
            <td>
                <input type="text" name="youtube" id="youtube" value="<?php echo esc_attr( get_the_author_meta( 'youtube', $user->ID ) ); ?>" class="regular-text" />
            </td>
        </tr>
        <tr>
            <th><label for="vimeo"><?php _e( 'Vimeo', 'luxus-core' ); ?></label></th>
            <td>
                <input type="text" name="vimeo" id="vimeo" value="<?php echo esc_attr( get_the_author_meta( 'vimeo', $user->ID ) ); ?>" class="regular-text" />
            </td>
        </tr>
    </table>
<?php

endif;

}

/**
 * User Profile Extra Fields Update To Database
 */
add_action( 'personal_options_update', 'luxus_save_user_profile_fields' );
add_action( 'edit_user_profile_update', 'luxus_save_user_profile_fields' );
function luxus_save_user_profile_fields( $user_id ) {

    if ( $user_role !== 'agent' &&  $user_role !== 'agency' && !current_user_can( 'edit_user', $user_id ) ) { return false; }

    update_user_meta( $user_id, 'profile_image_id', $_POST['profile_image_id'] );
    update_user_meta( $user_id, 'position', $_POST['position'] );
    update_user_meta( $user_id, 'license', $_POST['license'] );
    update_user_meta( $user_id, 'taxnumber', $_POST['taxnumber'] );
    update_user_meta( $user_id, 'phone', $_POST['phone'] );
    update_user_meta( $user_id, 'mobile', $_POST['mobile'] );
    update_user_meta( $user_id, 'fax', $_POST['fax'] );
    update_user_meta( $user_id, 'city', $_POST['city'] );
    update_user_meta( $user_id, 'state', $_POST['state'] );
    update_user_meta( $user_id, 'zip', $_POST['zip'] );
    update_user_meta( $user_id, 'country', $_POST['country'] );
    update_user_meta( $user_id, 'address', $_POST['address'] );
    update_user_meta( $user_id, 'facebook', $_POST['facebook'] );
    update_user_meta( $user_id, 'twitter', $_POST['twitter'] );
    update_user_meta( $user_id, 'linkedin', $_POST['linkedin'] );
    update_user_meta( $user_id, 'instagram', $_POST['instagram'] );
    update_user_meta( $user_id, 'pinterest', $_POST['pinterest'] );
    update_user_meta( $user_id, 'vk', $_POST['vk'] );
    update_user_meta( $user_id, 'youtube', $_POST['youtube'] );
    update_user_meta( $user_id, 'vimeo', $_POST['vimeo'] );
    
}