<?php

$taxonomy = $settings['select_category'];

switch ($taxonomy) {

    case "property_type":
        $taxonomy_name = $settings['property_type'];
        break;
    case "property_feature":
        $taxonomy_name = $settings['property_feature'];
        break;
    case "property_status":
        $taxonomy_name = $settings['property_status'];
        break;
    case "property_city":
        $taxonomy_name = $settings['property_city'];
        break;
    case "property_province":
        $taxonomy_name = $settings['property_province'];
        break;
    case "property_country":
        $taxonomy_name = $settings['property_country'];
        break;
    default:
        $taxonomy_name = '';
}

if ( !$taxonomy == NULL && !$taxonomy_name == NULL ) :

    $category = get_term( $taxonomy_name );

?>

<div class="sl-category sl-cat">
    <?php echo '<img src="'. esc_url($settings['category_image']['url']) .'" class="cat-image" alt="'. esc_attr($category->name) .'">'; ?>
    <div class="cat-info">
        <h5 class="cat-name"><?php echo esc_html($category->name); ?></h5>
        <p class="cat-count"><?php echo esc_html($category->count); ?> <?php echo esc_html($settings['posts_count_postfix']); ?></p>
        <a href="<?php echo esc_url(get_term_link( $category->term_id )); ?>" class="tax-explore"><?php echo esc_html($settings['link_text']); ?></a>
    </div>
</div>

<?php

else:

    esc_html_e('Please Select Category', 'luxus-core');

endif;

?>



