<?php

// Agent Meta Boxes
$agent_profile = luxus_post_meta( '_user_profile_img' );
$img_placeholder = SL_PLUGIN_URL . 'public/images/agency-profile.jpg';
$agent_pic_url = $agent_profile != NULL ? $agent_profile['url'] : $img_placeholder;

$social_icons_visibility = $agent_show_icons == 'yes' ? 'agent_social_icons_on' : 'agent_social_icons_off';

?>

<div class="agent-item team-two" style="background-image: url('<?php echo esc_url($agent_pic_url); ?>');">
    <div class="info <?php echo $social_icons_visibility; ?>">
        <h6 class="name"><?php the_title(); ?></h6>
        <p class="possition"><?php esc_html_e('Agent', 'luxus-core'); ?></p>
        <a href="<?php the_permalink(); ?>" class="more"><?php esc_html_e('View Profile', 'luxus-core'); ?></a>
        <?php if( $agent_show_icons == 'yes' ):
            // Social
            $agent_facebook = luxus_post_meta( '_user_facebook' );
            $agent_twitter = luxus_post_meta( '_user_twitter' );
            $agent_linkedin = luxus_post_meta( '_user_linkedin' );
            $agent_instagram = luxus_post_meta( '_user_instagram' );
            $agent_pinterest = luxus_post_meta( '_user_pinterest' );
            $agent_vk = luxus_post_meta( '_user_vk' );

        ?>
            <div class="social">
                <ul>
                    <?php if( $agent_show_icons != NULL): ?>
                        <li><a href="<?php echo esc_url($agent_facebook); ?>" target="blank"><i class="fab fa-facebook-f"></i></a></li>
                    <?php endif;
                    if( $agent_instagram != NULL): ?>
                        <li><a href="<?php echo esc_url($agent_instagram); ?>" target="blank"><i class="fab fa-instagram"></i></a></li>
                    <?php endif;
                    if( $agent_twitter != NULL): ?>
                        <li><a href="<?php echo esc_url($agent_twitter); ?>" target="blank"><i class="fab fa-twitter"></i></a></li>
                    <?php endif;
                    if( $agent_linkedin != NULL): ?>
                        <li><a href="<?php echo esc_url($agent_linkedin); ?>" target="blank"><i class="fab fa-linkedin-in"></i></a></li>
                    <?php endif;
                    if( $agent_pinterest != NULL): ?>
                        <li><a href="<?php echo esc_url($agent_pinterest); ?>" target="blank"><i class="fab fa-pinterest-p"></i></a></li>
                    <?php endif;
                    if( $agent_vk != NULL) : ?>
                        <li><a href="<?php echo esc_url($agent_vk); ?>" target="blank"><i class="fab fa-vk"></i></a></li>
                    <?php endif; ?>
                </ul>
            </div>
        <?php endif; ?>
    </div>
</div>