<?php

// Agency Meta Boxes
$agency_logo = luxus_post_meta( '_user_profile_img' );
$img_placeholder = SL_PLUGIN_URL . 'public/images/agency-profile.jpg';
$agency_pic_url = $agency_logo != NULL ? $agency_logo['url'] : $img_placeholder;

$agency_phone = luxus_post_meta( '_user_phone' );
$agency_mobile = luxus_post_meta( '_user_cell' );
$agency_email = luxus_post_meta( '_user_email' );
$_agency_city = luxus_post_meta( '_user_city' );
$agency_city = !empty( $_agency_city ) ? get_term( $_agency_city ) : null;

?>

<div class="agency-item agency-one">
    <div class="picture" style="background-image: url('<?php echo esc_url($agency_pic_url); ?>');">
        <a href="<?php the_permalink(); ?>" class="view-profile"><i class="fa fa-link"></i></a>
    </div>
    <div class="agency-information">
        <a href="<?php the_permalink(); ?>"><h5 class="name"><?php the_title(); ?></h5></a>
        <div class="contect-info">
            <ul>
                <li><span><?php esc_html_e('Mobile:', 'luxus-core') ?></span>
                    <?php echo esc_html( $agency_mobile != NULL ? $agency_mobile : __('NA', 'luxus-core') ); ?>
                </li>
                <li><span><?php esc_html_e('Office:', 'luxus-core') ?></span>
                    <?php echo esc_html( $agency_phone != NULL ? $agency_phone : __('NA', 'luxus-core') ); ?>
                </li>
                <li><span><?php esc_html_e('Email:', 'luxus-core') ?></span>
                    <?php echo esc_html( $agency_email != NULL ? $agency_email : __('NA', 'luxus-core') ); ?>
                </li>
                <li><span><?php esc_html_e('Location:', 'luxus-core') ?></span>
                    <?php echo esc_html( $agency_city != NULL ? $agency_city->name : __('NA', 'luxus-core') ); ?>
                </li>
            </ul>
        </div>
        <div class="social">
            <?php if ($agency_show_icons == 'yes') :

                // Social
                $agency_facebook = luxus_post_meta( '_user_facebook' );
                $agency_twitter = luxus_post_meta( '_user_twitter' );
                $agency_linkedin = luxus_post_meta( '_user_linkedin' );
                $agency_instagram = luxus_post_meta( '_user_instagram' );
                $agency_pinterest = luxus_post_meta( '_user_pinterest' );
                $agency_vk = luxus_post_meta( '_user_vk' );

            ?>
                <ul>
                    <?php if( $agency_facebook != NULL): ?>
                        <li><a href="<?php echo esc_url($agency_facebook); ?>" target="blank"><i class="fab fa-facebook-f"></i></a></li>
                    <?php endif;
                    if( $agency_instagram != NULL): ?>
                        <li><a href="<?php echo esc_url($agency_instagram); ?>" target="blank"><i class="fab fa-instagram"></i></a></li>
                    <?php endif;
                    if( $agency_twitter != NULL): ?>
                        <li><a href="<?php echo esc_url($agency_twitter); ?>" target="blank"><i class="fab fa-twitter"></i></a></li>
                    <?php endif;
                    if( $agency_linkedin != NULL): ?>
                        <li><a href="<?php echo esc_url($agency_linkedin); ?>" target="blank"><i class="fab fa-linkedin-in"></i></a></li>
                    <?php endif;
                    if( $agency_pinterest != NULL): ?>
                        <li><a href="<?php echo esc_url($agency_pinterest); ?>" target="blank"><i class="fab fa-pinterest-p"></i></a></li>
                    <?php endif;
                    if( $agency_vk != NULL) : ?>
                        <li><a href="<?php echo esc_url($agency_vk); ?>" target="blank"><i class="fab fa-vk"></i></a></li>
                    <?php endif; ?>
                </ul>

            <?php endif; ?>
        </div>
    </div>
</div>