<?php

// Contact User Form Request

$contact_user_table_name = $wpdb->prefix."luxus_messages";
$contact_user_msg_alert = '';
$contact_user_error = '';

if ( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['send_message_action'] ) && $_POST['send_message_action'] == 'send-message' )
{
    global $contact_user_error;
    $contact_user_error = new WP_Error;

    $created_by = $current_user_id;

    $sender_phone_isset = sanitize_text_field( $_POST['sender_phone'] );
    $sender_message_isset = sanitize_text_field( $_POST['sender_message'] );

    if ( empty( $sender_phone_isset ) || empty( $sender_message_isset ) ) {
        $contact_user_error->add( 'field', __(' Please fill all Required fields.', 'luxus-core') );
    }
    if ( ! wp_verify_nonce( $_POST['user_message_nonce'], 'user_message_action' ) ) {
        $contact_user_error->add( 'nonce', __(' Something is wrong, Please try again.', 'luxus-core') );
    }

    if( !empty( $sender_phone_isset ) ) {
        $sender_phone = $sender_phone_isset;
    }else{
        $sender_phone = '';
    }

    if( !empty( $sender_message_isset ) ) {
        $sender_message = $sender_message_isset;
    }else{
        $sender_message = '';
    }

    if( isset( $_POST['sender_id'] ) AND !empty( $_POST['sender_id'] ) ) {
        $sender_id = sanitize_text_field( $_POST['sender_id'] );
    }
    else {
       $sender_id = '';    
    }

    if( isset( $_POST['receiver_id'] ) AND !empty( $_POST['receiver_id'] ) ) {
        $receiver_id = sanitize_text_field( $_POST['receiver_id'] );
    }
    else {
       $reciver_id = '';    
    }

    $time = current_time('mysql', 1);

    $data = array(
        'created_by' => $created_by,
        'sender_id' => $sender_id,
        'receiver_id' => $receiver_id,
        'sender_phone' => $sender_phone,
        'message' => $sender_message,
        'time' => $time,
    );

    //field formats: %s = string, %d = integer, %f = float
    // A string is a sequence of characters, like "Hello world!".
    // An integer data type is a non-decimal number between -2,147,483,648 and 2,147,483,647.

    $format = array(
        '%s', '%s', '%s', '%s', '%s', '%s'
    );

    if ( 1 > count( $contact_user_error->get_error_messages() ) ) {

        $success = $wpdb->insert( $contact_user_table_name, $data, $format );

        $contact_user_msg_alert = 'success';
        
        // Reset Form
        $sender_phone = '';
        $sender_message = '';

    }else{
        $contact_user_msg_alert = 'failed';
    }
}
