<?php

$sl_col = ( is_active_sidebar( 'properties-page-widget' ) ? 'col-lg-6 col-md-6' : 'col-lg-4 col-md-6' );

// Agent Meta Boxes
$agent_profile = luxus_post_meta( '_user_profile_img' );
$img_placeholder = SL_PLUGIN_URL . 'public/images/agency-profile.jpg';
$agent_pic_url = $agent_profile != NULL && $agent_profile['url'] != NULL ? $agent_profile['url'] : $img_placeholder;

$agent_phone = luxus_post_meta( '_user_phone' );
$agent_mobile = luxus_post_meta( '_user_cell' );
$agent_email = luxus_post_meta( '_user_email' );
$_agent_city = luxus_post_meta( '_user_city' );
$agent_city = !empty( $_agent_city ) ? get_term( $_agent_city ) : null;

$show_social_icons = luxus_options('agent-enable-social-icons');

?>

<div class="<?php echo esc_attr($sl_col); ?>">
	<div class="agent-one">
		<div class="picture" style="background-image: url('<?php echo esc_url($agent_pic_url); ?>');">
			<a href="<?php the_permalink(); ?>" class="view-profile"><i class="fa fa-link"></i></a>
		</div>
		<a href="<?php the_permalink(); ?>"><h6 class="name"><?php the_title(); ?></h6></a>
		<div class="contect-info">
			<ul>
				<li><span>Mobile:</span>
					<?php echo esc_html( $agent_mobile != NULL ? $agent_mobile : __('NA', 'luxus-core') ); ?>
				</li>
				<li><span>Office:</span>
					<?php echo esc_html( $agent_phone != NULL ? $agent_phone : __('NA', 'luxus-core') ); ?>
				</li>
				<li><span>Email:</span>
					<?php echo esc_html( $agent_email != NULL ? $agent_email : __('NA', 'luxus-core') ); ?>
				</li>
				<li><span>Location:</span>
					<?php echo esc_html( $agent_city != NULL ? $agent_city->name : __('NA', 'luxus-core') ); ?>
				</li>
			</ul>
		</div>

		<?php

			if ( $show_social_icons == true ) :

				// Social
				$agent_facebook = luxus_post_meta( '_user_facebook' );
				$agent_twitter = luxus_post_meta( '_user_twitter' );
				$agent_linkedin = luxus_post_meta( '_user_linkedin' );
				$agent_instagram = luxus_post_meta( '_user_instagram' );
				$agent_pinterest = luxus_post_meta( '_user_pinterest' );
				$agent_vk = luxus_post_meta( '_user_vk' );
				$agent_youtube = luxus_post_meta( '_user_youtube' );
				$agent_vimeo = luxus_post_meta( '_user_vimeo' );

		?>
			<div class="social">
				<ul>
					<?php if( $agent_facebook != NULL): ?>
						<li><a href="<?php echo esc_url($agent_facebook); ?>" target="blank"><i class="fab fa-facebook-f"></i></a></li>
					<?php endif;
					if( $agent_instagram != NULL): ?>
						<li><a href="<?php echo esc_url($agent_instagram); ?>" target="blank"><i class="fab fa-instagram"></i></a></li>
					<?php endif;
					if( $agent_twitter != NULL): ?>
						<li><a href="<?php echo esc_url($agent_twitter); ?>" target="blank"><i class="fab fa-twitter"></i></a></li>
					<?php endif;
					if( $agent_linkedin != NULL): ?>
						<li><a href="<?php echo esc_url($agent_linkedin); ?>" target="blank"><i class="fab fa-linkedin-in"></i></a></li>
					<?php endif;
					if( $agent_pinterest != NULL): ?>
						<li><a href="<?php echo esc_url($agent_pinterest); ?>" target="blank"><i class="fab fa-pinterest-p"></i></a></li>
					<?php endif;
					if( $agent_vk != NULL) : ?>
	                    <li><a href="<?php echo esc_url($agent_vk); ?>" target="blank"><i class="fab fa-vk"></i></a></li>
	                <?php endif; ?>
				</ul>
			</div>
		<?php endif; ?>
	</div>
</div>
