<?php

// Agent Meta Boxes
$agency_logo = luxus_post_meta( '_user_profile_img' );
$img_placeholder = SL_PLUGIN_URL . 'public/images/agency-profile.jpg';
$agency_pic_url = $agency_logo != NULL && $agency_logo['url'] != NULL ? $agency_logo['url'] : $img_placeholder;

$agency_phone = luxus_post_meta( '_user_phone' );
$agency_mobile = luxus_post_meta( '_user_cell' );
$agency_email = luxus_post_meta( '_user_email' );
$_agency_city = luxus_post_meta( '_user_city' );
$agency_city = !empty( $_agency_city ) ? get_term( $_agency_city ) : null;

$show_social_icons = luxus_options('agency-enable-social-icons');

$agency_excerpt_opt = luxus_options('agency-excerpt-length');
$agency_excerpt = !empty( $agency_excerpt_opt ) ? $agency_excerpt_opt : 20;

?>

<div class="col-xl-12 col-md-6">
	<div class="agent-three">
		<div class="img" style="background-image: url('<?php echo esc_url($agency_pic_url); ?>');">
			<?php

			if ( $show_social_icons == true ) :

				// Social
				$agency_facebook = luxus_post_meta( '_user_facebook' );
				$agency_twitter = luxus_post_meta( '_user_twitter' );
				$agency_linkedin = luxus_post_meta( '_user_linkedin' );
				$agency_instagram = luxus_post_meta( '_user_instagram' );
				$agency_pinterest = luxus_post_meta( '_user_pinterest' );
				$agency_vk = luxus_post_meta( '_user_vk' );

			?>
				<div class="social">
					<ul>
						<?php if( $agency_facebook != NULL): ?>
							<li><a href="<?php echo esc_url($agency_facebook); ?>" target="blank"><i class="fab fa-facebook-f"></i></a></li>
						<?php endif;
						if( $agency_instagram != NULL): ?>
							<li><a href="<?php echo esc_url($agency_instagram); ?>" target="blank"><i class="fab fa-instagram"></i></a></li>
						<?php endif;
						if( $agency_twitter != NULL): ?>
							<li><a href="<?php echo esc_url($agency_twitter); ?>" target="blank"><i class="fab fa-twitter"></i></a></li>
						<?php endif;
						if( $agency_linkedin != NULL): ?>
							<li><a href="<?php echo esc_url($agency_linkedin); ?>" target="blank"><i class="fab fa-linkedin-in"></i></a></li>
						<?php endif;
						if( $agency_pinterest != NULL): ?>
							<li><a href="<?php echo esc_url($agency_pinterest); ?>" target="blank"><i class="fab fa-pinterest-p"></i></a></li>
						<?php endif;
						if( $agency_vk != NULL): ?>
							<li><a href="<?php echo esc_url($agency_vk); ?>" target="blank"><i class="fab fa-vk"></i></a></li>
						<?php endif; ?>
					</ul>
				</div>
			<?php endif; ?>
		</div>
		<div class="content">
			<h6 class="name heading"><?php the_title(); ?></h6>
			<ul class="contect-info">
				<li><i class="sl-icon sl-phone-t"></i>
					<?php echo esc_html( $agency_phone != NULL ? $agency_phone : __('NA', 'luxus-core') ); ?>
				</li>
				<li><i class="sl-icon sl-phone-o"></i>
					<?php echo esc_html( $agency_mobile != NULL ? $agency_mobile : __('NA', 'luxus-core') ); ?>
				</li>
				<li><i class="sl-icon sl-mail-o"></i>
					<?php echo esc_html( $agency_email != NULL ? $agency_email : __('NA', 'luxus-core') ); ?>
				</li>
				<li><i class="sl-icon sl-place"></i>
					<?php echo esc_html( $agency_city != NULL ? $agency_city->name : __('NA', 'luxus-core') ); ?>
				</li>
			</ul>
			<p class="text"><?php echo wp_trim_words( get_the_content(), $agency_excerpt, __(' ...', 'luxus-core') ); ?></p>
			<a class="more" href="<?php the_permalink() ?>"><?php esc_html_e('View Profile', 'luxus-core'); ?></a>
		</div>
	</div>
</div>
