<?php if ( ! defined( 'ABSPATH' )  ) { die; } // Cannot access directly.

/**
 * The template for displaying all single posts of 'agency post type'
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package luxus
 */

get_header();

global $wpdb;

// Get options
$sidebar_position = luxus_options('agency-single-sidebar-position');
$agency_enable_address = luxus_options('agency-enable-address');
$agency_enable_reviews = luxus_options('agency-enable-reviews');
$agency_enable_map = luxus_options('agency-enable-map');

// Agency Meta Boxes
$agency_profile = luxus_post_meta( '_user_profile_img' );
$agency_phone = luxus_post_meta( '_user_phone' );
$agency_fax = luxus_post_meta( '_user_fax' );
$agency_mobile = luxus_post_meta( '_user_cell' );
$agency_email = luxus_post_meta( '_user_email' );
$agency_website = luxus_post_meta( '_user_website' );
$_agency_city = luxus_post_meta( '_user_city' );
$agency_city = !empty( $_agency_city ) ? get_term( $_agency_city ) : null;
$_agency_state = luxus_post_meta( '_user_state' );
$agency_state = !empty( $_agency_state ) ? get_term( $_agency_state ) : null;
$agency_zip_code = luxus_post_meta( '_user_zip' );
$_agency_country = luxus_post_meta( '_user_country' );
$agency_country = !empty( $_agency_country ) ? get_term( $_agency_country ) : null;
$agency_st_address = luxus_post_meta( '_user_st_address' );
$agency_licence = luxus_post_meta( '_user_license' );
$agency_tax_number = luxus_post_meta( '_user_tax_number' );
$agency_position = luxus_post_meta( '_user_designation' );

if ( $agency_enable_map == true ){

    $agency_map = luxus_post_meta( '_user_map');
    $agency_map_address = ( !empty( $agency_st_address ) ? $agency_st_address . ', ' : null ) . ( isset( $agency_city->name ) ? $agency_city->name . ', ' : null ) . ( !empty( $agency_zip_code ) ? $agency_zip_code . ', ' : null ) . ( isset( $agency_state->name ) ? $agency_state->name : null );
}

// Social
$agency_facebook = luxus_post_meta( '_user_facebook' );
$agency_twitter = luxus_post_meta( '_user_twitter' );
$agency_linkedin = luxus_post_meta( '_user_linkedin' );
$agency_instagram = luxus_post_meta( '_user_instagram' );
$agency_pinterest = luxus_post_meta( '_user_pinterest' );
$agency_vk = luxus_post_meta( '_user_vk' );
$agency_youtube = luxus_post_meta( '_user_youtube' );
$agency_vimeo = luxus_post_meta( '_user_vimeo' );

$agency_agents = luxus_post_meta( '_user_agents' );

$thumbnail = get_the_post_thumbnail_url(get_the_ID(),'full');
$agency_title_bg = luxus_options('agency-single-title-bg');
$background_gradient_direction = $agency_title_bg['background-gradient-direction'];
$background_color = $agency_title_bg['background-color'];
$background_gradient_color = $agency_title_bg['background-gradient-color'];
$title_background = !empty( $thumbnail ) ? 'background-image: linear-gradient('.$background_gradient_direction.','.$background_color.','.$background_gradient_color.'), url('.$thumbnail.');' : null;

$agency_id = get_the_ID();

$img_placeholder = SL_PLUGIN_URL . 'public/images/agency-profile.jpg';
$agency_pic = $agency_profile ? $agency_profile['url'] : '';
$agency_pic_url = $agency_pic != NULL ? $agency_pic : $img_placeholder;

// Contact Form Schedule Tour Form
$author_id = get_post_field ( 'post_author', get_the_ID() );
$current_user_id = $current_user->ID;
$current_user_name = $current_user->display_name;
$current_user_email = $current_user->user_email;

?>

<div class="agency-single-page-header" style="<?php echo esc_attr($title_background); ?>">
	<div class="container">

        <?php

        luxus_set_post_view();

        echo '<div class="title-left">';

        the_title( '<h2 class="agency-singel-title">', '</h2>' );

        if ($agency_enable_address == true ) :

        ?>
        <p class="address">
            <i class="sl-icon sl-place"></i>
            <?php

            if( $agency_city != NULL) :
                echo esc_html($agency_city->name) . ', ';
            endif;
            if( $agency_state != NULL) :
                echo esc_html($agency_state->name) . ', ';
            endif;
            if( $agency_zip_code != NULL) :
                echo esc_html($agency_zip_code) . ', ';
            endif;
            if( $agency_country != NULL) :
                echo esc_html($agency_country->name);
            endif;

            ?>
        </p>
        <?php

        endif;

        echo '</div>';

        if ( $agency_enable_reviews == true ) :
        echo '<div class="title-right">';
            echo luxus_reviews_get_average_ratings();
        echo '</div>';
        endif;

        ?>
	</div>
</div><!-- .page-header -->

<!-- Main Content -->
<div class="page-content agency-single-content">
	<div class="container">
        <div class="sl-box agency-info">
            <div class="row">
                <div class="col-lg-4">
                    <div class="agency-img" style="background-image: url('<?php echo esc_url($agency_pic_url); ?>');">
                    </div>
                </div>
                <div class="col-lg-4">
                    <h6 class="heading"><?php esc_html_e('Contact with', 'luxus-core'); ?> <span><?php the_title(); ?></span></h6>
                    <div class="agency-contect-info">
                        <ul>
                            <?php if( $agency_mobile != NULL): ?>
                                <li><i class="sl-icon sl-phone-o"></i> <?php echo esc_html($agency_mobile); ?></li>
                            <?php endif;
                            if( $agency_phone != NULL): ?>
                                <li><i class="sl-icon sl-phone-t"></i> <?php echo esc_html($agency_phone); ?></li>
                            <?php endif;
                            if( $agency_fax != NULL): ?>
                                <li><i class="sl-icon sl-fax"></i> <?php echo esc_html($agency_fax); ?></li>
                            <?php endif;
                            if( $agency_email != NULL): ?>
                                <li><i class="sl-icon sl-mail-o"></i> <?php echo esc_html($agency_email); ?></li>
                            <?php endif;
                            if( $agency_website != NULL): ?>
                                <li><i class="sl-icon sl-world"></i> <?php echo esc_html($agency_website); ?></li>
                            <?php endif; ?>
                        </ul>
                    </div>
                    <div class="social">
                        <ul>
                            <?php if( $agency_facebook != NULL): ?>
                                <li><a href="<?php echo esc_url($agency_facebook); ?>" target="blank"><i class="fab fa-facebook-f"></i></a></li>
                            <?php endif;
                            if( $agency_instagram != NULL): ?>
                                <li><a href="<?php echo esc_url($agency_instagram); ?>" target="blank"><i class="fab fa-instagram"></i></a></li>
                            <?php endif;
                            if( $agency_twitter != NULL): ?>
                                <li><a href="<?php echo esc_url($agency_twitter); ?>" target="blank"><i class="fab fa-twitter"></i></a></li>
                            <?php endif;
                            if( $agency_linkedin != NULL): ?>
                                <li><a href="<?php echo esc_url($agency_linkedin); ?>" target="blank"><i class="fab fa-linkedin-in"></i></a></li>
                            <?php endif;
                            if( $agency_pinterest != NULL): ?>
                                <li><a href="<?php echo esc_url($agency_pinterest); ?>" target="blank"><i class="fab fa-pinterest-p"></i></a></li>
                            <?php endif;
                            if( $agency_vk != NULL): ?>
                                <li><a href="<?php echo esc_url($agency_vk); ?>" target="blank"><i class="fab fa-vk"></i></a></li>
                            <?php endif;
                            if( $agency_youtube != NULL) : ?>
                                <li><a href="<?php echo esc_url($agency_youtube); ?>" target="blank"><i class="fab fa-youtube"></i></a></li>
                            <?php endif;
                            if( $agency_vimeo != NULL) : ?>
                                <li><a href="<?php echo esc_url($agency_vimeo); ?>" target="blank"><i class="fab fa-vimeo-v"></i></a></li>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
                <?php 

                // Contact User Form Action
                require dirname( __FILE__ ) . '/template-parts/contact-user-form-action.php';

                ?>
                <div class="col-lg-4">
                    <div class="contact-agency">
                        <form action="" method="post">
                            <input type="hidden" id="reciver_id" name="receiver_id" value="<?php echo esc_attr($author_id); ?>" />
                            <input type="hidden" id="sender_id" name="sender_id" value="<?php echo esc_attr($current_user_id); ?>" />

                            <?php if( !is_user_logged_in() ) { ?>

                                <input type="text" class="form-control" id="sender_name" placeholder="<?php esc_attr_e('Name', 'luxus-core'); ?>">

                                <input type="text" class="form-control" id="sender_email" placeholder="<?php esc_attr_e('Email', 'luxus-core'); ?>">

                            <?php } else {
                                echo '<h6 class="heading">'. __('Logged in as', 'luxus-core') .' <span>'. esc_html($current_user_name) .'</span></h6>';

                                ?>
                                <input type="text" class="form-control" id="sender_phone" name="sender_phone" value="<?php echo esc_attr( isset( $_POST['sender_phone'] ) ? $sender_phone : null ) ?>" placeholder="<?php esc_attr_e('Phone', 'luxus-core'); ?>">
                            <?php } ?>

                            <textarea class="form-control" id="sender_message" name="sender_message" value="<?php echo esc_attr( isset( $_POST['sender_message'] ) ? $sender_message : null ) ?>"placeholder="<?php esc_attr_e('Message', 'luxus-core'); ?>"><?php echo esc_html( isset( $_POST['sender_message'] ) ? $sender_message : null ) ?></textarea>

                            <?php if( !is_user_logged_in() ) {

                                echo "<a href='' class='sl-ajax-login sl-btn-fill'>". __('Send Message', 'luxus-core') ."</a>";

                            } else { ?>
                                
                                <button type="submit" class="sl-btn-fill"><?php esc_html_e('Contact with', 'luxus-core'); ?></button>
                                <?php wp_nonce_field( "user_message_action", "user_message_nonce" ); ?>
                                <input type="hidden" id="send_message_action" name="send_message_action" value="send-message" />

                            <?php } ?>
                        </form>
                        <?php
                            // Print Errors
                            if ( is_wp_error( $contact_user_error ) ) {
                                echo '<div class="agency-errors">';
                                    foreach ( $contact_user_error->get_error_messages() as $error ) {
                                        echo '<strong class="text-danger">'. __('Error: ') .'</strong>' . $error . '<br/>';
                                    }
                                echo '</div>';
                            }
                        ?>
                    </div>
                </div>
                
                <!-- Contact User Succes Alert -->
                <?php

                if ( !empty($contact_user_msg_alert) && $contact_user_msg_alert == 'success' ) :
                    echo '<script type="text/javascript">toastr.success("'. __('Message Sent Successfully.', 'luxus-core') .'");</script>';
                endif;

                // Contact User Failed Alert
                if ( !empty($contact_user_msg_alert) && $contact_user_msg_alert == 'failed' ) :
                     echo '<script type="text/javascript">toastr.error("'. __('Message Sent Failed!', 'luxus-core') .'");</script>';
                endif;

                ?>
            </div>
        </div>
		<div class="row">
	        <div class="col-lg-8">

                <!-- Agency Detail -->
                <div id="overview" class="sl-box">
                    <h6 class="heading"><?php esc_html_e('Agency Detail', 'luxus-core'); ?></h6>
                    <?php
                        while ( have_posts() ) : the_post();

                            the_content();

                        endwhile;
                    ?>
                </div>

                <!-- Agency Agents -->
                <h6 class="heading"><?php esc_html_e('Our Agents', 'luxus-core'); ?></h6>
                <div id="agents">
                    <div class="row">
                        <?php

                        if ( !$agency_agents == null ) {

                            // the query
                            $agents = new WP_Query( array(
                                'post__in' => $agency_agents,
                                'post_type' => 'agent',
                                'posts_per_page' => -1,
                            ));

                            if ( $agents->have_posts() ) :
                                while ( $agents->have_posts() ) :
                                    $agents->the_post();

                                    // Agent Template Parts
                                    require dirname( __FILE__ ) . '/template-parts/agent-style-one.php';
                                
                                endwhile;

                                    // Custom Pagination
                                    luxus_pagination_bar( $agents );

                            endif;

                            wp_reset_postdata();

                        } else { ?>
                            <div class="col-xl-12">
                                <div class="alert-message alert-message-info">
                                    <h6><?php esc_html_e('Agents not found.', 'luxus-core'); ?></h6>
                                    <p><?php esc_html_e('Sorry! No Agents added by', 'luxus-core'); ?> <strong><?php the_title(); ?>.</strong></p>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>

                <!-- Agency Properties -->
                <h6 class="heading"><?php esc_html_e('Properties By', 'luxus-core'); ?> <span><?php the_title(); ?></span></h6>
                <div id="properties">
                    <div class="row">
                        <?php

                            $post_view = luxus_options('agency-single-post-view');
                            $sl_col = ( $post_view == 'grid-view' ? 'col-md-6 col-lg-6' : 'col-md-12 col-lg-12' );
                            $sl_col_item = ( $post_view == 'grid-view' ? 'property-grid' : 'property-list' );

                            $paged = ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1;

                            // Add Agents Properties in Agency Property List
                            $author_ids = array($author_id);
                            $agency_agents_ids = $agency_agents;

                            if ( !empty($agency_agents) ) {

                                $author_id = array($author_id);
                                $agency_agents_ids = array();

                                foreach ( $agency_agents as $agency_agent ) {

                                    $ids = $agency_agent;
                                    $agency_agents_ids[] = get_post_field ( 'post_author', $ids );
                                }

                                $author_in_ids = array_merge($author_id,$agency_agents_ids);

                            } else {

                                $author_in_ids = $author_id;

                            }

                            // the query
                            $properties = new WP_Query( array(
                                'author__in'=> $author_in_ids,
                                'post_type' => 'property',
                                'posts_per_page' => 12,
                                'paged' => $paged
                            ));
                            if ( $properties->have_posts() ) :
                                while ( $properties->have_posts() ) :
                                    $properties->the_post();
                        ?>
                                    <div class="sl-col <?php echo esc_attr($sl_col); ?>">
                                        <div class="sl-item <?php echo esc_attr($sl_col_item); ?>">
                                            <?php

                                            // Property Template Parts
                                            require dirname( __FILE__ ) . '/template-parts/property-style-one.php';

                                            ?>
                                        </div>
                                    </div>
                            <?php

                                endwhile;

                                    // Custom Pagination
                                    luxus_pagination_bar($properties);

                                else :
                            ?>
                                <div class="col-xl-12">
                                    <div class="alert-message alert-message-info">
                                        <h6><?php esc_html_e('Properties not found.', 'luxus-core'); ?></h6>
                                        <p><?php esc_html_e('Sorry! No Properties added by', 'luxus-core'); ?> <strong><?php the_title(); ?>.</strong></p>
                                    </div>
                                </div>
                        <?php 

                            endif;

                            wp_reset_postdata();
                        ?>
                    </div>
                </div>

                <!-- Agency Map -->
                <?php
                if ( $agency_enable_map == true ) :

                    echo '<div class="agency-map sl-box">';
                        echo '<h6 class="heading">'. __('Agency Location', 'luxus-core') .'</h6>';
                        echo '<div id="agency-map"></div>';
                    echo '</div>';

                endif;

                // Reviews
                if ( $agency_enable_reviews == true ) :

                    echo '<h6 class="heading">Reviews</h6>';

                    // If comments are open or we have at least one comment, load up the comment template.
                    if ( comments_open() || get_comments_number() ) {
                        comments_template('/template-parts/reviews.php', true);
                    }

                endif;
                ?>

            </div>

            <!-- This Class order-xl-first is for float sidebar left -->
            <div class="col-lg-4 sl-sticky <?php echo esc_attr( $sidebar_position == 'left-sidebar' ? 'order-lg-first' : '' ); ?>">
                <aside id="secondary" class="widget-area">
                    <?php dynamic_sidebar( 'agencies-page-widget' ); ?>
                </aside><!-- #secondary -->
            </div>
        </div>
	</div>
</div>
<!-- Main Content End -->

<?php if ( $agency_enable_map == true ){

    // getting Values From Meta
    $latitude = isset( $agency_map['latitude'] ) ? $agency_map['latitude'] : 0 ;
    $longtitude = isset( $agency_map['longitude'] ) ? $agency_map['longitude'] : 0 ;
    $zoom = 11;
    $map_marker = SL_PLUGIN_URL . 'public/images/map-pin.png';

    // Agent Map Script
    wp_register_script( 'luxus-agency-map', '', array("jquery"), '', true );
    wp_enqueue_script( 'luxus-agency-map'  );

    wp_add_inline_script( 'luxus-agency-map', "

        jQuery( document ).ready( function( $ ) {

            var markerLocation = [{$latitude}, {$longtitude}];

            var map = L.map('agency-map', {
                center: markerLocation,
                zoom: {$zoom},
                scrollWheelZoom: false,
                'layers': [
                    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                        attribution: '&copy; <a href=\"https://osm.org/copyright\">OpenStreetMap</a> contributors'
                    })
                ]
            });

            map.attributionControl.setPrefix(false);

            // create custom icon
            var mapMarker = L.icon({
                iconUrl: '{$map_marker}',
                iconSize: [40, 48], // size of the icon
            });

            var marker = new L.marker(markerLocation, {
                icon: mapMarker,
                draggable: false
            }).bindPopup('{$agency_map_address}').openPopup();

            marker.addTo(map);

        });
    ");

}

get_footer();