<?php if ( ! defined( 'ABSPATH' )  ) { die; } // Cannot access directly.

/**
 * Template Name: Agencies Template
 */

get_header();

// Get options
$sidebar_position = luxus_options('agencies-sidebar-position');
$is_active_sidebar = ( is_active_sidebar( 'agencies-page-widget' ) ? true : false );
$active_col = ( $is_active_sidebar == true ? '8' : '12' );
$agency_enable_page_title = luxus_options('agency-enable-page-title');
$agency_enable_breadcrumb  = luxus_options('agency-enable-breadcrumb');

//Agency Cities Texonomy
$role_cities = get_terms(array('taxonomy'=>'agency_city'));

//Search By Agency Title
if( isset( $_POST['search_title'] ) AND !empty( $_POST['search_title'] ) ) {
    $search_title = $_POST['search_title'];
}
else {
   $search_title = '';    
}

$tax_query = array();

// Location
if( isset( $_POST['role_city'] ) AND !empty( $_POST['role_city'] ) ) {
    $sl_role_city = $_POST['role_city'];
    $tax_query [] = array(
        'taxonomy'  => 'agency_city',
        'terms'     => $_POST['role_city'],
        'field'     => 'slug',
        'operator'  => 'IN'
    );
}else{
    $sl_role_city = '';
}

if( $agency_enable_page_title == true ): ?>

<div class="agency-page-header">
    <div class="container">
        <?php

            the_title( '<h2 class="agency-page-title">', '</h2>' );

            if( $agency_enable_breadcrumb == true ): ?>

                <p class="sl_breadcrumb agency-breadcrumb"><?php echo luxus_get_breadcrumb(); ?></p>

            <?php endif;?>
    </div>
</div><!-- .page-header -->

<?php endif; ?>

<!-- Main Content -->
<div class="page-content agencies-page">
    <div class="container">
        <div class="row">
            <div class="col-lg-<?php echo esc_attr($active_col); ?>">
                <div class="row">
                    <div class="col-lg-12">
                        <!-- Agency Search form -->
                        <div class="role-search-form">
                            <form action="<?php echo esc_url( get_the_permalink() ); ?>" method="post" novalidate="novalidate">
                                <div class="row">
                                    <div class="col-lg-6 col-md-12">
                                        <input type="text" name="search_title" value="<?php echo esc_attr(isset($_POST['search_title']) ? $search_title : NULL); ?>" class="form-control sl-search-input search_title" placeholder="<?php esc_attr_e('Search Agency by title ...', 'luxus-core'); ?>">
                                    </div>
                                    <div class="col-lg-4 col-md-12 sl-p0">
                                        <div class="sl-select">
                                            <select name="role_city" id="role_city" class="form-control">
                                                <option value=""><?php esc_html_e('Select City', 'luxus-core'); ?></option>
                                                <?php 
                                                if($role_cities != NULL)
                                                {
                                                    foreach ($role_cities as $city) 
                                                    {
                                                ?>
                                                    <option value="<?php echo esc_attr($city->name); ?>" <?php echo esc_attr( $sl_role_city == $city->name ? 'selected' : '' ); ?>>
                                                        <?php echo esc_html($city->name); ?>
                                                    </option>
                                                <?php
                                                        }
                                                    }
                                               ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-lg-2 col-md-12">
                                        <div class="submit_btn">
                                            <button type="submit" class="sl-btn-fill search-btn"><?php esc_html_e('Search', 'luxus-core'); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <!-- Agency Search Form End -->
                    </div>
                    <?php

                        $posts_per_page = luxus_options('agencies-show');
                        $post_style = luxus_options('agencies-post-style');
                        
                        $paged = ( get_query_var( 'paged' ) ) ? absint( get_query_var( 'paged' ) ) : 1;
                        
                        // the query
                        $agencies = new WP_Query( array(
                            'post_type' => 'agency',
                            'post_status' => 'publish',
                            'posts_per_page' => $posts_per_page,
                            's' => $search_title,
                            'tax_query' => $tax_query,
                            'paged' => $paged,
                        ));

                        if ( $agencies->have_posts() ) :
                            while ( $agencies->have_posts() ) :
                                $agencies->the_post();
                                
                                // Agency Template Parts
                                require dirname( __FILE__ ) . '/template-parts/agency-' .$post_style. '.php';

                            endwhile;

                                // Custom Pagination
                                echo '<div class="col-lg-12">';
                                luxus_pagination_bar( $agencies );
                                echo '</div>';

                            else :

                            $nothing_found_img = SL_PLUGIN_URL . 'public/images/nothing-found.png';
                    ?>
                            <div class="col-xl-12 content-none">
                                <div class="fzf-error sl-box text-center">
                                    <img src="<?php echo esc_url($nothing_found_img); ?>">
                                    <h2 class="fzf-title"><?php esc_html_e( 'OOPS! NOTHING FOUND.', 'luxus-core' ); ?></h2>
                                    <p class="error-text">
                                        <?php esc_html_e( 'Sorry, Agencies not found. Please try again with some different keywords.', 'luxus-core' ); ?>
                                    </p>
                                </div>
                            </div><!-- .page-content -->
                    <?php 

                        endif;

                        wp_reset_postdata();
                    ?>
                </div>
            </div>

            <?php if( $is_active_sidebar == true ) : ?>
            <!-- This Class order-xl-first is for float sidebar left -->
            <div class="col-lg-4 sl-sticky <?php echo esc_attr( $sidebar_position == 'left-sidebar' ? 'order-lg-first' : '' ); ?>">
                <aside id="secondary" class="widget-area">
                    <?php dynamic_sidebar( 'agencies-page-widget' ); ?>
                </aside><!-- #secondary -->
            </div>
            <?php endif; ?>

        </div>
    </div>
</div>
<!-- Main Content End -->

<?php
get_footer();