<?php if ( ! defined( 'ABSPATH' )  ) { die; } // Cannot access directly.

/**
 * Template Name: My Profile
 */

// Custom Page Title
function luxus_my_profile_page_title() {
    return esc_html__('My Profile', 'luxus-core') . ' - ' . get_bloginfo();
}
add_action( 'pre_get_document_title', 'luxus_my_profile_page_title' );

// Enqueue Scripts
function luxus_my_profile_enqueue() {
	
	// Media
    wp_enqueue_media();
    wp_register_script('mediaelement', plugins_url('wp-mediaelement.min.js', __FILE__), array('jquery'), '4.8.2', true);
    wp_enqueue_script('mediaelement');
    wp_enqueue_script('media-profile', SL_PLUGIN_URL . 'public/js/media-profile.js', array('jquery'), '1.0', true);
	
	// Leaflet Js
	wp_enqueue_script( 'leaflet', SL_PLUGIN_URL . 'public/js/leaflet.min.js', array( 'jquery' ), '1.7.1', true );
	
	// Leaflet Js Css
	wp_enqueue_style( 'leaflet', SL_PLUGIN_URL . 'public/css/leaflet.min.css', array(), '1.7.1', 'all' );
	
}
add_action('wp_enqueue_scripts', 'luxus_my_profile_enqueue');

$error = array();
$password_error = array();

$current_user = wp_get_current_user();

// Getting post type by user role
$user_post = new WP_Query( array(
    'post_type' => $current_user->roles['0'],
    'author' => $current_user->ID,
) );

$user_post->the_post();

// User CPT profile ID
$cpt_post_id = get_the_ID();
$view_profile_link = get_permalink( $cpt_post_id );

// If Admin Redirect to admin profile
if( $current_user->roles['0'] == 'administrator' ) {
    wp_redirect( admin_url('/profile.php') );
    exit;
}

if ( $current_user->roles['0']  == 'agent' ) {
    $cities = 'agent_city';
    $provinces = 'agent_province';
    $countries = 'agent_country';
}
if ( $current_user->roles['0'] == 'agency' ) {
    $cities = 'agency_city';
    $provinces = 'agency_province';
    $countries = 'agency_country';
}

// Password Update
if ( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['action'] ) && $_POST['action'] == 'change-password' ) {
 
    $_POST = array_map( 'stripslashes_deep', $_POST );
    $current_password = sanitize_text_field( $_POST['current_password'] );
    $new_password = sanitize_text_field( $_POST['new_password'] );
    $confirm_new_password = sanitize_text_field( $_POST['confirm_new_password'] );

    // Check for errors
    if ( empty( $current_password ) && empty( $new_password ) && empty( $confirm_new_password ) ) {
        $password_error[] = __('All Fields Are Requires.', 'luxus-core');
    }

    if( $current_user && wp_check_password( $current_password, $current_user->data->user_pass, $current_user->ID )){
        //match
    } else {
        $password_error[] = __('Password is incorrect', 'luxus-core');
    }

    if( $new_password != $confirm_new_password ) {
        $password_error[] = __('Password does not match', 'luxus-core');
    }

    if(strlen( $new_password ) < 6){
        $password_error[] = __('Password is too short, minimum of 6 characters', 'luxus-core');
    }

    // If NO Errors Update User Password
    if ( count( $password_error ) == 0 ) {
        // Update User Password
        wp_set_password( $new_password, $current_user->ID );
        // Redirect to Current Page
        wp_redirect( get_bloginfo('url').'/my-profile/');
        exit;
    }
}

// Profile Update
if ( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['action'] ) && $_POST['action'] == 'update-user' ) {
 
    // Update User Profile
    if ( !empty( $_POST['firstname'] ) ) {
        update_user_meta( $current_user->ID, 'first_name', esc_attr( $_POST['firstname'] ) );
    }
    if ( !empty( $_POST['lastname'] ) ){
        update_user_meta( $current_user->ID, 'last_name', esc_attr( $_POST['lastname'] ) );
    }
    if ( !empty( $_POST['email'] ) ){
        update_user_meta( $current_user->ID, 'user_email', esc_attr( $_POST['email'] ) );
    }
    if ( !empty( $_POST['position'] ) ){
        update_user_meta( $current_user->ID, 'position', esc_attr( $_POST['position'] ) );
    }
    if ( !empty( $_POST['license'] ) ){
        update_user_meta( $current_user->ID, 'license', esc_attr( $_POST['license'] ) );
    }
    if ( !empty( $_POST['taxnumber'] ) ){
        update_user_meta( $current_user->ID, 'taxnumber', esc_attr( $_POST['taxnumber'] ) );
    }
    if ( !empty( $_POST['phone'] ) ){
        update_user_meta( $current_user->ID, 'phone', esc_attr( $_POST['phone'] ) );
    }
    if ( !empty( $_POST['mobile'] ) ){
        update_user_meta( $current_user->ID, 'mobile', esc_attr( $_POST['mobile'] ) );
    }
    if ( !empty( $_POST['fax'] ) ){
        update_user_meta( $current_user->ID, 'fax', esc_attr( $_POST['fax'] ) );
    }
    if ( !empty( $_POST['city'] ) ){
        update_user_meta( $current_user->ID, 'city', esc_attr( $_POST['city'] ) );
    }
    if ( !empty( $_POST['state'] ) ){
        update_user_meta( $current_user->ID, 'state', esc_attr( $_POST['state'] ) );
    }
    if ( !empty( $_POST['zip'] ) ){
        update_user_meta( $current_user->ID, 'zip', esc_attr( $_POST['zip'] ) );
    }
    if ( !empty( $_POST['address'] ) ){
        update_user_meta( $current_user->ID, 'address', esc_attr( $_POST['address'] ) );
    }
    if ( !empty( $_POST['country'] ) ){
        update_user_meta( $current_user->ID, 'country', esc_attr( $_POST['country'] ) );
    }
    if ( !empty( $_POST['about'] ) ){
        update_user_meta( $current_user->ID, 'description', esc_attr( $_POST['about'] ) );
    }

    // Update User Profile Social Accounts
    if ( !empty( $_POST['website'] ) ){
        update_user_meta( $current_user->ID, 'user_url', esc_attr( $_POST['website'] ) );
    }
    if ( !empty( $_POST['facebook'] ) ){
        update_user_meta( $current_user->ID, 'facebook', esc_attr( $_POST['facebook'] ) );
    }
    if ( !empty( $_POST['twitter'] ) ){
        update_user_meta( $current_user->ID, 'twitter', esc_attr( $_POST['twitter'] ) );
    }
    if ( !empty( $_POST['linkedin'] ) ){
        update_user_meta( $current_user->ID, 'linkedin', esc_attr( $_POST['linkedin'] ) );
    }
    if ( !empty( $_POST['instagram'] ) ){
        update_user_meta( $current_user->ID, 'instagram', esc_attr( $_POST['instagram'] ) );
    }
    if ( !empty( $_POST['pinterest'] ) ){
        update_user_meta( $current_user->ID, 'pinterest', esc_attr( $_POST['pinterest'] ) );
    }
    if ( !empty( $_POST['vk'] ) ){
        update_user_meta( $current_user->ID, 'vk', esc_attr( $_POST['vk'] ) );
    }
    if ( !empty( $_POST['youtube'] ) ){
        update_user_meta( $current_user->ID, 'youtube', esc_attr( $_POST['youtube'] ) );
    }
    if ( !empty( $_POST['vimeo'] ) ){
        update_user_meta( $current_user->ID, 'vimeo', esc_attr( $_POST['vimeo'] ) );
    }
    if ( !empty( $_POST['profile_image_id'] ) ){
        update_user_meta( $current_user->ID, 'profile_image_id', esc_attr( $_POST['profile_image_id'] ) );
    }

    //If CPT Post ID is not Null Update CPT Agent / Agency Database
    if($cpt_post_id != NULL){

        // First Name & Last Name string concatenation
        $cpt_post_title = $_POST['firstname'] . ' ' . $_POST['lastname'];

        // Creating New Slug By User Title
        $new_slug = sanitize_title( $cpt_post_title);

        // Unique Post Slug
        $post_type = get_post_type( $cpt_post_id );
        $post_status = get_post_status( $cpt_post_id );
        $post_parent = wp_get_post_parent_id( $cpt_post_id );
        $new_slug = wp_unique_post_slug( $new_slug, $cpt_post_id, $post_status, $post_type, $post_parent );

        $post_content = $_POST['about'];

        // Get Valuse From Custom Form
        $update_my_cpt_post = array(
            'ID' =>  esc_attr($cpt_post_id),
            'post_title' => esc_attr($cpt_post_title),
            'post_name' => $new_slug,
            'post_content' => $post_content,
        );

        // Update User Custom post into the database
        wp_update_post( $update_my_cpt_post );
        
        update_post_meta( $cpt_post_id, '_user_email', esc_attr( $_POST['email'] ) );
        update_post_meta( $cpt_post_id, '_user_designation', esc_attr( $_POST['position'] ) );
        update_post_meta( $cpt_post_id, '_user_license', esc_attr( $_POST['license'] ) );
        update_post_meta( $cpt_post_id, '_user_tax_number', esc_attr( $_POST['taxnumber'] ) );
        update_post_meta( $cpt_post_id, '_user_phone', esc_attr( $_POST['phone'] ) );
        update_post_meta( $cpt_post_id, '_user_cell', esc_attr( $_POST['mobile'] ) );
        update_post_meta( $cpt_post_id, '_user_fax', esc_attr( $_POST['fax'] ) );
        update_post_meta( $cpt_post_id, '_user_city', esc_attr( $_POST['city'] ) );
        update_post_meta( $cpt_post_id, '_user_zip', esc_attr( $_POST['zip'] ) );
        update_post_meta( $cpt_post_id, '_user_st_address', esc_attr( $_POST['address'] ) );

        if ( !empty( $_POST['city'] ) ){
            wp_set_post_terms( $cpt_post_id, $_POST['city'], $cities);
            update_post_meta( $cpt_post_id, '_user_city', esc_attr( $_POST['city'] ) );
        }
        if ( !empty( $_POST['state'] ) ){
            wp_set_post_terms( $cpt_post_id, $_POST['state'], $provinces);
            update_post_meta( $cpt_post_id, '_user_state', esc_attr( $_POST['state'] ) );
        }
        if ( !empty( $_POST['country'] ) ){
            wp_set_post_terms( $cpt_post_id, $_POST['country'], $countries);
            update_post_meta( $cpt_post_id, '_user_country', esc_attr( $_POST['country'] ) );
        }

        // Agencies Agents
        if ( $current_user->roles['0'] == 'agency' ) {
            if ( empty( $_POST['agency_agents'] ) ) {

                // no values selected, delete all post meta for our key
                 delete_post_meta( $cpt_post_id, '_user_agents' );

            } else {

                $old_values = get_post_meta( $cpt_post_id, '_user_agents', );
                $new_values = $_POST['agency_agents'];
                $values_to_skip = array();

                if( !empty( $old_values ) ) {
                    foreach( $old_values as $old_value ) {
                        if ( ! in_array( $old_value, $new_values ) ) {

                            // this value was in meta, but now it is not selected,
                            // so it has to be deletec
                            delete_post_meta( $cpt_post_id, '_user_agents', $old_value );

                        } else {

                            // This value was in meta and it is selected again,
                            // So, we don't need to save it again
                            $values_to_skip[] = $old_value;

                        }
                    }
                }

                // Get the values that are not already in database
                // And store them
                $values_to_save = array_diff( $new_values, $values_to_skip );

                if ( ! empty( $values_to_save ) ) {

                    update_post_meta( $cpt_post_id, '_user_agents', $values_to_save );
                }
            }
        } // End Agencies Agents

        // Update User Profile Social Accounts
        update_post_meta( $cpt_post_id, '_user_website', esc_attr( $_POST['website'] ) );
        update_post_meta( $cpt_post_id, '_user_facebook', esc_attr( $_POST['facebook'] ) );
        update_post_meta( $cpt_post_id, '_user_twitter', esc_attr( $_POST['twitter'] ) );
        update_post_meta( $cpt_post_id, '_user_linkedin', esc_attr( $_POST['linkedin'] ) );
        update_post_meta( $cpt_post_id, '_user_instagram', esc_attr( $_POST['instagram'] ) );
        update_post_meta( $cpt_post_id, '_user_pinterest', esc_attr( $_POST['pinterest'] ) );
        update_post_meta( $cpt_post_id, '_user_vk', esc_attr( $_POST['vk'] ) );
        update_post_meta( $cpt_post_id, '_user_youtube', esc_attr( $_POST['youtube'] ) );
        update_post_meta( $cpt_post_id, '_user_vimeo', esc_attr( $_POST['vimeo'] ) );

        if ( !empty( $_POST['profile_thumbnail_id'] ) ){
           update_post_meta( $cpt_post_id, '_thumbnail_id', esc_attr( $_POST['profile_thumbnail_id'] ) );
        }
        if ( !empty( $_POST['user_img'] ) ){
           update_post_meta( $cpt_post_id, '_user_profile_img', $_POST['user_img'] );
        }
        if ( !empty( $_POST['user_map'] ) ){
           update_post_meta( $cpt_post_id, '_user_map', $_POST['user_map'] );
        }

    }

    // If NO Errors Update User Profile Database
    if ( count($error) == 0 ) {

        // Update User Profile
        do_action('luxus_edit_user_profile_update', $current_user->ID);

        // Redirect to Current Page
        wp_redirect( get_bloginfo('url').'/my-profile/');
        exit;
    }

}

// Custom User Header
require dirname( __FILE__ ) . '/template-parts/header-user.php';

$username = get_user_meta( $user->ID, 'nickname', true );
$email = get_user_meta( $user->ID, 'user_email', true );
$firstname = get_user_meta( $user->ID, 'first_name', true );
$lastname = get_user_meta( $user->ID, 'last_name', true );
$position = get_user_meta( $user->ID, 'position', true );
$license = get_user_meta( $user->ID, 'license', true );
$taxnumber  = get_user_meta( $user->ID, 'taxnumber', true );
$phone = get_user_meta( $user->ID, 'phone', true );
$mobile = get_user_meta( $user->ID, 'mobile', true );
$fax = get_user_meta( $user->ID, 'fax', true );
$city = get_user_meta( $user->ID, 'city', true );
$state = get_user_meta( $user->ID, 'state', true );
$zip = get_user_meta( $user->ID, 'zip', true );
$address = get_user_meta( $user->ID, 'address', true );
$about = get_user_meta( $user->ID, 'description', true );

// Social Accounts
$website = get_user_meta( $user->ID, 'user_url', true );
$facebook = get_user_meta( $user->ID, 'facebook', true );
$twitter = get_user_meta( $user->ID, 'twitter', true );
$linkedin = get_user_meta( $user->ID, 'linkedin', true );
$instagram = get_user_meta( $user->ID, 'instagram', true );
$pinterest = get_user_meta( $user->ID, 'pinterest', true );
$vk = get_user_meta( $user->ID, 'vk', true );
$youtube = get_user_meta( $user->ID, 'linkedin', true );
$vimeo = get_user_meta( $user->ID, 'vimeo', true );

$map_marker = SL_PLUGIN_URL . 'public/images/map-pin.png';
$user_map_meta = luxus_post_meta( '_user_map', $cpt_post_id );
// $user_map_array = explode(',', $user_map_meta);

$map_address = isset( $user_map_meta['address'] ) ? $user_map_meta['address'] : '' ;
$map_latitude = isset( $user_map_meta['latitude'] ) ? $user_map_meta['latitude'] : '' ;
$map_longitude = isset( $user_map_meta['longitude'] ) ? $user_map_meta['longitude'] : '' ;
$map_zoom = isset( $user_map_meta['zoom'] ) ? $user_map_meta['zoom'] : '' ;

?>

<!-- Main Content -->
<div class="main-content my-profile-content">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <h2 class="heading-one"><?php esc_html_e('Profile Settings', 'luxus-core'); ?></h2>
            </div>
            <div class="col-lg-12">
                <form class="update-user-form" method="post" action="<?php esc_url(get_bloginfo('url').'/my-profile/') ?>" enctype="multipart/form-data">
                    <div class="sl-box">
                        <div class="col-lg-12">
                            <div class="row profile-top">
                                <div class="form-group col-lg-3">
                                    <div class="user-profile-image">
                                        <?php

                                        $profile_pic = get_post_meta( $cpt_post_id, '_user_profile_img', TRUE);

                                        $user_image_id = isset($profile_pic['id']) ? $profile_pic['id'] : '';
                                        $user_image_url = isset($profile_pic['url']) ? $profile_pic['url'] : '';
                                        $user_image_width = isset($profile_pic['width']) ? $profile_pic['width'] : '';
                                        $user_image_height = isset($profile_pic['height']) ? $profile_pic['height'] : '';
                                        $user_image_thumbnail = isset($profile_pic['thumbnail']) ? $profile_pic['thumbnail'] : '';
                                        $user_image_alt = isset($profile_pic['alt']) ? $profile_pic['alt'] : '';
                                        $user_image_title = isset($profile_pic['title']) ? $profile_pic['title'] : '';
                                        $user_image_description = isset($profile_pic['description']) ? $profile_pic['description'] : '';

                                        $profile_placeholder = SL_PLUGIN_URL . 'public/images/agency-profile.jpg'
                                        ?>
                                        <div id='profile-image-preview-wrapper' style="background-image: url('<?php echo esc_url( $user_image_url!= NULL ) ? $user_image_url : $profile_placeholder; ?>'); ">
                                        </div>
                                        <button id="upload_profile_image"><i class="sl-icon sl-image-o"></i></button>
                                        <input type='hidden' name='profile_image_id' id='profile_image_id' value='<?php echo esc_attr($user_image_id); ?>'>
                                        <input type="hidden" name="user_img[url]" id="user_img_url" value="<?php echo esc_attr($user_image_url); ?>">
                                        <input type="hidden" name="user_img[id]" id="user_img_id" value="<?php echo esc_attr($user_image_id); ?>">
                                        <input type="hidden" name="user_img[width]" id="user_img_width" value="<?php echo esc_attr($user_image_width); ?>">
                                        <input type="hidden" name="user_img[height]" id="user_img_height" value="<?php echo esc_attr($user_image_height); ?>">
                                        <input type="hidden" name="user_img[thumbnail]" id="user_img_thumbnail" value="<?php echo esc_attr($user_image_thumbnail); ?>">
                                        <input type="hidden" name="user_img[alt]" id="user_img_alt" value="<?php echo esc_attr($user_image_alt); ?>">
                                        <input type="hidden" name="user_img[title]" id="user_img_title" value="<?php echo esc_attr($user_image_title); ?>">
                                        <input type="hidden" name="user_img[description]" id="user_img_description" value="<?php echo esc_attr($user_image_description); ?>">
                                    </div>
                                </div>
                                <div class="form-group col-lg-9">
                                    <div class="user-profile-thumbnail">
                                        <?php

                                            $get_thumbnail_id = get_post_thumbnail_id($cpt_post_id);

                                            $image_attributes = wp_get_attachment_image_src($get_thumbnail_id , array( 800, 200) );

                                            $thumbnail_placeholder = SL_PLUGIN_URL . 'public/images/placholder-upload-gallery.jpg'
                                        ?>
                                        
                                        <div id='profile-thumbnail-preview-wrapper' style="background-image: url('<?php echo esc_url( $image_attributes != NULL ) ? $image_attributes[0] : $thumbnail_placeholder; ?>'); ">
                                            <?php $fullname = $firstname . ' ' . $lastname; ?>
                                            <a href="<?php echo esc_url($view_profile_link); ?>" class="view-user-profile"><h3 class="profile-name"><?php echo esc_attr( $fullname ); ?></h3></a>
                                        </div>
                                        <button id="upload_profile_thumbnail"><i class="sl-icon sl-image-o"></i></button>
                                        <input type='hidden' name='profile_thumbnail_id' id='profile_thumbnail_id' value='<?php echo esc_attr($get_thumbnail_id); ?>'>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <h6 class="heading">Profile</h6>
                            <input type="hidden" name="action" value="plp_general_details" />
                        </div>
                        <div class="col-lg-12">
                            <label for="username"><?php esc_html_e('Username cannot be changed.', 'luxus-core'); ?></label>
                            <input type="text" class="form-control" name="username" disabled value="<?php echo esc_attr( $username ); ?>" id="username">
                        </div>
                        <div class="col-lg-12">
                            <div class="row gx-3">
                                <div class="form-group col-lg-4">
                                    <label for="firstname"><?php esc_html_e('First Name', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="firstname" value="<?php echo esc_attr( $firstname ); ?>" id="firstname">
                                </div>
                                <div class="form-group col-lg-4">
                                    <label for="lastname"><?php esc_html_e('Last Name', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="lastname" value="<?php echo esc_attr( $lastname ); ?>" id="lastname">
                                </div>
                                <div class="form-group col-lg-4">
                                    <label for="email"><?php esc_html_e('Email', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="email" value="<?php echo esc_attr( $email ); ?>" id="email">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="row gx-3">
                                <div class="form-group col-lg-4">
                                    <label for="position"><?php esc_html_e('Designation', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="position" value="<?php echo esc_attr( $position ); ?>" id="position">
                                </div>
                                <div class="form-group col-lg-4">
                                    <label for="license"><?php esc_html_e('License', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="license" value="<?php echo esc_attr( $license ); ?>" id="license">
                                </div>
                                <div class="form-group col-lg-4">
                                    <label for="taxnumber"><?php esc_html_e('Tax Number', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="taxnumber" value="<?php echo esc_attr( $taxnumber ); ?>" id="taxnumber">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="row gx-3">
                                <div class="form-group col-lg-4">
                                    <label for="phone"><?php esc_html_e('Office Phone', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="phone" value="<?php echo esc_attr( $phone ); ?>" id="phone">
                                </div>
                                <div class="form-group col-lg-4">
                                    <label for="fax"><?php esc_html_e('Fax Number', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="fax" value="<?php echo $fax; ?>" id="fax">
                                </div>
                                <div class="form-group col-lg-4">
                                    <label for="mobile"><?php esc_html_e('Mobile', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="mobile" value="<?php echo $mobile; ?>" id="mobile">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <label for="about"><?php esc_html_e('About Me', 'luxus-core'); ?></label>
                            <textarea class="form-control" name="about" id="about" rows="7"><?php echo esc_html($about); ?></textarea>
                        </div>

                        <?php

                        if ( $current_user->roles['0'] == 'agency' ) : ?>

                        <div class="col-lg-12 agency-agents-col">

                            <?php

                            $agency_agents_meta = get_post_meta( $cpt_post_id, '_user_agents', true );

                            $args = array(
                                'post_type'=>'agent',
                                'posts_per_page' => -1,
                            );
                            $agency_agents = get_posts( $args );

                            ?>

                            <label for="agents"><?php esc_html_e('Our Agents', 'luxus-core'); ?></label>
                            <select name="agency_agents[]" class="agency-agents form-control"  id="agents" multiple="multiple">
                                <?php
                                    if( $agency_agents != NULL ):
                                        foreach($agency_agents as $agency_agent) { ?>
                                    <option <?php echo esc_attr( !empty( $agency_agents_meta ) && in_array( $agency_agent->ID, $agency_agents_meta ) ? ' selected="selected"' : '' ) ?> value="<?php echo esc_attr($agency_agent->ID); ?>">
                                        <?php echo esc_html($agency_agent->ID) . ' - ' .  esc_html($agency_agent->post_title);?>
                                    </option>
                                    <?php } else: ?>
                                    <option value="none"><?php esc_html_e('None', 'luxus-core'); ?></option>
                                <?php endif; ?>
                            </select>
                        </div>

                        <?php endif; ?>

                        <div class="col-md-12">
                            <h6 class="heading"><?php esc_html_e('Social Accounts', 'luxus-core'); ?></h6>
                        </div>
                        <div class="col-lg-12">
                            <div class="row gx-3">
                                <div class="form-group col-lg-12">
                                    <label for="website"><?php esc_html_e('Website', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="website" value="<?php echo esc_attr( $website ); ?>" id="website">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="facebook"><?php esc_html_e('Facebook', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="facebook" value="<?php echo esc_attr( $facebook ); ?>" id="facebook">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="twitter"><?php esc_html_e('Twitter', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="twitter" value="<?php echo esc_attr($twitter); ?>" id="twitter">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="linkedin"><?php esc_html_e('Linkedin', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="linkedin" value="<?php echo esc_attr($linkedin); ?>" id="linkedin">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="instagram"><?php esc_html_e('Instagram', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="instagram" value="<?php echo esc_attr($instagram); ?>" id="instagram">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="pinterest"><?php esc_html_e('Pinterest', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="pinterest" value="<?php echo esc_attr($pinterest); ?>" id="pinterest">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="vk"><?php esc_html_e('VK', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="vk" value="<?php echo esc_attr($vk); ?>" id="vk">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="youtube"><?php esc_html_e('Youtube', 'luxus-core'); ?></label>
                                    <input type="youtube" class="form-control" name="youtube" value="<?php echo esc_attr($youtube); ?>" id="youtube">
                                </div>
                                <div class="form-group col-lg-6">
                                    <label for="vimeo"><?php esc_html_e('Vimeo', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="vimeo" value="<?php echo esc_attr($vimeo); ?>" id="vimeo">
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <h6 class="heading"><?php esc_html_e('User Address', 'luxus-core'); ?></h6>
                        </div>
                        <div class="col-lg-12">
                            <div class="row gx-3">
                                <div class="col-lg-4">
                                    <?php

                                    //User City Taxonomy
                                    $user_cities = get_terms( array( 'taxonomy' => $cities, 'hide_empty' => false ) );
                                    $user_city = get_the_author_meta( 'city', $user->ID );

                                    ?>
                                    <label for="city">City</label>
                                    <div class="sl-select">
                                        <select name="city" class="form-control"  id="city">
                                            <option value=" "><?php esc_html_e('Select City', 'luxus-core'); ?></option>
                                            <?php
                                                if( $user_cities != NULL ):
                                                    foreach($user_cities as $city) { ?>
                                                <option <?php echo esc_attr( $user_city == $city->term_id ? 'selected' : '' ); ?> value="<?php echo esc_attr($city->term_id); ?>"><?php echo esc_html($city->name); ?></option>
                                                <?php } else: ?>
                                                <option value="none"><?php esc_html_e('None', 'luxus-core'); ?></option>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <label for="state"><?php esc_html_e('State / Province', 'luxus-core'); ?></label>
                                    <?php

                                    //User Province Taxonomy
                                    $user_states = get_terms( array( 'taxonomy' => $provinces, 'hide_empty' => false ) );

                                    $user_state = get_the_author_meta( 'state', $user->ID );

                                    ?>
                                    <div class="sl-select">
                                        <select name="state" class="form-control"  id="state">
                                            <option value=" "><?php esc_html_e('Select State/Province', 'luxus-core'); ?></option>
                                            <?php
                                                if( $user_states != NULL ):
                                                    foreach($user_states as $state) { ?>
                                                <option <?php echo esc_attr( $user_state == $state->term_id ? 'selected' : '' ); ?> value="<?php echo esc_attr($state->term_id); ?>"><?php echo esc_html($state->name); ?></option>
                                                <?php } else: ?>
                                                <option value="none"><?php esc_html_e('None', 'luxus-core'); ?></option>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <label for="zip"><?php esc_html_e('Zip / Postal Code', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="zip" value="<?php echo esc_attr($zip); ?>" id="zip">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="row gx-3">
                                <div class="col-lg-6">
                                    <label for="address"><?php esc_html_e('Street Address', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="address" value="<?php echo esc_attr($address); ?>" id="address">
                                </div>
                                <div class="col-lg-6">
                                    <?php

                                    //User Country Taxonomy
                                    $user_countries = get_terms( array( 'taxonomy' => $countries, 'hide_empty' => false ) );

                                    $user_country = get_the_author_meta( 'country', $user->ID );

                                    ?>
                                    <label for="country"><?php esc_html_e('Country', 'luxus-core'); ?></label>
                                    <div class="sl-select">
                                        <select name="country" class="form-control"  id="country">
                                            <option value=" "><?php esc_html_e('Select Country', 'luxus-core'); ?></option>
                                            <?php
                                                if( $user_countries != NULL ):
                                                    foreach($user_countries as $country) { ?>
                                                <option <?php echo esc_attr( $user_country == $country->term_id ? 'selected' : '' ); ?> value="<?php echo esc_attr($country->term_id); ?>"><?php echo esc_html($country->name); ?></option>
                                                <?php } else: ?>
                                                <option value="none"><?php esc_html_e('None', 'luxus-core'); ?></option>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <label for="map"><?php esc_html_e('Map', 'luxus-core'); ?></label>
                            <div id="map"></div>
                            <input type="hidden" name="user_map[address]" id="st_address" value="<?php echo esc_attr($map_address); ?>" /> 
                            <input type="hidden" name="user_map[latitude]" id="lat" value="<?php echo esc_attr($map_latitude); ?>" /> 
                            <input type="hidden" name="user_map[longitude]" id="lng" value="<?php echo esc_attr($map_longitude); ?>" />
                            <input type="hidden" name="user_map[zoom]" id="zoom" value="<?php echo esc_attr($map_zoom); ?>" />
                        </div>

                        <div class="col-lg-12">
                            <button id="update-user" type="submit" class="sl-btn-fill"><?php esc_html_e('Update Settings', 'luxus-core'); ?></button>
                            <?php wp_nonce_field( 'update-user' ) ?>
                            <input name="action" type="hidden" id="action" value="update-user" />
                        </div>
                    </div>
                </form>
            </div>

            <!-- Change / Reset Password -->
            <div class="col-lg-12">
                <form class="change-password-form" method="post" action="<?php esc_url(get_bloginfo('url').'/my-profile/') ?>" enctype="multipart/form-data">
                    <div class="sl-box">
                        <div class="col-lg-12">
                            <h6 class="heading"><?php esc_html_e('Change Password', 'luxus-core'); ?></h6>
                            <input type="hidden" name="action" value="plp_general_details" />
                        </div>
                        <div class="col-lg-12">
                            <div class="row gx-3">
                                <div class="form-group col-lg-4">
                                    <label for="current_password"><?php esc_html_e('Current Password', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="current_password" value="<?php echo esc_attr(isset( $_POST['current_password']) ? $current_password : null); ?>" id="current_password">
                                </div>
                                <div class="form-group col-lg-4">
                                    <label for="new_password"><?php esc_html_e('New Password', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="new_password" value="<?php echo esc_attr(isset( $_POST['new_password']) ? $new_password : null); ?>" id="new_password">
                                </div>
                                <div class="form-group col-lg-4">
                                    <label for="confirm_new_password"><?php esc_html_e('Confirm New Password', 'luxus-core'); ?></label>
                                    <input type="text" class="form-control" name="confirm_new_password" value="<?php echo esc_attr(isset( $_POST['confirm_new_password']) ? $confirm_new_password : null); ?>" id="confirm_new_password">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <button id="update-password" type="submit" class="sl-btn-outline"><?php esc_html_e('Change Password', 'luxus-core'); ?></button>

                            <?php wp_nonce_field( 'change-password' ) ?>
                            
                            <input name="action" type="hidden" id="action" value="change-password" />
                        </div>
                        
                        <!-- Print Change Password Errors -->
                        <?php

                            if ( !empty($password_error) ){

                                // Echo Errors
                                echo '<div class="col-lg-12 profile-errors">';
                                echo '<h5>'. esc_html_e('Errors:', 'luxus-core').'</h5>';
                                foreach($password_error as $error){

                                    echo '<p>';
                                    echo "<strong>". $error ."</strong>";
                                    echo '</p>';

                                }
                                echo '</div>';

                            }
                       ?>

                    </div>
                </form>
            </div>

            <!-- Change / Reset Password -->
        </div>
        <div class="row"></div>
    </div>
</div>
<!-- Main Content End -->

<?php

// getting Values From Meta
$latitude = isset( $user_map_meta['latitude'] ) ? $user_map_meta['latitude'] : 0;
$longtitude = isset( $user_map_meta['longitude'] ) ? $user_map_meta['longitude'] : 0;

// Agent Map Script
wp_register_script( 'luxus-my-profile', '', array("jquery"), '', true );
wp_enqueue_script( 'luxus-my-profile'  );

wp_add_inline_script( 'luxus-my-profile', "
    jQuery( document ).ready( function( $ ) {
        // Lat Long
        var markerLocation = [{$latitude}, {$longtitude}];
        // Zoom Level
        var mapZoom = 6;

        // Default Marker Position
        if (markerLocation[0] == 0 && markerLocation[1] == 0) {
            markerLocation = [30.0497935, 60.3349021];
        }

        var map = L.map('map', {
            center: markerLocation,
            zoom: mapZoom,
        });

        L.tileLayer('https://{s}.tile.osm.org/{z}/{x}/{y}.png', {
            attribution: '&copy; <a href=\"https://osm.org/copyright\">OpenStreetMap</a> contributors'
        }).addTo(map);

        map.attributionControl.setPrefix(false);

        // create custom icon
        var mapMarker = L.icon({
            iconUrl: '{$map_marker}',
            iconSize: [40, 48], // size of the icon
        });

        var marker = new L.marker(markerLocation, {
            icon: mapMarker,
            draggable: 'true'
        });

        function addValueToTextBox(lt,ln){
            document.getElementById('lat').value = lt;
            document.getElementById('lng').value = ln;
        }

        document.getElementById('zoom').value = mapZoom;

        marker.on('dragend', function(event){
            var marker = event.target;
            var location = marker.getLatLng();
            var lat = location.lat;
            var lon = location.lng;
            addValueToTextBox(lat,lon);
        });

        marker.addTo(map);
    });
");


// Custom User Footer
require dirname( __FILE__ ) . '/template-parts/footer-user.php';
