<?php if ( ! defined( 'ABSPATH' )  ) { die; } // Cannot access directly.

/**
 * The template for displaying all archive posts of 'agency post type'
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package luxus
 */

get_header();

// Get options
$sidebar_position = luxus_options('agencies-sidebar-position');
$is_active_sidebar = ( is_active_sidebar( 'agencies-page-widget' ) ? true : false );
$active_col = ( $is_active_sidebar == true ? '8' : '12' );

?>

<div class="agency-page-header">
	<div class="container">
		<?php the_archive_title( '<h1 class="agency-page-title">', '</h1>' ); ?>
	</div>
</div><!-- .page-header -->

<!-- Main Content -->
<div class="page-content">
    <div class="container">
        <div class="row">
            <div class="col-lg-<?php echo esc_attr($active_col); ?>">
                <div class="row">
                    <?php

                    $post_style = luxus_options('agencies-post-style');
                    $show_social_icons = luxus_options('agency-enable-social-icons');
                        
                    if ( have_posts() ) :
                        /* Start the Loop */
                        while ( have_posts() ) :
                            the_post();
                            
                            // Agency Template Parts
                            require dirname( __FILE__ ) . '/template-parts/agency-' .$post_style. '.php';

                        endwhile;

                                // Custom Pagination
                                echo '<div class="col-lg-12">';
                                luxus_pagination();
                                echo '</div>';

                        else :
                    ?>

                    <div class="col-xl-12">
                        <div class="not-found-result">
                            <img src="<?php echo esc_url(get_template_directory_uri())?>/assets/images/not-found.png">
                            <h6><?php esc_html_e( 'Sorry, No Agencies Found.', 'luxus-core' ); ?></h6>
                        </div>
                    </div>

                    <?php 

                    endif;
                        wp_reset_postdata();
                    ?>
                </div>
            </div>

            <?php if( $is_active_sidebar == true ) : ?>
            <!-- This Class order-xl-first is for float sidebar left -->
            <div class="col-lg-4 sl-sticky <?php echo esc_attr( $sidebar_position == 'left-sidebar' ? 'order-lg-first' : '' ); ?>">
                <aside id="secondary" class="widget-area">
                    <?php dynamic_sidebar( 'agencies-page-widget' ); ?>
                </aside><!-- #secondary -->
            </div>
            <?php endif; ?>

        </div>
    </div>
</div>
<!-- Main Content End -->

<?php
get_footer();
