<?php if ( ! defined( 'ABSPATH' )  ) { die; } // Cannot access directly.

// Register Custom Taxonomy 'Property Types'
add_action( 'init', 'luxus_property_types', 0 );
function luxus_property_types() {
	$labels = array(
		'name'                       => _x( 'Property Types', 'Taxonomy General Name', 'luxus-core' ),
		'singular_name'              => _x( 'Property Type', 'Taxonomy Singular Name', 'luxus-core' ),
		'menu_name'                  => __( 'Property Types', 'luxus-core' ),
		'all_items'                  => __( 'All Types', 'luxus-core' ),
		'parent_item'                => __( 'Parent Type', 'luxus-core' ),
		'parent_item_colon'          => __( 'Parent Type:', 'luxus-core' ),
		'new_item_name'              => __( 'New Type Name', 'luxus-core' ),
		'add_new_item'               => __( 'Add New Type', 'luxus-core' ),
		'edit_item'                  => __( 'Edit Type', 'luxus-core' ),
		'update_item'                => __( 'Update Type', 'luxus-core' ),
		'view_item'                  => __( 'View Type', 'luxus-core' ),
		'separate_items_with_commas' => __( 'Separate items with commas', 'luxus-core' ),
		'add_or_remove_items'        => __( 'Add or remove Types', 'luxus-core' ),
		'choose_from_most_used'      => __( 'Choose from the most used', 'luxus-core' ),
		'popular_items'              => __( 'Popular Types', 'luxus-core' ),
		'search_items'               => __( 'Search Types', 'luxus-core' ),
		'not_found'                  => __( 'Not Found', 'luxus-core' ),
		'no_terms'                   => __( 'No items', 'luxus-core' ),
		'items_list'                 => __( 'Types list', 'luxus-core' ),
		'items_list_navigation'      => __( 'Types list navigation', 'luxus-core' ),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
		'show_in_rest'               => true,
		'show_in_quick_edit'         => false,
    	'meta_box_cb'                => false,
	);
	register_taxonomy( 'property_type', array( 'property' ), $args );
}

// Register Custom Taxonomy 'Property Features'
add_action( 'init', 'luxus_property_features', 0 );
function luxus_property_features() {
	$labels = array(
		'name'                       => _x( 'Property Features', 'Taxonomy General Name', 'luxus-core' ),
		'singular_name'              => _x( 'Property Feature', 'Taxonomy Singular Name', 'luxus-core' ),
		'menu_name'                  => __( 'Property Features', 'luxus-core' ),
		'all_items'                  => __( 'All Features', 'luxus-core' ),
		'parent_item'                => __( 'Parent Feature', 'luxus-core' ),
		'parent_item_colon'          => __( 'Parent Feature:', 'luxus-core' ),
		'new_item_name'              => __( 'New Feature Name', 'luxus-core' ),
		'add_new_item'               => __( 'Add New Feature', 'luxus-core' ),
		'edit_item'                  => __( 'Edit Feature', 'luxus-core' ),
		'update_item'                => __( 'Update Feature', 'luxus-core' ),
		'view_item'                  => __( 'View Feature', 'luxus-core' ),
		'separate_items_with_commas' => __( 'Separate items with commas', 'luxus-core' ),
		'add_or_remove_items'        => __( 'Add or remove Features', 'luxus-core' ),
		'choose_from_most_used'      => __( 'Choose from the most used', 'luxus-core' ),
		'popular_items'              => __( 'Popular Features', 'luxus-core' ),
		'search_items'               => __( 'Search Features', 'luxus-core' ),
		'not_found'                  => __( 'Not Found', 'luxus-core' ),
		'no_terms'                   => __( 'No items', 'luxus-core' ),
		'items_list'                 => __( 'Features list', 'luxus-core' ),
		'items_list_navigation'      => __( 'Features list navigation', 'luxus-core' ),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => false,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
		'show_in_rest'               => true,
	);
	register_taxonomy( 'property_feature', array( 'property' ), $args );
}

// Register Custom Taxonomy 'Property Status'
add_action( 'init', 'luxus_property_status', 0 );
function luxus_property_status() {
	$labels = array(
		'name'                       => _x( 'Property Status', 'Taxonomy General Name', 'luxus-core' ),
		'singular_name'              => _x( 'Property Status', 'Taxonomy Singular Name', 'luxus-core' ),
		'menu_name'                  => __( 'Property Status', 'luxus-core' ),
		'all_items'                  => __( 'All Status', 'luxus-core' ),
		'parent_item'                => __( 'Parent Status', 'luxus-core' ),
		'parent_item_colon'          => __( 'Parent Status:', 'luxus-core' ),
		'new_item_name'              => __( 'New Status Name', 'luxus-core' ),
		'add_new_item'               => __( 'Add New Status', 'luxus-core' ),
		'edit_item'                  => __( 'Edit Status', 'luxus-core' ),
		'update_item'                => __( 'Update Status', 'luxus-core' ),
		'view_item'                  => __( 'View Status', 'luxus-core' ),
		'separate_items_with_commas' => __( 'Separate items with commas', 'luxus-core' ),
		'add_or_remove_items'        => __( 'Add or remove Status', 'luxus-core' ),
		'choose_from_most_used'      => __( 'Choose from the most used', 'luxus-core' ),
		'popular_items'              => __( 'Popular Status', 'luxus-core' ),
		'search_items'               => __( 'Search Status', 'luxus-core' ),
		'not_found'                  => __( 'Not Found', 'luxus-core' ),
		'no_terms'                   => __( 'No items', 'luxus-core' ),
		'items_list'                 => __( 'Status list', 'luxus-core' ),
		'items_list_navigation'      => __( 'Status list navigation', 'luxus-core' ),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
		'show_in_rest'               => true,
		'show_in_quick_edit'         => false,
    	'meta_box_cb'                => false,
	);
	register_taxonomy( 'property_status', array( 'property' ), $args );
}

// Register Custom Taxonomy 'Property Cities'
add_action( 'init', 'luxus_property_cities', 0 );
function luxus_property_cities() {
	$labels = array(
		'name'                       => _x( 'Property Cities', 'Taxonomy General Name', 'luxus-core' ),
		'singular_name'              => _x( 'Property City', 'Taxonomy Singular Name', 'luxus-core' ),
		'menu_name'                  => __( 'Property Cities', 'luxus-core' ),
		'all_items'                  => __( 'All Cities', 'luxus-core' ),
		'parent_item'                => __( 'Parent City', 'luxus-core' ),
		'parent_item_colon'          => __( 'Parent City:', 'luxus-core' ),
		'new_item_name'              => __( 'New City Name', 'luxus-core' ),
		'add_new_item'               => __( 'Add New City', 'luxus-core' ),
		'edit_item'                  => __( 'Edit City', 'luxus-core' ),
		'update_item'                => __( 'Update City', 'luxus-core' ),
		'view_item'                  => __( 'View City', 'luxus-core' ),
		'separate_items_with_commas' => __( 'Separate items with commas', 'luxus-core' ),
		'add_or_remove_items'        => __( 'Add or remove Cities', 'luxus-core' ),
		'choose_from_most_used'      => __( 'Choose from the most used', 'luxus-core' ),
		'popular_items'              => __( 'Popular Cities', 'luxus-core' ),
		'search_items'               => __( 'Search Cities', 'luxus-core' ),
		'not_found'                  => __( 'Not Found', 'luxus-core' ),
		'no_terms'                   => __( 'No items', 'luxus-core' ),
		'items_list'                 => __( 'Cities list', 'luxus-core' ),
		'items_list_navigation'      => __( 'Cities list navigation', 'luxus-core' ),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => false,
		'show_in_rest'               => true,
		'show_in_quick_edit'         => false,
    	'meta_box_cb'                => false,
		
	);
	register_taxonomy( 'property_city', array( 'property' ), $args );
}

// Register Custom Taxonomy 'Property Provinces'
add_action( 'init', 'luxus_property_provinces', 0 );
function luxus_property_provinces() {
	$labels = array(
		'name'                       => _x( 'Property Provinces', 'Taxonomy General Name', 'luxus-core' ),
		'singular_name'              => _x( 'Property Province', 'Taxonomy Singular Name', 'luxus-core' ),
		'menu_name'                  => __( 'Property Provinces', 'luxus-core' ),
		'all_items'                  => __( 'All Provinces', 'luxus-core' ),
		'parent_item'                => __( 'Parent Province', 'luxus-core' ),
		'parent_item_colon'          => __( 'Parent Province:', 'luxus-core' ),
		'new_item_name'              => __( 'New Province Name', 'luxus-core' ),
		'add_new_item'               => __( 'Add New Province', 'luxus-core' ),
		'edit_item'                  => __( 'Edit Province', 'luxus-core' ),
		'update_item'                => __( 'Update Province', 'luxus-core' ),
		'view_item'                  => __( 'View Province', 'luxus-core' ),
		'separate_items_with_commas' => __( 'Separate items with commas', 'luxus-core' ),
		'add_or_remove_items'        => __( 'Add or remove Provinces', 'luxus-core' ),
		'choose_from_most_used'      => __( 'Choose from the most used', 'luxus-core' ),
		'popular_items'              => __( 'Popular Provinces', 'luxus-core' ),
		'search_items'               => __( 'Search Provinces', 'luxus-core' ),
		'not_found'                  => __( 'Not Found', 'luxus-core' ),
		'no_terms'                   => __( 'No items', 'luxus-core' ),
		'items_list'                 => __( 'Provinces list', 'luxus-core' ),
		'items_list_navigation'      => __( 'Provinces list navigation', 'luxus-core' ),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => false,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
		'show_in_rest'               => true,
		'show_in_quick_edit'         => false,
    	'meta_box_cb'                => false,
	);
	register_taxonomy( 'property_province', array( 'property' ), $args );
}

// Register Custom Taxonomy 'Property Countries'
add_action( 'init', 'luxus_property_country', 0 );
function luxus_property_country() {
	$labels = array(
		'name'                       => _x( 'Property Countries', 'Taxonomy General Name', 'luxus-core' ),
		'singular_name'              => _x( 'Property Country', 'Taxonomy Singular Name', 'luxus-core' ),
		'menu_name'                  => __( 'Property Countries', 'luxus-core' ),
		'all_items'                  => __( 'All Countries', 'luxus-core' ),
		'parent_item'                => __( 'Parent Country', 'luxus-core' ),
		'parent_item_colon'          => __( 'Parent Country:', 'luxus-core' ),
		'new_item_name'              => __( 'New Country Name', 'luxus-core' ),
		'add_new_item'               => __( 'Add New Country', 'luxus-core' ),
		'edit_item'                  => __( 'Edit Country', 'luxus-core' ),
		'update_item'                => __( 'Update Country', 'luxus-core' ),
		'view_item'                  => __( 'View Country', 'luxus-core' ),
		'separate_items_with_commas' => __( 'Separate items with commas', 'luxus-core' ),
		'add_or_remove_items'        => __( 'Add or remove Countries', 'luxus-core' ),
		'choose_from_most_used'      => __( 'Choose from the most used', 'luxus-core' ),
		'popular_items'              => __( 'Popular Countries', 'luxus-core' ),
		'search_items'               => __( 'Search Countries', 'luxus-core' ),
		'not_found'                  => __( 'Not Found', 'luxus-core' ),
		'no_terms'                   => __( 'No items', 'luxus-core' ),
		'items_list'                 => __( 'Countries list', 'luxus-core' ),
		'items_list_navigation'      => __( 'Countries list navigation', 'luxus-core' ),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => false,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
		'show_in_rest'               => true,
		'show_in_quick_edit'         => false,
    	'meta_box_cb'                => false,
	);
	register_taxonomy( 'property_country', array( 'property' ), $args );
}
