<?php if ( ! defined( 'ABSPATH' )  ) { die; } // Cannot access directly.

// Register Custom Taxonomy 'Agency Cities'
add_action( 'init', 'luxus_agency_cities', 0 );
function luxus_agency_cities() {
	$labels = array(
		'name'                       => _x( 'Agency Cities', 'Taxonomy General Name', 'luxus-core' ),
		'singular_name'              => _x( 'Agency City', 'Taxonomy Singular Name', 'luxus-core' ),
		'menu_name'                  => __( 'Agency Cities', 'luxus-core' ),
		'all_items'                  => __( 'All Cities', 'luxus-core' ),
		'parent_item'                => __( 'Parent City', 'luxus-core' ),
		'parent_item_colon'          => __( 'Parent City:', 'luxus-core' ),
		'new_item_name'              => __( 'New City Name', 'luxus-core' ),
		'add_new_item'               => __( 'Add New City', 'luxus-core' ),
		'edit_item'                  => __( 'Edit City', 'luxus-core' ),
		'update_item'                => __( 'Update City', 'luxus-core' ),
		'view_item'                  => __( 'View City', 'luxus-core' ),
		'separate_items_with_commas' => __( 'Separate items with commas', 'luxus-core' ),
		'add_or_remove_items'        => __( 'Add or remove Cities', 'luxus-core' ),
		'choose_from_most_used'      => __( 'Choose from the most used', 'luxus-core' ),
		'popular_items'              => __( 'Popular Cities', 'luxus-core' ),
		'search_items'               => __( 'Search Cities', 'luxus-core' ),
		'not_found'                  => __( 'Not Found', 'luxus-core' ),
		'no_terms'                   => __( 'No items', 'luxus-core' ),
		'items_list'                 => __( 'Cities list', 'luxus-core' ),
		'items_list_navigation'      => __( 'Cities list navigation', 'luxus-core' ),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => false,
		'show_in_rest'               => true,
		'show_in_quick_edit'         => false,
    	'meta_box_cb'                => false,
		
	);
	register_taxonomy( 'agency_city', array( 'agency' ), $args );
}

// Register Custom Taxonomy 'Agency Provinces'
add_action( 'init', 'luxus_agency_provinces', 0 );
function luxus_agency_provinces() {
	$labels = array(
		'name'                       => _x( 'Agency Provinces', 'Taxonomy General Name', 'luxus-core' ),
		'singular_name'              => _x( 'Agency Province', 'Taxonomy Singular Name', 'luxus-core' ),
		'menu_name'                  => __( 'Agency Provinces', 'luxus-core' ),
		'all_items'                  => __( 'All Provinces', 'luxus-core' ),
		'parent_item'                => __( 'Parent Province', 'luxus-core' ),
		'parent_item_colon'          => __( 'Parent Province:', 'luxus-core' ),
		'new_item_name'              => __( 'New Province Name', 'luxus-core' ),
		'add_new_item'               => __( 'Add New Province', 'luxus-core' ),
		'edit_item'                  => __( 'Edit Province', 'luxus-core' ),
		'update_item'                => __( 'Update Province', 'luxus-core' ),
		'view_item'                  => __( 'View Province', 'luxus-core' ),
		'separate_items_with_commas' => __( 'Separate items with commas', 'luxus-core' ),
		'add_or_remove_items'        => __( 'Add or remove Provinces', 'luxus-core' ),
		'choose_from_most_used'      => __( 'Choose from the most used', 'luxus-core' ),
		'popular_items'              => __( 'Popular Provinces', 'luxus-core' ),
		'search_items'               => __( 'Search Provinces', 'luxus-core' ),
		'not_found'                  => __( 'Not Found', 'luxus-core' ),
		'no_terms'                   => __( 'No items', 'luxus-core' ),
		'items_list'                 => __( 'Provinces list', 'luxus-core' ),
		'items_list_navigation'      => __( 'Provinces list navigation', 'luxus-core' ),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => false,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
		'show_in_rest'               => true,
		'show_in_quick_edit'         => false,
    	'meta_box_cb'                => false,
	);
	register_taxonomy( 'agency_province', array( 'agency' ), $args );
}

// Register Custom Taxonomy 'Agency Countries'
add_action( 'init', 'luxus_agency_country', 0 );
function luxus_agency_country() {
	$labels = array(
		'name'                       => _x( 'Agency Countries', 'Taxonomy General Name', 'luxus-core' ),
		'singular_name'              => _x( 'Agency Country', 'Taxonomy Singular Name', 'luxus-core' ),
		'menu_name'                  => __( 'Agency Countries', 'luxus-core' ),
		'all_items'                  => __( 'All Countries', 'luxus-core' ),
		'parent_item'                => __( 'Parent Country', 'luxus-core' ),
		'parent_item_colon'          => __( 'Parent Country:', 'luxus-core' ),
		'new_item_name'              => __( 'New Country Name', 'luxus-core' ),
		'add_new_item'               => __( 'Add New Country', 'luxus-core' ),
		'edit_item'                  => __( 'Edit Country', 'luxus-core' ),
		'update_item'                => __( 'Update Country', 'luxus-core' ),
		'view_item'                  => __( 'View Country', 'luxus-core' ),
		'separate_items_with_commas' => __( 'Separate items with commas', 'luxus-core' ),
		'add_or_remove_items'        => __( 'Add or remove Countries', 'luxus-core' ),
		'choose_from_most_used'      => __( 'Choose from the most used', 'luxus-core' ),
		'popular_items'              => __( 'Popular Countries', 'luxus-core' ),
		'search_items'               => __( 'Search Countries', 'luxus-core' ),
		'not_found'                  => __( 'Not Found', 'luxus-core' ),
		'no_terms'                   => __( 'No items', 'luxus-core' ),
		'items_list'                 => __( 'Countries list', 'luxus-core' ),
		'items_list_navigation'      => __( 'Countries list navigation', 'luxus-core' ),
	);
	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => false,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
		'show_in_rest'               => true,
		'show_in_quick_edit'         => false,
    	'meta_box_cb'                => false,
	);
	register_taxonomy( 'agency_country', array( 'agency' ), $args );
}
